#!/bin/sh

# **************************************************
# ** Libraries used by Kettle:                    **
# **************************************************
# MB Aufruf Beispiel sx_kitchen.x -file "sospos_res1.kjb" -norep


BASEDIR=`dirname $0`
cd $BASEDIR
DIR=`pwd`
cd - > /dev/null

# MB nicht benötigt . "$DIR/set-pentaho-env.sh"

# MB nicht benötigt setPentahoEnv

#CLASSPATH=$BASEDIR
#CLASSPATH=$CLASSPATH:$BASEDIR/lib/kettle-core.jar
#CLASSPATH=$CLASSPATH:$BASEDIR/lib/kettle-db.jar
#CLASSPATH=$CLASSPATH:$BASEDIR/lib/kettle-engine.jar
#echo $CLASSPATH

# **************************************************
# ** JDBC & other libraries used by Kettle:       **
# **************************************************

#for f in `find $BASEDIR/libext -type f -name "*.jar"` `find $BASEDIR/libext -type f -name "*.zip"`
#do
#  CLASSPATH=$CLASSPATH:$f
#done


# **************************************************
# ** Platform specific libraries ...              **
# **************************************************

# circumvention for the IBM JVM behavior (seems to be a problem with the IBM JVM native compiler)
if [ `uname -s` = "OS400" ]
then
  CLASSPATH=${CLASSPATH}:$BASEDIR/libswt/aix/swt.jar
fi


# ******************************************************************
# ** Set java runtime options                                     **
# ** Change 512m to higher values in case you run out of memory   **
# ** or set the PENTAHO_DI_JAVA_OPTIONS environment variable      **
# ** (JAVAMAXMEM is there for compatibility reasons)              **
# ******************************************************************

if [ -z "$JAVAMAXMEM" ]; then
  JAVAMAXMEM="512"
fi

if [ -z "$PENTAHO_DI_JAVA_OPTIONS" ]; then
    PENTAHO_DI_JAVA_OPTIONS="-Xmx${JAVAMAXMEM}m"
fi

#OPT="$PENTAHO_DI_JAVA_OPTIONS -cp $JDBC_CLASSPATH -DKETTLE_HOME=$KETTLE_HOME -DKETTLE_REPOSITORY=$KETTLE_REPOSITORY -DKETTLE_USER=$KETTLE_USER -DKETTLE_PASSWORD=$KETTLE_PASSWORD -DKETTLE_PLUGIN_PACKAGES=$KETTLE_PLUGIN_PACKAGES -DKETTLE_LOG_SIZE_LIMIT=$KETTLE_LOG_SIZE_LIMIT"

OPT="$PENTAHO_DI_JAVA_OPTIONS -cp $JDBC_CLASSPATH -DKETTLE_HOME=$KETTLE_HOME -DKETTLE_REPOSITORY=$KETTLE_REPOSITORY -DKETTLE_USER=$KETTLE_USER -DKETTLE_PASSWORD=$KETTLE_PASSWORD -DKETTLE_PLUGIN_PACKAGES=$KETTLE_PLUGIN_PACKAGES -DKETTLE_LOG_SIZE_LIMIT=$KETTLE_LOG_SIZE_LIMIT -DBI_KETTLE_PLUGIN_BASE_FOLDERS=$BI_KETTLE_PLUGIN_BASE_FOLDERS -DKETTLE_PLUGIN_BASE_FOLDERS=$KETTLE_PLUGIN_BASE_FOLDERS --add-opens java.naming/com.sun.jndi.ldap=ALL-UNNAMED --add-opens java.base/sun.nio.ch=ALL-UNNAMED --add-opens java.base/sun.net.www.protocol.jar=ALL-UNNAMED --add-opens java.base/javax.crypto=ALL-UNNAMED --add-opens java.base/java.util.stream=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.net=ALL-UNNAMED --add-opens java.base/java.io=ALL-UNNAMED --add-opens java.base/java.lang=ALL-UNNAMED --add-opens=java.base/java.math=ALL-UNNAMED"


if [ "$1" = "-x" ]; then
  set LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$BASEDIR/libext
  export LD_LIBRARY_PATH
  OPT="-Xruntracer $OPT"
  shift
fi

# ***************
# ** Run...    **
# ***************

"$JAVA_HOME/bin/java" $OPT org.pentaho.di.kitchen.Kitchen "${1+$@}"


