<?xml version="1.0"  encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:sx="http://memtext.de"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="pageComponents_html.xsl" />
<!--In diesem Stylesheet knnen Sie individuelle templates unterbringen,
  die in ihrer Przedenz das normale Stylesheet 
  pageComponents_html.xsl berragt. --> 
  <xsl:import href="pageComponents_html_final.xsl" />
<xsl:import href="resultset_html.xsl" />
<xsl:import href="interLinks_html.xsl" />
<xsl:import href="xsl_functions.xsl" />
<xsl:decimal-format name="German" grouping-separator="." NaN="" zero-digit ="0" decimal-separator="," />

                                                      <!-- wichtig fr DOJO!-->
<xsl:output method="xml"    media-type="text/html" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
   doctype-system="DTD/xhtml1-strict.dtd"    cdata-section-elements="script style"    indent="yes" encoding="ISO-8859-1"/>

<xsl:template match="/">
<xsl:call-template name="table"/>
</xsl:template>

<!-- start table main-->
<xsl:template name="table">
<html>
<xsl:call-template name="head" ><xsl:with-param name="title" select="concat('Ergebnis ',/ergebnisse/ergebnis[ position()=1]/maskenname)" /></xsl:call-template> 
<xsl:call-template name="tableCSS"></xsl:call-template>
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_pre_javascript'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_pre_javascript'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tableJavascript"></xsl:call-template> 
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_post_javascript'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_post_javascript'"></xsl:with-param></xsl:call-template>

<!-- start Body-->
<body onload="document.getElementById('progressbar').style.display='none';tableonload();"> <!-- tableonload definiert in pageComponents.pccustomize position table_post_javascript -->
<div id="progressbar"  style="position:absolute; width:150px; height:150px; left:200px; top:200px; background:#AAAAAA">
 <p>&#160;<b>Laden...</b><br/><img src="/superx/images/progress_bar.gif"></img><br/></p></div>

<xsl:call-template name="topbar_table" /> <!-- momentan gar nix drin -->
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_pre_center'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_pre_center'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tableCenter"/>
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_post_center'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_post_center'"></xsl:with-param></xsl:call-template>

<xsl:call-template name="tableDialogs"></xsl:call-template>
<!--<div class="dontprint" id="dojoDebug"></div>-->
<xsl:call-template name="bottombar" />
</body>
<!-- end body -->
</html>
</xsl:template>
<!-- end main -->
<!-- start css -->
<xsl:template name="tableCSS">
		<style type="text/css">
.dojoDialog {background : #eee;	border : 1px solid #999;-moz-border-radius : 5px;padding : 4px;width:650;height:500px;overflow:scroll}
.treebutton {
      border:none;
      margin: 0 4px 0 0;
    }
 @media print{
.dontprint{display:none;}
}

}
</style>
</xsl:template>
<!-- end css -->

<!-- start Javascript-->
<xsl:template name="tableJavascript">
<script language="JavaScript" type="text/javascript">
    function getTid(){
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:text>tid=</xsl:text><xsl:value-of select="/ergebnisse/makro/@id" /><xsl:text>;
</xsl:text>
</xsl:when>
<xsl:otherwise> 
<xsl:text>tid=</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/maskenname/@id" /><xsl:text>;
</xsl:text>
</xsl:otherwise>
</xsl:choose>
return tid;
}
</script>
<!-- start normale Abfragen - nicht makros dojo/ggfs. Treetable-->
<xsl:if test="/ergebnisse/@isMakro!='true'"> 
 <script language="JavaScript" type="text/javascript">
 djConfig = { 
				bindEncoding: "ISO-8859-1",
				isDebug: false,
				debugAtAllCosts:false,
				debugContainerId:"dojoDebug"
			};
			</script>
<script language="JavaScript" type="text/javascript" src="/superx/xml/js/dojo/dojo.js"></script>
<script language="JavaScript" type="text/javascript" src="/superx/xml/js/memtext/sx_functions.js"></script> 

 <script language="JavaScript" type="text/javascript">
  dojo.require("dojo.widget.Dialog");
            dojo.require("dojo.widget.Button");
	    dojo.require("dojo.event.*");
	    dojo.require("dojo.dnd.*");
			dojo.require("dojo.io.*");
			dojo.require("dojo.widget.ContentPane");
			dojo.hostenv.writeIncludes();
			var configdlg;
			var spaltenliste,spaltentrash;

</script>
<!-- javascript array mit Feldern - bei Makros ist Feld-XML noch nicht drin-->
 <xsl:text disable-output-escaping="yes"><![CDATA[<script type="text/javascript">
       var felder = new Array();]]></xsl:text>
       <xsl:for-each select="/ergebnisse/ergebnis/felder/feld">
       <xsl:text>felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]= new Object();
       felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]["htmlname"]='</xsl:text><xsl:value-of select="@varname"/><xsl:text>';
       felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]["name"]='</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="@varname"/></xsl:with-param></xsl:call-template><xsl:text>';
   	felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]["cb_name"]='</xsl:text><xsl:call-template name="umlaut_urlencode"><xsl:with-param name="s1"><xsl:value-of select="@varname"/></xsl:with-param></xsl:call-template><xsl:text>';
	</xsl:text>
	<!-- in sql-variablen knnte auch " vorkommen als %22 codieren-->
	<xsl:variable name="quot">"</xsl:variable>
       <xsl:variable name="r"><xsl:value-of disable-output-escaping="yes" select="value"/></xsl:variable>
	<xsl:text>felder[</xsl:text><xsl:value-of select="position()" /><xsl:text>]["value"]="</xsl:text>
       <xsl:call-template name="search_replace">
	<xsl:with-param name="string" select="$r"/>
	<xsl:with-param name="search" select="$quot" />
	<xsl:with-param name="replace" select="'%22'" />
</xsl:call-template><xsl:text>";       
       </xsl:text>
      </xsl:for-each>
 <xsl:text disable-output-escaping="yes"><![CDATA[</script>]]></xsl:text>


<!-- start x fr Tabellenfixierung-->
        <script type='text/javascript' src='/superx/xml/js/x/x_core.js'></script>
      <script type='text/javascript' src='/superx/xml/js/x/lib/xaddeventlistener.js'></script>
      <script type='text/javascript' src='/superx/xml/js/x/lib/xtablefixed.js'></script>
 
     
  <!-- start xTableHeaderFixed -->
      <script type='text/javascript'>
var addBehavior = false, ss = '/superx/xml/js/x/xthf.css';

if (window.XMLHttpRequest) {
  addBehavior = true;
}
else {
  /*@cc_on
  @if (@_jscript_version == 5.6) // IE6
 if(navigator.appName=="Microsoft Internet Explorer" )
  ss = '/superx/xml/js/x/xthf_ie6.css';
  addBehavior = false;
  @end @*/
}
if (addBehavior) {
  var e = document.createElement('link');
  e.rel = 'stylesheet';
  e.type = 'text/css';
  e.href = ss;
  document.getElementsByTagName('head')[0].appendChild(e);
  xAddEventListener(window, 'load', appOnload, false);
  xAddEventListener(window, 'unload', function(){if (window.xthf) window.xthf.unload();}, false);
} 

function appOnload()
{
  //window.xthf = new xTableHeaderFixed('idFixedHeaderContainer', 'clsFixedHeaderTable', 'leftColumn', 1, 1, 'table1', 'table2', 'table3');
  //window.xthf = new xTableHeaderFixed('idFixedHeaderContainer', 'clsFixedHeaderTable', 'leftColumn', 1, 1);
 // window.xtcf = new xTableColumnsFixed('idFixedColumnsContainer', 'clsFixedColumnsTable', 'leftColumn', 1, 1,false,2,'table1');
 var fixedColumnCount=<xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@fixed_column_count"/>;
  window.xthf = new xTableFixed('idFixedHeaderContainer', 'clsFixedHeaderTable','idFixedColumnsContainer', 'clsFixedColumnsTable', 'leftColumn', 1, 1,false,fixedColumnCount,'table1');
 //dojo.debug(window.xthf);
}

</script> 
  <!-- end xtableheaderfixed -->
  <!-- end x-->

<!-- start xy-->
 <script language="JavaScript" type="text/javascript">
 <xsl:text>headers=eval("([</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/header">
<xsl:text>{key:'</xsl:text><xsl:value-of select="f_name"/><xsl:text>',name:'</xsl:text>
    <xsl:call-template name='json_adapt'>
    <xsl:with-param name="string" select="wert" />
    </xsl:call-template><xsl:text>'}</xsl:text>
 <xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
</xsl:for-each>
<xsl:text>])");
var count=1; 
<![CDATA[for (var i=0;i<headers.length;i++) if (headers[i].name.replace(/\s+$/,"")=='') {headers[i].name='Leerspalte '+count;count++;}]]> 
</xsl:text>
<xsl:text>complete_headers=eval("([</xsl:text>
<xsl:for-each select="/ergebnisse/ergebnis/ergebniselement/sqlerg/complete_headers/header">
<xsl:text>{key:'</xsl:text><xsl:value-of select="f_name"/><xsl:text>',name:'</xsl:text>
       <xsl:call-template name='json_adapt'>
    <xsl:with-param name="string" select="wert" />
    </xsl:call-template><xsl:text>'}</xsl:text>
 <xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
</xsl:for-each>
<xsl:text>])");</xsl:text>
 var count=1; 
<![CDATA[for (var i=0;i<complete_headers.length;i++) if (complete_headers[i].name.replace(/\s+$/,"")=='') {complete_headers[i].name='Leerspalte '+count;count++;}]]> 

function init(e) {
configdlg = dojo.widget.byId("configdlg");
spaltenliste=document.getElementById('spaltenliste');
//spaltentrash=document.getElementById('spaltentrash');
new dojo.dnd.HtmlDropTarget(spaltenliste, ["spaltenobjekt"]);
//new dojo.dnd.HtmlDropTarget(document.getElementById('spaltentrash'), ["spaltenobjekt"]);

document.getElementById('progressbar').style.display="none";
}
dojo.addOnLoad(init);

<!-- start showConfig -->
function showConfig()
{
<xsl:choose>
<xsl:when test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@hasAggregationHeaders='true'">
alert("Konfiguration bei diesem komplexen Layout nicht moeglich");
</xsl:when>
<xsl:otherwise>
//Spaltenreihenfolge
while (spaltenliste.hasChildNodes())
spaltenliste.removeChild(spaltenliste.childNodes[0]);
//while (spaltentrash.hasChildNodes()) spaltentrash.removeChild(spaltentrash.childNodes[0]);
//var newLI = document.createElement("li"); newLI.appendChild(document.createTextNode("nicht dargestellte Spalten")); spaltentrash.appendChild(newLI);
<![CDATA[
for (var i=0;i<complete_headers.length;i++)
{
var newLI = document.createElement("li");
newLI.setAttribute("key",complete_headers[i].key);
 spaltenliste.appendChild(newLI);

 var newLIText = document.createTextNode(complete_headers[i].name+"  ");
  var b = document.createElement ("b");
  var sp= document.createElement("span");
  b.appendChild(sp);
  sp.appendChild(newLIText);
 newLI.appendChild(b);
var cb = document.createElement("input");
cb.type = "checkbox";
cb.name = "checkboxHeader"+i;
cb.id=  "checkboxHeader"+i;
var vis=false; 
for (var i2=0;i2<headers.length;i2++)
{
 if (complete_headers[i].key==headers[i2].key) vis=true;
}
cb.checked = cb.defaultChecked=vis;
 newLI.appendChild(cb);
 newLI.appendChild(document.createTextNode("anzeigen"));
 }
var lis = document.getElementById('spaltenliste').getElementsByTagName("li");
for(var x=0; x<lis.length; x++){
new dojo.dnd.HtmlDragSource(lis[x], "spaltenobjekt");
}
]]>
//Spaltensortierung
var sortierspalten=document.getElementById('sortierspalten');
while (sortierspalten.hasChildNodes()) sortierspalten.removeChild(sortierspalten.childNodes[0]);
<![CDATA[
for (var i=0;i<complete_headers.length&&i<5;i++)
{
var lbl=document.createElement("label");
lbl.innerHTML=(i+1)+".";
sortierspalten.appendChild(lbl);
var newSelect = document.createElement("select");
newSelect.id="sortcol"+i;
newSelect.options[0]=new Option("","nocol_selected");
for (var i2=0;i2<complete_headers.length;i2++)
 {newSelect.options[i2+1]=new Option(complete_headers[i2].name,complete_headers[i2].key);}
sortierspalten.appendChild(newSelect);
var asc=document.createElement("select");
asc.id = "sortcol"+i+"-asc"; 
asc.options[0]=new Option("aufsteigend","-A");
asc.options[1]=new Option("absteigend","-D");
sortierspalten.appendChild(asc);
sortierspalten.appendChild(document.createElement("br"));
 }
]]>

configdlg.show();
</xsl:otherwise>
</xsl:choose>
}
<!-- end show config-->
<!-- start tableReload-->
function tableReload(colsetParam,colsortParam)
{
document.getElementById('progressbar').style.display="";
 <xsl:text>var callurl="/superx/servlet/SuperXmlTabelle</xsl:text>
 <!-- <xsl:if test="/ergebnisse/@jsessionid!=''">;jsessionid=<xsl:value-of select="/ergebnisse/@jsessionid"/></xsl:if> -->
 <xsl:text>?tid=</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/@id"/>
 <xsl:text><![CDATA[&reuseresult=true&colset=";]]></xsl:text>
  <![CDATA[
   if (colsetParam=='restore')
 callurl+='restore';
 else
 {
 var lis = document.getElementById('spaltenliste').getElementsByTagName("li");

for(var x=0; x<lis.length; x++){
 if (lis[x].getElementsByTagName('input')[0].checked)
 {
  for (var i=0;i<complete_headers.length;i++)
   if (complete_headers[i].key==lis[x].getAttribute("key")) callurl+=escape(complete_headers[i].key);
     if (x<(lis.length-1)){ callurl+="|";}
  }
 }

}
callurl+='&colsort=';
 if (colsortParam=='restore')
 callurl+='restore';
 else
 {
  for (var i=0;i<complete_headers.length&&i<5;i++)
 {
 var sortcol=document.getElementById('sortcol'+i);
 var sortcolasc=document.getElementById('sortcol'+i+'-asc');
 var sel=sortcol.options[sortcol.selectedIndex].value;
 if (i==0&&sel!='nocol_selected') callurl+=sel+sortcolasc.options[sortcolasc.selectedIndex].value;
 if (i>0&&sel!='nocol_selected') callurl+="|"+sel+sortcolasc.options[sortcolasc.selectedIndex].value;
 }
 }
 ]]>
self.location=callurl;
}
<!-- end table reload -->

	</script>
	

	<!-- end dojo-->
<!-- start treetable -->
<xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/@istreetable='true'">
<script type="text/javascript" src="/superx/xml/js/treetable.js"></script>
 <script type="text/javascript">
    treetable_callbacks['eventRowStateChanged'] = 'treetable_eventRowChanged';
    
    function treetable_eventRowChanged(rowId, state) {
    try{
    //normalerweise ist Grafik in erster Spalte, kann aber auch 2. sein
    //var row=document.getElementById(rowId); //macht im FF pltzlich rger
    //dojo.debug("rowid:"+rowId);
    var row=xGetElementById(rowId);
    //dojo.debug("row"+row);
    var tds= row.getElementsByTagName('td');
    //dojo.debug("tds:"+tds);
    //todo komisch hier luft was schief??!
    //dojo.debug("tds length"+tds.length);
    var td0=tds[0]
     var td0img=  td0.getElementsByTagName('img');
     if (td0img.length>0) img=td0img[0];
     else
   { 
   tds=row.getElementsByTagName('td');
   //dojo.debug("tds :"+tds);
    //dojo.debug("tds length"+tds.length);
    var td1=tds[1];
    var td1img=  td1.getElementsByTagName('img');
    
   if (td1img.length>0) img = td1img[0];
   }
    
      if (state == 1) {
        img.src = '/superx/xml/folder_green_open.gif';
      } else {
        img.src = '/superx/xml/folder_green.gif';
      }
      }
      catch (e) {
      }
      return (true);
    }  
  </script>
<script type="text/javascript">
         		function ajaxNodeToggle(nodeid,internalrowno)
			{
			
			//if children already loaded, no ajax request necessary
			//dojo.debug(document.getElementById(nodeid+"_0"));
			if (!document.getElementById(nodeid+"_0"))
			{
			document.getElementById('progressbar').style.display="";
			<xsl:text>var callurl="/superx/servlet/SuperXmlTabelle</xsl:text>
 <!-- <xsl:if test="/ergebnisse/@jsessionid!=''">;jsessionid=<xsl:value-of select="/ergebnisse/@jsessionid"/></xsl:if> -->
 <xsl:text>?tid=</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/@id"/><xsl:text>";
 </xsl:text>
			<![CDATA[
			callurl+="&treetableid="+nodeid+"&getKidRows="+internalrowno;
			]]>
			 dojo.io.bind({url:callurl,encoding: "ISO-8859-1",method: "post",
			       handler: function(type,data,evt)
			       {
			      // dojo.debug(data);
			           document.getElementById('progressbar').style.display="none";
			     if (type=='error') {
			     msg='Fehler beim Lesen der Daten!\n';
			     if (data.message) msg+=data.message;
			     else msg+=data.error;
					       alert(msg);
					       //dojo.debugDeep(data);
			       }
				       else
				      {
				      
			var help=document.createElement("div");
			help.innerHTML=data;
			  var pos=document.getElementById(nodeid).sectionRowIndex;
			  //dojo.debug("pos: "+pos);
			 var newrows=help.getElementsByTagName("tr");
			   <![CDATA[
			for (i=0;i<newrows.length;i++)
			{
			
			var newrow=document.getElementById("table1").tBodies[0].insertRow(pos+i+1);
			newrow.id=nodeid+"_"+i;
			//IE kann nicht in TR-innerHTML schreiben
			//newrow.innerHTML=newrows[i].innerHTML;
			for (i2=0;i2<newrows[i].attributes.length;i2++)
			{
			  newrow.setAttribute(newrows[i].attributes[i2].name,newrows[i].getAttribute(newrows[i].attributes[i2].name));
			}
			//fuck IE
			newrow.setAttribute("className", newrows[i].getAttribute("className"));
			   for (i2=0;i2<newrows[i].cells.length;i2++)
			   {
			    newcell=newrow.insertCell(i2);
			    newcell.innerHTML=newrows[i].cells[i2].innerHTML;
			    //Attribut wie class wird nicht durch innerHTML bernommen
			    for (i3=0;i3<newrows[i].cells[i2].attributes.length;i3++)
			    {
			    newcell.setAttribute(newrows[i].cells[i2].attributes[i3].name,newrows[i].cells[i2].getAttribute(newrows[i].cells[i2].attributes[i3].name));
			    }
			    //fuck IE
			    newcell.setAttribute("className", newrows[i].cells[i2].getAttribute("className"));
			   }
			}
			treetable_toggleRow(nodeid,1,1);
			treetable_eventRowChanged(nodeid, 1);
			if (window.xthf) window.xthf.init();
			 document.getElementById('progressbar').style.display="none";
				 ]]>			
	            }
	          }
	          }
			       );
			
			       }
			       else //kein Nachladen per Dojo ntig
			       {
			          treetable_toggleRow(nodeid);
				 //  treetable_zuklappen(nodeid);
				//   var starttime=(new Date).getTime();
				 //   while (starttime+400>(new Date).getTime()){};
				 //   treetable_toggleRow(nodeid,-1,-1);
				   }
				  
	  if (window.xthf) window.xthf.init();
	    
	 //dojo.debugDeep(window.xthf);
	
			       }
	
	
			      
			       </script>
			
 
</xsl:if>
<!-- end treetable-->

 <!-- start Lesezeichen/applyMerkmale-->
	<script language="JavaScript" type="text/javascript">

<!-- von Lesezeichen oder template Merkmale eintragen 
geht nur fr normale Masken da Javascript-array fr Felder korrekt gefllt sein muss
anders definiert als in maske_html, muss genauso heien, damit allgemeine Vorlage sowohl masken als auch bei Tabellen greifen 
   -->	
function applyMerkmale(merkmale)
{
<xsl:text><![CDATA[url=location.protocol+'//'+location.host+"/superx/servlet/SuperXmlTabelle";]]>
</xsl:text>
<!-- <xsl:if test="/ergebnisse/@jsessionid!=''"><xsl:text>url+=';jsessionid=</xsl:text><xsl:value-of select="/maske/@jsessionid"/><xsl:text>';
</xsl:text></xsl:if>-->
<xsl:text>url+="?tid="+getTid();</xsl:text>
<xsl:if test="/ergebnisse/@MandantenID!='default'">
<xsl:text><![CDATA[url+="&MandatenID=]]></xsl:text><xsl:value-of select="/ergebnisse/@MandantenID"/><xsl:text>";</xsl:text>
</xsl:if>
var merkmale2=merkmale.replace(/n:'/g,'n:"');
var merkmale3=merkmale2.replace(/',k:'/g,'",k:"');
var merkmale4=merkmale3.replace(/'}/g,'"}');
var merkmale5=merkmale4.replace(/',sichtparam:'/g,'",sichtparam:"');
var merkmale6=merkmale5.replace(/',standparam:'/g,'",standparam:"');
var m=purgeval(merkmale6);
<![CDATA[
for (i=0;i<m.length;i++)
{
url+="&"+encodeURIComponent(m[i].n)+"="+encodeURIComponent(m[i].k);
if (m[i].sichtparam) url+="&"+encodeURIComponent(m[i].n)+"-Sicht="+encodeURIComponent(m[i].sichtparam);
if (m[i].standparam) url+="&"+encodeURIComponent(m[i].n)+"-Stand="+m[i].standparam;
}
]]>
<!--falls ein Feld nicht als Merkmal belegt ist und es fr ein Feld auf der Maske eine Auswahl gibt, diese bernehmen-->
<![CDATA[
for(var i1=1;i1<= felder.length-1; i1++)
{
var merkmalvorhanden=false;
for (i=0;i<m.length;i++)
{
if (encodeURIComponent(m[i].n)==encodeURIComponent(felder[i1]["htmlname"])) merkmalvorhanden=true;
}
if (!merkmalvorhanden) 
  { 
   var val=felder[i1]["value"];
   url+="&"+encodeURIComponent(felder[i1]["htmlname"])+"="+encodeURIComponent(val);
 }
}
]]>
<xsl:if test="/ergebnisse/@isMakro!='true'">
<xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colset!=''">
<xsl:text><![CDATA[url+="&colset=]]></xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colset"/><xsl:text>";
</xsl:text>
</xsl:if>
<xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colsort!=''">
<xsl:text><![CDATA[url+="&colsort=]]></xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colsort"/><xsl:text>";
</xsl:text>
</xsl:if>
</xsl:if>
//dojo.debug(url);
document.getElementById('progressbar').style.display="";
location.href=url;
}
<!-- fr Zurck-Button bei normalen Abfragen und Lesezeichen
-->

function getParams(method) <!--direkt fr Zurckbutton, ohne Speicherung als Bookmarklet-->
{

params="";
//alert("getparams - method"+method);
if (method!='direkt') params+="p=[";

  <xsl:for-each select="/ergebnisse/ergebnis/felder/feld">
    <xsl:if test="value!='' and value!='null'"> <!-- bei Duisburger Sichten vorgekommen-->
    if (method!='direkt') 
     <xsl:text>params+="{\"n\":\"</xsl:text><xsl:value-of select="@varname"/><xsl:text>\",\"k\":\"</xsl:text>
     <xsl:value-of select="value"/><xsl:text>\"},";
       </xsl:text>
     else
       <xsl:text><![CDATA[params+="&"+encodeURIComponent("]]></xsl:text><xsl:value-of select="@varname"/><xsl:text>")+"="+encodeURIComponent("</xsl:text><xsl:value-of select="value"/><xsl:text>");
   </xsl:text>

   

   <!-- Probleme im IE wenn kleiner als, Prozent oder sowas vorkommt 
   title+=" </xsl:text>
   <xsl:choose>	<xsl:when test="caption_short!= '' and caption_short != 'null'"><![CDATA[]]><xsl:value-of select="caption_short" /><![CDATA[]]>
	</xsl:when>
	<xsl:otherwise>	<xsl:value-of select="@varname" />	</xsl:otherwise>	</xsl:choose><xsl:text>: </xsl:text><xsl:value-of select="value"/><xsl:text>";
    </xsl:text>
   -->
      </xsl:if>
<!-- MB Stand und Sicht in Lesezeichen -->
  <xsl:if test="@stand!=''">
  <xsl:text>var stand="</xsl:text><xsl:value-of select="@stand"/><xsl:text>";
  </xsl:text>

  if (<![CDATA[stand&&isDate(stand)&&!isToday(stand)]]>) <!-- wenn Stand today ist, braucht er nicht in bookmarklet noch in zurckbutton-->
  {
  if (method!='direkt')
    <xsl:text>params+="{\"n\":\"</xsl:text><xsl:value-of select="@varname"/><xsl:text>-Stand\",\"k\":\"</xsl:text><xsl:value-of select="@stand"/><xsl:text>\"},";
    </xsl:text>
    else
       <xsl:text><![CDATA[params+="&"+encodeURIComponent("]]></xsl:text><xsl:value-of select="@varname"/><xsl:text>")+"-Stand=</xsl:text><xsl:value-of select="@stand"/><xsl:text>";
   </xsl:text> 
   }
  </xsl:if>
  <xsl:if test="sicht/@name_intern!=''">
    if (method!='direkt')
   <xsl:text>params+="{\"n\":\"</xsl:text><xsl:value-of select="@varname"/><xsl:text>-Sicht\",\"k\":\"</xsl:text><xsl:value-of select="sicht/@name_intern"/><xsl:text>\"},";
   </xsl:text>
   else
    <xsl:text><![CDATA[params+="&"+encodeURIComponent("]]></xsl:text><xsl:value-of select="@varname"/><xsl:text>")+"-Sicht="+encodeURIComponent("</xsl:text><xsl:value-of select="sicht/@name_intern"/><xsl:text>");
   </xsl:text> 
  </xsl:if>
 </xsl:for-each>
 
if (method!='direkt') params=params.substring(0,params.length-1)+"]";//letztes Komma berschreiben
alert(params);

return params;
}

<!-- Tabelle_esezeichen erstellen - bei Makros ist dojo zu aufwndig-->
function lesezeichen_erstellen()
{
params=getParams();
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
title='Tab <xsl:value-of select="/ergebnisse/makro/name" />';
</xsl:when>
<xsl:otherwise>
title='Tab <xsl:value-of select="/ergebnisse/ergebnis/maskenname"/>';
<xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colset!=''">
<xsl:text><![CDATA[params+=";p[p.length]={\"n\":\"colset\",\"k\":\"]]></xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colset"/><xsl:text>\"}";
</xsl:text>
</xsl:if>
<xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colsort!=''">
<xsl:text><![CDATA[params+=";p[p.length]={\"n\":\"colsort\",\"k\":\"]]></xsl:text><xsl:value-of select="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@colsort"/><xsl:text>\"}";
</xsl:text>
</xsl:if>
</xsl:otherwise>
</xsl:choose>

//dojo.debug(params);

<xsl:text>lesezeichen('/superx/servlet/SuperXmlTabelle',getTid(),'</xsl:text><xsl:value-of select="/ergebnisse/@MandantenID"/><xsl:text>',params,title);</xsl:text>
dojo.widget.byId("lesezeichendlg").show();

}
</script>
<!-- end lesezeichen -->
	</xsl:if>
<!-- end normale Abfragen - nicht makros-->
</xsl:template>
<!-- end javascript-->	

<!-- start tablecenter-->
<xsl:template name="tableCenter">
<form name="Weiterverarbeitung"  method="post" target="_self" charset="ISO-8859-1"><xsl:attribute name="action"><xsl:value-of select="'SuperXmlTabelle'" /></xsl:attribute>
<!-- start Kopf-->
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_inform'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_inform'"></xsl:with-param></xsl:call-template>

<input type="hidden" name="tid">
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro='true'">
<xsl:attribute name="value"><xsl:value-of select="/ergebnisse/makro/@id" /></xsl:attribute>
</xsl:when>
<xsl:otherwise> 
<xsl:attribute name="value"><xsl:value-of select="/ergebnisse/ergebnis/maskenname/@id" /></xsl:attribute>
</xsl:otherwise>
</xsl:choose>
</input>
<input type="hidden" name="UserID"><xsl:attribute name="value"><xsl:value-of select="/ergebnisse/userID" /></xsl:attribute></input>
<input type="hidden" name="reuseresult" value="true"/> <!--  gecachte Ergebnis benutzen-->
<input type="hidden" name="maxoffset" value=""/> <!--im Normalfall wird Servleteinstellung genutzt - nur Druckversion bergibt Wert-->
<input type="hidden" name="stylesheet" value="" />
<input type="hidden" name="contenttype" value="" />
<xsl:for-each select="/ergebnisse/ergebnis/felder/feld">
 <input type="hidden">
   <xsl:attribute name="name"><xsl:value-of select="@varname" /></xsl:attribute>
   <xsl:attribute name="value"><xsl:value-of select="value" /></xsl:attribute>
  </input>
</xsl:for-each>

<!--
<xsl:call-template name="tablePrintsaveexport"/>
-->
<xsl:if test="/ergebnisse/@isMakro='true'">
<h1><xsl:value-of select="/ergebnisse/makro/name" /></h1>
</xsl:if>
<p></p>

<!-- end Kopf-->
<!-- start tabelle-->
<xsl:for-each select="ergebnisse/ergebnis/ergebniselement">
<xsl:choose>
<xsl:when test="@typ='image'">
  <img><xsl:attribute name="src"><xsl:value-of select="@url" /></xsl:attribute></img><hr/>
  <xsl:text>
  </xsl:text>
</xsl:when>
<xsl:when test="@typ='tabelle'">
   <xsl:call-template name="tableSingletable"/>
</xsl:when>
<xsl:otherwise>
    <xsl:text> Nicht untersttzter Ergebnistyp </xsl:text><xsl:value-of select="@type" />
</xsl:otherwise>
</xsl:choose>
<!-- end tabelle-->
<!-- start fu-->
<xsl:choose>
<xsl:when test="/ergebnisse/@isMakro!='true' and /ergebnisse/ergebnis/ergebniselement/sqlerg/@istreetable!='true'">
<xsl:call-template name="navigationsfuss" />
</xsl:when>
<xsl:otherwise> <!-- input fr offset ist wichtig fr Exporte, normalerweise im Navigationsfu definiert -->
<input type="hidden" name="offset">
<xsl:attribute name="value"><xsl:value-of select="sqlerg/@offset" /></xsl:attribute> 
</input>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_pre_explanation'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_pre_explanation'"></xsl:with-param></xsl:call-template>

<xsl:if test="count(sqlerg/headers/header/caption_long) &gt; 0"><xsl:call-template name="explanation" /></xsl:if>
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_post_explanation'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_post_explanation'"></xsl:with-param></xsl:call-template>

</xsl:for-each>
</form>
<!-- end fu-->
</xsl:template>
<!-- end tablecenter-->
<!-- start printsaveExport-->
<!-- printsave/export in pageComponents definiert - kann also berlagert werden-->
<xsl:template name="tablePrintsaveexport">
<table  class="dontprint" border="0"><tr><td align="left">
<xsl:call-template name="printsaveButtons" />
</td>
<td align="right"><xsl:call-template name="exportButtons" />
</td>
</tr></table>
</xsl:template>
<!-- end printsave -->

<!-- start singleTable-->
<xsl:template name="tableSingletable">
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_pre_title'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_pre_title'"></xsl:with-param></xsl:call-template>

<p class="maskentitel"><xsl:value-of select="../maskenname" /></p>
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'table_post_title'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="tablecustomize"><xsl:with-param name="position" select="'table_post_title'"></xsl:with-param></xsl:call-template>

<!--<xsl:call-template name="legende" />-->
<xsl:if test="/ergebnisse/@isMakro!='true' and /ergebnisse/ergebnis/ergebniselement/sqlerg/@istreetable!='true' and /ergebnisse/ergebnis/ergebniselement/sqlerg/@max &gt; 19">
  <xsl:call-template name="navigationsmenue" />
</xsl:if>
<table id="table1" class="ergtabelle">
<!-- start headers -->
<thead>
<!--Spaltenberschriften: zunchst wird geprft, ob Spaltenberschriften verknpft werden sollen 

<xsl:variable name="spanned_cols"> 
<xsl:for-each select="sqlerg/headers/header">
<xsl:if test="contains(wert,'\000')"> 
    <xsl:text>true</xsl:text>
</xsl:if>
</xsl:for-each>
</xsl:variable>

<xsl:when test="contains($spanned_cols,'true')"> 
<xsl:variable name="headers_str">
<xsl:for-each select="sqlerg/headers/header">
<xsl:value-of select="concat('^',wert)" />
</xsl:for-each>
</xsl:variable>
<xsl:value-of select="sx:headers2html($headers_str)" disable-output-escaping="yes"/>
 -->
<xsl:choose>
<xsl:when test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/@hasAggregationHeaders='true'">
<xsl:for-each select="sqlerg/aggregationHeaders/tr">
<tr>
<xsl:for-each select="th [@isHidden!='true']">
<th class="header" scope="col">
<xsl:if test="@colspan!=''"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
<xsl:if test="@rowspan!=''"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
<xsl:choose>
<xsl:when test="@isopen='true'">
<a class='bildnavi' >
<xsl:attribute name="href"><xsl:text>javascript:setHeaderExpanded('</xsl:text>
<xsl:value-of select="/ergebnisse/@jsessionid"/><xsl:text>',</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/maskenname/@id" />
<xsl:text>,</xsl:text><xsl:value-of select="@id"/><xsl:text>,false);</xsl:text></xsl:attribute>
 <img border='0' src='/superx/xml/folder_green_open.gif'/>&#160;
<xsl:call-template name="removeBackslashN" >
    <xsl:with-param name="derwert"><xsl:value-of select="." /></xsl:with-param>
    <xsl:with-param name="format"><xsl:value-of select="'html'" /></xsl:with-param>
    </xsl:call-template>  
</a>
</xsl:when>
<xsl:when test="@isopen='false'">
<a class='bildnavi'>
<xsl:attribute name="href"><xsl:text>javascript:setHeaderExpanded('</xsl:text>
<xsl:value-of select="/ergebnisse/@jsessionid"/><xsl:text>',</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/maskenname/@id" />
<xsl:text>,</xsl:text><xsl:value-of select="@id"/><xsl:text>,true);</xsl:text></xsl:attribute>
<img border='0' src='/superx/xml/folder_green.gif'/>&#160;
<xsl:call-template name="removeBackslashN" >
    <xsl:with-param name="derwert"><xsl:value-of select="." /></xsl:with-param>
    <xsl:with-param name="format"><xsl:value-of select="'html'" /></xsl:with-param>
    </xsl:call-template>
</a> 
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="removeBackslashN" >
    <xsl:with-param name="derwert"><xsl:value-of select="." /></xsl:with-param>
    <xsl:with-param name="format"><xsl:value-of select="'html'" /></xsl:with-param>
    </xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</th>

</xsl:for-each>
</tr>
</xsl:for-each>
</xsl:when>
<xsl:otherwise>
<!-- alt Normale headers -->
<xsl:variable name="headers_str">
<xsl:for-each select="sqlerg/headers/header">
<xsl:value-of select="concat('^',wert)" />
</xsl:for-each>
</xsl:variable>
<xsl:value-of select="sx:headers2html($headers_str)" disable-output-escaping="yes"/>

<!--<xsl:call-template name="removeBackslashN" >
    <xsl:with-param name="derwert"><xsl:value-of select="." /></xsl:with-param>
    <xsl:with-param name="format"><xsl:value-of select="'html'" /></xsl:with-param>
    </xsl:call-template>
<tr>
<xsl:for-each select="sqlerg/headers/header">
<th class="header" scope="col">
<xsl:call-template name="removeBackslashN" >
    <xsl:with-param name="derwert"><xsl:value-of select="wert" /></xsl:with-param>
    <xsl:with-param name="format"><xsl:value-of select="'html'" /></xsl:with-param>
    </xsl:call-template>
    </th>
</xsl:for-each>
</tr>-->
</xsl:otherwise>
</xsl:choose>

<!--<td></td>-->
</thead>
<!-- end headers -->
<!-- start data-->
<tbody>
<xsl:variable name="erglevelmax"><xsl:text>5</xsl:text> 
<!-- todo: auch bei treetable variable Zeilenebenen
<xsl:if test="count(sqlerg/row/col [ f_name = 'ebene' ]) &gt; 0">
<xsl:choose>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '4']) &gt; 0">
<xsl:text>4</xsl:text>
</xsl:when>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '3']) &gt; 0">
<xsl:text>3</xsl:text>
</xsl:when>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '2']) &gt; 0">
<xsl:text>2</xsl:text>
</xsl:when>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '1']) &gt; 0">
<xsl:text>1</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>5</xsl:text>
</xsl:otherwise>
</xsl:choose>
</xsl:if>-->
</xsl:variable>
<xsl:for-each select="sqlerg/row">
  <!-- MB ausgelagert nach resultset.xsl-->
<xsl:call-template name="resultrow">
<xsl:with-param name="row" select="."/>
<xsl:with-param name="erglevelmax" select="$erglevelmax"/>
</xsl:call-template>
</xsl:for-each>
</tbody>
<!-- end data-->
</table>
</xsl:template>
<!-- end singleTable-->
<!-- start DOJO Dialoge-->
<xsl:template name="tableDialogs">
<xsl:if test="/ergebnisse/@isMakro!='true'"> 
<!-- start configdlg-->
 <div dojoType="dialog" id="configdlg" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="250" closeNode="ok" style="display:none">

		<form name="configform" onsubmit="return false;">
		
	<table style="font-size:10pt">
	<tr><td align="center"><h3>Spaltenreihenfolge</h3></td><td align="center" valign="top"><h3>Sortierung der Ergebnisse</h3></td></tr>
	<tr><td align="left">
	<div style="height:300px;width:300px;overflow:scroll"><!-- IE needs non-dojo div vor scrolling-->
	<ul id="spaltenliste">
	<li>Keine Spalteninformation gefunden</li>
	</ul>
	</div>
	<!--
	<p align="center"><b>MLLEIMER</b></p>
	 <div style="height:80px;width:350px;overflow:scroll">-->
	 <!-- IE needs non-dojo div vor scrolling-->
	 <!--
	<ul id="spaltentrash"><li>nicht dargestellte Spalten</li></ul>
	</div>
	-->
	<label> <![CDATA[Sie knnen einen Eintrag anklicken und  ]]><br/>
	<![CDATA[ bei gedrckter li. Maustaste verschieben]]> <br/>
	         <![CDATA[die schwarze Hilfslinie zeigt das Ziel an.]]><br/>
	         <![CDATA[ Entfernen Sie das Hkchen bei "anzeigen",]]><br/>
		 <![CDATA[ um Spalten auszublenden]]><br/>
		 <!--  <![CDATA[ in den Mlleimer ziehen.]]>  -->
		  </label>
	</td>
	<td>
	<p>Sortieren nach Spalte</p>
	<div id="sortierspalten">
	</div>
	</td>
	</tr>
	</table>
	
	<p align="center">
	<input type="button" id="ok" class="clsButtonStyle" onclick="tableReload('','');" value="OK"></input>&#160;
	
	<input type="button" id="restore" class="clsButtonStyle" onclick="tableReload('restore','restore');" value="Alles zurcksetzen"></input>&#160;
	<input type="button" id="abbrechen" class="clsButtonStyle" onclick="configdlg.hide()" value="Abbrechen"></input>&#160;
	</p>
	
			</form>
			
	
</div>
<!-- end configdlg -->
</xsl:if>

<!-- start lesezeichen -->
<div dojoType="dialog" id="lesezeichendlg" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="250" closeNode="hidelesezeichen" style="display:none">
	<form name="lesezeichenform" onsubmit="return false;">
	<h1 align="center">Lesezeichen erstellen</h1>
	 <div id="lesezeichenlinkdiv">
	 <p align="center"> Hier Ihr Lesezeichen-Link:</p>
	 <h3 align="center"><a id="lesezeichenlink"></a></h3>
	 <p align="center" id="lesezeicheninfoIE"> Klicken Sie mit der <b><font color="red">rechten Maustaste</font></b> auf den obigen Link und whlen Sie <br/><br/><b>"Zu Favoriten hinzufgen"</b><br/>
	 <br/>
	 Es folgt ein Sicherheitshinweis <br/>"Sie fgen einen Favoriten hinzu, der mglicherweise nicht sicher ist"<br/>
	 Den knnen Sie besttigen, da SuperX-Lesezeichen nur harmloses JavaScript verwenden.<br/><br/>
	 Hinweis: Damit SuperX-Lesezeichen im IE7 aufgerufen werden knnen, muss vorher eine beliebige andere Seite angezeigt werden.</p>
	 <p align="center" id="lesezeicheninfoFF"> Klicken Sie mit der <b><font color="#f17c00">rechten Maustaste</font></b> auf den obigen Link und whlen Sie <br/><b>"Lesezeichen fr diesen Link hinzufgen"</b>
	 </p>
	 <br/><br/><br/><br/><br/><br/><br/>
	 <p align="center"><input id="hidelesezeichen" class="clsButtonStyle" type="button" value="Dialog schlieen"></input></p>
	 </div>
	
		 
	</form>
</div>

<!-- end lesezeichen-->
</xsl:template>
<!-- end DOjo dialoge-->
<!-- start obsolet -->
<xsl:template name="tabwert">
    <xsl:choose>
      <xsl:when test="wert/@type='numeric'"><xsl:value-of select="wert" />
<!--<xsl:value-of select="format-number(wert,'#.###.##0,00','de_DE')" />-->
</xsl:when>
<xsl:otherwise><xsl:value-of select="wert" /></xsl:otherwise>
</xsl:choose>
</xsl:template>
<xsl:template name="create_url">
<xsl:param name="stylesheet"/>
<xsl:text>../servlet/SuperXmlTabelle?</xsl:text>
<xsl:text>tid=</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/maskenname/@id" />
<xsl:if test="$stylesheet!=''"><xsl:text>&amp;stylesheet=</xsl:text><xsl:value-of select="$stylesheet" />
</xsl:if>

	<xsl:for-each select="/ergebnis/tabelle/felder/feld">
	<xsl:if test="wert/value !=''">
		<xsl:text>&amp;</xsl:text><xsl:value-of select="wert/@varname" /><xsl:text>=</xsl:text><xsl:value-of select="wert/value" />
	</xsl:if>
</xsl:for-each>
</xsl:template>
<!-- end -->
 <!-- start customize  standard ist leer, kann von Spezialstylesheets berlagert werden -->
  <xsl:template name="tablecustomize">
    <xsl:param name="position"/>
 </xsl:template>
  <!-- end customize-->
</xsl:stylesheet>
