<?xml version="1.0"  encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:sx="http://memtext.de"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="pageComponents_html.xsl" />
<!--In diesem Stylesheet knnen Sie individuelle templates unterbringen,
  die in ihrer Przedenz das normale Stylesheet 
  pageComponents_html.xsl berragt. --> 
<xsl:import href="pageComponents_html_final.xsl" />
<xsl:import href="resultset_html.xsl" />
<xsl:import href="interLinks_html.xsl" />
<xsl:import href="xsl_functions.xsl" />
<xsl:import href="menue_html_dojo.xsl" />
<xsl:decimal-format name="German" grouping-separator="." NaN="" zero-digit ="0" decimal-separator="," />

<xml:output method="html" />
<xsl:template match="/">

<html>
<xsl:call-template name="head" >
<xsl:with-param name="title" select="concat('Ergebnis ',/ergebnisse/ergebnis[ position()=1]/maskenname)" /> 
</xsl:call-template> 
<body onload="isReady=true">
  <xsl:if test="/ergebnisse/@showNavigation='true'"> 
<xsl:for-each select="/ergebnisse/menue">
   <xsl:call-template name="menuFrame" />
   </xsl:for-each>
</xsl:if>
   <div>
<xsl:if test="/ergebnisse/@showNavigation='true'">
<xsl:attribute name="class"><xsl:text>page-wrap</xsl:text></xsl:attribute>
   <xsl:for-each select="/ergebnisse/menue">
   <xsl:call-template name="topbar_menue" />
   </xsl:for-each>
</xsl:if>

   <div>
   <xsl:if test="/ergebnisse/@showNavigation='true'">
   <xsl:attribute name="id"><xsl:text>wrapper</xsl:text></xsl:attribute>
   </xsl:if>
<xsl:call-template name="topbar_table" />
<form name="Weiterverarbeitung"  method="post" target="_self"><xsl:attribute name="action"><xsl:value-of select="'SuperXmlTabelle'" /></xsl:attribute>
<table border="0"><tr><td align="left"><input type="hidden" name="UserID">

<xsl:attribute name="value"><xsl:value-of select="/ergebnisse/userID" /></xsl:attribute>
</input>

<input type="hidden" name="reuseresult" value="false"/> <!--  gecachte Ergebnis benutzen-->
<input type="hidden" name="maxoffset" value=""/> <!--im Normalfall wird Servleteinstellung genutzt - nur Druckversion bergibt Wert-->
<input type="hidden" name="stylesheet" value="" />
<!-- <input type="hidden" name="Bestaetigt" value="" /> -->
<input type="hidden" name="contenttype" value="" />
<input type="hidden" name="navi" value="{/ergebnisse/@showNavigation}" />
<!--[ @varname != 'Bestaetigt']-->
<xsl:for-each select="/ergebnisse/ergebnis/completefields/feld ">
		<input type="hidden">
		<xsl:attribute name="name"><xsl:value-of select="@varname" /></xsl:attribute>
		<xsl:choose>
		<xsl:when test="@varname='Inhalt' and count(../feld[@varname='Trennzeichen']='tab') &gt; 0">
		<xsl:attribute name="value">
		<xsl:call-template name="search_replace">
		<xsl:with-param name="string"><xsl:value-of select="value" /></xsl:with-param>
		<xsl:with-param name="search"><xsl:text>	</xsl:text></xsl:with-param>
		<xsl:with-param name="replace"><xsl:text>^</xsl:text></xsl:with-param>
		</xsl:call-template>
		</xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
		<xsl:attribute name="value"><xsl:value-of select="value" /></xsl:attribute>
		</xsl:otherwise>
		</xsl:choose>
		</input>
</xsl:for-each>

<!--<xsl:call-template name="printsaveButtons" />-->
</td>
<td align="right"><!--<xsl:call-template name="exportButtons" />-->
</td></tr></table>
<xsl:choose>
<!--MB -->
<xsl:when test="/ergebnisse/makro/@id !=''">
<h1><xsl:value-of select="/ergebnisse/makro/name" /></h1>
<p><input type="hidden" name="tid">
<xsl:attribute name="value"><xsl:value-of select="/ergebnisse/makro/@id" /></xsl:attribute>
</input>
</p></xsl:when>
<xsl:otherwise> 
<p><input type="hidden" name="tid">
<xsl:attribute name="value"><xsl:value-of select="/ergebnisse/ergebnis/maskenname/@id" /></xsl:attribute>
</input></p>
</xsl:otherwise>
</xsl:choose>

<!--<xsl:call-template name="legende" />-->
<xsl:for-each select="ergebnisse/ergebnis/ergebniselement">
<xsl:choose>
<xsl:when test="@typ='image'">
<img>
<xsl:attribute name="src"><xsl:value-of select="@url" /></xsl:attribute>
</img>
<hr/>
<xsl:text>

</xsl:text>
</xsl:when>
<xsl:when test="@typ='tabelle'">
<xsl:choose>
<xsl:when test="/ergebnisse/ergebnis/completefields/feld [ @varname = 'Bestaetigt'] /value='1' "> 
<p class="maskentitel">Import ausgefhrt: <xsl:value-of select="../maskenname" /></p>
</xsl:when>
<xsl:otherwise>
<p class="maskentitel"><xsl:value-of select="../maskenname" /> (Vorschau)</p>
</xsl:otherwise>
</xsl:choose>



<!-- MB legende bei jeder Tabelle -->
<xsl:call-template name="legende" />
<!-- MB fehlermeldung direkt vom Servlet
<xsl:if test="errmsg !=''"><p class="errmsg"><xsl:copy-of select="errmsg" /></p></xsl:if>
 -->
<table class="ergtabelle">
<tr>
<!--Spaltenberschriften: zunchst wird geprft, ob Spaltenberschriften verknpft werden sollen -->
<xsl:variable name="spanned_cols"> 
<xsl:for-each select="sqlerg/headers/header">
	<xsl:if test="contains(wert,'\000')"> 
    <xsl:text>true</xsl:text>
</xsl:if>
</xsl:for-each>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains($spanned_cols,'true')"> 
<xsl:variable name="headers_str">
<xsl:for-each select="sqlerg/headers/header">
<xsl:value-of select="concat('^',wert)" />
</xsl:for-each>
</xsl:variable>
<!--Zurckgegeben werden html-<tr>-Tags -->

<xsl:value-of select="sx:headers2html($headers_str)" disable-output-escaping="yes"/>
</xsl:when>
<xsl:otherwise>
<!--Normale headers-->
<xsl:for-each select="sqlerg/headers/header">
	
	
	<xsl:call-template name="header">
    <xsl:with-param name="derwert" select="wert" />
    </xsl:call-template>		

</xsl:for-each>
</xsl:otherwise>
</xsl:choose>
<!--<td></td>-->
</tr>
<xsl:for-each select="sqlerg/row">
<tr>
<xsl:if test="col/f_name  = 'ebene'">
<xsl:attribute name="class"><xsl:text>erglevel_</xsl:text><xsl:value-of select="col[ f_name = 'ebene' ] /wert" /></xsl:attribute> 
</xsl:if>

<xsl:for-each select="col">

<td class="ergfeld">
    <xsl:choose>
      <!--<xsl:when test="@id='0'">
		<xsl:attribute name="class">themenspalte</xsl:attribute>
	</xsl:when>
	<xsl:when test="@typ='1'"> String
		<xsl:attribute name="class">string</xsl:attribute>
		<xsl:value-of select="wert" />
		</xsl:when>-->
	<xsl:when test="@typ='2' or @typ='8' or @typ='3'"> <!-- DecimalFormat -->
		<xsl:attribute name="class">decimal</xsl:attribute>
		<!--<xsl:value-of select="wert" />-->
		<xsl:choose>
    <xsl:when test="wert != ''">
   <xsl:value-of select="format-number(wert,'###.###.###.###.##0,00','German')" />
    </xsl:when>
    <xsl:otherwise>
    <xsl:value-of select="'&#160;'" />
    </xsl:otherwise>
    </xsl:choose>
		
	</xsl:when>
	<xsl:when test="@typ='4'"> <!-- Integer -->
		<xsl:attribute name="class">integer</xsl:attribute>
		<!--<xsl:value-of select="wert" />-->
		<xsl:choose>
    <xsl:when test="wert != ''">
   <xsl:value-of select="format-number(wert,'###.###.###.###.###','German')" />
    </xsl:when>
    <xsl:otherwise>
    <xsl:value-of select="'&#160;'" />
    </xsl:otherwise>
    </xsl:choose>
		
	</xsl:when>
	<xsl:otherwise>
	<!--Typ=1 ist string und wird defaultmig behandelt -->
	<xsl:call-template name="field_type" />
    <xsl:variable name="zs">
    <xsl:call-template name="field_value">
    </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="zs3">
    <xsl:call-template name="resultsetLink">
    <xsl:with-param name="zs2" select="$zs" />
    </xsl:call-template>
    </xsl:variable>
    <!--Ab hier knnen Benutzerspezifische Transformationen nach Feldnamen oder Typ beginnen
    Bei leeren Zellen wird nbsp bergeben, weil
    der IE die Zellen sonst ohne Rahmen darstellt.
    Standardmmig wird der Feldinhalt nur noch kopiert.-->
  
    <xsl:call-template name="get_val_or_nbsp">
    <xsl:with-param name="zs4"><xsl:copy-of select="$zs3" /></xsl:with-param>
    
    </xsl:call-template>

    
    
</xsl:otherwise>
</xsl:choose>

</td>
</xsl:for-each>
<!--<td></td>-->
</tr>
</xsl:for-each>
</table>
</xsl:when>
<xsl:otherwise>
<xsl:text>
Nicht untersttzter Ergebnistyp </xsl:text><xsl:value-of select="@type" />
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="navigationsfuss" />
</xsl:for-each>
<!--<div id="inhalt" class="versteckt"><p><TEXTAREA NAME="content" ROWS="40" COLS="80" WRAP="off" READONLY="true">
<ergebnis><xsl:copy-of select="/ergebnis/*|@*|text()" /></ergebnis>
</TEXTAREA>
</p></div>
<script language="Javascript">
versteckeText("inhalt");
</script>-->
<xsl:if test="/ergebnisse/ergebnis/completefields/feld [ @varname = 'Bestaetigt'] /value !='1' ">
<p>
<input type="submit" value="Import ausfhren"  class="clsButtonStyle">
<xsl:attribute name="onClick"><xsl:text>javascript:document.forms[0].stylesheet.value='tabelle_html_18240.xsl';document.forms[0].offset.value='0';document.forms[0].maxoffset.value='1000000';document.forms[0].Bestaetigt.value='1'; document.forms[0].submit();</xsl:text>
</xsl:attribute>
</input>
</p>
</xsl:if>
</form>
<xsl:call-template name="bottombar" />
</div>
</div>
</body>
</html>
</xsl:template>
<xsl:template name="tabwert">
    <xsl:choose>
      <xsl:when test="wert/@type='numeric'"><xsl:value-of select="wert" />
<!--<xsl:value-of select="format-number(wert,'#.###.##0,00','de_DE')" />-->
</xsl:when>
<xsl:otherwise><xsl:value-of select="wert" /></xsl:otherwise>
</xsl:choose>

</xsl:template>
<xsl:template name="create_url">
<xsl:param name="stylesheet"/>
<xsl:text>../servlet/SuperXmlTabelle?</xsl:text>
<xsl:if test="$stylesheet!=''"><xsl:text>stylesheet=</xsl:text><xsl:value-of select="$stylesheet" /><xsl:text>&amp;</xsl:text>
</xsl:if>
<xsl:text>UserID=</xsl:text><xsl:value-of select="/ergebnis/userID" /><xsl:text>&amp;tid=</xsl:text><xsl:value-of select="/ergebnisse/ergebnis/maskenname/@id" />
	<xsl:for-each select="/ergebnis/tabelle/completefields/feld">
	<xsl:if test="wert/value !=''">
		<xsl:text>&amp;</xsl:text><xsl:value-of select="wert/@varname" /><xsl:text>=</xsl:text><xsl:value-of select="wert/value" />
	</xsl:if>
</xsl:for-each>
</xsl:template>
</xsl:stylesheet>
