<?xml version="1.0"  encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">
<xsl:import href="pageComponents_html.xsl" />
<!--(c) 2010 D. Quathamer --> 
<xsl:import href="pageComponents_html_final.xsl" />
<xsl:import href="resultset_html.xsl" />
<xsl:decimal-format name="German" grouping-separator="." NaN="" zero-digit ="0" decimal-separator="," />
<!--Wenn Sie ein eigenes PDF-Stylesheet erstellen, sollten Sie die u. aufgefhrte Routine zur
Berechnung der Spaltenbreite bernehmen
Wenn Sie nur das Seitenlayout ndern wollen, z.B. auf A4, dann reicht es, hier die Variablen seitenbreite_mm,
die druckbreite_mm und das Attribut page-height anzupassen.
-->
<xsl:variable name="seitenbreite_mm">297</xsl:variable>
<!--Die Breite der Tabelle in mm bei A4 Querformat:-->
<xsl:variable name="druckbreite_mm">267</xsl:variable>
<!-- Wenn keine Spaltenbreite definiert ist, wird 12 (Einheit Applet-Breite) verwendet.  -->
<xsl:variable name="std_spaltenbreite">12</xsl:variable>
<!-- TOC-->
<xsl:variable name="studis_alle">Alle Studierende (ohne Beurlaubte, mit Praxissemester)</xsl:variable>
<xsl:variable name="studis_einschr">Studienanfnger (mit Praxissemester)</xsl:variable>
<xsl:variable name="studis_einschr12">Einschreibungen</xsl:variable>
<xsl:variable name="studis_1fs">Studierende im 1. Fachsemester</xsl:variable>
<xsl:variable name="header_abkuerzungen">Hochschulen</xsl:variable>
<xsl:variable name="header_faecher">Studienfcher (amtlich)</xsl:variable>
<xsl:variable name="header_tab1_short">Tabelle 1</xsl:variable>
<xsl:variable name="header_tab1_long">Bewerbungen und Studierende nach Hochschule</xsl:variable>
<xsl:variable name="header_tab2_short">Tabelle 2</xsl:variable>
<xsl:variable name="header_tab2_long">Bewerbungen und Studienanfnger nach HZB-Art</xsl:variable>
<xsl:variable name="header_tab3_short">Tabelle 3</xsl:variable>
<xsl:variable name="header_tab3_long">Bewerbungen nach Fchern</xsl:variable>
<xsl:variable name="header_tab4_short">Tabelle 4</xsl:variable>
<xsl:variable name="header_tab4_long">Studierende nach Fach und Hochschule</xsl:variable>
<xsl:variable name="header_tab5_short">Tabelle 5</xsl:variable>
<xsl:variable name="header_tab5_long">Studierende nach Fach und Trgerschaft</xsl:variable>
<xsl:variable name="header_tab6_short">Tabelle 6</xsl:variable>
<xsl:variable name="header_tab6_long">Studierende nach Fach und Fachsemester</xsl:variable>
<xsl:variable name="header_tab7_short">Tabelle 7</xsl:variable>
<xsl:variable name="header_tab7_long">Studierende nach Fach und Fachsemester (hochschulweise)</xsl:variable>

<xsl:variable name="font_family">Times</xsl:variable>
    <xsl:template match="/">
    <xsl:call-template name="pdfpages"/>
    </xsl:template>
    
    <xsl:template name="pdfpages">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">

<!-- start allg-->
            <fo:layout-master-set>
                 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'Deckblatt'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master_zweispaltig">
		 <xsl:with-param name="master_name" select="'TOC'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'abkuerzungen'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master_zweispaltig">
		 <xsl:with-param name="master_name" select="'faecher'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'tabelle_1'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'tabelle_2'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'tabelle_3'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'tabelle_4a'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'tabelle_4b'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'tabelle_4c'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'tabelle_5a'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'tabelle_5b'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'tabelle_5c'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'tabelle_6'" />
		 </xsl:call-template>
		 <xsl:call-template name="page_master">
		 <xsl:with-param name="master_name" select="'tabelle_7'" />
		 </xsl:call-template>
		 <fo:page-sequence-master master-name="sequence">
		     <fo:repeatable-page-master-alternatives>
		     <fo:conditional-page-master-reference master-reference="Deckblatt" />
		     <fo:conditional-page-master-reference master-reference="TOC" />
		     <fo:conditional-page-master-reference master-reference="abkuerzungen" />
		     <fo:conditional-page-master-reference master-reference="faecher" />
		     <fo:conditional-page-master-reference master-reference="tabelle_1" />
		     <fo:conditional-page-master-reference master-reference="tabelle_2" />
		     <fo:conditional-page-master-reference master-reference="tabelle_3" />
		     <fo:conditional-page-master-reference master-reference="tabelle_4a" />
		     <fo:conditional-page-master-reference master-reference="tabelle_4b" />
		     <fo:conditional-page-master-reference master-reference="tabelle_4c" />
		     <fo:conditional-page-master-reference master-reference="tabelle_5a" />
		     <fo:conditional-page-master-reference master-reference="tabelle_5b" />
		     <fo:conditional-page-master-reference master-reference="tabelle_5c" />
		     <fo:conditional-page-master-reference master-reference="tabelle_6" />
		     <fo:conditional-page-master-reference master-reference="tabelle_7" />
		     </fo:repeatable-page-master-alternatives>
                 </fo:page-sequence-master>
             </fo:layout-master-set>
	     <!-- end allg-->
	     
	     <xsl:call-template name="pdfpage"/>
 
<!-- end Seite-->
</fo:root>
</xsl:template>

<xsl:template name="pdfpage">
<!--Haupt-Template fr alle Kapitel-->
 <xsl:call-template name="Deckblatt" >
 <xsl:with-param name="semester" select="ergebnisse/ergebnis[@ordnr='2']/felder/feld[@varname='Semester']/value" />
 </xsl:call-template>
 <xsl:call-template name="TOC" >
 
 </xsl:call-template>
 <xsl:call-template name="abkuerzungen" >
  </xsl:call-template>
  
  <xsl:call-template name="faecher" >
  </xsl:call-template>
  <fo:page-sequence master-name="tabelle_1" master-reference="tabelle_1">
  <xsl:call-template name="kopf_fusszeile">
  <xsl:with-param name="nummer" select="'1'" />
  <xsl:with-param name="caption" select="''" />
  </xsl:call-template>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Tabelle_1'"/>
  </xsl:call-template>
    <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18760']">
       <xsl:call-template name="pdftable"/>
   </xsl:for-each>
   </fo:flow>
    </fo:page-sequence>
    <fo:page-sequence master-name="tabelle_2" master-reference="tabelle_2">
  <xsl:call-template name="kopf_fusszeile">
  <xsl:with-param name="nummer" select="'2'" />
  <xsl:with-param name="caption" select="''" />
  </xsl:call-template>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Tabelle_2'"/>
  </xsl:call-template>
    <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18780']">
   
       <xsl:call-template name="pdftable"/>
   </xsl:for-each>
   </fo:flow>
    </fo:page-sequence>
    <fo:page-sequence master-name="tabelle_3" master-reference="tabelle_3">
  <xsl:call-template name="kopf_fusszeile">
  <xsl:with-param name="nummer" select="'3'" />
  <xsl:with-param name="caption" select="$header_tab3_long" />
  </xsl:call-template>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Tabelle_3'"/>
  </xsl:call-template>
    <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18960']">
   
       <xsl:call-template name="pdftable"/>
   </xsl:for-each>
   </fo:flow>
    </fo:page-sequence>
    <fo:page-sequence master-name="tabelle_4a" master-reference="tabelle_4a">
  <xsl:call-template name="kopf_fusszeile">
  <xsl:with-param name="nummer" select="'4a'" />
  <xsl:with-param name="caption" select="$studis_alle" />
  </xsl:call-template>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Tabelle_4a'"/>
  </xsl:call-template>
    <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18800']">
    <xsl:if test="../felder/feld[@varname='Status']/value != '1,2' and count(../felder/feld[@varname='bis Fachsemester'])=0 and count(../felder/feld[@varname='Filter Studierende'])=0">
    <!-- zum Debuggen <fo:block>DQ: <xsl:value-of select="@ordnr" /></fo:block>-->
       <xsl:call-template name="pdftable" />
       </xsl:if>
   </xsl:for-each>
   </fo:flow>
    </fo:page-sequence>
    <fo:page-sequence master-name="tabelle_4b" master-reference="tabelle_4b">
  <xsl:call-template name="kopf_fusszeile">
  <xsl:with-param name="nummer" select="'4b'" />
  <xsl:with-param name="caption" select="$studis_einschr12" />
  </xsl:call-template>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Tabelle_4b'"/>
  </xsl:call-template>
    <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18800']">
    <xsl:if test="../felder/feld[@varname='Status']/value='1,2' and count(../felder/feld[@varname='bis Fachsemester'])=0">
       <xsl:call-template name="pdftable" />
       </xsl:if>
   </xsl:for-each>
   </fo:flow>
    </fo:page-sequence>
    <fo:page-sequence master-name="tabelle_4c" master-reference="tabelle_4c">
  <xsl:call-template name="kopf_fusszeile">
  <xsl:with-param name="nummer" select="'4c'" />
  <xsl:with-param name="caption" select="$studis_1fs" />
  </xsl:call-template>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Tabelle_4c'"/>
  </xsl:call-template>
    <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18800']">
    <xsl:if test="../felder/feld[@varname='Status']/value !='1,2' and ../felder/feld[@varname='bis Fachsemester']/value='1'">
       <xsl:call-template name="pdftable" />
       </xsl:if>
   </xsl:for-each>
   </fo:flow>
    </fo:page-sequence>
    <!-- Tabelle 5-->
    <fo:page-sequence master-name="tabelle_5a" master-reference="tabelle_5a">
  <xsl:call-template name="kopf_fusszeile">
  <xsl:with-param name="nummer" select="'5a'" />
  <xsl:with-param name="caption" select="'Alle Studierende (ohne Beurlaubte, mit Praxissemester)'" />
  </xsl:call-template>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Tabelle_5a'"/>
  </xsl:call-template>
    <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18820']">
    <xsl:if test="../felder/feld[@varname='Status']/value !='1,2' and count(../felder/feld[@varname='bis Fachsemester'])=0 and count(../felder/feld[@varname='Filter Studierende'])=0">
       <xsl:call-template name="pdftable" />
       </xsl:if>
   </xsl:for-each>
   </fo:flow>
    </fo:page-sequence>
    <fo:page-sequence master-name="tabelle_5b" master-reference="tabelle_5b">
  <xsl:call-template name="kopf_fusszeile">
  <xsl:with-param name="nummer" select="'5b'" />
  <xsl:with-param name="caption" select="$studis_einschr12" />
  </xsl:call-template>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Tabelle_5b'"/>
  </xsl:call-template>
    <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18820']">
    <xsl:if test="../felder/feld[@varname='Status']/value = '1,2' and count(../felder/feld[@varname='bis Fachsemester'])=0">
       <xsl:call-template name="pdftable" />
       </xsl:if>
   </xsl:for-each>
   </fo:flow>
    </fo:page-sequence>
    <fo:page-sequence master-name="tabelle_5c" master-reference="tabelle_5c">
  <xsl:call-template name="kopf_fusszeile">
  <xsl:with-param name="nummer" select="'5c'" />
  <xsl:with-param name="caption" select="$studis_1fs" />
  </xsl:call-template>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Tabelle_5c'"/>
  </xsl:call-template>
    <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18820']">
    <xsl:if test="../felder/feld[@varname='Status']/value !='1,2' and ../felder/feld[@varname='bis Fachsemester']/value='1'">
       <xsl:call-template name="pdftable" />
       </xsl:if>
   </xsl:for-each>
   </fo:flow>
    </fo:page-sequence>
    <fo:page-sequence master-name="tabelle_6" master-reference="tabelle_6">
  <xsl:call-template name="kopf_fusszeile">
  <xsl:with-param name="nummer" select="'6'" />
  <xsl:with-param name="caption" select="'Studierende im X. Fachsemester (insgesamt/darunter im Studiensemester, ohne Beurlaubte)'" />
  </xsl:call-template>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Tabelle_6'"/>
  </xsl:call-template>
    <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18840']">
    <xsl:if test="../felder/feld[@varname='Hochschule']/value=''">
       <xsl:call-template name="pdftable">
       <xsl:with-param name="caption" select="'Alle Hochschulen fr angewandte Wissenschaften'">
       </xsl:with-param>
       </xsl:call-template>
       </xsl:if>
   </xsl:for-each>
   </fo:flow>
    </fo:page-sequence>
    <fo:page-sequence master-name="tabelle_7" master-reference="tabelle_7">
  <xsl:call-template name="kopf_fusszeile">
  <xsl:with-param name="nummer" select="'7'" />
  <xsl:with-param name="caption" select="'Studierende im X. Fachsemester (insgesamt/darunter im Studiensemester, ohne Beurlaubte)'" />
  </xsl:call-template>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Tabelle_7'"/>
  </xsl:call-template>
    <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18840']">
    <xsl:if test="../felder/feld[@varname='Hochschule']/value !=''">
    <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="concat('anchor_Tabelle_6_',../felder/feld[@varname='Hochschule']/value)"/>
  </xsl:call-template>
  <xsl:variable name="hochschulname_lang">
  <xsl:call-template name="get_hochschulname_lang">
  <xsl:with-param name="key_apnr" select="../felder/feld[@varname='Hochschule']/value" />
  </xsl:call-template>
  </xsl:variable>
  <xsl:call-template name="pdftable">
       <xsl:with-param name="caption" select="$hochschulname_lang">
       </xsl:with-param>
       </xsl:call-template>
       </xsl:if>
   </xsl:for-each>
   <fo:block font-family="{$font_family}" line-height="8pt" font-size="8pt" margin-top="5mm">1) Studienfcher, die mehrere Studienbereiche betreffen, oder interdisziplinre Studien, die sich keinem einzelnen Fach zuordnen lassen.</fo:block>
    <fo:block font-family="{$font_family}" line-height="8pt" font-size="8pt">2) Studienfach der Lehrerausbildung, das in mehrere Studienbereiche der Fchergruppe bergreift.</fo:block>
    <fo:block font-family="{$font_family}" line-height="8pt" font-size="8pt">3) Regionale Studien, soweit nicht einzelnen Studienbereichen oder anderen Fchergruppen zuzuordnen.</fo:block>
 
   </fo:flow>
    </fo:page-sequence>
   <!-- end Tabelle
   <xsl:call-template name="pdfaftertable"/>
   <xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/header [f_name='text' and wert='Studienbereich/Fach']">
    x  </xsl:if>-->


</xsl:template>

<xsl:template name="pdfaftertable"/>

<xsl:template name="pdftable">
<xsl:param name="caption"/>
<xsl:param name="width"/>
<xsl:variable name="tablewidth">
<xsl:choose>
<xsl:when test="$width!=''"><xsl:value-of select="$width"/></xsl:when>
<xsl:otherwise><xsl:text>auto</xsl:text></xsl:otherwise>
</xsl:choose>
</xsl:variable>

<fo:table border="solid" border-collapse="collapse" table-layout="auto" width="{$tablewidth}"><xsl:text>
</xsl:text>
<xsl:call-template name="pdfcolumnwidths"/>


<xsl:call-template name="pdftableheaders">
<xsl:with-param name="caption" select="$caption" />
</xsl:call-template>

<!-- start body-->
<xsl:choose>
<xsl:when test="count(sqlerg/row) = 0"><!-- saxon verlangt hier mind. eine Zeile -->
  <fo:table-body><fo:table-row ><fo:table-cell><fo:block> </fo:block></fo:table-cell></fo:table-row></fo:table-body>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="pdftablebody"/>
</xsl:otherwise>
</xsl:choose>
</fo:table>
<!--<fo:block break-after="page"> </fo:block>-->
</xsl:template>


<xsl:template name="pdftablebody">
<fo:table-body>
<xsl:variable name="erglevelmax">
<xsl:if test="count(sqlerg/row/col [ f_name = 'ebene' ]) &gt; 0">
<xsl:choose>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '4']) &gt; 0">
<xsl:text>4</xsl:text>
</xsl:when>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '3']) &gt; 0">
<xsl:text>3</xsl:text>
</xsl:when>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '2']) &gt; 0">
<xsl:text>2</xsl:text>
</xsl:when>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '1']) &gt; 0">
<xsl:text>1</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>5</xsl:text>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:variable>
<xsl:call-template name="pdftablerows">
<xsl:with-param name="erglevelmax">$erglevelmax</xsl:with-param>
</xsl:call-template>

</fo:table-body>
</xsl:template>

<xsl:template name="pdftablerows">
<xsl:param name="erglevelmax"/>
<xsl:for-each select="sqlerg/row">
<xsl:call-template name="pdfsinglerow"><xsl:with-param name="erglevelmax">$erglevelmax</xsl:with-param></xsl:call-template>
</xsl:for-each>
</xsl:template>

<xsl:template name="pdfsinglerow">
<xsl:param name="erglevelmax"/>
<fo:table-row>
<xsl:choose>
<!-- <xsl:when test="col/f_name  = 'ebene'">

<xsl:choose>
<xsl:when test="6-$erglevelmax+col[ f_name = 'ebene' ] /wert='1'"> 
<xsl:attribute name="background-color"><xsl:text>#cccccc</xsl:text></xsl:attribute>
<xsl:attribute name="border-width"><xsl:text>1mm</xsl:text></xsl:attribute>
</xsl:when>
<xsl:when test="6-$erglevelmax+col[ f_name = 'ebene' ] /wert='2'"> 
<xsl:attribute name="border-width"><xsl:text>1mm</xsl:text></xsl:attribute>
</xsl:when>
<xsl:when test="6-$erglevelmax+col[ f_name = 'ebene' ] /wert='3'"> 
<xsl:attribute name="border-width"><xsl:text>0.5mm</xsl:text></xsl:attribute>
<xsl:attribute name="background-color"><xsl:text>#cccccc</xsl:text></xsl:attribute>
</xsl:when>
<xsl:when test="6-$erglevelmax+col[ f_name = 'ebene' ] /wert='4'"> 
<xsl:attribute name="background-color"><xsl:text>#e6e6e6</xsl:text></xsl:attribute>
<xsl:attribute name="border-width"><xsl:text>0.5mm</xsl:text></xsl:attribute>
</xsl:when>
<xsl:when test="6-$erglevelmax+ col[ f_name = 'ebene' ] /wert='5'"> 
<xsl:attribute name="background-color"><xsl:text>#e6e6e6</xsl:text></xsl:attribute>
</xsl:when>
<xsl:otherwise>

</xsl:otherwise>
</xsl:choose>
</xsl:when> -->

<xsl:when test="col [f_name  = 'struktur'] /wert='Trgerschaft'">
<xsl:attribute name="background-color"><xsl:text>#cccccc</xsl:text></xsl:attribute>
<xsl:attribute name="font-weight"><xsl:text>bold</xsl:text></xsl:attribute>
<xsl:attribute name="height"><xsl:text>1.5em</xsl:text></xsl:attribute>
</xsl:when>
<xsl:when test="col [f_name  = 'struktur'] /wert='Studienabschnitt'">
<xsl:attribute name="background-color"><xsl:text>#e8e8e8</xsl:text></xsl:attribute>
<xsl:attribute name="font-weight"><xsl:text>bold</xsl:text></xsl:attribute>
<xsl:attribute name="height"><xsl:text>1.3em</xsl:text></xsl:attribute>
</xsl:when>

<xsl:when test="col [f_name  = 'struktur'] /wert='Fchergruppe'">
<xsl:attribute name="font-weight"><xsl:text>bold</xsl:text></xsl:attribute>
<xsl:attribute name="height"><xsl:text>2em</xsl:text></xsl:attribute>
</xsl:when>


<xsl:when test="@issumme='true'">
<xsl:attribute name="background-color"><xsl:text>#cccccc</xsl:text></xsl:attribute>
<xsl:attribute name="border-width"><xsl:text>1mm</xsl:text></xsl:attribute>
</xsl:when>
<xsl:otherwise>
<xsl:choose>
<xsl:when test="@no mod 2 = 1">
<xsl:attribute name="background-color"><xsl:text>#EFEFEF</xsl:text></xsl:attribute>
</xsl:when>
<xsl:when test="@no mod 2 = 0">
<xsl:attribute name="background-color"><xsl:text>#FFFFFF</xsl:text></xsl:attribute>
</xsl:when>
</xsl:choose>
</xsl:otherwise>
</xsl:choose>
<xsl:text>
</xsl:text>
<xsl:for-each select="col[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false ]">
           <xsl:call-template name="pdftablecell" /><xsl:text>
</xsl:text>

</xsl:for-each>
</fo:table-row><xsl:text>
</xsl:text>
</xsl:template>

<xsl:template name="pdfcolumnwidths">
<xsl:variable name="gesamtbreite_str">
<xsl:text>0</xsl:text>
<!--MB 4/2010 keine Link oder versteckten SPalten-->
<xsl:for-each select="sqlerg/headers/header[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false ]">
<xsl:text>+</xsl:text><xsl:value-of select="@width" />
</xsl:for-each>
</xsl:variable>
                                                                      <!--MB 10.6.09 keine Linkspalten-->
<xsl:variable name="defbreite" ><xsl:value-of select="sum(sqlerg/headers/header[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and @width &gt; 0 and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false ]/@width )" /></xsl:variable> 
<xsl:variable name="ndefbreite" ><xsl:value-of select="count(sqlerg/headers/header[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and @width = '' and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false])" /></xsl:variable> 
<xsl:variable name="gesamtbreite" ><xsl:value-of select="$defbreite+($ndefbreite* $std_spaltenbreite)" /></xsl:variable> 

<xsl:for-each select="sqlerg/headers/header[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false ]">
<xsl:text>
</xsl:text>
<xsl:comment><xsl:value-of select="$defbreite" /></xsl:comment> 
<fo:table-column>
<xsl:attribute name="column-width">
<xsl:choose>

<xsl:when test="@width != ''" >

<xsl:variable name="spbreite"><xsl:value-of select="$druckbreite_mm*(@width div $gesamtbreite)" />
</xsl:variable>
<xsl:choose>
<xsl:when test="$spbreite &gt; 2" >
<xsl:value-of select="concat($spbreite,'mm')" />
</xsl:when>
<xsl:otherwise >
<xsl:text>auto</xsl:text>
</xsl:otherwise>
</xsl:choose>

</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$druckbreite_mm*($std_spaltenbreite div $gesamtbreite)" />
</xsl:otherwise>
</xsl:choose>
</xsl:attribute>
<!--
<xsl:attribute name="column-number">
<xsl:value-of select="(@id+1)" />
</xsl:attribute>-->
</fo:table-column> 

</xsl:for-each>
</xsl:template>

<xsl:template name="pdftabletitle">
<fo:block font-family="{$font_family}" line-height="14pt" font-size="14pt" font-weight="bold" color="rgb(0,0,0)"  space-after="0mm">
<xsl:value-of select="../maskenname" /></fo:block>

</xsl:template>

<xsl:template name="pdflogo">
<fo:block font-family="{$font_family}" line-height="10pt" font-size="10pt" font-weight="bolder"  color="rgb(0,0,0)" margin-bottom="10mm" text-align="end" space-after="5mm">
<fo:external-graphic>
<!-- im Servlet steht:
foUserAgent.setBaseURL("file:///"+ getServletConfig().getServletContext().getRealPath("/") );-->
<xsl:attribute name="src"><xsl:text>servlet/</xsl:text><xsl:call-template name="logo_path"></xsl:call-template></xsl:attribute>
</fo:external-graphic></fo:block>
</xsl:template>



<xsl:template name="pdftableheaders">
<xsl:param name="caption" select="''"/>
<fo:table-header>
<xsl:if test="$caption != ''">
<fo:table-row>
<fo:table-cell  border-width="0.5mm" padding="1px" border-style="solid" number-columns-spanned="{count(sqlerg/headers/header)-1}">
<fo:block text-align="center" font-size="8pt" language="en" hyphenate="true">
<xsl:value-of select="$caption"/>
</fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:if>
<!--Spaltenberschriften: zunchst wird geprft, ob Spaltenberschriften verknpft werden sollen -->
<xsl:variable name="spanned_cols"> 
<xsl:for-each select="sqlerg/headers/header">
<xsl:if test="contains(wert,'\000')"> 
    <xsl:text>true</xsl:text>
</xsl:if>
</xsl:for-each>
</xsl:variable>
<xsl:choose>
<xsl:when test="sqlerg/headers/@hasAggregationHeaders='true'">
<xsl:for-each select="sqlerg/aggregationHeaders">
<xsl:for-each select="tr">
<fo:table-row>
<xsl:for-each select="th [ starts-with(@f_name,'struktur') = false and starts-with(@f_name,'ebene') = false and @isHidden='false' and starts-with(@f_name,'next') = false] ">
<fo:table-cell  border-width="0.5mm" padding="1mm" border-style="solid">
<xsl:if test="@rowspan != ''">
<xsl:attribute name="number-rows-spanned"><xsl:value-of select="@rowspan" /></xsl:attribute>
</xsl:if>
<xsl:if test="@colspan != ''">
<xsl:attribute name="number-columns-spanned"><xsl:value-of select="@colspan" /></xsl:attribute>
</xsl:if>
<!--language =en wg. hyphenation-->
<fo:block margin="1px" text-align="center" font-size="8pt" language="en" hyphenate="true"><!-- hyphenation raus, fop kommt sonst in Endlosschleife -->
<xsl:call-template name="removeBackslashN" >
    <xsl:with-param name="derwert"><xsl:value-of select="." /></xsl:with-param>
    <xsl:with-param name="format"><xsl:value-of select="'html'" /></xsl:with-param>
    </xsl:call-template>
</fo:block> 

</fo:table-cell><xsl:text>
</xsl:text>
</xsl:for-each>
</fo:table-row><xsl:text>
</xsl:text>
</xsl:for-each>
</xsl:for-each>
</xsl:when>
<xsl:otherwise>
<!--Normale headers-->
<!-- <xsl:if test="count(th [ starts-with(@f_name,'struktur') = false and starts-with(@f_name,'ebene') = false and @isHidden='false' and starts-with(@f_name,'next') = false] ) &gt; 0"> -->
<fo:table-row>
<xsl:for-each select="sqlerg/headers/header[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false ]">


<xsl:call-template name="foheader_tab3">
    <xsl:with-param name="derwert" select="wert" />
    </xsl:call-template>

    
<!-- <xsl:if test="../../../ergebniselement [@id!=18800]">
<xsl:call-template name="foheader">
    <xsl:with-param name="derwert" select="wert" />
    </xsl:call-template>
</xsl:if> -->
    <xsl:text>
</xsl:text>

</xsl:for-each>
</fo:table-row>
<!-- </xsl:if> -->
</xsl:otherwise>
</xsl:choose>

</fo:table-header>
</xsl:template>



<xsl:template name="pdftablecell">
<fo:table-cell border-width="0.1mm" border-style="solid"  padding-left="0.5mm"   padding-right="0.5mm">
<fo:block font-size="8pt" font-family="{$font_family}" line-height="8pt" margin-top="1px" margin-bottom="1px" margin-left="1px" margin-right="1px" space-before.optimum="6pt" space-after.optimum="6pt"
 language="en" hyphenate="true">
  <xsl:variable name="checkname"><xsl:value-of select="concat('hidden',f_name,'dp')"/></xsl:variable>
    <xsl:choose>
  	<xsl:when test="@typ='2' or @typ='8' or @typ='3'"> <!-- DecimalFormat -->
		<xsl:attribute name="text-align">end</xsl:attribute>
		 <xsl:choose>         <!--MB wenn es eine versteckte hidden_decimalpl gibt auswerten-->
       <xsl:when test="../col[f_name=$checkname]/wert='0'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.###','German')" />
     </xsl:when>
      <xsl:when test="../col[f_name=$checkname]/wert='1'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,0','German')" />
     </xsl:when>
     <xsl:when test="../col[f_name=$checkname]/wert='2'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,00','German')" />
     </xsl:when>
     <xsl:when test="../col[f_name=$checkname]/wert='3'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,000','German')" />
     </xsl:when>
     <xsl:when test="../col[f_name=$checkname]/wert='4'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,0000','German')" />
     </xsl:when>
     <xsl:when test="../col[f_name=$checkname]/wert='5'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,00000','German')" />
     </xsl:when>
      <xsl:when test="../col[f_name=$checkname]/wert='6'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,000000','German')" />
     </xsl:when>
     <xsl:otherwise>
    <xsl:value-of select="format-number(wert,'###.###.###.###.##0,0','German')" />
   </xsl:otherwise>
   </xsl:choose>
	</xsl:when>
	<xsl:when test="@typ='4'"> <!-- Integer -->
	<xsl:attribute name="text-align">end</xsl:attribute>
		<!--<xsl:attribute name="class">integer</xsl:attribute>-->
		<!--<xsl:value-of select="wert" />-->
		<xsl:value-of select="format-number(wert,'###.###.###.###.###','German')" />
	</xsl:when>
	<xsl:otherwise>
	<!--Typ=1 ist string und wird defaultmig behandelt -->
	<xsl:attribute name="text-align">start</xsl:attribute>
	<xsl:choose>
		<xsl:when test="f_name='email'">
		
		<xsl:value-of select="wert" />
		</xsl:when>
		<xsl:when test="f_name='url'">
			<!--<a target="_blank"><xsl:attribute name="href"><xsl:value-of select="wert" /></xsl:attribute>-->
			<xsl:value-of select="wert" /><!--</a>-->
			</xsl:when>
		<xsl:when test="f_name='nextmask'">
			</xsl:when>
		<xsl:when test="f_name='nexttable'">
		</xsl:when>
		<xsl:otherwise>
        		<xsl:value-of select="wert" />
		</xsl:otherwise>
	</xsl:choose>
</xsl:otherwise>
</xsl:choose>
              </fo:block>
	     
          </fo:table-cell><xsl:text>
</xsl:text>
</xsl:template>
<!-- end template-->
<!-- start legende-->
<xsl:template name="legende_fo">
<fo:block font-family="{$font_family}" line-height="20pt" font-size="10pt" margin-bottom="10px"> <!-- border-width="0.5mm" border-style="solid" border-color="gray" space-after="10mm"  -->
<xsl:for-each select="../felder/feld">
	<xsl:if test="(value !='' or sicht/@isFirstInGroup='false' or @isstandtoday='false')  and @varname != 'sort' and @varname != 'maxoffset'">
	<fo:inline>
		<xsl:choose>
		<xsl:when test="string-length(caption_short) &gt; 0 and caption_short != 'null'" >
		<![CDATA[]]><xsl:value-of select="caption_short" /><![CDATA[]]>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="@varname" />
		</xsl:otherwise>
		</xsl:choose></fo:inline><fo:inline>:&#160;</fo:inline>
		<fo:inline> <!--  font-style="italic" font-weight="bold"> -->
		<![CDATA[]]><xsl:value-of select="value_caption" /><![CDATA[]]>

		;&#160;</fo:inline>
		
		
	</xsl:if>
	
</xsl:for-each>
<xsl:text>User: </xsl:text><xsl:value-of select="/ergebnisse/user" />
<!-- <xsl:text>; Stand: </xsl:text><xsl:value-of select="../stand" /> -->
</fo:block>
</xsl:template>
<!-- end legende-->
<!--start foheader-->
<xsl:template name="foheader">
<xsl:param name="derwert" /> 
<fo:table-cell border-width="0.5mm" border-style="solid"><xsl:text>
</xsl:text>
                                     <fo:block margin="1px" font-size="8pt" 
                                         
					  language="en" hyphenate="true">
                                         <xsl:variable name="header1"> 
	<xsl:choose>
		<xsl:when test="(contains(string($derwert),'\n'))">
		<xsl:value-of select="substring-before($derwert,'\n') "/>
		 <xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($derwert,'\n') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:copy-of select="$derwert" />
		</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
	<xsl:variable name="header2"> 
	<xsl:choose>
		<xsl:when test="(contains(string($header1),'\n'))">
		<xsl:value-of select="substring-before($header1,'\n') "/>
		<xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($header1,'\n') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="$header1" />
		</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test="(contains(string($header2),'\000'))">
		<xsl:value-of select="substring-before($header2,'\000') "/>
		<xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($header2,'\000') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="$header2" />
		</xsl:otherwise>
	</xsl:choose><xsl:text>
</xsl:text>
</fo:block>
</fo:table-cell><xsl:text>
</xsl:text>

</xsl:template>




<xsl:template name="foheader_tab3">
<xsl:param name="derwert" /> 
<fo:table-cell border-width="0.5mm" border-style="solid"><xsl:text>
</xsl:text>
                                     <fo:block margin="1px" font-size="8pt" 
                                         
					  language="en" text-align="center" hyphenate="true">
                                         <xsl:variable name="header1"> 
	<xsl:choose>
		<xsl:when test="(contains(string($derwert),'\n'))">
		<xsl:value-of select="substring-before($derwert,'\n') "/>
		 <xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($derwert,'\n') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:copy-of select="$derwert" />
		</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
	<xsl:variable name="header2"> 
	<xsl:choose>
		<xsl:when test="(contains(string($header1),'\n'))">
		<xsl:value-of select="substring-before($header1,'\n') "/>
		<xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($header1,'\n') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="$header1" />
		</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test="(contains(string($header2),'\000'))">
		<xsl:value-of select="substring-before($header2,'\000') "/>
		<xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($header2,'\000') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="$header2" />
		</xsl:otherwise>
	</xsl:choose><xsl:text>
</xsl:text>
</fo:block>
</fo:table-cell><xsl:text>
</xsl:text>

</xsl:template>







<!--end foheader-->
<xsl:template name="page_master">
<xsl:param name="master_name" />
<fo:simple-page-master master-name="{$master_name}"
                     page-height="210mm" page-width="{concat($seitenbreite_mm,'mm')}"
                     margin-top="10mm" margin-bottom="14mm"
                     margin-left="15mm" margin-right="15mm"> 

                     <fo:region-body 
                       margin-top="20mm" margin-bottom="15mm"
                       margin-left="0mm" margin-right="0mm"
		     />
		     <fo:region-before extent="40mm"  region-name="{concat($master_name,'-before')}" />
                     <fo:region-after extent="10mm"  region-name="{concat($master_name,'-after')}"/>
                 </fo:simple-page-master>
		 </xsl:template>
<xsl:template name="page_master_zweispaltig">
<xsl:param name="master_name" />
<fo:simple-page-master master-name="{$master_name}"
                     page-height="210mm" page-width="{concat($seitenbreite_mm,'mm')}"
                     margin-top="10mm" margin-bottom="14mm"
                     margin-left="15mm" margin-right="15mm"> 

                     <fo:region-body 
                       margin-top="20mm" margin-bottom="15mm"
                       margin-left="0mm" margin-right="0mm"
		       column-count="2" column-gap="0.25in"
		     />
		     <fo:region-before extent="40mm"  region-name="{concat($master_name,'-before')}" />
                     <fo:region-after extent="10mm"  region-name="{concat($master_name,'-after')}"/>
                 </fo:simple-page-master>
		 </xsl:template>
<xsl:template name="kopf_fusszeile">
<xsl:param name="nummer" />
<xsl:param name="caption" />

<fo:static-content flow-name="{concat('tabelle_',$nummer,'-before')}">
  <fo:block-container position="absolute" left="0mm" top="0mm" width="120mm" height="15mm">
  <fo:block font-family="{$font_family}">Ministerium fr Wissenschaft und Forschung</fo:block>
  <fo:block font-family="{$font_family}"> - Abteilung II Referat 1 - </fo:block>
   </fo:block-container>
   <fo:block-container position="absolute" left="120mm" top="0mm" width="80mm" height="15mm">
  <fo:block font-family="{$font_family}">Studierendenstatistik</fo:block>
  <fo:block font-family="{$font_family}"><xsl:value-of select="/ergebnisse/ergebnis/felder/feld[@varname='Semester']/value_caption" /></fo:block>
   </fo:block-container>
   <fo:block-container position="absolute" left="235mm" top="0mm" width="60mm" height="15mm">
  <fo:block font-family="{$font_family}">Stand: <xsl:value-of select="substring(/ergebnisse/ergebnis/felder/feld[@varname='Datum']/value,2,10)" /></fo:block>
  <fo:block font-family="{$font_family}">Tabelle <xsl:value-of select="$nummer"/></fo:block>
  <fo:block font-family="{$font_family}">Seite: <fo:page-number /> </fo:block>
   </fo:block-container>
   <fo:block-container position="absolute" left="0mm" top="15mm" width="290mm" height="15mm">
  <fo:block font-family="{$font_family}" font-weight="bold" text-align="center"><xsl:value-of select="$caption" /></fo:block>
   </fo:block-container>
  </fo:static-content>
  
    
  <fo:static-content flow-name="{concat('tabelle_',$nummer,'-after')}">

  </fo:static-content>
</xsl:template>
<xsl:template name="Deckblatt">
<xsl:param name="semester" />
<xsl:variable name="jahrestext">
<xsl:value-of select="substring($semester,1,4)"/>
<xsl:if test="substring($semester,5,1)='2'">
<xsl:value-of select="concat('/',string(number(substring($semester,1,4))+1))"/>
</xsl:if>
</xsl:variable>
<xsl:variable name="semestertext">
<xsl:choose>
<xsl:when test="substring($semester,5,1)='1'">
<xsl:text>Sommersemester</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>Wintersemester</xsl:text>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>


<fo:page-sequence master-name="Deckblatt" master-reference="Deckblatt">
  <fo:flow flow-name="xsl-region-body">
  <fo:block-container position="absolute" left="30mm" top="20mm" width="120mm" height="50mm">
 <fo:block font-family="{$font_family}" line-height="15pt" font-size="20pt" font-weight="bold">
     <xsl:text>Hochschulen fr angewandte Wissenschaften</xsl:text>
    </fo:block>
    </fo:block-container>
    <fo:block-container position="absolute" left="30mm" top="40mm" width="120mm" height="50mm">
 <fo:block font-family="{$font_family}" line-height="15pt" font-size="20pt" font-weight="bold">
     <xsl:text>Baden-Wrttembergs</xsl:text>
    </fo:block>
    </fo:block-container>
    <fo:block-container position="absolute" left="30mm" top="50mm" width="120mm" height="50mm">
 <fo:block font-family="{$font_family}" line-height="15pt" font-size="20pt" font-weight="bold"
  border-top-color="black"
          border-top-style="solid"
          border-top-width="thick"
>
     <xsl:text>                                                   </xsl:text> 
    </fo:block>
    </fo:block-container>
     <fo:block-container position="absolute" left="30mm" top="60mm" width="120mm" height="50mm">
 <fo:block font-family="{$font_family}" line-height="15pt" font-size="20pt" font-weight="bold">
 <fo:inline letter-spacing="3pt"><xsl:text>Studierendenstatistik</xsl:text></fo:inline>
      
    </fo:block>
    </fo:block-container>
  <fo:block-container position="absolute" left="30mm" top="80mm" width="120mm" height="50mm">
 <fo:block font-family="{$font_family}" line-height="15pt" font-size="20pt" font-weight="bold">
     <xsl:value-of select="concat($semestertext,' ', $jahrestext)" />
    </fo:block>
    </fo:block-container>
  <!--Seite 2-->
  <fo:block font-family="{$font_family}" line-height="15pt" font-size="20pt" font-weight="bold" break-before="page">
  <fo:inline text-transform="uppercase"><xsl:text>Vorbemerkungen</xsl:text></fo:inline>
  
  </fo:block>
  <fo:block font-family="{$font_family}" margin-top="2em">Definitionen</fo:block>
  <fo:list-block margin-top="2em">
<fo:list-item>
<fo:list-item-label end-indent="label-end()"><fo:block  font-family="{$font_family}"><xsl:text>- </xsl:text></fo:block></fo:list-item-label>
<fo:list-item-body start-indent="body-start()"><fo:block  font-family="{$font_family}"><xsl:text>Studierende: Alle Haupt-, Neben- und Zweithrer im ersten Studiengang und ersten Fach, ohne Beurlaubte, ohne vor dem Stichtag Exmatrikulierte</xsl:text></fo:block></fo:list-item-body>
</fo:list-item>
<fo:list-item>
<fo:list-item-label end-indent="label-end()"><fo:block  font-family="{$font_family}"><xsl:text>- </xsl:text></fo:block></fo:list-item-label>
<fo:list-item-body start-indent="body-start()"><fo:block  font-family="{$font_family}"><xsl:text>Studienanfnger: Von der Gruppe der Studierenden nur diejenigen, die sich in einem grundstndigen Studiengang (d.h. kein Master-Studiengang) mit der Studienform "Erststudium" eingeschrieben haben (Erst- oder Neueinschreibung)</xsl:text></fo:block></fo:list-item-body>
</fo:list-item>
<fo:list-item>
<fo:list-item-label end-indent="label-end()"><fo:block  font-family="{$font_family}"><xsl:text>- </xsl:text></fo:block></fo:list-item-label>
<fo:list-item-body start-indent="body-start()"><fo:block  font-family="{$font_family}"><xsl:text>Studierende im 1. Studiensemester: Von der Gruppe der Studierenden nur diejenigen, die sich im ersten Fachsemester befinden</xsl:text></fo:block></fo:list-item-body>
</fo:list-item>
<fo:list-item>
<fo:list-item-label end-indent="label-end()"><fo:block  font-family="{$font_family}"><xsl:text>- </xsl:text></fo:block></fo:list-item-label>
<fo:list-item-body start-indent="body-start()"><fo:block  font-family="{$font_family}"><xsl:text>Einschreibungen: Von der Gruppe der Studierenden nur diejenigen, die sich eingeschrieben haben (Erst- oder Neueinschreibung)</xsl:text></fo:block></fo:list-item-body>
</fo:list-item>

</fo:list-block>

 						

  <xsl:if test="count(/ergebnisse/ergebnis/ergebniselement [@id='18840']) &gt; 3">
   
  <!--<fo:block-container position="absolute" left="170mm" top="150mm" width="60mm" height="50mm">
  <fo:block font-family="{$font_family}">
  <xsl:text>Bereitgestellt vom HSZ-BW</xsl:text>
</fo:block>
 <fo:block font-family="{$font_family}">
  <fo:external-graphic src="../xml/kenn/hsz-banner.gif">
</fo:external-graphic>
</fo:block>
</fo:block-container>-->
</xsl:if>
<fo:block-container position="absolute" left="230mm" top="0mm" width="60mm" height="50mm">
 <fo:block font-family="{$font_family}">
  <fo:external-graphic>
<!-- im Servlet steht:
foUserAgent.setBaseURL("file:///"+ getServletConfig().getServletContext().getRealPath("/") );-->
<xsl:attribute name="src"><xsl:call-template name="logo_path"></xsl:call-template></xsl:attribute>
</fo:external-graphic>
</fo:block>
</fo:block-container>
    </fo:flow>
    </fo:page-sequence>
</xsl:template>
<xsl:template name="TOC">
<fo:page-sequence master-name="TOC" master-reference="TOC">
  <fo:flow flow-name="xsl-region-body">
  <fo:block font-family="{$font_family}" line-height="15pt" font-size="20pt" font-weight="bold">
     <xsl:text>Inhaltsverzeichnis</xsl:text>
    </fo:block>
     <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Abkuerzungen'"/>
   <xsl:with-param name="caption" select="'Abkrzungen'" />
      </xsl:call-template>
 <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Faecher'"/>
   <xsl:with-param name="caption" select="'Studienfcher (alphabetisch)'" />
      </xsl:call-template>

    <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Tabelle_1'"/>
   <xsl:with-param name="caption" select="concat($header_tab1_short,' ',$header_tab1_long)" />
      </xsl:call-template>
    <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Tabelle_2'"/>
   <xsl:with-param name="caption" select="concat($header_tab2_short,' ',$header_tab2_long)" />
      </xsl:call-template>
    <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Tabelle_3'"/>
   <xsl:with-param name="caption" select="concat($header_tab3_short,' ',$header_tab3_long)" />
      </xsl:call-template>
    <fo:block font-family="{$font_family}"><xsl:value-of select="concat($header_tab4_short,' ',$header_tab4_long)" /></fo:block>
 
   <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Tabelle_4a'"/>
   <xsl:with-param name="caption" select="$studis_alle" />
   <xsl:with-param name="level" select="'2'"/>
      </xsl:call-template>
   <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Tabelle_4b'"/>
   <xsl:with-param name="caption" select="$studis_einschr12" />
   <xsl:with-param name="level" select="'2'"/>
      </xsl:call-template>
   <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Tabelle_4c'"/>
   <xsl:with-param name="caption" select="$studis_1fs" />
   <xsl:with-param name="level" select="'2'"/>
      </xsl:call-template>
   <fo:block font-family="{$font_family}"><xsl:value-of select="concat($header_tab5_short,' ',$header_tab5_long)" /></fo:block>
 

      
    <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Tabelle_5a'"/>
   <xsl:with-param name="caption" select="$studis_alle" />
   <xsl:with-param name="level" select="'2'"/>
      </xsl:call-template>
   <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Tabelle_5b'"/>
   <xsl:with-param name="caption" select="$studis_einschr12" />
   <xsl:with-param name="level" select="'2'"/>
      </xsl:call-template>
   <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Tabelle_5c'"/>
   <xsl:with-param name="caption" select="$studis_1fs" />
   <xsl:with-param name="level" select="'2'"/>
      </xsl:call-template>
   <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Tabelle_6'"/>
   <xsl:with-param name="caption" select="concat($header_tab6_short,' ',$header_tab6_long)" />
    </xsl:call-template>
    <xsl:call-template name="TOC_entry">
   <xsl:with-param name="target_id" select="'anchor_Tabelle_7'"/>
   <xsl:with-param name="caption" select="concat($header_tab7_short,' ',$header_tab7_long)" />
    </xsl:call-template>
  <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18840']">
    <xsl:if test="../felder/feld[@varname='Hochschule']/value !=''">
    <xsl:call-template name="TOC_entry_hsnr">
<xsl:with-param name="target_id" select="concat('anchor_Tabelle_7_',../felder/feld[@varname='Hochschule']/value)"/>
<xsl:with-param name="caption" select="../felder/feld[@varname='Hochschule']/value_caption"/>
<xsl:with-param name="level" select="'2'"/>
<xsl:with-param name="hsnr" select="../felder/feld[@varname='Hochschule']/value"/>
</xsl:call-template>
</xsl:if>
</xsl:for-each>


    </fo:flow>
    </fo:page-sequence>
</xsl:template>
<xsl:template name="abkuerzungen">
<fo:page-sequence master-name="abkuerzungen" master-reference="abkuerzungen">
<fo:static-content flow-name="abkuerzungen-before">
  <fo:block-container position="absolute" left="235mm" top="0mm" width="60mm" height="15mm">
  
  <fo:block font-family="{$font_family}">Seite: <fo:page-number /> </fo:block>
   </fo:block-container>
   <fo:block-container position="absolute" left="0mm" top="15mm" width="290mm" height="15mm">
  <fo:block font-family="{$font_family}" font-weight="bold" text-align="center"><xsl:value-of select="$header_abkuerzungen" /></fo:block>
   </fo:block-container>
   </fo:static-content>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Abkuerzungen'"/>
  </xsl:call-template>
  <fo:block font-family="{$font_family}" line-height="15pt" font-size="20pt" font-weight="bold">
     <xsl:text> </xsl:text>
    </fo:block>
      <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18900']">
    
       <xsl:call-template name="pdftable">
       <xsl:with-param name="caption" select="''">
       </xsl:with-param>
       </xsl:call-template>
       
   </xsl:for-each>
    </fo:flow>
    </fo:page-sequence>
</xsl:template>
<xsl:template name="faecher">
<fo:page-sequence master-name="faecher" master-reference="faecher">
<fo:static-content flow-name="faecher-before">
  <fo:block-container position="absolute" left="235mm" top="0mm" width="60mm" height="15mm">
  
  <fo:block font-family="{$font_family}">Seite: <fo:page-number /> </fo:block>
   </fo:block-container>
   <fo:block-container position="absolute" left="0mm" top="10mm" width="240mm" height="15mm">
  <fo:block font-family="{$font_family}" font-weight="bold" text-align="center"><xsl:value-of select="$header_faecher" /></fo:block>
   </fo:block-container>
   </fo:static-content>
  <fo:flow flow-name="xsl-region-body">
  <xsl:call-template name="TOC_Anchor">
<xsl:with-param name="id" select="'anchor_Faecher'"/>
  </xsl:call-template>
      <xsl:for-each select="ergebnisse/ergebnis/ergebniselement [@id='18920']">
       <xsl:call-template name="faecherliste">
       <xsl:with-param name="colid" select="'1'">
       </xsl:with-param>
       </xsl:call-template>
   </xsl:for-each>
    </fo:flow>
    </fo:page-sequence>
</xsl:template>
<xsl:template name="faecherliste">
<xsl:param name="colid" />
<fo:list-block>
<xsl:for-each select="sqlerg/row [col[@id='3']/wert='Fach (amtlich)']">
<fo:list-item>
<fo:list-item-label end-indent="label-end()"><fo:block  font-family="{$font_family}"><xsl:text>- </xsl:text></fo:block></fo:list-item-label>
<fo:list-item-body start-indent="body-start()"><fo:block  font-family="{$font_family}"><xsl:value-of select="col[@id=$colid]/wert" /></fo:block></fo:list-item-body>
</fo:list-item>
</xsl:for-each>
</fo:list-block>
</xsl:template>
<xsl:template name="TOC_Anchor">
<xsl:param name="id" />
<xsl:param name="caption" select="''"/>
  <fo:block id="{$id}">
   <fo:marker marker-class-name="Tabelle">
    <xsl:value-of select="$id"/>
   </fo:marker>
   <xsl:value-of select="$caption"/>
   </fo:block>

   </xsl:template>
   <xsl:template name="TOC_entry">
   <xsl:param name="target_id" />
   <xsl:param name="caption" />
   <xsl:param name="level" select="'1'"/>
   <xsl:variable name="indent">
   <xsl:value-of select="(number($level)-1) * 30" />
   </xsl:variable>
   <fo:block font-family="{$font_family}" 
   margin-left="{concat($indent,'pt')}" text-align-last="justify">
   <fo:basic-link internal-destination="{$target_id}">
    <xsl:value-of select="$caption"/>
  <!--<xsl:call-template name="get_hochschulname_lang">
  <xsl:with-param name="key_apnr" select="$target_id" />
  </xsl:call-template>-->
    <fo:leader leader-pattern="dots"/>
    <fo:page-number-citation ref-id="{$target_id}"/>
   </fo:basic-link>
  </fo:block>
  </xsl:template>
     <xsl:template name="TOC_entry_hsnr">
   <xsl:param name="target_id" />
   <xsl:param name="caption" />
   <xsl:param name="level" select="'1'"/>
   <xsl:param name="hsnr" />
   <xsl:variable name="indent">
   <xsl:value-of select="(number($level)-1) * 30" />
   </xsl:variable>
   <fo:block font-family="{$font_family}" 
   margin-left="{concat($indent,'pt')}" text-align-last="justify">
   <fo:basic-link internal-destination="{$target_id}">
    <xsl:value-of select="../../ergebnis[@ordnr='0']/ergebniselement[@id='18900']/sqlerg/row[col[@id='4']/wert=$hsnr]/col[@id='1']/wert"/>
  <!--<xsl:call-template name="get_hochschulname_lang">
  <xsl:with-param name="key_apnr" select="$target_id" />
  </xsl:call-template>-->
    <fo:leader leader-pattern="dots"/>
    <fo:page-number-citation ref-id="{$target_id}"/>
   </fo:basic-link>
  </fo:block>
  </xsl:template>
  <xsl:template name="get_hochschulname_lang">
   <xsl:param name="key_apnr" />
   <xsl:value-of select="/ergebnisse/ergebnis[@ordnr='0']/ergebniselement[@id='18900']/sqlerg/row[col[@id='4']/wert=$key_apnr]/col[@id='1']/wert"/>
  </xsl:template>
</xsl:stylesheet>

