<?xml version="1.0"  encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">
<xsl:import href="pageComponents_html.xsl" />
<!--In diesem Stylesheet knnen Sie individuelle templates unterbringen,
  die in ihrer Przedenz das normale Stylesheet 
  pageComponents_html.xsl berragt. --> 
<xsl:import href="pageComponents_html_final.xsl" />
<xsl:import href="resultset_html.xsl" />
<xsl:decimal-format name="German" grouping-separator="." NaN="" zero-digit ="0" decimal-separator="," />
<!--Wenn Sie ein eigenes PDF-Stylesheet erstellen, sollten Sie die u. aufgefhrte Routine zur
Berechnung der Spaltenbreite bernehmen
Wenn Sie nur das Seitenlayout ndern wollen, z.B. auf A4, dann reicht es, hier die Variablen seitenbreite_mm,
die druckbreite_mm und das Attribut page-height anzupassen.
-->
<xsl:variable name="seitenbreite_mm">297</xsl:variable>
<!--Die Breite der Tabelle in mm bei A4 Querformat:-->
<xsl:variable name="druckbreite_mm">267</xsl:variable>
<!-- Wenn keine Spaltenbreite definiert ist, wird 12 (Einheit Applet-Breite) verwendet.  -->
<xsl:variable name="std_spaltenbreite">12</xsl:variable>

<xsl:variable name="font_family">Times</xsl:variable>
    <xsl:template match="/">
    <xsl:call-template name="pdfpages"/>
    </xsl:template>
    
    <xsl:template name="pdfpages">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">

<!-- start allg-->
            <fo:layout-master-set>
                 <fo:simple-page-master master-name="first"
                     page-height="210mm" page-width="{concat($seitenbreite_mm,'mm')}"
                     margin-top="10mm" margin-bottom="14mm"
                     margin-left="15mm" margin-right="15mm"> 

                     <fo:region-body
                       margin-top="15mm" margin-bottom="15mm"
                       margin-left="0mm" margin-right="0mm"
		     />
		       <fo:region-before extent="40mm"  region-name="first-region-before" />
                     <fo:region-after extent="10mm"/>
                 </fo:simple-page-master>
		 
		 <fo:simple-page-master master-name="rest"
                     page-height="210mm" page-width="{concat($seitenbreite_mm,'mm')}"
                     margin-top="20mm" margin-bottom="14mm"
                     margin-left="15mm" margin-right="15mm">

                     <fo:region-body
                       margin-top="5mm" margin-bottom="20mm"
                       margin-left="0mm" margin-right="0mm"
		     />
		       <fo:region-before extent="10mm"/>
                     <fo:region-after extent="10mm"/>
                 </fo:simple-page-master>
 
		 <fo:page-sequence-master master-name="sequence">
		     <fo:repeatable-page-master-alternatives>
		     <fo:conditional-page-master-reference master-reference="first" page-position="first"/>
		     <fo:conditional-page-master-reference master-reference="rest" page-position="rest" />
		     </fo:repeatable-page-master-alternatives>
                 </fo:page-sequence-master>
             </fo:layout-master-set>
	     <!-- end allg-->
	     <xsl:call-template name="pdfpage"/>
 
<!-- end Seite-->
</fo:root>
</xsl:template>

<xsl:template name="pdfpage">
 <fo:page-sequence master-name="sequence" master-reference="sequence">
  
  <fo:static-content flow-name="first-region-before">
  <fo:block-container position="absolute" left="0mm" top="0mm" width="120mm" height="15mm">
  <fo:block font-family="{$font_family}">Ministerium fr Wissenschaft und Forschung</fo:block>
  <fo:block font-family="{$font_family}"> - Abteilung II Referat 1 - </fo:block>
   </fo:block-container>
   <fo:block-container position="absolute" left="120mm" top="0mm" width="80mm" height="15mm">
  <fo:block font-family="{$font_family}">Studentenstatistik</fo:block>
  <fo:block font-family="{$font_family}"><xsl:value-of select="/ergebnisse/ergebnis/felder/feld[@varname='Semester']/value_caption" /></fo:block>
   </fo:block-container>
   <fo:block-container position="absolute" left="235mm" top="0mm" width="60mm" height="15mm">
  <fo:block font-family="{$font_family}">Stand: <xsl:value-of select="/ergebnisse/ergebnis/stand" /></fo:block>
  <fo:block font-family="{$font_family}">Tabelle <xsl:if test="/ergebnisse/@isMakro!='true'"><xsl:value-of select='substring(/ergebnisse/ergebnis/maskenname,5,1)'/></xsl:if><xsl:if test="/ergebnisse/@isMakro='true'"><xsl:value-of select='substring(/ergebnisse/makro/name,5,1)'/></xsl:if></fo:block>
  <fo:block font-family="{$font_family}">Seite: <fo:page-number /> von <fo:page-number-citation ref-id="endofdoc" /></fo:block>
   </fo:block-container>
  </fo:static-content>
  
    
  <fo:static-content flow-name="xsl-region-after">

  </fo:static-content>
  
  
  <fo:flow flow-name="xsl-region-body">
   <!-- start Titel -->
   <!-- <xsl:if test="/ergebnisse/makro/@id !=''">
    <fo:block font-family="{$font_family}" line-height="15pt" font-size="15pt" font-weight="bold">
     <xsl:value-of select="/ergebnisse/makro/name" />
    </fo:block>
   </xsl:if>  -->
   <!-- end TItel-->
   <!-- start Tabelle-->
   <xsl:for-each select="ergebnisse/ergebnis/ergebniselement">
    <xsl:choose>
     <xsl:when test="@typ='image'">
      <!-- klappt noch nciht<img>
      <xsl:attribute name="src"><xsl:value-of select="@url" /></xsl:attribute>
      </img>
      <hr/>-->
      <xsl:text>
      </xsl:text>
     </xsl:when>
     <xsl:when test="@typ='tabelle'">
      <xsl:if test="errmsg !=''">
       <fo:block font-family="{$font_family}" line-height="15pt" font-size="15pt"><!---->
        <xsl:copy-of select="errmsg" />
       </fo:block>
      </xsl:if>
      <xsl:call-template name="pdfergebnis"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>Nicht untersttzter Ergebnistyp </xsl:text><xsl:value-of select="@type" />
     </xsl:otherwise>
    </xsl:choose>
    <!-- end Tabelle-->
    <xsl:call-template name="datensatzzaehler" />
   </xsl:for-each>
   <!-- end Tabelle-->
   <xsl:call-template name="pdfaftertable"/>
   <xsl:if test="/ergebnisse/ergebnis/ergebniselement/sqlerg/headers/header [f_name='text' and wert='Studienbereich/Fach']">
    <fo:block font-family="{$font_family}" line-height="8pt" font-size="8pt" margin-top="5mm">1) Studienfcher, die mehrere Studienbereiche betreffen, oder interdisziplinre Studien, die sich keinem einzelnen Fach zuordnen lassen.</fo:block>
    <fo:block font-family="{$font_family}" line-height="8pt" font-size="8pt">2) Studienfach der Lehrerausbildung, das in mehrere Studienbereiche der Fchergruppe bergreift.</fo:block>
    <fo:block font-family="{$font_family}" line-height="8pt" font-size="8pt">3) Regionale Studien, soweit nicht einzelnen Studienbereichen oder anderen Fchergruppen zuzuordnen.</fo:block>
   </xsl:if>
   <!--  Ende des Dokuments zur Ermitttlung der maximalen Seitenzahl  zu Speicherintensiv-->
   <fo:block id="endofdoc" />
  </fo:flow>
 </fo:page-sequence>
</xsl:template>

<xsl:template name="pdfaftertable"/>

<xsl:template name="pdftable">
<xsl:param name="width"/>
<xsl:variable name="tablewidth">
<xsl:choose>
<xsl:when test="$width!=''"><xsl:value-of select="$width"/></xsl:when>
<xsl:otherwise><xsl:text>auto</xsl:text></xsl:otherwise>
</xsl:choose>
</xsl:variable>
<fo:table border="solid" border-collapse="collapse" table-layout="auto" width="$tablewidth"><xsl:text>
</xsl:text>
<xsl:call-template name="pdfcolumnwidths"/>


<xsl:call-template name="pdftableheaders"/>

<!-- start body-->
<xsl:choose>
<xsl:when test="count(sqlerg/row) = 0"><!-- saxon verlangt hier mind. eine Zeile -->
  <fo:table-body><fo:table-row ><fo:table-cell><fo:block> </fo:block></fo:table-cell></fo:table-row></fo:table-body>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="pdftablebody"/>
</xsl:otherwise>
</xsl:choose>
</fo:table>
</xsl:template>


<xsl:template name="pdfergebnis">
<!-- <xsl:call-template name="pdftabletitle"/> -->

  <xsl:if test="/ergebnisse/@isMakro='true'">
  <fo:block text-align="center" margin-top="5mm" font-family="{$font_family}" line-height="15pt" font-size="12pt">
  <xsl:value-of select="../felder/feld [@varname='Hochschule'] /value_caption"/>
  </fo:block>
  </xsl:if>
  
<fo:block margin-bottom="10px"> </fo:block>
<!-- <xsl:call-template name="legende_fo" /> -->

<xsl:call-template name="pdftable"/>
</xsl:template>


<xsl:template name="pdftablebody">
<fo:table-body>
<xsl:variable name="erglevelmax">
<xsl:if test="count(sqlerg/row/col [ f_name = 'ebene' ]) &gt; 0">
<xsl:choose>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '4']) &gt; 0">
<xsl:text>4</xsl:text>
</xsl:when>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '3']) &gt; 0">
<xsl:text>3</xsl:text>
</xsl:when>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '2']) &gt; 0">
<xsl:text>2</xsl:text>
</xsl:when>
<xsl:when test="count(sqlerg/row/col [ f_name = 'ebene' ] /wert [ . = '1']) &gt; 0">
<xsl:text>1</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>5</xsl:text>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:variable>
<xsl:call-template name="pdftablerows">
<xsl:with-param name="erglevelmax">$erglevelmax</xsl:with-param>
</xsl:call-template>

</fo:table-body>
</xsl:template>

<xsl:template name="pdftablerows">
<xsl:param name="erglevelmax"/>
<xsl:for-each select="sqlerg/row">
<xsl:call-template name="pdfsinglerow"><xsl:with-param name="erglevelmax">$erglevelmax</xsl:with-param></xsl:call-template>
</xsl:for-each>
</xsl:template>

<xsl:template name="pdfsinglerow">
<xsl:param name="erglevelmax"/>
<fo:table-row>
<xsl:choose>
<!-- <xsl:when test="col/f_name  = 'ebene'">

<xsl:choose>
<xsl:when test="6-$erglevelmax+col[ f_name = 'ebene' ] /wert='1'"> 
<xsl:attribute name="background-color"><xsl:text>#cccccc</xsl:text></xsl:attribute>
<xsl:attribute name="border-width"><xsl:text>1mm</xsl:text></xsl:attribute>
</xsl:when>
<xsl:when test="6-$erglevelmax+col[ f_name = 'ebene' ] /wert='2'"> 
<xsl:attribute name="border-width"><xsl:text>1mm</xsl:text></xsl:attribute>
</xsl:when>
<xsl:when test="6-$erglevelmax+col[ f_name = 'ebene' ] /wert='3'"> 
<xsl:attribute name="border-width"><xsl:text>0.5mm</xsl:text></xsl:attribute>
<xsl:attribute name="background-color"><xsl:text>#cccccc</xsl:text></xsl:attribute>
</xsl:when>
<xsl:when test="6-$erglevelmax+col[ f_name = 'ebene' ] /wert='4'"> 
<xsl:attribute name="background-color"><xsl:text>#e6e6e6</xsl:text></xsl:attribute>
<xsl:attribute name="border-width"><xsl:text>0.5mm</xsl:text></xsl:attribute>
</xsl:when>
<xsl:when test="6-$erglevelmax+ col[ f_name = 'ebene' ] /wert='5'"> 
<xsl:attribute name="background-color"><xsl:text>#e6e6e6</xsl:text></xsl:attribute>
</xsl:when>
<xsl:otherwise>

</xsl:otherwise>
</xsl:choose>
</xsl:when> -->

<xsl:when test="col [f_name  = 'struktur'] /wert='Studienabschnitt' or col [f_name  = 'struktur'] /wert='Trgerschaft'">
<xsl:attribute name="background-color"><xsl:text>#cccccc</xsl:text></xsl:attribute>
<xsl:attribute name="font-weight"><xsl:text>bold</xsl:text></xsl:attribute>
</xsl:when>


<xsl:when test="@issumme='true'">
<xsl:attribute name="background-color"><xsl:text>#cccccc</xsl:text></xsl:attribute>
<xsl:attribute name="border-width"><xsl:text>1mm</xsl:text></xsl:attribute>
</xsl:when>
<xsl:otherwise>
<xsl:choose>
<xsl:when test="@no mod 2 = 1">
<xsl:attribute name="background-color"><xsl:text>#EFEFEF</xsl:text></xsl:attribute>
</xsl:when>
<xsl:when test="@no mod 2 = 0">
<xsl:attribute name="background-color"><xsl:text>#FFFFFF</xsl:text></xsl:attribute>
</xsl:when>
</xsl:choose>
</xsl:otherwise>
</xsl:choose>
<xsl:text>
</xsl:text>
<xsl:for-each select="col[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false ]">
           <xsl:call-template name="pdftablecell" /><xsl:text>
</xsl:text>

</xsl:for-each>
</fo:table-row><xsl:text>
</xsl:text>
</xsl:template>

<xsl:template name="pdfcolumnwidths">
<xsl:variable name="gesamtbreite_str">
<xsl:text>0</xsl:text>
<!--MB 4/2010 keine Link oder versteckten SPalten-->
<xsl:for-each select="sqlerg/headers/header[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false ]">
<xsl:text>+</xsl:text><xsl:value-of select="@width" />
</xsl:for-each>
</xsl:variable>
                                                                      <!--MB 10.6.09 keine Linkspalten-->
<xsl:variable name="defbreite" ><xsl:value-of select="sum(sqlerg/headers/header[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and @width &gt; 0 and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false ]/@width )" /></xsl:variable> 
<xsl:variable name="ndefbreite" ><xsl:value-of select="count(sqlerg/headers/header[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and @width = '' and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false])" /></xsl:variable> 
<xsl:variable name="gesamtbreite" ><xsl:value-of select="$defbreite+($ndefbreite* $std_spaltenbreite)" /></xsl:variable> 

<xsl:for-each select="sqlerg/headers/header[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false ]">
<xsl:text>
</xsl:text>
<xsl:comment><xsl:value-of select="$defbreite" /></xsl:comment> 
<fo:table-column>
<xsl:attribute name="column-width">
<xsl:choose>

<xsl:when test="@width != ''" >

<xsl:variable name="spbreite"><xsl:value-of select="$druckbreite_mm*(@width div $gesamtbreite)" />
</xsl:variable>
<xsl:choose>
<xsl:when test="$spbreite &gt; 2" >
<xsl:value-of select="concat($spbreite,'mm')" />
</xsl:when>
<xsl:otherwise >
<xsl:text>auto</xsl:text>
</xsl:otherwise>
</xsl:choose>

</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$druckbreite_mm*($std_spaltenbreite div $gesamtbreite)" />
</xsl:otherwise>
</xsl:choose>
</xsl:attribute>
<!--
<xsl:attribute name="column-number">
<xsl:value-of select="(@id+1)" />
</xsl:attribute>-->
</fo:table-column> 

</xsl:for-each>
</xsl:template>

<xsl:template name="pdftabletitle">
<fo:block font-family="{$font_family}" line-height="14pt" font-size="14pt" font-weight="bold" color="rgb(0,0,0)"  space-after="0mm">
<xsl:value-of select="../maskenname" /></fo:block>

</xsl:template>

<xsl:template name="pdflogo">
<fo:block font-family="{$font_family}" line-height="10pt" font-size="10pt" font-weight="bolder"  color="rgb(0,0,0)" margin-bottom="10mm" text-align="end" space-after="5mm">
<fo:external-graphic>
<!-- im Servlet steht:
foUserAgent.setBaseURL("file:///"+ getServletConfig().getServletContext().getRealPath("/") );-->
<xsl:attribute name="src"><xsl:text>servlet/</xsl:text><xsl:call-template name="logo_path"></xsl:call-template></xsl:attribute>
</fo:external-graphic></fo:block>
</xsl:template>



<xsl:template name="pdftableheaders">
<fo:table-header>
<!--Spaltenberschriften: zunchst wird geprft, ob Spaltenberschriften verknpft werden sollen -->
<xsl:variable name="spanned_cols"> 
<xsl:for-each select="sqlerg/headers/header">
<xsl:if test="contains(wert,'\000')"> 
    <xsl:text>true</xsl:text>
</xsl:if>
</xsl:for-each>
</xsl:variable>
<xsl:choose>
<xsl:when test="sqlerg/headers/@hasAggregationHeaders='true'">
<xsl:for-each select="sqlerg/aggregationHeaders">
<xsl:for-each select="tr">
<fo:table-row>
<xsl:for-each select="th [ starts-with(@f_name,'struktur') = false and starts-with(@f_name,'ebene') = false and @isHidden='false' and starts-with(@f_name,'next') = false] ">
<fo:table-cell  border-width="0.5mm" padding="1mm" border-style="solid">
<xsl:if test="@rowspan != ''">
<xsl:attribute name="number-rows-spanned"><xsl:value-of select="@rowspan" /></xsl:attribute>
</xsl:if>
<xsl:if test="@colspan != ''">
<xsl:attribute name="number-columns-spanned"><xsl:value-of select="@colspan" /></xsl:attribute>
</xsl:if>
<!--language =en wg. hyphenation-->
<fo:block margin="1px" text-align="center" font-size="8pt" font-weight="bold" language="en" hyphenate="true"><!-- hyphenation raus, fop kommt sonst in Endlosschleife -->
<xsl:call-template name="removeBackslashN" >
    <xsl:with-param name="derwert"><xsl:value-of select="." /></xsl:with-param>
    <xsl:with-param name="format"><xsl:value-of select="'html'" /></xsl:with-param>
    </xsl:call-template>
</fo:block> 

</fo:table-cell><xsl:text>
</xsl:text>
</xsl:for-each>
</fo:table-row><xsl:text>
</xsl:text>
</xsl:for-each>
</xsl:for-each>
</xsl:when>
<xsl:otherwise>
<!--Normale headers-->
<!-- <xsl:if test="count(th [ starts-with(@f_name,'struktur') = false and starts-with(@f_name,'ebene') = false and @isHidden='false' and starts-with(@f_name,'next') = false] ) &gt; 0"> -->
<fo:table-row>
<xsl:for-each select="sqlerg/headers/header[ starts-with(f_name,'struktur') = false and starts-with(f_name,'ebene') = false and starts-with(f_name,'hidden')=false and starts-with(f_name,'next') = false ]">
<xsl:call-template name="foheader">
    <xsl:with-param name="derwert" select="wert" />
    </xsl:call-template>
    
    <xsl:text>
</xsl:text>

</xsl:for-each>
</fo:table-row>
<!-- </xsl:if> -->
</xsl:otherwise>
</xsl:choose>

</fo:table-header>
</xsl:template>



<xsl:template name="pdftablecell">
<fo:table-cell border-width="0.1mm" border-style="solid"  padding-left="0.5mm"   padding-right="0.5mm">
<fo:block font-size="8pt" font-family="{$font_family}" line-height="8pt" margin-top="1px" margin-bottom="1px" margin-left="1px" margin-right="1px" space-before.optimum="6pt" space-after.optimum="6pt"
 language="en" hyphenate="true">
  <xsl:variable name="checkname"><xsl:value-of select="concat('hidden',f_name,'dp')"/></xsl:variable>
    <xsl:choose>
  	<xsl:when test="@typ='2' or @typ='8' or @typ='3'"> <!-- DecimalFormat -->
		<xsl:attribute name="text-align">end</xsl:attribute>
		 <xsl:choose>         <!--MB wenn es eine versteckte hidden_decimalpl gibt auswerten-->
       <xsl:when test="../col[f_name=$checkname]/wert='0'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.###','German')" />
     </xsl:when>
      <xsl:when test="../col[f_name=$checkname]/wert='1'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,0','German')" />
     </xsl:when>
     <xsl:when test="../col[f_name=$checkname]/wert='2'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,00','German')" />
     </xsl:when>
     <xsl:when test="../col[f_name=$checkname]/wert='3'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,000','German')" />
     </xsl:when>
     <xsl:when test="../col[f_name=$checkname]/wert='4'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,0000','German')" />
     </xsl:when>
     <xsl:when test="../col[f_name=$checkname]/wert='5'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,00000','German')" />
     </xsl:when>
      <xsl:when test="../col[f_name=$checkname]/wert='6'">   
     <xsl:value-of select="format-number(wert,'###.###.###.###.##0,000000','German')" />
     </xsl:when>
     <xsl:otherwise>
    <xsl:value-of select="format-number(wert,'###.###.###.###.##0,0','German')" />
   </xsl:otherwise>
   </xsl:choose>
	</xsl:when>
	<xsl:when test="@typ='4'"> <!-- Integer -->
	<xsl:attribute name="text-align">end</xsl:attribute>
		<!--<xsl:attribute name="class">integer</xsl:attribute>-->
		<!--<xsl:value-of select="wert" />-->
		<xsl:value-of select="format-number(wert,'###.###.###.###.###','German')" />
	</xsl:when>
	<xsl:otherwise>
	<!--Typ=1 ist string und wird defaultmig behandelt -->
	<xsl:attribute name="text-align">start</xsl:attribute>
	<xsl:choose>
		<xsl:when test="f_name='email'">
		
		<xsl:value-of select="wert" />
		</xsl:when>
		<xsl:when test="f_name='url'">
			<!--<a target="_blank"><xsl:attribute name="href"><xsl:value-of select="wert" /></xsl:attribute>-->
			<xsl:value-of select="wert" /><!--</a>-->
			</xsl:when>
		<xsl:when test="f_name='nextmask'">
			</xsl:when>
		<xsl:when test="f_name='nexttable'">
		</xsl:when>
		<xsl:otherwise>
        		<xsl:value-of select="wert" />
		</xsl:otherwise>
	</xsl:choose>
</xsl:otherwise>
</xsl:choose>
              </fo:block>
	     
          </fo:table-cell><xsl:text>
</xsl:text>
</xsl:template>
<!-- end template-->
<!-- start legende-->
<xsl:template name="legende_fo">
<fo:block font-family="{$font_family}" line-height="20pt" font-size="10pt" margin-bottom="10px"> <!-- border-width="0.5mm" border-style="solid" border-color="gray" space-after="10mm"  -->
<xsl:for-each select="../felder/feld">
	<xsl:if test="(value !='' or sicht/@isFirstInGroup='false' or @isstandtoday='false')  and @varname != 'sort' and @varname != 'maxoffset'">
	<fo:inline>
		<xsl:choose>
		<xsl:when test="string-length(caption_short) &gt; 0 and caption_short != 'null'" >
		<![CDATA[]]><xsl:value-of select="caption_short" /><![CDATA[]]>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="@varname" />
		</xsl:otherwise>
		</xsl:choose></fo:inline><fo:inline>:&#160;</fo:inline>
		<fo:inline> <!--  font-style="italic" font-weight="bold"> -->
		<![CDATA[]]><xsl:value-of select="value_caption" /><![CDATA[]]>

		;&#160;</fo:inline>
		
		
	</xsl:if>
	
</xsl:for-each>
<xsl:text>User: </xsl:text><xsl:value-of select="/ergebnisse/user" />
<!-- <xsl:text>; Stand: </xsl:text><xsl:value-of select="../stand" /> -->
</fo:block>
</xsl:template>
<!-- end legende-->
<!--start foheader-->
<xsl:template name="foheader">
<xsl:param name="derwert" /> 
<fo:table-cell border-width="0.5mm" padding-left="1mm" border-style="solid"><xsl:text>
</xsl:text>
                                     <fo:block margin="1px" font-size="8pt" 
                                         font-weight="bold"
					  language="en" hyphenate="true">
                                         <xsl:variable name="header1"> 
	<xsl:choose>
		<xsl:when test="(contains(string($derwert),'\n'))">
		<xsl:value-of select="substring-before($derwert,'\n') "/>
		 <xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($derwert,'\n') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:copy-of select="$derwert" />
		</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
	<xsl:variable name="header2"> 
	<xsl:choose>
		<xsl:when test="(contains(string($header1),'\n'))">
		<xsl:value-of select="substring-before($header1,'\n') "/>
		<xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($header1,'\n') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="$header1" />
		</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test="(contains(string($header2),'\000'))">
		<xsl:value-of select="substring-before($header2,'\000') "/>
		<xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($header2,'\000') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="$header2" />
		</xsl:otherwise>
	</xsl:choose><xsl:text>
</xsl:text>
</fo:block>
</fo:table-cell><xsl:text>
</xsl:text>

</xsl:template>
<!--end foheader-->
</xsl:stylesheet>

