<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="xsl_functions.xsl" />
<xsl:import href="pageComponents_html.xsl" />
<!--In diesem Stylesheet knnen Sie individuelle templates unterbringen,
  die in ihrer Przedenz das normale Stylesheet 
  pageComponents_html.xsl berragt. --> 
<xsl:import href="pageComponents_html_final.xsl" />
<xsl:import href="maskComponents_html.xsl" />
<xsl:import href="levels.xsl" />
<xsl:variable name="useragent" select="'mozilla'" /> 
<xsl:variable name="zeilenhoehe" select="'35'" /> <!--Zeilenhhe in Masken, gemessen in Pixel-->

<xsl:template match="/">
<xsl:call-template name="mask"/>
</xsl:template>

<!-- start Maske-->
<xsl:template name="mask">
    <html>
  <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_pre_head'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_pre_head'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="head" ><xsl:with-param name="title" select="concat('Maske ',maske/felder/feld/maskenname)" /></xsl:call-template> 
<style type="text/css">
div.sx_submit_402
{
border: none;
display:block;
}
div.Maskenkopf_402
{
}
div.maskenfelder_402
{
}
div.sx_field_402
{
position:relative;
}
div.sx_fieldlabel_402
{
font-size:9pt;
display:inline;
}
div.sx_inputfeld_402
{
cursor: pointer;
display:inline;
}
div.sx_buttondiv_402
{
color:black;
cursor: pointer;
text-align:center;
font-weight:normal;
border:thin solid blue;
background-color:#ffffcc;
display:inline;
}
</style>
  <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_post_head'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_post_head'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_pre_javaskript'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_pre_javaskript'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="javascript"></xsl:call-template>
  <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_post_javascript'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_post_javascript'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_pre_CSS'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_pre_CSS'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskCSS"></xsl:call-template>
   <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_post_CSS'"></xsl:with-param></xsl:call-template>
   <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_post_CSS'"></xsl:with-param></xsl:call-template>
<script language="javascript">
      <!-- function kenn_zahl_felder()
      {
      var vorschrift=document.forms[0].Kennzahl.options[document.forms[0].Kennzahl.selectedIndex].value;
      var kennzahl=vorschrift.substring(0,vorschrift.indexOf('#'));
      var dims=vorschrift.substring(vorschrift.indexOf('#')+1,vorschrift.length);
      var dim_trenn=dims.indexOf(',');
      var ord=1;
      var offset=0;
      var zs="";
      while(dim_trenn != -1)
      {
      zs += ord + ". "+ dim_felder(dims.substring(offset,dim_trenn));
      offset=dim_trenn;
      dim_trenn=dims.indexOf(',',dim_trenn+1);
      ord++;
      }
      zs+=ord +". Wert der Kennzahl, Typ decimal (z.B. 5 oder 6.5)";
      alert ("Fuer die Kennzahl "+kennzahl +" sind folgende Angaben erforderlich:\n"+zs);
      } -->
      function kenn_zahl_felder()
      {
      if(document.forms[0].elements["Kennzahl"])
         var formfield=document.forms[0].elements["Kennzahl"];
      if(document.forms[0].elements["Tabelle"])
         var formfield=document.forms[0].elements["Tabelle"];

      var vorschrift=formfield.value;
      var kennzahl=vorschrift.substring(0,vorschrift.indexOf('#'));
      var dims=vorschrift.substring(vorschrift.indexOf('#')+1,vorschrift.length);
      var dim_trenn=dims.indexOf(',');
      var ord=1;
      var offset=0;
      var zs="";  
      if (dims.indexOf("*") > -1) {
      while(dim_trenn != -1)
      {
      zs += ord + ". "+ dim_felder(dims.substring(offset,dim_trenn));
      offset=dim_trenn;
      dim_trenn=dims.indexOf(',',dim_trenn+1);
      ord++;
      }
      if(dims.indexOf("wert_str") >-1)
      	zs+=ord +". Wert der Kennzahl, Typ String (z.B. 5 oder 6.5)"; 
	else
	zs+=ord +". Wert der Kennzahl, Typ Integer oder Decimal (z.B. 5 fr Integer oder 6.5 bzw. 6,5 fr Decimal)";
      alert ("Fuer die Kennzahl "+kennzahl +" sind folgende Angaben erforderlich:\n"+zs);
      } else if (dims != '') {
      var modul=dims.substring(0,dims.indexOf('_'));
      var url_adresse="../doku/"+modul+"_modul/"+modul+".html#tab_"+dims;
      TableInfoFenster = window.open(url_adresse, "_blank", "location=no,menubar=no,scrollbars=yes,resizable=yes,toolbar=no,width=1000,height=600");
      TableInfoFenster.focus();
      } else {
      alert ("Bitte erst eine Kennzahl auswhlen!");
      }
      }
function dim_felder(dim_string)
{
var dim_feld_kurz=dim_string.substring(0,dim_string.indexOf('*'));
var dim_feld_lang=dim_string.substring(dim_string.indexOf('*')+1,dim_string.indexOf('*',dim_string.indexOf('*')+1));
var dim_feld_typ=dim_string.substring(dim_string.lastIndexOf('*')+1,dim_string.length);
return "Merkmal: "+dim_feld_lang+", Typ "+dim_feld_typ+"\n";
}

function inhalt_field_endsign()
{
	var end_sign='#^END^#';
	var inhalt_str=document.forms[0].Inhalt.value;
	var inhalt_str_end=inhalt_str.indexOf(end_sign);
	if (inhalt_str_end == -1) {
		document.forms[0].Inhalt.value=document.forms[0].Inhalt.value+end_sign;
	}
}

  </script> 
<body onload="maskonload()"> <!--Leere Funktion in pageComponents. mask_post_javaskript definiert-->
   
  <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_pre_topbar'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_pre_topbar'"></xsl:with-param></xsl:call-template>
  <xsl:choose><!-- progressbar (LadeFenster) soll bei einer JasperReports Ergebnistabelle nicht angezeigt werden, da diese nicht mehr endet -->
   <xsl:when test="count(/maske/felder/feld[name='Ausgabeformat']) &gt; 0"> <!-- progressbar dummy -->
   <div id="progressbar" style="position:absolute; width:1px; height:1px; left:1px; top:1px; z-index:2001"></div>
   </xsl:when>
   <xsl:otherwise>
  <div id="progressbar"  style="position:absolute; width:150; height:150; left:200px; top:200px; background:#AAAAAA; z-index:2001">
     <p>&#160;<b>Laden...</b><br/><img src="/superx/images/progress_bar.gif"></img><br/></p></div>
    </xsl:otherwise>
   </xsl:choose>
  <xsl:call-template name="topbar" />
  
  <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_post_topbar'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_post_topbar'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_pre_buttons'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_pre_buttons'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskButtons" />
  <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_post_buttons'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_post_buttons'"></xsl:with-param></xsl:call-template>
  
  
  <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_pre_form'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_pre_form'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskForm"/>
 <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_post_form'"></xsl:with-param></xsl:call-template>
 <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_post_form'"></xsl:with-param></xsl:call-template>
	<!--<xsl:call-template name="sidebar" />-->
	  
  <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_pre_bottombar'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_pre_bottombar'"></xsl:with-param></xsl:call-template>

 <xsl:call-template name="bottombar_mask" />
    <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_post_bottombar'"></xsl:with-param></xsl:call-template>
    <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_post_bottombar'"></xsl:with-param></xsl:call-template>
    <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_pre_dialogs'"></xsl:with-param></xsl:call-template>
    <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_pre_dialogs'"></xsl:with-param></xsl:call-template>
   <xsl:call-template name="maskDialogs"></xsl:call-template>
     <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_post_dialogs'"></xsl:with-param></xsl:call-template>
     <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_post_dialogs'"></xsl:with-param></xsl:call-template>
   
   
   
   
   
  <!-- <div id="dojoDebug"></div>-->
</body>
</html>
  </xsl:template>
<!-- end -->
  <!-- start CSS -->
  <xsl:template name="maskCSS">
  <style type="text/css">
body { font-family : sans-serif; }
.dojoDialog {background : #eee;	border : 1px solid #999;-moz-border-radius : 5px;padding : 4px;width:550px;height:500px;overflow:scroll}
.sichtstand {font-size:80%;}
.header {font-size:150%;text-align:center}
form {	margin-bottom : 0;}
</style>
</xsl:template>
<!-- end CSS-->
   <!-- start javascript-->  
  
  
 <!-- start maskForm -->
 <xsl:template name="maskForm">
      <form name="maske" id="SuperXMaske" method="post"  charset="ISO-8859-1">
<xsl:attribute name="action"><xsl:value-of select="'SuperXmlTabelle'" /></xsl:attribute>
<xsl:if test="/maske/felder/feld[art=19]!=''" >
<xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
</xsl:if>
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_inform'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_inform'"></xsl:with-param></xsl:call-template>
		
  <input type="hidden" name="keyfieldsused" value="false"/>		
  <input type="hidden" name="tid"><xsl:attribute name="value"><xsl:value-of select="/maske/@tid"/></xsl:attribute></input>
  <input type="hidden" name="stylesheet" value="" />
	
 <!-- Merkfelder fr Sichten/Stnde -->
   <xsl:for-each select="/maske/felder/feld">
     <xsl:for-each select="sichten/sicht">
     <xsl:if test="@selected='true'">
     <xsl:text>
     </xsl:text>
     	<input type="hidden">
	<xsl:attribute name="id">
	 <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="../../name"/></xsl:with-param></xsl:call-template>
	<xsl:text>_Sichtmerker</xsl:text>
	</xsl:attribute>
	<xsl:attribute name="value">
	<!-- MB 6.10.08 UTF <xsl:call-template name="umlaut_urlencode"><xsl:with-param name="s1"><xsl:value-of select="@name_intern"/></xsl:with-param></xsl:call-template>-->
	<xsl:value-of select="@name_intern"/>
	</xsl:attribute>
	</input>
	<xsl:text>
     </xsl:text>
	<input type="hidden">
		<xsl:attribute name="id">
 <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="../../name"/></xsl:with-param></xsl:call-template>
<xsl:text>_Standmerker</xsl:text>
	</xsl:attribute>
	<xsl:attribute name="value">
	<xsl:value-of select="@stand"/>
	</xsl:attribute>
	</input>
     </xsl:if>
     </xsl:for-each>
    </xsl:for-each>
     <div id="maske" class="maske">
<div dojoType="ContentPane" id="Maskenkopf" class="Maskenkopf_402">
 <xsl:if test="/maske/nachricht !=''"><p><xsl:copy-of select="/maske/nachricht" /></p></xsl:if>
<xsl:call-template name="pccustomize"> <xsl:with-param name="position" select="'mask_pre_title'"></xsl:with-param> </xsl:call-template>
<xsl:call-template name="maskcustomize"> <xsl:with-param name="position" select="'mask_pre_title'"></xsl:with-param> </xsl:call-template>
<p class="maskentitel"><xsl:value-of select="maske/@name" /></p>
<xsl:call-template name="pccustomize"> <xsl:with-param name="position" select="'mask_post_title'"></xsl:with-param> </xsl:call-template>
<xsl:call-template name="maskcustomize"> <xsl:with-param name="position" select="'mask_post_title'"></xsl:with-param> </xsl:call-template>
</div>
<div dojoType="ContentPane" id="maskenfelder" class="maskenfelder_402">
  <table border="0">
<xsl:call-template name="pccustomize"> <xsl:with-param name="position" select="'mask_pre_fieldtop'"></xsl:with-param> </xsl:call-template>
<xsl:call-template name="maskcustomize"> <xsl:with-param name="position" select="'mask_pre_fieldtop'"></xsl:with-param> </xsl:call-template>

<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_post_fieldtop'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_post_fieldtop'"></xsl:with-param></xsl:call-template>

  <xsl:for-each select="maske/felder">

    <xsl:for-each select="feld">
    
    <xsl:call-template name="mask_afield_402"></xsl:call-template>
    
    </xsl:for-each>
<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_presubmit'"></xsl:with-param></xsl:call-template>
<xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_presubmit'"></xsl:with-param></xsl:call-template>
<tr><td></td><td>    
<div dojoType="ContentPane" id="sx_submit" class="sx_submit_402">
   <!--<xsl:attribute name="style"><xsl:text>position:absolute;left:200px;top:</xsl:text><xsl:value-of select="$zeilenhoehe* (rownr +1)" />
		   <xsl:text>px;</xsl:text></xsl:attribute>-->
                   <p align="left" >
		   
		     <input type="submit"  class="clsButtonStyle" value="@@abschicken@@" onClick="ok=validateForm(document.forms[0],'superx');if (ok==true) document.getElementById('progressbar').style.display='';inhalt_field_endsign();return ok"/>
                      &#160;                  
		<!--   <input type="reset" value="@@reset@@"/>-->
		</p>
		<div id="validation" style="color:#CC0000"><p> </p></div>
       </div>
       </td></tr>

       </xsl:for-each>
       
 <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_postsubmit'"></xsl:with-param></xsl:call-template>
 <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_postsubmit'"></xsl:with-param></xsl:call-template>
 </table>
     </div>
     
  </div>
  

	 <xsl:choose>
	 <xsl:when test="count(/maske/felder/feld[art=18]) &gt; 0">
	 
	  <div id="maske_infobar" class="maske_infobar">
	  <div class="weitere_einstellungen" id="dropdownmenu">
	  <ul>
	  <li><a href="#" rel="dropmenu1">Weitere Einstellungen:</a></li>
	  </ul>
	  </div>
	  <div id="dropmenu1" class="dropmenudiv">
	      <xsl:for-each select="/maske/felder/feld[art=18]">
		 <a target="_blank">
		  <xsl:attribute name="href">
		  <xsl:choose>
		  <xsl:when test="contains(defaultwert/key,'|')">
		  <xsl:value-of select="concat(substring-before(defaultwert/key,'|'),'?',substring-after(defaultwert/key,'|'))"/>
		  </xsl:when>
		  <xsl:otherwise>
		  <xsl:value-of select="defaultwert/key"/>
		  </xsl:otherwise>
		  </xsl:choose>
		  </xsl:attribute>
		  <xsl:value-of select="name" />
		 </a>
	      </xsl:for-each> 
	      </div>
	      </div>
	      <script type="text/javascript">cssdropdown.startdropdown("dropdownmenu")</script>
	 </xsl:when>
	 <xsl:otherwise>
	 
	 </xsl:otherwise>
	 </xsl:choose>
  
  
  
  
  
  
  
  
</form>
	</xsl:template>
 <!-- end maskForm-->
 <!-- start mask Afield-->
 <xsl:template name="mask_afield_402">
   <xsl:if test="attribut!='hidden'">
   <tr>
	     <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_prefield'"></xsl:with-param></xsl:call-template>
	     <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_prefield'"></xsl:with-param></xsl:call-template>
		     <!--<div dojoType="ContentPane" id="{concat('f_',tid)}" name="{concat('f_',tid)}" class="sx_field_402">-->
		    <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_infield1'"></xsl:with-param></xsl:call-template>
		    <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_infield1'"></xsl:with-param></xsl:call-template>
		    
		    <xsl:call-template name="sx_field_402"><xsl:with-param name="browser" select="$useragent" /><xsl:with-param name="zeilenhoehe" select="$zeilenhoehe" /></xsl:call-template>
		      <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_infield2'"></xsl:with-param></xsl:call-template>
		      <xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_infield2'"></xsl:with-param></xsl:call-template>
		      
		      <xsl:if test="name='Kennzahl' or name='Tabelle'">
		      <td valign="top">
		      <xsl:text> </xsl:text><a href="javascript:kenn_zahl_felder();"> Merkmalsliste</a>
		      </td>
		      </xsl:if>
		      <xsl:if test="name='Inhalt'">
		      <td valign="top">
		      <xsl:text> </xsl:text>
		      </td>
		      </xsl:if>
		    <!--</div>-->
		    </tr>
		    </xsl:if>
	<xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_post_field'"></xsl:with-param></xsl:call-template>
	<xsl:call-template name="maskcustomize"><xsl:with-param name="position" select="'mask_post_field'"></xsl:with-param></xsl:call-template>
 </xsl:template>
 <!-- end-->
 

  <!-- start customize  standard ist leer, kann von Spezialstylesheets berlagert werden -->
  <xsl:template name="maskcustomize">
    <xsl:param name="position"/>
 </xsl:template>
  <!-- end customize-->
  
     <!-- start V.4.0rc2-->
<xsl:template name="sx_field_402">
<xsl:param name="browser" />
<xsl:param name="zeilenhoehe" />
  <!-- rownr-Element im Servlet gesetzt -->
  <!-- Abwrtskomp. im Applet: Buttonbreite=0 abfangen -->
  <xsl:variable name="buttonbreite">
  <xsl:choose>
  <xsl:when test="buttonbreite=0 or buttonbreite='null'">
  <xsl:value-of select="100" /> 
  </xsl:when>
  <xsl:otherwise>
 <xsl:value-of select="buttonbreite"/> 
 </xsl:otherwise>
 </xsl:choose>
 </xsl:variable>
<td valign="top">
  <!-- start  Label-->
   <div class="sx_fieldlabel_402" dojoType="ContentPane" >
   <xsl:attribute name="style"><xsl:value-of select="concat('width:',$buttonbreite,'px; min-width:',$buttonbreite,'px')"/></xsl:attribute>


   <xsl:choose>
    <!-- start 0-->
    <xsl:when test="art='0' and zeilenanzahl &gt; 1">
    <span>
	 <xsl:choose>
        <xsl:when test="obligatorisch='1'">
        <xsl:attribute name="class">labelPflicht</xsl:attribute></xsl:when>
      <xsl:otherwise><xsl:attribute name="class">labelNormal</xsl:attribute></xsl:otherwise>
	</xsl:choose>
    <xsl:value-of select="name" />
    </span>
	    
   
    </xsl:when>
    <!-- end 0 -->
    <!-- start 1,2-->
    <xsl:when test="(art='1' or art='2') and (@isDynamic='true' or zeilenanzahl &gt; 1)">
    <div name="{concat('btn',name)}" class="sx_buttondiv">
   
	    <xsl:attribute name="onclick"><xsl:text>javascript:maskeComboLaden('</xsl:text><xsl:value-of select="name"/><xsl:text>','</xsl:text><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]><xsl:text>');</xsl:text></xsl:attribute>
	    <span>
	 <xsl:choose>
        <xsl:when test="obligatorisch='1'">
        <xsl:attribute name="class">labelPflicht</xsl:attribute></xsl:when>
      <xsl:otherwise><xsl:attribute name="class">labelNormal</xsl:attribute></xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
	<xsl:when test="caption_short != ''"><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]></xsl:when>
	    <xsl:otherwise>
	     
          <xsl:value-of select="name"/>
       	    </xsl:otherwise>
	    </xsl:choose>
	    </span>
	    </div>
	    </xsl:when>
	    <!-- end 1,2-->
	    <!-- start 4,6,7,12 Sichten -->
	 <xsl:when test="(art='4' or art='6' or art='7' or art='12') and attribut!='hidden' ">
	 <xsl:call-template name="dojosichtBtn" />
	 </xsl:when>
	 <!-- end-->
	 <!-- start 13/15-->
	 <xsl:when test="art = '13' or art = '15' or art = '18'">
	 <!--Kein Label bei versteckten Feldern und Hyperlinks-->
	 </xsl:when>
	 <!-- end 13/15-->
	 <!-- start 16 auskommentiert -->
	<!-- <xsl:when test="art = '16'">
	 <div name="{concat('btn',name)}"  class="sx_buttondiv">
        <xsl:attribute name="onclick"><xsl:text>javascript:maskeComboLaden('</xsl:text><xsl:value-of select="name"/><xsl:text>','</xsl:text><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]><xsl:text>');</xsl:text></xsl:attribute>
     
        <xsl:text>);</xsl:text>
        </xsl:attribute>
        <span>
	 <xsl:choose>
        <xsl:when test="obligatorisch='1'">
        <xsl:attribute name="class">labelPflicht</xsl:attribute></xsl:when>
      <xsl:otherwise><xsl:attribute name="class">labelNormal</xsl:attribute></xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
    <xsl:when test="caption_short != ''">
        <xsl:value-of select="caption_short"/>
       
        </xsl:when>
        <xsl:otherwise>
         
          <xsl:value-of select="name"/>
       
        </xsl:otherwise>
        </xsl:choose>
	</span>
        </div>
	 </xsl:when>  -->
	 <!-- end 16-->
	 <!-- start otherwise-->
    <xsl:otherwise>
         	 <span>
	 <xsl:choose>
        <xsl:when test="obligatorisch='1'">
        <xsl:attribute name="class">labelPflicht</xsl:attribute></xsl:when>
      <xsl:otherwise><xsl:attribute name="class">labelNormal</xsl:attribute></xsl:otherwise>
	</xsl:choose>
      <xsl:choose>
	<xsl:when test="caption_short != ''"><![CDATA[]]><xsl:value-of select="caption_short" /><![CDATA[]]></xsl:when>
	<xsl:otherwise>
	<xsl:value-of select="name" />
	</xsl:otherwise>
	</xsl:choose>
	</span>
     
   
                        
</xsl:otherwise>
 <!-- end otherwise -->
</xsl:choose>
</div>
</td>
<!-- end label-->
<!-- start inputfeld -->
<td valign="top">
<div dojoType="ContentPane" class="sx_inputfeld_402">
	    <!--<xsl:attribute name="style">
	    <xsl:text>width:</xsl:text><xsl:value-of select="feldbreite*1.2" /></xsl:attribute>-->

   <xsl:if test="caption_long != '' and art != '13' ">
	<div dojoType="tooltip" connectId="{concat('f_',tid)}" style="display:none;z-index:1000">
	<!--todo: br-Tags abfangen-->
	<xsl:call-template name="br_to_newline">
	<xsl:with-param name="string"><![CDATA[]]><xsl:value-of select="caption_long"/><![CDATA[]]></xsl:with-param>
	<xsl:with-param name="search">&lt;br&gt;</xsl:with-param>
	<!--<xsl:with-param name="replace"><xsl:text>&#10;</xsl:text></xsl:with-param>-->
	</xsl:call-template>
		</div>
		</xsl:if>
	
	
	
	
<xsl:choose>
<!-- start art 0-->
      <xsl:when test="art='0'">
      &#160;&#160;&#160;<!--wg. Schlsselfeldern gleiche Breite-->
        <xsl:if test="zeilenanzahl='1'">
          <input type="text" >
	  <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
	    <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="MAXLENGTH">
              <xsl:value-of select="laenge"/>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
	    <!--<xsl:choose>
	    <xsl:when test="typ='date'">
	    <xsl:if test="string-length(defaultwert/name) &gt; 0">
	    <xsl:value-of select="concat(substring(defaultwert/name,7,4),'-',substring(defaultwert/name,4,2),'-',substring(defaultwert/name,1,2))"/>
	    </xsl:if>
	    </xsl:when>
	    <xsl:otherwise>-->
	    <xsl:value-of select="defaultwert/name"/>
	    <!--</xsl:otherwise>
	    </xsl:choose>-->
            </xsl:attribute>
            <xsl:attribute name="size">
              <xsl:value-of select="feldbreite div $feldbreite_faktor"/>
            </xsl:attribute>
	    <xsl:if test="typ='date'">
	    <!--
	    <xsl:attribute name="dojoType"><xsl:text>dropdowndatepicker</xsl:text> </xsl:attribute>
	    <xsl:attribute name="displayFormat"><xsl:text>dd.MM.yyyy</xsl:text> </xsl:attribute>
	    <xsl:attribute name="saveFormat"><xsl:text>dd.MM.yyyy</xsl:text></xsl:attribute>
	    <xsl:if test="string-length(defaultwert/name) &gt; 0">
	    <xsl:attribute name="date"><xsl:value-of select="concat(substring(defaultwert/name,7,4),'-',substring(defaultwert/name,4,2),'-',substring(defaultwert/name,1,2))"/></xsl:attribute>
	    </xsl:if>-->
	    <a href="javascript:doNothing()">
	    <xsl:attribute name="onclick"><xsl:text>calDateFormat='DD.MM.yyyy';setDateField(document.forms['maske'].elements['</xsl:text><xsl:value-of select="name" /><xsl:text>']); top.newWin = window.open('/superx/dbformslib/jscal/calendar.html','cal','width=270,height=280')</xsl:text></xsl:attribute>
	    <img src="/superx/dbformslib/jscal/calendar.gif" class="imageCalendar"  border="0"  alt="Kalender ffnen"></img></a>
	   </xsl:if>
	   </input>
        </xsl:if>
        <xsl:if test="zeilenanzahl!='1'">
	    <textarea WRAP="on">
            <xsl:attribute name="cols">
              <xsl:value-of select="feldbreite div 10"/>
            </xsl:attribute>
            <xsl:attribute name="rows">
              <xsl:value-of select="zeilenanzahl"/>
            </xsl:attribute>
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
            <xsl:value-of select="defaultwert/name"/>
          </textarea>
      </xsl:if>
	
      </xsl:when>
      <!-- end art 0-->
<!-- start art 1 oder 2 COMBO-->
      <xsl:when test="art='1' or art='2'">
      <!--normale Combo-Box -->
         	    <!-- <xsl:call-template name="schluesselfeld" />&#160;  Wegen versatz im His1 Layout Leerzeichen gelscht-->
	    <xsl:call-template name="schluesselfeld" />
	    <xsl:choose>
	    <!-- start combobox fr zeilenzahl 1/nicht-dynamisches Feld-->
	     <xsl:when test="zeilenanzahl=1 and @isDynamic='false'">
	    <!--Combobox ist nur Auswahlhilfe ausgewertet wird inhalt von Inputfeld!!-->
      <select >
      <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
        <xsl:attribute name="id"><xsl:text>select_</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template></xsl:attribute>
          <xsl:attribute name="NAME">
            <xsl:text>select_</xsl:text><xsl:value-of select="name"/>
          </xsl:attribute>
	  <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
	    <xsl:attribute name="onchange">
	    <xsl:text>c=document.getElementById('</xsl:text>
	    <xsl:text>select_</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
	    <xsl:text>');document.getElementById('</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template><xsl:text>').value=c.options[c.selectedIndex].value;</xsl:text>
	    </xsl:attribute>
             <option />
           <xsl:for-each select="relation/item">
	   <xsl:if test="string-length(name) &gt; 0">
            <option class="maskinput">
              <xsl:attribute name="value">
                <xsl:value-of select="key"/>
              </xsl:attribute>
	      			<!--MB-->
	  		  <xsl:if test="../../defaultwert/name=name">
          		  <xsl:attribute name="selected">true</xsl:attribute>
		    </xsl:if>
              <xsl:value-of select="name"/>
            </option>
	    </xsl:if>
          </xsl:for-each>
        </select>
      </xsl:when>
      <!-- end combobox fr zeilenzahl 1-->
      <!-- start Button and Skript fr zeilenzahl grer 1 -->
      <xsl:otherwise>
         <xsl:call-template name="valuelabel" />&#160;
	 <!--   <script language="JavaScript">
	    var a=[new Option("testing","testing"),
	    <xsl:for-each select="relation/item">
	   <xsl:if test="string-length(name) &gt; 0">
           <xsl:text>new Option("</xsl:text>
	   <xsl:call-template name="escape-quote"><xsl:with-param name="string" select="name" /></xsl:call-template>
	   <xsl:text>","</xsl:text><xsl:value-of select="key"/><xsl:text>"</xsl:text>
		<xsl:choose>      			
	  		  <xsl:when test="../../defaultwert/name=name">
          		  <xsl:text>,true,true)</xsl:text>
		    </xsl:when>
		    <xsl:otherwise><xsl:text>,false,false)</xsl:text></xsl:otherwise>
		    </xsl:choose>
		    <xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
    	    </xsl:if>
          </xsl:for-each>
	  ];
	</script>-->

      </xsl:otherwise>
            </xsl:choose>
      <!-- end Button and Skript fr zeilenzahl > 1 -->
      </xsl:when>
      <!-- end art 1 -->
<!-- start 8,5 Kommentar/Label-->
   <xsl:when test="art='8' or art='5'">
   <!--label-->
   
      <input type="label" readonly ="true" class="sx_labelRight">
	 <xsl:attribute name="NAME">
            <xsl:value-of select="name"/>
          </xsl:attribute>
	 <xsl:attribute name="value">
	 <xsl:value-of select="defaultwert/name"/>
	 </xsl:attribute>
	

	 	 
	 </input>
   </xsl:when>
      <xsl:when test="art='9'">
        <xsl:call-template name="treeview">
       </xsl:call-template>
      </xsl:when>
        <xsl:when test="art='10'">
           <input type="checkbox" value="true" >
	   <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
	    <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
	    <xsl:if test="defaultwert/name != '' and defaultwert/name != 'false'">
            <xsl:attribute name="checked">
              <xsl:value-of select="defaultwert/name"/>
            </xsl:attribute>
	    </xsl:if>
	    
          </input> &#160;
       
      </xsl:when>
      <!-- end -->
<!-- start art 11 passwort-->
      
      <xsl:when test="art='11'">
      <xsl:if test="zeilenanzahl='1'">
          <input type="password">
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
	    <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="MAXLENGTH">
              <xsl:value-of select="laenge"/>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
              <xsl:value-of select="defaultwert/name"/>
            </xsl:attribute>
            <xsl:attribute name="size">
              <xsl:value-of select="feldbreite div 12"/>
            </xsl:attribute>
	   
          </input>
        </xsl:if>
     </xsl:when>
     <!-- end art 11-->
<!-- start 4,6,8, 12 Sicht -->
     
     <xsl:when test="art='4' or art='6' or art='7' or art='12'">
     <xsl:call-template name="dojosichtValue">
       </xsl:call-template>
     
     
	  	 
   </xsl:when>
   <!-- end 12-->
<!-- start 13 hidden-->
      <xsl:when test="art='13'">
      <input type="hidden">
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
              <xsl:value-of select="defaultwert/key"/>
            </xsl:attribute>
            
          </input>
	  </xsl:when>
	  <!-- end 13 -->
<!-- start 14 radiobox-->
	  <xsl:when test="art='14'">
      <input type="radio">
      <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
      	<xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
              <xsl:value-of select="defaultwert/name"/>
            </xsl:attribute>
	   
            
          </input>
	  </xsl:when>
	  <!-- end 14-->
<!-- start 15 links-->
	  <xsl:when test="art='15'">
	  <xsl:if test="defaultwert/name != ''">
	  <a class="feldlink">
          <xsl:attribute name="href">
	  <xsl:choose>
	  <!--bei externen Links bentigen wir keine JSESSIONID-->
	  <xsl:when test="starts-with(defaultwert/name,'www')">
              <xsl:value-of select="concat('http://',defaultwert/name)"/>

	  </xsl:when>
	  <xsl:when test="starts-with(defaultwert/name,'http')  or contains(defaultwert/name,'.htm')">
              <xsl:value-of select="defaultwert/name"/>

	  </xsl:when>
	  <xsl:when test="starts-with(defaultwert/name,'nexttable:')">
       <xsl:value-of select="concat('SuperXmlTabelle','?tid=',substring-after(defaultwert/name,'nexttable:'))"/>
	 
	  </xsl:when>
	  <xsl:otherwise>
	  <!--Default: Link auf andere Maske-->
	  <xsl:value-of select="concat('SuperXmlMaske','?tid=',defaultwert/name)"/>
	  </xsl:otherwise>
	  </xsl:choose>
           </xsl:attribute>
	  

            <xsl:value-of select="name"/>
          </a>
	  </xsl:if>
	  </xsl:when>
	  <!-- end 15-->
<!-- start 16 querabhngig combo ausskommentiert-->
   <!-- <xsl:when test="art='16'">
    <xsl:call-template name="schluesselfeld" />&#160;<xsl:call-template name="valuelabel" />&#160;
    </xsl:when>  -->
    <!-- end 16-->
    <xsl:when test="art='17'">
	  <!--Radio-->
	  <input name="{name}" id="{name}" type="hidden" value="{defaultwert/key}" />
	  <xsl:for-each select="relation/item [string-length(name) &gt; 0]">
	   
            <input name="{concat(../../name,'Radio')}" id="{concat(../../name,'Radio',position())}" value="{key}" type="radio" >
	    <xsl:attribute name="onclick"><xsl:text>document.forms[0].elements['</xsl:text><xsl:value-of select="../../name"/>
	    <xsl:text>'].value='</xsl:text><xsl:value-of select="key"/><xsl:text>';return true;</xsl:text></xsl:attribute>
	 <xsl:if test="../../defaultwert/name=name">
          		  <xsl:attribute name="checked"><xsl:text>true</xsl:text></xsl:attribute>
		    </xsl:if>
	    </input>&#160;<xsl:value-of select="name"/><br /> 
            </xsl:for-each>  
	    
         
	  
	  </xsl:when>
	  <xsl:when test="art='18'">
	  </xsl:when>
	    <xsl:when test="art='19'">
	   <input type="file" size="60" name="Datei" />
	   </xsl:when>
	  <xsl:otherwise>Unbekannte Feldart <xsl:value-of select="art"/></xsl:otherwise>
    </xsl:choose>
    </div>
	</td>
	
  </xsl:template>
</xsl:stylesheet>
