<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet 
version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:html="http://www.w3.org/1999/xhtml">

<xsl:import href="xsl_functions.xsl" />
<xsl:import href="pageComponents_html.xsl" />
<xsl:import href="menue_html_dojo.xsl" />
<!--In diesem Stylesheet knnen Sie individuelle templates unterbringen,
  die in ihrer Przedenz das normale Stylesheet 
  pageComponents_html.xsl berragt. --> 
<xsl:import href="pageComponents_html_final.xsl" />
<xsl:import href="maskComponents_html.xsl" />
<xsl:import href="levels.xsl" />

<xsl:output method="xml"    media-type="text/html" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
   doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"    cdata-section-elements="script style"    indent="yes" encoding="ISO-8859-1"/>
<xsl:variable name="useragent" select="'mozilla'" /> 
<xsl:variable name="zeilenhoehe" select="'35'" /> <!--Zeilenhhe in Masken, gemessen in Pixel-->
<xsl:template match="/">
 <html>
  <xsl:call-template name="head" ><xsl:with-param name="title" select="concat('Maske ',maske/felder/feld/maskenname)" /></xsl:call-template>
  <xsl:call-template name="javascript"></xsl:call-template>
  <xsl:call-template name="pccustomize"><xsl:with-param name="position" select="'mask_post_javascript'"></xsl:with-param></xsl:call-template>
  <xsl:call-template name="maskCSS"></xsl:call-template>
  <script type="text/javascript"><![CDATA[
function setMaskKeysOfReport()
 {
 var keys = document.getElementById('Ausgabe_des_Berichts').value;
 var keysSplit = keys.split("*");
 //alert(keysSplit + '\n' + keysSplit[2]);
 document.getElementById('Berichtsart').value=keysSplit[0];
 document.getElementById('tablestylesheet').value=keysSplit[1];
 document.getElementById('Ausgabeformat').value=keysSplit[2];
 }
      
function maskeComboLaden18100(fname,caption)
 {
resetValidation();
Feldname=fname;
var callurl='/superx/servlet/SuperXmlMaske';
//if (jsessionid!='') callurl+=";jsessionid="+jsessionid;
callurl+="?tid="+maskentid+"&getJSON_"+getEncoded(Feldname)+'=xxxxxx-xxxxxx@';
var params="";
for (i=1;i<felder.length;i++)
 {
 e=document.forms['maske'].elements[felder[i]["htmlname"]];
 if(e)
	{
	var t=e.type;
	var name=felder[i]["name"];
	if (name==Feldname||t=='button'||t=='submit'||t=='reset'||t=='hidden') continue;
	//todo bei startsWith select_ label_ auch berspringen

	if (e.value!='') 
	params+="&"+felder[i]["htmlname"]+"="+encodeURIComponent(e.value);
	else
	params+="&"+felder[i]["htmlname"]+"=--leer--";
	}
		
 }

if (!caption||caption=='') caption=Feldname;
document.getElementById("comboElementName").innerHTML='Auswahl '+caption;
document.getElementById("comboload").style.display="";
document.getElementById("comboselect").style.display="none";
var myCombo=document.getElementById("comboselect");
while (myCombo.firstChild) {
    myCombo.removeChild(myCombo.firstChild);
}
versteckeCombosIE6();
combodlg.show();

   dojo.io.bind({url:callurl+params,encoding: "UTF-8",method: "post",
	handler: function(type,data,evt)
	{
	var da=purgeval(data);
	if (type=='error'|| da.error) {
		if (da.error) msg=da.error; else msg=data.message;
				  document.getElementById('progressbar').style.display="none";
		alert('Fehler beim Lesen der Daten!\n'+msg);
		combodlg.hide();
	}
	else
	{
	nodes=da.nodes;
	document.forms['comboform'].comboselect.options.length=0;
	if (nodes.length==0)
		{
		document.forms['comboform'].comboselect.options[0]=new Option("keine Auswahl moeglich","");
		}
		else
		{
		if (fname=="Externes Produkt (Fchergruppe+LFB)")
			{
			var lastOptgroup="";
			var currentOptgroup="";
			var optGroup01 = document.createElement('optgroup');
			optGroup01.label=getFgrLabel(nodes,"01") ; //"Sprach- und Kulturwiss.";
			var optGroup01_has_child=false;
			var optGroup02 = document.createElement('optgroup');
			optGroup02.label=getFgrLabel(nodes,"02") ;//"Sport";
			var optGroup02_has_child=false;
			var optGroup03 = document.createElement('optgroup');
			optGroup03.label=getFgrLabel(nodes,"03") ;//"Recht/Wirtsch/Sozial";
			var optGroup03_has_child=false;
			var optGroup04 = document.createElement('optgroup');
			optGroup04.label=getFgrLabel(nodes,"04") ;//"Mathe/Naturwiss.";
			var optGroup04_has_child=false;
			var optGroup05 = document.createElement('optgroup');
			optGroup05.label=getFgrLabel(nodes,"05") ;//"Human-/Gesundheitswiss.";
			var optGroup05_has_child=false;
			var optGroup06 = document.createElement('optgroup');
			optGroup06.label=getFgrLabel(nodes,"06") ;//"Veterinrmedizin";
			var optGroup06_has_child=false;
			var optGroup07 = document.createElement('optgroup');
			optGroup07.label=getFgrLabel(nodes,"07") ;//"Agrar/Forst/Ernhrung";
			var optGroup07_has_child=false;
			var optGroup08 = document.createElement('optgroup');
			optGroup08.label=getFgrLabel(nodes,"08") ;//"Ingenieurwissenschaften";
			var optGroup08_has_child=false;
			var optGroup09 = document.createElement('optgroup');
			optGroup09.label=getFgrLabel(nodes,"09") ;//"Kunst/ Kunstwiss.";
			var optGroup09_has_child=false;
			var optGroup15 = document.createElement('optgroup');
			optGroup15.label=getFgrLabel(nodes,"15") ;//Zentrale Einrichtungen  (ohne klinikspezifische Einrichtungen)";
			var optGroup15_has_child=false;
			}
			for (i=0;i<nodes.length;i++)
			{
								
				sel=false;
				if (nodes[i].isSelected) sel=true;
	//-------------------HIER IST DER ANGEPASSTE CODE------------------------------------------------------------------------
				title=nodes[i].title;
				key=nodes[i].objectId;
				if (fname=="Externes Produkt (Fchergruppe+LFB)")
				{
					if (key.length == 2)
					{
					//Fchergruppe nur als optgroup:
					currentOptgroup=key;
					}
					else
					{
					//LFB:
					var o=new Option(title,key,sel,sel);
					if(lastOptgroup=="01")
					{optGroup01_has_child=true;
					optGroup01.appendChild(o);
					}
					if(lastOptgroup=="02")
					{optGroup02_has_child=true;
					optGroup02.appendChild(o);
					}
					if(lastOptgroup=="03")
					{optGroup03_has_child=true;
					optGroup03.appendChild(o);
					}
					if(lastOptgroup=="04")
					{optGroup04_has_child=true;
					optGroup04.appendChild(o);
					}
					if(lastOptgroup=="05")
					{optGroup05_has_child=true;
					optGroup05.appendChild(o);
					}
					if(lastOptgroup=="06")
					{optGroup06_has_child=true;
					optGroup06.appendChild(o);
					}
					if(lastOptgroup=="07")
					{optGroup07_has_child=true;
					optGroup07.appendChild(o);
					}
					if(lastOptgroup=="08")
					{optGroup08_has_child=true;
					optGroup08.appendChild(o);
					}
					if(lastOptgroup=="09")
					{optGroup09_has_child=true;
					optGroup09.appendChild(o);
					}
					if(lastOptgroup=="15")
					{optGroup15_has_child=true;
					optGroup15.appendChild(o);
					}							
				}
								
				if(currentOptgroup != lastOptgroup || i==nodes.length-1)
					{
					//alert(currentOptgroup+"-"+lastOptgroup);
					lastOptgroup=currentOptgroup;
					}
				} //Ende Feld Ext. Produkt (gruppiert)
				else
				{
				//normale Feldart 1
				var o=new Option(title,nodes[i].objectId,sel,sel);
				document.forms['comboform'].comboselect.options[i]=o;
				}
							
       //---------------------------------------- BIS HIER -------------------------------------------------------------
							
							
			}
			if (fname=="Externes Produkt (Fchergruppe+LFB)")
				{
				if(optGroup01_has_child)
				document.getElementById("comboselect").appendChild(optGroup01);
				if(optGroup02_has_child)
				document.getElementById("comboselect").appendChild(optGroup02);
				if(optGroup03_has_child)
				document.getElementById("comboselect").appendChild(optGroup03);
				if(optGroup04_has_child)
				document.getElementById("comboselect").appendChild(optGroup04);
				if(optGroup05_has_child)
				document.getElementById("comboselect").appendChild(optGroup05);
				if(optGroup06_has_child)
				document.getElementById("comboselect").appendChild(optGroup06);
				if(optGroup07_has_child)
				document.getElementById("comboselect").appendChild(optGroup07);
				if(optGroup08_has_child)
				document.getElementById("comboselect").appendChild(optGroup08);
				if(optGroup09_has_child)
				document.getElementById("comboselect").appendChild(optGroup09);
				if(optGroup15_has_child)
				document.getElementById("comboselect").appendChild(optGroup15);
				}
				if (da.zeilenanzahl>1&&nodes.length>1)
					{
					document.forms['comboform'].comboselect.size=10;
							
					document.forms['comboform'].comboselect.multiple=true;
					document.getElementById("multiselecthint").style.display="";
					document.getElementById("suchselect").multiple=true;
						
					}
					else
					{
					document.forms['comboform'].comboselect.size=1;
					document.forms['comboform'].comboselect.multiple=false;
					document.getElementById("multiselecthint").style.display="none";
					document.getElementById("suchselect").multiple=false;
					}
					document.getElementById("comboload").style.display="none";
					document.getElementById("comboselect").style.display="";	
		}
		document.getElementById('progressbar').style.display="none";
		}
	       }
	       }
	);


 }
 function getFgrLabel(myNodes,fgr_nr)
 {
 var myTitle="";
 var myKey="";
  
 for (i=0;i<myNodes.length;i++)
 {
 myKey=nodes[i].objectId;
 if(myKey==fgr_nr)
 	myTitle=nodes[i].title;
 }
 return myTitle;
 }
 function setURL()
 {
 //Da der Link in Excel auf passwortgeschtzte Seiten nicht funktioniert, hier ein Umweg ber eine Seite mit Redirect
 //als Parameter wird dann der eigene Server angegeben.
 var server_path = "".concat(window.location.protocol).concat("//").concat(window.location.host);
 var myFormElem=document.forms["maske"].elements["URL"];
 var zs="";
 if("".concat(myFormElem.value).includes("server_path") )
 {
        zs=myFormElem.value;
 }
 else
 {
        zs=myFormElem.value.concat("?server_path=").concat(server_path);
 }

 if(myFormElem)
        myFormElem.value=zs;
 }

 ]]>
      </script>
  <body onload="setURL();maskonload()">
   <xsl:choose>
   <xsl:when test="count(/maske/felder/feld[name='Ausgabeformat']) &gt; 0"> 
   <div id="progressbar" style="position:absolute; width:1px; height:1px; left:1px; top:1px; z-index:2001"></div>
   </xsl:when>
   <xsl:otherwise>
   <div id="progressbar" style="position: fixed; width: 250px; height: 115px; left: 50%; margin-left: -150px; top: 200px; background-color: rgba(255, 255, 255, 0.9);  z-index: 2001; background-position: initial initial; background-repeat: initial initial; border: 1px solid #037AA6; -moz-border-radius: 4px; border-radius: 4px;"><center><p>&#160;<br/><img src="/superx/images/icons/loader_33.gif" style="position: center;"></img><br/><br/><b style="font-style: italic; font-weight: normal">Bitte warten ...</b></p></center></div>
   </xsl:otherwise>
   </xsl:choose>
   
   <xsl:if test="/maske/@showNavigation='true'"> 
<xsl:for-each select="/maske/menue">
   <xsl:call-template name="menuFrame" />
   </xsl:for-each>
</xsl:if>
   <div>
<xsl:if test="/maske/@showNavigation='true'">
<xsl:attribute name="class"><xsl:text>page-wrap</xsl:text></xsl:attribute>
   <xsl:for-each select="/maske/menue">
   <xsl:call-template name="topbar_menue" />
   </xsl:for-each>
</xsl:if>

   <div>
   <xsl:if test="/maske/@showNavigation='true'">
   <xsl:attribute name="id"><xsl:text>wrapper</xsl:text></xsl:attribute>
   </xsl:if>

    <div class="divcontent">
     <div class="submenu">
      <div id="contentFrame">
       <form name="maske" id="SuperXMaske" method="post"  charset="UTF-8">
        <!-- MB 9/14 encode URL ignoriert jsession id  -->
        <xsl:attribute name="action"><xsl:value-of select="'SuperXmlTabelle'" /></xsl:attribute>
	<xsl:if test="/maske/felder/feld[art=19]!=''" >
<xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
</xsl:if>
        <h1 class="unsichtbar"><a name="content">Inhalt</a>
         <input type="hidden" name="keyfieldsused" value="false"/>
         <input type="hidden" name="tid"><xsl:attribute name="value"><xsl:value-of select="/maske/@tid"/></xsl:attribute></input>
         <input type="hidden" name="stylesheet" value="" />
         <!-- Merkfelder fr Sichten/Stnde -->
         <xsl:for-each select="/maske/felder/feld">
	 <xsl:if test="art != '18' and attribut!='hidden'">
          <xsl:for-each select="sichten/sicht">
           <xsl:if test="@selected='true'">
            <xsl:text>
            </xsl:text>
            <input type="hidden">
             <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="../../name"/></xsl:with-param></xsl:call-template>
              <xsl:text>_Sichtmerker</xsl:text>
             </xsl:attribute>
             <xsl:attribute name="value">
              <!-- MB 6.10.08 UTF <xsl:call-template name="umlaut_urlencode"><xsl:with-param name="s1"><xsl:value-of select="@name_intern"/></xsl:with-param></xsl:call-template>-->
              <xsl:value-of select="@name_intern"/>
             </xsl:attribute>
            </input>
            <xsl:text>
            </xsl:text>
            <input type="hidden">
             <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="../../name"/></xsl:with-param></xsl:call-template>
              <xsl:text>_Standmerker</xsl:text>
             </xsl:attribute>
             <xsl:attribute name="value">
              <xsl:value-of select="@stand"/>
             </xsl:attribute>
            </input>
           </xsl:if>
          </xsl:for-each>
	 </xsl:if>
         </xsl:for-each>
        </h1>
        <h1><xsl:value-of select="/maske/@name" /></h1>
        <xsl:call-template name="maskbreadcrumbs" />
        <!-- <div class="clearerSpaceAboveHalfEm"></div> -->
        <div id="maske" class="maske">
         <div class="iconsTopAbove">
<!--           <a class="iconsTopAboveIcon" tabindex="22" href="/qisserver/pages/cs/sys/portal/documentation/documentation.faces?navigationPosition=documentation&amp;site={/ergebnisse/ergebnis/maskenname/@helpcontext}" title="Hilfe" target="_blank"><img title="Dokumentation" alt="Dokumentation" src="../images/icons/book.gif"  border="0" /></a>       -->
           <a  type="button" class="linkLookImage" tabindex="23" title="Schlsselfelder an- oder ausschalten" onclick="maskeTogglekeyfields(); return false;"><img border="0" src="../xml/his1/images/icons/two_key_bracket.svg" class="svg_icon" title="Schlsselfelder an- oder ausschalten" alt="Schlsselfelder an- oder ausschalten" /></a>
           <span class="separator">&#160;</span>  
          <a  class="linkLookImage" tabindex="22" href="/{/maske/@helpcontext}" title="Hilfe" target="_blank"><img title="Handbuch zu ..." alt="Handbuch zu ..." src="../xml/his1/images/icons/book.svg" class="svg_icon"  border="0" /></a>
           <span class="separator">&#160;</span>
          <a  type="button" class="linkLookImage" tabindex="24" title="Aktuelle Maske als Lesezeichen im Browser speichern" onclick="maskepreparelesezeichendlg();versteckeCombosIE6();lesezeichendlg.show(); return false;"><img title="Aktuelle Maske als Lesezeichen im Browser speichern" alt="Aktuelle Maske als Lesezeichen im Browser speichern" src="../xml/his1/images/icons/attach.svg" class="svg_icon" border="0" /></a>
              
         </div>
<!--        <input tabindex="30" type="submit" class="submit" value="Abschicken" onclick="ok=validateForm(document.forms[0],'his1');if (ok==true) document.getElementById('progressbar').style.display='';return ok;" />    -->
	 <!-- <div class="clearer"></div> --> 
	 <div>
	 <xsl:choose>
	 <xsl:when test="count(/maske/felder/feld[art=18]) &gt; 0">
	  <xsl:attribute name="class"><xsl:text>columnTwoThirdLeft_1024</xsl:text></xsl:attribute>
	 </xsl:when>
	 <xsl:otherwise>
	 <xsl:attribute name="class"><xsl:text>columnFullSize</xsl:text></xsl:attribute>
	 </xsl:otherwise>
	 </xsl:choose>
          <div class="boxStandard">
           <div class="box_container">
            <div>
             <div class="box_title">
              <h2>Bericht erstellen: <xsl:value-of select="maske/@name" /></h2>
             </div>
             <div>
              <div class="box_content">
               <fieldset class="fieldsetNoBorder">
                <legend>No legend</legend>
                 <ol>
                  <xsl:for-each select="maske/felder/feld">
		  <xsl:choose>
		  
		   <xsl:when test="art != '18' and attribut!='hidden'">
                    <li>
                     <label class="label_40">
                      <xsl:attribute name="for"><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template></xsl:attribute>
                      <xsl:call-template name="inputlabel"/>
                     </label>
                     <xsl:call-template name="inputfeld"/>
                     <xsl:if test="caption_long != '' and art != '13' ">
                     <!--  <div connectId="{concat('f_',tid)}" style="display:none;z-index:1000">
                       <xsl:call-template name="br_to_newline">
                        <xsl:with-param name="string"><![CDATA[]]><xsl:value-of select="caption_long"/><![CDATA[]]></xsl:with-param>
                        <xsl:with-param name="search">&lt;br&gt;</xsl:with-param>
                       </xsl:call-template>
                      </div>
		      <img alt="Informationen zu ...(label)" src="../images/icons/information.gif" name="{concat('f_',tid)}" id="{concat('f_',tid)}" />
		      -->
		      
		      <input type="image" onclick="if(document.getElementById('{concat('f_',tid)}').style.display=='none')document.getElementById('{concat('f_',tid)}').style.display='block'; else document.getElementById('{concat('f_',tid)}').style.display='none'; return false;" src="../xml/his1/images/icons/information.svg" class="svg_icon" value="Helptext" name="{concat('i_',tid)}" id="{concat('i_',tid)}"/>
                      <br/>
		      <p id="{concat('f_',tid)}" class="helptext" style="display: none;">
		       <xsl:call-template name="br_to_newline">
                        <xsl:with-param name="string"><![CDATA[]]><xsl:value-of select="caption_long"/><![CDATA[]]></xsl:with-param>
                        <xsl:with-param name="search">&lt;br&gt;</xsl:with-param>
                       </xsl:call-template>
		      </p>
                     </xsl:if>
                    </li>
		   </xsl:when>
		   <xsl:otherwise>
		   <input type="hidden" >
	    <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
	    <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
	    	    <xsl:value-of select="defaultwert/key"/>
	                </xsl:attribute>
           
	    </input>
		   </xsl:otherwise>
		   </xsl:choose>
                  </xsl:for-each>
                 </ol>
               </fieldset>
               <!--</div>-->
              </div>
              <div class="box_bottom_left">
               <div class="box_bottom_right">
               </div>
              </div>
             </div>
            </div>
           </div>
          </div>
         </div>
	 <xsl:if test="count(/maske/felder/feld[art=18]) &gt; 0"> 
	  <div>
	   <xsl:attribute name="class"><xsl:text>columnOneThirdRight_1024</xsl:text></xsl:attribute>
	   <div class="box_grey_bg_white">
	    <div class="box_container">
	     <div class="box_title">
              <h2>Weitere Einstellungen:</h2>
             </div>
	     <div class="box_content">
	      <xsl:for-each select="/maske/felder/feld[art=18]">
	       <fieldset class="fieldsetNoBorder">
                 <legend>Weitere Einstellungen:</legend>
		 <a target="_blank">
		  <xsl:attribute name="href">
		  <xsl:choose>
		  <xsl:when test="contains(defaultwert/key,'|')">
		  <!-- MB 9/14 encode URL ignoriert jsession id  -->
		  <xsl:value-of select="concat(substring-before(defaultwert/key,'|'),'?',substring-after(defaultwert/key,'|'))"/>
		  </xsl:when>
		  <xsl:otherwise>
		  <xsl:value-of select="defaultwert/key"/>
		  </xsl:otherwise>
		  </xsl:choose>
		  
		  </xsl:attribute><xsl:value-of select="name" />
		 </a>
               </fieldset>
	      </xsl:for-each>
	     </div>
	     <div class="box_bottom_left">
              <div class="box_bottom_right"></div>
             </div>
	    </div>
	   </div>
	  </div>
	 </xsl:if>
         <!-- <div class="clearer"></div> -->
         <div class="columnHalfLeft">
	 <input name="navi" type="hidden" value="true" />
         <input tabindex="10000" type="submit" class="submit" value="Abschicken" onclick="setMaskKeysOfReport();ok=validateForm(document.forms[0],'his1');if (ok==true) document.getElementById('progressbar').style.display='';return ok;" />
	   <input tabindex="10001" type="submit" value="@@reset@@" class="submit">
		   <xsl:attribute name="onclick"><xsl:text>location.href='/superx/servlet/SuperXmlMaske?tid=</xsl:text><xsl:value-of select="/maske/@tid"/><xsl:text>&amp;navi=true&amp;cachingcontrol=clearsessiondefaults';return false;</xsl:text></xsl:attribute>
		   </input>&#160; &#160; &#160; 
          
         </div>
        </div>
        <div id="clearer" class="clearer"></div>
       </form>
      </div>
     </div>
     
     <!-- <div class="clearer"></div> -->
     <div id="validation" style="color:#FF0000;font-weight:bolder"><p> </p></div>
    </div>
   </div>
   </div>
   <xsl:call-template name="maskDialogs"></xsl:call-template>
  </body>
 </html>
</xsl:template>


 <!-- start CSS -->
  <xsl:template name="maskCSS">
  <style type="text/css">
body { font-family : sans-serif; }
.dojoDialog {background : #eee; border : 1px solid #999;-moz-border-radius : 5px;padding : 4px;width:550px;overflow:scroll}
.sichtstand {font-size:80%;}
.header {font-size:150%;text-align:center}
form { margin-bottom : 0;}
</style>
</xsl:template>
<!-- end CSS-->
 
   <!-- start DOJO maskDialogs  ******************************************************************************* -->
  <xsl:template name="maskDialogs">
  
        <!-- start Lesezeichen DLG -->
<div dojoType="dialog" id="lesezeichendlg" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="100" 
closeNode="lesezeichen_abbrechen" style="z-index:1010;display:none">
        <form name="lesezeichenform" onsubmit="return false;">
        <h1  align="center">Lesezeichen erstellen</h1>
        <div id="lesezeichen_konfig"> 
        <p>Bitte whlen Sie aus, ob die aktuelle Auswahl bei den<br/> folgenden Feldern, mit im Lesezeichen hinterlegt werden soll.</p>
         <div id="lesezeichen_checkboxen" style="height:250px;overflow:scroll">
         </div>
         <table><tr><td valign="center">Dieses Lesezeichen soll</td><td><input type="radio" name="lesezeichenart" id="lesezeichen_maske" value="maske" checked="true">speziell fr diese Maske gelten</input></td></tr>
         <tr><td></td><td><input type="radio" id="lesezeichen_vorlage" name="lesezeichenart" value="vorlage">eine Merkmalsvorlage sein (<a href="javascript:dojo.widget.byId('merkmalsvorlageinfo').show();">Was ist das?</a>)</input></td></tr>
         </table>
         </div>
         <div id="lesezeichenlinkdiv">
         <p align="center"> Hier Ihr Lesezeichen-Link:</p>
         <h3 align="center"><a id="lesezeichenlink"></a></h3>
         <p align="center" id="lesezeicheninfoIE"> Klicken Sie mit der <b><font color="red">rechten Maustaste</font></b> auf den obigen Link und whlen Sie <br/><br/><b>"Zu Favoriten hinzufgen"</b><br/>
         <br/>
         Es folgt ein Sicherheitshinweis <br/>"Sie fgen einen Favoriten hinzu, der mglicherweise nicht sicher ist"<br/>
         Den knnen Sie besttigen, da SuperX-Lesezeichen nur harmloses JavaScript verwenden. <br/>
         (Zum Aufrufen des Lesezeichens muss im InternetExplorer7 zuvor eine beliebige andere Seite geladen sein.</p>
         <p align="center" id="lesezeicheninfoFF"> Klicken Sie mit der <b><font color="#f17c00">rechten Maustaste</font></b>  auf den obigen Link und whlen Sie <br/><b>"Lesezeichen fr diesen Link hinzufgen"</b>
         </p>
         <br/><br/><br/><br/><br/><br/><br/>
         <p align="center"><input id="hidelesezeichen" type="button" class="clsButtonStyle" onclick="lesezeichendlg.hide();zeigeCombosIE6();" value="Dialog schlieen"></input></p>
         </div>
         <p align="center">
        <input type="button"  class="clsButtonStyle" id="lesezeichen_abbrechen" onclick="lesezeichendlg.hide();zeigeCombosIE6();" value="Abbrechen"></input>&#160;
                <input type="button"  class="clsButtonStyle" id="lesezeichen_ok" onclick="prepareLesezeichenLink();"  value="OK"></input>&#160;
                </p>
                 </form>
</div>
        <!-- end Lesezeichen DLG-->
        
	<div dojoType="dialog" id="merkmalsvorlageinfo" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="100" 
closeNode="merkmalsvorlage_abbrechen" style="z-index:1010;display:none">
<h2 align="center">Merkmalsvorlagen</h2>
<SPAN STYLE="font-size: 1.2em">Normalerweise sind Lesezeichen dafr gedacht, ausgewhlte Berichtsmasken oder Ergebnistabellen wieder aufzurufen.<br/>
Es ist aber darber hinaus auch mglich sogenannte "Merkmalsvorlagen" zu erstellen.<br/><br/>
Dabei werden die auf einer Maske ausgewhlten Merkmale (z.B. Haushaltsjahr=2007 und Kostenstelle=1) gespeichert.<br/>
Sie knnen nun bei der gleichen oder auch anderen Masken diese Vorlage aufrufen und die Merkmale werden als Auswahl eingestellt.<br/><br/>
Weiterhin knnen Sie sogar bei einer Ergebnistabelle die Vorlage aufrufen und die Ergebnisse werden fr die enthaltenen Merkmale neu berechnet.<br/><br/>
(Zu beachten ist allerdings, dass die Feldbezeichnungen passen mssen, z.B. wirkt sich das Merkmal Kostenstelle=1 nicht auf das Feld Institution aus).
<br/><br/>
Bitte beachten Sie auch: diese Funktion ist im Internet Explorer 6.x nicht verfgbar, bitte aktualisieren Sie auf einen aktuellen Browser. 
</SPAN> 
<br/>
 <p align="center"><input type="button"  class="clsButtonStyle" id="merkmalsvorlage_abbrechen" onclick="dojo.widget.byId('merkmalsvorlageinfo').hide()" value="OK"></input></p>
       
</div>
	
	
        <!-- start combodlg braucht nur angezeigt werden, wenn mind 1 combobox--> 
         <div dojoType="dialog" id="combodlg" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="100" 
         closeNode="ok" style="z-index:1011;display:none">
        <form name="comboform" onsubmit="return false;">
        <h3 id="comboElementName" align="center">Auswahl</h3>
         <br/>
         <div id="comboload" style="display:none">
         <br/><br/><br/>
         <h3 align="center"><font color="red">Daten werden geladen</font><br/>
         <img src="/superx/images/progress_bar.gif"></img></h3>
         </div>
        <p align="center">
        <select id="comboselect" name="comboselect">
        <option value="1">1-ja</option>
        <option>keine Auswahl mglich</option>
        </select>
        <br/>
        <br/>
        <label id="multiselecthint">Sie knnen einen oder mehrere Werte auswhlen (<a href="javascript:alert('Halten Sie beim Anklicken Strg gedrckt,um einzelne Elemete auszuwhlen,\noder die Umschalttaste um einen ganzen Block auszuwhlen');">Hinweis</a>)</label> 
        <br/>
        <br/>
        <input type="button"  class="clsButtonStyle" 
        onclick="document.getElementById('suchok').style.display='';document.getElementById('suchselect').style.display='none';document.getElementById('suchuebernehmen').style.display='none';dojo.widget.byId('suchdlg').show();"
        value="Suchen"></input>
        <br/><br/>
        <input type="button" id="abbrechen"  class="clsButtonStyle" onclick="combodlg.hide();zeigeCombosIE6();" value="Abbrechen"></input>&#160;
                <input type="button" id="ok"  class="clsButtonStyle" onclick="maskeComboauswahlUebernehmen();" value="OK"></input>&#160;&#160;&#160;&#160;&#160;
                <input type="button" id="leeren"  class="clsButtonStyle" onclick="document.forms['comboform'].comboselect.selectedIndex=-1;maskeComboauswahlUebernehmen();combodlg.hide()" value="Leeren"></input>
                </p>
        </form>
        </div>
<!-- end combo -->
 <!-- start sicht Definition des Sichtauswahl DLGs braucht nur eingebaut werden wenn mind 1 Sichtfeld-->
 
  <div dojoType="dialog" id="sichtdlg" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="100" 
  closeNode="ok" style="z-index:1012;display:none">
        <form name="treedlgform" onsubmit="return false;">
        <center>
        <table align="center">
        <tr><td colspan="2" class="header" id="sichtElementName" align="center">Auswahl</td></tr>
        <tr>
        <td id="sicht"  align="center"><b>Sicht:</b> ausgewhlte Sicht</td><td id="sichtbutton" ><input  class="submit_pencil" id="Sichtauswahl" type="button" value="Sichtauswahl" onclick="sichtauswahl.show()"></input></td>
        </tr>
        <tr><td id="stand" class="sichtstand" align="center"><b>Stand:</b> 1.1.2007</td><td id="standbutton" class="sichtstand"><input  class="clsButtonStyle" id="Standauswahl" type="button" value="ndern" onclick="dojo.widget.byId('Standeingabedlg').show();"></input></td>
        </tr>
        </table>
        </center>
        <br/>
        <div 
          dojoType="TreeSelectorV3" 
          widgetId="treeSelector" 
          allowedMulti="false" 
          id="treeSelector" eventNames="select:nodeSelected">
          <xsl:text> </xsl:text>
        </div>
        <div dojoType="TreeEmphasizeOnSelect" selector="treeSelector"></div>
        <div dojoType="memtext:TreeLoadingControllerSx" id="treeLoadingController" widgetId="treeLoadingController">
        <xsl:attribute name="RPCUrl">/superx/servlet/SuperXmlMaske?tid=<xsl:value-of select="/maske/@tid"/></xsl:attribute>
        </div>
        <div style="height:325px;overflow:scroll"><!-- IE needs non-dojo div vor scrolling-->
        <div dojoType="memtext:MemTree" widgetId="selTree"    id="selTree"     listeners="treeLoadingController;treeSelector">
        <div dojoType="TreeNodeV3"   title="keine Auswahl mglich" ></div>
               </div>
               </div>
        <br/>
        <center>
        <label id="sichthintmulti">Sie knnen einen oder mehrere Eintrge auswhlen (<a href="javascript:alert('Halten Sie beim Anklicken Strg gedrckt, um mehrere Eintrge auszuwhlen.');">Hinweis</a>)</label>
        <p align="center">
        <input type="button"  class="clsButtonStyle" 
        onclick="document.getElementById('suchok').style.display='';document.getElementById('suchselect').style.display='none';document.getElementById('suchuebernehmen').style.display='none';dojo.widget.byId('suchdlg').show();"
        value="Suchen"></input>&#160;
        </p>
        <p align="center">
        <input type="button" id="abbrechen"  class="clsButtonStyle" onclick="sichtdlg.hide();zeigeCombosIE6();" value="Abbrechen"></input>&#160;
                <input type="button" id="ok"  class="clsButtonStyle" onclick="maskeSichtauswahlUebernehmen();" value="OK"></input>&#160;&#160;&#160;&#160;&#160;
                <input type="button" id="leeren"  class="clsButtonStyle" onclick="dojo.widget.byId('treeSelector').deselectAll();maskeSichtauswahlUebernehmen();sichtdlg.hide();" value="Leeren"></input>
                </p>
                </center>
        </form>
</div>
  <div dojoType="dialog" id="sichtauswahl" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="100" closeNode="ok"
  style="z-index:1014;display:none">
  <h3 align="center">Sicht auswhlen</h3>
  <form name="sichtauswahlform">
  <p align="center">
   <select name="sichtselect">
   <option value="-999">keine Auswahl mglich</option>
   </select>
   </p>
  <p align="center">
  <input type="button"  class="clsButtonStyle" id="abbrechen2" onclick="sichtauswahl.hide()" value="Abbrechen">&#160;</input>
<input type="button" id="ok2"  class="clsButtonStyle" onclick="maskeSichtAendern()" value="OK"></input>
        </p>
        </form>
  </div>
 
  <!-- end sicht -->
  <!-- start suchdlg -->
  <div dojoType="dialog" id="suchdlg" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="100" style="z-index:1015;display:none">
  <h3 align="center">Suche</h3>
  <form name="suchform" onsubmit="return false;">
  <p align="center">
   <input type="text" id="suchtext" onkeypress="enterClicksButton('suchok',event)"></input>
   </p>
   <p align="center">
    <select id="suchselect" size="10">
   
   </select>
</p>
  <p align="center">
  <input type="button"  class="clsButtonStyle" id="abbrechen" onclick="dojo.widget.byId('suchdlg').hide();" value="Abbrechen">&#160;</input>
  <input type="button" id="suchok"  class="clsButtonStyle" onclick="sichtEintraegeSuchen(document.getElementById('suchtext').value);" value="OK"></input>
<input type="button" id="suchuebernehmen"  class="clsButtonStyle" onclick="dojo.widget.byId('suchdlg').hide();combodlg.hide();sichtdlg.hide();suchauswahlUebernehmen();" value="bernehmen"></input>
        </p>
        </form>
  </div> 
  
  <!-- end suchdlg -->
  <!-- start Standeingabe Dlg -->
        <div dojoType="dialog" id="Standeingabedlg" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="100" 
        closeNode="lesezeichen_abbrechen" style="z-index:1100;display:none">
        <form name="Standeingabeform" onsubmit="return false;">
        <h3  align="center">Geben Sie den gewnschten Stand ein</h3>
        
        <p align="center">
        <input type="text" id="gewuenschterStand" length="11" onkeypress="enterClicksButton('stand_ok',event)"></input>
        </p>
         <p align="center">
        <input type="button"  class="clsButtonStyle" id="stand_abbrechen" onclick="document.getElementById('gewuenschterStand').value=''; dojo.widget.byId('Standeingabedlg').hide();" value="Abbrechen"></input>&#160;
                <input type="button"  class="clsButtonStyle" id="stand_ok" onclick="dojo.widget.byId('Standeingabedlg').hide();maskeSichtstandAendern();"  value="OK"></input>&#160;
                </p>
                 </form>
</div>
<!-- end standeingabe -->

  <!-- start images -->
  <div style="display:none">
    <!--  IE  has  a  bug:  it  reloads  all  dynamically  resolved  images,  no  matter,  is  it  
    new  Image()  or  CSS  background.  If  you  don't  specify  images  like  that,
    it  will  reload  them  every  time  a  new  node  is  created  -->
    <img  src="/superx/xml/js/dojo/src/widget/templates/images/TreeV3/i.gif"/>
    <img  src="/superx/xml/js/dojo/src/widget/templates/images/TreeV3/i_half.gif"/>
    <img  src="/superx/xml/js/dojo/src/widget/templates/images/TreeV3/expand_minus.gif"/>
    <img  src="/superx/xml/js/dojo/src/widget/templates/images/TreeV3/expand_plus.gif"/>
    <img  src="/superx/xml/js/dojo/src/widget/templates/images/TreeV3/expand_leaf.gif"/>
    <img  src="/superx/xml/js/dojo/src/widget/templates/images/TreeV3/i_long.gif"/>
    <img  src="/superx/xml/js/dojo/src/widget/templates/images/TreeV3/document.gif"/>
    <img  src="/superx/xml/js/dojo/src/widget/templates/images/TreeV3/open.gif"/>
    <img  src="/superx/xml/js/dojo/src/widget/templates/images/TreeV3/closed.gif"/>
</div>
<!-- end images -->
<!-- start textareadlg--> 
         <div dojoType="dialog" id="textareadlg" bgColor="darkgray" bgOpacity="0.7" toggle="fade" toggleDuration="100" closeNode="ok" style="display:none">
        <form name="textareaform" onsubmit="return false;">
        <h3 id="textareaElementName" align="center">Eingabe</h3>
         <br/>
         
        <p align="center">
        <textarea id="textarea_fld" name="textarea_fld" rows="10" cols="30">
        keine Auswahl mglich</textarea>
        
        <br/>
        <br/>
        
        <br/>
        <br/>
        <input type="button" id="abbrechen"  class="clsButtonStyle" onclick="textareadlg.hide();zeigeCombosIE6();" value="Abbrechen"></input>&#160;
                <input type="button" id="ok"  class="clsButtonStyle" onclick="maskeTextareaUebernehmen();" value="OK"></input>&#160;&#160;&#160;&#160;&#160;
                <input type="button" id="leeren"  class="clsButtonStyle" onclick="document.forms['textareaform'].textarea_fld.value='';maskeTextareaUebernehmen();textareadlg.hide()" value="Leeren"></input>
                </p>
        </form>
        </div>
<!-- end textareaDlg -->
  
</xsl:template>  
  <!-- end dojo-->
  
  <xsl:template name="inputlabel">
  <xsl:if test="art != '13' and  art != '15' and art != '18' ">
              
	 <xsl:if test="obligatorisch='1'">
       <xsl:text>* </xsl:text>
     </xsl:if>
      <xsl:choose>
	<xsl:when test="caption_short != ''"><![CDATA[]]><xsl:value-of select="caption_short" /><![CDATA[]]></xsl:when>
	<xsl:otherwise>
	<xsl:value-of select="name" />
	</xsl:otherwise>
	</xsl:choose>
	
                 </xsl:if>    

</xsl:template>
  <xsl:template name="inputfeld">
<!-- start inputfeld -->
<div dojoType="ContentPane" class="sx_inputfeld">
	    <!--<xsl:attribute name="style">
	    <xsl:text>width:</xsl:text><xsl:value-of select="feldbreite*1.2" /></xsl:attribute>-->

   
<xsl:choose>
<!-- start art 0-->
      <xsl:when test="art='0'">
      <xsl:choose>
        <xsl:when test="zeilenanzahl='1'">
	<div style="margin:0 0 0 6px; padding:0 0 0 0 ">
          <input type="text" >
	  <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
	    <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="MAXLENGTH">
              <xsl:value-of select="laenge"/>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
	    	    <xsl:value-of select="defaultwert/name"/>
	                </xsl:attribute>
            <xsl:attribute name="size">
              <xsl:value-of select="feldbreite div $feldbreite_faktor"/>
            </xsl:attribute>
	    <xsl:if test="typ='date'">
	    
	    <a href="javascript:doNothing()">
	    <xsl:attribute name="onclick"><xsl:text>calDateFormat='DD.MM.yyyy';setDateField(document.forms['maske'].elements['</xsl:text><xsl:value-of select="name" /><xsl:text>']); top.newWin = window.open('/superx/dbformslib/jscal/calendar.html','cal','width=270,height=280')</xsl:text></xsl:attribute>
	    <img src="/superx/dbformslib/jscal/calendar.gif" class="imageCalendar"  border="0"  alt="Kalender ffnen"></img></a>
	   </xsl:if>
	   </input></div>
	   
        </xsl:when>
	<xsl:otherwise><!--zeilenanzahl!='1'-->
	    <!-- <xsl:call-template name="schluesselfeld" />&#160;<xsl:call-template name="dojoTextareaBtnHIS1" />&#160;<xsl:call-template name="valuelabel" /> -->
	    <!--<xsl:call-template name="schluesselfeld" /><xsl:call-template name="dojoTextareaBtnHIS1" /><xsl:call-template name="valuelabel" />-->
	    <xsl:text>&#160;&#160;&#160;</xsl:text><textarea WRAP="on">
            <xsl:attribute name="cols">
              <xsl:value-of select="feldbreite div 10"/>
            </xsl:attribute>
            <xsl:attribute name="rows">
              <xsl:value-of select="zeilenanzahl"/>
            </xsl:attribute>
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
            <xsl:value-of select="defaultwert/name"/>
          </textarea>
	    </xsl:otherwise>
	    </xsl:choose>
	
      </xsl:when>
      <!-- end art 0-->
<!-- start art 1 oder 2 COMBO-->
      <xsl:when test="art='1' or art='2'">
      <!--normale Combo-Box -->
         <xsl:call-template name="schluesselfeld" />
	    <xsl:choose>
	    <!-- start combobox fr zeilenzahl 1/nicht-dynamisches Feld-->
	     <xsl:when test="zeilenanzahl=1 and @isDynamic='false'">
	    <!--Combobox ist nur Auswahlhilfe ausgewertet wird inhalt von Inputfeld!!-->
      <select >
      <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
        <xsl:attribute name="id"><xsl:text>select_</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template></xsl:attribute>
          <xsl:attribute name="NAME">
            <xsl:text>select_</xsl:text><xsl:value-of select="name"/>
          </xsl:attribute>
	  <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
	    <xsl:attribute name="onchange">
	    <xsl:text>c=document.getElementById('</xsl:text>
	    <xsl:text>select_</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
	    <xsl:text>');document.getElementById('</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template><xsl:text>').value=c.options[c.selectedIndex].value;resetValidation();</xsl:text>
	    </xsl:attribute>
             <option />
           <xsl:for-each select="relation/item">
	   <xsl:if test="string-length(name) &gt; 0">
            <option class="maskinput">
              <xsl:attribute name="value">
                <xsl:value-of select="key"/>
              </xsl:attribute>
	      			<!--MB-->
	  		  <xsl:if test="../../defaultwert/name=name">
          		  <xsl:attribute name="selected">true</xsl:attribute>
		    </xsl:if>
              <xsl:value-of select="name"/>
            </option>
	    </xsl:if>
          </xsl:for-each>
        </select>
      </xsl:when>
      <!-- end combobox fr zeilenzahl 1-->
      <!-- start Button and Skript fr zeilenzahl grer 1 -->
      <xsl:otherwise>
      <!--<xsl:call-template name="schluesselfeld" />&#160;-->
     <xsl:call-template name="valuelabel" />&#160;<xsl:call-template name="dojoComboBtnHIS1" />
         
	

      </xsl:otherwise>
            </xsl:choose>
      <!-- end Button and Skript fr zeilenzahl > 1 -->
      </xsl:when>
      <!-- end art 1 -->
<!-- start 8,5 Kommentar/Label-->
   <xsl:when test="art='8' or art='5'">
   <!--label-->
   
      
	 <xsl:value-of select="defaultwert/name"/>
	 
   </xsl:when>
      <xsl:when test="art='9'">
        <xsl:call-template name="treeview">
       </xsl:call-template>
      </xsl:when>
        <xsl:when test="art='10'">
           <input type="checkbox" value="true" >
	   <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
	    <xsl:attribute name="id">
	     <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
	    </xsl:attribute>
	    <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
	    <xsl:if test="defaultwert/name != '' and defaultwert/name != 'false'">
            <xsl:attribute name="checked">
              <xsl:value-of select="defaultwert/name"/>
            </xsl:attribute>
	    </xsl:if>
	    
          </input> &#160;
       
      </xsl:when>
      <!-- end -->
<!-- start art 11 passwort-->
      
      <xsl:when test="art='11'">
      <xsl:if test="zeilenanzahl='1'">
          <input type="password">
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
	    <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="MAXLENGTH">
              <xsl:value-of select="laenge"/>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
              <xsl:value-of select="defaultwert/name"/>
            </xsl:attribute>
            <xsl:attribute name="size">
              <xsl:value-of select="feldbreite div 12"/>
            </xsl:attribute>
	   
          </input>
        </xsl:if>
     </xsl:when>
     <!-- end art 11-->
<!-- start 4,6,8, 12 Sicht -->
     
     <xsl:when test="art='4' or art='6' or art='7' or art='12'">
      <!--<xsl:call-template name="schluesselfeld" />&#160;--><!-- original: <xsl:call-template name="dojosichtBtnHIS1" />&#160;
     <xsl:call-template name="dojosichtValue">
       </xsl:call-template> --> 
     <xsl:call-template name="dojosichtValue"></xsl:call-template>&#160;<xsl:call-template name="dojosichtBtnHIS1" />
     
	  	 
   </xsl:when>
   <!-- end 12-->
<!-- start 13 hidden-->
      <xsl:when test="art='13'">
      <input type="hidden">
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
              <xsl:value-of select="defaultwert/key"/>
            </xsl:attribute>
            
          </input>
	  </xsl:when>
	  <!-- end 13 -->
<!-- start 14 radiobox-->
	  <xsl:when test="art='14'">
      <input type="radio">
      <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
      	<xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
              <xsl:value-of select="defaultwert/name"/>
            </xsl:attribute>
	   
            
          </input>
	  </xsl:when>
	  <!-- end 14-->
<!-- start 15 links-->
	  <xsl:when test="art='15'">
	  <xsl:if test="defaultwert/name != ''">
	  <a class="feldlink">
          <xsl:attribute name="href">
	  <xsl:choose>
	  <!--bei externen Links bentigen wir keine JSESSIONID-->
	  <xsl:when test="starts-with(defaultwert/name,'www')">
              <xsl:value-of select="concat('http://',defaultwert/name)"/>

	  </xsl:when>
	  <xsl:when test="starts-with(defaultwert/name,'http')  or contains(defaultwert/name,'.htm')">
              <xsl:value-of select="defaultwert/name"/>

	  </xsl:when>
	  <xsl:when test="starts-with(defaultwert/name,'nexttable:')">
       <xsl:value-of select="concat('SuperXmlTabelle','?tid=',substring-after(defaultwert/name,'nexttable:'))"/>
	 
	  </xsl:when>
	  <xsl:otherwise>
	  <!--Default: Link auf andere Maske-->
	  <xsl:value-of select="concat('SuperXmlMaske','?tid=',defaultwert/name)"/>
	  </xsl:otherwise>
	  </xsl:choose>
           </xsl:attribute>
	  

            <xsl:value-of select="name"/>
          </a>
	  </xsl:if>
	  </xsl:when>
	  <!-- end 15-->
<!-- start 16 querabhngig combo ausskommentiert-->
   <!-- <xsl:when test="art='16'">
    <xsl:call-template name="schluesselfeld" />&#160;<xsl:call-template name="valuelabel" />&#160;
    </xsl:when>  -->
    <!-- end 16-->
    <xsl:when test="art='17'">
	  <!--Radio-->
	  <input name="{name}" id="{name}" type="hidden" value="{defaultwert/key}" />
	  <xsl:for-each select="relation/item [string-length(name) &gt; 0]">
	   
            <input name="{concat(../../name,'Radio')}" id="{concat(../../name,'Radio',position())}" value="{key}" type="radio" >
	    <xsl:attribute name="onclick"><xsl:text>document.forms[0].elements['</xsl:text><xsl:value-of select="../../name"/>
	    <xsl:text>'].value='</xsl:text><xsl:value-of select="key"/><xsl:text>';return true;</xsl:text></xsl:attribute>
	 <xsl:if test="../../defaultwert/name=name">
          		  <xsl:attribute name="checked"><xsl:text>true</xsl:text></xsl:attribute>
		    </xsl:if>
	    </input>&#160;<xsl:value-of select="name"/><br /> 
            </xsl:for-each>  
	    
         
	  
	  </xsl:when>
	  <xsl:when test="art='18'">
	  </xsl:when>
	    <xsl:when test="art='19'">
	   <input type="file" size="60" name="Datei" />
	   </xsl:when>
	  <xsl:otherwise>Unbekannte Feldart <xsl:value-of select="art"/></xsl:otherwise>
    </xsl:choose>
    </div>
  </xsl:template>
  <!-- start customize  standard ist leer, kann von Spezialstylesheets berlagert werden -->
  <xsl:template name="maskcustomize">
    <xsl:param name="position"/>
 </xsl:template>
			
 <xsl:template name="dojosichtBtnHIS1">
<a title="{concat('Auswahl ',name)}">
<xsl:attribute name="tabindex">
<xsl:value-of select="100+(nummer*10)+3"/>
</xsl:attribute>
       <xsl:attribute name="href"><xsl:text>javascript:maskeSichtLaden(getFieldName(</xsl:text><xsl:value-of select="position()"/><xsl:text>),'</xsl:text><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]><xsl:text>',null);</xsl:text></xsl:attribute>
      <img title="{concat('Auswahl ',name)}" alt="{concat('Auswahl ',name)}" src="../xml/his1/images/icons/pencil.svg" class="svg_icon" border="0">
            </img>
	    </a>
      
	      
  </xsl:template>
  <xsl:template name="dojoTextareaBtnHIS1">
  <a title="{concat('Eingabe ',name)}">
  <xsl:attribute name="tabindex">
<xsl:value-of select="100+(nummer*10)+3"/>
</xsl:attribute>
       <xsl:attribute name="href"><xsl:text>javascript:textareaLaden(getFieldName(</xsl:text><xsl:value-of select="position()"/><xsl:text>),'</xsl:text><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]><xsl:text>');</xsl:text></xsl:attribute>
      <img title="{concat('Eingabe ',name)}" alt="{concat('Eingabe ',name)}" src="../xml/his1/images/icons/pencil.svg" class="svg_icon" border="0">
            </img>
	    </a>
 </xsl:template>
 <xsl:template name="dojoComboBtnHIS1">
<a title="{concat('Auswahl ',name)}">
<xsl:attribute name="tabindex">
<xsl:value-of select="100+(nummer*10)+3"/>
</xsl:attribute>
       <xsl:attribute name="href"><xsl:text>javascript:maskeComboLaden(getFieldName(</xsl:text><xsl:value-of select="position()"/><xsl:text>),'</xsl:text><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]><xsl:text>');</xsl:text></xsl:attribute>
       <xsl:attribute name="tabindex">
<xsl:value-of select="100+(nummer*10)+3"/>
</xsl:attribute>
      <img title="{concat('Auswahl ',name)}" alt="{concat('Auswahl ',name)}" src="../xml/his1/images/icons/pencil.svg" class="svg_icon" border="0">
            </img>
	    </a>
	    <!--
	    <div name="{concat('btn',name)}" class="sx_buttondiv">
   
	    <xsl:attribute name="onclick"><xsl:text>javascript:maskeComboLaden('</xsl:text><xsl:value-of select="name"/><xsl:text>','</xsl:text><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]><xsl:text>');</xsl:text></xsl:attribute>
	    <span>
	 <xsl:choose>
        <xsl:when test="obligatorisch='1'">
        <xsl:attribute name="class">labelPflicht</xsl:attribute></xsl:when>
      <xsl:otherwise><xsl:attribute name="class">labelNormal</xsl:attribute></xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
	<xsl:when test="caption_short != ''"><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]></xsl:when>
	    <xsl:otherwise>
	     
          <xsl:value-of select="name"/>
       	    </xsl:otherwise>
	    </xsl:choose>
	    </span>
	    </div>-->
 	    </xsl:template>
 	    
 	    
 	    
 	    
 	    
 	    
 	    <xsl:template name="sx_field">
<xsl:param name="browser" />
<xsl:param name="zeilenhoehe" />
  <!-- rownr-Element im Servlet gesetzt -->
  <!-- Abwrtskomp. im Applet: Buttonbreite=0 abfangen -->
  <xsl:variable name="buttonbreite">
  <xsl:choose>
  <xsl:when test="buttonbreite=0 or buttonbreite='null'">
  <xsl:value-of select="100" /> 
  </xsl:when>
  <xsl:otherwise>
 <xsl:value-of select="buttonbreite"/> 
 </xsl:otherwise>
 </xsl:choose>
 </xsl:variable>
 <xsl:attribute name="style">
 
 <xsl:text>position:absolute;overflow:visible;border:none;display:inline;width:</xsl:text><xsl:value-of select="$buttonbreite+feldbreite+150"/><xsl:text>px;</xsl:text>
 <xsl:text>height:</xsl:text><xsl:value-of select="$zeilenhoehe"/><xsl:text>px;</xsl:text>
 <xsl:text>top:</xsl:text><xsl:value-of select="$zeilenhoehe * rownr"/><xsl:text>px;</xsl:text>
 <xsl:text>left:</xsl:text><xsl:value-of select="x*1.2"/><xsl:text>px;</xsl:text>
 </xsl:attribute>
 
  <!-- start  Label-->
   <div class="sx_fieldlabel" dojoType="ContentPane" >
   <xsl:attribute name="style"><xsl:value-of select="concat('width:',$buttonbreite,'px; min-width:',$buttonbreite,'px')"/></xsl:attribute>


   <xsl:choose>
    <!-- start 0-->
    <xsl:when test="art='0' and zeilenanzahl &gt; 1">
    <div name="{concat('btn',name)}" class="sx_buttondiv">
    
  	    <xsl:attribute name="onclick"><xsl:text>javascript:textareaLaden('</xsl:text><xsl:value-of select="name" /><xsl:text>','</xsl:text><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]><xsl:text>');</xsl:text></xsl:attribute>
	    <span>
	 <xsl:choose>
        <xsl:when test="obligatorisch='1'">
        <xsl:attribute name="class">labelPflicht</xsl:attribute></xsl:when>
      <xsl:otherwise><xsl:attribute name="class">labelNormal</xsl:attribute></xsl:otherwise>
	</xsl:choose>
	    <xsl:choose>
	<xsl:when test="caption_short != ''"><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]></xsl:when>
	    <xsl:otherwise>
	      
          <xsl:value-of select="name"/>
        
	    </xsl:otherwise>
	    </xsl:choose>
	    </span>
	    </div>
	    
   
    </xsl:when>
    <!-- end 0 -->
    <!-- start 1,2-->
    <xsl:when test="(art='1' or art='2') and (@isDynamic='true' or zeilenanzahl &gt; 1)">
    <div name="{concat('btn',name)}" class="sx_buttondiv">
   
	    <xsl:attribute name="onclick"><xsl:text>javascript:maskeComboLaden(getFieldName(</xsl:text><xsl:value-of select="position()"/><xsl:text>),'</xsl:text><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]><xsl:text>');</xsl:text></xsl:attribute>
	    <span>
	 <xsl:choose>
        <xsl:when test="obligatorisch='1'">
        <xsl:attribute name="class">labelPflicht</xsl:attribute></xsl:when>
      <xsl:otherwise><xsl:attribute name="class">labelNormal</xsl:attribute></xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
	<xsl:when test="caption_short != ''"><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]></xsl:when>
	    <xsl:otherwise>
	     
          <xsl:value-of select="name"/>
       	    </xsl:otherwise>
	    </xsl:choose>
	    </span>
	    </div>
	    </xsl:when>
	    <!-- end 1,2-->
	    <!-- start 4,6,7,12 Sichten -->
	 <xsl:when test="(art='4' or art='6' or art='7' or art='12') and attribut!='hidden' ">
	 <xsl:call-template name="dojosichtBtn" />
	 </xsl:when>
	 <!-- end-->
	 <!-- start 13/15-->
	 <xsl:when test="art = '13' or art = '15' or art = '18'">
	 <!--Kein Label bei versteckten Feldern und Hyperlinks-->
	 </xsl:when>
	 <!-- end 13/15-->
	 <!-- start 16 auskommentiert -->
	<!-- <xsl:when test="art = '16'">
	 <div name="{concat('btn',name)}"  class="sx_buttondiv">
        <xsl:attribute name="onclick"><xsl:text>javascript:maskeComboLaden('</xsl:text><xsl:value-of select="name"/><xsl:text>','</xsl:text><![CDATA[]]><xsl:value-of select="caption_short"/><![CDATA[]]><xsl:text>');</xsl:text></xsl:attribute>
     
        <xsl:text>);</xsl:text>
        </xsl:attribute>
        <span>
	 <xsl:choose>
        <xsl:when test="obligatorisch='1'">
        <xsl:attribute name="class">labelPflicht</xsl:attribute></xsl:when>
      <xsl:otherwise><xsl:attribute name="class">labelNormal</xsl:attribute></xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
    <xsl:when test="caption_short != ''">
        <xsl:value-of select="caption_short"/>
       
        </xsl:when>
        <xsl:otherwise>
         
          <xsl:value-of select="name"/>
       
        </xsl:otherwise>
        </xsl:choose>
	</span>
        </div>
	 </xsl:when>  -->
	 <!-- end 16-->
	 <!-- start otherwise-->
    <xsl:otherwise>
         	 <span>
	 <xsl:choose>
        <xsl:when test="obligatorisch='1'">
        <xsl:attribute name="class">labelPflicht</xsl:attribute></xsl:when>
      <xsl:otherwise><xsl:attribute name="class">labelNormal</xsl:attribute></xsl:otherwise>
	</xsl:choose>
      <xsl:choose>
	<xsl:when test="caption_short != ''"><![CDATA[]]><xsl:value-of select="caption_short" /><![CDATA[]]></xsl:when>
	<xsl:otherwise>
	<xsl:value-of select="name" />
	</xsl:otherwise>
	</xsl:choose>
	</span>
     
   
                        
</xsl:otherwise>
 <!-- end otherwise -->
</xsl:choose>
</div>
<!-- end label-->
<!-- start inputfeld -->
<div dojoType="ContentPane" class="sx_inputfeld">
	    <!--<xsl:attribute name="style">
	    <xsl:text>width:</xsl:text><xsl:value-of select="feldbreite*1.2" /></xsl:attribute>-->

   <xsl:if test="caption_long != '' and art != '13' ">
	<div dojoType="tooltip" connectId="{concat('f_',tid)}" style="display:none;z-index:1000">
	<!--todo: br-Tags abfangen-->
	<xsl:call-template name="br_to_newline">
	<xsl:with-param name="string"><![CDATA[]]><xsl:value-of select="caption_long"/><![CDATA[]]></xsl:with-param>
	<xsl:with-param name="search">&lt;br&gt;</xsl:with-param>
	<!--<xsl:with-param name="replace"><xsl:text>&#10;</xsl:text></xsl:with-param>-->
	</xsl:call-template>
		</div>
		</xsl:if>
	
	
	
	
<xsl:choose>
<!-- start art 0-->
      <xsl:when test="art='0'">
      
        <xsl:if test="zeilenanzahl='1'">
          <input type="text" >
	  <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
	    <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="MAXLENGTH">
              <xsl:value-of select="laenge"/>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
	    <!--<xsl:choose>
	    <xsl:when test="typ='date'">
	    <xsl:if test="string-length(defaultwert/name) &gt; 0">
	    <xsl:value-of select="concat(substring(defaultwert/name,7,4),'-',substring(defaultwert/name,4,2),'-',substring(defaultwert/name,1,2))"/>
	    </xsl:if>
	    </xsl:when>
	    <xsl:otherwise>-->
	    <xsl:value-of select="defaultwert/name"/>
	    <!--</xsl:otherwise>
	    </xsl:choose>-->
            </xsl:attribute>
            <xsl:attribute name="size">
              <xsl:value-of select="feldbreite div $feldbreite_faktor"/>
            </xsl:attribute>
	    <xsl:if test="typ='date'">
	    <!--
	    <xsl:attribute name="dojoType"><xsl:text>dropdowndatepicker</xsl:text> </xsl:attribute>
	    <xsl:attribute name="displayFormat"><xsl:text>dd.MM.yyyy</xsl:text> </xsl:attribute>
	    <xsl:attribute name="saveFormat"><xsl:text>dd.MM.yyyy</xsl:text></xsl:attribute>
	    <xsl:if test="string-length(defaultwert/name) &gt; 0">
	    <xsl:attribute name="date"><xsl:value-of select="concat(substring(defaultwert/name,7,4),'-',substring(defaultwert/name,4,2),'-',substring(defaultwert/name,1,2))"/></xsl:attribute>
	    </xsl:if>-->
	    <a href="javascript:doNothing()">
	    <xsl:attribute name="onclick"><xsl:text>calDateFormat='DD.MM.yyyy';setDateField(document.forms['maske'].elements['</xsl:text><xsl:value-of select="name" /><xsl:text>']); top.newWin = window.open('/superx/dbformslib/jscal/calendar.html','cal','width=270,height=280')</xsl:text></xsl:attribute>
	    <img src="/superx/dbformslib/jscal/calendar.gif" class="imageCalendar"  border="0"  alt="Kalender ffnen"></img></a>
	   </xsl:if>
	   </input>
        </xsl:if>
        <xsl:if test="zeilenanzahl!='1'">
	    <!-- <xsl:call-template name="schluesselfeld" />&#160;<xsl:call-template name="valuelabel" />  Wegen versatz im His1 Layout Leerzeichen gelscht-->
	    <xsl:call-template name="schluesselfeld" /><xsl:call-template name="valuelabel" />
      </xsl:if>
	
      </xsl:when>
      <!-- end art 0-->
<!-- start art 1 oder 2 COMBO-->
      <xsl:when test="art='1' or art='2'">
      <!--normale Combo-Box -->
         	    <!-- <xsl:call-template name="schluesselfeld" />&#160; Wegen versatz im His1 Layout Leerzeichen gelscht-->
	    <xsl:call-template name="schluesselfeld" />
	    <xsl:choose>
	    <!-- start combobox fr zeilenzahl 1/nicht-dynamisches Feld-->
	     <xsl:when test="zeilenanzahl=1 and @isDynamic='false'">
	    <!--Combobox ist nur Auswahlhilfe ausgewertet wird inhalt von Inputfeld!!-->
      <select >
      <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
        <xsl:attribute name="id"><xsl:text>select_</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template></xsl:attribute>
          <xsl:attribute name="NAME">
            <xsl:text>select_</xsl:text><xsl:value-of select="name"/>
          </xsl:attribute>
	  <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
	    <xsl:attribute name="onchange">
	    <xsl:text>c=document.getElementById('</xsl:text>
	    <xsl:text>select_</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
	    <xsl:text>');document.getElementById('</xsl:text><xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template><xsl:text>').value=c.options[c.selectedIndex].value;resetValidation();</xsl:text>
	    </xsl:attribute>
             <option />
           <xsl:for-each select="relation/item">
	   <xsl:if test="string-length(name) &gt; 0">
            <option class="maskinput">
              <xsl:attribute name="value">
                <xsl:value-of select="key"/>
              </xsl:attribute>
	      			<!--MB-->
	  		  <xsl:if test="../../defaultwert/name=name">
          		  <xsl:attribute name="selected">true</xsl:attribute>
		    </xsl:if>
              <xsl:value-of select="name"/>
            </option>
	    </xsl:if>
          </xsl:for-each>
        </select>
      </xsl:when>
      <!-- end combobox fr zeilenzahl 1-->
      <!-- start Button and Skript fr zeilenzahl grer 1 -->
      <xsl:otherwise>
         <xsl:call-template name="valuelabel" />&#160;
	 <!--   <script language="JavaScript">
	    var a=[new Option("testing","testing"),
	    <xsl:for-each select="relation/item">
	   <xsl:if test="string-length(name) &gt; 0">
           <xsl:text>new Option("</xsl:text>
	   <xsl:call-template name="escape-quote"><xsl:with-param name="string" select="name" /></xsl:call-template>
	   <xsl:text>","</xsl:text><xsl:value-of select="key"/><xsl:text>"</xsl:text>
		<xsl:choose>      			
	  		  <xsl:when test="../../defaultwert/name=name">
          		  <xsl:text>,true,true)</xsl:text>
		    </xsl:when>
		    <xsl:otherwise><xsl:text>,false,false)</xsl:text></xsl:otherwise>
		    </xsl:choose>
		    <xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
    	    </xsl:if>
          </xsl:for-each>
	  ];
	</script>-->

      </xsl:otherwise>
            </xsl:choose>
      <!-- end Button and Skript fr zeilenzahl > 1 -->
      </xsl:when>
      <!-- end art 1 -->
<!-- start 8,5 Kommentar/Label-->
   <xsl:when test="art='8' or art='5'">
   <!--label-->
   
      <xsl:value-of select="defaultwert/name"/>
   </xsl:when>
      <xsl:when test="art='9'">
        <xsl:call-template name="treeview">
       </xsl:call-template>
      </xsl:when>
        <xsl:when test="art='10'">
           <input type="checkbox" value="true" >
	   <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
	    <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
	    <xsl:if test="defaultwert/name != '' and defaultwert/name != 'false'">
            <xsl:attribute name="checked">
              <xsl:value-of select="defaultwert/name"/>
            </xsl:attribute>
	    </xsl:if>
	    
          </input> &#160;
       
      </xsl:when>
      <!-- end -->
<!-- start art 11 passwort-->
      
      <xsl:when test="art='11'">
      <xsl:if test="zeilenanzahl='1'">
          <input type="password">
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
	    <xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="MAXLENGTH">
              <xsl:value-of select="laenge"/>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
              <xsl:value-of select="defaultwert/name"/>
            </xsl:attribute>
            <xsl:attribute name="size">
              <xsl:value-of select="feldbreite div 12"/>
            </xsl:attribute>
	   
          </input>
        </xsl:if>
     </xsl:when>
     <!-- end art 11-->
<!-- start 4,6,8, 12 Sicht -->
     
     <xsl:when test="art='4' or art='6' or art='7' or art='12'">
     <xsl:call-template name="dojosichtValue">
       </xsl:call-template>
     
     
	  	 
   </xsl:when>
   <!-- end 12-->
<!-- start 13 hidden-->
      <xsl:when test="art='13'">
      <input type="hidden">
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
              <xsl:value-of select="defaultwert/key"/>
            </xsl:attribute>
            
          </input>
	  </xsl:when>
	  <!-- end 13 -->
<!-- start 14 radiobox-->
	  <xsl:when test="art='14'">
      <input type="radio">
      <xsl:attribute name="class">
	  <xsl:choose>
	  <xsl:when test="obligatorisch='1'"> 
              <xsl:text>maskinputPflicht</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
	      <xsl:text>maskinput</xsl:text>
	      </xsl:otherwise>
	      </xsl:choose>
            </xsl:attribute>
      	<xsl:attribute name="tabindex">
              <xsl:value-of select="100+(nummer*10)+2"/>
            </xsl:attribute>
            <xsl:attribute name="NAME">
              <xsl:value-of select="name"/>
            </xsl:attribute>
            <xsl:attribute name="id">
              <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template>
            </xsl:attribute>
            <xsl:attribute name="VALUE">
              <xsl:value-of select="defaultwert/name"/>
            </xsl:attribute>
	   
            
          </input>
	  </xsl:when>
	  <!-- end 14-->
<!-- start 15 links-->
	  <xsl:when test="art='15'">
	  <xsl:if test="defaultwert/name != ''">
	  <a class="feldlink">
          <xsl:attribute name="href">
	  <xsl:choose>
	  <!--bei externen Links bentigen wir keine JSESSIONID-->
	  <xsl:when test="starts-with(defaultwert/name,'www')">
              <xsl:value-of select="concat('http://',defaultwert/name)"/>

	  </xsl:when>
	  <xsl:when test="starts-with(defaultwert/name,'http')  or contains(defaultwert/name,'.htm')">
              <xsl:value-of select="defaultwert/name"/>

	  </xsl:when>
	  <xsl:when test="starts-with(defaultwert/name,'nexttable:')">
       <xsl:value-of select="concat('SuperXmlTabelle','?tid=',substring-after(defaultwert/name,'nexttable:'))"/>
	 
	  </xsl:when>
	  <xsl:otherwise>
	  <!--Default: Link auf andere Maske-->
	  <xsl:value-of select="concat('SuperXmlMaske','?tid=',defaultwert/name)"/>
	  </xsl:otherwise>
	  </xsl:choose>
           </xsl:attribute>
	  

            <xsl:value-of select="name"/>
          </a>
	  </xsl:if>
	  </xsl:when>
	  <!-- end 15-->
<!-- start 16 querabhngig combo ausskommentiert-->
   <!-- <xsl:when test="art='16'">
    <xsl:call-template name="schluesselfeld" />&#160;<xsl:call-template name="valuelabel" />&#160;
    </xsl:when>  -->
    <!-- end 16-->
    <xsl:when test="art='17'">
	  <!--Radio-->
	  <input name="{name}" id="{name}" type="hidden" value="{defaultwert/key}" />
	  <xsl:for-each select="relation/item [string-length(name) &gt; 0]">
	   
            <input name="{concat(../../name,'Radio')}" id="{concat(../../name,'Radio',position())}" value="{key}" type="radio" >
	    <xsl:attribute name="onclick"><xsl:text>document.forms[0].elements['</xsl:text><xsl:value-of select="../../name"/>
	    <xsl:text>'].value='</xsl:text><xsl:value-of select="key"/><xsl:text>';return true;</xsl:text></xsl:attribute>
	 <xsl:if test="../../defaultwert/name=name">
          		  <xsl:attribute name="checked"><xsl:text>true</xsl:text></xsl:attribute>
		    </xsl:if>
	    </input>&#160;<xsl:value-of select="name"/><br /> 
            </xsl:for-each>  
	    
         
	  
	  </xsl:when>
	  <xsl:when test="art='18'">
	  </xsl:when>
	  <xsl:otherwise>Unbekannte Feldart <xsl:value-of select="art"/></xsl:otherwise>
    </xsl:choose>
    </div>
	
	
  </xsl:template>
     <xsl:template name="valuelabel">
<input type="label" readonly ="true" class="sx_labelRight">
	     <xsl:attribute name="name"><xsl:text>label_</xsl:text>  <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template></xsl:attribute>
	     <xsl:attribute name="id"><xsl:text>label_</xsl:text> <xsl:call-template name="create_varname"><xsl:with-param name="string"><xsl:value-of select="name"/></xsl:with-param></xsl:call-template></xsl:attribute>
	     
	     <xsl:attribute name="tabindex">
	     
	     <xsl:value-of select="10000+(nummer*10)+2"/>
	     </xsl:attribute>
	   
	     <xsl:attribute name="value">
	     <xsl:choose> 
	    <xsl:when test="defaultwert/key!=''"><xsl:value-of select="defaultwert/name"/></xsl:when>
            <!-- AK 20.08.2014 von "bitte whlen" nach "nichts gewhlt" -->
	    <xsl:otherwise> nichts gewhlt </xsl:otherwise>
	    </xsl:choose>
	    </xsl:attribute>
		<xsl:attribute name="onClick">
          	<xsl:text>javascript:maskeComboLaden(getFieldName(</xsl:text>
          	<xsl:value-of select="position()" /><xsl:text>),'</xsl:text><![CDATA[]]>
          	<xsl:value-of select="caption_short" /><![CDATA[]]><xsl:text>');</xsl:text>
        </xsl:attribute>
	    </input>
</xsl:template>
 </xsl:stylesheet>

