<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:fox="http://xml.apache.org/fop/extensions" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:saxon="http://icl.com/saxon" extension-element-prefixes="saxon" >
<xsl:import href="pageComponents_html.xsl" />
<!--In diesem Stylesheet knnen Sie individuelle templates unterbringen,
  die in ihrer Przedenz das normale Stylesheet 
  pageComponents_html.xsl berragt. --> 
<xsl:import href="pageComponents_html_final.xsl" />
<xsl:import href="resultset_html.xsl" />
<xsl:decimal-format name="German" grouping-separator="." NaN="" zero-digit ="0" decimal-separator="," />
<xsl:template match="ergebnisse">
<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
<fo:layout-master-set>
<fo:simple-page-master master-name="pagemaster1" page-height="598.0pt" page-width="845.0pt" margin-top="10.0pt" margin-left="10.0pt" margin-bottom="10.0pt" margin-right="10.0pt">
<fo:region-body margin-left="28.0pt" margin-top="73.0pt" margin-bottom="28.0pt" margin-right="28.0pt"/>
<fo:region-before extent="73.0pt" precedence="true"/>
<fo:region-after extent="28.0pt" precedence="true"/>
<fo:region-start extent="28.0pt" precedence="false"/>
<fo:region-end extent="28.0pt" precedence="false"/>
</fo:simple-page-master>
</fo:layout-master-set>
<xsl:for-each select="ergebnis">
<fo:page-sequence master-name="pagemaster1" master-reference="pagemaster1">
<xsl:attribute name="force-page-count">no-force</xsl:attribute>
<fo:static-content flow-name="xsl-region-before">
<xsl:call-template name="logo_rechts"></xsl:call-template><fo:block-container position="absolute" top="15.0pt" left="61.0pt" height="29.0pt" width="461.0pt">
<fo:block line-height="24.0pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="start" position="relative" top="15.0pt" left="61.0pt" height="29.0pt" width="461.0pt" color="#000000" font-family="sans-serif" font-size="20.0pt" font-weight="bold">
<xsl:value-of disable-output-escaping="no" select="maskenname"/>
</fo:block>
</fo:block-container>
<!--<fo:block-container position="absolute" top="46.0pt" left="61.0pt" height="20.0pt" width="100.0pt">
<fo:block line-height="14.399999999999999pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="start" position="relative" top="46.0pt" left="61.0pt" height="20.0pt" width="100.0pt" color="#000000" font-family="sans-serif" font-size="12.0pt">
<fo:block text-align="left" white-space-collapse="false"  linefeed-treatment="preserve" >
<fo:inline>
<xsl:text>Haushaltsjahr: </xsl:text></fo:inline>
<fo:inline>
<xsl:value-of disable-output-escaping="no" select="felder/feld[@varname='Haushaltsjahr']/value_caption"/>
</fo:inline>
</fo:block>
</fo:block>
</fo:block-container>-->
<xsl:call-template name="legende_fo" />
</fo:static-content>
<fo:static-content flow-name="xsl-region-after">
<!--<fo:block-container position="absolute" top="7.0pt" left="690.0pt" height="17.0pt" width="33.0pt" display-align="before">
<fo:block white-space-collapse="false"  linefeed-treatment="preserve"  text-align="start" position="relative" top="7.0pt" left="790.0pt" height="17.0pt" width="33.0pt" color="#000000" font-family="sans-serif" font-size="12.0pt"><fo:page-number/></fo:block>
<fo:block text-align="center" font-size="12pt">Seite <fo:page-number /> von <fo:page-number-citation ref-id="pageNumberCitation1" /></fo:block>
</fo:block-container>-->
<fo:block text-align="center" font-size="12pt">Seite <fo:page-number /> von <fo:page-number-citation ref-id="pageNumberCitation1" />
</fo:block>
</fo:static-content>
<fo:static-content flow-name="xsl-region-start"/>
<fo:static-content flow-name="xsl-region-end"/>
<fo:flow flow-name="xsl-region-body">
<fo:block/>
<fo:block-container position="absolute" top="4pt" left="2pt" height="752.0pt" width="536.0pt" border-width="1.0pt"> <fo:block span="none" white-space-collapse="false"  font-family="Helvetica" font-size="12pt" text-align="start" position="relative" top="44pt" left="27pt" height="752.0pt" width="536.0pt">
<!--<fo:instream-foreign-object  xmlns:xlink="http://www.w3.org/1999/xlink"><svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="600" height="600" viewBox="0 0 1000 1000"> <g id="test-body-content"><text x="0" y="250" style="opacity:.1; font-family:Arial; font-size:200pt; fill:rgb(200,200,200)">XSLfast</text><text x="50" y="420" style="opacity:.1; font-family:Arial; font-size:200pt; fill:rgb(200,200,200)">DEMO</text></g></svg></fo:instream-foreign-object>-->
</fo:block></fo:block-container><fo:block span="none"><!-- GENERATE TABLE START-->

<fo:table table-layout="fixed">
<fo:table-column column-width="40.0pt"/>
<fo:table-column column-width="158.0pt"/>
<fo:table-column column-width="201.0pt"/>
<fo:table-column column-width="80.0pt"/>
<fo:table-column column-width="81.0pt"/>
<fo:table-column column-width="115.0pt"/>
<fo:table-header>

<fo:table-row>
<fo:table-cell display-align="before">
<fo:block line-height="14.399999999999999pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="start" color="#000000" font-family="sans-serif" font-size="12.0pt" font-weight="bold">
<xsl:text>Ebene</xsl:text></fo:block>
</fo:table-cell>
<fo:table-cell display-align="before">
<fo:block line-height="14.399999999999999pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="start" color="#000000" font-family="sans-serif" font-size="12.0pt" font-weight="bold">
<xsl:text>Studiengang / Fach / SB / FGR</xsl:text></fo:block>
</fo:table-cell>
<fo:table-cell display-align="before">
<fo:block line-height="14.399999999999999pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="start" color="#000000" font-family="sans-serif" font-size="12.0pt" font-weight="bold">
<xsl:text>Lehreinheit</xsl:text></fo:block>
</fo:table-cell>
<fo:table-cell display-align="before">
<fo:block line-height="14.399999999999999pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="end" color="#000000" font-family="sans-serif" font-size="12.0pt" font-weight="bold">
<fo:block text-align="right" white-space-collapse="false"  linefeed-treatment="preserve" >
<fo:inline>
<xsl:text>Kosten</xsl:text></fo:inline>
<fo:inline>
<xsl:text>
</xsl:text></fo:inline>
<fo:inline>
<xsl:text>in EUR</xsl:text></fo:inline>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell display-align="before">
<fo:block line-height="14.399999999999999pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="end" color="#000000" font-family="sans-serif" font-size="12.0pt" font-weight="bold">
<fo:block text-align="right" white-space-collapse="false"  linefeed-treatment="preserve" >
<fo:inline>
<xsl:text>Zahl der Studierenden
</xsl:text></fo:inline>
<fo:inline>
<xsl:text>(VZ)</xsl:text></fo:inline>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell display-align="before">
<fo:block line-height="14.399999999999999pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="end" color="#000000" font-family="sans-serif" font-size="12.0pt" font-weight="bold">
<fo:block text-align="right" white-space-collapse="false"  linefeed-treatment="preserve" >
<fo:inline>
<xsl:text>Kosten des
</xsl:text></fo:inline>
<fo:inline>
<xsl:text>Studiengangs pro
</xsl:text></fo:inline>
<fo:inline>
<xsl:text>Studierendem</xsl:text></fo:inline>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-header>
<fo:table-body>
<xsl:for-each select="ergebniselement/sqlerg/row">
<xsl:variable name="altColor6">
<xsl:if test="col/f_name  = 'ebene'">
<xsl:choose>
<xsl:when test="col[ f_name = 'ebene' ] /wert ='1'">
<xsl:text>#9999ff</xsl:text>
</xsl:when>
<xsl:when test="col[ f_name = 'ebene' ] /wert ='2'">
<xsl:text>#ccccff</xsl:text>
</xsl:when> 
<xsl:when test="col[ f_name = 'ebene' ] /wert ='3'">
<xsl:text>#ccccff</xsl:text>
</xsl:when>  
<xsl:when test="col[ f_name = 'ebene' ] /wert ='4'">
<xsl:text>#e9ecff</xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:text>#ffffff</xsl:text>
</xsl:otherwise>
</xsl:choose>
</xsl:if>
</xsl:variable>

<!--<xsl:if test="position() mod 2 = 1">  #ffffff</xsl:if><xsl:if test="position() mod 2 = 0">#c0c0c0</xsl:if></xsl:variable>-->
<fo:table-row background-color="{$altColor6}">
<fo:table-cell display-align="before">
<fo:block line-height="14.399999999999999pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="start" color="#000000" font-family="sans-serif" font-size="10.0pt">
<xsl:value-of disable-output-escaping="no" select="col[@id='0']/wert"/>
</fo:block>
</fo:table-cell>
<fo:table-cell display-align="before">
<fo:block line-height="14.399999999999999pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="start" color="#000000" font-family="sans-serif" font-size="10.0pt">
<xsl:value-of disable-output-escaping="no" select="col[@id='1']/wert"/>
</fo:block>
</fo:table-cell>
<fo:table-cell display-align="before">
<fo:block line-height="14.399999999999999pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="start" color="#000000" font-family="sans-serif" font-size="10.0pt">
<xsl:value-of disable-output-escaping="no" select="col[@id='2']/wert"/>
</fo:block>
</fo:table-cell>
<fo:table-cell display-align="before">
<fo:block position="relative" white-space-collapse="false"  linefeed-treatment="preserve"  display-align="before" text-align="end" color="#000000" font-family="sans-serif" font-size="10.0pt">
<xsl:value-of select="format-number(col[@id='3']/wert,'###.###.###.###.##0,00','German')" />
</fo:block>
</fo:table-cell>
<fo:table-cell display-align="before">
<fo:block line-height="14.399999999999999pt" white-space-collapse="false"  linefeed-treatment="preserve"  text-align="end" color="#000000" font-family="sans-serif" font-size="10.0pt">
<xsl:value-of select="format-number(col[@id='4']/wert,'###.###.###.###.##0,00','German')" />
</fo:block>
</fo:table-cell>
<fo:table-cell display-align="before">
<fo:block position="relative" white-space-collapse="false"  linefeed-treatment="preserve"  display-align="before" text-align="end" color="#000000" font-family="sans-serif" font-size="10.0pt">
<xsl:value-of select="format-number(col[@id='5']/wert,'###.###.###.###.##0,00','German')" />
</fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:for-each></fo:table-body>
</fo:table>
</fo:block><xsl:if test='position()=last()'>
<fo:block id="pageNumberCitation1"/>
</xsl:if>
</fo:flow>
</fo:page-sequence>
</xsl:for-each></fo:root>
</xsl:template>

<!-- GENERATED TEMPLATE logo_rechts -->
<xsl:template name="logo_rechts" >


<fo:block-container  position="absolute" top="6.0pt" left="694.0pt" height="52.0pt" width="52.0pt">
<fo:block  text-align="start">
<xsl:variable name="filename">superx.gif</xsl:variable>
<fo:external-graphic src="../images/{$filename}" position="relative" top="8.0pt" left="694.0pt"/>
</fo:block>
</fo:block-container>

</xsl:template>
<xsl:template name="legende_fo">
<fo:block-container position="absolute" top="46.0pt" left="21.0pt" height="22.0pt" width="630.0pt">
<fo:block font-family="sans-serif" line-height="11pt" font-size="10pt" border-width="0.2mm" border-style="solid" border-color="gray" space-after="10mm">
<xsl:for-each select="/ergebnisse/ergebnis/felder/feld">
	<xsl:if test="value !=''  and @varname != 'sort' and @varname != 'maxoffset'">

		<fo:inline>
		<xsl:choose>
		<xsl:when test="string-length(caption_short) &gt; 0 and caption_short != 'null'" >
		<xsl:value-of select="caption_short" />
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="@varname" />
		</xsl:otherwise>
		</xsl:choose></fo:inline><fo:inline>:&#160;</fo:inline>
		<fo:inline font-style="italic" font-weight="bold">
		<xsl:if test="string-length(value_caption) &lt; 50">
			<xsl:value-of select="value_caption" />
		</xsl:if>
		<xsl:if test="string-length(value_caption) &gt; 49">
			<xsl:value-of select="substring(value_caption,0,50)" />...
		</xsl:if>
		;&#160;</fo:inline>
		
	</xsl:if>
	
</xsl:for-each>
Stand: <xsl:value-of select="/ergebnisse/ergebnis/stand" />
</fo:block>
</fo:block-container>
<!--
<xsl:for-each select="/ergebnis/felder/msgs/msg">
	<xsl:if test="wert !=''">
	<fo:block space-after="10mm" font-family="sans-serif" line-height="16pt" font-size="14pt">
	<xsl:value-of select="wert" />
	</fo:block>
	</xsl:if>
</xsl:for-each>-->
</xsl:template>
<xsl:template name="foheader">
<xsl:param name="derwert" /> 
<fo:table-cell border-width="0.5mm" padding-left="1mm" border-style="solid"><xsl:text>
</xsl:text>
                                     <fo:block font-size="12pt" 
                                         font-weight="bold"
					  language="en" hyphenate="true">
                                         <xsl:variable name="header1"> 
	<xsl:choose>
		<xsl:when test="(contains(string($derwert),'\n'))">
		<xsl:value-of select="substring-before($derwert,'\n') "/>
		 <xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($derwert,'\n') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:copy-of select="$derwert" />
		</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
	<xsl:variable name="header2"> 
	<xsl:choose>
		<xsl:when test="(contains(string($header1),'\n'))">
		<xsl:value-of select="substring-before($header1,'\n') "/>
		<xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($header1,'\n') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:copy-of select="$header1" />
		</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test="(contains(string($header2),'\000'))">
		<xsl:value-of select="substring-before($header2,'\000') "/>
		<xsl:text>
</xsl:text>
		<xsl:value-of select="substring-after($header2,'\000') "/>
		</xsl:when>
		<xsl:otherwise>
		<xsl:copy-of select="$header2" />
		</xsl:otherwise>
	</xsl:choose><xsl:text>
</xsl:text>
</fo:block>
</fo:table-cell><xsl:text>
</xsl:text>

</xsl:template>
</xsl:stylesheet>
