<#macro version_lookup_statement jahr monat=1>
SELECT
    trim(krv.report_id) AS report,
    trim(sts.filename) as filename,
    trim(sts.contenttype) as contenttype,
    CASE WHEN TRIM(sts.contenttype) = 'application/pdf' THEN 'PDF' ELSE 'XLS' END AS format,
    trim(sts.caption) as caption,
    trim(krv.report_id) || '*' || trim(sts.filename) || '*' || trim(sts.contenttype) as id
FROM
    kenn_rpt_version krv
    JOIN kenn_stylesheet_version ksv ON krv.tid = ksv.rpt_version_id
    JOIN sx_stylesheets sts ON ksv.stylesheet_id = sts.tid
    JOIN masken_felder_bez mfb ON mfb.felderinfo_id = ${FieldID}
    JOIN sx_mask_style sms ON sms.stylesheet_id = sts.tid and sms.maskeninfo_id = mfb.maskeninfo_id
WHERE
  make_date(${jahr}, ${monat}, 1) BETWEEN krv.valid_from AND krv.valid_to
</#macro>

<#macro quarter_to_month quarter=10>
    <#if !quarter?? || !['1','2','3','4']?seq_contains(quarter) >
        10
    <#else>
        ((${quarter}::INT - 1) * 3 + 1)
    </#if>
</#macro>
