
--SQL Script automatisch generiert von SuperX module_upgrade.xsl
--Freemarker Template
<sqlvars>
<sqlvar name="views">

select relname,relname as tabelle from pg_class where relname::varchar(200) in ('kenn_perso_z',
'kenn_stell_z',
'kenn_gege',
'kenn_dienstart',
'kenn_taetigkeit',
'kenn_stg_astat',
'kenn_abschl_astat',
'kenn_quartale',
'kenn_zahlen',
'kenn_hs_sichten',
'kenn_hs_stort_trg',
'kenn_hs_stort_art',
'kenn_hs_st_trgart',
'kenn_hs_stort',
'kenn_stg_sb',
'kenn_redaktionsstatus',
'dim_hochschule',
'kenn_extkotr_lfb',
'kenn_extkotr_lehre_k',
'kenn_extkotr_a',
'kenn_hzbart_astat_akt',
'dim_kenn_koepfe_faelle',
'dim_kenn_monat',
'dim_kenn_stg_int',
'dim_kenn_stg_astat',
'dim_kenn_abschl_astat',
'dim_kenn_bvkr_art',
'kenn_report_katalog',
'kenn_report',
'kenn_report_fuer_stichtagsarten',
'kenn_bezugszeit',
'kenn_abschl_astat_pruef_grp',
'kenn_stbb_kapitel',
'kenn_stbb_titel',
'k_astat_studienfach_land_l',
'kenn_hochschulen_plus') UNION
SELECT N.nspname||'.'||C.relname as relname, N.nspname||'.'||C.relname as tabelle
FROM pg_class C, pg_namespace N
WHERE N.oid = C.relnamespace and N.nspname||'.'||C.relname in ('kenn_perso_z',
'kenn_stell_z',
'kenn_gege',
'kenn_dienstart',
'kenn_taetigkeit',
'kenn_stg_astat',
'kenn_abschl_astat',
'kenn_quartale',
'kenn_zahlen',
'kenn_hs_sichten',
'kenn_hs_stort_trg',
'kenn_hs_stort_art',
'kenn_hs_st_trgart',
'kenn_hs_stort',
'kenn_stg_sb',
'kenn_redaktionsstatus',
'dim_hochschule',
'kenn_extkotr_lfb',
'kenn_extkotr_lehre_k',
'kenn_extkotr_a',
'kenn_hzbart_astat_akt',
'dim_kenn_koepfe_faelle',
'dim_kenn_monat',
'dim_kenn_stg_int',
'dim_kenn_stg_astat',
'dim_kenn_abschl_astat',
'dim_kenn_bvkr_art',
'kenn_report_katalog',
'kenn_report',
'kenn_report_fuer_stichtagsarten',
'kenn_bezugszeit',
'kenn_abschl_astat_pruef_grp',
'kenn_stbb_kapitel',
'kenn_stbb_titel',
'k_astat_studienfach_land_l',
'kenn_hochschulen_plus'
);</sqlvar>
</sqlvars>


select now(), 'Checking views';


<#if views?has_content>

<#if views?seq_contains("kenn_perso_z") >


select now(), 'view kenn_perso_z exists - fine';


<#else>


select now(), 'Erzeuge View kenn_perso_z';

create view kenn_perso_z(
	name, 
key) as
	select apnr, druck from kenn_cifx where key=111;
	
</#if>

<#if views?seq_contains("kenn_stell_z") >


select now(), 'view kenn_stell_z exists - fine';


<#else>


select now(), 'Erzeuge View kenn_stell_z';

create view kenn_stell_z(
	name, 
key) as
	select apnr, druck from kenn_cifx where key=112;
	
</#if>

<#if views?seq_contains("kenn_gege") >


select now(), 'view kenn_gege exists - fine';


<#else>


select now(), 'Erzeuge View kenn_gege';

create view kenn_gege(
	id, 
apnr, 
kurz, 
druck, 
lang_1, 
struktur_c, 
gruppe) as
	select tid, apnr, kurz, druck, lang_1, struktur_c, gruppe from kenn_cifx where key=648;
	
</#if>

<#if views?seq_contains("kenn_dienstart") >


select now(), 'view kenn_dienstart exists - fine';


<#else>


select now(), 'Erzeuge View kenn_dienstart';

create view kenn_dienstart(
	tid, 
bund_dienstart, 
kurztext, 
drucktext, 
langtext) as
	select tid, apnr as bund_dienstart, kurz, druck, lang_1 from kenn_cifx where key=660;
	
</#if>

<#if views?seq_contains("kenn_taetigkeit") >


select now(), 'view kenn_taetigkeit exists - fine';


<#else>


select now(), 'Erzeuge View kenn_taetigkeit';

create view kenn_taetigkeit(
	tid, 
bund_taetigkeit, 
kurztext, 
drucktext, 
langtext) as
	select tid, apnr as bund_taetigkeit, kurz, druck, lang_1 from kenn_cifx where key=661;
	
</#if>

<#if views?seq_contains("kenn_stg_astat") >


select now(), 'view kenn_stg_astat exists - fine';


<#else>


select now(), 'Erzeuge View kenn_stg_astat';

create view kenn_stg_astat(
	tid, 
astat, 
parent, 
ktxt, 
dtxt, 
ltxt, 
sicht, 
ebene, 
sort1, 
sortc1, 
gueltig_von, 
gueltig_bis, 
struktur_c) as
	
          select tid, apnr as astat, parent,
                   kurz as ktxt,
                   druck as dtxt,
                   lang_1 as ltxt,
                   'kenn_stg_astat_stb_fg'::char(200) as sicht,
                   ebene,
                   sort1,
                   sortc1,
                   d_akt_von as gueltig_von  ,
                   d_akt_bis as gueltig_bis  ,
                   struktur_c
                   from kenn_cifx where key=663 
        ;
	
</#if>

<#if views?seq_contains("kenn_abschl_astat") >


select now(), 'view kenn_abschl_astat exists - fine';


<#else>


select now(), 'Erzeuge View kenn_abschl_astat';

create view kenn_abschl_astat(
	tid, 
astat, 
parent, 
ktxt, 
dtxt, 
ltxt, 
sicht, 
ebene, 
sort1, 
sortc1, 
gueltig_von, 
gueltig_bis, 
struktur_c) as
	
          select tid, apnr as astat, parent,
                   kurz as ktxt,
                   druck as dtxt,
                   lang_1 as ltxt,
                   'kenn_abschl_astat'::char(200) as sicht,
                   ebene,
                   sort1,
                   sortc1,
                   d_akt_von as gueltig_von  ,
                   d_akt_bis as gueltig_bis  ,
                   struktur_c
                   from kenn_cifx where key=662 
        ;
	
</#if>

<#if views?seq_contains("kenn_quartale") >


select now(), 'view kenn_quartale exists - fine';


<#else>


select now(), 'Erzeuge View kenn_quartale';

create view kenn_quartale(
	apnr, 
kurz, 
druck, 
lang_1, 
sort1) as
	select to_number(apnr,'99999'), kurz, druck, lang_1,sort1 from kenn_cifx where key=664;
	
</#if>

<#if views?seq_contains("kenn_zahlen") >


select now(), 'view kenn_zahlen exists - fine';


<#else>


select now(), 'Erzeuge View kenn_zahlen';

create view kenn_zahlen(
	apnr, 
kurz, 
druck, 
lang_1, 
gruppierung, 
sort1, 
ebene, 
struktur_c, 
gruppe) as
	select apnr, kurz, druck, lang_1,lang_2 as gruppierung,sort1 ,ebene,struktur_c,gruppe from kenn_cifx where key=665;
	
</#if>

<#if views?seq_contains("kenn_hs_sichten") >


select now(), 'view kenn_hs_sichten exists - fine';


<#else>


select now(), 'Erzeuge View kenn_hs_sichten';

create view kenn_hs_sichten(
	hs_nr, 
tid, 
dimension, 
dimension_lang, 
stichtag, 
alt_hier_id, 
sichtart, 
bezugszeit, 
bezugsart, 
exportieren) as
	
          
                   select distinct H.hs_nr, S.tid,
                   K.dimension,
                   K.dimension_lang,
                   K.stichtag,
                   S.alt_hier_id,
                   K.sichtart,
                   I.bezugszeit,
                   I.bezugsart,
                   I.exportieren
                   FROM kenn_sichten K, sichten S, hochschulinfo H, kenn_stichtag I
                   where 
                   K.sicht_name_intern=S.name_intern
                   and I.stichtagsart='Kostenrechnung'
                   and (I.tid=K.stichtag_id or K.stichtag_id=0)
          
        ;
	
</#if>

<#if views?seq_contains("kenn_hs_stort_trg") >


select now(), 'view kenn_hs_stort_trg exists - fine';


<#else>


select now(), 'Erzeuge View kenn_hs_stort_trg';

create view kenn_hs_stort_trg(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select name,hs_nr::char(10) as apnr,traegerschaft as parent,3::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen
                   where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union
                   select lang_1, apnr,'_root',2,'Trgerschaft' from kenn_cifx where key=672
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.kurztext) || ' - ' || S.kurz,'ST' || apnr,H.hs_nr::char(10),4,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	
</#if>

<#if views?seq_contains("kenn_hs_stort_art") >


select now(), 'view kenn_hs_stort_art exists - fine';


<#else>


select now(), 'Erzeuge View kenn_hs_stort_art';

create view kenn_hs_stort_art(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select name,hs_nr::char(10) as apnr,art as parent,3::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen
                   where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union
                   select druck, apnr,'_root',2,'Art' from kenn_cifx where key=673
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.kurztext) || ' - ' || S.kurz,'ST' || apnr,H.hs_nr::char(10),4,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	
</#if>

<#if views?seq_contains("kenn_hs_st_trgart") >


select now(), 'view kenn_hs_st_trgart exists - fine';


<#else>


select now(), 'Erzeuge View kenn_hs_st_trgart';

create view kenn_hs_st_trgart(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select kurztext,hs_nr::char(10) as apnr,trim(traegerschaft) || '_' || art as parent,4::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union
                   select lang_1, apnr,'_root',2,'Art' from kenn_cifx where key=673
                   union
                   select lang_1, trim(apnr) || '_U','U',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_FH','FH',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_PH','PH',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_VFH','VFH',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_KMW','KMW',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_DH','DH',3,'Trgerschaft' from kenn_cifx where key=672
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.kurztext) || ' - ' || S.kurz,'ST' || apnr,H.hs_nr::char(10),4,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	
</#if>

<#if views?seq_contains("kenn_hs_stort") >


select now(), 'view kenn_hs_stort exists - fine';


<#else>


select now(), 'Erzeuge View kenn_hs_stort';

create view kenn_hs_stort(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select name,hs_nr::char(10) as apnr,'_root'::char(10) as parent,2::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen
                   where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.name) || ' Standort  ' || trim(S.druck),'ST' || apnr,H.hs_nr::char(10),3,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	
</#if>

<#if views?seq_contains("kenn_stg_sb") >


select now(), 'view kenn_stg_sb exists - fine';


<#else>


select now(), 'Erzeuge View kenn_stg_sb';

create view kenn_stg_sb(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select druck as name,apnr,parent,1::smallint as ebene,struktur_c as struktur_str from kenn_cifx where key=663 and struktur_c ='Fach (amtlich)'
                   union select druck,apnr,'_Alle',1,struktur_c from kenn_cifx where key=663 and struktur_c ='Studienbereich'
                   union select 'Alle Studienbereiche','_Alle',null::char(10),1,'Summe Studienbereiche' from xdummy
          
        ;
	
</#if>

<#if views?seq_contains("kenn_redaktionsstatus") >


select now(), 'view kenn_redaktionsstatus exists - fine';


<#else>


select now(), 'Erzeuge View kenn_redaktionsstatus';

create view kenn_redaktionsstatus(
	apnr, 
name) as
	
          
                   select 3::integer as apnr, 'In Bearbeitung' from xdummy
                   union
                   select 4::integer as apnr, 'Freigegeben' from xdummy
          
        ;
	
</#if>

<#if views?seq_contains("dim_hochschule") >


select now(), 'view dim_hochschule exists - fine';


<#else>


select now(), 'Erzeuge View dim_hochschule';

create view dim_hochschule(
	hs_nr, 
name, 
kurztext, 
art) as
	
          
                   SELECT 
                   hs_nr,
                   name,
                   kurztext,
                   case when art='FH'  then 'Fachhochschule'
                   when art='U' then 'Universitt'
                   when art='DH' then 'Duale Hochschule'
                   when art='KMW' then 'Kunst/Musikhochschule'
                   when art='PH' then 'Pdagogische Hochschule'
                   else art
                   end
                   FROM kenn_hochschulen
                   where (bland='BW'
                   and (select K.apnr from konstanten K where K.beschreibung='KENN_PROFIL') in (1,2,3,4))
                   or (bland='SA'
                   and (select K.apnr from konstanten K where K.beschreibung='KENN_PROFIL') in (5,6))
                   or bland is null
                   or bland not in ('BW','SA')
                   
                   
          
        ;
	
</#if>

<#if views?seq_contains("kenn_extkotr_lfb") >


select now(), 'view kenn_extkotr_lfb exists - fine';


<#else>


select now(), 'Erzeuge View kenn_extkotr_lfb';

create view kenn_extkotr_lfb(
	key, 
parent, 
name, 
struktur_str, 
gueltig_von, 
gueltig_bis) as
	
          
                   SELECT 
                   distinct  substring(key from 4 for 3) as key,
                   substring(key from 2 for 2) as parent,
                   case when name like 'Le LFB%' then substring (name from 8 for 150) when name like 'Le %' then substring (name from 4 for 150) else name end as name,
                   'lfb'::char(10) as struktur_str,
                   extract (year from gueltig_von) as gueltig_von,
                   extract (year from gueltig_bis) as gueltig_bis
                   FROM kenn_extkotr
                   where kategorie='lf'
                   and key like '1%'
                   union
                   select distinct substring(key from 2 for 2) as key,
                   '_lfb' as parent,
                   substring(name from 4 for 200) as name,
                   kategorie as struktur_str,
                   extract (year from gueltig_von) as gueltig_von,
                   extract (year from gueltig_bis) as gueltig_bis
                   from kenn_extkotr where
                   kategorie='fg'
                   and key like '1%'
                   union select '_lfb'::char(10),null::char(10), 'Lehr- und Forschungsbereiche',
                   'Alle' as struktur_str,1900,3000 from xdummy
                   
                   
          
        ;
	
</#if>

<#if views?seq_contains("kenn_extkotr_lehre_k") >


select now(), 'view kenn_extkotr_lehre_k exists - fine';


<#else>


select now(), 'Erzeuge View kenn_extkotr_lehre_k';

create view kenn_extkotr_lehre_k(
	key, 
parent, 
kurztext, 
name, 
gueltig_von, 
gueltig_bis) as
	
          
                   
                   select 
                   key,
                   null::char(30) as parent,
                   substring(name from 1 for 10) as kurztext,
                   name,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where key ='01'
                   union
                   --Fchergruppe:
                   select 
                   'F' || substring(key from 3 for 2),
                   '01',
                   substring(name from 1 for 10),
                   name,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where 
                   key like '01%'
                   and length(trim(key))=4
                   union
                   --FGR ohne koop.
                   select 
                   key,
                   'F' || substring(key from 3 for 2),
                   substring(name from 1 for 10),
                   trim(name) || ' (ohne Koop.-Stg.)',
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where 
                   key like '01%'
                   and length(trim(key))=4
                   union
                   --FGR mit koop-Stg:
                   select key,
                   'F' || substring(key from 3 for 2),
                   substring(name from 1 for 10),
                   trim(name) || ' (Koop.-Stg.)',
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where 
                   key like '11%'
                   and length(trim(key))=4
                   union
                   select 
                   key,
                   parent,
                   substring(name from 1 for 10),
                   trim(name) ,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr 
                   where (key like '01%' or key like '11%')
                   and length(trim(key))>4
                   
                   
          
        ;
	
</#if>

<#if views?seq_contains("kenn_extkotr_a") >


select now(), 'view kenn_extkotr_a exists - fine';


<#else>


select now(), 'Erzeuge View kenn_extkotr_a';

create view kenn_extkotr_a(
	key, 
parent, 
kurztext, 
name, 
kategorie, 
gueltig_von, 
gueltig_bis) as
	
          
                   
                   select 
                   --alte Knoten:
                   key,
                   parent,
                   substring(name from 1 for 10) as kurztext,
                   trim(name) || ' (bis ' || extract (year from gueltig_bis) || ')',
                   kategorie,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where extract (year from gueltig_bis) <3000
                   union
                   --aktuelle Knoten:
                   select
                   key,
                   parent,
                   substring(name from 1 for 10) as kurztext,
                   trim(name),
                   kategorie,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where extract (year from gueltig_bis) =3000
                   or gueltig_bis is null
                   
                   
          
        ;
	
</#if>

<#if views?seq_contains("kenn_hzbart_astat_akt") >


select now(), 'view kenn_hzbart_astat_akt exists - fine';


<#else>


select now(), 'Erzeuge View kenn_hzbart_astat_akt';

create view kenn_hzbart_astat_akt(
	tid, 
bland, 
apnr, 
druck, 
gruppe) as
	select tid,bland,apnr,druck,gruppe from kenn_hzbart_astat where current_date between gueltig_von and gueltig_bis;
	
</#if>

<#if views?seq_contains("dim_kenn_koepfe_faelle") >


select now(), 'view dim_kenn_koepfe_faelle exists - fine';


<#else>


select now(), 'Erzeuge View dim_kenn_koepfe_faelle';

create view dim_kenn_koepfe_faelle(
	apnr, 
druck, 
struktur_int) as
	
          
                   
                   select 'K'::char(1) as apnr, 
                   'Kpfe'::varchar(255) as druck,
                   1::integer as struktur_int
                   from xdummy
                   union
                   select 'S'::char(1) as apnr, 
                   'Kpfe Stat. Landesamt (1.F.,n-ter Stg)'::varchar(255) as druck,
                   3::integer as struktur_int
                   from xdummy
                   union
                   select 'F'::char(1) as apnr, 
                   'Flle'::varchar(255) as druck,
                   2::integer as struktur_int
                   from xdummy
                   
                   
          
        ;
	
</#if>

<#if views?seq_contains("dim_kenn_monat") >


select now(), 'view dim_kenn_monat exists - fine';


<#else>


select now(), 'Erzeuge View dim_kenn_monat';

create view dim_kenn_monat(
	monat, 
quartal, 
halbjahr, 
name) as
	
          
                   
                   SELECT to_number(substring(wert from 7 for 2),'99')::integer as monat,
                   (case when to_number(substring(wert from 7 for 2),'99') between 1 and 3 then 1
                   when to_number(substring(wert from 7 for 2),'99') between 4 and 6 then 2
                   when to_number(substring(wert from 7 for 2),'99') between 7 and 9 then 3
                   when to_number(substring(wert from 7 for 2),'99') between 10 and 13 then 4
                   end )::integer as quartal,
                   (case when to_number(substring(wert from 7 for 2),'99') between 1 and 6 then 1
                   when to_number(substring(wert from 7 for 2),'99') between 6 and 13 then 2
                   end )::integer as halbjahr,
                   name from aggregierung
                   where kategorie='ZeitraumMonat'
                   and wert like '%=%'
                   
                   
          
        ;
	
</#if>

<#if views?seq_contains("dim_kenn_stg_int") >


select now(), 'view dim_kenn_stg_int exists - fine';


<#else>


select now(), 'Erzeuge View dim_kenn_stg_int';

create view dim_kenn_stg_int(
	apnr, 
druck, 
hs_nr_str, 
hs_nr, 
stg_astat_str) as
	
          
                   
                   select '' || S.hs_nr  || '_' || trim(S.apnr) as apnr,
                   (trim(H.name) || ': ' || trim(S.druck))::varchar(255) as druck,
                   H.name as hs_nr_str,
                   H.hs_nr,
                   C.druck as stg_astat_str
                   
                   from kenn_hochschulen H, kenn_stg_int S 
                   left outer join kenn_cifx C on (
                   S.astat=C.apnr
                   and C.key=663
                   and C.struktur_c='Fach (amtlich)')
                   where 
                   H.hs_nr=S.hs_nr
                   
                   
          
        ;
	
</#if>

<#if views?seq_contains("dim_kenn_stg_astat") >


select now(), 'view dim_kenn_stg_astat exists - fine';


<#else>


select now(), 'Erzeuge View dim_kenn_stg_astat';

create view dim_kenn_stg_astat(
	apnr, 
druck, 
sb, 
sb_str, 
fgr) as
	
          
                   
                   select C.apnr, 
                   C.druck,
                   C.parent as sb,
                   C.lang_2 as sb_str,
                   C.lang_3 as fgr
                   from kenn_cifx C 
                   where C.key=663
                   and C.struktur_c='Fach (amtlich)'
                   
                   
                   
          
        ;
	
</#if>

<#if views?seq_contains("dim_kenn_abschl_astat") >


select now(), 'view dim_kenn_abschl_astat exists - fine';


<#else>


select now(), 'Erzeuge View dim_kenn_abschl_astat';

create view dim_kenn_abschl_astat(
	apnr, 
druck, 
abschlussart, 
abschlussgruppe) as
	
          
                   
                   select C.apnr, 
                   C.druck,
                   C.lang_2 as abschlussart,
                   C.lang_3 as abschlussgruppe
                   from kenn_cifx C 
                   where C.key=662
                   and C.struktur_c='Abschluss (amtlich)'
                   
                   
                   
          
        ;
	
</#if>

<#if views?seq_contains("dim_kenn_bvkr_art") >


select now(), 'view dim_kenn_bvkr_art exists - fine';


<#else>


select now(), 'Erzeuge View dim_kenn_bvkr_art';

create view dim_kenn_bvkr_art(
	apnr, 
druck, 
parent, 
struktur_c, 
ebene, 
kostentyp, 
kostentyp_str) as
	
          
                   select 
                   apnr,
                   druck,
                   parent ,
                   struktur_c,
                   ebene,
                   gruppe as kostentyp,
                   case when gruppe='60' then 'Erlse' 
                   when gruppe='62' then 'Sachaufwendungen' 
                   when gruppe='64' then 'Kosten Abschreibungen'
                   when gruppe='63' then 'Weitere Aufwendungen'
                   when gruppe='65' then 'Kosten kalkulatorische Mieten'
                   when gruppe='61' then 'Personalstandardkosten' 
                   else 'Sonstige'
                   end  as kostentyp_str      
                   from 
                   kenn_cifx where key=668
                   and ebene>1 
          
        ;
	
</#if>

<#if views?seq_contains("kenn_report_katalog") >


select now(), 'view kenn_report_katalog exists - fine';


<#else>


select now(), 'Erzeuge View kenn_report_katalog';

create view kenn_report_katalog(
	apnr, 
druck, 
parent, 
struktur_str, 
sortnr, 
ebene, 
quelltabelle, 
report_id, 
uniquename) as
	
          
                   select '_' || apnr::char(100) as apnr,
                   druck,
                   null::char(100) as parent,
                   'Bericht'::varchar(255) as struktur_str,
                   1000::smallint as sortnr ,
                   1::smallint as ebene,
                   null::char(255) as quelltabellen,
                   apnr::char(40) as report_id,
                   null::varchar(255) as uniquename
                   from kenn_cifx where key=666 
                   --ebene Gruppe:
                   union select '_G_' || G.id as apnr,
                   G.name,
                   '_' || G.report_id as parent,
                   'Gruppe'::varchar(255) as struktur_str,
                   (1000+G.ord_nr)::smallint as sortnr ,
                   2::smallint as ebene,
                   null::char(255) as quelltabellen,
                   G.report_id ,
                   G.uniquename
                   from kenn_katalog_grp G
                   union select R.katalog_id,
                   K.name,coalesce(R.parent_katalog_id,'_G_' || R.gruppe_1) as parent,
                   'Kennzahl'::varchar(255) as struktur_str,
                   10000+R.ord_nr as sortnr,
                   2+R.ebene as ebene,
                   K.quelltabelle,
                   R.report_id,
                   R.uniquename
                   from kenn_katalog_rpt R, kenn_katalog K, kenn_cifx C
                   where R.katalog_id=K.id
                   and R.report_id=C.apnr
                   and R.active > 0
                   and C.key=666
          
        ;
	
</#if>

<#if views?seq_contains("kenn_report") >


select now(), 'view kenn_report exists - fine';


<#else>


select now(), 'Erzeuge View kenn_report';

create view kenn_report(
	apnr, 
druck, 
sortnr, 
land_apnr, 
is_download, 
bezugsart, 
gruppe) as
	
          
                   SELECT apnr,
		   druck,
		   sort1 as sortnr,
		   land_apnr,
		   (case when intern_c='D' then 'J' else 'N' end) as is_download,
		   struktur_c as bezugsart ,
		   gruppe
		   from kenn_cifx 
		   where key in (666,679)
          
        ;
	
</#if>

<#if views?seq_contains("kenn_report_fuer_stichtagsarten") >


select now(), 'view kenn_report_fuer_stichtagsarten exists - fine';


<#else>


select now(), 'Erzeuge View kenn_report_fuer_stichtagsarten';

create view kenn_report_fuer_stichtagsarten(
	apnr, 
druck, 
sortnr, 
land_apnr, 
is_download, 
bezugsart) as
	
          
                   SELECT apnr,
		   druck,
		   sort1 as sortnr,
		   land_apnr,
		   (case when intern_c='D' then 'J' else 'N' end) as is_download,
		   struktur_c as bezugsart 
		   from kenn_cifx 
		   where key in (688)
          
        ;
	
</#if>

<#if views?seq_contains("kenn_bezugszeit") >


select now(), 'view kenn_bezugszeit exists - fine';


<#else>


select now(), 'Erzeuge View kenn_bezugszeit';

create view kenn_bezugszeit(
	bezugsart, 
bezugszeit, 
druck) as
	
          
                   
	    select 'S'::char(1) as bezugsart,
	    K.tid as bezugszeit,
	    K.druck 
	    from kenn_semester K
	    union select 'J',
	    ord as bezugszeit,
	    name::varchar(255) as druck
	    from aggregierung 
	    where kategorie='KENN-Jahr'
	    union
	    SELECT 'Q',
	    CAST(apnr AS INTEGER),
	    druck
	    FROM kenn_cifx where key=664
           
        ;
	
</#if>

<#if views?seq_contains("kenn_abschl_astat_pruef_grp") >


select now(), 'view kenn_abschl_astat_pruef_grp exists - fine';


<#else>


select now(), 'Erzeuge View kenn_abschl_astat_pruef_grp';

create view kenn_abschl_astat_pruef_grp(
	astat, 
pruef_grp, 
kurz, 
druck, 
lang_1, 
sort1) as
	
          
                   SELECT G.astat,G.pruef_grp, C.kurz, C.druck,C.lang_1, C.sort1
                   from kenn_cifx C left outer join kenn_abschl_pruef_grp G
                   on (G.pruef_grp = C.apnr)
                   where C.key=687
                   
          
        ;
	
</#if>

<#if views?seq_contains("kenn_stbb_kapitel") >


select now(), 'view kenn_stbb_kapitel exists - fine';


<#else>


select now(), 'Erzeuge View kenn_stbb_kapitel';

create view kenn_stbb_kapitel(
	kapitel) as
	
          
                   SELECT distinct kapitel 
		   from kenn_stbb_kap_titel_bericht
                   
          
        ;
	
</#if>

<#if views?seq_contains("kenn_stbb_titel") >


select now(), 'view kenn_stbb_titel exists - fine';


<#else>


select now(), 'Erzeuge View kenn_stbb_titel';

create view kenn_stbb_titel(
	titel) as
	
          
                   SELECT distinct titel 
		   from kenn_stbb_kap_titel_bericht
                   
          
        ;
	
</#if>

<#if views?seq_contains("k_astat_studienfach_land_l") >


select now(), 'view k_astat_studienfach_land_l exists - fine';


<#else>


select now(), 'Erzeuge View k_astat_studienfach_land_l';

create view k_astat_studienfach_land_l(
	schluessel, 
gueltig_ab, 
land, 
version, 
sortkey, 
gueltig_bis, 
name, 
isced, 
keybund) as
	
          
					select 
						L.schluessel,
						L.gueltig_ab,
						L.land,
						L.version,
						L.sortkey,
						L.gueltig_bis,
						L.name,
						L.isced,
						L.keybund
					from 
						k_astat_studienfach_land L,
						cif C
					where 
						C.apnr=L.land
						and C.key=659  
          
        ;
	
</#if>

<#if views?seq_contains("kenn_hochschulen_plus") >


select now(), 'view kenn_hochschulen_plus exists - fine';


<#else>


select now(), 'Erzeuge View kenn_hochschulen_plus';

create view kenn_hochschulen_plus(
	hs_nr, 
kuerzel) as
	
          
					select hs_nr::char(40), kuerzel from kenn_hochschulen union 
					select 'hochschulroot', 'Gesamt' from xdummy union
					select '10001', 'Uni' from xdummy union
					select '20001', 'FH' from xdummy union
					select '30001', 'KunstMusik' from xdummy union
					select '40001', 'Sonst' from xdummy
					; 
          
        ;
	
</#if>

<#else>


select now(), 'Erzeuge View kenn_perso_z';

create view kenn_perso_z(
	name, 
key) as
	select apnr, druck from kenn_cifx where key=111;
	

select now(), 'Erzeuge View kenn_stell_z';

create view kenn_stell_z(
	name, 
key) as
	select apnr, druck from kenn_cifx where key=112;
	

select now(), 'Erzeuge View kenn_gege';

create view kenn_gege(
	id, 
apnr, 
kurz, 
druck, 
lang_1, 
struktur_c, 
gruppe) as
	select tid, apnr, kurz, druck, lang_1, struktur_c, gruppe from kenn_cifx where key=648;
	

select now(), 'Erzeuge View kenn_dienstart';

create view kenn_dienstart(
	tid, 
bund_dienstart, 
kurztext, 
drucktext, 
langtext) as
	select tid, apnr as bund_dienstart, kurz, druck, lang_1 from kenn_cifx where key=660;
	

select now(), 'Erzeuge View kenn_taetigkeit';

create view kenn_taetigkeit(
	tid, 
bund_taetigkeit, 
kurztext, 
drucktext, 
langtext) as
	select tid, apnr as bund_taetigkeit, kurz, druck, lang_1 from kenn_cifx where key=661;
	

select now(), 'Erzeuge View kenn_stg_astat';

create view kenn_stg_astat(
	tid, 
astat, 
parent, 
ktxt, 
dtxt, 
ltxt, 
sicht, 
ebene, 
sort1, 
sortc1, 
gueltig_von, 
gueltig_bis, 
struktur_c) as
	
          select tid, apnr as astat, parent,
                   kurz as ktxt,
                   druck as dtxt,
                   lang_1 as ltxt,
                   'kenn_stg_astat_stb_fg'::char(200) as sicht,
                   ebene,
                   sort1,
                   sortc1,
                   d_akt_von as gueltig_von  ,
                   d_akt_bis as gueltig_bis  ,
                   struktur_c
                   from kenn_cifx where key=663 
        ;
	

select now(), 'Erzeuge View kenn_abschl_astat';

create view kenn_abschl_astat(
	tid, 
astat, 
parent, 
ktxt, 
dtxt, 
ltxt, 
sicht, 
ebene, 
sort1, 
sortc1, 
gueltig_von, 
gueltig_bis, 
struktur_c) as
	
          select tid, apnr as astat, parent,
                   kurz as ktxt,
                   druck as dtxt,
                   lang_1 as ltxt,
                   'kenn_abschl_astat'::char(200) as sicht,
                   ebene,
                   sort1,
                   sortc1,
                   d_akt_von as gueltig_von  ,
                   d_akt_bis as gueltig_bis  ,
                   struktur_c
                   from kenn_cifx where key=662 
        ;
	

select now(), 'Erzeuge View kenn_quartale';

create view kenn_quartale(
	apnr, 
kurz, 
druck, 
lang_1, 
sort1) as
	select to_number(apnr,'99999'), kurz, druck, lang_1,sort1 from kenn_cifx where key=664;
	

select now(), 'Erzeuge View kenn_zahlen';

create view kenn_zahlen(
	apnr, 
kurz, 
druck, 
lang_1, 
gruppierung, 
sort1, 
ebene, 
struktur_c, 
gruppe) as
	select apnr, kurz, druck, lang_1,lang_2 as gruppierung,sort1 ,ebene,struktur_c,gruppe from kenn_cifx where key=665;
	

select now(), 'Erzeuge View kenn_hs_sichten';

create view kenn_hs_sichten(
	hs_nr, 
tid, 
dimension, 
dimension_lang, 
stichtag, 
alt_hier_id, 
sichtart, 
bezugszeit, 
bezugsart, 
exportieren) as
	
          
                   select distinct H.hs_nr, S.tid,
                   K.dimension,
                   K.dimension_lang,
                   K.stichtag,
                   S.alt_hier_id,
                   K.sichtart,
                   I.bezugszeit,
                   I.bezugsart,
                   I.exportieren
                   FROM kenn_sichten K, sichten S, hochschulinfo H, kenn_stichtag I
                   where 
                   K.sicht_name_intern=S.name_intern
                   and I.stichtagsart='Kostenrechnung'
                   and (I.tid=K.stichtag_id or K.stichtag_id=0)
          
        ;
	

select now(), 'Erzeuge View kenn_hs_stort_trg';

create view kenn_hs_stort_trg(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select name,hs_nr::char(10) as apnr,traegerschaft as parent,3::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen
                   where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union
                   select lang_1, apnr,'_root',2,'Trgerschaft' from kenn_cifx where key=672
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.kurztext) || ' - ' || S.kurz,'ST' || apnr,H.hs_nr::char(10),4,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	

select now(), 'Erzeuge View kenn_hs_stort_art';

create view kenn_hs_stort_art(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select name,hs_nr::char(10) as apnr,art as parent,3::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen
                   where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union
                   select druck, apnr,'_root',2,'Art' from kenn_cifx where key=673
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.kurztext) || ' - ' || S.kurz,'ST' || apnr,H.hs_nr::char(10),4,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	

select now(), 'Erzeuge View kenn_hs_st_trgart';

create view kenn_hs_st_trgart(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select kurztext,hs_nr::char(10) as apnr,trim(traegerschaft) || '_' || art as parent,4::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union
                   select lang_1, apnr,'_root',2,'Art' from kenn_cifx where key=673
                   union
                   select lang_1, trim(apnr) || '_U','U',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_FH','FH',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_PH','PH',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_VFH','VFH',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_KMW','KMW',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_DH','DH',3,'Trgerschaft' from kenn_cifx where key=672
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.kurztext) || ' - ' || S.kurz,'ST' || apnr,H.hs_nr::char(10),4,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	

select now(), 'Erzeuge View kenn_hs_stort';

create view kenn_hs_stort(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select name,hs_nr::char(10) as apnr,'_root'::char(10) as parent,2::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen
                   where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.name) || ' Standort  ' || trim(S.druck),'ST' || apnr,H.hs_nr::char(10),3,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	

select now(), 'Erzeuge View kenn_stg_sb';

create view kenn_stg_sb(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select druck as name,apnr,parent,1::smallint as ebene,struktur_c as struktur_str from kenn_cifx where key=663 and struktur_c ='Fach (amtlich)'
                   union select druck,apnr,'_Alle',1,struktur_c from kenn_cifx where key=663 and struktur_c ='Studienbereich'
                   union select 'Alle Studienbereiche','_Alle',null::char(10),1,'Summe Studienbereiche' from xdummy
          
        ;
	

select now(), 'Erzeuge View kenn_redaktionsstatus';

create view kenn_redaktionsstatus(
	apnr, 
name) as
	
          
                   select 3::integer as apnr, 'In Bearbeitung' from xdummy
                   union
                   select 4::integer as apnr, 'Freigegeben' from xdummy
          
        ;
	

select now(), 'Erzeuge View dim_hochschule';

create view dim_hochschule(
	hs_nr, 
name, 
kurztext, 
art) as
	
          
                   SELECT 
                   hs_nr,
                   name,
                   kurztext,
                   case when art='FH'  then 'Fachhochschule'
                   when art='U' then 'Universitt'
                   when art='DH' then 'Duale Hochschule'
                   when art='KMW' then 'Kunst/Musikhochschule'
                   when art='PH' then 'Pdagogische Hochschule'
                   else art
                   end
                   FROM kenn_hochschulen
                   where (bland='BW'
                   and (select K.apnr from konstanten K where K.beschreibung='KENN_PROFIL') in (1,2,3,4))
                   or (bland='SA'
                   and (select K.apnr from konstanten K where K.beschreibung='KENN_PROFIL') in (5,6))
                   or bland is null
                   or bland not in ('BW','SA')
                   
                   
          
        ;
	

select now(), 'Erzeuge View kenn_extkotr_lfb';

create view kenn_extkotr_lfb(
	key, 
parent, 
name, 
struktur_str, 
gueltig_von, 
gueltig_bis) as
	
          
                   SELECT 
                   distinct  substring(key from 4 for 3) as key,
                   substring(key from 2 for 2) as parent,
                   case when name like 'Le LFB%' then substring (name from 8 for 150) when name like 'Le %' then substring (name from 4 for 150) else name end as name,
                   'lfb'::char(10) as struktur_str,
                   extract (year from gueltig_von) as gueltig_von,
                   extract (year from gueltig_bis) as gueltig_bis
                   FROM kenn_extkotr
                   where kategorie='lf'
                   and key like '1%'
                   union
                   select distinct substring(key from 2 for 2) as key,
                   '_lfb' as parent,
                   substring(name from 4 for 200) as name,
                   kategorie as struktur_str,
                   extract (year from gueltig_von) as gueltig_von,
                   extract (year from gueltig_bis) as gueltig_bis
                   from kenn_extkotr where
                   kategorie='fg'
                   and key like '1%'
                   union select '_lfb'::char(10),null::char(10), 'Lehr- und Forschungsbereiche',
                   'Alle' as struktur_str,1900,3000 from xdummy
                   
                   
          
        ;
	

select now(), 'Erzeuge View kenn_extkotr_lehre_k';

create view kenn_extkotr_lehre_k(
	key, 
parent, 
kurztext, 
name, 
gueltig_von, 
gueltig_bis) as
	
          
                   
                   select 
                   key,
                   null::char(30) as parent,
                   substring(name from 1 for 10) as kurztext,
                   name,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where key ='01'
                   union
                   --Fchergruppe:
                   select 
                   'F' || substring(key from 3 for 2),
                   '01',
                   substring(name from 1 for 10),
                   name,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where 
                   key like '01%'
                   and length(trim(key))=4
                   union
                   --FGR ohne koop.
                   select 
                   key,
                   'F' || substring(key from 3 for 2),
                   substring(name from 1 for 10),
                   trim(name) || ' (ohne Koop.-Stg.)',
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where 
                   key like '01%'
                   and length(trim(key))=4
                   union
                   --FGR mit koop-Stg:
                   select key,
                   'F' || substring(key from 3 for 2),
                   substring(name from 1 for 10),
                   trim(name) || ' (Koop.-Stg.)',
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where 
                   key like '11%'
                   and length(trim(key))=4
                   union
                   select 
                   key,
                   parent,
                   substring(name from 1 for 10),
                   trim(name) ,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr 
                   where (key like '01%' or key like '11%')
                   and length(trim(key))>4
                   
                   
          
        ;
	

select now(), 'Erzeuge View kenn_extkotr_a';

create view kenn_extkotr_a(
	key, 
parent, 
kurztext, 
name, 
kategorie, 
gueltig_von, 
gueltig_bis) as
	
          
                   
                   select 
                   --alte Knoten:
                   key,
                   parent,
                   substring(name from 1 for 10) as kurztext,
                   trim(name) || ' (bis ' || extract (year from gueltig_bis) || ')',
                   kategorie,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where extract (year from gueltig_bis) <3000
                   union
                   --aktuelle Knoten:
                   select
                   key,
                   parent,
                   substring(name from 1 for 10) as kurztext,
                   trim(name),
                   kategorie,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where extract (year from gueltig_bis) =3000
                   or gueltig_bis is null
                   
                   
          
        ;
	

select now(), 'Erzeuge View kenn_hzbart_astat_akt';

create view kenn_hzbart_astat_akt(
	tid, 
bland, 
apnr, 
druck, 
gruppe) as
	select tid,bland,apnr,druck,gruppe from kenn_hzbart_astat where current_date between gueltig_von and gueltig_bis;
	

select now(), 'Erzeuge View dim_kenn_koepfe_faelle';

create view dim_kenn_koepfe_faelle(
	apnr, 
druck, 
struktur_int) as
	
          
                   
                   select 'K'::char(1) as apnr, 
                   'Kpfe'::varchar(255) as druck,
                   1::integer as struktur_int
                   from xdummy
                   union
                   select 'S'::char(1) as apnr, 
                   'Kpfe Stat. Landesamt (1.F.,n-ter Stg)'::varchar(255) as druck,
                   3::integer as struktur_int
                   from xdummy
                   union
                   select 'F'::char(1) as apnr, 
                   'Flle'::varchar(255) as druck,
                   2::integer as struktur_int
                   from xdummy
                   
                   
          
        ;
	

select now(), 'Erzeuge View dim_kenn_monat';

create view dim_kenn_monat(
	monat, 
quartal, 
halbjahr, 
name) as
	
          
                   
                   SELECT to_number(substring(wert from 7 for 2),'99')::integer as monat,
                   (case when to_number(substring(wert from 7 for 2),'99') between 1 and 3 then 1
                   when to_number(substring(wert from 7 for 2),'99') between 4 and 6 then 2
                   when to_number(substring(wert from 7 for 2),'99') between 7 and 9 then 3
                   when to_number(substring(wert from 7 for 2),'99') between 10 and 13 then 4
                   end )::integer as quartal,
                   (case when to_number(substring(wert from 7 for 2),'99') between 1 and 6 then 1
                   when to_number(substring(wert from 7 for 2),'99') between 6 and 13 then 2
                   end )::integer as halbjahr,
                   name from aggregierung
                   where kategorie='ZeitraumMonat'
                   and wert like '%=%'
                   
                   
          
        ;
	

select now(), 'Erzeuge View dim_kenn_stg_int';

create view dim_kenn_stg_int(
	apnr, 
druck, 
hs_nr_str, 
hs_nr, 
stg_astat_str) as
	
          
                   
                   select '' || S.hs_nr  || '_' || trim(S.apnr) as apnr,
                   (trim(H.name) || ': ' || trim(S.druck))::varchar(255) as druck,
                   H.name as hs_nr_str,
                   H.hs_nr,
                   C.druck as stg_astat_str
                   
                   from kenn_hochschulen H, kenn_stg_int S 
                   left outer join kenn_cifx C on (
                   S.astat=C.apnr
                   and C.key=663
                   and C.struktur_c='Fach (amtlich)')
                   where 
                   H.hs_nr=S.hs_nr
                   
                   
          
        ;
	

select now(), 'Erzeuge View dim_kenn_stg_astat';

create view dim_kenn_stg_astat(
	apnr, 
druck, 
sb, 
sb_str, 
fgr) as
	
          
                   
                   select C.apnr, 
                   C.druck,
                   C.parent as sb,
                   C.lang_2 as sb_str,
                   C.lang_3 as fgr
                   from kenn_cifx C 
                   where C.key=663
                   and C.struktur_c='Fach (amtlich)'
                   
                   
                   
          
        ;
	

select now(), 'Erzeuge View dim_kenn_abschl_astat';

create view dim_kenn_abschl_astat(
	apnr, 
druck, 
abschlussart, 
abschlussgruppe) as
	
          
                   
                   select C.apnr, 
                   C.druck,
                   C.lang_2 as abschlussart,
                   C.lang_3 as abschlussgruppe
                   from kenn_cifx C 
                   where C.key=662
                   and C.struktur_c='Abschluss (amtlich)'
                   
                   
                   
          
        ;
	

select now(), 'Erzeuge View dim_kenn_bvkr_art';

create view dim_kenn_bvkr_art(
	apnr, 
druck, 
parent, 
struktur_c, 
ebene, 
kostentyp, 
kostentyp_str) as
	
          
                   select 
                   apnr,
                   druck,
                   parent ,
                   struktur_c,
                   ebene,
                   gruppe as kostentyp,
                   case when gruppe='60' then 'Erlse' 
                   when gruppe='62' then 'Sachaufwendungen' 
                   when gruppe='64' then 'Kosten Abschreibungen'
                   when gruppe='63' then 'Weitere Aufwendungen'
                   when gruppe='65' then 'Kosten kalkulatorische Mieten'
                   when gruppe='61' then 'Personalstandardkosten' 
                   else 'Sonstige'
                   end  as kostentyp_str      
                   from 
                   kenn_cifx where key=668
                   and ebene>1 
          
        ;
	

select now(), 'Erzeuge View kenn_report_katalog';

create view kenn_report_katalog(
	apnr, 
druck, 
parent, 
struktur_str, 
sortnr, 
ebene, 
quelltabelle, 
report_id, 
uniquename) as
	
          
                   select '_' || apnr::char(100) as apnr,
                   druck,
                   null::char(100) as parent,
                   'Bericht'::varchar(255) as struktur_str,
                   1000::smallint as sortnr ,
                   1::smallint as ebene,
                   null::char(255) as quelltabellen,
                   apnr::char(40) as report_id,
                   null::varchar(255) as uniquename
                   from kenn_cifx where key=666 
                   --ebene Gruppe:
                   union select '_G_' || G.id as apnr,
                   G.name,
                   '_' || G.report_id as parent,
                   'Gruppe'::varchar(255) as struktur_str,
                   (1000+G.ord_nr)::smallint as sortnr ,
                   2::smallint as ebene,
                   null::char(255) as quelltabellen,
                   G.report_id ,
                   G.uniquename
                   from kenn_katalog_grp G
                   union select R.katalog_id,
                   K.name,coalesce(R.parent_katalog_id,'_G_' || R.gruppe_1) as parent,
                   'Kennzahl'::varchar(255) as struktur_str,
                   10000+R.ord_nr as sortnr,
                   2+R.ebene as ebene,
                   K.quelltabelle,
                   R.report_id,
                   R.uniquename
                   from kenn_katalog_rpt R, kenn_katalog K, kenn_cifx C
                   where R.katalog_id=K.id
                   and R.report_id=C.apnr
                   and R.active > 0
                   and C.key=666
          
        ;
	

select now(), 'Erzeuge View kenn_report';

create view kenn_report(
	apnr, 
druck, 
sortnr, 
land_apnr, 
is_download, 
bezugsart, 
gruppe) as
	
          
                   SELECT apnr,
		   druck,
		   sort1 as sortnr,
		   land_apnr,
		   (case when intern_c='D' then 'J' else 'N' end) as is_download,
		   struktur_c as bezugsart ,
		   gruppe
		   from kenn_cifx 
		   where key in (666,679)
          
        ;
	

select now(), 'Erzeuge View kenn_report_fuer_stichtagsarten';

create view kenn_report_fuer_stichtagsarten(
	apnr, 
druck, 
sortnr, 
land_apnr, 
is_download, 
bezugsart) as
	
          
                   SELECT apnr,
		   druck,
		   sort1 as sortnr,
		   land_apnr,
		   (case when intern_c='D' then 'J' else 'N' end) as is_download,
		   struktur_c as bezugsart 
		   from kenn_cifx 
		   where key in (688)
          
        ;
	

select now(), 'Erzeuge View kenn_bezugszeit';

create view kenn_bezugszeit(
	bezugsart, 
bezugszeit, 
druck) as
	
          
                   
	    select 'S'::char(1) as bezugsart,
	    K.tid as bezugszeit,
	    K.druck 
	    from kenn_semester K
	    union select 'J',
	    ord as bezugszeit,
	    name::varchar(255) as druck
	    from aggregierung 
	    where kategorie='KENN-Jahr'
	    union
	    SELECT 'Q',
	    CAST(apnr AS INTEGER),
	    druck
	    FROM kenn_cifx where key=664
           
        ;
	

select now(), 'Erzeuge View kenn_abschl_astat_pruef_grp';

create view kenn_abschl_astat_pruef_grp(
	astat, 
pruef_grp, 
kurz, 
druck, 
lang_1, 
sort1) as
	
          
                   SELECT G.astat,G.pruef_grp, C.kurz, C.druck,C.lang_1, C.sort1
                   from kenn_cifx C left outer join kenn_abschl_pruef_grp G
                   on (G.pruef_grp = C.apnr)
                   where C.key=687
                   
          
        ;
	

select now(), 'Erzeuge View kenn_stbb_kapitel';

create view kenn_stbb_kapitel(
	kapitel) as
	
          
                   SELECT distinct kapitel 
		   from kenn_stbb_kap_titel_bericht
                   
          
        ;
	

select now(), 'Erzeuge View kenn_stbb_titel';

create view kenn_stbb_titel(
	titel) as
	
          
                   SELECT distinct titel 
		   from kenn_stbb_kap_titel_bericht
                   
          
        ;
	

select now(), 'Erzeuge View k_astat_studienfach_land_l';

create view k_astat_studienfach_land_l(
	schluessel, 
gueltig_ab, 
land, 
version, 
sortkey, 
gueltig_bis, 
name, 
isced, 
keybund) as
	
          
					select 
						L.schluessel,
						L.gueltig_ab,
						L.land,
						L.version,
						L.sortkey,
						L.gueltig_bis,
						L.name,
						L.isced,
						L.keybund
					from 
						k_astat_studienfach_land L,
						cif C
					where 
						C.apnr=L.land
						and C.key=659  
          
        ;
	

select now(), 'Erzeuge View kenn_hochschulen_plus';

create view kenn_hochschulen_plus(
	hs_nr, 
kuerzel) as
	
          
					select hs_nr::char(40), kuerzel from kenn_hochschulen union 
					select 'hochschulroot', 'Gesamt' from xdummy union
					select '10001', 'Uni' from xdummy union
					select '20001', 'FH' from xdummy union
					select '30001', 'KunstMusik' from xdummy union
					select '40001', 'Sonst' from xdummy
					; 
          
        ;
	
</#if>
