
--SQL Script automatisch generiert von SuperX module_upgrade.xsl
--Freemarker Template
<sqlvars>
<sqlvar name="tables" type="list">

select relname,relname as tabelle from pg_class JOIN pg_namespace ON pg_namespace.oid = pg_class.relnamespace WHERE pg_namespace.nspname = 'public' AND relname::varchar(200) in ('kenn_sos_stg',
'kenn_sos_lab',
'kenn_semester',
'kenn_stichtag',
'kenn_staat',
'kenn_geschl',
'kenn_hzbart',
'kenn_kzfa',
'kenn_hochschulen',
'kenn_busa_aggr',
'kenn_vtbu_aggr',
'kenn_flaeche',
'kenn_stug',
'kenn_su_imp_stud',
'kenn_alt_keys',
'kenn_fikr',
'kenn_inst_to_ext',
'kenn_inst',
'kenn_extkotr',
'kenn_sgd_aggr',
'kenn_pbe_aggr',
'kenn_pbv_aggr',
'kenn_pbv_aggr_astat',
'kenn_k_buadbz',
'kenn_lfb_fg',
'kenn_cifx',
'kenn_status',
'kenn_pruefrout',
'kenn_sb_astfr_lfb',
'kenn_sichten',
'kenn_zahl_wert',
'kenn_konto_aggr',
'kenn_drittm_aggr',
'kenn_hsfinanz_stat',
'kenn_dr',
'kenn_titel',
'kenn_katalog',
'kenn_katalog_rpt',
'kenn_katalog_grp',
'kenn_katalog_sub',
'kenn_vari',
'kenn_lieferung',
'kenn_quartal_hier',
'kenn_anlagen_aggr',
'kenn_stg_int',
'kenn_abint',
'kenn_hzbart_astat',
'kenn_stufrm',
'kenn_stuart',
'kenn_stort',
'kenn_antr_aggr',
'kenn_antr_prozess_aggr',
'kenn_stg_aggr',
'kenn_kzfach_int',
'kenn_vert_int',
'kenn_abschl_sbereich',
'kenn_extkotr_stg',
'kenn_proj_gege',
'kenn_pbv_klr',
'kenn_auslastung',
'kenn_fibu_guv',
'kenn_fibu_bilanz',
'kenn_fibu_quartal',
'kenn_fibu_wiplan',
'kenn_kam_quartal',
'kenn_kam_ja',
'kenn_stupl',
'kenn_zulzahl_id',
'kenn_zulzahl_sem',
'kenn_zulzahl2int',
'kenn_vtbu_qp_aggr',
'kenn_stg_cube',
'kenn_sember_stg_cube',
'kenn_antr_cube',
'kenn_extkotr_lfb_hs',
'kenn_bestand',
'kenn_report_stichtagsart',
'kenn_bestandsart',
'kenn_bestandsart_bland',
'kenn_promo',
'kenn_promo_aggr',
'kenn_stichtagsart',
'kenn_dim_extkotr',
'kenn_pkosten_cube',
'kenn_dim_extkost',
'kenn_skosten_cube',
'kenn_flaeche_cube',
'kenn_dim_lfb_fg',
'kenn_pbv_astat',
'kenn_sos_astat',
'kenn_lab_astat',
'kenn_stg_aggr_astat',
'kenn_stud_aggr_astat',
'kenn_lab_aggr_astat',
'kenn_absolv_aggr_astat',
'kenn_dim_fgr',
'kenn_sos_astat_2015',
'kenn_lab_astat_2015',
'kenn_kennz_aggr',
'kenn_prom_astat',
'kenn_abschl_pruef_grp',
'kenn_stelle_bvl_bez',
'kenn_stelle_hhpl',
'kenn_stbb_kap_titel_bericht',
'kenn_rpt_ansprech',
'kenn_rpt_version',
'kenn_stylesheet_version',
'kenn_zsl_ausgleich_kennungen') UNION SELECT pg_namespace.nspname||'.'||relname as relname,pg_namespace.nspname||'.'||relname as tabelle from pg_class JOIN pg_namespace ON pg_namespace.oid = pg_class.relnamespace WHERE pg_namespace.nspname||'.'||relname in ('kenn_sos_stg',
'kenn_sos_lab',
'kenn_semester',
'kenn_stichtag',
'kenn_staat',
'kenn_geschl',
'kenn_hzbart',
'kenn_kzfa',
'kenn_hochschulen',
'kenn_busa_aggr',
'kenn_vtbu_aggr',
'kenn_flaeche',
'kenn_stug',
'kenn_su_imp_stud',
'kenn_alt_keys',
'kenn_fikr',
'kenn_inst_to_ext',
'kenn_inst',
'kenn_extkotr',
'kenn_sgd_aggr',
'kenn_pbe_aggr',
'kenn_pbv_aggr',
'kenn_pbv_aggr_astat',
'kenn_k_buadbz',
'kenn_lfb_fg',
'kenn_cifx',
'kenn_status',
'kenn_pruefrout',
'kenn_sb_astfr_lfb',
'kenn_sichten',
'kenn_zahl_wert',
'kenn_konto_aggr',
'kenn_drittm_aggr',
'kenn_hsfinanz_stat',
'kenn_dr',
'kenn_titel',
'kenn_katalog',
'kenn_katalog_rpt',
'kenn_katalog_grp',
'kenn_katalog_sub',
'kenn_vari',
'kenn_lieferung',
'kenn_quartal_hier',
'kenn_anlagen_aggr',
'kenn_stg_int',
'kenn_abint',
'kenn_hzbart_astat',
'kenn_stufrm',
'kenn_stuart',
'kenn_stort',
'kenn_antr_aggr',
'kenn_antr_prozess_aggr',
'kenn_stg_aggr',
'kenn_kzfach_int',
'kenn_vert_int',
'kenn_abschl_sbereich',
'kenn_extkotr_stg',
'kenn_proj_gege',
'kenn_pbv_klr',
'kenn_auslastung',
'kenn_fibu_guv',
'kenn_fibu_bilanz',
'kenn_fibu_quartal',
'kenn_fibu_wiplan',
'kenn_kam_quartal',
'kenn_kam_ja',
'kenn_stupl',
'kenn_zulzahl_id',
'kenn_zulzahl_sem',
'kenn_zulzahl2int',
'kenn_vtbu_qp_aggr',
'kenn_stg_cube',
'kenn_sember_stg_cube',
'kenn_antr_cube',
'kenn_extkotr_lfb_hs',
'kenn_bestand',
'kenn_report_stichtagsart',
'kenn_bestandsart',
'kenn_bestandsart_bland',
'kenn_promo',
'kenn_promo_aggr',
'kenn_stichtagsart',
'kenn_dim_extkotr',
'kenn_pkosten_cube',
'kenn_dim_extkost',
'kenn_skosten_cube',
'kenn_flaeche_cube',
'kenn_dim_lfb_fg',
'kenn_pbv_astat',
'kenn_sos_astat',
'kenn_lab_astat',
'kenn_stg_aggr_astat',
'kenn_stud_aggr_astat',
'kenn_lab_aggr_astat',
'kenn_absolv_aggr_astat',
'kenn_dim_fgr',
'kenn_sos_astat_2015',
'kenn_lab_astat_2015',
'kenn_kennz_aggr',
'kenn_prom_astat',
'kenn_abschl_pruef_grp',
'kenn_stelle_bvl_bez',
'kenn_stelle_hhpl',
'kenn_stbb_kap_titel_bericht',
'kenn_rpt_ansprech',
'kenn_rpt_version',
'kenn_stylesheet_version',
'kenn_zsl_ausgleich_kennungen'
);</sqlvar>
</sqlvars>

<#assign deleted_tables = []>


select now(), 'Checking tables';


<#if !deleted_tables?seq_contains("kenn_sos_stg") && tables?is_sequence && tables?seq_contains("kenn_sos_stg") >


select now(), 'table kenn_sos_stg exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_sos_stg';

create table kenn_sos_stg(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_rueck_beur_ein SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
regel SMALLINT , 
hzbart SMALLINT , 
kz_rueck_beur_ein SMALLINT , 
fach_sem_zahl SMALLINT , 
hssem SMALLINT , 
kz_fach CHAR(1) , 
datum date , 
summe INTEGER , 
extkost CHAR(30) , 
extkotr CHAR(30) , 
stufrm CHAR(10) , 
hrst CHAR(10) 
) 
;



comment on table kenn_sos_stg is 'Hilfstabelle Studierendenstatistik (Haupthrer ohne beurlaubte und exmatrik., stichtagsbezogen)';

comment on column kenn_sos_stg.hs_nr is 'Hochschulnummer';

comment on column kenn_sos_stg.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_sos_stg.fach_nr is 'Fach-Nummer';

comment on column kenn_sos_stg.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_sos_stg.ca12_staat is 'Nationalitt';

comment on column kenn_sos_stg.sem_rueck_beur_ein is 'Semester';

comment on column kenn_sos_stg.stg is 'Fach (amtlich)';

comment on column kenn_sos_stg.abschluss is 'Abschluss (amtlich)';

comment on column kenn_sos_stg.regel is 'in der RSZ (0=nein, 1=ja,-1=unbekannt)';

comment on column kenn_sos_stg.hzbart is 'Art der Hochschulzugangsber.';

comment on column kenn_sos_stg.kz_rueck_beur_ein is 'Einschreib- oder Rckmeldestatus';

comment on column kenn_sos_stg.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_sos_stg.hssem is 'Anzahl Hochschulsemester';

comment on column kenn_sos_stg.kz_fach is 'Fachkennzeichen';

comment on column kenn_sos_stg.datum is 'Datum der Erzeugung';

comment on column kenn_sos_stg.summe is 'Summe';

comment on column kenn_sos_stg.extkost is 'Externe Kostenstelle';

comment on column kenn_sos_stg.extkotr is 'Externer Produktschlssel';

comment on column kenn_sos_stg.stufrm is 'Studienform';

comment on column kenn_sos_stg.hrst is 'Hrerstatus';


select now(), 'Erzeuge Index ixkenn_sos_stg1';

create  index ixkenn_sos_stg1 on kenn_sos_stg (hs_nr );


select now(), 'Erzeuge Index ixkenn_sos_stg2';

create  index ixkenn_sos_stg2 on kenn_sos_stg (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_sos_stg3';

create  index ixkenn_sos_stg3 on kenn_sos_stg (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_sos_stg4';

create  index ixkenn_sos_stg4 on kenn_sos_stg (sem_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_sos_stg5';

create  index ixkenn_sos_stg5 on kenn_sos_stg (abschluss );


select now(), 'Erzeuge Index ixkenn_sos_stg6';

create  index ixkenn_sos_stg6 on kenn_sos_stg (hzbart );


select now(), 'Erzeuge Index ixkenn_sos_stg7';

create  index ixkenn_sos_stg7 on kenn_sos_stg (kz_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_sos_stg8';

create  index ixkenn_sos_stg8 on kenn_sos_stg (kz_fach );

</#if>
delete from db_tabellen where name='kenn_sos_stg';
insert into db_tabellen (name,protokollierung) values('kenn_sos_stg',0);

<#if !deleted_tables?seq_contains("kenn_sos_lab") && tables?is_sequence && tables?seq_contains("kenn_sos_lab") >


select now(), 'table kenn_sos_lab exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_sos_lab';

create table kenn_sos_lab(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_der_pruefung SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
fach_sem_zahl SMALLINT , 
hzbart CHAR(2) , 
kz_fach CHAR(1) , 
regel SMALLINT , 
datum date , 
summe INTEGER , 
extkost CHAR(30) , 
extkotr CHAR(30) , 
stufrm CHAR(10) 
) 
;



comment on table kenn_sos_lab is 'Hilfstabelle Prfungen (Hauptprfungen, bestanden, stichtagsbezogen)';

comment on column kenn_sos_lab.hs_nr is 'Hochschulnummer';

comment on column kenn_sos_lab.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_sos_lab.fach_nr is 'Fach-Nummer';

comment on column kenn_sos_lab.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_sos_lab.ca12_staat is 'Nationalitt';

comment on column kenn_sos_lab.sem_der_pruefung is 'Semester';

comment on column kenn_sos_lab.stg is 'Fach (amtlich)';

comment on column kenn_sos_lab.abschluss is 'Abschluss (amtlich)';

comment on column kenn_sos_lab.fach_sem_zahl is 'Dauer des Studiums in Fachsem.';

comment on column kenn_sos_lab.hzbart is 'Art der Hochschulzugangsber.';

comment on column kenn_sos_lab.kz_fach is 'Fachkennzeichen';

comment on column kenn_sos_lab.regel is 'in der RSZ. BaWue: 0=nein, 1=ja,-1=unbekannt. Sachsen: -1=RSZ unbek., 0=ber der RSZ (+4), 1=in der RSZ, 2=RSZ +1, 3=RSZ +2, 4=RSZ +3';

comment on column kenn_sos_lab.datum is 'Datum der Erzeugung';

comment on column kenn_sos_lab.summe is 'Summe';

comment on column kenn_sos_lab.extkost is 'Externe Kostenstelle';

comment on column kenn_sos_lab.extkotr is 'Externer Produktschlssel';

comment on column kenn_sos_lab.stufrm is 'Studienform';


select now(), 'Erzeuge Index ixkenn_sos_lab1';

create  index ixkenn_sos_lab1 on kenn_sos_lab (hs_nr );


select now(), 'Erzeuge Index ixkenn_sos_lab2';

create  index ixkenn_sos_lab2 on kenn_sos_lab (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_sos_lab3';

create  index ixkenn_sos_lab3 on kenn_sos_lab (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_sos_lab4';

create  index ixkenn_sos_lab4 on kenn_sos_lab (sem_der_pruefung );


select now(), 'Erzeuge Index ixkenn_sos_lab5';

create  index ixkenn_sos_lab5 on kenn_sos_lab (abschluss );


select now(), 'Erzeuge Index ixkenn_sos_lab6';

create  index ixkenn_sos_lab6 on kenn_sos_lab (hzbart );


select now(), 'Erzeuge Index ixkenn_sos_lab8';

create  index ixkenn_sos_lab8 on kenn_sos_lab (kz_fach );

</#if>
delete from db_tabellen where name='kenn_sos_lab';
insert into db_tabellen (name,protokollierung) values('kenn_sos_lab',0);

<#if !deleted_tables?seq_contains("kenn_semester") && tables?is_sequence && tables?seq_contains("kenn_semester") >


select now(), 'table kenn_semester exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_semester';

create table kenn_semester(
	tid INTEGER , 
kurz CHAR(50) , 
druck CHAR(200) , 
akad_jahr SMALLINT , 
akad_jahr_absolv SMALLINT , 
akad_jahr_anf SMALLINT , 
sem_beginn DATE , 
sem_ende DATE 
) 
;



comment on table kenn_semester is 'Schlsseltabelle Semester';

comment on column kenn_semester.tid is 'Schlssel';

comment on column kenn_semester.akad_jahr is 'Akademisches Jahr BW';

comment on column kenn_semester.akad_jahr_absolv is 'Akademisches Jahr fr Absolventen SA';

comment on column kenn_semester.akad_jahr_anf is 'Akademisches Jahr fr Studienanfnger SA';

</#if>
delete from db_tabellen where name='kenn_semester';
insert into db_tabellen (name,protokollierung) values('kenn_semester',0);

<#if !deleted_tables?seq_contains("kenn_stichtag") && tables?is_sequence && tables?seq_contains("kenn_stichtag") >


select now(), 'table kenn_stichtag exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stichtag';

create table kenn_stichtag(
	tid SERIAL , 
stichtag DATE , 
bezugszeit SMALLINT , 
bezugsart CHAR(1)  not null, 
stichtagsart CHAR(100) , 
berechnen CHAR(1)  default '1' , 
exportieren CHAR(1)  default '1' , 
stichtagsart_id CHAR(40) , 
	constraint c_kenn_stich_tid primary key (tid)

) 
;



comment on table kenn_stichtag is 'Schlsseltabelle Stichtage zu Datenlieferungen';

comment on column kenn_stichtag.tid is 'Schlssel';

comment on column kenn_stichtag.stichtag is 'Stichtag';

comment on column kenn_stichtag.bezugszeit is 'Bezug des Stichtags';

comment on column kenn_stichtag.bezugsart is 'Bezugsart (Semester S,Jahr J, Quartal Q, Monat M)';

comment on column kenn_stichtag.stichtagsart is 'Art des Stichtags';

comment on column kenn_stichtag.berechnen is 'Berechnen?';

comment on column kenn_stichtag.exportieren is 'Exportieren?';

comment on column kenn_stichtag.stichtagsart_id is 'Stichtagsart';

</#if>
delete from db_tabellen where name='kenn_stichtag';
insert into db_tabellen (name,protokollierung) values('kenn_stichtag',0);

<#if !deleted_tables?seq_contains("kenn_staat") && tables?is_sequence && tables?seq_contains("kenn_staat") >


select now(), 'table kenn_staat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_staat';

create table kenn_staat(
	astat CHAR(10) , 
druck CHAR(150) , 
erdteil CHAR(10) , 
d_akt_von DATE , 
d_akt_bis DATE 
) 
;



comment on table kenn_staat is 'Nationalitten der Studierenden';

comment on column kenn_staat.d_akt_von is 'gltig von';

comment on column kenn_staat.d_akt_bis is 'gltig bis';

</#if>
delete from db_tabellen where name='kenn_staat';
insert into db_tabellen (name,protokollierung) values('kenn_staat',0);

<#if !deleted_tables?seq_contains("kenn_geschl") && tables?is_sequence && tables?seq_contains("kenn_geschl") >


select now(), 'table kenn_geschl exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_geschl';

create table kenn_geschl(
	apnr integer  not null, 
druck CHAR(150) 
) 
;



comment on table kenn_geschl is 'View Geschlecht';

</#if>
delete from db_tabellen where name='kenn_geschl';
insert into db_tabellen (name,protokollierung) values('kenn_geschl',0);

<#if !deleted_tables?seq_contains("kenn_hzbart") && tables?is_sequence && tables?seq_contains("kenn_hzbart") >


select now(), 'table kenn_hzbart exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_hzbart';

create table kenn_hzbart(
	astat CHAR(2) , 
druck CHAR(150) 
) 
;



comment on table kenn_hzbart is 'View Hochschulzugangsberechtigung (gruppiert)';

</#if>
delete from db_tabellen where name='kenn_hzbart';
insert into db_tabellen (name,protokollierung) values('kenn_hzbart',0);

<#if !deleted_tables?seq_contains("kenn_kzfa") && tables?is_sequence && tables?seq_contains("kenn_kzfa") >


select now(), 'table kenn_kzfa exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_kzfa';

create table kenn_kzfa(
	astat CHAR(10) , 
kurz CHAR(10) , 
druck CHAR(150) , 
tid SERIAL 
) 
;



comment on table kenn_kzfa is 'View Fachkennzeichen (H=Hauptfach, N=Nebenfach)';

comment on column kenn_kzfa.tid is 'Laufnummer';

</#if>
delete from db_tabellen where name='kenn_kzfa';
insert into db_tabellen (name,protokollierung) values('kenn_kzfa',0);

<#if !deleted_tables?seq_contains("kenn_hochschulen") && tables?is_sequence && tables?seq_contains("kenn_hochschulen") >


select now(), 'table kenn_hochschulen exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_hochschulen';

create table kenn_hochschulen(
	name CHAR(100)  not null, 
hs_nr INTEGER  not null, 
kapitel CHAR(5) , 
art CHAR(10) , 
traegerschaft CHAR(10) , 
kurztext CHAR(100) , 
ort VARCHAR(255) , 
bland CHAR(10) , 
kuerzel CHAR(10) , 
	constraint k_hochschulen primary key (hs_nr)

) 
;



comment on table kenn_hochschulen is 'Verzeichnis der Hochschulen';

comment on column kenn_hochschulen.name is 'Hochschulname';

comment on column kenn_hochschulen.hs_nr is 'Hochschulnummer (HIS)';

comment on column kenn_hochschulen.kapitel is 'Hochschulkapitel';

comment on column kenn_hochschulen.art is 'Hochschulart';

comment on column kenn_hochschulen.traegerschaft is 'Trgerschaft';

comment on column kenn_hochschulen.kurztext is 'Hochschulname (kurz)';

comment on column kenn_hochschulen.ort is 'Hochschulort';

comment on column kenn_hochschulen.bland is 'Bundesland';

comment on column kenn_hochschulen.kuerzel is 'Bundesland';

</#if>
delete from db_tabellen where name='kenn_hochschulen';
insert into db_tabellen (name,protokollierung) values('kenn_hochschulen',0);

<#if !deleted_tables?seq_contains("kenn_busa_aggr") && tables?is_sequence && tables?seq_contains("kenn_busa_aggr") >


select now(), 'table kenn_busa_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_busa_aggr';

create table kenn_busa_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
monat SMALLINT , 
fikrkey CHAR(12) , 
kokl_faktor SMALLINT , 
klr_geldgeber CHAR(10) , 
ch110_institut VARCHAR(50) , 
projnr CHAR(10) , 
datum date , 
betrag double precision , 
bvkr_art CHAR(12) , 
inst_art CHAR(20) 
) 
;



comment on table kenn_busa_aggr is 'Hilfstabelle Primrkosten, busa steht fr Buchungsstze, aber die Werte sind aggregiert';

comment on column kenn_busa_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_busa_aggr.jahr is 'Jahr der Buchung';

comment on column kenn_busa_aggr.quartal is 'Quartal der Buchung';

comment on column kenn_busa_aggr.monat is 'Monat der Buchung';

comment on column kenn_busa_aggr.fikrkey is 'Kostenart';

comment on column kenn_busa_aggr.kokl_faktor is 'Kostenklasse (1=Kosten, -1=Erls)';

comment on column kenn_busa_aggr.klr_geldgeber is 'Geldgeber nach KLR (Drittm.,Fremdkap.,HH)';

comment on column kenn_busa_aggr.ch110_institut is 'Kostenstelle (alternative Hierarchie KENN-Kostenstellen)';

comment on column kenn_busa_aggr.projnr is 'Externer Kostentrger';

comment on column kenn_busa_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_busa_aggr.betrag is 'Betrag in EUR';

comment on column kenn_busa_aggr.bvkr_art is 'Kostenart (BVKR)';

comment on column kenn_busa_aggr.inst_art is 'Externe Kostenstelle';


select now(), 'Erzeuge Index ixkenn_busa_aggr1';

create  index ixkenn_busa_aggr1 on kenn_busa_aggr (jahr, 
monat, 
fikrkey, 
ch110_institut );


select now(), 'Erzeuge Index ixkenn_busa_aggr2';

create  index ixkenn_busa_aggr2 on kenn_busa_aggr (kokl_faktor );


select now(), 'Erzeuge Index ixkenn_busa_aggr3';

create  index ixkenn_busa_aggr3 on kenn_busa_aggr (projnr );


select now(), 'Erzeuge Index ixkenn_busa_aggr4';

create  index ixkenn_busa_aggr4 on kenn_busa_aggr (quartal );


select now(), 'Erzeuge Index ixkenn_busa_aggr5';

create  index ixkenn_busa_aggr5 on kenn_busa_aggr (klr_geldgeber );


select now(), 'Erzeuge Index kenn_busa_aggr6';

create  index kenn_busa_aggr6 on kenn_busa_aggr (hs_nr );


select now(), 'Erzeuge Index kenn_busa_aggr7';

create  index kenn_busa_aggr7 on kenn_busa_aggr (bvkr_art );


select now(), 'Erzeuge Index kenn_busa_aggr8';

create  index kenn_busa_aggr8 on kenn_busa_aggr (inst_art );

</#if>
delete from db_tabellen where name='kenn_busa_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_busa_aggr',0);

<#if !deleted_tables?seq_contains("kenn_vtbu_aggr") && tables?is_sequence && tables?seq_contains("kenn_vtbu_aggr") >


select now(), 'table kenn_vtbu_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_vtbu_aggr';

create table kenn_vtbu_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
monat SMALLINT , 
quell_ch110_inst VARCHAR(50) , 
quell_projnr CHAR(10) , 
quell_stug CHAR(20) , 
ziel_projnr CHAR(10) , 
ziel_stug CHAR(20) , 
ziel_fikrkey CHAR(12) , 
kokl CHAR(1) , 
klr_geldgeber CHAR(3) , 
vari CHAR(1) , 
datum date , 
betrag double precision , 
ziel_ch110_inst CHAR(10) 
) 
;



comment on table kenn_vtbu_aggr is 'Hilfstabelle Verteilbuchungen aus HISCOB';

comment on column kenn_vtbu_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_vtbu_aggr.quartal is 'Quartal der Buchung';

comment on column kenn_vtbu_aggr.quell_ch110_inst is 'Abgebende Kostenstelle';

comment on column kenn_vtbu_aggr.quell_projnr is 'Projektnr. (ext. Kostentrger)';

comment on column kenn_vtbu_aggr.quell_stug is 'Studiengang';

comment on column kenn_vtbu_aggr.ziel_projnr is 'Projektnr. (ext. Kostentrger)';

comment on column kenn_vtbu_aggr.ziel_stug is 'Studiengang';

comment on column kenn_vtbu_aggr.ziel_fikrkey is 'Ziel-Kostenartenblock';

comment on column kenn_vtbu_aggr.kokl is 'Kontenklasse';

comment on column kenn_vtbu_aggr.klr_geldgeber is 'Geldgeber';

comment on column kenn_vtbu_aggr.vari is 'Verteilschritte';

comment on column kenn_vtbu_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_vtbu_aggr.ziel_ch110_inst is 'Ziel-Kostenstelle';


select now(), 'Erzeuge Index ixkenn_vtbu_aggr1';

create  index ixkenn_vtbu_aggr1 on kenn_vtbu_aggr (jahr, 
monat, 
quell_projnr, 
ziel_projnr, 
ziel_fikrkey );


select now(), 'Erzeuge Index kenn_vtbu_aggr3';

create  index kenn_vtbu_aggr3 on kenn_vtbu_aggr (quell_stug );


select now(), 'Erzeuge Index kenn_vtbu_aggr4';

create  index kenn_vtbu_aggr4 on kenn_vtbu_aggr (ziel_stug );


select now(), 'Erzeuge Index kenn_vtbu_aggr5';

create  index kenn_vtbu_aggr5 on kenn_vtbu_aggr (klr_geldgeber );


select now(), 'Erzeuge Index kenn_vtbu_aggr6';

create  index kenn_vtbu_aggr6 on kenn_vtbu_aggr (hs_nr );


select now(), 'Erzeuge Index kenn_vtbu_aggr7';

create  index kenn_vtbu_aggr7 on kenn_vtbu_aggr (vari );


select now(), 'Erzeuge Index kenn_vtbu_aggr8';

create  index kenn_vtbu_aggr8 on kenn_vtbu_aggr (kokl );

</#if>
delete from db_tabellen where name='kenn_vtbu_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_vtbu_aggr',0);

<#if !deleted_tables?seq_contains("kenn_flaeche") && tables?is_sequence && tables?seq_contains("kenn_flaeche") >


select now(), 'table kenn_flaeche exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_flaeche';

create table kenn_flaeche(
	hs_nr INTEGER , 
ch110_institut VARCHAR(50) , 
nutzungsart CHAR(4) , 
kfanr VARCHAR(10) , 
jahr SMALLINT , 
datum date , 
flaeche double precision , 
extkotr CHAR(30) 
) 
;



comment on table kenn_flaeche is 'Hilfstabelle Flchen aus HISCOB (Tabl. cob_imp_flaeche)';

comment on column kenn_flaeche.hs_nr is 'Hochschulnummer';

comment on column kenn_flaeche.ch110_institut is 'Kostenstelle (alternative Hierarchie KENN-Kostenstellen)';

comment on column kenn_flaeche.nutzungsart is 'Raumnutzungsart';

comment on column kenn_flaeche.kfanr is 'Kostenflchenart';

comment on column kenn_flaeche.jahr is 'Jahr des Stichtags';

comment on column kenn_flaeche.datum is 'Datum der Erzeugung';

comment on column kenn_flaeche.extkotr is 'Externer Produktschlssel';


select now(), 'Erzeuge Index ixkenn_flaeche1';

create  index ixkenn_flaeche1 on kenn_flaeche (hs_nr );


select now(), 'Erzeuge Index ixkenn_flaeche2';

create  index ixkenn_flaeche2 on kenn_flaeche (ch110_institut );


select now(), 'Erzeuge Index ixkenn_flaeche3';

create  index ixkenn_flaeche3 on kenn_flaeche (nutzungsart );


select now(), 'Erzeuge Index ixkenn_flaeche4';

create  index ixkenn_flaeche4 on kenn_flaeche (kfanr );


select now(), 'Erzeuge Index ixkenn_flaeche5';

create  index ixkenn_flaeche5 on kenn_flaeche (jahr );

</#if>
delete from db_tabellen where name='kenn_flaeche';
insert into db_tabellen (name,protokollierung) values('kenn_flaeche',0);

<#if !deleted_tables?seq_contains("kenn_stug") && tables?is_sequence && tables?seq_contains("kenn_stug") >


select now(), 'table kenn_stug exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stug';

create table kenn_stug(
	hs_nr INTEGER , 
stug_key CHAR(20) , 
stug_von DATE , 
stug_fach CHAR(10) , 
stug_abschl CHAR(10) , 
stug_dbez CHAR(51) , 
stug_rstuz SMALLINT , 
stug_cnw double precision , 
stug_bis DATE , 
key_lehreinh CHAR(10) , 
stug_plaetze SMALLINT , 
k_extkotr CHAR(10) 
) 
;



comment on column kenn_stug.hs_nr is 'Hochschulnummer';


select now(), 'Erzeuge Index kenn_hs_nr_key';

create  index kenn_hs_nr_key on kenn_stug (hs_nr );


select now(), 'Erzeuge Index kenn_uxstug_key';

create  index kenn_uxstug_key on kenn_stug (stug_key );

</#if>
delete from db_tabellen where name='kenn_stug';
insert into db_tabellen (name,protokollierung) values('kenn_stug',0);

<#if !deleted_tables?seq_contains("kenn_su_imp_stud") && tables?is_sequence && tables?seq_contains("kenn_su_imp_stud") >


select now(), 'table kenn_su_imp_stud exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_su_imp_stud';

create table kenn_su_imp_stud(
	hs_nr INTEGER , 
lehreinheit CHAR(10) , 
k_extkotr CHAR(10) , 
sem INTEGER , 
stgnr VARCHAR(2) , 
fsemnr INTEGER , 
fachkey VARCHAR(4) , 
fachkeydbez VARCHAR(25) , 
abslkey VARCHAR(2) , 
abslkeydbez VARCHAR(25) , 
kzfach VARCHAR(1) , 
stufrm VARCHAR(1) , 
stufrmdbez VARCHAR(25) , 
kzfachdbez VARCHAR(25) , 
ffstgnr VARCHAR(2) , 
gruppierung VARCHAR(4) , 
ffgewicht double precision , 
stugkey CHAR(20) , 
vza double precision , 
ffges double precision , 
ffidr double precision , 
ff1_4 double precision , 
ffidrgfs double precision , 
ff1_4gfs double precision , 
ffidrgf2 double precision , 
ff1_4gf2 double precision , 
kpfges double precision , 
kpfidr double precision , 
kpf1_4 double precision , 
datum date 
) 
;



comment on table kenn_su_imp_stud is 'Studierendenstatistik fr die Kostenrechnung aus dem SuperX-COB-Modul';

comment on column kenn_su_imp_stud.hs_nr is 'Hochschulnummer';

comment on column kenn_su_imp_stud.lehreinheit is 'Lehreinheit aus cob_stug';

comment on column kenn_su_imp_stud.k_extkotr is 'externer Kostentrger';

comment on column kenn_su_imp_stud.vza is 'Vollzeitquivalent';

comment on column kenn_su_imp_stud.ffges is 'Fachflle gesamt';

comment on column kenn_su_imp_stud.ffidr is 'Fachflle in der RSZ';

comment on column kenn_su_imp_stud.ff1_4 is 'Fachflle 1.-4. Fachsemester';

comment on column kenn_su_imp_stud.ffidrgfs is 'FFA i.d.RSZ';

comment on column kenn_su_imp_stud.ff1_4gfs is 'VZ 1.-4. Fachsemester';

comment on column kenn_su_imp_stud.ffidrgf2 is 'VZ i.d. RSZ';

comment on column kenn_su_imp_stud.ff1_4gf2 is 'VZ 1.-4. Fachsemester';

comment on column kenn_su_imp_stud.kpfges is 'Kpfe gesamt';

comment on column kenn_su_imp_stud.kpfidr is 'Kpfe i.d. RSZ';

comment on column kenn_su_imp_stud.kpf1_4 is 'Kpfe 1.-4. Fachsemester';

comment on column kenn_su_imp_stud.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ix_kennstud_view_s';

create  index ix_kennstud_view_s on kenn_su_imp_stud (sem );


select now(), 'Erzeuge Index ix_kennstud_view1';

create  index ix_kennstud_view1 on kenn_su_imp_stud (hs_nr );


select now(), 'Erzeuge Index ix_kennstud_view2';

create  index ix_kennstud_view2 on kenn_su_imp_stud (k_extkotr );


select now(), 'Erzeuge Index ix_kennstud_view3';

create  index ix_kennstud_view3 on kenn_su_imp_stud (stgnr );


select now(), 'Erzeuge Index ix_kennstud_view4';

create  index ix_kennstud_view4 on kenn_su_imp_stud (stugkey );


select now(), 'Erzeuge Index ix_kennstud_view5';

create  index ix_kennstud_view5 on kenn_su_imp_stud (kzfach );

</#if>
delete from db_tabellen where name='kenn_su_imp_stud';
insert into db_tabellen (name,protokollierung) values('kenn_su_imp_stud',0);

<#if !deleted_tables?seq_contains("kenn_alt_keys") && tables?is_sequence && tables?seq_contains("kenn_alt_keys") >


select now(), 'table kenn_alt_keys exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_alt_keys';

create table kenn_alt_keys(
	hs_nr INTEGER , 
relation CHAR(10) , 
hierarchie_id integer  not null, 
key CHAR(12) , 
parent CHAR(12) , 
flags SMALLINT 
) 
;



comment on table kenn_alt_keys is 'Enthaelt die alternativen Hierarchien aus alt_inst, alt_fikr, alt_proj, die ans MWK exportiert werden. Nur fr Hochschulen, die mit dem SuperX-COB-Modul arbeiten.';

comment on column kenn_alt_keys.hs_nr is 'Hochschulnummer';


select now(), 'Erzeuge Index kenn_alt_keys_id';

create  index kenn_alt_keys_id on kenn_alt_keys (hierarchie_id );

</#if>
delete from db_tabellen where name='kenn_alt_keys';
insert into db_tabellen (name,protokollierung) values('kenn_alt_keys',0);

<#if !deleted_tables?seq_contains("kenn_fikr") && tables?is_sequence && tables?seq_contains("kenn_fikr") >


select now(), 'table kenn_fikr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_fikr';

create table kenn_fikr(
	hs_nr INTEGER , 
key CHAR(12) , 
ueberg CHAR(12) , 
kbez CHAR(130) , 
lbez CHAR(150) , 
kokl CHAR(1) , 
habpos CHAR(1) , 
ebene SMALLINT , 
key_von DATE , 
key_bis DATE 
) 
;



comment on table kenn_fikr is 'Kostenarten (Bundesschlssel) aus dem SuperX-COB-Modul';

comment on column kenn_fikr.hs_nr is 'Hochschulnummer';


select now(), 'Erzeuge Index kenn_fikr_key';

create  index kenn_fikr_key on kenn_fikr (hs_nr, 
key, 
kokl, 
key_von, 
key_bis );


select now(), 'Erzeuge Index ixkenn_fikr_ko';

create  index ixkenn_fikr_ko on kenn_fikr (kokl );

</#if>
delete from db_tabellen where name='kenn_fikr';
insert into db_tabellen (name,protokollierung) values('kenn_fikr',0);

<#if !deleted_tables?seq_contains("kenn_inst_to_ext") && tables?is_sequence && tables?seq_contains("kenn_inst_to_ext") >


select now(), 'table kenn_inst_to_ext exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_inst_to_ext';

create table kenn_inst_to_ext(
	hs_nr INTEGER , 
instnr CHAR(10) , 
email CHAR(255) , 
key_ext CHAR(15) , 
dbez_ext CHAR(25) , 
gebnr CHAR(10) , 
key_extkotr CHAR(10) 
) 
;



comment on column kenn_inst_to_ext.hs_nr is 'Hochschulnummer';

comment on column kenn_inst_to_ext.instnr is 'Interne Kostenstellen-Nummer';

comment on column kenn_inst_to_ext.key_ext is 'Externe Kostenstellen-Nummer';

comment on column kenn_inst_to_ext.dbez_ext is 'Externe Kostenstelle Bezeichnung';

comment on column kenn_inst_to_ext.key_extkotr is 'ext. Kostentrger';


select now(), 'Erzeuge Index kuxinst_to_ext';

create  index kuxinst_to_ext on kenn_inst_to_ext (hs_nr, 
instnr );

</#if>
delete from db_tabellen where name='kenn_inst_to_ext';
insert into db_tabellen (name,protokollierung) values('kenn_inst_to_ext',0);

<#if !deleted_tables?seq_contains("kenn_inst") && tables?is_sequence && tables?seq_contains("kenn_inst") >


select now(), 'table kenn_inst exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_inst';

create table kenn_inst(
	tid SERIAL  not null, 
hs_nr INTEGER , 
key_apnr VARCHAR(50) , 
parent VARCHAR(50) , 
drucktext CHAR(50) , 
name CHAR(250) , 
ebene INTEGER , 
lehre SMALLINT , 
gueltig_seit DATE , 
gueltig_bis DATE , 
orgstruktur INTEGER , 
bund_lehr_forsch CHAR(3) , 
bund_fachgebiet CHAR(4) , 
	constraint u420_349 primary key (tid)

) 
;



comment on table kenn_inst is 'Kostenstellen der Hochschulen aus dem SuperX-COB-Modul (alternative Hierarchie KENN-Kostenstellen und KENN-Lehreinheiten)';

comment on column kenn_inst.hs_nr is 'Hochschulnummer';

comment on column kenn_inst.drucktext is 'Name (Drucktext';

comment on column kenn_inst.name is 'Name (Drucktext';


select now(), 'Erzeuge Index kenn_inst_hsnr';

create  index kenn_inst_hsnr on kenn_inst (hs_nr );


select now(), 'Erzeuge Index kenn_inst_key';

create  index kenn_inst_key on kenn_inst (key_apnr, 
gueltig_seit, 
gueltig_bis );


select now(), 'Erzeuge Index kenn_inst_parent';

create  index kenn_inst_parent on kenn_inst (parent );

</#if>
delete from db_tabellen where name='kenn_inst';
insert into db_tabellen (name,protokollierung) values('kenn_inst',0);

<#if !deleted_tables?seq_contains("kenn_extkotr") && tables?is_sequence && tables?seq_contains("kenn_extkotr") >


select now(), 'table kenn_extkotr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_extkotr';

create table kenn_extkotr(
	hs_nr INTEGER , 
key CHAR(30) , 
parent CHAR(30) , 
name CHAR(255) , 
kategorie CHAR(2) , 
fins_stugfach CHAR(3) , 
tid SERIAL , 
gueltig_von DATE , 
gueltig_bis DATE 
) 
;



comment on table kenn_extkotr is 'Verzeichnis der externen Kostentrger aus dem SuperX-COB-Modul';

comment on column kenn_extkotr.hs_nr is 'Hochschulnummer';

comment on column kenn_extkotr.key is 'Externer Kostentrgerschlssel';

comment on column kenn_extkotr.parent is 'bergeordneter Schlssel';

comment on column kenn_extkotr.name is 'Externer Kostentrgerbezeichnung';

comment on column kenn_extkotr.kategorie is 'Kostentrger-Kategorie';

comment on column kenn_extkotr.fins_stugfach is 'Finanzstatistikschlssel';

comment on column kenn_extkotr.tid is 'Laufnummer';

comment on column kenn_extkotr.gueltig_von is 'Gltig von';

comment on column kenn_extkotr.gueltig_bis is 'Gltig bis';


select now(), 'Erzeuge Index ix_kenn_extkotr';

create  index ix_kenn_extkotr on kenn_extkotr (hs_nr, 
key );

</#if>
delete from db_tabellen where name='kenn_extkotr';
insert into db_tabellen (name,protokollierung) values('kenn_extkotr',0);

<#if !deleted_tables?seq_contains("kenn_sgd_aggr") && tables?is_sequence && tables?seq_contains("kenn_sgd_aggr") >


select now(), 'table kenn_sgd_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_sgd_aggr';

create table kenn_sgd_aggr(
	hs_nr INTEGER , 
bund_fachgebiet CHAR(10) , 
bund_dienstart SMALLINT , 
faktor decimal(3,2) , 
buadbz CHAR(10) , 
besetzung CHAR(1) , 
vzae_besetzung double precision , 
koepfe_besetzung double precision , 
buadbz_besetzung CHAR(10) , 
da_besetzung SMALLINT , 
taet_besetzung SMALLINT , 
stichtag DATE , 
datum date , 
zaehlung CHAR(2) , 
summe double precision , 
titel CHAR(10) , 
bund_bvl_stelle CHAR(10) , 
hhv SMALLINT , 
kategorie_gruppe SMALLINT , 
vzae_besetzung_beamt double precision , 
vzae_besetzung_besch double precision , 
vzae_besetzung_uw double precision , 
adbz_land CHAR(10) , 
bvl_stelle_kurz VARCHAR(255) , 
kapitel CHAR(10) 
) 
;



comment on table kenn_sgd_aggr is 'Hilfstabelle Stellengrunddaten einer Hochschule (aggregiert, nur Planstellen)';

comment on column kenn_sgd_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_sgd_aggr.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_sgd_aggr.bund_dienstart is 'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)';

comment on column kenn_sgd_aggr.faktor is 'Halbe Stelle/ganze Stelle';

comment on column kenn_sgd_aggr.buadbz is 'Bundesschlssel ADBZ';

comment on column kenn_sgd_aggr.besetzung is 'Besetzungsart';

comment on column kenn_sgd_aggr.vzae_besetzung is 'Umfang der Besetzung (VZ)';

comment on column kenn_sgd_aggr.koepfe_besetzung is 'Umfang der Besetzung (Kpfe)';

comment on column kenn_sgd_aggr.buadbz_besetzung is 'Amtsdienstbezeichung (Bund) der Besetzung';

comment on column kenn_sgd_aggr.da_besetzung is 'Dienstart (Bund) der Besetzung';

comment on column kenn_sgd_aggr.taet_besetzung is 'Ttigkeit (Bund) der Besetzung';

comment on column kenn_sgd_aggr.stichtag is 'Datum der Gltigkeit der Stelle';

comment on column kenn_sgd_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_sgd_aggr.zaehlung is 'Zhlung der Stelle';

comment on column kenn_sgd_aggr.summe is 'Summe der Stellen';

comment on column kenn_sgd_aggr.titel is 'Titel der Stelle';

comment on column kenn_sgd_aggr.bund_bvl_stelle is 'BVL-Gruppe Stelle';

comment on column kenn_sgd_aggr.hhv is 'Haushaltsvermerk';

comment on column kenn_sgd_aggr.kategorie_gruppe is 'Stellenkategorie';

comment on column kenn_sgd_aggr.vzae_besetzung_beamt is 'Umfang der Besetzung (VZ) durch Beamte';

comment on column kenn_sgd_aggr.vzae_besetzung_besch is 'Umfang der Besetzung (VZ) durch Beschftigte';

comment on column kenn_sgd_aggr.vzae_besetzung_uw is 'Umfang der Besetzung (VZ) unterwertig';

comment on column kenn_sgd_aggr.adbz_land is 'Landesschlssel ADBZ';

comment on column kenn_sgd_aggr.bvl_stelle_kurz is 'Kurztext der BVL-Gruppe';

comment on column kenn_sgd_aggr.kapitel is 'Kapitel';


select now(), 'Erzeuge Index ixkenn_sgd_aggr1';

create  index ixkenn_sgd_aggr1 on kenn_sgd_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_sgd_aggr2';

create  index ixkenn_sgd_aggr2 on kenn_sgd_aggr (bund_fachgebiet, 
bund_dienstart );


select now(), 'Erzeuge Index ixkenn_sgd_aggr3';

create  index ixkenn_sgd_aggr3 on kenn_sgd_aggr (buadbz );


select now(), 'Erzeuge Index ixkenn_sgd_aggr4';

create  index ixkenn_sgd_aggr4 on kenn_sgd_aggr (da_besetzung, 
taet_besetzung );


select now(), 'Erzeuge Index ixkenn_sgd_aggr5';

create  index ixkenn_sgd_aggr5 on kenn_sgd_aggr (stichtag );


select now(), 'Erzeuge Index ixkenn_sgd_aggr6';

create  index ixkenn_sgd_aggr6 on kenn_sgd_aggr (zaehlung );

</#if>
delete from db_tabellen where name='kenn_sgd_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_sgd_aggr',0);

<#if !deleted_tables?seq_contains("kenn_pbe_aggr") && tables?is_sequence && tables?seq_contains("kenn_pbe_aggr") >


select now(), 'table kenn_pbe_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_pbe_aggr';

create table kenn_pbe_aggr(
	hs_nr INTEGER , 
bund_fachgebiet CHAR(10) , 
bund_dienstart SMALLINT , 
faktor decimal(3,2) , 
buadbz CHAR(10) , 
buadbz_besetzung CHAR(10) , 
da_besetzung SMALLINT , 
taet_besetzung SMALLINT , 
stichtag DATE , 
datum date , 
zaehlung CHAR(2) , 
summe double precision 
) 
;



comment on table kenn_pbe_aggr is 'Hilfstabelle Stellenbesetzungen einer Hochschule (aggregiert, nur Planstellen)';

comment on column kenn_pbe_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_pbe_aggr.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_pbe_aggr.bund_dienstart is 'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)';

comment on column kenn_pbe_aggr.faktor is 'Halbe Stelle/ganze Stelle';

comment on column kenn_pbe_aggr.buadbz is 'Bundesschlssel ADBZ';

comment on column kenn_pbe_aggr.buadbz_besetzung is 'Amtsdienstbezeichung (Bund) der Besetzung';

comment on column kenn_pbe_aggr.da_besetzung is 'Dienstart (Bund) der Besetzung';

comment on column kenn_pbe_aggr.taet_besetzung is 'Ttigkeit (Bund) der Besetzung';

comment on column kenn_pbe_aggr.stichtag is 'Datum der Gltigkeit der Stelle';

comment on column kenn_pbe_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_pbe_aggr.zaehlung is 'Zhlung der Besetzung';

comment on column kenn_pbe_aggr.summe is 'Umfang der Besetzung (VZ)';


select now(), 'Erzeuge Index ixkenn_pbe_aggr1';

create  index ixkenn_pbe_aggr1 on kenn_pbe_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_pbe_aggr2';

create  index ixkenn_pbe_aggr2 on kenn_pbe_aggr (bund_fachgebiet, 
bund_dienstart );


select now(), 'Erzeuge Index ixkenn_pbe_aggr3';

create  index ixkenn_pbe_aggr3 on kenn_pbe_aggr (buadbz );


select now(), 'Erzeuge Index ixkenn_pbe_aggr4';

create  index ixkenn_pbe_aggr4 on kenn_pbe_aggr (da_besetzung, 
taet_besetzung );


select now(), 'Erzeuge Index ixkenn_pbe_aggr5';

create  index ixkenn_pbe_aggr5 on kenn_pbe_aggr (stichtag );


select now(), 'Erzeuge Index ixkenn_pbe_aggr6';

create  index ixkenn_pbe_aggr6 on kenn_pbe_aggr (zaehlung );

</#if>
delete from db_tabellen where name='kenn_pbe_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_pbe_aggr',0);

<#if !deleted_tables?seq_contains("kenn_pbv_aggr") && tables?is_sequence && tables?seq_contains("kenn_pbv_aggr") >


select now(), 'table kenn_pbv_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_pbv_aggr';

create table kenn_pbv_aggr(
	hs_nr INTEGER , 
geschlecht SMALLINT , 
bund_fachgebiet CHAR(10) , 
bund_taetigkeit SMALLINT , 
bund_dienstart SMALLINT , 
buadbz CHAR(5) , 
klr_geldgeber CHAR(4) , 
kapitel CHAR(5) , 
stichtag DATE , 
zaehlung CHAR(2) , 
datum date , 
summe double precision , 
extkost CHAR(30) , 
extkotr CHAR(30) , 
befristet SMALLINT , 
staat INTEGER , 
ernennung_alter INTEGER , 
qualifizierung_art SMALLINT , 
finanzierung_art CHAR(10) 
) 
;



comment on table kenn_pbv_aggr is 'Hilfstabelle Personal-Beschftigungsverhltnisse einer Hochschule';

comment on column kenn_pbv_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_pbv_aggr.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_pbv_aggr.bund_taetigkeit is 'Art der Ttigkeit';

comment on column kenn_pbv_aggr.bund_dienstart is 'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)';

comment on column kenn_pbv_aggr.buadbz is 'Amts-Dienstbez. (Bundesschlssel)';

comment on column kenn_pbv_aggr.klr_geldgeber is 'Geldgeber aus Finanzierung';

comment on column kenn_pbv_aggr.kapitel is 'Kapitel aus Finanzierung';

comment on column kenn_pbv_aggr.stichtag is 'Datum der Gltigkeit des Besch.-Verh.';

comment on column kenn_pbv_aggr.zaehlung is 'Kpfe=k / VZAE zum Stichtag=v / (nur Sachsen:) VZAE im Jahr=j / Kpfe im Jahr=p';

comment on column kenn_pbv_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_pbv_aggr.summe is 'Summe';

comment on column kenn_pbv_aggr.extkost is 'Externe Kostenstelle';

comment on column kenn_pbv_aggr.extkotr is 'Externer Produktschlssel';

comment on column kenn_pbv_aggr.befristet is 'Befristet';

comment on column kenn_pbv_aggr.staat is 'Nationalitt';

comment on column kenn_pbv_aggr.ernennung_alter is 'Alter bei Ernennung';

comment on column kenn_pbv_aggr.qualifizierung_art is 'Tenure Track oder Nachwuchsgruppenleitung';

comment on column kenn_pbv_aggr.finanzierung_art is 'finanzierungsart';


select now(), 'Erzeuge Index ixkenn_pbv_aggr1';

create  index ixkenn_pbv_aggr1 on kenn_pbv_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_pbv_aggr2';

create  index ixkenn_pbv_aggr2 on kenn_pbv_aggr (bund_fachgebiet, 
bund_taetigkeit );


select now(), 'Erzeuge Index ixkenn_pbv_aggr3';

create  index ixkenn_pbv_aggr3 on kenn_pbv_aggr (geschlecht );


select now(), 'Erzeuge Index ixkenn_pbv_aggr4';

create  index ixkenn_pbv_aggr4 on kenn_pbv_aggr (buadbz );


select now(), 'Erzeuge Index ixkenn_pbv_aggr5';

create  index ixkenn_pbv_aggr5 on kenn_pbv_aggr (klr_geldgeber );


select now(), 'Erzeuge Index ixkenn_pbv_aggr6';

create  index ixkenn_pbv_aggr6 on kenn_pbv_aggr (kapitel );


select now(), 'Erzeuge Index ixkenn_pbv_aggr7';

create  index ixkenn_pbv_aggr7 on kenn_pbv_aggr (stichtag );


select now(), 'Erzeuge Index ixkenn_pbv_aggr8';

create  index ixkenn_pbv_aggr8 on kenn_pbv_aggr (zaehlung );

</#if>
delete from db_tabellen where name='kenn_pbv_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_pbv_aggr',0);

<#if !deleted_tables?seq_contains("kenn_pbv_aggr_astat") && tables?is_sequence && tables?seq_contains("kenn_pbv_aggr_astat") >


select now(), 'table kenn_pbv_aggr_astat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_pbv_aggr_astat';

create table kenn_pbv_aggr_astat(
	hs_nr INTEGER , 
jahr SMALLINT , 
geschlecht SMALLINT , 
bund_fachgebiet CHAR(10) , 
bund_taetigkeit SMALLINT , 
bund_dienstart SMALLINT , 
buadbz CHAR(5) , 
bund_geldgeber CHAR(4) , 
zaehlung CHAR(2) , 
datum date , 
befristet SMALLINT , 
staat INTEGER , 
ernennung_jahr INTEGER , 
ernennung_alter INTEGER , 
qualifizierung_art SMALLINT , 
fgr CHAR(10) , 
summe double precision 
) 
;



comment on table kenn_pbv_aggr_astat is 'Hilfstabelle Personal-Beschftigungsverhltnisse auf Basis amtl. Stat.';

comment on column kenn_pbv_aggr_astat.hs_nr is 'Hochschulnummer';

comment on column kenn_pbv_aggr_astat.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_pbv_aggr_astat.bund_taetigkeit is 'Art der Ttigkeit';

comment on column kenn_pbv_aggr_astat.bund_dienstart is 'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)';

comment on column kenn_pbv_aggr_astat.buadbz is 'Amts-Dienstbez. (Bundesschlssel)';

comment on column kenn_pbv_aggr_astat.bund_geldgeber is 'Geldgeber aus Finanzierung';

comment on column kenn_pbv_aggr_astat.zaehlung is 'Kpfe=k / VZAE zum Stichtag=v / (nur Sachsen:) VZAE im Jahr=j / Kpfe im Jahr=p';

comment on column kenn_pbv_aggr_astat.datum is 'Datum der Erzeugung';

comment on column kenn_pbv_aggr_astat.befristet is 'Befristet';

comment on column kenn_pbv_aggr_astat.staat is 'Nationalitt';

comment on column kenn_pbv_aggr_astat.ernennung_jahr is 'Jahr der Ernennung';

comment on column kenn_pbv_aggr_astat.ernennung_alter is 'Alter bei Ernennung';

comment on column kenn_pbv_aggr_astat.qualifizierung_art is 'Tenure Track oder Nachwuchsgruppenleitung';

comment on column kenn_pbv_aggr_astat.fgr is 'Fchergruppe';

comment on column kenn_pbv_aggr_astat.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_pbv_aggr_astat1';

create  index ixkenn_pbv_aggr_astat1 on kenn_pbv_aggr_astat (hs_nr );


select now(), 'Erzeuge Index ixkenn_pbv_aggr_astat2';

create  index ixkenn_pbv_aggr_astat2 on kenn_pbv_aggr_astat (jahr );


select now(), 'Erzeuge Index ixkenn_pbv_aggr_astat_3';

create  index ixkenn_pbv_aggr_astat_3 on kenn_pbv_aggr_astat (geschlecht );


select now(), 'Erzeuge Index ixkenn_pbv_aggr_astat_4';

create  index ixkenn_pbv_aggr_astat_4 on kenn_pbv_aggr_astat (buadbz );


select now(), 'Erzeuge Index ixkenn_pbv_aggr_astat_5';

create  index ixkenn_pbv_aggr_astat_5 on kenn_pbv_aggr_astat (zaehlung );

</#if>
delete from db_tabellen where name='kenn_pbv_aggr_astat';
insert into db_tabellen (name,protokollierung) values('kenn_pbv_aggr_astat',0);

<#if !deleted_tables?seq_contains("kenn_k_buadbz") && tables?is_sequence && tables?seq_contains("kenn_k_buadbz") >


select now(), 'table kenn_k_buadbz exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_k_buadbz';

create table kenn_k_buadbz(
	buadbz CHAR(10) , 
gruppe_adbz CHAR(50) , 
adbz CHAR(50) , 
druck_adbz CHAR(50) , 
gruppe CHAR(1) 
) 
;



comment on table kenn_k_buadbz is 'Amts- und Dienstbezeichnungen Bundesschlssel, vgl. http://www.destatis.de/allg/d/veroe/hoch/hochdow3.htm';

comment on column kenn_k_buadbz.buadbz is 'Schlssel ADBZ';

comment on column kenn_k_buadbz.gruppe_adbz is 'Volltext ADBZ (gruppiert)';

comment on column kenn_k_buadbz.adbz is 'Volltext ADBZ';

comment on column kenn_k_buadbz.druck_adbz is 'Drucktext ADBZ';

comment on column kenn_k_buadbz.gruppe is 'Gruppe gem. HISCOB';

</#if>
delete from db_tabellen where name='kenn_k_buadbz';
insert into db_tabellen (name,protokollierung) values('kenn_k_buadbz',0);

<#if !deleted_tables?seq_contains("kenn_lfb_fg") && tables?is_sequence && tables?seq_contains("kenn_lfb_fg") >


select now(), 'table kenn_lfb_fg exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_lfb_fg';

create table kenn_lfb_fg(
	tid SERIAL  not null, 
apnr CHAR(10) , 
parent CHAR(10) , 
drucktext CHAR(255) , 
name CHAR(255) , 
struktur_c CHAR(50) , 
gueltig_von DATE , 
gueltig_bis DATE , 
	constraint pk_kenn_lfb_fg primary key (tid)

) 
;



comment on table kenn_lfb_fg is '
        Schlssel des Stat. Bundesamtes fr Lehr-Forschungsbereiche und Fachgebiete. Die Tabelle spannt eine Hierarchie auf:
        Alle
        Fchergruppe
        Lehr- und Forschungsbreich
        Fachgebiet
        
        Im Feld "parent" steht jeweils der Schlssel des bergeordneten Elements. Im Feld "struktur_c" sehen Sie, ob es sich bei dem Datensatz um ein Fachgebiet, einen LFB oder eine Fchergruppe handelt. Die Hochschulen verwenden nur die unterste Ebene des Baums, das Fachgebiet. Die oberen Ebenen fgen wir hinzu, um es bersichtlicher zu machen.
      ';

comment on column kenn_lfb_fg.apnr is 'Schlssel Fach/LFB/Fchergruppe';

comment on column kenn_lfb_fg.parent is 'bergeordneter Schlssel';

comment on column kenn_lfb_fg.drucktext is 'Volltext Druck';

comment on column kenn_lfb_fg.name is 'Volltext Lang';

comment on column kenn_lfb_fg.struktur_c is 'Art des Schlssels (FG,LFB,FGR)';

comment on column kenn_lfb_fg.gueltig_von is 'Gltig von';

comment on column kenn_lfb_fg.gueltig_bis is 'Gltig von';

</#if>
delete from db_tabellen where name='kenn_lfb_fg';
insert into db_tabellen (name,protokollierung) values('kenn_lfb_fg',0);

<#if !deleted_tables?seq_contains("kenn_cifx") && tables?is_sequence && tables?seq_contains("kenn_cifx") >


select now(), 'table kenn_cifx exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_cifx';

create table kenn_cifx(
	tid INTEGER , 
hs INTEGER , 
key SMALLINT , 
apnr CHAR(10) , 
d_akt_von DATE , 
d_akt_bis DATE , 
kurz CHAR(10) , 
druck CHAR(100) , 
lang_1 CHAR(250) , 
lang_2 CHAR(250) , 
lang_3 CHAR(250) , 
parent CHAR(10) , 
filter CHAR(10) , 
his_system_key CHAR(10) , 
astat CHAR(10) , 
bund_apnr CHAR(10) , 
land_apnr CHAR(10) , 
sort1 INTEGER , 
sort2 INTEGER , 
sort3 INTEGER , 
sortc1 CHAR(10) , 
sortc2 CHAR(10) , 
intern_int INTEGER , 
intern_c CHAR(10) , 
sprache CHAR(3) , 
struktur_int INTEGER , 
struktur_c CHAR(50) , 
ebene INTEGER , 
gruppe CHAR(10) , 
	constraint c_kenn_cifx_tid primary key (tid)

) 
;



comment on table kenn_cifx is 'Zentrale KENN-Schlssel, bestehend aus Schlssel, astat und ggf. auch parent.';

comment on column kenn_cifx.hs is 'Hochschulschlssel (ohne Verwendung)';

comment on column kenn_cifx.key is 'hochschulischer Schlssel';

comment on column kenn_cifx.apnr is 'statistische Ausprgung';

comment on column kenn_cifx.d_akt_von is 'gltig von';

comment on column kenn_cifx.d_akt_bis is 'gltig bis';

comment on column kenn_cifx.kurz is 'Kurzbezeichnung';

comment on column kenn_cifx.druck is 'Druckbezeichnung';

comment on column kenn_cifx.lang_1 is 'Langbezeichnung1';

comment on column kenn_cifx.lang_2 is 'Langbezeichnung2';

comment on column kenn_cifx.lang_3 is 'Langbezeichnung3';

comment on column kenn_cifx.parent is 'bergeordn. Schlssel';

comment on column kenn_cifx.filter is '(ohne Verwendung)';

comment on column kenn_cifx.his_system_key is '(ohne Verwendung)';

comment on column kenn_cifx.astat is 'Statistikschlssel';

comment on column kenn_cifx.bund_apnr is 'Statistikschlssel Bund';

comment on column kenn_cifx.land_apnr is 'Statistikschlssel Land';

comment on column kenn_cifx.sort1 is 'Sortierschlssel (Ganzzahl)';

comment on column kenn_cifx.sort2 is 'Sortierschlssel (Ganzzahl) 2';

comment on column kenn_cifx.sort3 is 'Sortierschlssel (Ganzzahl) 3';

comment on column kenn_cifx.sortc1 is 'Sortierschlssel (Alphabetisch)';

comment on column kenn_cifx.sortc2 is 'Sortierschlssel (Alphabetisch) 2';

comment on column kenn_cifx.intern_int is '(ohne Verwendung)';

comment on column kenn_cifx.intern_c is '(ohne Verwendung)';

comment on column kenn_cifx.sprache is '(ohne Verwendung)';

comment on column kenn_cifx.struktur_int is '(ohne Verwendung)';

comment on column kenn_cifx.struktur_c is '(ohne Verwendung)';

comment on column kenn_cifx.ebene is 'Ebene in Hierarchie';

comment on column kenn_cifx.gruppe is 'Gruppierungsmerkmal';


select now(), 'Erzeuge Index kenn_cifx_ind';

create  unique  index kenn_cifx_ind on kenn_cifx (hs, 
apnr, 
key, 
d_akt_von, 
d_akt_bis );


select now(), 'Erzeuge Index kenn_cifx_ind2';

create  index kenn_cifx_ind2 on kenn_cifx (key );


select now(), 'Erzeuge Index kenn_cifx_ind3';

create  index kenn_cifx_ind3 on kenn_cifx (apnr );

</#if>
delete from db_tabellen where name='kenn_cifx';
insert into db_tabellen (name,protokollierung) values('kenn_cifx',0);

<#if !deleted_tables?seq_contains("kenn_status") && tables?is_sequence && tables?seq_contains("kenn_status") >


select now(), 'table kenn_status exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_status';

create table kenn_status(
	tid INTEGER  not null, 
apnr CHAR(200) , 
eintrag CHAR(200) 
) 
;



comment on table kenn_status is 'SQL-Codes fr die flexible Filterung von Einschreib- und Rckmeldekennzeichen';

</#if>
delete from db_tabellen where name='kenn_status';
insert into db_tabellen (name,protokollierung) values('kenn_status',0);

<#if !deleted_tables?seq_contains("kenn_pruefrout") && tables?is_sequence && tables?seq_contains("kenn_pruefrout") >


select now(), 'table kenn_pruefrout exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_pruefrout';

create table kenn_pruefrout(
	tid SERIAL , 
datum DATE , 
gueltig_von DATE , 
gueltig_bis DATE , 
tabelle_quelle CHAR(18) , 
tabelle_kenn CHAR(18) , 
problem CHAR(255) , 
aktion CHAR(255) , 
	constraint c_kenn_pruef_tid primary key (tid)

) 
;



comment on table kenn_pruefrout is 'Log-Tabelle fr Prfroutinen';

</#if>
delete from db_tabellen where name='kenn_pruefrout';
insert into db_tabellen (name,protokollierung) values('kenn_pruefrout',0);

<#if !deleted_tables?seq_contains("kenn_sb_astfr_lfb") && tables?is_sequence && tables?seq_contains("kenn_sb_astfr_lfb") >


select now(), 'table kenn_sb_astfr_lfb exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_sb_astfr_lfb';

create table kenn_sb_astfr_lfb(
	tid SERIAL  not null, 
astfr CHAR(10) , 
astfr_text CHAR(255) , 
sb_nr CHAR(10) , 
sb_text CHAR(255) , 
lfb_nr CHAR(10) , 
lfb_text CHAR(255) , 
	constraint c_kenn_sb_fr_lfb primary key (tid)

) 
;



comment on table kenn_sb_astfr_lfb is 'Gegenberstellung /Zusammenfhrung der amtlichen Schlssel zum Forschungs- und Lehrbereich (LuF), Studienbereich (StB) und zur Fachrichtung (FR) der Gasthrerstatistik';

comment on column kenn_sb_astfr_lfb.astfr is 'Schlssel Fachrichtung Gasthrerstat.';

comment on column kenn_sb_astfr_lfb.astfr_text is 'Volltext Fachrichtung Gasthrerstat.';

comment on column kenn_sb_astfr_lfb.sb_nr is 'Schlssel Studienbereich';

comment on column kenn_sb_astfr_lfb.sb_text is 'Volltext Studienbereich';

comment on column kenn_sb_astfr_lfb.lfb_nr is 'Schlssel Lehr- und Forschungsbereich';

comment on column kenn_sb_astfr_lfb.lfb_text is 'Volltext Lehr- und Forschungsbereich';

</#if>
delete from db_tabellen where name='kenn_sb_astfr_lfb';
insert into db_tabellen (name,protokollierung) values('kenn_sb_astfr_lfb',0);

<#if !deleted_tables?seq_contains("kenn_sichten") && tables?is_sequence && tables?seq_contains("kenn_sichten") >


select now(), 'table kenn_sichten exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_sichten';

create table kenn_sichten(
	tid SERIAL  not null, 
dimension CHAR(40)  not null, 
dimension_lang CHAR(255) , 
stichtag DATE , 
sicht_id INTEGER , 
sichtart CHAR(40) , 
sicht_name_intern CHAR(200) , 
stichtag_id INTEGER , 
	constraint c_kenn_sichten primary key (tid)

) 
;



comment on table kenn_sichten is 'Zuordnung von Default-Hierarchien zu Berichtsdimensionen,z.B. BVKR';

comment on column kenn_sichten.dimension is 'Kurzname der Dimension';

comment on column kenn_sichten.dimension_lang is 'Beschreibungstext Dimension';

comment on column kenn_sichten.stichtag is 'Stichtag alt (Datum)';

comment on column kenn_sichten.sicht_id is 'TID der Sicht (obsolet)';

comment on column kenn_sichten.sichtart is 'Art der Sicht';

comment on column kenn_sichten.sicht_name_intern is 'ID der Sicht';

comment on column kenn_sichten.stichtag_id is 'Stichtag';

</#if>
delete from db_tabellen where name='kenn_sichten';
insert into db_tabellen (name,protokollierung) values('kenn_sichten',0);

<#if !deleted_tables?seq_contains("kenn_zahl_wert") && tables?is_sequence && tables?seq_contains("kenn_zahl_wert") >


select now(), 'table kenn_zahl_wert exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_zahl_wert';

create table kenn_zahl_wert(
	tid SERIAL  not null, 
hs_nr INTEGER , 
kenn_zahl CHAR(40)  not null, 
jahr SMALLINT , 
sem SMALLINT , 
ch110_institut VARCHAR(50) , 
stugkey CHAR(20) , 
bund_fachgebiet CHAR(10) , 
titel CHAR(10) , 
wert double precision , 
wert_str varchar(255) , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
generic_dim1 VARCHAR(255) , 
generic_dim2 VARCHAR(255) , 
	constraint c_kenn_zahl_wert primary key (tid)

) 
;



comment on table kenn_zahl_wert is 'Kennzahlen aus manueller Schnittstelle';

comment on column kenn_zahl_wert.hs_nr is 'Hochschulnummer';

comment on column kenn_zahl_wert.kenn_zahl is 'Bestandsart';

comment on column kenn_zahl_wert.jahr is 'Bezugsjahr';

comment on column kenn_zahl_wert.sem is 'Bezugssemester';

comment on column kenn_zahl_wert.ch110_institut is 'Kostenstelle/Institut';

comment on column kenn_zahl_wert.stugkey is 'Studiengangschlssel KLR';

comment on column kenn_zahl_wert.bund_fachgebiet is 'Fachgebiet/Fchergruppe';

comment on column kenn_zahl_wert.titel is 'Titel/Titelgruppe';

comment on column kenn_zahl_wert.wert is 'Wert der Kennzahl';

comment on column kenn_zahl_wert.wert_str is 'Wert der Kennzahl (fr Texteingaben)';

comment on column kenn_zahl_wert.geschlecht is 'Geschlecht';

comment on column kenn_zahl_wert.ca12_staat is 'Nationalitt';

comment on column kenn_zahl_wert.generic_dim1 is 'Kategorie';

comment on column kenn_zahl_wert.generic_dim2 is 'Kategorie 2';


select now(), 'Erzeuge Index ixkennzw_aggr1';

create  index ixkennzw_aggr1 on kenn_zahl_wert (hs_nr );


select now(), 'Erzeuge Index ixkenn_zahl_wert';

create  index ixkenn_zahl_wert on kenn_zahl_wert (kenn_zahl, 
jahr, 
sem, 
stugkey, 
ch110_institut );

</#if>
delete from db_tabellen where name='kenn_zahl_wert';
insert into db_tabellen (name,protokollierung) values('kenn_zahl_wert',0);

<#if !deleted_tables?seq_contains("kenn_konto_aggr") && tables?is_sequence && tables?seq_contains("kenn_konto_aggr") >


select now(), 'table kenn_konto_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_konto_aggr';

create table kenn_konto_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
monat SMALLINT , 
kapitel CHAR(5) , 
dr CHAR(5) , 
titel CHAR(10) , 
fikrkey CHAR(12) , 
klr_geldgeber CHAR(10) , 
betragsart CHAR(1) , 
bund_fachgebiet CHAR(10) , 
datum date , 
betrag double precision , 
extkost CHAR(30) , 
extkotr CHAR(30) , 
kfmkam SMALLINT 
) 
;



comment on table kenn_konto_aggr is 'Aggregierte Haushalts-Kontendaten aus FIN';

comment on column kenn_konto_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_konto_aggr.jahr is 'Jahr der Buchung';

comment on column kenn_konto_aggr.quartal is 'Quartal der Buchung';

comment on column kenn_konto_aggr.monat is 'Monat der Buchung';

comment on column kenn_konto_aggr.kapitel is 'Kapitel';

comment on column kenn_konto_aggr.dr is 'Titelgruppe (nur gefllt wenn Konstante KENN_KAMERAL_ERWEITERT=1)';

comment on column kenn_konto_aggr.titel is 'Titel';

comment on column kenn_konto_aggr.fikrkey is 'Kostenart gem.BVKR';

comment on column kenn_konto_aggr.klr_geldgeber is 'Geldgeber nach KLR (Drittm.,Fremdkap.,HH)';

comment on column kenn_konto_aggr.betragsart is 'Art des Betrages';

comment on column kenn_konto_aggr.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_konto_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_konto_aggr.betrag is 'Betrag in EUR';

comment on column kenn_konto_aggr.extkost is 'Externe Kostenstelle';

comment on column kenn_konto_aggr.extkotr is 'Externer Produktschlssel';

comment on column kenn_konto_aggr.kfmkam is 'Kaufm./Kameral berechnet';


select now(), 'Erzeuge Index ixkenn_konto_aggr1';

create  index ixkenn_konto_aggr1 on kenn_konto_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_konto_aggr2';

create  index ixkenn_konto_aggr2 on kenn_konto_aggr (jahr, 
quartal, 
monat );


select now(), 'Erzeuge Index ixkenn_konto_aggr3';

create  index ixkenn_konto_aggr3 on kenn_konto_aggr (kapitel, 
titel );


select now(), 'Erzeuge Index ixkenn_konto_aggr4';

create  index ixkenn_konto_aggr4 on kenn_konto_aggr (fikrkey );


select now(), 'Erzeuge Index ixkenn_konto_aggr5';

create  index ixkenn_konto_aggr5 on kenn_konto_aggr (klr_geldgeber );


select now(), 'Erzeuge Index ixkenn_konto_aggr6';

create  index ixkenn_konto_aggr6 on kenn_konto_aggr (betragsart );

</#if>
delete from db_tabellen where name='kenn_konto_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_konto_aggr',0);

<#if !deleted_tables?seq_contains("kenn_drittm_aggr") && tables?is_sequence && tables?seq_contains("kenn_drittm_aggr") >


select now(), 'table kenn_drittm_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_drittm_aggr';

create table kenn_drittm_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
betragsart CHAR(1) , 
kfmkam SMALLINT , 
syf CHAR(10) , 
fgr CHAR(10) , 
datum date , 
betrag double precision 
) 
;



comment on table kenn_drittm_aggr is 'Aggregierte Drittmittel der Hs-Finanzstat.';

comment on column kenn_drittm_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_drittm_aggr.jahr is 'Jahr der Buchung';

comment on column kenn_drittm_aggr.betragsart is 'Art des Betrages';

comment on column kenn_drittm_aggr.kfmkam is 'Kaufm./Kameral berechnet';

comment on column kenn_drittm_aggr.syf is 'Syf-Code';

comment on column kenn_drittm_aggr.fgr is 'Fchergruppe';

comment on column kenn_drittm_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_drittm_aggr.betrag is 'Betrag in EUR';


select now(), 'Erzeuge Index ixkenn_drittm_aggr1';

create  index ixkenn_drittm_aggr1 on kenn_drittm_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_drittm_aggr2';

create  index ixkenn_drittm_aggr2 on kenn_drittm_aggr (jahr );


select now(), 'Erzeuge Index ixkenn_drittm_aggr3';

create  index ixkenn_drittm_aggr3 on kenn_drittm_aggr (fgr );


select now(), 'Erzeuge Index ixkenn_drittm_aggr4';

create  index ixkenn_drittm_aggr4 on kenn_drittm_aggr (betragsart, 
kfmkam );

</#if>
delete from db_tabellen where name='kenn_drittm_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_drittm_aggr',0);

<#if !deleted_tables?seq_contains("kenn_hsfinanz_stat") && tables?is_sequence && tables?seq_contains("kenn_hsfinanz_stat") >


select now(), 'table kenn_hsfinanz_stat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_hsfinanz_stat';

create table kenn_hsfinanz_stat(
	hs_nr INTEGER , 
jahr SMALLINT , 
betragsart CHAR(1) , 
kfmkam SMALLINT , 
lfb CHAR(10) , 
syf CHAR(10) , 
betrag double precision 
) 
;



comment on table kenn_hsfinanz_stat is 'Importtabelle der Hs-Finanzstat.';

comment on column kenn_hsfinanz_stat.hs_nr is 'Hochschulnummer';

comment on column kenn_hsfinanz_stat.jahr is 'Jahr der Buchung';

comment on column kenn_hsfinanz_stat.betragsart is 'Art des Betrages';

comment on column kenn_hsfinanz_stat.kfmkam is 'Kaufm./Kameral berechnet';

comment on column kenn_hsfinanz_stat.lfb is 'Lehr- und Forschungsbereich';

comment on column kenn_hsfinanz_stat.syf is 'Syf-Code';

comment on column kenn_hsfinanz_stat.betrag is 'Betrag in EUR';

</#if>
delete from db_tabellen where name='kenn_hsfinanz_stat';
insert into db_tabellen (name,protokollierung) values('kenn_hsfinanz_stat',0);

<#if !deleted_tables?seq_contains("kenn_dr") && tables?is_sequence && tables?seq_contains("kenn_dr") >


select now(), 'table kenn_dr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_dr';

create table kenn_dr(
	hs_nr INTEGER , 
jahr SMALLINT , 
kapitel CHAR(5) , 
dr CHAR(5) , 
dritt integer , 
bezeichnung CHAR(150) , 
check1 CHAR(1) , 
ktobez VARCHAR(255) 
) 
;



comment on table kenn_dr is 'Deckungsring-Bezeichnungen der Hochschule (nur gefllt wenn Konstante KENN_KAMERAL_ERWEITERT=1)';

comment on column kenn_dr.hs_nr is 'Hochschulnummer';

comment on column kenn_dr.jahr is 'Haushaltsjahr';

comment on column kenn_dr.kapitel is 'Kapitel';

comment on column kenn_dr.dr is 'Titelgruppe/Deckungsring';

comment on column kenn_dr.dritt is 'Drittmittelkonto';

comment on column kenn_dr.bezeichnung is 'Bezeichnung';

comment on column kenn_dr.ktobez is 'Kontenbezeichnung';


select now(), 'Erzeuge Index ix_kenn_drjahr';

create  index ix_kenn_drjahr on kenn_dr (jahr );

</#if>
delete from db_tabellen where name='kenn_dr';
insert into db_tabellen (name,protokollierung) values('kenn_dr',0);

<#if !deleted_tables?seq_contains("kenn_titel") && tables?is_sequence && tables?seq_contains("kenn_titel") >


select now(), 'table kenn_titel exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_titel';

create table kenn_titel(
	hs_nr INTEGER , 
jahr smallint , 
kapitel CHAR(5) , 
dr CHAR(5) , 
dr2 CHAR(5) , 
titel CHAR(10) , 
dritt integer , 
ktobez VARCHAR(255) 
) 
;



comment on table kenn_titel is 'Titel-Bezeichnungen der Hochschule (nur gefllt wenn Konstante KENN_KAMERAL_ERWEITERT=1)';

comment on column kenn_titel.hs_nr is 'Hochschulnummer';

comment on column kenn_titel.jahr is 'Jahr';

comment on column kenn_titel.kapitel is 'Kapitel';

comment on column kenn_titel.dr is 'Deckungsring';

comment on column kenn_titel.titel is 'Titel';

comment on column kenn_titel.dritt is 'Drittmittel';

comment on column kenn_titel.ktobez is 'Kontenbezeichnung';


select now(), 'Erzeuge Index ix_kenn_titjahr';

create  index ix_kenn_titjahr on kenn_titel (jahr );

</#if>
delete from db_tabellen where name='kenn_titel';
insert into db_tabellen (name,protokollierung) values('kenn_titel',0);

<#if !deleted_tables?seq_contains("kenn_katalog") && tables?is_sequence && tables?seq_contains("kenn_katalog") >


select now(), 'table kenn_katalog exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_katalog';

create table kenn_katalog(
	tid SERIAL  not null, 
id CHAR(100)  not null, 
name CHAR(255) , 
beschreibung TEXT , 
quelltabelle CHAR(255) , 
quellfeld CHAR(255) , 
bedingung TEXT , 
stichtagsart CHAR(100) , 
bezugsart CHAR(1) , 
zeitfeld CHAR(40) , 
einheit VARCHAR(255) , 
bezugszeit_wert SMALLINT , 
bezugszeit_art CHAR(1) , 
bezugszeit_diff VARCHAR(255)  default '0' , 
gueltig_von DATE , 
gueltig_bis DATE , 
	constraint c_kenn_katalog primary key (tid)

) 
;



comment on table kenn_katalog is 'Formeln fr Grunddaten und Kennzahlen';

comment on column kenn_katalog.tid is 'Tupelidentifier';

comment on column kenn_katalog.id is 'ID der Kennzahl';

comment on column kenn_katalog.name is 'Name der Kennzahl';

comment on column kenn_katalog.beschreibung is 'Beschreibung der Kennzahl';

comment on column kenn_katalog.quelltabelle is 'Datenquelle';

comment on column kenn_katalog.quellfeld is 'Feld (SQL-Ausdruck)';

comment on column kenn_katalog.bedingung is 'Where-Bedingung (SQL-Ausdruck)';

comment on column kenn_katalog.stichtagsart is 'Art des Stichtags';

comment on column kenn_katalog.bezugsart is 'Art des Zeitbezugs';

comment on column kenn_katalog.zeitfeld is 'Name des Zeitfeldes';

comment on column kenn_katalog.einheit is 'Einheit des Ergebnisses der Kennahl';

comment on column kenn_katalog.bezugszeit_wert is 'Bezugszeit Wert';

comment on column kenn_katalog.bezugszeit_art is 'Bezugszeit Art';

comment on column kenn_katalog.bezugszeit_diff is 'Bezugszeit Differenz';

comment on column kenn_katalog.gueltig_von is 'gueltig_von';

comment on column kenn_katalog.gueltig_bis is 'gueltig_bis';


select now(), 'Erzeuge Index ix_kenn_katalog';

create  unique  index ix_kenn_katalog on kenn_katalog (id );

</#if>
delete from db_tabellen where name='kenn_katalog';
insert into db_tabellen (name,protokollierung) values('kenn_katalog',0);

<#if !deleted_tables?seq_contains("kenn_katalog_rpt") && tables?is_sequence && tables?seq_contains("kenn_katalog_rpt") >


select now(), 'table kenn_katalog_rpt exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_katalog_rpt';

create table kenn_katalog_rpt(
	tid SERIAL  not null, 
katalog_id CHAR(100)  not null, 
report_id CHAR(40)  not null, 
beschreibung TEXT , 
ord_nr SMALLINT , 
gruppe_1 CHAR(40) , 
gruppe_2 CHAR(40) , 
ebene SMALLINT , 
parent_katalog_id CHAR(100) , 
active smallint  default 1 , 
uniquename VARCHAR(255) , 
	constraint c_kenn_katalog_r primary key (tid)

) 
;



comment on table kenn_katalog_rpt is 'Berichtslayouts fr Grunddaten und Kennzahlen';

comment on column kenn_katalog_rpt.tid is 'Tupelidentifier';

comment on column kenn_katalog_rpt.katalog_id is 'ID der Kennzahl';

comment on column kenn_katalog_rpt.report_id is 'ID des Reports';

comment on column kenn_katalog_rpt.beschreibung is 'Beschreibung der Kennzahl';

comment on column kenn_katalog_rpt.ord_nr is 'Reihenfolge der Kennzahl';

comment on column kenn_katalog_rpt.gruppe_1 is 'Gruppierungsebene 1 der Kennzahl';

comment on column kenn_katalog_rpt.gruppe_2 is 'Gruppierungsebene 2 der Kennzahl';

comment on column kenn_katalog_rpt.ebene is 'Ebene der Kennzahl';

comment on column kenn_katalog_rpt.parent_katalog_id is 'bergeordnete Kennzahl (ID)';

comment on column kenn_katalog_rpt.active is 'Aktiv';

comment on column kenn_katalog_rpt.uniquename is 'Schlssel der Kennzahl im Bericht';

</#if>
delete from db_tabellen where name='kenn_katalog_rpt';
insert into db_tabellen (name,protokollierung) values('kenn_katalog_rpt',0);

<#if !deleted_tables?seq_contains("kenn_katalog_grp") && tables?is_sequence && tables?seq_contains("kenn_katalog_grp") >


select now(), 'table kenn_katalog_grp exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_katalog_grp';

create table kenn_katalog_grp(
	tid SERIAL  not null, 
report_id CHAR(40)  not null, 
id CHAR(40)  not null, 
uniquename VARCHAR(255) , 
name VARCHAR(255) , 
beschreibung TEXT , 
parent_id CHAR(40) , 
ord_nr SMALLINT , 
	constraint c_kenn_katalog_grp primary key (tid)

) 
;



comment on table kenn_katalog_grp is 'Gruppierungen fr Grunddaten und Kennzahlen';

comment on column kenn_katalog_grp.tid is 'Tupelidentifier';

comment on column kenn_katalog_grp.report_id is 'ID des Reports';

comment on column kenn_katalog_grp.id is 'ID der Gruppe';

comment on column kenn_katalog_grp.uniquename is 'Schlssel der Gruppe im Bericht';

comment on column kenn_katalog_grp.name is 'Name der Gruppe';

comment on column kenn_katalog_grp.beschreibung is 'Beschreibung der Kennzahl';

comment on column kenn_katalog_grp.parent_id is 'ID der Gruppe';

comment on column kenn_katalog_grp.ord_nr is 'Reihenfolge der Kennzahl';

</#if>
delete from db_tabellen where name='kenn_katalog_grp';
insert into db_tabellen (name,protokollierung) values('kenn_katalog_grp',0);

<#if !deleted_tables?seq_contains("kenn_katalog_sub") && tables?is_sequence && tables?seq_contains("kenn_katalog_sub") >


select now(), 'table kenn_katalog_sub exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_katalog_sub';

create table kenn_katalog_sub(
	tid SERIAL  not null, 
report_id CHAR(40)  not null, 
katalog_id CHAR(100)  not null, 
sub_caption VARCHAR(255) , 
sub_key_col VARCHAR(255) , 
sub_lookup_table VARCHAR(255) , 
sub_lookup_key VARCHAR(255) , 
sub_lookup_name VARCHAR(255) , 
sub_lookup_whereclause VARCHAR(255) , 
sub_lookup_snowflake TEXT , 
ord_nr SMALLINT , 
	constraint c_kenn_katalog_sub primary key (tid)

) 
;



comment on table kenn_katalog_sub is 'Differenzierungen fr Grunddaten und Kennzahlen';

comment on column kenn_katalog_sub.tid is 'Tupelidentifier';

comment on column kenn_katalog_sub.report_id is 'ID des Reports';

comment on column kenn_katalog_sub.katalog_id is 'ID der Kennzahl';

comment on column kenn_katalog_sub.sub_caption is 'Differenzierung Name';

comment on column kenn_katalog_sub.sub_key_col is 'Differenzierung Spaltenname';

comment on column kenn_katalog_sub.sub_lookup_table is 'Differenzierung Lookup-Tabelle';

comment on column kenn_katalog_sub.sub_lookup_key is 'Differenzierung Lookup-Tabelle key-Spalte';

comment on column kenn_katalog_sub.sub_lookup_name is 'Differenzierung Lookup-Tabelle Name-Spalte';

comment on column kenn_katalog_sub.sub_lookup_whereclause is 'Differenzierung whereclause Lookup-Tabelle';

comment on column kenn_katalog_sub.sub_lookup_snowflake is 'Differenzierung weitere Lookup-Tabellen';

comment on column kenn_katalog_sub.ord_nr is 'Reihenfolge der Kennzahl';

</#if>
delete from db_tabellen where name='kenn_katalog_sub';
insert into db_tabellen (name,protokollierung) values('kenn_katalog_sub',0);

<#if !deleted_tables?seq_contains("kenn_vari") && tables?is_sequence && tables?seq_contains("kenn_vari") >


select now(), 'table kenn_vari exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_vari';

create table kenn_vari(
	tid SERIAL  not null, 
vari_nr INTEGER  not null, 
kotr_art CHAR(1)  not null, 
bezugszeit INTEGER , 
bezugsart CHAR(1)  not null, 
	constraint c_kenn_vari_r primary key (tid)

) 
;



comment on table kenn_vari is 'Verteilschritte fr Grunddaten und Kennzahlen im Bereich Kostenrechnung';

comment on column kenn_vari.tid is 'Tupelidentifier';

comment on column kenn_vari.vari_nr is 'Verteilschritt';

comment on column kenn_vari.kotr_art is 'Art d. Kostentrgers';

comment on column kenn_vari.bezugszeit is 'Bezug des Zeitraums';

comment on column kenn_vari.bezugsart is 'Bezugsart (Akad. Jahr A,Jahr J, Quartal Q, Monat M)';

</#if>
delete from db_tabellen where name='kenn_vari';
insert into db_tabellen (name,protokollierung) values('kenn_vari',0);

<#if !deleted_tables?seq_contains("kenn_lieferung") && tables?is_sequence && tables?seq_contains("kenn_lieferung") >


select now(), 'table kenn_lieferung exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_lieferung';

create table kenn_lieferung(
	hs_nr INTEGER , 
kennzahl CHAR(40) , 
datum date 
) 
;



comment on table kenn_lieferung is 'Lieferungen Datum+Hochschule';

comment on column kenn_lieferung.hs_nr is 'Hochschulnummer';

comment on column kenn_lieferung.kennzahl is 'Art der Kennzahl';

comment on column kenn_lieferung.datum is 'Datum der letzten Lieferung';

</#if>
delete from db_tabellen where name='kenn_lieferung';
insert into db_tabellen (name,protokollierung) values('kenn_lieferung',0);

<#if !deleted_tables?seq_contains("kenn_quartal_hier") && tables?is_sequence && tables?seq_contains("kenn_quartal_hier") >


select now(), 'table kenn_quartal_hier exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_quartal_hier';

create table kenn_quartal_hier(
	hs_nr INTEGER , 
quartal INTEGER , 
gruppe CHAR(12) , 
key CHAR(12) , 
ueberg CHAR(12) 
) 
;



comment on table kenn_quartal_hier is 'Zuordnung alternativer Hiearchien zu Landesschlsseln pro Quartal';

comment on column kenn_quartal_hier.hs_nr is 'Hochschulnummer';

comment on column kenn_quartal_hier.quartal is 'Quartal';

comment on column kenn_quartal_hier.gruppe is 'Kostenart/Kostenstelle';

comment on column kenn_quartal_hier.key is 'Schlssel';

comment on column kenn_quartal_hier.ueberg is 'bergeordnet lt. BVKR/Inst';


select now(), 'Erzeuge Index ix_kenn_q_hier';

create  unique  index ix_kenn_q_hier on kenn_quartal_hier (hs_nr, 
quartal, 
gruppe, 
key );

</#if>
delete from db_tabellen where name='kenn_quartal_hier';
insert into db_tabellen (name,protokollierung) values('kenn_quartal_hier',0);

<#if !deleted_tables?seq_contains("kenn_anlagen_aggr") && tables?is_sequence && tables?seq_contains("kenn_anlagen_aggr") >


select now(), 'table kenn_anlagen_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_anlagen_aggr';

create table kenn_anlagen_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
inst_ext CHAR(20) , 
bund_fachgebiet CHAR(10) , 
asp_akl varchar(6) , 
rest decimal(14,2) , 
rest_vj decimal(14,2) , 
zugang decimal(14,2) , 
abgang decimal(14,2) , 
abschr decimal(14,2) , 
histor_ahk decimal(14,2) , 
umbuch decimal(14,2) , 
zuschr decimal(14,2) , 
abschr_ges decimal(14,2) , 
datum date , 
extkotr CHAR(30) 
) 
;



comment on table kenn_anlagen_aggr is 'Aggregierte Anlagedaten aus IVS';

comment on column kenn_anlagen_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_anlagen_aggr.jahr is 'Jahr';

comment on column kenn_anlagen_aggr.inst_ext is 'Institut';

comment on column kenn_anlagen_aggr.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_anlagen_aggr.asp_akl is 'Anlagenklasse';

comment on column kenn_anlagen_aggr.rest is 'Restbuchwert';

comment on column kenn_anlagen_aggr.rest_vj is 'Restbuchwert Vorjahr';

comment on column kenn_anlagen_aggr.zugang is 'Zugnge';

comment on column kenn_anlagen_aggr.abgang is 'Abgnge';

comment on column kenn_anlagen_aggr.abschr is 'Abschreibungen';

comment on column kenn_anlagen_aggr.histor_ahk is 'Historische AHK';

comment on column kenn_anlagen_aggr.umbuch is 'Umbuchungen';

comment on column kenn_anlagen_aggr.zuschr is 'Zuschreibungen';

comment on column kenn_anlagen_aggr.abschr_ges is 'gesamte Abschreibungen';

comment on column kenn_anlagen_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_anlagen_aggr.extkotr is 'Externer Produktschlssel';


select now(), 'Erzeuge Index ixkenn_anlagen_aggr1';

create  index ixkenn_anlagen_aggr1 on kenn_anlagen_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_anlagen_aggr2';

create  index ixkenn_anlagen_aggr2 on kenn_anlagen_aggr (jahr );


select now(), 'Erzeuge Index ixkenn_anlagen_aggr3';

create  index ixkenn_anlagen_aggr3 on kenn_anlagen_aggr (inst_ext );


select now(), 'Erzeuge Index ixkenn_anlagen_aggr4';

create  index ixkenn_anlagen_aggr4 on kenn_anlagen_aggr (bund_fachgebiet );


select now(), 'Erzeuge Index ixkenn_anlagen_aggr5';

create  index ixkenn_anlagen_aggr5 on kenn_anlagen_aggr (asp_akl );

</#if>
delete from db_tabellen where name='kenn_anlagen_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_anlagen_aggr',0);

<#if !deleted_tables?seq_contains("kenn_stg_int") && tables?is_sequence && tables?seq_contains("kenn_stg_int") >


select now(), 'table kenn_stg_int exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stg_int';

create table kenn_stg_int(
	hs_nr INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
astat CHAR(10) , 
abint CHAR(10) , 
datum date 
) 
;



comment on table kenn_stg_int is 'Hochschulinterne Fcher';

comment on column kenn_stg_int.hs_nr is 'Hochschulnummer';

comment on column kenn_stg_int.apnr is 'Fach (intern)';

comment on column kenn_stg_int.druck is 'Fachbezeichnung';

comment on column kenn_stg_int.astat is 'Fach (amtlich)';

comment on column kenn_stg_int.abint is 'Abschluss (intern)';

comment on column kenn_stg_int.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ixkenn_stg_int1';

create  index ixkenn_stg_int1 on kenn_stg_int (hs_nr );


select now(), 'Erzeuge Index ixkenn_stg_int2';

create  index ixkenn_stg_int2 on kenn_stg_int (apnr );


select now(), 'Erzeuge Index ixkenn_stg_int3';

create  index ixkenn_stg_int3 on kenn_stg_int (astat );

</#if>
delete from db_tabellen where name='kenn_stg_int';
insert into db_tabellen (name,protokollierung) values('kenn_stg_int',0);

<#if !deleted_tables?seq_contains("kenn_abint") && tables?is_sequence && tables?seq_contains("kenn_abint") >


select now(), 'table kenn_abint exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_abint';

create table kenn_abint(
	hs_nr INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
astat CHAR(10) , 
datum date 
) 
;



comment on table kenn_abint is 'Hochschulinterne Abschlsse';

comment on column kenn_abint.hs_nr is 'Hochschulnummer';

comment on column kenn_abint.apnr is 'Fach (intern)';

comment on column kenn_abint.druck is 'Fachbezeichnung';

comment on column kenn_abint.astat is 'Fach (amtlich)';

comment on column kenn_abint.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ixkenn_abint1';

create  index ixkenn_abint1 on kenn_abint (hs_nr );


select now(), 'Erzeuge Index ixkenn_abint2';

create  index ixkenn_abint2 on kenn_abint (apnr );


select now(), 'Erzeuge Index ixkenn_abint3';

create  index ixkenn_abint3 on kenn_abint (astat );

</#if>
delete from db_tabellen where name='kenn_abint';
insert into db_tabellen (name,protokollierung) values('kenn_abint',0);

<#if !deleted_tables?seq_contains("kenn_hzbart_astat") && tables?is_sequence && tables?seq_contains("kenn_hzbart_astat") >


select now(), 'table kenn_hzbart_astat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_hzbart_astat';

create table kenn_hzbart_astat(
	tid SERIAL  not null, 
bland INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
gruppe INTEGER , 
gueltig_von DATE , 
gueltig_bis DATE , 
	constraint c_khzbart_astat_tid primary key (tid)

) 
;



comment on table kenn_hzbart_astat is 'Art der Hochschulzugangsber. (Amtlich)';

comment on column kenn_hzbart_astat.tid is 'Tupelidentifier';

comment on column kenn_hzbart_astat.bland is 'Bundesland';

comment on column kenn_hzbart_astat.apnr is 'Schlssel HZB-Art';

comment on column kenn_hzbart_astat.druck is 'Bezeichnung';

comment on column kenn_hzbart_astat.gruppe is 'Gruppe';

comment on column kenn_hzbart_astat.gueltig_von is 'Gltig von';

comment on column kenn_hzbart_astat.gueltig_bis is 'Gltig bis';

</#if>
delete from db_tabellen where name='kenn_hzbart_astat';
insert into db_tabellen (name,protokollierung) values('kenn_hzbart_astat',0);

<#if !deleted_tables?seq_contains("kenn_stufrm") && tables?is_sequence && tables?seq_contains("kenn_stufrm") >


select now(), 'table kenn_stufrm exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stufrm';

create table kenn_stufrm(
	tid SERIAL  not null, 
bland INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
	constraint c_kenn_stufrm_tid primary key (tid)

) 
;



comment on table kenn_stufrm is 'Studienform (Amtlich)';

comment on column kenn_stufrm.tid is 'Tupelidentifier';

comment on column kenn_stufrm.bland is 'Bundesland';

comment on column kenn_stufrm.apnr is 'Schlssel Studienform';

comment on column kenn_stufrm.druck is 'Bezeichnung';

</#if>
delete from db_tabellen where name='kenn_stufrm';
insert into db_tabellen (name,protokollierung) values('kenn_stufrm',0);

<#if !deleted_tables?seq_contains("kenn_stuart") && tables?is_sequence && tables?seq_contains("kenn_stuart") >


select now(), 'table kenn_stuart exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stuart';

create table kenn_stuart(
	tid SERIAL  not null, 
bland INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
	constraint c_kenn_stuart_tid primary key (tid)

) 
;



comment on table kenn_stuart is 'Studienart (Amtlich)';

comment on column kenn_stuart.tid is 'Tupelidentifier';

comment on column kenn_stuart.bland is 'Bundesland';

comment on column kenn_stuart.apnr is 'Schlssel Studienart';

comment on column kenn_stuart.druck is 'Bezeichnung';

</#if>
delete from db_tabellen where name='kenn_stuart';
insert into db_tabellen (name,protokollierung) values('kenn_stuart',0);

<#if !deleted_tables?seq_contains("kenn_stort") && tables?is_sequence && tables?seq_contains("kenn_stort") >


select now(), 'table kenn_stort exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stort';

create table kenn_stort(
	tid SERIAL  not null, 
bland INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
hs_nr INTEGER , 
kurz VARCHAR(254) , 
	constraint c_kenn_stort_tid primary key (tid)

) 
;



comment on table kenn_stort is 'Standorte (Amtlich)';

comment on column kenn_stort.tid is 'Tupelidentifier';

comment on column kenn_stort.bland is 'Bundesland';

comment on column kenn_stort.apnr is 'Schlssel Standort';

comment on column kenn_stort.druck is 'Bezeichnung';

comment on column kenn_stort.hs_nr is 'Hochschule';

comment on column kenn_stort.kurz is 'Hochschule';

</#if>
delete from db_tabellen where name='kenn_stort';
insert into db_tabellen (name,protokollierung) values('kenn_stort',0);

<#if !deleted_tables?seq_contains("kenn_antr_aggr") && tables?is_sequence && tables?seq_contains("kenn_antr_aggr") >


select now(), 'table kenn_antr_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_antr_aggr';

create table kenn_antr_aggr(
	hs_nr INTEGER , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
bewsem SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
antrnr SMALLINT , 
fach_sem_zahl SMALLINT , 
stort CHAR(10) , 
stg_int CHAR(10) , 
abint CHAR(10) , 
hzbart SMALLINT , 
zul_kz CHAR(1) , 
datum date , 
einschreib_kz CHAR(1) , 
summe INTEGER , 
stg_land CHAR(4) 
) 
;



comment on table kenn_antr_aggr is 'Hilfstabelle Bewerberstatistik';

comment on column kenn_antr_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_antr_aggr.fach_nr is 'Fach-Nummer';

comment on column kenn_antr_aggr.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_antr_aggr.ca12_staat is 'Nationalitt';

comment on column kenn_antr_aggr.bewsem is 'Semester';

comment on column kenn_antr_aggr.stg is 'Fach (amtlich)';

comment on column kenn_antr_aggr.abschluss is 'Abschluss (amtlich)';

comment on column kenn_antr_aggr.antrnr is 'Antragsnummer';

comment on column kenn_antr_aggr.fach_sem_zahl is 'Fachsemester';

comment on column kenn_antr_aggr.stort is 'Standort';

comment on column kenn_antr_aggr.stg_int is 'Fach (intern)';

comment on column kenn_antr_aggr.abint is 'Abschluss (intern)';

comment on column kenn_antr_aggr.hzbart is 'Art der Hochschulzugangsber.';

comment on column kenn_antr_aggr.zul_kz is 'Zugelassen';

comment on column kenn_antr_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_antr_aggr.einschreib_kz is 'Einschreibungs-Kennzeichen';

comment on column kenn_antr_aggr.summe is 'Summe';

comment on column kenn_antr_aggr.stg_land is 'Fach Land (amtlich)';


select now(), 'Erzeuge Index ixkenn_antr_aggr1';

create  index ixkenn_antr_aggr1 on kenn_antr_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_antr_aggr2';

create  index ixkenn_antr_aggr2 on kenn_antr_aggr (fach_nr );


select now(), 'Erzeuge Index ixkenn_antr_aggr3';

create  index ixkenn_antr_aggr3 on kenn_antr_aggr (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_antr_aggr4';

create  index ixkenn_antr_aggr4 on kenn_antr_aggr (bewsem );


select now(), 'Erzeuge Index ixkenn_antr_aggr5';

create  index ixkenn_antr_aggr5 on kenn_antr_aggr (abschluss );


select now(), 'Erzeuge Index ixkenn_antr_aggr6';

create  index ixkenn_antr_aggr6 on kenn_antr_aggr (hzbart );


select now(), 'Erzeuge Index ixkenn_antr_aggr7';

create  index ixkenn_antr_aggr7 on kenn_antr_aggr (antrnr );

</#if>
delete from db_tabellen where name='kenn_antr_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_antr_aggr',0);

<#if !deleted_tables?seq_contains("kenn_antr_prozess_aggr") && tables?is_sequence && tables?seq_contains("kenn_antr_prozess_aggr") >


select now(), 'table kenn_antr_prozess_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_antr_prozess_aggr';

create table kenn_antr_prozess_aggr(
	hs_nr INTEGER , 
fach_nr SMALLINT , 
geschlecht CHAR(10) , 
bewsem SMALLINT , 
stg CHAR(4) , 
stg_land CHAR(4) , 
abschlusstyp CHAR(10) , 
antrnr SMALLINT , 
fach_sem_zahl_1 CHAR(10) , 
antrag_status CHAR(10) , 
aufbaustudium CHAR(10) , 
datum date , 
summe INTEGER 
) 
;



comment on table kenn_antr_prozess_aggr is 'Hilfstabelle Bewerbungsproze-Statistik';

comment on column kenn_antr_prozess_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_antr_prozess_aggr.fach_nr is 'Fach-Nummer';

comment on column kenn_antr_prozess_aggr.geschlecht is 'Geschlecht';

comment on column kenn_antr_prozess_aggr.bewsem is 'Semester';

comment on column kenn_antr_prozess_aggr.stg is 'Fach (amtlich Bund)';

comment on column kenn_antr_prozess_aggr.stg_land is 'Fach Land (amtlich)';

comment on column kenn_antr_prozess_aggr.abschlusstyp is 'Abschlusstyp';

comment on column kenn_antr_prozess_aggr.antrnr is 'Antragsnummer';

comment on column kenn_antr_prozess_aggr.fach_sem_zahl_1 is '1. Fachsemester';

comment on column kenn_antr_prozess_aggr.antrag_status is 'Antragsstatus';

comment on column kenn_antr_prozess_aggr.aufbaustudium is 'Ist Aufbaustudium';

comment on column kenn_antr_prozess_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_antr_prozess_aggr.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr1';

create  index ixkenn_antr_prozess_aggr1 on kenn_antr_prozess_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr2';

create  index ixkenn_antr_prozess_aggr2 on kenn_antr_prozess_aggr (fach_nr );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr3';

create  index ixkenn_antr_prozess_aggr3 on kenn_antr_prozess_aggr (geschlecht );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr4';

create  index ixkenn_antr_prozess_aggr4 on kenn_antr_prozess_aggr (bewsem );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr5';

create  index ixkenn_antr_prozess_aggr5 on kenn_antr_prozess_aggr (stg, 
abschlusstyp );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr6';

create  index ixkenn_antr_prozess_aggr6 on kenn_antr_prozess_aggr (antrag_status );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr7';

create  index ixkenn_antr_prozess_aggr7 on kenn_antr_prozess_aggr (antrnr );

</#if>
delete from db_tabellen where name='kenn_antr_prozess_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_antr_prozess_aggr',0);

<#if !deleted_tables?seq_contains("kenn_stg_aggr") && tables?is_sequence && tables?seq_contains("kenn_stg_aggr") >


select now(), 'table kenn_stg_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stg_aggr';

create table kenn_stg_aggr(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_rueck_beur_ein SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
regel SMALLINT , 
hzbart SMALLINT , 
kz_rueck_beur_ein SMALLINT , 
fach_sem_zahl SMALLINT , 
hssem SMALLINT , 
kz_fach CHAR(1) , 
stort CHAR(10) , 
stuart CHAR(10) , 
stufrm CHAR(10) , 
stg_int CHAR(10) , 
abint CHAR(10) , 
hzbart_astat CHAR(10) , 
hrst CHAR(10) , 
datum date , 
summe INTEGER , 
kz_fach_int CHAR(10) , 
vertfg CHAR(10) , 
stg_land CHAR(4) 
) 
;



comment on table kenn_stg_aggr is 'Hilfstabelle Studierendenstatistik (fr Semesterberichte)';

comment on column kenn_stg_aggr.hs_nr is 'Hochschule';

comment on column kenn_stg_aggr.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_stg_aggr.fach_nr is 'Fach-Nummer';

comment on column kenn_stg_aggr.geschlecht is 'Geschlecht';

comment on column kenn_stg_aggr.ca12_staat is 'Nationalitt';

comment on column kenn_stg_aggr.sem_rueck_beur_ein is 'Semester';

comment on column kenn_stg_aggr.stg is 'Fach (amtlich)';

comment on column kenn_stg_aggr.abschluss is 'Abschluss (amtlich)';

comment on column kenn_stg_aggr.regel is 'in der RSZ';

comment on column kenn_stg_aggr.hzbart is 'Art der Hochschulzugangsber.';

comment on column kenn_stg_aggr.kz_rueck_beur_ein is 'Einschreib- oder Rckmeldestatus';

comment on column kenn_stg_aggr.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_stg_aggr.hssem is 'Anzahl Hochschulsemester';

comment on column kenn_stg_aggr.kz_fach is 'Fachkennzeichen';

comment on column kenn_stg_aggr.stort is 'Standort';

comment on column kenn_stg_aggr.stuart is 'Studienart (amtlich)';

comment on column kenn_stg_aggr.stufrm is 'Studienform (amtlich)';

comment on column kenn_stg_aggr.stg_int is 'Fach (intern)';

comment on column kenn_stg_aggr.abint is 'Abschluss (intern)';

comment on column kenn_stg_aggr.hzbart_astat is 'Hochschulzugangsberechtigung';

comment on column kenn_stg_aggr.hrst is 'Hrerstatus';

comment on column kenn_stg_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_stg_aggr.summe is 'Summe';

comment on column kenn_stg_aggr.kz_fach_int is 'Fachkennzeichen (intern)';

comment on column kenn_stg_aggr.vertfg is 'Vertiefung';

comment on column kenn_stg_aggr.stg_land is 'Fach Land (amtlich)';


select now(), 'Erzeuge Index ixkenn_stg_aggr1';

create  index ixkenn_stg_aggr1 on kenn_stg_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_stg_aggr2';

create  index ixkenn_stg_aggr2 on kenn_stg_aggr (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_stg_aggr3';

create  index ixkenn_stg_aggr3 on kenn_stg_aggr (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_stg_aggr4';

create  index ixkenn_stg_aggr4 on kenn_stg_aggr (sem_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stg_aggr5';

create  index ixkenn_stg_aggr5 on kenn_stg_aggr (abschluss );


select now(), 'Erzeuge Index ixkenn_stg_aggr6';

create  index ixkenn_stg_aggr6 on kenn_stg_aggr (hzbart_astat );


select now(), 'Erzeuge Index ixkenn_stg_aggr7';

create  index ixkenn_stg_aggr7 on kenn_stg_aggr (kz_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stg_aggr8';

create  index ixkenn_stg_aggr8 on kenn_stg_aggr (stg );

</#if>
delete from db_tabellen where name='kenn_stg_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_stg_aggr',0);

<#if !deleted_tables?seq_contains("kenn_kzfach_int") && tables?is_sequence && tables?seq_contains("kenn_kzfach_int") >


select now(), 'table kenn_kzfach_int exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_kzfach_int';

create table kenn_kzfach_int(
	hs_nr INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
datum date 
) 
;



comment on table kenn_kzfach_int is 'Hochschulinterne Fachkennzeichen';

comment on column kenn_kzfach_int.hs_nr is 'Hochschulnummer';

comment on column kenn_kzfach_int.apnr is 'Fachkennzeichen (intern)';

comment on column kenn_kzfach_int.druck is 'Fachkennzeichenbezeichnung';

comment on column kenn_kzfach_int.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ixkenn_kzfach_int1';

create  index ixkenn_kzfach_int1 on kenn_kzfach_int (hs_nr );


select now(), 'Erzeuge Index ixkenn_kzfach_int2';

create  index ixkenn_kzfach_int2 on kenn_kzfach_int (apnr );

</#if>
delete from db_tabellen where name='kenn_kzfach_int';
insert into db_tabellen (name,protokollierung) values('kenn_kzfach_int',0);

<#if !deleted_tables?seq_contains("kenn_vert_int") && tables?is_sequence && tables?seq_contains("kenn_vert_int") >


select now(), 'table kenn_vert_int exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_vert_int';

create table kenn_vert_int(
	hs_nr INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
datum date 
) 
;



comment on table kenn_vert_int is 'Hochschulinterne Vertiefungen';

comment on column kenn_vert_int.hs_nr is 'Hochschulnummer';

comment on column kenn_vert_int.apnr is 'Vertiefungen (intern)';

comment on column kenn_vert_int.druck is 'Vertiefungenbezeichnung';

comment on column kenn_vert_int.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ixkenn_vert_int1';

create  index ixkenn_vert_int1 on kenn_vert_int (hs_nr );


select now(), 'Erzeuge Index ixkenn_vert_int2';

create  index ixkenn_vert_int2 on kenn_vert_int (apnr );

</#if>
delete from db_tabellen where name='kenn_vert_int';
insert into db_tabellen (name,protokollierung) values('kenn_vert_int',0);

<#if !deleted_tables?seq_contains("kenn_abschl_sbereich") && tables?is_sequence && tables?seq_contains("kenn_abschl_sbereich") >


select now(), 'table kenn_abschl_sbereich exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_abschl_sbereich';

create table kenn_abschl_sbereich(
	tid SERIAL  not null, 
abschluss CHAR(10) , 
sbereich VARCHAR(255) , 
	constraint c_kenn_abschl_sbereich primary key (tid)

) 
;



comment on column kenn_abschl_sbereich.abschluss is 'Abschluss (intern)';

comment on column kenn_abschl_sbereich.sbereich is 'Abschlussgruppe';

</#if>
delete from db_tabellen where name='kenn_abschl_sbereich';
insert into db_tabellen (name,protokollierung) values('kenn_abschl_sbereich',0);

<#if !deleted_tables?seq_contains("kenn_extkotr_stg") && tables?is_sequence && tables?seq_contains("kenn_extkotr_stg") >


select now(), 'table kenn_extkotr_stg exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_extkotr_stg';

create table kenn_extkotr_stg(
	tid SERIAL  not null, 
extkotr CHAR(30) , 
stg CHAR(10) , 
stg_astat CHAR(10) , 
stg_str CHAR(255) , 
	constraint c_kenn_extkotr_stg primary key (tid)

) 
;



comment on column kenn_extkotr_stg.extkotr is 'Externer Kostentrger';

comment on column kenn_extkotr_stg.stg is 'Fach (intern) Schlssel';

comment on column kenn_extkotr_stg.stg_astat is 'Fach (amtlich) Bundesschlssel';

comment on column kenn_extkotr_stg.stg_str is 'Fach (intern) Name';


select now(), 'Erzeuge Index ixkenn_extkotr_stg1';

create  unique  index ixkenn_extkotr_stg1 on kenn_extkotr_stg (stg );

</#if>
delete from db_tabellen where name='kenn_extkotr_stg';
insert into db_tabellen (name,protokollierung) values('kenn_extkotr_stg',0);

<#if !deleted_tables?seq_contains("kenn_proj_gege") && tables?is_sequence && tables?seq_contains("kenn_proj_gege") >


select now(), 'table kenn_proj_gege exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_proj_gege';

create table kenn_proj_gege(
	hs_nr INTEGER , 
projnr CHAR(10) , 
klr_geldgeber CHAR(10) , 
k_extkotr CHAR(10) , 
jahr INTEGER 
) 
;



comment on table kenn_proj_gege is 'Kostentrger zu Geldgeber';

comment on column kenn_proj_gege.hs_nr is 'Hochschulnummer';

comment on column kenn_proj_gege.projnr is 'Projekt Schlssel';

comment on column kenn_proj_gege.klr_geldgeber is 'KLR-Geldgeber';

comment on column kenn_proj_gege.k_extkotr is 'externer Kostentrger';


select now(), 'Erzeuge Index ix_kenn_proj_gege';

create  index ix_kenn_proj_gege on kenn_proj_gege (hs_nr, 
projnr );


select now(), 'Erzeuge Index ix_kenn_proj_gex';

create  index ix_kenn_proj_gex on kenn_proj_gege (k_extkotr );

</#if>
delete from db_tabellen where name='kenn_proj_gege';
insert into db_tabellen (name,protokollierung) values('kenn_proj_gege',0);

<#if !deleted_tables?seq_contains("kenn_pbv_klr") && tables?is_sequence && tables?seq_contains("kenn_pbv_klr") >


select now(), 'table kenn_pbv_klr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_pbv_klr';

create table kenn_pbv_klr(
	hs_nr INTEGER , 
jahr SMALLINT , 
monat SMALLINT , 
kapitel CHAR(5) , 
titel CHAR(10) , 
kostenart CHAR(12) , 
kalk_kostenart CHAR(12) , 
bund_dienstart SMALLINT , 
buadbz CHAR(10) , 
klr_geldgeber CHAR(10) , 
extkost CHAR(30) , 
extkotr CHAR(30) , 
stichtag DATE , 
zaehlung CHAR(2) , 
datum date , 
summe double precision 
) 
;



comment on table kenn_pbv_klr is 'Personalstammstze aus der KLR';

comment on column kenn_pbv_klr.hs_nr is 'Hochschulnummer';

comment on column kenn_pbv_klr.kapitel is 'Kapitel aus Finanzierung';

comment on column kenn_pbv_klr.bund_dienstart is 'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)';

comment on column kenn_pbv_klr.buadbz is 'Amts-Dienstbez. (Bundesschlssel)';

comment on column kenn_pbv_klr.klr_geldgeber is 'Geldgeber aus Finanzierung';

comment on column kenn_pbv_klr.extkost is 'Externe Kostenstelle';

comment on column kenn_pbv_klr.extkotr is 'Externer Produktschlssel';

comment on column kenn_pbv_klr.stichtag is 'Datum der Gltigkeit des Besch.-Verh.';

comment on column kenn_pbv_klr.zaehlung is 'Kpfe=k / VZAE=v';

comment on column kenn_pbv_klr.datum is 'Datum der Erzeugung';

comment on column kenn_pbv_klr.summe is 'Summe';


select now(), 'Erzeuge Index kenn_imp_pbv_id';

create  index kenn_imp_pbv_id on kenn_pbv_klr (zaehlung, 
monat, 
jahr, 
klr_geldgeber );

</#if>
delete from db_tabellen where name='kenn_pbv_klr';
insert into db_tabellen (name,protokollierung) values('kenn_pbv_klr',0);

<#if !deleted_tables?seq_contains("kenn_auslastung") && tables?is_sequence && tables?seq_contains("kenn_auslastung") >


select now(), 'table kenn_auslastung exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_auslastung';

create table kenn_auslastung(
	hs_nr INTEGER , 
lehreinheit CHAR(10) , 
k_extkotr CHAR(10) , 
sem INTEGER , 
datum DATE , 
ffidrgf2 double precision , 
sws_lehrang double precision , 
sws_lehrnf double precision , 
sws_lehrnf_eigen double precision , 
sws_lehrnf_fremd double precision , 
sws_lehrnf_ea double precision , 
dlk double precision 
) 
;



comment on table kenn_auslastung is 'Lehrnachfrage/angebot gem. KapVo (nur Sachsen)';

comment on column kenn_auslastung.hs_nr is 'Hochschulnummer';

comment on column kenn_auslastung.lehreinheit is 'Lehreinheit';

comment on column kenn_auslastung.k_extkotr is 'Externer Produktschlssel';

comment on column kenn_auslastung.sem is 'Semester';

comment on column kenn_auslastung.datum is 'Berechnungsdatum';

comment on column kenn_auslastung.ffidrgf2 is 'VZ in der RSZ';

comment on column kenn_auslastung.sws_lehrang is 'SWS Angebot';

comment on column kenn_auslastung.sws_lehrnf is 'SWS Nachfrage';

comment on column kenn_auslastung.sws_lehrnf_eigen is 'SWS Nachfrage (eigene Studiengnge)';

comment on column kenn_auslastung.sws_lehrnf_fremd is 'SWS Nachfrage (Dienstleistung fr andere Studiengnge)';

comment on column kenn_auslastung.sws_lehrnf_ea is 'SWS Nachfrage eigener Studiengnge an alle Lehreinheiten';

comment on column kenn_auslastung.dlk is 'Dienstleistungskoeffizient';

</#if>
delete from db_tabellen where name='kenn_auslastung';
insert into db_tabellen (name,protokollierung) values('kenn_auslastung',0);

<#if !deleted_tables?seq_contains("kenn_fibu_guv") && tables?is_sequence && tables?seq_contains("kenn_fibu_guv") >


select now(), 'table kenn_fibu_guv exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_fibu_guv';

create table kenn_fibu_guv(
	hs_nr INTEGER , 
jahr SMALLINT , 
name VARCHAR(255) , 
hierarchie_ebene SMALLINT , 
betrag double precision , 
betragvorjahr double precision , 
unterstrich SMALLINT  default 0 , 
sortnr INTEGER  default 0 , 
sortnr2 INTEGER  default 0 , 
datum DATE 
) 
;



comment on column kenn_fibu_guv.hs_nr is 'Hochschulnummer';

comment on column kenn_fibu_guv.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index kenn_fibu_guv1';

create  index kenn_fibu_guv1 on kenn_fibu_guv (hs_nr );

</#if>
delete from db_tabellen where name='kenn_fibu_guv';
insert into db_tabellen (name,protokollierung) values('kenn_fibu_guv',0);

<#if !deleted_tables?seq_contains("kenn_fibu_bilanz") && tables?is_sequence && tables?seq_contains("kenn_fibu_bilanz") >


select now(), 'table kenn_fibu_bilanz exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_fibu_bilanz';

create table kenn_fibu_bilanz(
	hs_nr INTEGER , 
jahr SMALLINT , 
name VARCHAR(255) , 
hierarchie_ebene SMALLINT , 
betrag double precision , 
betragvorjahr double precision , 
unterstrich SMALLINT  default 0 , 
sortnr INTEGER  default 0 , 
sortnr2 INTEGER  default 0 , 
datum DATE 
) 
;



comment on column kenn_fibu_bilanz.hs_nr is 'Hochschulnummer';

comment on column kenn_fibu_bilanz.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index kenn_fibu_bil1';

create  index kenn_fibu_bil1 on kenn_fibu_bilanz (hs_nr );

</#if>
delete from db_tabellen where name='kenn_fibu_bilanz';
insert into db_tabellen (name,protokollierung) values('kenn_fibu_bilanz',0);

<#if !deleted_tables?seq_contains("kenn_fibu_quartal") && tables?is_sequence && tables?seq_contains("kenn_fibu_quartal") >


select now(), 'table kenn_fibu_quartal exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_fibu_quartal';

create table kenn_fibu_quartal(
	hs_nr INTEGER , 
id VARCHAR(50)  default '0' , 
jahr SMALLINT , 
zeile VARCHAR(255) , 
kontengruppe VARCHAR(255) , 
name VARCHAR(255) , 
hierarchie_ebene SMALLINT , 
plan double precision , 
q1 double precision , 
q2 double precision , 
q3 double precision , 
q4 double precision , 
steuerungvorschau double precision , 
steuerungvorjahr double precision , 
erlaeuterung TEXT , 
sortnr INTEGER  default 0 , 
sortnr2 INTEGER  default 0 , 
datum DATE , 
zeilennr INTEGER , 
vorjahr_q1 double precision , 
vorjahr_q2 double precision , 
vorjahr_q3 double precision , 
vorjahr_q4 double precision , 
quartal SMALLINT 
) 
;



comment on column kenn_fibu_quartal.hs_nr is 'Hochschulnummer';

comment on column kenn_fibu_quartal.id is 'ID fr HIS-FIBU';

comment on column kenn_fibu_quartal.datum is 'Datum der Erzeugung';

comment on column kenn_fibu_quartal.quartal is 'Quartal der Lieferung';


select now(), 'Erzeuge Index kenn_fibu_quar1';

create  index kenn_fibu_quar1 on kenn_fibu_quartal (hs_nr );

</#if>
delete from db_tabellen where name='kenn_fibu_quartal';
insert into db_tabellen (name,protokollierung) values('kenn_fibu_quartal',0);

<#if !deleted_tables?seq_contains("kenn_fibu_wiplan") && tables?is_sequence && tables?seq_contains("kenn_fibu_wiplan") >


select now(), 'table kenn_fibu_wiplan exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_fibu_wiplan';

create table kenn_fibu_wiplan(
	hs_nr INTEGER , 
id VARCHAR(50)  not null, 
jahr SMALLINT , 
kuerzel VARCHAR(255) , 
kontengruppe VARCHAR(255) , 
zweckbestimmung VARCHAR(255) , 
ist double precision , 
sollplus1 double precision , 
sollplus2 double precision , 
sollplus3 double precision , 
sortnr INTEGER  default 0 , 
datum DATE , 
	constraint id_kenn_fibu_wipla2 primary key (hs_nr, id)

) 
;



comment on column kenn_fibu_wiplan.hs_nr is 'Hochschulnummer';

comment on column kenn_fibu_wiplan.id is 'eindeutig ID zum Hinterlegen von manuell zu erfassenden Werten';

comment on column kenn_fibu_wiplan.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index kenn_fibu_wipl1';

create  index kenn_fibu_wipl1 on kenn_fibu_wiplan (hs_nr );

</#if>
delete from db_tabellen where name='kenn_fibu_wiplan';
insert into db_tabellen (name,protokollierung) values('kenn_fibu_wiplan',0);

<#if !deleted_tables?seq_contains("kenn_kam_quartal") && tables?is_sequence && tables?seq_contains("kenn_kam_quartal") >


select now(), 'table kenn_kam_quartal exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_kam_quartal';

create table kenn_kam_quartal(
	hs_nr INTEGER , 
jahr SMALLINT , 
dr VARCHAR(50) , 
titel CHAR(10) , 
soll double precision  default 0 , 
reste double precision  default 0 , 
haushaltsvorgriff double precision  default 0 , 
istq1 double precision  default 0 , 
istq2 double precision  default 0 , 
istq3 double precision  default 0 , 
istq4 double precision  default 0 , 
istvorjahr_q1 double precision  default 0 , 
istvorjahr_q2 double precision  default 0 , 
istvorjahr_q3 double precision  default 0 , 
istvorjahr_q4 double precision  default 0 , 
vorschau double precision  default 0 , 
erlaeuterung TEXT , 
datum DATE , 
quartal SMALLINT 
) 
;



comment on column kenn_kam_quartal.hs_nr is 'Hochschulnummer';

comment on column kenn_kam_quartal.datum is 'Datum der Erzeugung';

comment on column kenn_kam_quartal.quartal is 'Quartal der Lieferung';


select now(), 'Erzeuge Index ix_kenn_kam_quartal1';

create  index ix_kenn_kam_quartal1 on kenn_kam_quartal (hs_nr, 
jahr );


select now(), 'Erzeuge Index ix_kenn_kam_quartal2';

create  index ix_kenn_kam_quartal2 on kenn_kam_quartal (quartal );

</#if>
delete from db_tabellen where name='kenn_kam_quartal';
insert into db_tabellen (name,protokollierung) values('kenn_kam_quartal',0);

<#if !deleted_tables?seq_contains("kenn_kam_ja") && tables?is_sequence && tables?seq_contains("kenn_kam_ja") >


select now(), 'table kenn_kam_ja exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_kam_ja';

create table kenn_kam_ja(
	hs_nr INTEGER , 
jahr SMALLINT , 
dr VARCHAR(50) , 
titel CHAR(10) , 
soll double precision  default 0 , 
reste double precision  default 0 , 
haushaltsvorgriff double precision  default 0 , 
ist double precision  default 0 , 
erlaeuterung TEXT , 
datum DATE 
) 
;



comment on column kenn_kam_ja.hs_nr is 'Hochschulnummer';

comment on column kenn_kam_ja.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ix_kenn_kam_ja1';

create  index ix_kenn_kam_ja1 on kenn_kam_ja (hs_nr, 
jahr );

</#if>
delete from db_tabellen where name='kenn_kam_ja';
insert into db_tabellen (name,protokollierung) values('kenn_kam_ja',0);

<#if !deleted_tables?seq_contains("kenn_stupl") && tables?is_sequence && tables?seq_contains("kenn_stupl") >


select now(), 'table kenn_stupl exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stupl';

create table kenn_stupl(
	hs_nr INTEGER  not null, 
stug_key CHAR(12) , 
stug_rstuz SMALLINT , 
jahr INTEGER , 
sem INTEGER  not null, 
extkotr CHAR(30) , 
datum DATE , 
summe INTEGER 
) 
;



comment on table kenn_stupl is 'Studienplaetze je Studiengang';

comment on column kenn_stupl.hs_nr is 'Hochschulnummer';

comment on column kenn_stupl.extkotr is 'Externer Produktschlssel';

comment on column kenn_stupl.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ix_kenn_stupl';

create  index ix_kenn_stupl on kenn_stupl (stug_key, 
extkotr, 
sem );


select now(), 'Erzeuge Index ix_kenn_stupl2';

create  index ix_kenn_stupl2 on kenn_stupl (hs_nr );

</#if>
delete from db_tabellen where name='kenn_stupl';
insert into db_tabellen (name,protokollierung) values('kenn_stupl',0);

<#if !deleted_tables?seq_contains("kenn_zulzahl_id") && tables?is_sequence && tables?seq_contains("kenn_zulzahl_id") >


select now(), 'table kenn_zulzahl_id exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_zulzahl_id';

create table kenn_zulzahl_id(
	id SERIAL  not null, 
name VARCHAR(255) , 
beschreibung VARCHAR(255) , 
fach VARCHAR(255) , 
abschluss VARCHAR(255) , 
hs_nr INTEGER , 
stort CHAR(10) , 
abgrp CHAR(10) , 
erzeugt_am DATE  default today(), 
geaendert_am DATE , 
geaendert_von_id INTEGER , 
erzeugt_von_id INTEGER , 
redaktionsstatus INTEGER , 
	constraint pk_kenn_zulzahl_id_id primary key (id)

) 
;



comment on table kenn_zulzahl_id is 'Nur BaWue: ID fr Zulassungszahlen mit Namen und Kurzbeschreibung';

comment on column kenn_zulzahl_id.id is 'Laufnummer';

comment on column kenn_zulzahl_id.name is 'Name';

comment on column kenn_zulzahl_id.fach is 'Studienfach';

comment on column kenn_zulzahl_id.abschluss is 'Abschluss';

comment on column kenn_zulzahl_id.hs_nr is 'Hochschule';

comment on column kenn_zulzahl_id.stort is 'Standort';

comment on column kenn_zulzahl_id.abgrp is 'Abschlussgruppe';

comment on column kenn_zulzahl_id.erzeugt_am is 'Datum der Erzeugung des Datensatzes';

comment on column kenn_zulzahl_id.geaendert_am is 'Datum der letzten nderung des Datensatzes';

comment on column kenn_zulzahl_id.geaendert_von_id is 'UserID des ndernden';

comment on column kenn_zulzahl_id.erzeugt_von_id is 'UserID des Erzeugers';

comment on column kenn_zulzahl_id.redaktionsstatus is 'Redaktionsstatus';


select now(), 'Erzeuge Index ix_kenn_zulzahl_id1';

create  index ix_kenn_zulzahl_id1 on kenn_zulzahl_id (hs_nr );

</#if>
delete from db_tabellen where name='kenn_zulzahl_id';
insert into db_tabellen (name,protokollierung) values('kenn_zulzahl_id',0);

<#if !deleted_tables?seq_contains("kenn_zulzahl_sem") && tables?is_sequence && tables?seq_contains("kenn_zulzahl_sem") >


select now(), 'table kenn_zulzahl_sem exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_zulzahl_sem';

create table kenn_zulzahl_sem(
	tid SERIAL  not null, 
zulzahl_id INTEGER  not null, 
semester INTEGER , 
zul_beschr SMALLINT , 
zulzahl INTEGER , 
	constraint pk_kenn_zulzahl_sem primary key (tid)

) 
;



comment on table kenn_zulzahl_sem is 'Nur BaWue: Zulassungszahlen pro Semester';

comment on column kenn_zulzahl_sem.tid is 'Laufnummer';

comment on column kenn_zulzahl_sem.zulzahl_id is 'Zulassungszahl-ID';

comment on column kenn_zulzahl_sem.semester is 'Semester';

comment on column kenn_zulzahl_sem.zul_beschr is 'Zulassungsbeschrnkt?';

comment on column kenn_zulzahl_sem.zulzahl is 'Zulassungszahl';


select now(), 'Erzeuge Index ix_kenn_zulzahl_stupl1';

create  index ix_kenn_zulzahl_stupl1 on kenn_zulzahl_sem (zulzahl_id, 
semester );

</#if>
delete from db_tabellen where name='kenn_zulzahl_sem';
insert into db_tabellen (name,protokollierung) values('kenn_zulzahl_sem',0);

<#if !deleted_tables?seq_contains("kenn_zulzahl2int") && tables?is_sequence && tables?seq_contains("kenn_zulzahl2int") >


select now(), 'table kenn_zulzahl2int exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_zulzahl2int';

create table kenn_zulzahl2int(
	tid SERIAL  not null, 
zulzahl_id INTEGER , 
stg_int CHAR(10) , 
abschluss_int CHAR(10) , 
kz_fach_int CHAR(10) , 
vertfg CHAR(10) , 
stg_astat CHAR(10) , 
abschluss_astat CHAR(10) , 
hs_nr INTEGER , 
stort CHAR(10) , 
erzeugt_am DATE  default today(), 
geaendert_am DATE , 
geaendert_von_id INTEGER , 
erzeugt_von_id INTEGER , 
	constraint pk_kenn_zulzahl2int_tid primary key (tid)

) 
;



comment on table kenn_zulzahl2int is 'Nur BaWue: Zuordnung der Zulassungszahl-ID zum internen Studiengang';

comment on column kenn_zulzahl2int.tid is 'Laufnummer';

comment on column kenn_zulzahl2int.zulzahl_id is 'Studiengang-ID';

comment on column kenn_zulzahl2int.stg_int is 'Fach (intern)';

comment on column kenn_zulzahl2int.abschluss_int is 'Abschluss (intern)';

comment on column kenn_zulzahl2int.kz_fach_int is 'Fachkennzeichen (intern)';

comment on column kenn_zulzahl2int.vertfg is 'Vertiefung';

comment on column kenn_zulzahl2int.stg_astat is 'Fach (amtl.)';

comment on column kenn_zulzahl2int.abschluss_astat is 'Abschluss (amtl.)';

comment on column kenn_zulzahl2int.hs_nr is 'Hochschule';

comment on column kenn_zulzahl2int.stort is 'Standort';

comment on column kenn_zulzahl2int.erzeugt_am is 'Datum der Erzeugung des Datensatzes';

comment on column kenn_zulzahl2int.geaendert_am is 'Datum der letzten nderung des Datensatzes';

comment on column kenn_zulzahl2int.geaendert_von_id is 'UserID des ndernden';

comment on column kenn_zulzahl2int.erzeugt_von_id is 'UserID des Erzeugers';


select now(), 'Erzeuge Index ix_zulzahl2int2';

create  index ix_zulzahl2int2 on kenn_zulzahl2int (zulzahl_id );


select now(), 'Erzeuge Index ix_zulzahl2int3';

create  index ix_zulzahl2int3 on kenn_zulzahl2int (hs_nr );

</#if>
delete from db_tabellen where name='kenn_zulzahl2int';
insert into db_tabellen (name,protokollierung) values('kenn_zulzahl2int',0);

<#if !deleted_tables?seq_contains("kenn_vtbu_qp_aggr") && tables?is_sequence && tables?seq_contains("kenn_vtbu_qp_aggr") >


select now(), 'table kenn_vtbu_qp_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_vtbu_qp_aggr';

create table kenn_vtbu_qp_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
monat SMALLINT , 
quell_ch110_inst VARCHAR(50) , 
ziel_projnr CHAR(10) , 
kokl CHAR(1) , 
datum date , 
betrag double precision 
) 
;



comment on table kenn_vtbu_qp_aggr is 'Hilfstabelle Verteilbuchungen Querschnittsprodukte aus HISCOB';

comment on column kenn_vtbu_qp_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_vtbu_qp_aggr.jahr is 'Jahr';

comment on column kenn_vtbu_qp_aggr.quartal is 'Quartal';

comment on column kenn_vtbu_qp_aggr.monat is 'Monat';

comment on column kenn_vtbu_qp_aggr.quell_ch110_inst is 'Abgebende Kostenstelle';

comment on column kenn_vtbu_qp_aggr.ziel_projnr is 'Projektnr. (ext. Kostentrger)';

comment on column kenn_vtbu_qp_aggr.kokl is 'Kontenklasse';

comment on column kenn_vtbu_qp_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_vtbu_qp_aggr.betrag is 'Betrag';


select now(), 'Erzeuge Index ixkenn_vtbu_qpaggr1';

create  index ixkenn_vtbu_qpaggr1 on kenn_vtbu_qp_aggr (jahr, 
monat );


select now(), 'Erzeuge Index kenn_vtbu_qpaggr3';

create  index kenn_vtbu_qpaggr3 on kenn_vtbu_qp_aggr (quell_ch110_inst );


select now(), 'Erzeuge Index kenn_vtbu_qpaggr4';

create  index kenn_vtbu_qpaggr4 on kenn_vtbu_qp_aggr (ziel_projnr );


select now(), 'Erzeuge Index kenn_vtbu_qpaggr6';

create  index kenn_vtbu_qpaggr6 on kenn_vtbu_qp_aggr (hs_nr );

</#if>
delete from db_tabellen where name='kenn_vtbu_qp_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_vtbu_qp_aggr',0);

<#if !deleted_tables?seq_contains("kenn_stg_cube") && tables?is_sequence && tables?seq_contains("kenn_stg_cube") >


select now(), 'table kenn_stg_cube exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stg_cube';

create table kenn_stg_cube(
	hs_nr INTEGER , 
ca12_staat INTEGER , 
geschlecht INTEGER , 
hzbart INTEGER , 
studiengang_nr INTEGER , 
fach_nr INTEGER , 
fach_sem_zahl INTEGER , 
sem_rueck_beur_ein INTEGER , 
kz_rueck_beur_ein INTEGER , 
hssem INTEGER , 
stufrm_astat INTEGER , 
stg_astat INTEGER , 
kz_fach_astat INTEGER , 
abschluss_astat INTEGER , 
rsz INTEGER , 
extkotr INTEGER , 
summe decimal(16,2) 
) 
;



comment on table kenn_stg_cube is 'Cube-Tabelle Belegungen von Studiengngen';

comment on column kenn_stg_cube.hs_nr is 'Hochschulen Namen';

comment on column kenn_stg_cube.ca12_staat is 'Staatsangehrigkeit (weltweit)';

comment on column kenn_stg_cube.geschlecht is 'Geschlecht';

comment on column kenn_stg_cube.hzbart is 'Hochschulzugangsberechtigung';

comment on column kenn_stg_cube.studiengang_nr is 'Studiengang Nr.';

comment on column kenn_stg_cube.fach_nr is 'Studienfachnummer';

comment on column kenn_stg_cube.fach_sem_zahl is 'Studiensem. nach Fachsem.';

comment on column kenn_stg_cube.sem_rueck_beur_ein is 'Zeitpunkt semesterweise';

comment on column kenn_stg_cube.kz_rueck_beur_ein is 'Einschreib/Rckmeldestatus';

comment on column kenn_stg_cube.hssem is 'Studiensem. nach Hochschulsem.';

comment on column kenn_stg_cube.stufrm_astat is 'Studienform (amtlich)';

comment on column kenn_stg_cube.stg_astat is 'Studienfach (amtlich)';

comment on column kenn_stg_cube.kz_fach_astat is 'Fachkennzeichen (amtlich)';

comment on column kenn_stg_cube.abschluss_astat is 'Studienabschluss (amtlich)';

comment on column kenn_stg_cube.rsz is 'Regelstudienzeit';

comment on column kenn_stg_cube.extkotr is 'Ext. Kostentrger';

comment on column kenn_stg_cube.summe is 'Summe';

</#if>
delete from db_tabellen where name='kenn_stg_cube';
insert into db_tabellen (name,protokollierung) values('kenn_stg_cube',0);

<#if !deleted_tables?seq_contains("kenn_sember_stg_cube") && tables?is_sequence && tables?seq_contains("kenn_sember_stg_cube") >


select now(), 'table kenn_sember_stg_cube exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_sember_stg_cube';

create table kenn_sember_stg_cube(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
semester INTEGER , 
fachsem INTEGER , 
geschlecht INTEGER , 
hzbart INTEGER , 
rsz INTEGER , 
abschluss CHAR(20) , 
abschluss_astat CHAR(10) , 
stg_astat CHAR(20) , 
stg CHAR(20) , 
ca12_staat INTEGER , 
hssem INTEGER , 
kz_fach CHAR(10) , 
kz_rueck_beur_ein SMALLINT , 
hzbart_astat CHAR(10) , 
stort CHAR(10) , 
stuart CHAR(10) , 
stufrm CHAR(10) , 
hrst CHAR(10) , 
summe INTEGER 
) 
;



comment on table kenn_sember_stg_cube is 'Semesterberichte Studierende';

comment on column kenn_sember_stg_cube.hs_nr is 'Hochschule';

comment on column kenn_sember_stg_cube.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_sember_stg_cube.fach_nr is 'Fach-Nummer';

comment on column kenn_sember_stg_cube.semester is 'Semester';

comment on column kenn_sember_stg_cube.fachsem is 'Anzahl Fachsemester';

comment on column kenn_sember_stg_cube.geschlecht is 'Geschlecht';

comment on column kenn_sember_stg_cube.hzbart is 'Gruppe der HZB';

comment on column kenn_sember_stg_cube.rsz is 'in der RSZ';

comment on column kenn_sember_stg_cube.abschluss is 'Abschluss';

comment on column kenn_sember_stg_cube.abschluss_astat is 'Abschluss (amtlich)';

comment on column kenn_sember_stg_cube.stg_astat is 'Fach (amtlich)';

comment on column kenn_sember_stg_cube.stg is 'Hochschule und Fach (intern)';

comment on column kenn_sember_stg_cube.ca12_staat is 'Staatsangehrigkeit';

comment on column kenn_sember_stg_cube.hssem is 'Anzahl Hochschulsemester';

comment on column kenn_sember_stg_cube.kz_fach is 'Fachkennzeichen (amtlich)';

comment on column kenn_sember_stg_cube.kz_rueck_beur_ein is 'Status';

comment on column kenn_sember_stg_cube.hzbart_astat is 'Art der HZB (amtlich)';

comment on column kenn_sember_stg_cube.stort is 'Standort';

comment on column kenn_sember_stg_cube.stuart is 'Studienart (amtlich)';

comment on column kenn_sember_stg_cube.stufrm is 'Studienform (amtlich)';

comment on column kenn_sember_stg_cube.hrst is 'Hrerstatus (amtlich)';

comment on column kenn_sember_stg_cube.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_stgsem_cube1';

create  index ixkenn_stgsem_cube1 on kenn_sember_stg_cube (hs_nr );


select now(), 'Erzeuge Index ixkenn_stgsem_cube2';

create  index ixkenn_stgsem_cube2 on kenn_sember_stg_cube (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_stgsem_cube3';

create  index ixkenn_stgsem_cube3 on kenn_sember_stg_cube (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_stgsem_cube4';

create  index ixkenn_stgsem_cube4 on kenn_sember_stg_cube (semester );


select now(), 'Erzeuge Index ixkenn_stgsem_cube5';

create  index ixkenn_stgsem_cube5 on kenn_sember_stg_cube (abschluss );


select now(), 'Erzeuge Index ixkenn_stgsem_cube6';

create  index ixkenn_stgsem_cube6 on kenn_sember_stg_cube (hzbart_astat );


select now(), 'Erzeuge Index ixkenn_stgsem_cube7';

create  index ixkenn_stgsem_cube7 on kenn_sember_stg_cube (kz_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stgsem_cube8';

create  index ixkenn_stgsem_cube8 on kenn_sember_stg_cube (stg );

</#if>
delete from db_tabellen where name='kenn_sember_stg_cube';
insert into db_tabellen (name,protokollierung) values('kenn_sember_stg_cube',0);

<#if !deleted_tables?seq_contains("kenn_antr_cube") && tables?is_sequence && tables?seq_contains("kenn_antr_cube") >


select now(), 'table kenn_antr_cube exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_antr_cube';

create table kenn_antr_cube(
	hs_nr INTEGER , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
bewsem SMALLINT , 
zul_kz INTEGER , 
abschluss_astat CHAR(10) , 
stg_astat CHAR(20) , 
stg CHAR(20) , 
antrnr SMALLINT , 
fach_sem_zahl SMALLINT , 
stort CHAR(10) , 
hzbart SMALLINT , 
summe INTEGER 
) 
;



comment on table kenn_antr_cube is 'Semesterberichte Bewerbungen';

comment on column kenn_antr_cube.hs_nr is 'Hochschulnummer';

comment on column kenn_antr_cube.fach_nr is 'Fach-Nummer';

comment on column kenn_antr_cube.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_antr_cube.ca12_staat is 'Nationalitt';

comment on column kenn_antr_cube.bewsem is 'Semester';

comment on column kenn_antr_cube.zul_kz is 'Zulassungskennzeichen';

comment on column kenn_antr_cube.abschluss_astat is 'Abschluss (amtlich)';

comment on column kenn_antr_cube.stg_astat is 'Fach (amtlich)';

comment on column kenn_antr_cube.stg is 'Hochschule und Fach (intern)';

comment on column kenn_antr_cube.antrnr is 'Antragsnummer';

comment on column kenn_antr_cube.fach_sem_zahl is 'Fachsemester';

comment on column kenn_antr_cube.stort is 'Standort';

comment on column kenn_antr_cube.hzbart is 'Art der Hochschulzugangsber.';

comment on column kenn_antr_cube.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_antr_cube1';

create  index ixkenn_antr_cube1 on kenn_antr_cube (hs_nr );


select now(), 'Erzeuge Index ixkenn_antr_cube2';

create  index ixkenn_antr_cube2 on kenn_antr_cube (fach_nr );


select now(), 'Erzeuge Index ixkenn_antr_cube3';

create  index ixkenn_antr_cube3 on kenn_antr_cube (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_antr_cube4';

create  index ixkenn_antr_cube4 on kenn_antr_cube (bewsem );


select now(), 'Erzeuge Index ixkenn_antr_cube5';

create  index ixkenn_antr_cube5 on kenn_antr_cube (abschluss_astat );


select now(), 'Erzeuge Index ixkenn_antr_cube6';

create  index ixkenn_antr_cube6 on kenn_antr_cube (stg );


select now(), 'Erzeuge Index ixkenn_antr_cube7';

create  index ixkenn_antr_cube7 on kenn_antr_cube (antrnr );

</#if>
delete from db_tabellen where name='kenn_antr_cube';
insert into db_tabellen (name,protokollierung) values('kenn_antr_cube',0);

<#if !deleted_tables?seq_contains("kenn_extkotr_lfb_hs") && tables?is_sequence && tables?seq_contains("kenn_extkotr_lfb_hs") >


select now(), 'table kenn_extkotr_lfb_hs exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_extkotr_lfb_hs';

create table kenn_extkotr_lfb_hs(
	key CHAR(10)  not null, 
hs_nr INTEGER  not null
) 
;



comment on table kenn_extkotr_lfb_hs is 'Externer Kostentrger (nur Lehr- und Forschungsbereiche) zu Hochschulen';

comment on column kenn_extkotr_lfb_hs.key is 'Externer Kostentrger (Schlssel)';

comment on column kenn_extkotr_lfb_hs.hs_nr is 'Hochschule';

</#if>
delete from db_tabellen where name='kenn_extkotr_lfb_hs';
insert into db_tabellen (name,protokollierung) values('kenn_extkotr_lfb_hs',0);

<#if !deleted_tables?seq_contains("kenn_bestand") && tables?is_sequence && tables?seq_contains("kenn_bestand") >


select now(), 'table kenn_bestand exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_bestand';

create table kenn_bestand(
	hs_nr INTEGER , 
bestandsart CHAR(40) , 
stichtagsart_id CHAR(40) , 
quelltabelle VARCHAR(255) , 
timeunit CHAR(1) , 
zeitwert INTEGER , 
bestand_anz INTEGER , 
bestand_datum date , 
datenherkunft VARCHAR(255) 
) 
;



comment on table kenn_bestand is 'Hilfstabelle Lieferungen pro Bestand';

</#if>
delete from db_tabellen where name='kenn_bestand';
insert into db_tabellen (name,protokollierung) values('kenn_bestand',0);

<#if !deleted_tables?seq_contains("kenn_report_stichtagsart") && tables?is_sequence && tables?seq_contains("kenn_report_stichtagsart") >


select now(), 'table kenn_report_stichtagsart exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_report_stichtagsart';

create table kenn_report_stichtagsart(
	tid SERIAL  not null, 
report_id CHAR(40)  not null, 
stichtagsart_id CHAR(40)  not null, 
	constraint c_kenn_report_sticht primary key (tid)

) 
;



comment on table kenn_report_stichtagsart is 'Berichte zu Stichtagsarten';

comment on column kenn_report_stichtagsart.tid is 'Tupelidentifier';

comment on column kenn_report_stichtagsart.report_id is 'ID des Reports';

comment on column kenn_report_stichtagsart.stichtagsart_id is 'ID der Stichtagsart';

</#if>
delete from db_tabellen where name='kenn_report_stichtagsart';
insert into db_tabellen (name,protokollierung) values('kenn_report_stichtagsart',0);

<#if !deleted_tables?seq_contains("kenn_bestandsart") && tables?is_sequence && tables?seq_contains("kenn_bestandsart") >


select now(), 'table kenn_bestandsart exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_bestandsart';

create table kenn_bestandsart(
	apnr CHAR(40)  not null, 
kurz VARCHAR(255) , 
druck VARCHAR(255) , 
beschreibung VARCHAR(255) , 
eingabeschema VARCHAR(255) , 
bezugsart CHAR(1)  default 'J' , 
quelltabelle VARCHAR(255) , 
zeitfeld VARCHAR(255) , 
stichtagsart_id CHAR(40)  not null, 
	constraint c_kenn_bestandsart primary key (apnr)

) 
;



comment on table kenn_bestandsart is 'Bestandsarten';

comment on column kenn_bestandsart.apnr is 'Schlssel Bestandsart';

comment on column kenn_bestandsart.bezugsart is 'Bezugsart (Semester S, Akad. Jahr A,Jahr J, Quartal Q, Monat M)';

comment on column kenn_bestandsart.stichtagsart_id is 'Schlssel Stichtagsart';

</#if>
delete from db_tabellen where name='kenn_bestandsart';
insert into db_tabellen (name,protokollierung) values('kenn_bestandsart',0);

<#if !deleted_tables?seq_contains("kenn_bestandsart_bland") && tables?is_sequence && tables?seq_contains("kenn_bestandsart_bland") >


select now(), 'table kenn_bestandsart_bland exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_bestandsart_bland';

create table kenn_bestandsart_bland(
	tid SERIAL  not null, 
bestandsart CHAR(40)  not null, 
beschreibung VARCHAR(255) , 
eingabeschema VARCHAR(255) , 
bland CHAR(10) , 
	constraint c_kenn_bestandsart_bland primary key (tid)

) 
;



comment on table kenn_bestandsart_bland is 'Bestandsarten zu Bundeslndern';

comment on column kenn_bestandsart_bland.tid is 'Tupelidentifier';

comment on column kenn_bestandsart_bland.bestandsart is 'Schlssel Bestandsart';

comment on column kenn_bestandsart_bland.bland is 'Bundesland';

</#if>
delete from db_tabellen where name='kenn_bestandsart_bland';
insert into db_tabellen (name,protokollierung) values('kenn_bestandsart_bland',0);

<#if !deleted_tables?seq_contains("kenn_promo") && tables?is_sequence && tables?seq_contains("kenn_promo") >


select now(), 'table kenn_promo exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_promo';

create table kenn_promo(
	jahr_beginn SMALLINT , 
jahr_ende SMALLINT , 
art_ende CHAR(2) , 
koop_land_ausl CHAR(1) , 
geschlecht SMALLINT , 
extkotr CHAR(20) , 
summe INTEGER 
) 
;



comment on table kenn_promo is 'Datentabelle Promovierende: Begonnen in Jahr, Erfolgreich in Jahr, Kooperation mit anderer HS (HS-Nr. bei HS im Land, Dauer in Jahren,  Geschlecht, Summe';

comment on column kenn_promo.jahr_beginn is 'Jahr des Beginns der Promotion';

comment on column kenn_promo.jahr_ende is 'Jahr des Ende der Promotion';

comment on column kenn_promo.art_ende is 'erfolgreich (B=bestanden,NB=nicht bestanden, U=unbekannt)';

comment on column kenn_promo.koop_land_ausl is 'Staat der Koop. HS (L=Eigenes Bundesland, D=Anderes Bundesland in Deutschland, A=Ausland)';

comment on column kenn_promo.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_promo.extkotr is 'Fchergruppe';

comment on column kenn_promo.summe is 'Summe';

</#if>
delete from db_tabellen where name='kenn_promo';
insert into db_tabellen (name,protokollierung) values('kenn_promo',0);

<#if !deleted_tables?seq_contains("kenn_promo_aggr") && tables?is_sequence && tables?seq_contains("kenn_promo_aggr") >


select now(), 'table kenn_promo_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_promo_aggr';

create table kenn_promo_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
jahr_beginn SMALLINT , 
jahr_ende SMALLINT , 
art_ende CHAR(2) , 
koop_land_ausl CHAR(1) , 
geschlecht SMALLINT , 
extkotr CHAR(20) , 
datum date , 
summe INTEGER , 
dauer_jahre FLOAT , 
monat_beginn SMALLINT , 
monat_ende SMALLINT , 
jahr_beginn_bezug SMALLINT , 
jahr_ende_bezug SMALLINT 
) 
;



comment on table kenn_promo_aggr is 'Hilfstabelle Promovierende: Begonnen in Jahr, Erfolgreich in Jahr, Kooperation mit anderer HS (HS-Nr. bei HS im Land, Dauer in Jahren,  Geschlecht, Summe';

comment on column kenn_promo_aggr.jahr is 'Bezugsjahr';

comment on column kenn_promo_aggr.jahr_beginn is 'Jahr des Beginns der Promotion';

comment on column kenn_promo_aggr.jahr_ende is 'Jahr des Ende der Promotion';

comment on column kenn_promo_aggr.art_ende is 'erfolgreich (B=bestanden,NB=nicht bestanden, U=unbekannt)';

comment on column kenn_promo_aggr.koop_land_ausl is 'Staat der Koop. HS (L=Eigenes Bundesland, D=Anderes Bundesland in Deutschland, A=Ausland)';

comment on column kenn_promo_aggr.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_promo_aggr.extkotr is 'Fchergruppe';

comment on column kenn_promo_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_promo_aggr.summe is 'Summe';

comment on column kenn_promo_aggr.dauer_jahre is 'Dauer in Jahren';

comment on column kenn_promo_aggr.monat_beginn is 'Monat des Beginns der Promotion';

comment on column kenn_promo_aggr.monat_ende is 'Monat des Ende der Promotion';

comment on column kenn_promo_aggr.jahr_beginn_bezug is 'Bezugsjahr des Beginns der Promotion';

comment on column kenn_promo_aggr.jahr_ende_bezug is 'Bezugsjahr des Ende der Promotion';

</#if>
delete from db_tabellen where name='kenn_promo_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_promo_aggr',0);

<#if !deleted_tables?seq_contains("kenn_stichtagsart") && tables?is_sequence && tables?seq_contains("kenn_stichtagsart") >


select now(), 'table kenn_stichtagsart exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stichtagsart';

create table kenn_stichtagsart(
	apnr CHAR(40)  not null, 
kurz VARCHAR(255) , 
druck VARCHAR(255) , 
beschreibung VARCHAR(255) , 
bezugsart CHAR(1)  default 'J' , 
aktiv CHAR(1)  default '1' , 
berechnen CHAR(1) , 
datum_wird_ausgewertet SMALLINT  default 0 , 
	constraint c_kenn_stichtagsart primary key (apnr)

) 
;



comment on table kenn_stichtagsart is 'Stichtagsarten';

comment on column kenn_stichtagsart.apnr is 'Schlssel Stichtagsart';

comment on column kenn_stichtagsart.bezugsart is 'Bezugsart (Semester S, Akad. Jahr A,Jahr J, Quartal Q, Monat M)';

comment on column kenn_stichtagsart.aktiv is 'Aktiv (1,0)';

comment on column kenn_stichtagsart.berechnen is 'Berechnen mglich?';

comment on column kenn_stichtagsart.datum_wird_ausgewertet is 'Datum wird ausgewertet?';

</#if>
delete from db_tabellen where name='kenn_stichtagsart';
insert into db_tabellen (name,protokollierung) values('kenn_stichtagsart',0);

<#if !deleted_tables?seq_contains("kenn_dim_extkotr") && tables?is_sequence && tables?seq_contains("kenn_dim_extkotr") >


select now(), 'table kenn_dim_extkotr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_dim_extkotr';

create table kenn_dim_extkotr(
	key CHAR(30) , 
name CHAR(255) , 
pb CHAR(30) , 
pb_str VARCHAR(255) , 
fgr CHAR(30) , 
fgr_str VARCHAR(255) , 
sb CHAR(30) , 
sb_str VARCHAR(255) , 
fach CHAR(30) , 
fach_str VARCHAR(255) , 
gueltig_von DATE , 
gueltig_bis DATE 
) 
;



comment on table kenn_dim_extkotr is 'Verzeichnis der externen Kostentrger';

comment on column kenn_dim_extkotr.key is 'Externer Kostentrgerschlssel';

comment on column kenn_dim_extkotr.name is 'Externer Kostentrgerbezeichnung';

comment on column kenn_dim_extkotr.pb is 'Produktbereich Schlssel';

comment on column kenn_dim_extkotr.pb_str is 'Produktbereich Name';

comment on column kenn_dim_extkotr.fgr is 'Produktbereich Schlssel';

comment on column kenn_dim_extkotr.fgr_str is 'Produktbereich Name';

comment on column kenn_dim_extkotr.sb is 'Produktbereich Schlssel';

comment on column kenn_dim_extkotr.sb_str is 'Produktbereich Name';

comment on column kenn_dim_extkotr.fach is 'Produktbereich Schlssel';

comment on column kenn_dim_extkotr.fach_str is 'Produktbereich Name';

comment on column kenn_dim_extkotr.gueltig_von is 'Gltig von';

comment on column kenn_dim_extkotr.gueltig_bis is 'Gltig bis';


select now(), 'Erzeuge Index ix_dim_extkotr_extkotr';

create  index ix_dim_extkotr_extkotr on kenn_dim_extkotr (fgr, 
fgr_str );

</#if>
delete from db_tabellen where name='kenn_dim_extkotr';
insert into db_tabellen (name,protokollierung) values('kenn_dim_extkotr',0);

<#if !deleted_tables?seq_contains("kenn_pkosten_cube") && tables?is_sequence && tables?seq_contains("kenn_pkosten_cube") >


select now(), 'table kenn_pkosten_cube exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_pkosten_cube';

create table kenn_pkosten_cube(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
bvkr_art CHAR(12) , 
klr_geldgeber CHAR(10) , 
projnr CHAR(10) , 
inst_art CHAR(20) , 
betrag double precision 
) 
;



comment on table kenn_pkosten_cube is 'Cube Primrkosten';

comment on column kenn_pkosten_cube.hs_nr is 'Hochschulnummer';

comment on column kenn_pkosten_cube.jahr is 'Jahr der Buchung';

comment on column kenn_pkosten_cube.quartal is 'Quartal der Buchung';

comment on column kenn_pkosten_cube.bvkr_art is 'Kostenart (BVKR)';

comment on column kenn_pkosten_cube.klr_geldgeber is 'Geldgeber nach KLR (Drittm.,Fremdkap.,HH)';

comment on column kenn_pkosten_cube.projnr is 'Externer Kostentrger';

comment on column kenn_pkosten_cube.inst_art is 'Externe Kostenstelle';

comment on column kenn_pkosten_cube.betrag is 'Betrag in EUR';

</#if>
delete from db_tabellen where name='kenn_pkosten_cube';
insert into db_tabellen (name,protokollierung) values('kenn_pkosten_cube',0);

<#if !deleted_tables?seq_contains("kenn_dim_extkost") && tables?is_sequence && tables?seq_contains("kenn_dim_extkost") >


select now(), 'table kenn_dim_extkost exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_dim_extkost';

create table kenn_dim_extkost(
	hs_art CHAR(10) , 
hs_art_str VARCHAR(255) , 
hs_nr INTEGER , 
hs_nr_str VARCHAR(255) , 
kost_art VARCHAR(255) , 
extkost CHAR(40) , 
extkost_str VARCHAR(255) 
) 
;



comment on table kenn_dim_extkost is 'Verzeichnis der externen Kostenstellen';

comment on column kenn_dim_extkost.hs_art is 'Hochschulart';

comment on column kenn_dim_extkost.hs_art_str is 'Hochschulart Bezeichnung';

comment on column kenn_dim_extkost.hs_nr is 'Hochschule (Schlssel)';

comment on column kenn_dim_extkost.hs_nr_str is 'Hochschule (Name)';

comment on column kenn_dim_extkost.kost_art is 'Art der ext. Kostenstelle';

comment on column kenn_dim_extkost.extkost is 'Externe Kostenstelle (Schlssel)';

comment on column kenn_dim_extkost.extkost_str is 'Externe Kostenstelle (Name)';


select now(), 'Erzeuge Index ix_kenn_dim_extkost_hs_nr';

create  index ix_kenn_dim_extkost_hs_nr on kenn_dim_extkost (hs_nr );

</#if>
delete from db_tabellen where name='kenn_dim_extkost';
insert into db_tabellen (name,protokollierung) values('kenn_dim_extkost',0);

<#if !deleted_tables?seq_contains("kenn_skosten_cube") && tables?is_sequence && tables?seq_contains("kenn_skosten_cube") >


select now(), 'table kenn_skosten_cube exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_skosten_cube';

create table kenn_skosten_cube(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
projnr CHAR(10) , 
produkt CHAR(10) , 
prim_sek CHAR(10) , 
koa_block CHAR(10) , 
betrag double precision 
) 
;



comment on table kenn_skosten_cube is 'Cube Primrkosten und Verteilbuchungen';

comment on column kenn_skosten_cube.hs_nr is 'Hochschulnummer';

comment on column kenn_skosten_cube.quartal is 'Quartal der Buchung';

comment on column kenn_skosten_cube.projnr is 'Projektnr. (ext. Kostentrger)';

comment on column kenn_skosten_cube.produkt is 'Produkt';

comment on column kenn_skosten_cube.prim_sek is 'Prim./Sek.';

comment on column kenn_skosten_cube.koa_block is 'Kostenartenblock';


select now(), 'Erzeuge Index ix_kenn_skosten_cube_hs_nr';

create  index ix_kenn_skosten_cube_hs_nr on kenn_skosten_cube (hs_nr );


select now(), 'Erzeuge Index ix_kenn_skosten_cube_jahr';

create  index ix_kenn_skosten_cube_jahr on kenn_skosten_cube (jahr );


select now(), 'Erzeuge Index ix_kenn_skosten_cube_produkt';

create  index ix_kenn_skosten_cube_produkt on kenn_skosten_cube (produkt );


select now(), 'Erzeuge Index ix_kenn_skosten_cube_prim_sek';

create  index ix_kenn_skosten_cube_prim_sek on kenn_skosten_cube (prim_sek );


select now(), 'Erzeuge Index ix_kenn_skosten_cube_koa_block';

create  index ix_kenn_skosten_cube_koa_block on kenn_skosten_cube (koa_block );

</#if>
delete from db_tabellen where name='kenn_skosten_cube';
insert into db_tabellen (name,protokollierung) values('kenn_skosten_cube',0);

<#if !deleted_tables?seq_contains("kenn_flaeche_cube") && tables?is_sequence && tables?seq_contains("kenn_flaeche_cube") >


select now(), 'table kenn_flaeche_cube exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_flaeche_cube';

create table kenn_flaeche_cube(
	hs_nr INTEGER , 
bund_fachgebiet CHAR(10) , 
nutzungsart CHAR(4) , 
kfanr VARCHAR(10) , 
jahr SMALLINT , 
inst_art CHAR(20) , 
flaeche decimal(15,2) 
) 
;



comment on table kenn_flaeche_cube is 'Joolap-Cube Flchen aus HISCOB (Tabl. cob_imp_flaeche)';

comment on column kenn_flaeche_cube.hs_nr is 'Hochschulnummer';

comment on column kenn_flaeche_cube.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_flaeche_cube.nutzungsart is 'Raumnutzungsart';

comment on column kenn_flaeche_cube.kfanr is 'Kostenflchenart';

comment on column kenn_flaeche_cube.jahr is 'Jahr des Stichtags';

comment on column kenn_flaeche_cube.inst_art is 'Externe Kostenstelle';

</#if>
delete from db_tabellen where name='kenn_flaeche_cube';
insert into db_tabellen (name,protokollierung) values('kenn_flaeche_cube',0);

<#if !deleted_tables?seq_contains("kenn_dim_lfb_fg") && tables?is_sequence && tables?seq_contains("kenn_dim_lfb_fg") >


select now(), 'table kenn_dim_lfb_fg exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_dim_lfb_fg';

create table kenn_dim_lfb_fg(
	apnr CHAR(10) , 
drucktext CHAR(255) , 
lfb CHAR(10) , 
lfb_str CHAR(255) , 
fgr CHAR(10) , 
fgr_str CHAR(255) , 
gueltig_von DATE , 
gueltig_bis DATE 
) 
;



comment on table kenn_dim_lfb_fg is '
        Schlssel des Stat. Bundesamtes fr Lehr-Forschungsbereiche und Fachgebiete. Die Tabelle spannt eine Hierarchie auf:
        Alle
        Fchergruppe
        Lehr- und Forschungsbreich
        Fachgebiet
      ';

comment on column kenn_dim_lfb_fg.apnr is 'Fach (Schlssel)';

comment on column kenn_dim_lfb_fg.drucktext is 'Fach (Bezeichnung)';

comment on column kenn_dim_lfb_fg.lfb is 'LFB (Schlssel)';

comment on column kenn_dim_lfb_fg.lfb_str is 'LFB (Bezeichnung)';

comment on column kenn_dim_lfb_fg.fgr is 'Fchergruppe (Schlssel)';

comment on column kenn_dim_lfb_fg.fgr_str is 'Fchergruppe (Bezeichnung)';

comment on column kenn_dim_lfb_fg.gueltig_von is 'Gltig von';

comment on column kenn_dim_lfb_fg.gueltig_bis is 'Gltig von';

</#if>
delete from db_tabellen where name='kenn_dim_lfb_fg';
insert into db_tabellen (name,protokollierung) values('kenn_dim_lfb_fg',0);

<#if !deleted_tables?seq_contains("kenn_pbv_astat") && tables?is_sequence && tables?seq_contains("kenn_pbv_astat") >


select now(), 'table kenn_pbv_astat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_pbv_astat';

create table kenn_pbv_astat(
	hs_nr INTEGER , 
jahr INTEGER , 
datum DATE , 
personal_nr INTEGER , 
ernennung_jahr_ngl SMALLINT , 
ef01 INTEGER , 
ef02 VARCHAR(255) , 
ef03 VARCHAR(255) , 
ef04 VARCHAR(255) , 
ef05 VARCHAR(255) , 
ef06 VARCHAR(255) , 
ef07 VARCHAR(255) , 
ef08 VARCHAR(255) , 
ef09 VARCHAR(255) , 
ef10 VARCHAR(255) , 
ef11 VARCHAR(255) , 
ef12 VARCHAR(255) , 
ef13 VARCHAR(255) , 
ef14 VARCHAR(255) , 
ef15 VARCHAR(255) , 
ef16 VARCHAR(255) , 
ef17 VARCHAR(255) , 
ef18 VARCHAR(255) , 
ef19 VARCHAR(255) , 
ef20 VARCHAR(255) , 
ef21 VARCHAR(255) , 
ef22 VARCHAR(255) , 
ef23 INTEGER , 
ef24 VARCHAR(255) , 
ef25 INTEGER , 
ef26 INTEGER , 
ef27 VARCHAR(255) , 
ef28 VARCHAR(255) , 
ef29 VARCHAR(255) , 
ef30 INTEGER , 
ef31 VARCHAR(255) , 
ef32 VARCHAR(255) , 
ef33 VARCHAR(255) , 
ef34 VARCHAR(255) , 
ef35 VARCHAR(255) , 
ef36 INTEGER , 
ef37 INTEGER , 
ef38 VARCHAR(255) , 
ef39 VARCHAR(255) , 
ef40 VARCHAR(255) , 
ef41 VARCHAR(255) , 
ef42 VARCHAR(255) , 
ef43 VARCHAR(255) 
) 
;



comment on table kenn_pbv_astat is 'Hilfstabelle Personal amtl. Stat';

comment on column kenn_pbv_astat.hs_nr is 'Hochschulnummer';

comment on column kenn_pbv_astat.jahr is 'Jahr';

comment on column kenn_pbv_astat.datum is 'Datum';

comment on column kenn_pbv_astat.personal_nr is 'Personalnr.';

comment on column kenn_pbv_astat.ernennung_jahr_ngl is 'Jahr bei Ernennung bei NGL';

comment on column kenn_pbv_astat.ef01 is 'ef01-Ordnungsmerkmal Satzart';

comment on column kenn_pbv_astat.ef02 is 'ef02-Berichtsland';

comment on column kenn_pbv_astat.ef03 is 'ef03-Hochschulnummer';

comment on column kenn_pbv_astat.ef04 is 'ef04-Listennummer';

comment on column kenn_pbv_astat.ef05 is 'ef05-Organisatorische Zugehrigkeit Kategorie';

comment on column kenn_pbv_astat.ef06 is 'ef06-Lehr- u. Forschungsbereich';

comment on column kenn_pbv_astat.ef07 is 'ef07-frei lassen';

comment on column kenn_pbv_astat.ef08 is 'ef08-Paginiernummer';

comment on column kenn_pbv_astat.ef09 is 'ef09-immer N';

comment on column kenn_pbv_astat.ef10 is 'ef10-Fachl. Zugehrigkeit';

comment on column kenn_pbv_astat.ef11 is 'ef11-Fachgebiet';

comment on column kenn_pbv_astat.ef12 is 'ef12-Dienstbezeichung';

comment on column kenn_pbv_astat.ef13 is 'ef13-Ttigkeit';

comment on column kenn_pbv_astat.ef14 is 'ef14-Arbeitszeit Vollzeit/Teilzeit';

comment on column kenn_pbv_astat.ef15 is 'ef15-hauptberufl. Ttigkeit';

comment on column kenn_pbv_astat.ef16 is 'ef16-Std. Anzahl';

comment on column kenn_pbv_astat.ef17 is 'ef17-Wochenstd. oder Semesterstd.';

comment on column kenn_pbv_astat.ef18 is 'ef18-Dienstverhltnis';

comment on column kenn_pbv_astat.ef19 is 'ef19-Beschftigung';

comment on column kenn_pbv_astat.ef20 is 'ef20-Laufbahngruppe';

comment on column kenn_pbv_astat.ef21 is 'ef21-Besoldungs-/ Vergtungsgruppe';

comment on column kenn_pbv_astat.ef22 is 'ef22-Art der Finanzierung';

comment on column kenn_pbv_astat.ef23 is 'ef23-Geschlecht';

comment on column kenn_pbv_astat.ef24 is 'ef24-Geburtsdatum Monat';

comment on column kenn_pbv_astat.ef25 is 'ef25-Jahr';

comment on column kenn_pbv_astat.ef26 is 'ef26-Staatsangeh.';

comment on column kenn_pbv_astat.ef27 is 'ef27-Hchster Schulabschluss';

comment on column kenn_pbv_astat.ef28 is 'ef28-Hochschule von EF27';

comment on column kenn_pbv_astat.ef29 is 'ef29-Staat von EF27';

comment on column kenn_pbv_astat.ef30 is 'ef30-Jahr des Erwerbs';

comment on column kenn_pbv_astat.ef31 is 'ef31-1. Fach des 1. Studiengang';

comment on column kenn_pbv_astat.ef32 is 'ef32-Habi. Fachgebiet d. Habi.';

comment on column kenn_pbv_astat.ef33 is 'ef33-Qualifizierung Art';

comment on column kenn_pbv_astat.ef34 is 'ef34-Verfahren';

comment on column kenn_pbv_astat.ef35 is 'ef35-Hochschule Position';

comment on column kenn_pbv_astat.ef36 is 'ef36-Jahr d. ersten Berufung auf Zeit';

comment on column kenn_pbv_astat.ef37 is 'ef37-Jahr d. ersten Berufung auf Lebenszeit';

comment on column kenn_pbv_astat.ef38 is 'ef38-Vorquali.';


select now(), 'Erzeuge Index ix_kenn_pbv_astat_hsnr';

create  index ix_kenn_pbv_astat_hsnr on kenn_pbv_astat (hs_nr );


select now(), 'Erzeuge Index ix_kenn_pbv_astat_jahr';

create  index ix_kenn_pbv_astat_jahr on kenn_pbv_astat (jahr );

</#if>
delete from db_tabellen where name='kenn_pbv_astat';
insert into db_tabellen (name,protokollierung) values('kenn_pbv_astat',0);

<#if !deleted_tables?seq_contains("kenn_sos_astat") && tables?is_sequence && tables?seq_contains("kenn_sos_astat") >


select now(), 'table kenn_sos_astat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_sos_astat';

create table kenn_sos_astat(
	hs_nr INTEGER , 
semester integer , 
matrikel_nr integer , 
ef001 varchar(12) , 
ef002 varchar(12) , 
ef003 varchar(12) , 
ef004 varchar(12) , 
ef005 varchar(12) , 
ef006 varchar(12) , 
ef007 varchar(12) , 
ef008u1 varchar(12) , 
ef008u2 varchar(12) , 
ef008u3 varchar(12) , 
ef009 varchar(12) , 
ef010 varchar(12) , 
ef011 varchar(12) , 
ef012u1 varchar(12) , 
ef012u2 varchar(12) , 
ef013u1 varchar(12) , 
ef013u2 varchar(12) , 
ef014 varchar(12) , 
ef015 varchar(12) , 
ef016 varchar(12) , 
ef017 varchar(12) , 
ef018 varchar(12) , 
ef019 varchar(12) , 
ef020 varchar(12) , 
ef021 varchar(12) , 
ef022 varchar(12) , 
ef023 varchar(12) , 
ef024 varchar(12) , 
ef025 varchar(12) , 
ef026 varchar(12) , 
ef027 varchar(12) , 
ef028 varchar(12) , 
ef029 varchar(12) , 
ef030 varchar(12) , 
ef031 varchar(12) , 
ef032 varchar(12) , 
ef033u1 varchar(12) , 
ef033u2 varchar(12) , 
ef034u1 varchar(12) , 
ef034u2 varchar(12) , 
ef035 varchar(12) , 
ef036 varchar(12) , 
ef037 varchar(12) , 
ef038 varchar(12) , 
ef039 varchar(12) , 
ef040 varchar(12) , 
ef041 varchar(12) , 
ef042 varchar(12) , 
ef043 varchar(12) , 
ef044 varchar(12) , 
ef045 varchar(12) , 
ef046 varchar(12) , 
ef047 varchar(12) , 
ef048 varchar(12) , 
ef049u1 varchar(12) , 
ef049u2 varchar(12) , 
ef050u1 varchar(12) , 
ef050u2 varchar(12) , 
ef051 varchar(12) , 
ef052 varchar(12) , 
ef053 varchar(12) , 
ef054 varchar(12) , 
ef055 varchar(12) , 
ef056 varchar(12) , 
ef057 varchar(12) , 
ef058 varchar(12) , 
ef059 varchar(12) , 
ef060 varchar(12) , 
ef061 varchar(12) , 
ef062 varchar(12) , 
ef063 varchar(12) , 
ef064 varchar(12) , 
ef065 varchar(12) , 
ef066 varchar(12) , 
ef067 varchar(12) , 
ef068 varchar(12) , 
ef069 varchar(12) , 
ef070 varchar(12) , 
ef071 varchar(12) , 
ef072 varchar(12) , 
ef073 varchar(12) , 
ef074 varchar(12) , 
ef075 varchar(12) , 
ef076 varchar(12) , 
ef077 varchar(12) , 
ef078 varchar(12) , 
ef079 varchar(12) , 
ef080 varchar(12) , 
ef081 varchar(12) , 
ef082 varchar(12) , 
ef083 varchar(12) , 
ef084 varchar(12) , 
ef085 varchar(12) , 
ef086 varchar(12) , 
ef087 varchar(12) , 
ef088 varchar(12) , 
ef089 varchar(12) , 
ef090 varchar(12) , 
ef091 varchar(12) , 
ef092 varchar(12) , 
ef093 varchar(12) , 
ef094 varchar(12) , 
ef095 varchar(12) , 
ef096 varchar(12) , 
ef097 varchar(12) , 
ef098 varchar(12) , 
ef099 varchar(12) , 
ef100 varchar(12) , 
ef101 varchar(12) , 
ef102 varchar(12) , 
ef103 varchar(12) , 
ef104 varchar(12) , 
ef105 varchar(12) , 
ef106 varchar(12) , 
ef107 varchar(12) , 
ef108 varchar(12) , 
ef109 varchar(12) , 
ef110 varchar(12) , 
ef111 varchar(12) , 
ef112 varchar(12) , 
ef113 varchar(12) , 
ef114 varchar(12) , 
ef115 varchar(12) , 
ef116 varchar(12) , 
ef117 varchar(12) , 
ef118 varchar(12) , 
ef119u1 varchar(12) , 
ef119u2 varchar(12) , 
ef120 varchar(12) , 
ef121 varchar(12) , 
ef122 varchar(12) , 
ef123 varchar(12) , 
ef124 varchar(12) , 
ef125 varchar(12) , 
ef126 varchar(12) , 
ef127 varchar(12) , 
ef128 varchar(12) , 
ef129 varchar(12) , 
ef130 varchar(12) , 
ef131 varchar(12) , 
ef132 varchar(12) , 
ef133 varchar(12) , 
ef134 varchar(12) , 
ef135 varchar(12) , 
ef136 varchar(12) , 
ef137 varchar(12) , 
ef138 varchar(12) , 
ef139 varchar(12) , 
ef140 varchar(12) , 
ef141 varchar(12) , 
ef142 varchar(12) , 
ef143 varchar(12) , 
ef144 varchar(12) , 
ef145 varchar(12) , 
ef146 varchar(12) , 
ef147u1 varchar(12) , 
ef147u2 varchar(12) , 
ef148 varchar(12) , 
ef149 varchar(12) , 
ef150 varchar(12) , 
ef151 varchar(12) , 
ef152 varchar(12) , 
ef153 varchar(12) , 
ef154 varchar(12) , 
ef155 varchar(12) , 
ef156 varchar(12) , 
ef157 varchar(12) , 
ef158 varchar(12) , 
ef159 varchar(12) , 
ef160 varchar(12) , 
ef161 varchar(12) , 
ef162 varchar(12) , 
ef163 varchar(12) , 
ef164 varchar(12) , 
ef165 varchar(12) , 
ef166 varchar(12) , 
ef167 varchar(12) , 
ef168 varchar(12) , 
ef169 varchar(12) , 
ef170 varchar(12) , 
ef171 varchar(12) , 
ef172 varchar(12) , 
ef173 varchar(12) , 
ef174 varchar(12) , 
ef175 varchar(12) , 
ef176 varchar(12) , 
ef177 varchar(12) , 
ef178 varchar(12) , 
ef179 varchar(12) , 
ef180 varchar(12) , 
ef181 varchar(12) , 
ef182 varchar(12) , 
ef183 varchar(12) , 
ef184u1 varchar(12) , 
ef184u2 varchar(12) , 
ef185 varchar(12) , 
ef186 varchar(12) , 
ef187 varchar(12) , 
ef188 varchar(12) , 
ef189 varchar(12) , 
ef190 varchar(12) , 
ef191 varchar(12) , 
ef192 varchar(12) , 
ef193 varchar(12) , 
ef194 varchar(12) , 
ef195 varchar(12) , 
ef196 varchar(12) , 
ef197 varchar(12) , 
ef198 varchar(12) , 
ef199 varchar(12) , 
id SERIAL  not null, 
importdatum timestamptz 
) 
;



comment on table kenn_sos_astat is 'Statistiktabelle Studierende zur Lieferung ans STALA (nach neuem Format)';

comment on column kenn_sos_astat.hs_nr is 'Hochschulnummer';

comment on column kenn_sos_astat.semester is 'Semester';

comment on column kenn_sos_astat.matrikel_nr is 'Matrikelnr.';

comment on column kenn_sos_astat.ef001 is 'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen';

comment on column kenn_sos_astat.ef002 is 'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester';

comment on column kenn_sos_astat.ef003 is 'ef003-Berichtsjahr';

comment on column kenn_sos_astat.ef004 is 'ef004-Hochschulstandort';

comment on column kenn_sos_astat.ef005 is 'ef005-Paginiernummer';

comment on column kenn_sos_astat.ef006 is 'ef006-Matrikelnummer';

comment on column kenn_sos_astat.ef007 is 'ef007-Geschlecht 1 = mnnlich 2 = weiblich';

comment on column kenn_sos_astat.ef008u1 is 'ef008u1-Geburtsdatum - Tag';

comment on column kenn_sos_astat.ef008u2 is 'ef008u2-Geburtsdatum - Monat';

comment on column kenn_sos_astat.ef008u3 is 'ef008u3-Geburtsdatum - Jahr';

comment on column kenn_sos_astat.ef009 is 'ef009-Name (Die ersten 4 Buchstaben des Vornamens';

comment on column kenn_sos_astat.ef010 is 'ef010-Staatsangehrigkeit';

comment on column kenn_sos_astat.ef011 is 'ef011-Weitere Staatsangehrigkeit';

comment on column kenn_sos_astat.ef012u1 is 'ef012u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat.ef012u2 is 'ef012u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_sos_astat.ef013u1 is 'ef013u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat.ef013u2 is 'ef013u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_sos_astat.ef014 is 'ef014-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat';

comment on column kenn_sos_astat.ef015 is 'ef015-Frei fr StL';

comment on column kenn_sos_astat.ef016 is 'ef016-Frei fr StL';

comment on column kenn_sos_astat.ef017 is 'ef017-Hochschulstandort der Ersteinschreibung';

comment on column kenn_sos_astat.ef018 is 'ef018-Bei Ersteinschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef019 is 'ef019-Ersteinschreibung in Deutschland/Semester';

comment on column kenn_sos_astat.ef020 is 'ef020-Jahr der Ersteinschreibung';

comment on column kenn_sos_astat.ef021 is 'ef021-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt';

comment on column kenn_sos_astat.ef022 is 'ef022-Urlaubssemester';

comment on column kenn_sos_astat.ef023 is 'ef023-Praxissemester';

comment on column kenn_sos_astat.ef024 is 'ef024-Semester am Studienkolleg';

comment on column kenn_sos_astat.ef025 is 'ef025-Anzahl der Unterbrechungssemester insgesamt';

comment on column kenn_sos_astat.ef026 is 'ef026-Art der Studienunterbrechung (Nur bei Exmatrikulation)';

comment on column kenn_sos_astat.ef027 is 'ef027-Frei fr StL';

comment on column kenn_sos_astat.ef028 is 'ef028-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_sos_astat.ef029 is 'ef029-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_sos_astat.ef030 is 'ef030-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_sos_astat.ef031 is 'ef031-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_sos_astat.ef032 is 'ef032-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat.ef033u1 is 'ef033u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_sos_astat.ef033u2 is 'ef033u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_sos_astat.ef034u1 is 'ef034u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat.ef034u2 is 'ef034u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland';

comment on column kenn_sos_astat.ef035 is 'ef035-Regelstudienzeit 1. Studiengang';

comment on column kenn_sos_astat.ef036 is 'ef036-1. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat.ef037 is 'ef037-2. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat.ef038 is 'ef038-Frei fr StL';

comment on column kenn_sos_astat.ef039 is 'ef039-3. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat.ef040 is 'ef040-Frei fr StL';

comment on column kenn_sos_astat.ef041 is 'ef041-Frei fr StL';

comment on column kenn_sos_astat.ef042 is 'ef042-Frei fr StL';

comment on column kenn_sos_astat.ef043 is 'ef043-Frei fr StL';

comment on column kenn_sos_astat.ef044 is 'ef044-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_sos_astat.ef045 is 'ef045-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_sos_astat.ef046 is 'ef046-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_sos_astat.ef047 is 'ef047-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_sos_astat.ef048 is 'ef048-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat.ef049u1 is 'ef049u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_sos_astat.ef049u2 is 'ef049u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_sos_astat.ef050u1 is 'ef050u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland (2. Studiengang)';

comment on column kenn_sos_astat.ef050u2 is 'ef050u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland (2. Studiengang)';

comment on column kenn_sos_astat.ef051 is 'ef051-Regelstudienzeit 2. Studiengang';

comment on column kenn_sos_astat.ef052 is 'ef052-1. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat.ef053 is 'ef053-2. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat.ef054 is 'ef054-Frei fr StL';

comment on column kenn_sos_astat.ef055 is 'ef055-3. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat.ef056 is 'ef056-Frei fr StL';

comment on column kenn_sos_astat.ef057 is 'ef057-Frei fr StL';

comment on column kenn_sos_astat.ef058 is 'ef058-Frei fr StL';

comment on column kenn_sos_astat.ef059 is 'ef059-Frei fr StL';

comment on column kenn_sos_astat.ef060 is 'ef060-Einschreibung an einer anderen Hochschule - Hochschulstandort';

comment on column kenn_sos_astat.ef061 is 'ef061-Einschreibung an einer anderen Hochschule - Bei Einschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef062 is 'ef062-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat.ef063 is 'ef063-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat.ef064 is 'ef064-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat.ef065 is 'ef065-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat.ef066 is 'ef066-Frei fr StL';

comment on column kenn_sos_astat.ef067 is 'ef067-Frei fr StL';

comment on column kenn_sos_astat.ef068 is 'ef068-Frei fr StL';

comment on column kenn_sos_astat.ef069 is 'ef069-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen';

comment on column kenn_sos_astat.ef070 is 'ef070-Studiengang gleich dem Berichtssemster?';

comment on column kenn_sos_astat.ef071 is 'ef071-Hochschulstandort';

comment on column kenn_sos_astat.ef072 is 'ef072-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef073 is 'ef073-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat.ef074 is 'ef074-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat.ef075 is 'ef075-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat.ef076 is 'ef076-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat.ef077 is 'ef077-Frei fr StL';

comment on column kenn_sos_astat.ef078 is 'ef078-Frei fr StL';

comment on column kenn_sos_astat.ef079 is 'ef079-Frei fr StL';

comment on column kenn_sos_astat.ef080 is 'ef080-Hochschulstandort';

comment on column kenn_sos_astat.ef081 is 'ef081-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef082 is 'ef082-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat.ef083 is 'ef083-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat.ef084 is 'ef084-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat.ef085 is 'ef085-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat.ef086 is 'ef086-Frei fr StL';

comment on column kenn_sos_astat.ef087 is 'ef087-Frei fr StL';

comment on column kenn_sos_astat.ef088 is 'ef088-Frei fr StL';

comment on column kenn_sos_astat.ef089 is 'ef089-Hochschulstandort';

comment on column kenn_sos_astat.ef090 is 'ef090-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef091 is 'ef091-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef092 is 'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef093 is 'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef094 is 'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef095 is 'ef095-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef096 is 'ef096-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef097 is 'ef097-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_sos_astat.ef098 is 'ef098-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00';

comment on column kenn_sos_astat.ef099 is 'ef099-Frei fr StL';

comment on column kenn_sos_astat.ef100 is 'ef100-Frei fr StL';

comment on column kenn_sos_astat.ef101 is 'ef101-Frei fr StL';

comment on column kenn_sos_astat.ef102 is 'ef102-Frei fr StL';

comment on column kenn_sos_astat.ef103 is 'ef103-Hochschulstandort';

comment on column kenn_sos_astat.ef104 is 'ef104-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef105 is 'ef105-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef106 is 'ef106-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef107 is 'ef107-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef108 is 'ef108-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef109 is 'ef109-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef110 is 'ef110-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef111 is 'ef111-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_sos_astat.ef112 is 'ef112-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00';

comment on column kenn_sos_astat.ef113 is 'ef113-Frei fr StL';

comment on column kenn_sos_astat.ef114 is 'ef114-Frei fr StL';

comment on column kenn_sos_astat.ef115 is 'ef115-Frei fr StL';

comment on column kenn_sos_astat.ef116 is 'ef116-Frei fr StL';

comment on column kenn_sos_astat.ef117 is 'ef117-Jahr des ersten Erwerbs der HZB';

comment on column kenn_sos_astat.ef118 is 'ef118-Art der HZB';

comment on column kenn_sos_astat.ef119u1 is 'ef119u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat.ef119u2 is 'ef119u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)';

comment on column kenn_sos_astat.ef120 is 'ef120-Frei fr StL';

comment on column kenn_sos_astat.ef121 is 'ef121-Frei fr StL';

comment on column kenn_sos_astat.ef122 is 'ef122-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER';

comment on column kenn_sos_astat.ef123 is 'ef123-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER';

comment on column kenn_sos_astat.ef124 is 'ef124-Frei fr StL';

comment on column kenn_sos_astat.ef125 is 'ef125-Frei fr StL';

comment on column kenn_sos_astat.ef126 is 'ef126-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef127 is 'ef127-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef128 is 'ef128-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef129 is 'ef129-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_sos_astat.ef130 is 'ef130-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_sos_astat.ef131 is 'ef131-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_sos_astat.ef132 is 'ef132-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte';

comment on column kenn_sos_astat.ef133 is 'ef133-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132';

comment on column kenn_sos_astat.ef134 is 'ef134-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte';

comment on column kenn_sos_astat.ef135 is 'ef135-1. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef136 is 'ef136-1. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef137 is 'ef137-1. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef138 is 'ef138-1. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef139 is 'ef139-2. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef140 is 'ef140-2. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef141 is 'ef141-2. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef142 is 'ef142-2. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef143 is 'ef143-3. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef144 is 'ef144-3. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef145 is 'ef145-3. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef146 is 'ef146-3. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef147u1 is 'ef147u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Studienform';

comment on column kenn_sos_astat.ef147u2 is 'ef147u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Abschluss';

comment on column kenn_sos_astat.ef148 is 'ef148-Fr Promotionsabsolventen Art der Promotion (1. Prfung)';

comment on column kenn_sos_astat.ef149 is 'ef149-Regelstudienzeit (1. Prfung)';

comment on column kenn_sos_astat.ef150 is 'ef150-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef151 is 'ef151-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef152 is 'ef152-Frei fr StL';

comment on column kenn_sos_astat.ef153 is 'ef153-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef154 is 'ef154-Frei fr StL';

comment on column kenn_sos_astat.ef155 is 'ef155-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef156 is 'ef156-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef157 is 'ef157-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef158 is 'ef158-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00';

comment on column kenn_sos_astat.ef159 is 'ef159-Frei fr StL';

comment on column kenn_sos_astat.ef160 is 'ef160-Frei fr StL';

comment on column kenn_sos_astat.ef161 is 'ef161-Frei fr StL';

comment on column kenn_sos_astat.ef162 is 'ef162-Frei fr StL';

comment on column kenn_sos_astat.ef163 is 'ef163-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef164 is 'ef164-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef165 is 'ef165-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef166 is 'ef166-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_sos_astat.ef167 is 'ef167-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_sos_astat.ef168 is 'ef168-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_sos_astat.ef169 is 'ef169-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte';

comment on column kenn_sos_astat.ef170 is 'ef170-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132';

comment on column kenn_sos_astat.ef171 is 'ef171-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte';

comment on column kenn_sos_astat.ef172 is 'ef172-1. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef173 is 'ef173-1. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef174 is 'ef174-1. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef175 is 'ef175-1. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef176 is 'ef176-2. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef177 is 'ef177-2. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef178 is 'ef178-2. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef179 is 'ef179-2. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef180 is 'ef180-3. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef181 is 'ef181-3. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef182 is 'ef182-3. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef183 is 'ef183-3. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef184u1 is 'ef184u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform';

comment on column kenn_sos_astat.ef184u2 is 'ef184u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss';

comment on column kenn_sos_astat.ef185 is 'ef185-Fr Promotionsabsolventen Art der Promotion (2. Prfung)';

comment on column kenn_sos_astat.ef186 is 'ef186-Regelstudienzeit (2. Prfung)';

comment on column kenn_sos_astat.ef187 is 'ef187-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef188 is 'ef188-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef189 is 'ef189-Frei fr StL';

comment on column kenn_sos_astat.ef190 is 'ef190-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef191 is 'ef191-Frei fr StL';

comment on column kenn_sos_astat.ef192 is 'ef192-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef193 is 'ef193-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef194 is 'ef194-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef195 is 'ef195-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00';

comment on column kenn_sos_astat.ef196 is 'ef196-Frei fr StL';

comment on column kenn_sos_astat.ef197 is 'ef197-Frei fr StL';

comment on column kenn_sos_astat.ef198 is 'ef198-Frei fr StL';

comment on column kenn_sos_astat.ef199 is 'ef199-Frei fr StL';

comment on column kenn_sos_astat.id is 'id';


select now(), 'Erzeuge Index kenn_sos_astat_ix1';

create  index kenn_sos_astat_ix1 on kenn_sos_astat (matrikel_nr );


select now(), 'Erzeuge Index kenn_sos_astat_ix2';

create  index kenn_sos_astat_ix2 on kenn_sos_astat (semester );

</#if>
delete from db_tabellen where name='kenn_sos_astat';
insert into db_tabellen (name,protokollierung) values('kenn_sos_astat',0);

<#if !deleted_tables?seq_contains("kenn_lab_astat") && tables?is_sequence && tables?seq_contains("kenn_lab_astat") >


select now(), 'table kenn_lab_astat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_lab_astat';

create table kenn_lab_astat(
	hs_nr INTEGER , 
semester integer , 
matrikel_nr integer , 
ef001 varchar(12) , 
ef002 varchar(12) , 
ef003 varchar(12) , 
ef004 varchar(12) , 
ef005 varchar(12) , 
ef006 varchar(12) , 
ef007 varchar(12) , 
ef008u1 varchar(12) , 
ef008u2 varchar(12) , 
ef008u3 varchar(12) , 
ef009 varchar(12) , 
ef010 varchar(12) , 
ef011 varchar(12) , 
ef012u1 varchar(12) , 
ef012u2 varchar(12) , 
ef013u1 varchar(12) , 
ef013u2 varchar(12) , 
ef014 varchar(12) , 
ef015 varchar(12) , 
ef016 varchar(12) , 
ef017 varchar(12) , 
ef018 varchar(12) , 
ef019 varchar(12) , 
ef020 varchar(12) , 
ef021 varchar(12) , 
ef022 varchar(12) , 
ef023 varchar(12) , 
ef024 varchar(12) , 
ef025 varchar(12) , 
ef026 varchar(12) , 
ef027 varchar(12) , 
ef028 varchar(12) , 
ef029 varchar(12) , 
ef030 varchar(12) , 
ef031 varchar(12) , 
ef032 varchar(12) , 
ef033u1 varchar(12) , 
ef033u2 varchar(12) , 
ef034u1 varchar(12) , 
ef034u2 varchar(12) , 
ef035 varchar(12) , 
ef036 varchar(12) , 
ef037 varchar(12) , 
ef038 varchar(12) , 
ef039 varchar(12) , 
ef040 varchar(12) , 
ef041 varchar(12) , 
ef042 varchar(12) , 
ef043 varchar(12) , 
ef044 varchar(12) , 
ef045 varchar(12) , 
ef046 varchar(12) , 
ef047 varchar(12) , 
ef048 varchar(12) , 
ef049u1 varchar(12) , 
ef049u2 varchar(12) , 
ef050u1 varchar(12) , 
ef050u2 varchar(12) , 
ef051 varchar(12) , 
ef052 varchar(12) , 
ef053 varchar(12) , 
ef054 varchar(12) , 
ef055 varchar(12) , 
ef056 varchar(12) , 
ef057 varchar(12) , 
ef058 varchar(12) , 
ef059 varchar(12) , 
ef060 varchar(12) , 
ef061 varchar(12) , 
ef062 varchar(12) , 
ef063 varchar(12) , 
ef064 varchar(12) , 
ef065 varchar(12) , 
ef066 varchar(12) , 
ef067 varchar(12) , 
ef068 varchar(12) , 
ef069 varchar(12) , 
ef070 varchar(12) , 
ef071 varchar(12) , 
ef072 varchar(12) , 
ef073 varchar(12) , 
ef074 varchar(12) , 
ef075 varchar(12) , 
ef076 varchar(12) , 
ef077 varchar(12) , 
ef078 varchar(12) , 
ef079 varchar(12) , 
ef080 varchar(12) , 
ef081 varchar(12) , 
ef082 varchar(12) , 
ef083 varchar(12) , 
ef084 varchar(12) , 
ef085 varchar(12) , 
ef086 varchar(12) , 
ef087 varchar(12) , 
ef088 varchar(12) , 
ef089 varchar(12) , 
ef090 varchar(12) , 
ef091 varchar(12) , 
ef092 varchar(12) , 
ef093 varchar(12) , 
ef094 varchar(12) , 
ef095 varchar(12) , 
ef096 varchar(12) , 
ef097 varchar(12) , 
ef098 varchar(12) , 
ef099 varchar(12) , 
ef100 varchar(12) , 
ef101 varchar(12) , 
ef102 varchar(12) , 
ef103 varchar(12) , 
ef104 varchar(12) , 
ef105 varchar(12) , 
ef106 varchar(12) , 
ef107 varchar(12) , 
ef108 varchar(12) , 
ef109 varchar(12) , 
ef110 varchar(12) , 
ef111 varchar(12) , 
ef112 varchar(12) , 
ef113 varchar(12) , 
ef114 varchar(12) , 
ef115 varchar(12) , 
ef116 varchar(12) , 
ef117 varchar(12) , 
ef118 varchar(12) , 
ef119u1 varchar(12) , 
ef119u2 varchar(12) , 
ef120 varchar(12) , 
ef121 varchar(12) , 
ef122 varchar(12) , 
ef123 varchar(12) , 
ef124 varchar(12) , 
ef125 varchar(12) , 
ef126 varchar(12) , 
ef127 varchar(12) , 
ef128 varchar(12) , 
ef129 varchar(12) , 
ef130 varchar(12) , 
ef131 varchar(12) , 
ef132 varchar(12) , 
ef133 varchar(12) , 
ef134 varchar(12) , 
ef135 varchar(12) , 
ef136 varchar(12) , 
ef137 varchar(12) , 
ef138 varchar(12) , 
ef139 varchar(12) , 
ef140 varchar(12) , 
ef141 varchar(12) , 
ef142 varchar(12) , 
ef143 varchar(12) , 
ef144 varchar(12) , 
ef145 varchar(12) , 
ef146 varchar(12) , 
ef147u1 varchar(12) , 
ef147u2 varchar(12) , 
ef148 varchar(12) , 
ef149 varchar(12) , 
ef150 varchar(12) , 
ef151 varchar(12) , 
ef152 varchar(12) , 
ef153 varchar(12) , 
ef154 varchar(12) , 
ef155 varchar(12) , 
ef156 varchar(12) , 
ef157 varchar(12) , 
ef158 varchar(12) , 
ef159 varchar(12) , 
ef160 varchar(12) , 
ef161 varchar(12) , 
ef162 varchar(12) , 
ef163 varchar(12) , 
ef164 varchar(12) , 
ef165 varchar(12) , 
ef166 varchar(12) , 
ef167 varchar(12) , 
ef168 varchar(12) , 
ef169 varchar(12) , 
ef170 varchar(12) , 
ef171 varchar(12) , 
ef172 varchar(12) , 
ef173 varchar(12) , 
ef174 varchar(12) , 
ef175 varchar(12) , 
ef176 varchar(12) , 
ef177 varchar(12) , 
ef178 varchar(12) , 
ef179 varchar(12) , 
ef180 varchar(12) , 
ef181 varchar(12) , 
ef182 varchar(12) , 
ef183 varchar(12) , 
ef184u1 varchar(12) , 
ef184u2 varchar(12) , 
ef185 varchar(12) , 
ef186 varchar(12) , 
ef187 varchar(12) , 
ef188 varchar(12) , 
ef189 varchar(12) , 
ef190 varchar(12) , 
ef191 varchar(12) , 
ef192 varchar(12) , 
ef193 varchar(12) , 
ef194 varchar(12) , 
ef195 varchar(12) , 
ef196 varchar(12) , 
ef197 varchar(12) , 
ef198 varchar(12) , 
ef199 varchar(12) , 
id SERIAL  not null, 
importdatum timestamptz 
) 
;



comment on table kenn_lab_astat is 'Statistiktabelle Absolventen zur Lieferung ans STALA (nach neuem Format)';

comment on column kenn_lab_astat.hs_nr is 'Hochschulnummer';

comment on column kenn_lab_astat.semester is 'Semester';

comment on column kenn_lab_astat.matrikel_nr is 'Matrikelnr.';

comment on column kenn_lab_astat.ef001 is 'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen';

comment on column kenn_lab_astat.ef002 is 'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester';

comment on column kenn_lab_astat.ef003 is 'ef003-Berichtsjahr';

comment on column kenn_lab_astat.ef004 is 'ef004-Hochschulstandort';

comment on column kenn_lab_astat.ef005 is 'ef005-Paginiernummer';

comment on column kenn_lab_astat.ef006 is 'ef006-Matrikelnummer';

comment on column kenn_lab_astat.ef007 is 'ef007-Geschlecht 1 = mnnlich 2 = weiblich';

comment on column kenn_lab_astat.ef008u1 is 'ef008u1-Geburtsdatum - Tag';

comment on column kenn_lab_astat.ef008u2 is 'ef008u2-Geburtsdatum - Monat';

comment on column kenn_lab_astat.ef008u3 is 'ef008u3-Geburtsdatum - Jahr';

comment on column kenn_lab_astat.ef009 is 'ef009-Name (Die ersten 4 Buchstaben des Vornamens';

comment on column kenn_lab_astat.ef010 is 'ef010-Staatsangehrigkeit';

comment on column kenn_lab_astat.ef011 is 'ef011-Weitere Staatsangehrigkeit';

comment on column kenn_lab_astat.ef012u1 is 'ef012u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat.ef012u2 is 'ef012u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_lab_astat.ef013u1 is 'ef013u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat.ef013u2 is 'ef013u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_lab_astat.ef014 is 'ef014-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat';

comment on column kenn_lab_astat.ef015 is 'ef015-Frei fr StL';

comment on column kenn_lab_astat.ef016 is 'ef016-Frei fr StL';

comment on column kenn_lab_astat.ef017 is 'ef017-Hochschulstandort der Ersteinschreibung';

comment on column kenn_lab_astat.ef018 is 'ef018-Bei Ersteinschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef019 is 'ef019-Ersteinschreibung in Deutschland/Semester';

comment on column kenn_lab_astat.ef020 is 'ef020-Jahr der Ersteinschreibung';

comment on column kenn_lab_astat.ef021 is 'ef021-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt';

comment on column kenn_lab_astat.ef022 is 'ef022-Urlaubssemester';

comment on column kenn_lab_astat.ef023 is 'ef023-Praxissemester';

comment on column kenn_lab_astat.ef024 is 'ef024-Semester am Studienkolleg';

comment on column kenn_lab_astat.ef025 is 'ef025-Anzahl der Unterbrechungssemester insgesamt';

comment on column kenn_lab_astat.ef026 is 'ef026-Art der Studienunterbrechung (Nur bei Exmatrikulation)';

comment on column kenn_lab_astat.ef027 is 'ef027-Frei fr StL';

comment on column kenn_lab_astat.ef028 is 'ef028-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_lab_astat.ef029 is 'ef029-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_lab_astat.ef030 is 'ef030-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_lab_astat.ef031 is 'ef031-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_lab_astat.ef032 is 'ef032-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat.ef033u1 is 'ef033u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_lab_astat.ef033u2 is 'ef033u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_lab_astat.ef034u1 is 'ef034u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat.ef034u2 is 'ef034u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland';

comment on column kenn_lab_astat.ef035 is 'ef035-Regelstudienzeit 1. Studiengang';

comment on column kenn_lab_astat.ef036 is 'ef036-1. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat.ef037 is 'ef037-2. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat.ef038 is 'ef038-Frei fr StL';

comment on column kenn_lab_astat.ef039 is 'ef039-3. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat.ef040 is 'ef040-Frei fr StL';

comment on column kenn_lab_astat.ef041 is 'ef041-Frei fr StL';

comment on column kenn_lab_astat.ef042 is 'ef042-Frei fr StL';

comment on column kenn_lab_astat.ef043 is 'ef043-Frei fr StL';

comment on column kenn_lab_astat.ef044 is 'ef044-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_lab_astat.ef045 is 'ef045-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_lab_astat.ef046 is 'ef046-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_lab_astat.ef047 is 'ef047-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_lab_astat.ef048 is 'ef048-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat.ef049u1 is 'ef049u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_lab_astat.ef049u2 is 'ef049u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_lab_astat.ef050u1 is 'ef050u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland (2. Studiengang)';

comment on column kenn_lab_astat.ef050u2 is 'ef050u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland (2. Studiengang)';

comment on column kenn_lab_astat.ef051 is 'ef051-Regelstudienzeit 2. Studiengang';

comment on column kenn_lab_astat.ef052 is 'ef052-1. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat.ef053 is 'ef053-2. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat.ef054 is 'ef054-Frei fr StL';

comment on column kenn_lab_astat.ef055 is 'ef055-3. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat.ef056 is 'ef056-Frei fr StL';

comment on column kenn_lab_astat.ef057 is 'ef057-Frei fr StL';

comment on column kenn_lab_astat.ef058 is 'ef058-Frei fr StL';

comment on column kenn_lab_astat.ef059 is 'ef059-Frei fr StL';

comment on column kenn_lab_astat.ef060 is 'ef060-Einschreibung an einer anderen Hochschule - Hochschulstandort';

comment on column kenn_lab_astat.ef061 is 'ef061-Einschreibung an einer anderen Hochschule - Bei Einschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef062 is 'ef062-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat.ef063 is 'ef063-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat.ef064 is 'ef064-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat.ef065 is 'ef065-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat.ef066 is 'ef066-Frei fr StL';

comment on column kenn_lab_astat.ef067 is 'ef067-Frei fr StL';

comment on column kenn_lab_astat.ef068 is 'ef068-Frei fr StL';

comment on column kenn_lab_astat.ef069 is 'ef069-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen';

comment on column kenn_lab_astat.ef070 is 'ef070-Studiengang gleich dem Berichtssemster?';

comment on column kenn_lab_astat.ef071 is 'ef071-Hochschulstandort';

comment on column kenn_lab_astat.ef072 is 'ef072-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef073 is 'ef073-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat.ef074 is 'ef074-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat.ef075 is 'ef075-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat.ef076 is 'ef076-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat.ef077 is 'ef077-Frei fr StL';

comment on column kenn_lab_astat.ef078 is 'ef078-Frei fr StL';

comment on column kenn_lab_astat.ef079 is 'ef079-Frei fr StL';

comment on column kenn_lab_astat.ef080 is 'ef080-Hochschulstandort';

comment on column kenn_lab_astat.ef081 is 'ef081-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef082 is 'ef082-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat.ef083 is 'ef083-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat.ef084 is 'ef084-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat.ef085 is 'ef085-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat.ef086 is 'ef086-Frei fr StL';

comment on column kenn_lab_astat.ef087 is 'ef087-Frei fr StL';

comment on column kenn_lab_astat.ef088 is 'ef088-Frei fr StL';

comment on column kenn_lab_astat.ef089 is 'ef089-Hochschulstandort';

comment on column kenn_lab_astat.ef090 is 'ef090-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef091 is 'ef091-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef092 is 'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef093 is 'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef094 is 'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef095 is 'ef095-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef096 is 'ef096-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef097 is 'ef097-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_lab_astat.ef098 is 'ef098-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00';

comment on column kenn_lab_astat.ef099 is 'ef099-Frei fr StL';

comment on column kenn_lab_astat.ef100 is 'ef100-Frei fr StL';

comment on column kenn_lab_astat.ef101 is 'ef101-Frei fr StL';

comment on column kenn_lab_astat.ef102 is 'ef102-Frei fr StL';

comment on column kenn_lab_astat.ef103 is 'ef103-Hochschulstandort';

comment on column kenn_lab_astat.ef104 is 'ef104-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef105 is 'ef105-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef106 is 'ef106-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef107 is 'ef107-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef108 is 'ef108-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef109 is 'ef109-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef110 is 'ef110-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef111 is 'ef111-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_lab_astat.ef112 is 'ef112-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00';

comment on column kenn_lab_astat.ef113 is 'ef113-Frei fr StL';

comment on column kenn_lab_astat.ef114 is 'ef114-Frei fr StL';

comment on column kenn_lab_astat.ef115 is 'ef115-Frei fr StL';

comment on column kenn_lab_astat.ef116 is 'ef116-Frei fr StL';

comment on column kenn_lab_astat.ef117 is 'ef117-Jahr des ersten Erwerbs der HZB';

comment on column kenn_lab_astat.ef118 is 'ef118-Art der HZB';

comment on column kenn_lab_astat.ef119u1 is 'ef119u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat.ef119u2 is 'ef119u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)';

comment on column kenn_lab_astat.ef120 is 'ef120-Frei fr StL';

comment on column kenn_lab_astat.ef121 is 'ef121-Frei fr StL';

comment on column kenn_lab_astat.ef122 is 'ef122-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER';

comment on column kenn_lab_astat.ef123 is 'ef123-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER';

comment on column kenn_lab_astat.ef124 is 'ef124-Frei fr StL';

comment on column kenn_lab_astat.ef125 is 'ef125-Frei fr StL';

comment on column kenn_lab_astat.ef126 is 'ef126-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef127 is 'ef127-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef128 is 'ef128-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef129 is 'ef129-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_lab_astat.ef130 is 'ef130-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_lab_astat.ef131 is 'ef131-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_lab_astat.ef132 is 'ef132-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte';

comment on column kenn_lab_astat.ef133 is 'ef133-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132';

comment on column kenn_lab_astat.ef134 is 'ef134-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte';

comment on column kenn_lab_astat.ef135 is 'ef135-1. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef136 is 'ef136-1. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef137 is 'ef137-1. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef138 is 'ef138-1. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef139 is 'ef139-2. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef140 is 'ef140-2. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef141 is 'ef141-2. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef142 is 'ef142-2. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef143 is 'ef143-3. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef144 is 'ef144-3. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef145 is 'ef145-3. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef146 is 'ef146-3. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef147u1 is 'ef147u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Studienform';

comment on column kenn_lab_astat.ef147u2 is 'ef147u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Abschluss';

comment on column kenn_lab_astat.ef148 is 'ef148-Fr Promotionsabsolventen Art der Promotion (1. Prfung)';

comment on column kenn_lab_astat.ef149 is 'ef149-Regelstudienzeit (1. Prfung)';

comment on column kenn_lab_astat.ef150 is 'ef150-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef151 is 'ef151-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef152 is 'ef152-Frei fr StL';

comment on column kenn_lab_astat.ef153 is 'ef153-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef154 is 'ef154-Frei fr StL';

comment on column kenn_lab_astat.ef155 is 'ef155-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef156 is 'ef156-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef157 is 'ef157-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef158 is 'ef158-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00';

comment on column kenn_lab_astat.ef159 is 'ef159-Frei fr StL';

comment on column kenn_lab_astat.ef160 is 'ef160-Frei fr StL';

comment on column kenn_lab_astat.ef161 is 'ef161-Frei fr StL';

comment on column kenn_lab_astat.ef162 is 'ef162-Frei fr StL';

comment on column kenn_lab_astat.ef163 is 'ef163-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef164 is 'ef164-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef165 is 'ef165-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef166 is 'ef166-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_lab_astat.ef167 is 'ef167-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_lab_astat.ef168 is 'ef168-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_lab_astat.ef169 is 'ef169-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte';

comment on column kenn_lab_astat.ef170 is 'ef170-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132';

comment on column kenn_lab_astat.ef171 is 'ef171-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte';

comment on column kenn_lab_astat.ef172 is 'ef172-1. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef173 is 'ef173-1. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef174 is 'ef174-1. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef175 is 'ef175-1. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef176 is 'ef176-2. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef177 is 'ef177-2. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef178 is 'ef178-2. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef179 is 'ef179-2. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef180 is 'ef180-3. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef181 is 'ef181-3. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef182 is 'ef182-3. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef183 is 'ef183-3. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef184u1 is 'ef184u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform';

comment on column kenn_lab_astat.ef184u2 is 'ef184u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss';

comment on column kenn_lab_astat.ef185 is 'ef185-Fr Promotionsabsolventen Art der Promotion (2. Prfung)';

comment on column kenn_lab_astat.ef186 is 'ef186-Regelstudienzeit (2. Prfung)';

comment on column kenn_lab_astat.ef187 is 'ef187-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef188 is 'ef188-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef189 is 'ef189-Frei fr StL';

comment on column kenn_lab_astat.ef190 is 'ef190-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef191 is 'ef191-Frei fr StL';

comment on column kenn_lab_astat.ef192 is 'ef192-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef193 is 'ef193-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef194 is 'ef194-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef195 is 'ef195-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00';

comment on column kenn_lab_astat.ef196 is 'ef196-Frei fr StL';

comment on column kenn_lab_astat.ef197 is 'ef197-Frei fr StL';

comment on column kenn_lab_astat.ef198 is 'ef198-Frei fr StL';

comment on column kenn_lab_astat.ef199 is 'ef199-Frei fr StL';

comment on column kenn_lab_astat.id is 'id';


select now(), 'Erzeuge Index kenn_lab_astat_ix1';

create  index kenn_lab_astat_ix1 on kenn_lab_astat (ef006 );


select now(), 'Erzeuge Index kenn_lab_astat_ix2';

create  index kenn_lab_astat_ix2 on kenn_lab_astat (ef002, 
ef003 );

</#if>
delete from db_tabellen where name='kenn_lab_astat';
insert into db_tabellen (name,protokollierung) values('kenn_lab_astat',0);

<#if !deleted_tables?seq_contains("kenn_stg_aggr_astat") && tables?is_sequence && tables?seq_contains("kenn_stg_aggr_astat") >


select now(), 'table kenn_stg_aggr_astat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stg_aggr_astat';

create table kenn_stg_aggr_astat(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_rueck_beur_ein SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
fgr CHAR(10) , 
abgrp CHAR(255) , 
regel SMALLINT , 
kz_rueck_beur_ein SMALLINT , 
fach_sem_zahl SMALLINT , 
hssem SMALLINT , 
stort CHAR(10) , 
stuart CHAR(10) , 
stufrm CHAR(10) , 
hzbart_astat CHAR(10) , 
hzbkfzkz CHAR(2) , 
hrst CHAR(10) , 
letzte_pruefung_stort CHAR(10) , 
letzte_pruefung_staat SMALLINT , 
letzte_pruefung_abschluss CHAR(2) , 
letzte_pruefung_ergebnis SMALLINT , 
vorletzte_pruefung_stort CHAR(10) , 
vorletzte_pruefung_staat SMALLINT , 
vorletzte_pruefung_abschluss CHAR(2) , 
vorletzte_pruefung_ergebnis SMALLINT , 
datum date , 
summe INTEGER , 
stg_land CHAR(4) 
) 
;



comment on table kenn_stg_aggr_astat is 'Hilfstabelle Studierendenstatistik (amtl.)';

comment on column kenn_stg_aggr_astat.hs_nr is 'Hochschule';

comment on column kenn_stg_aggr_astat.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_stg_aggr_astat.fach_nr is 'Fach-Nummer';

comment on column kenn_stg_aggr_astat.geschlecht is 'Geschlecht';

comment on column kenn_stg_aggr_astat.ca12_staat is 'Nationalitt';

comment on column kenn_stg_aggr_astat.sem_rueck_beur_ein is 'Semester';

comment on column kenn_stg_aggr_astat.stg is 'Fach (amtlich)';

comment on column kenn_stg_aggr_astat.abschluss is 'Abschluss (amtlich)';

comment on column kenn_stg_aggr_astat.fgr is 'Fchergruppe';

comment on column kenn_stg_aggr_astat.abgrp is 'Abschlussart';

comment on column kenn_stg_aggr_astat.regel is 'Regelstudienzeit';

comment on column kenn_stg_aggr_astat.kz_rueck_beur_ein is 'Einschreib- oder Rckmeldestatus';

comment on column kenn_stg_aggr_astat.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_stg_aggr_astat.hssem is 'Anzahl Hochschulsemester';

comment on column kenn_stg_aggr_astat.stort is 'Standort';

comment on column kenn_stg_aggr_astat.stuart is 'Studienart (amtlich)';

comment on column kenn_stg_aggr_astat.stufrm is 'Studienform (amtlich)';

comment on column kenn_stg_aggr_astat.hzbart_astat is 'Hochschulzugangsberechtigung Art';

comment on column kenn_stg_aggr_astat.hzbkfzkz is 'Hochschulzugangsberechtigung Land';

comment on column kenn_stg_aggr_astat.hrst is 'Hrerstatus';

comment on column kenn_stg_aggr_astat.letzte_pruefung_stort is 'Letzte Externe Prfung Hochschule/Standort';

comment on column kenn_stg_aggr_astat.letzte_pruefung_staat is 'Letzte Externe Prfung Staat';

comment on column kenn_stg_aggr_astat.letzte_pruefung_abschluss is 'Letzte Externe Prfung Abschluss (amtlich)';

comment on column kenn_stg_aggr_astat.letzte_pruefung_ergebnis is 'Letzte Externe Prfung Prfungsergebnis';

comment on column kenn_stg_aggr_astat.vorletzte_pruefung_stort is 'Vorletzte Externe Prfung Hochschule/Standort';

comment on column kenn_stg_aggr_astat.vorletzte_pruefung_staat is 'Vorletzte Externe Prfung Staat';

comment on column kenn_stg_aggr_astat.vorletzte_pruefung_abschluss is 'Vorletzte Externe Prfung Abschluss (amtlich)';

comment on column kenn_stg_aggr_astat.vorletzte_pruefung_ergebnis is 'Vorletzte Externe Prfung Prfungsergebnis';

comment on column kenn_stg_aggr_astat.datum is 'Datum der Erzeugung';

comment on column kenn_stg_aggr_astat.summe is 'Summe';

comment on column kenn_stg_aggr_astat.stg_land is 'Fach Land (amtlich)';


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat1';

create  index ixkenn_stg_aggr_astat1 on kenn_stg_aggr_astat (hs_nr );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat2';

create  index ixkenn_stg_aggr_astat2 on kenn_stg_aggr_astat (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat3';

create  index ixkenn_stg_aggr_astat3 on kenn_stg_aggr_astat (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat4';

create  index ixkenn_stg_aggr_astat4 on kenn_stg_aggr_astat (sem_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat5';

create  index ixkenn_stg_aggr_astat5 on kenn_stg_aggr_astat (abgrp );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat6';

create  index ixkenn_stg_aggr_astat6 on kenn_stg_aggr_astat (hzbart_astat );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat7';

create  index ixkenn_stg_aggr_astat7 on kenn_stg_aggr_astat (kz_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat8';

create  index ixkenn_stg_aggr_astat8 on kenn_stg_aggr_astat (fgr );

</#if>
delete from db_tabellen where name='kenn_stg_aggr_astat';
insert into db_tabellen (name,protokollierung) values('kenn_stg_aggr_astat',0);

<#if !deleted_tables?seq_contains("kenn_stud_aggr_astat") && tables?is_sequence && tables?seq_contains("kenn_stud_aggr_astat") >


select now(), 'table kenn_stud_aggr_astat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stud_aggr_astat';

create table kenn_stud_aggr_astat(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht CHAR(10) , 
bildungstyp CHAR(10) , 
sem_rueck_beur_ein SMALLINT , 
stg CHAR(4) , 
stg_land CHAR(4) , 
abschlusstyp CHAR(10) , 
regel SMALLINT , 
fach_sem_zahl SMALLINT , 
hssem_1 CHAR(10) , 
aufbaustudium CHAR(10) , 
hrst CHAR(10) , 
datum date , 
summe INTEGER 
) 
;



comment on table kenn_stud_aggr_astat is 'Hilfstabelle Studierendenstatistik (amtl.) fr Semesterberichte Unis BaWue';

comment on column kenn_stud_aggr_astat.hs_nr is 'Hochschule';

comment on column kenn_stud_aggr_astat.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_stud_aggr_astat.fach_nr is 'Fach-Nummer';

comment on column kenn_stud_aggr_astat.geschlecht is 'Geschlecht';

comment on column kenn_stud_aggr_astat.bildungstyp is 'Bildungstyp';

comment on column kenn_stud_aggr_astat.sem_rueck_beur_ein is 'Semester';

comment on column kenn_stud_aggr_astat.stg is 'Fach (amtlich)';

comment on column kenn_stud_aggr_astat.stg_land is 'Fach Land (amtlich)';

comment on column kenn_stud_aggr_astat.abschlusstyp is 'Abschlusstyp';

comment on column kenn_stud_aggr_astat.regel is 'Regelstudienzeit';

comment on column kenn_stud_aggr_astat.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_stud_aggr_astat.hssem_1 is '1. Hochschulsemester';

comment on column kenn_stud_aggr_astat.aufbaustudium is 'Ist Aufbaustudium';

comment on column kenn_stud_aggr_astat.hrst is 'Hrerstatus';

comment on column kenn_stud_aggr_astat.datum is 'Datum der Erzeugung';

comment on column kenn_stud_aggr_astat.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_stud_aggr_astat1';

create  index ixkenn_stud_aggr_astat1 on kenn_stud_aggr_astat (hs_nr );


select now(), 'Erzeuge Index ixkenn_stud_aggr_astat2';

create  index ixkenn_stud_aggr_astat2 on kenn_stud_aggr_astat (fach_nr );


select now(), 'Erzeuge Index ixkenn_stud_aggr_astat3';

create  index ixkenn_stud_aggr_astat3 on kenn_stud_aggr_astat (geschlecht, 
bildungstyp );


select now(), 'Erzeuge Index ixkenn_stud_aggr_astat4';

create  index ixkenn_stud_aggr_astat4 on kenn_stud_aggr_astat (sem_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stud_aggr_astat5';

create  index ixkenn_stud_aggr_astat5 on kenn_stud_aggr_astat (abschlusstyp );

</#if>
delete from db_tabellen where name='kenn_stud_aggr_astat';
insert into db_tabellen (name,protokollierung) values('kenn_stud_aggr_astat',0);

<#if !deleted_tables?seq_contains("kenn_lab_aggr_astat") && tables?is_sequence && tables?seq_contains("kenn_lab_aggr_astat") >


select now(), 'table kenn_lab_aggr_astat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_lab_aggr_astat';

create table kenn_lab_aggr_astat(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_der_pruefung SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
fgr CHAR(10) , 
abgrp CHAR(255) , 
regel SMALLINT , 
fach_sem_zahl SMALLINT , 
hzbart_astat CHAR(10) , 
hzbkfzkz CHAR(2) , 
stort CHAR(10) , 
stufrm CHAR(10) , 
pruefung_monat SMALLINT , 
pruefung_jahr SMALLINT , 
pruefung_ergebnis SMALLINT , 
ausland SMALLINT , 
datum date , 
summe INTEGER , 
stg_land CHAR(4) 
) 
;



comment on table kenn_lab_aggr_astat is 'Hilfstabelle Prfungsstatistik (amtl.)';

comment on column kenn_lab_aggr_astat.hs_nr is 'Hochschule';

comment on column kenn_lab_aggr_astat.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_lab_aggr_astat.fach_nr is 'Fach-Nummer';

comment on column kenn_lab_aggr_astat.geschlecht is 'Geschlecht';

comment on column kenn_lab_aggr_astat.ca12_staat is 'Nationalitt';

comment on column kenn_lab_aggr_astat.sem_der_pruefung is 'Semester';

comment on column kenn_lab_aggr_astat.stg is 'Fach (amtlich)';

comment on column kenn_lab_aggr_astat.abschluss is 'Abschluss (amtlich)';

comment on column kenn_lab_aggr_astat.fgr is 'Fchergruppe';

comment on column kenn_lab_aggr_astat.abgrp is 'Abschlussart';

comment on column kenn_lab_aggr_astat.regel is 'Regelstudienzeit';

comment on column kenn_lab_aggr_astat.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_lab_aggr_astat.hzbart_astat is 'Hochschulzugangsberechtigung Art';

comment on column kenn_lab_aggr_astat.hzbkfzkz is 'Hochschulzugangsberechtigung Land';

comment on column kenn_lab_aggr_astat.stort is 'Standort';

comment on column kenn_lab_aggr_astat.stufrm is 'Studienform (amtlich)';

comment on column kenn_lab_aggr_astat.pruefung_monat is 'Monat der Prfung';

comment on column kenn_lab_aggr_astat.pruefung_jahr is 'Jahr der Prfung';

comment on column kenn_lab_aggr_astat.pruefung_ergebnis is 'Prfungsergebnis';

comment on column kenn_lab_aggr_astat.ausland is 'Studienbezogene Auslandsaufenthalte';

comment on column kenn_lab_aggr_astat.datum is 'Datum der Erzeugung';

comment on column kenn_lab_aggr_astat.summe is 'Summe';

comment on column kenn_lab_aggr_astat.stg_land is 'Fach Land (amtlich)';


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat1';

create  index ixkenn_lab_aggr_astat1 on kenn_lab_aggr_astat (hs_nr );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat2';

create  index ixkenn_lab_aggr_astat2 on kenn_lab_aggr_astat (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat3';

create  index ixkenn_lab_aggr_astat3 on kenn_lab_aggr_astat (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat4';

create  index ixkenn_lab_aggr_astat4 on kenn_lab_aggr_astat (sem_der_pruefung );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat5';

create  index ixkenn_lab_aggr_astat5 on kenn_lab_aggr_astat (abgrp );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat6';

create  index ixkenn_lab_aggr_astat6 on kenn_lab_aggr_astat (hzbart_astat );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat7';

create  index ixkenn_lab_aggr_astat7 on kenn_lab_aggr_astat (pruefung_ergebnis );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat8';

create  index ixkenn_lab_aggr_astat8 on kenn_lab_aggr_astat (fgr );

</#if>
delete from db_tabellen where name='kenn_lab_aggr_astat';
insert into db_tabellen (name,protokollierung) values('kenn_lab_aggr_astat',0);

<#if !deleted_tables?seq_contains("kenn_absolv_aggr_astat") && tables?is_sequence && tables?seq_contains("kenn_absolv_aggr_astat") >


select now(), 'table kenn_absolv_aggr_astat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_absolv_aggr_astat';

create table kenn_absolv_aggr_astat(
	hs_nr INTEGER , 
fach_nr SMALLINT , 
geschlecht CHAR(10) , 
bildungstyp CHAR(10) , 
sem_der_pruefung SMALLINT , 
stg CHAR(4) , 
stg_land CHAR(4) , 
abschlusstyp CHAR(10) , 
regel SMALLINT , 
fach_sem_zahl SMALLINT , 
aufbaustudium CHAR(10) , 
datum date , 
summe INTEGER 
) 
;



comment on table kenn_absolv_aggr_astat is 'Hilfstabelle Prfungsstatistik (amtl.) fr Semesterberichte Unis BaWue';

comment on column kenn_absolv_aggr_astat.hs_nr is 'Hochschule';

comment on column kenn_absolv_aggr_astat.fach_nr is 'Fach-Nummer';

comment on column kenn_absolv_aggr_astat.geschlecht is 'Geschlecht';

comment on column kenn_absolv_aggr_astat.bildungstyp is 'Bildungstyp';

comment on column kenn_absolv_aggr_astat.sem_der_pruefung is 'Semester';

comment on column kenn_absolv_aggr_astat.stg is 'Fach (amtlich)';

comment on column kenn_absolv_aggr_astat.stg_land is 'Fach Land (amtlich)';

comment on column kenn_absolv_aggr_astat.abschlusstyp is 'Abschlusstyp';

comment on column kenn_absolv_aggr_astat.regel is 'Regelstudienzeit';

comment on column kenn_absolv_aggr_astat.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_absolv_aggr_astat.aufbaustudium is 'Ist Aufbaustudium';

comment on column kenn_absolv_aggr_astat.datum is 'Datum der Erzeugung';

comment on column kenn_absolv_aggr_astat.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_absolv_aggr_astat1';

create  index ixkenn_absolv_aggr_astat1 on kenn_absolv_aggr_astat (hs_nr );


select now(), 'Erzeuge Index ixkenn_absolv_aggr_astat2';

create  index ixkenn_absolv_aggr_astat2 on kenn_absolv_aggr_astat (fach_nr );


select now(), 'Erzeuge Index ixkenn_absolv_aggr_astat3';

create  index ixkenn_absolv_aggr_astat3 on kenn_absolv_aggr_astat (geschlecht, 
bildungstyp );


select now(), 'Erzeuge Index ixkenn_absolv_aggr_astat4';

create  index ixkenn_absolv_aggr_astat4 on kenn_absolv_aggr_astat (sem_der_pruefung );


select now(), 'Erzeuge Index ixkenn_absolv_aggr_astat5';

create  index ixkenn_absolv_aggr_astat5 on kenn_absolv_aggr_astat (abschlusstyp );

</#if>
delete from db_tabellen where name='kenn_absolv_aggr_astat';
insert into db_tabellen (name,protokollierung) values('kenn_absolv_aggr_astat',0);

<#if !deleted_tables?seq_contains("kenn_dim_fgr") && tables?is_sequence && tables?seq_contains("kenn_dim_fgr") >


select now(), 'table kenn_dim_fgr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_dim_fgr';

create table kenn_dim_fgr(
	apnr CHAR(10) , 
drucktext CHAR(255) , 
fg_personal CHAR(10) , 
fg_studierende CHAR(10) , 
gueltig_von DATE , 
gueltig_bis DATE , 
	constraint c_kenn_dim_fgr_apnr primary key (apnr)

) 
;



comment on table kenn_dim_fgr is 'Schlssel des Stat. Bundesamtes fr Fchergruppen (Studierende und Personal)';

comment on column kenn_dim_fgr.apnr is 'Fchergruppe (Schlssel)';

comment on column kenn_dim_fgr.drucktext is 'Fchergruppe (Bezeichnung)';

comment on column kenn_dim_fgr.fg_personal is 'Fchergruppe Personal (Schlssel)';

comment on column kenn_dim_fgr.fg_studierende is 'Fchergruppe Studierende (Schlssel)';

comment on column kenn_dim_fgr.gueltig_von is 'Gltig von';

comment on column kenn_dim_fgr.gueltig_bis is 'Gltig von';

</#if>
delete from db_tabellen where name='kenn_dim_fgr';
insert into db_tabellen (name,protokollierung) values('kenn_dim_fgr',0);

<#if !deleted_tables?seq_contains("kenn_sos_astat_2015") && tables?is_sequence && tables?seq_contains("kenn_sos_astat_2015") >


select now(), 'table kenn_sos_astat_2015 exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_sos_astat_2015';

create table kenn_sos_astat_2015(
	hs_nr INTEGER , 
semester integer , 
matrikel_nr integer , 
ef001 varchar(12) , 
ef002 varchar(12) , 
ef003 varchar(12) , 
ef004 varchar(12) , 
ef005 varchar(12) , 
ef006 varchar(12) , 
ef007 varchar(12) , 
ef008u1 varchar(12) , 
ef008u2 varchar(12) , 
ef009 varchar(12) , 
ef010u1 varchar(12) , 
ef010u2 varchar(12) , 
ef011u1 varchar(12) , 
ef011u2 varchar(12) , 
ef012 varchar(12) , 
ef013 varchar(12) , 
ef014 varchar(12) , 
ef015 varchar(12) , 
ef016 varchar(12) , 
ef017 varchar(12) , 
ef018 varchar(12) , 
ef019 varchar(12) , 
ef020 varchar(12) , 
ef021 varchar(12) , 
ef022 varchar(12) , 
ef023 varchar(12) , 
ef024 varchar(12) , 
ef025 varchar(12) , 
ef026 varchar(12) , 
ef027 varchar(12) , 
ef028 varchar(12) , 
ef029 varchar(12) , 
ef030 varchar(12) , 
ef031u1 varchar(12) , 
ef031u2 varchar(12) , 
ef032 varchar(12) , 
ef033 varchar(12) , 
ef034 varchar(12) , 
ef035 varchar(12) , 
ef036 varchar(12) , 
ef037 varchar(12) , 
ef038 varchar(12) , 
ef039 varchar(12) , 
ef040 varchar(12) , 
ef041 varchar(12) , 
ef042 varchar(12) , 
ef043 varchar(12) , 
ef044 varchar(12) , 
ef045 varchar(12) , 
ef046u1 varchar(12) , 
ef046u2 varchar(12) , 
ef047 varchar(12) , 
ef048 varchar(12) , 
ef049 varchar(12) , 
ef050 varchar(12) , 
ef051 varchar(12) , 
ef052 varchar(12) , 
ef053 varchar(12) , 
ef054 varchar(12) , 
ef055 varchar(12) , 
ef056 varchar(12) , 
ef057 varchar(12) , 
ef058 varchar(12) , 
ef059u1 varchar(12) , 
ef059u2 varchar(12) , 
ef060 varchar(12) , 
ef061 varchar(12) , 
ef062 varchar(12) , 
ef063 varchar(12) , 
ef064 varchar(12) , 
ef065 varchar(12) , 
ef066 varchar(12) , 
ef067 varchar(12) , 
ef068 varchar(12) , 
ef069u2 varchar(12) , 
ef069u1 varchar(12) , 
ef070 varchar(12) , 
ef071 varchar(12) , 
ef072 varchar(12) , 
ef073 varchar(12) , 
ef074 varchar(12) , 
ef075 varchar(12) , 
ef076 varchar(12) , 
ef077u1 varchar(12) , 
ef077u2 varchar(12) , 
ef078 varchar(12) , 
ef079 varchar(12) , 
ef080 varchar(12) , 
ef081 varchar(12) , 
ef082 varchar(12) , 
ef083 varchar(12) , 
ef084 varchar(12) , 
ef085 varchar(12) , 
ef086 varchar(12) , 
ef087 varchar(12) , 
ef088 varchar(12) , 
ef089 varchar(12) , 
ef090 varchar(12) , 
ef091u1 varchar(12) , 
ef091u2 varchar(12) , 
ef092 varchar(12) , 
ef093 varchar(12) , 
ef094 varchar(12) , 
ef095 varchar(12) , 
ef096 varchar(12) , 
ef097 varchar(12) , 
ef098 varchar(12) , 
ef099 varchar(12) , 
ef100u1 varchar(12) , 
ef100u2 varchar(12) , 
ef101 varchar(12) , 
ef102 varchar(12) , 
ef103 varchar(12) , 
ef104 varchar(12) , 
ef105 varchar(12) , 
ef106 varchar(12) , 
ef107 varchar(12) , 
ef108 varchar(12) , 
ef109 varchar(12) , 
ef110 varchar(12) , 
ef111u1 varchar(12) , 
ef111u2 varchar(12) , 
ef112 varchar(12) , 
ef113 varchar(12) , 
ef114 varchar(12) , 
ef115 varchar(12) , 
ef116 varchar(12) , 
ef117 varchar(12) , 
ef118 varchar(12) , 
ef119 varchar(12) , 
ef120 varchar(12) , 
ef121 varchar(12) , 
ef122 varchar(12) , 
ef123 varchar(12) , 
ef124 varchar(12) , 
ef125 varchar(12) , 
ef126u1 varchar(12) , 
ef126u2 varchar(12) , 
ef127 varchar(12) , 
ef128 varchar(12) , 
ef129 varchar(12) , 
ef130 varchar(12) , 
ef131 varchar(12) , 
ef132 varchar(12) , 
ef133 varchar(12) , 
ef134 varchar(12) , 
ef135 varchar(12) , 
ef136 varchar(12) , 
ef137 varchar(12) , 
ef138 varchar(12) , 
ef139 varchar(12) , 
ef140 varchar(12) , 
ef141 varchar(12) , 
ef142u1 varchar(12) , 
ef142u2 varchar(12) , 
ef143 varchar(12) , 
ef144 varchar(12) , 
ef145 varchar(12) , 
ef146 varchar(12) , 
ef147 varchar(12) , 
ef148 varchar(12) , 
ef149 varchar(12) , 
ef150 varchar(12) , 
ef151 varchar(12) , 
ef152 varchar(12) , 
id SERIAL  not null, 
	constraint pk_sos_astat_2015_id primary key (id)

) 
;



comment on table kenn_sos_astat_2015 is 'Statistiktabelle Studierende zur Lieferung ans STALA (nach altem Format bis 2016)';

comment on column kenn_sos_astat_2015.hs_nr is 'Hochschulnummer';

comment on column kenn_sos_astat_2015.semester is 'Semester';

comment on column kenn_sos_astat_2015.matrikel_nr is 'Matrikelnr.';

comment on column kenn_sos_astat_2015.ef001 is 'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen';

comment on column kenn_sos_astat_2015.ef002 is 'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester';

comment on column kenn_sos_astat_2015.ef003 is 'ef003-Berichtsjahr';

comment on column kenn_sos_astat_2015.ef004 is 'ef004-Hochschule';

comment on column kenn_sos_astat_2015.ef005 is 'ef005-Paginiernummer';

comment on column kenn_sos_astat_2015.ef006 is 'ef006-Matrikelnummer';

comment on column kenn_sos_astat_2015.ef007 is 'ef007-Geschlecht 1 = mnnlich 2 = weiblich';

comment on column kenn_sos_astat_2015.ef008u1 is 'ef008u1-Geburtsdatum - Monat';

comment on column kenn_sos_astat_2015.ef008u2 is 'ef008u2-Geburtsdatum - Jahr';

comment on column kenn_sos_astat_2015.ef009 is 'ef009-Staatsangehrigkeit';

comment on column kenn_sos_astat_2015.ef010u1 is 'ef010u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat_2015.ef010u2 is 'ef010u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_sos_astat_2015.ef011u1 is 'ef011u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat_2015.ef011u2 is 'ef011u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_sos_astat_2015.ef012 is 'ef012-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat';

comment on column kenn_sos_astat_2015.ef013 is 'ef013-Frei fr StL';

comment on column kenn_sos_astat_2015.ef014 is 'ef014-Frei fr StL';

comment on column kenn_sos_astat_2015.ef015 is 'ef015-Frei fr StL';

comment on column kenn_sos_astat_2015.ef016 is 'ef016-Hochschule der Ersteinschreibung';

comment on column kenn_sos_astat_2015.ef017 is 'ef017-Ersteinschreibung in Deutschland/Semester';

comment on column kenn_sos_astat_2015.ef018 is 'ef018-Jahr der Ersteinschreibung';

comment on column kenn_sos_astat_2015.ef019 is 'ef019-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt';

comment on column kenn_sos_astat_2015.ef020 is 'ef020-Urlaubssemester';

comment on column kenn_sos_astat_2015.ef021 is 'ef021-Praxissemester';

comment on column kenn_sos_astat_2015.ef022 is 'ef022-- Semester in der DDR bzw. Berlin (Ost) (einschl. Urlaubssemester)';

comment on column kenn_sos_astat_2015.ef023 is 'ef023-Nur bei Studium in der DDR bzw. Berlin (Ost) Art des Studiums 1 = Prsenzstudium 2 = Fernstudium';

comment on column kenn_sos_astat_2015.ef024 is 'ef024-Semester am Studienkolleg';

comment on column kenn_sos_astat_2015.ef025 is 'ef025-Anzahl der Unterbrechungssemester insgesamt';

comment on column kenn_sos_astat_2015.ef026 is 'ef026-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_sos_astat_2015.ef027 is 'ef027-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_sos_astat_2015.ef028 is 'ef028-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_sos_astat_2015.ef029 is 'ef029-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_sos_astat_2015.ef030 is 'ef030-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat_2015.ef031u1 is 'ef031u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_sos_astat_2015.ef031u2 is 'ef031u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_sos_astat_2015.ef032 is 'ef032-1. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat_2015.ef033 is 'ef033-Frei fr StL';

comment on column kenn_sos_astat_2015.ef034 is 'ef034-2. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat_2015.ef035 is 'ef035-Frei fr StL';

comment on column kenn_sos_astat_2015.ef036 is 'ef036-3. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat_2015.ef037 is 'ef037-Frei fr StL';

comment on column kenn_sos_astat_2015.ef038 is 'ef038-Frei fr StL';

comment on column kenn_sos_astat_2015.ef039 is 'ef039-Frei fr StL';

comment on column kenn_sos_astat_2015.ef040 is 'ef040-Frei fr StL';

comment on column kenn_sos_astat_2015.ef041 is 'ef041-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_sos_astat_2015.ef042 is 'ef042-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_sos_astat_2015.ef043 is 'ef043-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_sos_astat_2015.ef044 is 'ef044-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_sos_astat_2015.ef045 is 'ef045-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat_2015.ef046u1 is 'ef046u1-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Studienform';

comment on column kenn_sos_astat_2015.ef046u2 is 'ef046u2-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Abschluss';

comment on column kenn_sos_astat_2015.ef047 is 'ef047-1. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat_2015.ef048 is 'ef048-Frei fr StL';

comment on column kenn_sos_astat_2015.ef049 is 'ef049-2. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat_2015.ef050 is 'ef050-Frei fr StL';

comment on column kenn_sos_astat_2015.ef051 is 'ef051-3. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat_2015.ef052 is 'ef052-Frei fr StL';

comment on column kenn_sos_astat_2015.ef053 is 'ef053-Frei fr StL';

comment on column kenn_sos_astat_2015.ef054 is 'ef054-Frei fr StL';

comment on column kenn_sos_astat_2015.ef055 is 'ef055-Frei fr StL';

comment on column kenn_sos_astat_2015.ef056 is 'ef056-Hochschule (bei Einschreibung an einer anderen HS im Berichtssemester)';

comment on column kenn_sos_astat_2015.ef057 is 'ef057-Frei fr StL';

comment on column kenn_sos_astat_2015.ef058 is 'ef058-Frei fr StL';

comment on column kenn_sos_astat_2015.ef059u1 is 'ef059u1-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Studienform';

comment on column kenn_sos_astat_2015.ef059u2 is 'ef059u2-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Abschluss';

comment on column kenn_sos_astat_2015.ef060 is 'ef060-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat_2015.ef061 is 'ef061-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat_2015.ef062 is 'ef062-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat_2015.ef063 is 'ef063-Frei fr StL';

comment on column kenn_sos_astat_2015.ef064 is 'ef064-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen';

comment on column kenn_sos_astat_2015.ef065 is 'ef065-Studiengang gleich dem Berichtssemster?';

comment on column kenn_sos_astat_2015.ef066 is 'ef066-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat_2015.ef067 is 'ef067-Frei fr StL';

comment on column kenn_sos_astat_2015.ef068 is 'ef068-Frei fr StL';

comment on column kenn_sos_astat_2015.ef069u2 is 'ef069u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Studienform';

comment on column kenn_sos_astat_2015.ef069u1 is 'ef069u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Abschluss';

comment on column kenn_sos_astat_2015.ef070 is 'ef070-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat_2015.ef071 is 'ef071-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat_2015.ef072 is 'ef072-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat_2015.ef073 is 'ef073-Frei fr StL';

comment on column kenn_sos_astat_2015.ef074 is 'ef074-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat_2015.ef075 is 'ef075-Frei fr StL';

comment on column kenn_sos_astat_2015.ef076 is 'ef076-Frei fr StL';

comment on column kenn_sos_astat_2015.ef077u1 is 'ef077u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Studienform';

comment on column kenn_sos_astat_2015.ef077u2 is 'ef077u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Abschluss';

comment on column kenn_sos_astat_2015.ef078 is 'ef078-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat_2015.ef079 is 'ef079-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat_2015.ef080 is 'ef080-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat_2015.ef081 is 'ef081-Frei fr StL';

comment on column kenn_sos_astat_2015.ef082 is 'ef082-1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_sos_astat_2015.ef083 is 'ef083-Monate im 1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_sos_astat_2015.ef084 is 'ef084-Frei fr StL';

comment on column kenn_sos_astat_2015.ef085 is 'ef085-2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_sos_astat_2015.ef086 is 'ef086-Monate im 2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_sos_astat_2015.ef087 is 'ef087-Frei fr StL';

comment on column kenn_sos_astat_2015.ef088 is 'ef088-Frei fr StL';

comment on column kenn_sos_astat_2015.ef089 is 'ef089-Frei fr StL';

comment on column kenn_sos_astat_2015.ef090 is 'ef090-Frei fr StL';

comment on column kenn_sos_astat_2015.ef091u1 is 'ef091u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Studienform';

comment on column kenn_sos_astat_2015.ef091u2 is 'ef091u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Abschluss';

comment on column kenn_sos_astat_2015.ef092 is 'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat_2015.ef093 is 'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat_2015.ef094 is 'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat_2015.ef095 is 'ef095-Frei fr StL';

comment on column kenn_sos_astat_2015.ef096 is 'ef096-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat_2015.ef097 is 'ef097-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat_2015.ef098 is 'ef098-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_sos_astat_2015.ef099 is 'ef099-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00';

comment on column kenn_sos_astat_2015.ef100u1 is 'ef100u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Studienform';

comment on column kenn_sos_astat_2015.ef100u2 is 'ef100u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Abschluss';

comment on column kenn_sos_astat_2015.ef101 is 'ef101-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat_2015.ef102 is 'ef102-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat_2015.ef103 is 'ef103-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat_2015.ef104 is 'ef104-Frei fr StL';

comment on column kenn_sos_astat_2015.ef105 is 'ef105-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat_2015.ef106 is 'ef106-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat_2015.ef107 is 'ef107-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_sos_astat_2015.ef108 is 'ef108-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00';

comment on column kenn_sos_astat_2015.ef109 is 'ef109-Jahr des ersten Erwerbs der HZB';

comment on column kenn_sos_astat_2015.ef110 is 'ef110-Art der HZB';

comment on column kenn_sos_astat_2015.ef111u1 is 'ef111u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat_2015.ef111u2 is 'ef111u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)';

comment on column kenn_sos_astat_2015.ef112 is 'ef112-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER';

comment on column kenn_sos_astat_2015.ef113 is 'ef113-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER';

comment on column kenn_sos_astat_2015.ef114 is 'ef114-Frei fr StL';

comment on column kenn_sos_astat_2015.ef115 is 'ef115-Frei fr StL';

comment on column kenn_sos_astat_2015.ef116 is 'ef116-Frei fr StL';

comment on column kenn_sos_astat_2015.ef117 is 'ef117-Frei fr StL';

comment on column kenn_sos_astat_2015.ef118 is 'ef118-Frei fr StL';

comment on column kenn_sos_astat_2015.ef119 is 'ef119-Frei fr StL';

comment on column kenn_sos_astat_2015.ef120 is 'ef120-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef121 is 'ef121-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef122 is 'ef122-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef123 is 'ef123-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_sos_astat_2015.ef124 is 'ef124-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_sos_astat_2015.ef125 is 'ef125-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_sos_astat_2015.ef126u1 is 'ef126u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Studienform';

comment on column kenn_sos_astat_2015.ef126u2 is 'ef126u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Abschluss';

comment on column kenn_sos_astat_2015.ef127 is 'ef127-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef128 is 'ef128-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef129 is 'ef129-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef130 is 'ef130-Frei fr StL';

comment on column kenn_sos_astat_2015.ef131 is 'ef131-Frei fr StL';

comment on column kenn_sos_astat_2015.ef132 is 'ef132-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef133 is 'ef133-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef134 is 'ef134-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef135 is 'ef135-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00';

comment on column kenn_sos_astat_2015.ef136 is 'ef136-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef137 is 'ef137-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef138 is 'ef138-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef139 is 'ef139-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_sos_astat_2015.ef140 is 'ef140-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_sos_astat_2015.ef141 is 'ef141-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_sos_astat_2015.ef142u1 is 'ef142u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform';

comment on column kenn_sos_astat_2015.ef142u2 is 'ef142u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss';

comment on column kenn_sos_astat_2015.ef143 is 'ef143-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef144 is 'ef144-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef145 is 'ef145-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef146 is 'ef146-Frei fr StL';

comment on column kenn_sos_astat_2015.ef147 is 'ef147-Frei fr StL';

comment on column kenn_sos_astat_2015.ef148 is 'ef148-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef149 is 'ef149-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef150 is 'ef150-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef151 is 'ef151-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00';

comment on column kenn_sos_astat_2015.ef152 is 'ef152-Gesamtnote in Punkten bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';


select now(), 'Erzeuge Index ixkenn_sos_astat_20151';

create  index ixkenn_sos_astat_20151 on kenn_sos_astat_2015 (matrikel_nr );


select now(), 'Erzeuge Index ixkenn_sos_astat_20152';

create  index ixkenn_sos_astat_20152 on kenn_sos_astat_2015 (semester );

</#if>
delete from db_tabellen where name='kenn_sos_astat_2015';
insert into db_tabellen (name,protokollierung) values('kenn_sos_astat_2015',0);

<#if !deleted_tables?seq_contains("kenn_lab_astat_2015") && tables?is_sequence && tables?seq_contains("kenn_lab_astat_2015") >


select now(), 'table kenn_lab_astat_2015 exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_lab_astat_2015';

create table kenn_lab_astat_2015(
	hs_nr INTEGER , 
semester integer , 
matrikel_nr integer , 
ef001 varchar(12) , 
ef002 varchar(12) , 
ef003 varchar(12) , 
ef004 varchar(12) , 
ef005 varchar(12) , 
ef006 varchar(12) , 
ef007 varchar(12) , 
ef008u1 varchar(12) , 
ef008u2 varchar(12) , 
ef009 varchar(12) , 
ef010u1 varchar(12) , 
ef010u2 varchar(12) , 
ef011u1 varchar(12) , 
ef011u2 varchar(12) , 
ef012 varchar(12) , 
ef013 varchar(12) , 
ef014 varchar(12) , 
ef015 varchar(12) , 
ef016 varchar(12) , 
ef017 varchar(12) , 
ef018 varchar(12) , 
ef019 varchar(12) , 
ef020 varchar(12) , 
ef021 varchar(12) , 
ef022 varchar(12) , 
ef023 varchar(12) , 
ef024 varchar(12) , 
ef025 varchar(12) , 
ef026 varchar(12) , 
ef027 varchar(12) , 
ef028 varchar(12) , 
ef029 varchar(12) , 
ef030 varchar(12) , 
ef031u1 varchar(12) , 
ef031u2 varchar(12) , 
ef032 varchar(12) , 
ef033 varchar(12) , 
ef034 varchar(12) , 
ef035 varchar(12) , 
ef036 varchar(12) , 
ef037 varchar(12) , 
ef038 varchar(12) , 
ef039 varchar(12) , 
ef040 varchar(12) , 
ef041 varchar(12) , 
ef042 varchar(12) , 
ef043 varchar(12) , 
ef044 varchar(12) , 
ef045 varchar(12) , 
ef046u1 varchar(12) , 
ef046u2 varchar(12) , 
ef047 varchar(12) , 
ef048 varchar(12) , 
ef049 varchar(12) , 
ef050 varchar(12) , 
ef051 varchar(12) , 
ef052 varchar(12) , 
ef053 varchar(12) , 
ef054 varchar(12) , 
ef055 varchar(12) , 
ef056 varchar(12) , 
ef057 varchar(12) , 
ef058 varchar(12) , 
ef059u1 varchar(12) , 
ef059u2 varchar(12) , 
ef060 varchar(12) , 
ef061 varchar(12) , 
ef062 varchar(12) , 
ef063 varchar(12) , 
ef064 varchar(12) , 
ef065 varchar(12) , 
ef066 varchar(12) , 
ef067 varchar(12) , 
ef068 varchar(12) , 
ef069u2 varchar(12) , 
ef069u1 varchar(12) , 
ef070 varchar(12) , 
ef071 varchar(12) , 
ef072 varchar(12) , 
ef073 varchar(12) , 
ef074 varchar(12) , 
ef075 varchar(12) , 
ef076 varchar(12) , 
ef077u1 varchar(12) , 
ef077u2 varchar(12) , 
ef078 varchar(12) , 
ef079 varchar(12) , 
ef080 varchar(12) , 
ef081 varchar(12) , 
ef082 varchar(12) , 
ef083 varchar(12) , 
ef084 varchar(12) , 
ef085 varchar(12) , 
ef086 varchar(12) , 
ef087 varchar(12) , 
ef088 varchar(12) , 
ef089 varchar(12) , 
ef090 varchar(12) , 
ef091u1 varchar(12) , 
ef091u2 varchar(12) , 
ef092 varchar(12) , 
ef093 varchar(12) , 
ef094 varchar(12) , 
ef095 varchar(12) , 
ef096 varchar(12) , 
ef097 varchar(12) , 
ef098 varchar(12) , 
ef099 varchar(12) , 
ef100u1 varchar(12) , 
ef100u2 varchar(12) , 
ef101 varchar(12) , 
ef102 varchar(12) , 
ef103 varchar(12) , 
ef104 varchar(12) , 
ef105 varchar(12) , 
ef106 varchar(12) , 
ef107 varchar(12) , 
ef108 varchar(12) , 
ef109 varchar(12) , 
ef110 varchar(12) , 
ef111u1 varchar(12) , 
ef111u2 varchar(12) , 
ef112 varchar(12) , 
ef113 varchar(12) , 
ef114 varchar(12) , 
ef115 varchar(12) , 
ef116 varchar(12) , 
ef117 varchar(12) , 
ef118 varchar(12) , 
ef119 varchar(12) , 
ef120 varchar(12) , 
ef121 varchar(12) , 
ef122 varchar(12) , 
ef123 varchar(12) , 
ef124 varchar(12) , 
ef125 varchar(12) , 
ef126u1 varchar(12) , 
ef126u2 varchar(12) , 
ef127 varchar(12) , 
ef128 varchar(12) , 
ef129 varchar(12) , 
ef130 varchar(12) , 
ef131 varchar(12) , 
ef132 varchar(12) , 
ef133 varchar(12) , 
ef134 varchar(12) , 
ef135 varchar(12) , 
ef136 varchar(12) , 
ef137 varchar(12) , 
ef138 varchar(12) , 
ef139 varchar(12) , 
ef140 varchar(12) , 
ef141 varchar(12) , 
ef142u1 varchar(12) , 
ef142u2 varchar(12) , 
ef143 varchar(12) , 
ef144 varchar(12) , 
ef145 varchar(12) , 
ef146 varchar(12) , 
ef147 varchar(12) , 
ef148 varchar(12) , 
ef149 varchar(12) , 
ef150 varchar(12) , 
ef151 varchar(12) , 
ef152 varchar(12) , 
id SERIAL  not null, 
	constraint pk_lab_astat_2015_id primary key (id)

) 
;



comment on table kenn_lab_astat_2015 is 'Statistiktabelle Absolventen zur Lieferung ans STALA (nach altem Format bis 2016)';

comment on column kenn_lab_astat_2015.hs_nr is 'Hochschulnummer';

comment on column kenn_lab_astat_2015.semester is 'Semester';

comment on column kenn_lab_astat_2015.matrikel_nr is 'Matrikelnr.';

comment on column kenn_lab_astat_2015.ef001 is 'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen';

comment on column kenn_lab_astat_2015.ef002 is 'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester';

comment on column kenn_lab_astat_2015.ef003 is 'ef003-Berichtsjahr';

comment on column kenn_lab_astat_2015.ef004 is 'ef004-Hochschule';

comment on column kenn_lab_astat_2015.ef005 is 'ef005-Paginiernummer';

comment on column kenn_lab_astat_2015.ef006 is 'ef006-Matrikelnummer';

comment on column kenn_lab_astat_2015.ef007 is 'ef007-Geschlecht 1 = mnnlich 2 = weiblich';

comment on column kenn_lab_astat_2015.ef008u1 is 'ef008u1-Geburtsdatum - Monat';

comment on column kenn_lab_astat_2015.ef008u2 is 'ef008u2-Geburtsdatum - Jahr';

comment on column kenn_lab_astat_2015.ef009 is 'ef009-Staatsangehrigkeit';

comment on column kenn_lab_astat_2015.ef010u1 is 'ef010u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat_2015.ef010u2 is 'ef010u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_lab_astat_2015.ef011u1 is 'ef011u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat_2015.ef011u2 is 'ef011u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_lab_astat_2015.ef012 is 'ef012-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat';

comment on column kenn_lab_astat_2015.ef013 is 'ef013-Frei fr StL';

comment on column kenn_lab_astat_2015.ef014 is 'ef014-Frei fr StL';

comment on column kenn_lab_astat_2015.ef015 is 'ef015-Frei fr StL';

comment on column kenn_lab_astat_2015.ef016 is 'ef016-Hochschule der Ersteinschreibung';

comment on column kenn_lab_astat_2015.ef017 is 'ef017-Ersteinschreibung in Deutschland/Semester';

comment on column kenn_lab_astat_2015.ef018 is 'ef018-Jahr der Ersteinschreibung';

comment on column kenn_lab_astat_2015.ef019 is 'ef019-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt';

comment on column kenn_lab_astat_2015.ef020 is 'ef020-Urlaubssemester';

comment on column kenn_lab_astat_2015.ef021 is 'ef021-Praxissemester';

comment on column kenn_lab_astat_2015.ef022 is 'ef022-- Semester in der DDR bzw. Berlin (Ost) (einschl. Urlaubssemester)';

comment on column kenn_lab_astat_2015.ef023 is 'ef023-Nur bei Studium in der DDR bzw. Berlin (Ost) Art des Studiums 1 = Prsenzstudium 2 = Fernstudium';

comment on column kenn_lab_astat_2015.ef024 is 'ef024-Semester am Studienkolleg';

comment on column kenn_lab_astat_2015.ef025 is 'ef025-Anzahl der Unterbrechungssemester insgesamt';

comment on column kenn_lab_astat_2015.ef026 is 'ef026-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_lab_astat_2015.ef027 is 'ef027-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_lab_astat_2015.ef028 is 'ef028-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_lab_astat_2015.ef029 is 'ef029-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_lab_astat_2015.ef030 is 'ef030-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat_2015.ef031u1 is 'ef031u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_lab_astat_2015.ef031u2 is 'ef031u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_lab_astat_2015.ef032 is 'ef032-1. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat_2015.ef033 is 'ef033-Frei fr StL';

comment on column kenn_lab_astat_2015.ef034 is 'ef034-2. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat_2015.ef035 is 'ef035-Frei fr StL';

comment on column kenn_lab_astat_2015.ef036 is 'ef036-3. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat_2015.ef037 is 'ef037-Frei fr StL';

comment on column kenn_lab_astat_2015.ef038 is 'ef038-Frei fr StL';

comment on column kenn_lab_astat_2015.ef039 is 'ef039-Frei fr StL';

comment on column kenn_lab_astat_2015.ef040 is 'ef040-Frei fr StL';

comment on column kenn_lab_astat_2015.ef041 is 'ef041-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_lab_astat_2015.ef042 is 'ef042-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_lab_astat_2015.ef043 is 'ef043-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_lab_astat_2015.ef044 is 'ef044-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_lab_astat_2015.ef045 is 'ef045-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat_2015.ef046u1 is 'ef046u1-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Studienform';

comment on column kenn_lab_astat_2015.ef046u2 is 'ef046u2-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Abschluss';

comment on column kenn_lab_astat_2015.ef047 is 'ef047-1. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat_2015.ef048 is 'ef048-Frei fr StL';

comment on column kenn_lab_astat_2015.ef049 is 'ef049-2. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat_2015.ef050 is 'ef050-Frei fr StL';

comment on column kenn_lab_astat_2015.ef051 is 'ef051-3. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat_2015.ef052 is 'ef052-Frei fr StL';

comment on column kenn_lab_astat_2015.ef053 is 'ef053-Frei fr StL';

comment on column kenn_lab_astat_2015.ef054 is 'ef054-Frei fr StL';

comment on column kenn_lab_astat_2015.ef055 is 'ef055-Frei fr StL';

comment on column kenn_lab_astat_2015.ef056 is 'ef056-Hochschule (bei Einschreibung an einer anderen HS im Berichtssemester)';

comment on column kenn_lab_astat_2015.ef057 is 'ef057-Frei fr StL';

comment on column kenn_lab_astat_2015.ef058 is 'ef058-Frei fr StL';

comment on column kenn_lab_astat_2015.ef059u1 is 'ef059u1-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Studienform';

comment on column kenn_lab_astat_2015.ef059u2 is 'ef059u2-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Abschluss';

comment on column kenn_lab_astat_2015.ef060 is 'ef060-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat_2015.ef061 is 'ef061-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat_2015.ef062 is 'ef062-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat_2015.ef063 is 'ef063-Frei fr StL';

comment on column kenn_lab_astat_2015.ef064 is 'ef064-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen';

comment on column kenn_lab_astat_2015.ef065 is 'ef065-Studiengang gleich dem Berichtssemster?';

comment on column kenn_lab_astat_2015.ef066 is 'ef066-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat_2015.ef067 is 'ef067-Frei fr StL';

comment on column kenn_lab_astat_2015.ef068 is 'ef068-Frei fr StL';

comment on column kenn_lab_astat_2015.ef069u2 is 'ef069u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Studienform';

comment on column kenn_lab_astat_2015.ef069u1 is 'ef069u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Abschluss';

comment on column kenn_lab_astat_2015.ef070 is 'ef070-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat_2015.ef071 is 'ef071-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat_2015.ef072 is 'ef072-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat_2015.ef073 is 'ef073-Frei fr StL';

comment on column kenn_lab_astat_2015.ef074 is 'ef074-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat_2015.ef075 is 'ef075-Frei fr StL';

comment on column kenn_lab_astat_2015.ef076 is 'ef076-Frei fr StL';

comment on column kenn_lab_astat_2015.ef077u1 is 'ef077u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Studienform';

comment on column kenn_lab_astat_2015.ef077u2 is 'ef077u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Abschluss';

comment on column kenn_lab_astat_2015.ef078 is 'ef078-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat_2015.ef079 is 'ef079-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat_2015.ef080 is 'ef080-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat_2015.ef081 is 'ef081-Frei fr StL';

comment on column kenn_lab_astat_2015.ef082 is 'ef082-1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_lab_astat_2015.ef083 is 'ef083-Monate im 1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_lab_astat_2015.ef084 is 'ef084-Frei fr StL';

comment on column kenn_lab_astat_2015.ef085 is 'ef085-2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_lab_astat_2015.ef086 is 'ef086-Monate im 2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_lab_astat_2015.ef087 is 'ef087-Frei fr StL';

comment on column kenn_lab_astat_2015.ef088 is 'ef088-Frei fr StL';

comment on column kenn_lab_astat_2015.ef089 is 'ef089-Frei fr StL';

comment on column kenn_lab_astat_2015.ef090 is 'ef090-Frei fr StL';

comment on column kenn_lab_astat_2015.ef091u1 is 'ef091u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Studienform';

comment on column kenn_lab_astat_2015.ef091u2 is 'ef091u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Abschluss';

comment on column kenn_lab_astat_2015.ef092 is 'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat_2015.ef093 is 'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat_2015.ef094 is 'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat_2015.ef095 is 'ef095-Frei fr StL';

comment on column kenn_lab_astat_2015.ef096 is 'ef096-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat_2015.ef097 is 'ef097-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat_2015.ef098 is 'ef098-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_lab_astat_2015.ef099 is 'ef099-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00';

comment on column kenn_lab_astat_2015.ef100u1 is 'ef100u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Studienform';

comment on column kenn_lab_astat_2015.ef100u2 is 'ef100u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Abschluss';

comment on column kenn_lab_astat_2015.ef101 is 'ef101-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat_2015.ef102 is 'ef102-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat_2015.ef103 is 'ef103-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat_2015.ef104 is 'ef104-Frei fr StL';

comment on column kenn_lab_astat_2015.ef105 is 'ef105-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat_2015.ef106 is 'ef106-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat_2015.ef107 is 'ef107-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_lab_astat_2015.ef108 is 'ef108-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00';

comment on column kenn_lab_astat_2015.ef109 is 'ef109-Jahr des ersten Erwerbs der HZB';

comment on column kenn_lab_astat_2015.ef110 is 'ef110-Art der HZB';

comment on column kenn_lab_astat_2015.ef111u1 is 'ef111u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat_2015.ef111u2 is 'ef111u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)';

comment on column kenn_lab_astat_2015.ef112 is 'ef112-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER';

comment on column kenn_lab_astat_2015.ef113 is 'ef113-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER';

comment on column kenn_lab_astat_2015.ef114 is 'ef114-Frei fr StL';

comment on column kenn_lab_astat_2015.ef115 is 'ef115-Frei fr StL';

comment on column kenn_lab_astat_2015.ef116 is 'ef116-Frei fr StL';

comment on column kenn_lab_astat_2015.ef117 is 'ef117-Frei fr StL';

comment on column kenn_lab_astat_2015.ef118 is 'ef118-Frei fr StL';

comment on column kenn_lab_astat_2015.ef119 is 'ef119-Frei fr StL';

comment on column kenn_lab_astat_2015.ef120 is 'ef120-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef121 is 'ef121-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef122 is 'ef122-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef123 is 'ef123-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_lab_astat_2015.ef124 is 'ef124-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_lab_astat_2015.ef125 is 'ef125-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_lab_astat_2015.ef126u1 is 'ef126u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Studienform';

comment on column kenn_lab_astat_2015.ef126u2 is 'ef126u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Abschluss';

comment on column kenn_lab_astat_2015.ef127 is 'ef127-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef128 is 'ef128-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef129 is 'ef129-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef130 is 'ef130-Frei fr StL';

comment on column kenn_lab_astat_2015.ef131 is 'ef131-Frei fr StL';

comment on column kenn_lab_astat_2015.ef132 is 'ef132-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef133 is 'ef133-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef134 is 'ef134-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef135 is 'ef135-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00';

comment on column kenn_lab_astat_2015.ef136 is 'ef136-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef137 is 'ef137-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef138 is 'ef138-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef139 is 'ef139-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_lab_astat_2015.ef140 is 'ef140-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_lab_astat_2015.ef141 is 'ef141-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_lab_astat_2015.ef142u1 is 'ef142u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform';

comment on column kenn_lab_astat_2015.ef142u2 is 'ef142u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss';

comment on column kenn_lab_astat_2015.ef143 is 'ef143-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef144 is 'ef144-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef145 is 'ef145-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef146 is 'ef146-Frei fr StL';

comment on column kenn_lab_astat_2015.ef147 is 'ef147-Frei fr StL';

comment on column kenn_lab_astat_2015.ef148 is 'ef148-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef149 is 'ef149-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef150 is 'ef150-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef151 is 'ef151-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00';

comment on column kenn_lab_astat_2015.ef152 is 'ef152-Gesamtnote in Punkten bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

</#if>
delete from db_tabellen where name='kenn_lab_astat_2015';
insert into db_tabellen (name,protokollierung) values('kenn_lab_astat_2015',0);

<#if !deleted_tables?seq_contains("kenn_kennz_aggr") && tables?is_sequence && tables?seq_contains("kenn_kennz_aggr") >


select now(), 'table kenn_kennz_aggr exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_kennz_aggr';

create table kenn_kennz_aggr(
	hs_nr INTEGER , 
report_id CHAR(40)  not null, 
katalog_id CHAR(100)  not null, 
parent_katalog_id CHAR(100) , 
katalog_id_beschreibung TEXT , 
hochschulart CHAR(10) , 
zeitraum_int INTEGER , 
bezugszeit INTEGER , 
bezugsart CHAR(1) , 
ebene SMALLINT , 
ord_nr SMALLINT , 
ord_nr_2 SMALLINT , 
is_sub SMALLINT , 
sub_1_caption VARCHAR(255) , 
sub_1_key VARCHAR(255) , 
sub_1_name VARCHAR(255) , 
sub_2_caption VARCHAR(255) , 
sub_2_key VARCHAR(255) , 
sub_2_name VARCHAR(255) , 
betrag double precision , 
einheit CHAR(255) 
) 
;



comment on column kenn_kennz_aggr.report_id is 'ID des Reports';

</#if>
delete from db_tabellen where name='kenn_kennz_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_kennz_aggr',0);

<#if !deleted_tables?seq_contains("kenn_prom_astat") && tables?is_sequence && tables?seq_contains("kenn_prom_astat") >


select now(), 'table kenn_prom_astat exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_prom_astat';

create table kenn_prom_astat(
	hs_nr INTEGER , 
berichtseinheitid VARCHAR(8) , 
ef001 INTEGER , 
ef002 INTEGER , 
ef003 VARCHAR(255) , 
ef004 VARCHAR(255) , 
ef005 INTEGER , 
ef006u1 INTEGER , 
ef006u2 INTEGER , 
ef006u3 INTEGER , 
ef007 VARCHAR(255) , 
ef008 INTEGER , 
ef009 INTEGER , 
ef010 INTEGER , 
ef011 CHAR(4) , 
ef012 INTEGER , 
ef013u1 INTEGER , 
ef013u2 INTEGER , 
ef014u1 INTEGER , 
ef014u2 INTEGER , 
ef015 INTEGER , 
ef016 INTEGER , 
ef017 INTEGER , 
ef018 INTEGER , 
ef019 VARCHAR(255) , 
ef020 INTEGER , 
ef021 INTEGER , 
ef022 INTEGER , 
ef023 INTEGER , 
ef024 VARCHAR(255) , 
ef025 INTEGER , 
ef026 CHAR(3) , 
ef027 CHAR(4) , 
ef028 INTEGER , 
ef029 INTEGER , 
ef030 INTEGER , 
ef031 INTEGER , 
ef032 VARCHAR(255) , 
ef033u1 INTEGER , 
ef033u2 INTEGER , 
ef034 VARCHAR(255) , 
ef035 VARCHAR(255) , 
ef036 VARCHAR(255) , 
ef037 VARCHAR(255) , 
ef038 VARCHAR(255) 
) 
;



comment on table kenn_prom_astat is 'Tabelle zum Import der Lieferung der Promovierenden ans STALA';

comment on column kenn_prom_astat.hs_nr is 'Hochschulnummer';

comment on column kenn_prom_astat.berichtseinheitid is 'Berichtseinheit ID';

comment on column kenn_prom_astat.ef001 is 'Berichtsland';

comment on column kenn_prom_astat.ef002 is 'Berichtsjahr';

comment on column kenn_prom_astat.ef003 is 'Hochschule der Promotion';

comment on column kenn_prom_astat.ef004 is 'Paginiernummer';

comment on column kenn_prom_astat.ef005 is 'Geschlecht';

comment on column kenn_prom_astat.ef006u1 is 'Geburtsdatum - Tag';

comment on column kenn_prom_astat.ef006u2 is 'Geburtsdatum - Monat';

comment on column kenn_prom_astat.ef006u3 is 'Geburtsdatum - Jahr';

comment on column kenn_prom_astat.ef007 is 'Name';

comment on column kenn_prom_astat.ef008 is 'Staatsangehrigkeit';

comment on column kenn_prom_astat.ef009 is 'weitere Staatsangehrigkeit';

comment on column kenn_prom_astat.ef010 is 'Art der Promotion';

comment on column kenn_prom_astat.ef011 is 'Promotionsfach';

comment on column kenn_prom_astat.ef012 is 'Art der Registrierung als Promovierender';

comment on column kenn_prom_astat.ef013u1 is 'Promotionsbeginn Monat';

comment on column kenn_prom_astat.ef013u2 is 'Promotionsbeginn Jahr';

comment on column kenn_prom_astat.ef014u1 is 'Promotionsende Monat';

comment on column kenn_prom_astat.ef014u2 is 'Promotionsende Jahr';

comment on column kenn_prom_astat.ef015 is 'Immatrikulation';

comment on column kenn_prom_astat.ef016 is 'Teilnahme an einem strukturierenden Promotionsprogramm';

comment on column kenn_prom_astat.ef017 is 'Beschftigungsverhltnis an der Hochschule der Promotion';

comment on column kenn_prom_astat.ef018 is 'Art der Dissertation';

comment on column kenn_prom_astat.ef019 is 'Hochschule (Ersteinschreibung)';

comment on column kenn_prom_astat.ef020 is 'Staat der Hochschule';

comment on column kenn_prom_astat.ef021 is 'Semester';

comment on column kenn_prom_astat.ef022 is 'Jahr';

comment on column kenn_prom_astat.ef023 is 'Zur Promotion berechtigende Abschlussprfung';

comment on column kenn_prom_astat.ef024 is 'Hochschule';

comment on column kenn_prom_astat.ef025 is 'Vorherige Hochschule Staat';

comment on column kenn_prom_astat.ef026 is 'Art der Prfung';

comment on column kenn_prom_astat.ef027 is '1. Studienfach';

comment on column kenn_prom_astat.ef028 is 'Monat des Prfungsabschlusses';

comment on column kenn_prom_astat.ef029 is 'Jahr des Prfungsabschlusses';

comment on column kenn_prom_astat.ef030 is 'Gesamtnote';

comment on column kenn_prom_astat.ef031 is 'Jahr des Erwerbs einer HZB';

comment on column kenn_prom_astat.ef032 is 'Art der ersten HZB';

comment on column kenn_prom_astat.ef033u1 is 'Land der ersten HZB';

comment on column kenn_prom_astat.ef033u2 is 'Kreis/Staat der ersten HZB';

comment on column kenn_prom_astat.ef034 is 'frei fr landesinterne Angaben';

comment on column kenn_prom_astat.ef035 is 'frei fr landesinterne Angaben';

comment on column kenn_prom_astat.ef036 is 'frei fr landesinterne Angaben';

comment on column kenn_prom_astat.ef037 is 'frei fr landesinterne Angaben';

comment on column kenn_prom_astat.ef038 is 'frei fr landesinterne Angaben';

</#if>
delete from db_tabellen where name='kenn_prom_astat';
insert into db_tabellen (name,protokollierung) values('kenn_prom_astat',0);

<#if !deleted_tables?seq_contains("kenn_abschl_pruef_grp") && tables?is_sequence && tables?seq_contains("kenn_abschl_pruef_grp") >


select now(), 'table kenn_abschl_pruef_grp exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_abschl_pruef_grp';

create table kenn_abschl_pruef_grp(
	astat CHAR(10) , 
pruef_grp CHAR(10) 
) 
;



comment on table kenn_abschl_pruef_grp is 'Verzeichnis der externen Prfungsgruppen';

comment on column kenn_abschl_pruef_grp.astat is 'Amtlicher Schlssel Abschluss';

comment on column kenn_abschl_pruef_grp.pruef_grp is 'Prfungsgruppe Schlssel';

</#if>
delete from db_tabellen where name='kenn_abschl_pruef_grp';
insert into db_tabellen (name,protokollierung) values('kenn_abschl_pruef_grp',0);

<#if !deleted_tables?seq_contains("kenn_stelle_bvl_bez") && tables?is_sequence && tables?seq_contains("kenn_stelle_bvl_bez") >


select now(), 'table kenn_stelle_bvl_bez exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stelle_bvl_bez';

create table kenn_stelle_bvl_bez(
	id SERIAL  not null, 
sortnr integer , 
kapitel VARCHAR(255) , 
titel VARCHAR(255) , 
bez VARCHAR(255) , 
bvl_stelle_kurz VARCHAR(255) , 
hs_nr INTEGER , 
bez_hs VARCHAR(255) , 
adbz_land VARCHAR(255) , 
optional INTEGER , 
zeilenkontext VARCHAR(255) , 
gueltig_von DATE , 
gueltig_bis DATE , 
	constraint pk_kenn_stelle_bvl_bez primary key (id)

) 
;



comment on column kenn_stelle_bvl_bez.kapitel is 'Kapitel';

comment on column kenn_stelle_bvl_bez.titel is 'Titel';

comment on column kenn_stelle_bvl_bez.bez is 'Bezeichnung (hochschulunabhngig)';

comment on column kenn_stelle_bvl_bez.bvl_stelle_kurz is 'Kurztext der BVL-Gruppe';

comment on column kenn_stelle_bvl_bez.hs_nr is 'Hochschulnummer';

comment on column kenn_stelle_bvl_bez.bez_hs is 'Bezeichnung der Stellengruppe an der jew. Hochschule';

comment on column kenn_stelle_bvl_bez.adbz_land is 'Untergruppierung der BVL-Gruppe';

comment on column kenn_stelle_bvl_bez.optional is 'Zeile optional im STBB?';

comment on column kenn_stelle_bvl_bez.zeilenkontext is 'Zeilen innerhalb werden wei formatiert, Zeilen auserhalb grau. Innerhalb bedeutet --> zwischen Zeilen, welche in der gewhlten Berichtsart Stellen ausweisen.';

comment on column kenn_stelle_bvl_bez.gueltig_von is 'Gltig von';

comment on column kenn_stelle_bvl_bez.gueltig_bis is 'Gltig bis';

</#if>
delete from db_tabellen where name='kenn_stelle_bvl_bez';
insert into db_tabellen (name,protokollierung) values('kenn_stelle_bvl_bez',0);

<#if !deleted_tables?seq_contains("kenn_stelle_hhpl") && tables?is_sequence && tables?seq_contains("kenn_stelle_hhpl") >


select now(), 'table kenn_stelle_hhpl exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stelle_hhpl';

create table kenn_stelle_hhpl(
	kapitel CHAR(10) , 
titel CHAR(10) , 
hs_nr INTEGER , 
bvl_stelle_kurz VARCHAR(255) , 
adbz_land VARCHAR(255) , 
summe FLOAT , 
jahr_von INTEGER , 
jahr_bis INTEGER , 
datum date 
) 
;



comment on column kenn_stelle_hhpl.kapitel is 'Kapitel';

comment on column kenn_stelle_hhpl.titel is 'Titel der Stelle';

comment on column kenn_stelle_hhpl.hs_nr is 'Hochschulnummer';

comment on column kenn_stelle_hhpl.bvl_stelle_kurz is 'Kurztext der BVL-Gruppe';

comment on column kenn_stelle_hhpl.adbz_land is 'Untergruppierung der BVL-Gruppe';

comment on column kenn_stelle_hhpl.summe is 'Summe';

comment on column kenn_stelle_hhpl.jahr_von is 'Jahr von';

comment on column kenn_stelle_hhpl.jahr_bis is 'Jahr bis';

comment on column kenn_stelle_hhpl.datum is 'Datum der Berechnung';

</#if>
delete from db_tabellen where name='kenn_stelle_hhpl';
insert into db_tabellen (name,protokollierung) values('kenn_stelle_hhpl',0);

<#if !deleted_tables?seq_contains("kenn_stbb_kap_titel_bericht") && tables?is_sequence && tables?seq_contains("kenn_stbb_kap_titel_bericht") >


select now(), 'table kenn_stbb_kap_titel_bericht exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stbb_kap_titel_bericht';

create table kenn_stbb_kap_titel_bericht(
	hs_nr INTEGER , 
kapitel VARCHAR(255) , 
titel VARCHAR(255) , 
berichtsname VARCHAR(255) , 
berichtsname_key VARCHAR(255) 
) 
;



comment on column kenn_stbb_kap_titel_bericht.hs_nr is 'Hochschulnummer';

comment on column kenn_stbb_kap_titel_bericht.kapitel is 'Kapitel';

comment on column kenn_stbb_kap_titel_bericht.titel is 'Titel';

comment on column kenn_stbb_kap_titel_bericht.berichtsname is 'Berichtsname';

comment on column kenn_stbb_kap_titel_bericht.berichtsname_key is 'Berichtsname (Schlssel)';

</#if>
delete from db_tabellen where name='kenn_stbb_kap_titel_bericht';
insert into db_tabellen (name,protokollierung) values('kenn_stbb_kap_titel_bericht',0);

<#if !deleted_tables?seq_contains("kenn_rpt_ansprech") && tables?is_sequence && tables?seq_contains("kenn_rpt_ansprech") >


select now(), 'table kenn_rpt_ansprech exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_rpt_ansprech';

create table kenn_rpt_ansprech(
	tid SERIAL  not null, 
hs_nr INTEGER , 
report_id CHAR(10)  not null, 
name VARCHAR(255) , 
vorname VARCHAR(255) , 
email VARCHAR(255) , 
telefon VARCHAR(255) , 
exportieren CHAR(1)  default '1' , 
	constraint pk_kenn_rpt_ansprech primary key (tid)

) 
;



comment on column kenn_rpt_ansprech.hs_nr is 'Hochschule';

comment on column kenn_rpt_ansprech.report_id is 'Bericht';

comment on column kenn_rpt_ansprech.name is 'Nachname';

comment on column kenn_rpt_ansprech.vorname is 'Vorname';

comment on column kenn_rpt_ansprech.email is 'Email';

comment on column kenn_rpt_ansprech.telefon is 'Telefon';

comment on column kenn_rpt_ansprech.exportieren is 'Exportieren?';

</#if>
delete from db_tabellen where name='kenn_rpt_ansprech';
insert into db_tabellen (name,protokollierung) values('kenn_rpt_ansprech',0);

<#if !deleted_tables?seq_contains("kenn_rpt_version") && tables?is_sequence && tables?seq_contains("kenn_rpt_version") >


select now(), 'table kenn_rpt_version exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_rpt_version';

create table kenn_rpt_version(
	tid SERIAL  not null, 
report_id CHAR(40)  not null, 
defaulttext VARCHAR(255) , 
uniquename VARCHAR(255) , 
version_comment TEXT , 
ordinal_number INTEGER , 
release_version VARCHAR(255) , 
valid_from DATE , 
valid_to DATE , 
	constraint pk_kenn_rpt_version primary key (tid)

) 
;



comment on column kenn_rpt_version.report_id is 'Bericht';

comment on column kenn_rpt_version.defaulttext is 'Name';

comment on column kenn_rpt_version.uniquename is 'Schlssel';

comment on column kenn_rpt_version.version_comment is 'Kommentar';

comment on column kenn_rpt_version.ordinal_number is 'Version (numerisch)';

comment on column kenn_rpt_version.release_version is 'Paket-Version';

comment on column kenn_rpt_version.valid_from is 'Gltig von';

comment on column kenn_rpt_version.valid_to is 'Gltig bis';

</#if>
delete from db_tabellen where name='kenn_rpt_version';
insert into db_tabellen (name,protokollierung) values('kenn_rpt_version',0);

<#if !deleted_tables?seq_contains("kenn_stylesheet_version") && tables?is_sequence && tables?seq_contains("kenn_stylesheet_version") >


select now(), 'table kenn_stylesheet_version exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_stylesheet_version';

create table kenn_stylesheet_version(
	tid SERIAL  not null, 
stylesheet_id INTEGER  not null, 
rpt_version_id INTEGER  not null, 
	constraint pk_kenn_stylesheet_version primary key (tid)

) 
;



comment on column kenn_stylesheet_version.stylesheet_id is 'Stylesheet';

comment on column kenn_stylesheet_version.rpt_version_id is 'Version';

</#if>
delete from db_tabellen where name='kenn_stylesheet_version';
insert into db_tabellen (name,protokollierung) values('kenn_stylesheet_version',0);

<#if !deleted_tables?seq_contains("kenn_zsl_ausgleich_kennungen") && tables?is_sequence && tables?seq_contains("kenn_zsl_ausgleich_kennungen") >


select now(), 'table kenn_zsl_ausgleich_kennungen exists - fine';


<#else>


select now(), 'Erzeuge Tabelle kenn_zsl_ausgleich_kennungen';

create table kenn_zsl_ausgleich_kennungen(
	astat CHAR(3)  not null, 
studienart TEXT  not null, 
kennung_stud_hs1 SMALLINT  not null, 
kennung_stud_rsz2 SMALLINT  not null, 
kennung_absolv SMALLINT  not null, 
faktor FLOAT  not null
) 
;



comment on column kenn_zsl_ausgleich_kennungen.studienart is 'Studienart';

</#if>
delete from db_tabellen where name='kenn_zsl_ausgleich_kennungen';
insert into db_tabellen (name,protokollierung) values('kenn_zsl_ausgleich_kennungen',0);
 -- update primary keys, see ticket: #296420 
alter table if exists kenn_stichtag drop constraint if exists kenn_stichtag_pkey;
alter table if exists kenn_stichtag drop constraint if exists c_kenn_stich_tid;
alter table if exists kenn_hochschulen drop constraint if exists kenn_hochschulen_pkey;
alter table if exists kenn_hochschulen drop constraint if exists k_hochschulen;
alter table if exists kenn_inst drop constraint if exists kenn_inst_pkey;
alter table if exists kenn_inst drop constraint if exists u420_349;
alter table if exists kenn_lfb_fg drop constraint if exists kenn_lfb_fg_pkey;
alter table if exists kenn_lfb_fg drop constraint if exists pk_kenn_lfb_fg;
alter table if exists kenn_cifx drop constraint if exists kenn_cifx_pkey;
alter table if exists kenn_cifx drop constraint if exists c_kenn_cifx_tid;
alter table if exists kenn_pruefrout drop constraint if exists kenn_pruefrout_pkey;
alter table if exists kenn_pruefrout drop constraint if exists c_kenn_pruef_tid;
alter table if exists kenn_sb_astfr_lfb drop constraint if exists kenn_sb_astfr_lfb_pkey;
alter table if exists kenn_sb_astfr_lfb drop constraint if exists c_kenn_sb_fr_lfb;
alter table if exists kenn_sichten drop constraint if exists kenn_sichten_pkey;
alter table if exists kenn_sichten drop constraint if exists c_kenn_sichten;
alter table if exists kenn_zahl_wert drop constraint if exists kenn_zahl_wert_pkey;
alter table if exists kenn_zahl_wert drop constraint if exists c_kenn_zahl_wert;
alter table if exists kenn_katalog drop constraint if exists kenn_katalog_pkey;
alter table if exists kenn_katalog drop constraint if exists c_kenn_katalog;
alter table if exists kenn_katalog_rpt drop constraint if exists kenn_katalog_rpt_pkey;
alter table if exists kenn_katalog_rpt drop constraint if exists c_kenn_katalog_r;
alter table if exists kenn_katalog_grp drop constraint if exists kenn_katalog_grp_pkey;
alter table if exists kenn_katalog_grp drop constraint if exists c_kenn_katalog_grp;
alter table if exists kenn_katalog_sub drop constraint if exists kenn_katalog_sub_pkey;
alter table if exists kenn_katalog_sub drop constraint if exists c_kenn_katalog_sub;
alter table if exists kenn_vari drop constraint if exists kenn_vari_pkey;
alter table if exists kenn_vari drop constraint if exists c_kenn_vari_r;
alter table if exists kenn_hzbart_astat drop constraint if exists kenn_hzbart_astat_pkey;
alter table if exists kenn_hzbart_astat drop constraint if exists c_khzbart_astat_tid;
alter table if exists kenn_stufrm drop constraint if exists kenn_stufrm_pkey;
alter table if exists kenn_stufrm drop constraint if exists c_kenn_stufrm_tid;
alter table if exists kenn_stuart drop constraint if exists kenn_stuart_pkey;
alter table if exists kenn_stuart drop constraint if exists c_kenn_stuart_tid;
alter table if exists kenn_stort drop constraint if exists kenn_stort_pkey;
alter table if exists kenn_stort drop constraint if exists c_kenn_stort_tid;
alter table if exists kenn_abschl_sbereich drop constraint if exists kenn_abschl_sbereich_pkey;
alter table if exists kenn_abschl_sbereich drop constraint if exists c_kenn_abschl_sbereich;
alter table if exists kenn_extkotr_stg drop constraint if exists kenn_extkotr_stg_pkey;
alter table if exists kenn_extkotr_stg drop constraint if exists c_kenn_extkotr_stg;
alter table if exists kenn_fibu_wiplan drop constraint if exists kenn_fibu_wiplan_pkey;
alter table if exists kenn_fibu_wiplan drop constraint if exists id_kenn_fibu_wipla2;
alter table if exists kenn_zulzahl_id drop constraint if exists kenn_zulzahl_id_pkey;
alter table if exists kenn_zulzahl_id drop constraint if exists pk_kenn_zulzahl_id_id;
alter table if exists kenn_zulzahl_sem drop constraint if exists kenn_zulzahl_sem_pkey;
alter table if exists kenn_zulzahl_sem drop constraint if exists pk_kenn_zulzahl_sem;
alter table if exists kenn_zulzahl2int drop constraint if exists kenn_zulzahl2int_pkey;
alter table if exists kenn_zulzahl2int drop constraint if exists pk_kenn_zulzahl2int_tid;
alter table if exists kenn_report_stichtagsart drop constraint if exists kenn_report_stichtagsart_pkey;
alter table if exists kenn_report_stichtagsart drop constraint if exists c_kenn_report_sticht;
alter table if exists kenn_bestandsart drop constraint if exists kenn_bestandsart_pkey;
alter table if exists kenn_bestandsart drop constraint if exists c_kenn_bestandsart;
alter table if exists kenn_bestandsart_bland drop constraint if exists kenn_bestandsart_bland_pkey;
alter table if exists kenn_bestandsart_bland drop constraint if exists c_kenn_bestandsart_bland;
alter table if exists kenn_stichtagsart drop constraint if exists kenn_stichtagsart_pkey;
alter table if exists kenn_stichtagsart drop constraint if exists c_kenn_stichtagsart;
alter table if exists kenn_dim_fgr drop constraint if exists kenn_dim_fgr_pkey;
alter table if exists kenn_dim_fgr drop constraint if exists c_kenn_dim_fgr_apnr;
alter table if exists kenn_sos_astat_2015 drop constraint if exists kenn_sos_astat_2015_pkey;
alter table if exists kenn_sos_astat_2015 drop constraint if exists pk_sos_astat_2015_id;
alter table if exists kenn_lab_astat_2015 drop constraint if exists kenn_lab_astat_2015_pkey;
alter table if exists kenn_lab_astat_2015 drop constraint if exists pk_lab_astat_2015_id;
alter table if exists kenn_stelle_bvl_bez drop constraint if exists kenn_stelle_bvl_bez_pkey;
alter table if exists kenn_stelle_bvl_bez drop constraint if exists pk_kenn_stelle_bvl_bez;
alter table if exists kenn_rpt_ansprech drop constraint if exists kenn_rpt_ansprech_pkey;
alter table if exists kenn_rpt_ansprech drop constraint if exists pk_kenn_rpt_ansprech;
alter table if exists kenn_rpt_version drop constraint if exists kenn_rpt_version_pkey;
alter table if exists kenn_rpt_version drop constraint if exists pk_kenn_rpt_version;
alter table if exists kenn_stylesheet_version drop constraint if exists kenn_stylesheet_version_pkey;
alter table if exists kenn_stylesheet_version drop constraint if exists pk_kenn_stylesheet_version;
alter table if exists kenn_stichtag add constraint kenn_stichtag_pkey  primary key (tid);
alter table if exists kenn_hochschulen add constraint kenn_hochschulen_pkey  primary key (hs_nr);
alter table if exists kenn_inst add constraint kenn_inst_pkey  primary key (tid);
alter table if exists kenn_lfb_fg add constraint kenn_lfb_fg_pkey  primary key (tid);
alter table if exists kenn_cifx add constraint kenn_cifx_pkey  primary key (tid);
alter table if exists kenn_pruefrout add constraint kenn_pruefrout_pkey  primary key (tid);
alter table if exists kenn_sb_astfr_lfb add constraint kenn_sb_astfr_lfb_pkey  primary key (tid);
alter table if exists kenn_sichten add constraint kenn_sichten_pkey  primary key (tid);
alter table if exists kenn_zahl_wert add constraint kenn_zahl_wert_pkey  primary key (tid);
alter table if exists kenn_katalog add constraint kenn_katalog_pkey  primary key (tid);
alter table if exists kenn_katalog_rpt add constraint kenn_katalog_rpt_pkey  primary key (tid);
alter table if exists kenn_katalog_grp add constraint kenn_katalog_grp_pkey  primary key (tid);
alter table if exists kenn_katalog_sub add constraint kenn_katalog_sub_pkey  primary key (tid);
alter table if exists kenn_vari add constraint kenn_vari_pkey  primary key (tid);
alter table if exists kenn_hzbart_astat add constraint kenn_hzbart_astat_pkey  primary key (tid);
alter table if exists kenn_stufrm add constraint kenn_stufrm_pkey  primary key (tid);
alter table if exists kenn_stuart add constraint kenn_stuart_pkey  primary key (tid);
alter table if exists kenn_stort add constraint kenn_stort_pkey  primary key (tid);
alter table if exists kenn_abschl_sbereich add constraint kenn_abschl_sbereich_pkey  primary key (tid);
alter table if exists kenn_extkotr_stg add constraint kenn_extkotr_stg_pkey  primary key (tid);
alter table if exists kenn_fibu_wiplan add constraint kenn_fibu_wiplan_pkey  primary key (hs_nr,id);
alter table if exists kenn_zulzahl_id add constraint kenn_zulzahl_id_pkey  primary key (id);
alter table if exists kenn_zulzahl_sem add constraint kenn_zulzahl_sem_pkey  primary key (tid);
alter table if exists kenn_zulzahl2int add constraint kenn_zulzahl2int_pkey  primary key (tid);
alter table if exists kenn_report_stichtagsart add constraint kenn_report_stichtagsart_pkey  primary key (tid);
alter table if exists kenn_bestandsart add constraint kenn_bestandsart_pkey  primary key (apnr);
alter table if exists kenn_bestandsart_bland add constraint kenn_bestandsart_bland_pkey  primary key (tid);
alter table if exists kenn_stichtagsart add constraint kenn_stichtagsart_pkey  primary key (apnr);
alter table if exists kenn_dim_fgr add constraint kenn_dim_fgr_pkey  primary key (apnr);
alter table if exists kenn_sos_astat_2015 add constraint kenn_sos_astat_2015_pkey  primary key (id);
alter table if exists kenn_lab_astat_2015 add constraint kenn_lab_astat_2015_pkey  primary key (id);
alter table if exists kenn_stelle_bvl_bez add constraint kenn_stelle_bvl_bez_pkey  primary key (id);
alter table if exists kenn_rpt_ansprech add constraint kenn_rpt_ansprech_pkey  primary key (tid);
alter table if exists kenn_rpt_version add constraint kenn_rpt_version_pkey  primary key (tid);
alter table if exists kenn_stylesheet_version add constraint kenn_stylesheet_version_pkey  primary key (tid);
