--freemarker template
<sqlvars>
<sqlvar name="kenn_sos_stg_exists">
select sp_table_exists('kenn_sos_stg') from xdummy;
</sqlvar>
</sqlvars>

<#if kenn_sos_stg_exists=1>

CREATE TABLE kenn_sos_stg_tmp
(
   hs_nr              integer,
   studiengang_nr     smallint,
   fach_nr            smallint,
   geschlecht         smallint,
   ca12_staat         smallint,
   sem_rueck_beur_ein smallint,
   stg                char(4),
   abschluss          char(2),
   regel              smallint,
   hzbart             smallint,
   kz_rueck_beur_ein  smallint,
   fach_sem_zahl      smallint,
   hssem              smallint,
   kz_fach            char(1),
   datum              date,
   summe              integer
);

INSERT INTO kenn_sos_stg_tmp (hs_nr,studiengang_nr,fach_nr,geschlecht,ca12_staat,sem_rueck_beur_ein,stg,abschluss,regel,hzbart,kz_rueck_beur_ein,fach_sem_zahl,hssem,kz_fach,datum,summe)
select hs_nr,studiengang_nr,fach_nr,geschlecht,ca12_staat,sem_rueck_beur_ein,stg,abschluss,regel,hzbart::integer,kz_rueck_beur_ein,fach_sem_zahl,hssem,kz_fach,datum,summe
from kenn_sos_stg;

DROP TABLE kenn_sos_stg;
</#if>

CREATE TABLE kenn_sos_stg
(
   hs_nr              integer,
   studiengang_nr     smallint,
   fach_nr            smallint,
   geschlecht         smallint,
   ca12_staat         smallint,
   sem_rueck_beur_ein smallint,
   stg                char(4)  ,
   abschluss          char(2)  ,
   regel              smallint,
   hzbart             smallint,
   kz_rueck_beur_ein  smallint,
   fach_sem_zahl      smallint,
   hssem              smallint,
   kz_fach            char(1)  ,
   datum              date       ,
   summe              integer
);
CREATE INDEX ixkenn_sos_stg1 ON kenn_sos_stg (hs_nr);
CREATE INDEX ixkenn_sos_stg2 ON kenn_sos_stg (studiengang_nr, fach_nr);
CREATE INDEX ixkenn_sos_stg3 ON kenn_sos_stg (geschlecht, ca12_staat);
CREATE INDEX ixkenn_sos_stg4 ON kenn_sos_stg (sem_rueck_beur_ein);
CREATE INDEX ixkenn_sos_stg5 ON kenn_sos_stg (abschluss);
CREATE INDEX ixkenn_sos_stg6 ON kenn_sos_stg (hzbart);
CREATE INDEX ixkenn_sos_stg7 ON kenn_sos_stg (kz_rueck_beur_ein);
CREATE INDEX ixkenn_sos_stg8 ON kenn_sos_stg (kz_fach);

<#if kenn_sos_stg_exists=1>
INSERT INTO kenn_sos_stg (hs_nr,studiengang_nr,fach_nr,geschlecht,ca12_staat,sem_rueck_beur_ein,stg,abschluss,regel,hzbart,kz_rueck_beur_ein,fach_sem_zahl,hssem,kz_fach,datum,summe)
select hs_nr,studiengang_nr,fach_nr,geschlecht,ca12_staat,sem_rueck_beur_ein,stg,abschluss,regel,hzbart::integer,kz_rueck_beur_ein,fach_sem_zahl,hssem,kz_fach,datum,summe
from kenn_sos_stg_tmp;

DROP TABLE kenn_sos_stg_tmp;
</#if>
