#!/bin/bash

#Upgrade 
NEWVERSION=`cat ../VERSION`
# XML-generiertes Shell-Script fuer Modul kenn

echo "Die aktuell installierte Version des Moduls ist"
if [ "$DATABASE" == "INFORMIX"  ]
	then
DOQUERY "select version from db_version where his_system='kenn';" 2>/dev/null
else
DOQUERY "select version from db_version where his_system='kenn';"
fi

echo "Die zu installierende Version ist $NEWVERSION"

if [ "$1" != "J" ]
then
echo "Fortfahren? (J/N) ? "
	read WEITER
else
WEITER=$1
fi

if [ "$WEITER" != "J" ] 
then 
if [ "$WEITER" != "j" ]
then	echo "Upgrade-Script abgebrochen"
	exit 0
fi
fi

UPDATELOG=$KENN_PFAD/upgrade/upgrade"$MANDANTID".log
echo "Datenbank $DBNAME wird geupdated. Logdatei: $UPDATELOG"
echo "Datenbank $DBNAME wird geupdated." >$UPDATELOG

if [ -f "$KENN_PFAD/upgrade/kenn_pre_upgrade_$DATABASE_ABBR.sql" ] 
then

DOSQL $KENN_PFAD/upgrade/kenn_pre_upgrade_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1

fi

echo "Tabellen prfen" >>$UPDATELOG

DOSQL $KENN_PFAD/upgrade/kenn_upgrade_tables_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1
DOSQL $KENN_PFAD/upgrade/kenn_upgrade_fields_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1

DOSQL $KENN_PFAD/upgrade/kenn_upgrade_views_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1


if [ "$DATABASE" == "INFORMIX"  ]
	then
	echo "speziell fr IDS" >>$UPDATELOG
DOQUERY "drop procedure sp_get_vari_parent(integer);" >/dev/null 2>&1
DOQUERY "drop procedure sp_get_children();" >/dev/null 2>&1
DOQUERY "drop procedure get_akad_jahr(integer, varchar(255));" >/dev/null 2>&1
	
	fi


DOSQL $KENN_PFAD/upgrade/kenn_upgrade_functions_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1
DOSQL $KENN_PFAD/upgrade/kenn_upgrade_indexes_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1
DOSQL $KENN_PFAD/upgrade/kenn_upgrade_themenbaum.sql >>$UPDATELOG 2>&1
$KENN_PFAD/kenn_masken_einspielen_"$DATABASE_ABBR".x >>$UPDATELOG 2>&1

DOSQL $KENN_PFAD/upgrade/kenn_upgrade_"$DATABASE_ABBR".sql >>$UPDATELOG 2>&1


if [ -f "$KENN_PFAD/conf/customize$MANDANTID.sql"  ] 
then

CMD="DOSQL $KENN_PFAD/conf/customize$MANDANTID.sql"
runAndCheck.x $KENN_PFAD "$CMD" CONT_ON_ERROR NO_ERRORMAIL NO_LOGMAIL "kenn Customize$MANDANTID"

fi

if [ -f "$KENN_PFAD/kenn_install_custom.sql"  ] 
then

CMD="DOSQL $KENN_PFAD/kenn_install_custom.sql"
runAndCheck.x $KENN_PFAD "$CMD" CONT_ON_ERROR NO_ERRORMAIL NO_LOGMAIL "kenn Customize_aus_repository$MANDANTID"

fi

if [ "$WEBAPP" == ""  ]
	then
	#in SuperX 3.5 ist webapp immer hier:
WEBAPP=$SUPERX_DIR/webserver/tomcat/webapps/superx

fi

DBFORMS_CONFIG=$WEBAPP/WEB-INF/kenn_dbforms-config_"$DATABASE_ABBR".xml

if [ -f "$DBFORMS_CONFIG"  ]
then

CMD="dbforms-config_upgrade.x $DBFORMS_CONFIG"
runAndCheck.x $SUPERX_DIR/db/bin "$CMD" CONT_ON_ERROR NO_ERRORMAIL NO_LOGMAIL "kenn dbforms-config Upgrade$MANDANTID"

fi 

EDUSTORE_XML=$WEBAPP/WEB-INF/classes/edustore/edustore_kenn.xml

if [ "$EDUSTORE_XML_GENERATE" = "true" -a -f "$EDUSTORE_XML" -a -f "$SUPERX_DIR/db/bin/edustore_xml_upgrade.x" ]
then 
CMD="edustore_xml_upgrade.x $EDUSTORE_XML"
runAndCheck.x $SUPERX_DIR/db/bin "$CMD" CONT_ON_ERROR NO_ERRORMAIL NO_LOGMAIL "sos edustore_xml Upgrade$MANDANTID"
echo "$EDUSTORE_XML wurde aktualisiert."
else
echo "$EDUSTORE_XML wurde nicht aktualisiert."
fi 

fgrep -i -s "fehler" $UPDATELOG
FLAG1=$?
fgrep -i -s "error" $UPDATELOG
FLAG2=$?
fgrep -i -s "could not connect to server" $UPDATELOG
FLAG3=$?

if [ $FLAG1 -eq 0 -o $FLAG2 -eq 0 -o $FLAG3 -eq 0 ]
then
	echo "Fehler beim Upgrade der Datenbank" 
	echo "---------------------------------------" 
	echo "Bitte prfen Sie das Fehlerprotokoll in $UPDATELOG" 
	echo "---------------------------------------" 
	
else

	echo "----------------------------------------" 
	echo "Datenbank $DBNAME erfolgreich geupdated "
	echo "(Keine Fehler aufgefallen in $UPDATELOG)." 
	echo "Bitte starten Sie nun Tomcat neu."
	echo "----------------------------------------" 
fi

