--Freemarker Template 
--Altdaten aus Absol.-Statistik nach kenn_promo_aggr retten:
<sqlvars>
<sqlvar name="jahre" type="hashsequence">
SELECT distinct get_akad_jahr(sem_der_pruefung,'P') as bezugszeit,hs_nr  
 FROM kenn_lab_aggr_astat A
 where A.abschluss in ('06','07','91','92')
 and 0=(select count(*)
from kenn_promo_aggr P
where P.hs_nr=A.hs_nr
and P.jahr=get_akad_jahr(sem_der_pruefung,'P')) 
 ;
</sqlvar>

</sqlvars>
<#if jahre?has_content>
<#foreach jahr in jahre>


--Promotionen aus amtl. Statistik Absolventen, dies ist der Default:
insert into kenn_promo_aggr(
 hs_nr,
       jahr,
       jahr_beginn,
       jahr_ende,
       art_ende,
       koop_land_ausl,
       geschlecht,
       datum,
       extkotr,
       summe
)
 SELECT 
 A.hs_nr,
       ${jahr.bezugszeit},
       get_akad_jahr(sem_der_pruefung,'P') - fach_sem_zahl/2,  --'Promotionsbeginn Jahr'
       get_akad_jahr(sem_der_pruefung,'P') ,-- as jahr_ende,
       (case when pruefung_ergebnis=1 then 'B'
       else 'NB' end ) as art_ende, 
       null::char(1) as    koop_land_ausl,
       geschlecht,-- as geschlecht,
       today(),
       fgr,
       sum(A.summe)

FROM kenn_lab_aggr_astat A 
where  ${jahr.bezugszeit} =get_akad_jahr(A.sem_der_pruefung,'P') --Berichtsjahr
and ${jahr.hs_nr} =A.hs_nr
and A.abschluss in ('06','07','91','92')
group by 1,2,3,4,pruefung_ergebnis,geschlecht,fgr
 ;
 </#foreach>
</#if>


