
--freemarker template
--kenn_pbv_aggr: bund_taetigkeit, bund_dienstart und geschlecht
--werden smallint


select '${SQLdialect}' from xdummy;

<#if SQLdialect='Postgres'>

create temp table tmp_pbv_aggr(
	hs_nr INTEGER , 
geschlecht CHAR(1) , 
bund_fachgebiet CHAR(10) , 
bund_taetigkeit CHAR(10) , 
bund_dienstart CHAR(10) , 
buadbz CHAR(5) , 
klr_geldgeber CHAR(4) , 
kapitel CHAR(5) , 
stichtag DATE , 
zaehlung CHAR(2) , 
datum date , 
summe DECIMAL(10,2) 
);
insert into tmp_pbv_aggr(hs_nr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       klr_geldgeber,
       kapitel,
       stichtag,
       zaehlung,
       datum,
       summe
)
select hs_nr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       klr_geldgeber,
       kapitel,
       stichtag,
       zaehlung,
       datum,
       summe
       from kenn_pbv_aggr;
       
drop table kenn_pbv_aggr;

create table kenn_pbv_aggr(
	hs_nr INTEGER , 
geschlecht SMALLINT , 
bund_fachgebiet CHAR(10) , 
bund_taetigkeit SMALLINT , 
bund_dienstart SMALLINT , 
buadbz CHAR(5) , 
klr_geldgeber CHAR(4) , 
kapitel CHAR(5) , 
stichtag DATE , 
zaehlung CHAR(2) , 
datum date , 
summe DECIMAL(10,2) 
);

insert into kenn_pbv_aggr (hs_nr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       klr_geldgeber,
       kapitel,
       stichtag,
       zaehlung,
       datum,
       summe
)
select hs_nr,
       val(geschlecht),
       bund_fachgebiet,
       val(bund_taetigkeit),
       val(bund_dienstart),
       buadbz,
       klr_geldgeber,
       kapitel,
       stichtag,
       zaehlung,
       datum,
       summe
       from tmp_pbv_aggr;
       
drop table tmp_pbv_aggr;

create  index ixkenn_pbv_aggr1 on kenn_pbv_aggr (hs_nr );

create  index ixkenn_pbv_aggr2 on kenn_pbv_aggr (bund_fachgebiet, 
bund_taetigkeit );

create  index ixkenn_pbv_aggr3 on kenn_pbv_aggr (geschlecht );

create  index ixkenn_pbv_aggr4 on kenn_pbv_aggr (buadbz );

create  index ixkenn_pbv_aggr5 on kenn_pbv_aggr (klr_geldgeber );

create  index ixkenn_pbv_aggr6 on kenn_pbv_aggr (kapitel );

create  index ixkenn_pbv_aggr7 on kenn_pbv_aggr (stichtag );

create  index ixkenn_pbv_aggr8 on kenn_pbv_aggr (zaehlung );

</#if>

<#if SQLdialect='Informix'>

alter table kenn_pbv_aggr modify (geschlecht smallint);
alter table kenn_pbv_aggr modify (bund_taetigkeit smallint);
alter table kenn_pbv_aggr modify (bund_dienstart smallint);

</#if>

