--(c) 2015 Daniel Quathamer

-- bertragung der Daten von kenn_sgd_aggr nach kenn_pbe_aggr
-- Bei den Kennzahlen wird auf diese Tabelle zugegriffen und falls diese nach einem Upgrade 
-- nicht neu berechnet werden, wrden ohne dieses upgrade die Kahlen nicht mehr angezeigt werden.

create temp table tmp_pbe_jahre (jahr integer,hs_nr integer);

create temp table tmp_stichtag_jahre (jahr integer);

insert into tmp_pbe_jahre (hs_nr,jahr)
select distinct hs_nr,year(stichtag) from kenn_pbe_aggr;

insert into tmp_stichtag_jahre (jahr)
select distinct bezugszeit from kenn_stichtag 
where stichtagsart='Stellenstatistik' and berechnen='1' and bezugsart='J';


insert into kenn_pbe_aggr (hs_nr,bund_fachgebiet,bund_dienstart,faktor,buadbz,buadbz_besetzung,da_besetzung,taet_besetzung,stichtag,datum,zaehlung,summe)
select hs_nr,bund_fachgebiet,bund_dienstart,faktor,buadbz,buadbz_besetzung,da_besetzung,taet_besetzung,stichtag,datum,zaehlung,sum(summe) from kenn_sgd_aggr
where 0=(select count (*) from tmp_pbe_jahre T where year(kenn_sgd_aggr.stichtag)=T.jahr and kenn_sgd_aggr.hs_nr=T.hs_nr)
and 0=(select count (*) from tmp_stichtag_jahre T where year(kenn_sgd_aggr.stichtag)=T.jahr)
group by 1,2,3,4,5,6,7,8,9,10,11;

drop table tmp_pbe_jahre;
drop table tmp_stichtag_jahre;
