--(c) 2013 Daniel Quathamer
--Freemarker Template
<sqlvars>
<sqlvar name="sva_cifx_exists">
select sp_table_exists('sva_cifx') from xdummy;
</sqlvar>
<sqlvar name="fin_cifx_exists">
select sp_table_exists('fin_cifx') from xdummy;
</sqlvar>
<sqlvar name="kernmodul_version">
select substring(version from 1 for 3) from db_version where his_system='kern';
</sqlvar>
</sqlvars>

<#assign  titel_char10_alter = [
  {"table":"kenn_sgd_aggr"},
  {"table":"kenn_zahl_wert"},
  {"table":"kenn_konto_aggr"},
  {"table":"kenn_titel"},
  {"table":"kenn_pbv_klr"}
  ] />


<#foreach column in titel_char10_alter>

<#if '${SQLdialect}'='Postgres' >
alter table ${column.table} alter titel type char(10);
</#if>

<#if '${SQLdialect}'='Informix' >
alter table ${column.table} modify(titel char(10));
</#if>

</#foreach>

<#if '${SQLdialect}'='Postgres' >
alter table kenn_katalog alter bedingung type TEXT;
alter table kenn_pbv_aggr alter summe type double precision;
alter table kenn_sgd_aggr alter summe type double precision;
alter table kenn_sgd_aggr alter vzae_besetzung_beamt type double precision;
alter table kenn_sgd_aggr alter vzae_besetzung_besch type double precision;
alter table kenn_sgd_aggr alter vzae_besetzung_uw type double precision;
alter table kenn_sgd_aggr alter vzae_besetzung type double precision;
alter table kenn_sgd_aggr alter koepfe_besetzung type double precision;
alter table kenn_pbe_aggr alter summe type double precision;
alter table kenn_flaeche alter flaeche type double precision;
alter table kenn_zahl_wert alter wert type double precision;
alter table kenn_konto_aggr alter betrag type double precision;
alter table kenn_pbv_klr alter summe type double precision;
alter table kenn_fibu_guv alter betrag type double precision;
alter table kenn_fibu_guv alter betragvorjahr type double precision;
alter table kenn_fibu_bilanz alter betrag type double precision;
alter table kenn_fibu_bilanz alter betragvorjahr type double precision;

alter table kenn_fibu_quartal alter plan type double precision;
alter table kenn_fibu_quartal alter q1 type double precision;
alter table kenn_fibu_quartal alter q2 type double precision;
alter table kenn_fibu_quartal alter q3 type double precision;
alter table kenn_fibu_quartal alter q4 type double precision;
alter table kenn_fibu_quartal alter steuerungvorschau type double precision;
alter table kenn_fibu_quartal alter steuerungvorjahr type double precision;
alter table kenn_fibu_quartal alter column id drop NOT NULL;

alter table kenn_fibu_wiplan alter ist type double precision;
alter table kenn_fibu_wiplan alter sollplus1 type double precision;
alter table kenn_fibu_wiplan alter sollplus2 type double precision;
alter table kenn_fibu_wiplan alter sollplus3 type double precision;

alter table kenn_flaeche alter kfanr type varchar(10);
alter table kenn_flaeche_cube alter kfanr type varchar(10);
--Formel NHS Sachsen HH-finanziertes Personal:
--ghet nur unte rPostgres, ist aber nicht schlimm weil nur fr Sachsen / BI relevant
update sx_repository set content='ch212_geldgeber in (select ggnr from sva_geldgeber  where klr_geldgeber not in (''11'',''12'',''19'',''21'',''22'',''28'',''29'',''31'',''32'',''33a'',''33b'',''33c'',''33d'',''34'',''34a'',''35'',''36'',''37'',''38'',''39'',''40'') or klr_geldgeber is null) and (beurl_art is null or beurl_art in (select C.apnr from sva_k_beurlaubart C where (C.bezuege_kz is null or C.bezuege_kz = ''J''))) and vertart in (select apnr from sva_k_vertragsart KV where KV.bundstat_relevant=''J'')'
where id='SVA_HH_SA';
update sx_repository set content='ch212_geldgeber in (select ggnr from sva_geldgeber  where klr_geldgeber in (''11'',''12'',''19'',''21'',''22'',''28'',''29'',''31'',''32'',''33a'',''33b'',''33c'',''33d'',''34'',''34a'',''35'',''36'',''37'',''38'',''39'',''40'')) and (beurl_art is null or beurl_art in (select C.apnr from sva_k_beurlaubart C where (C.bezuege_kz is null or C.bezuege_kz = ''J''))) and vertart in (select apnr from sva_k_vertragsart KV where KV.bundstat_relevant=''J'')'
where id='SVA_DM_SA';


</#if>

<#if '${SQLdialect}'='Informix' >
alter table kenn_pbv_aggr modify(summe float);
alter table kenn_sgd_aggr modify(summe float);
alter table kenn_sgd_aggr modify(vzae_besetzung_beamt float);
alter table kenn_sgd_aggr modify(vzae_besetzung_besch float);
alter table kenn_sgd_aggr modify(vzae_besetzung_uw float);
alter table kenn_sgd_aggr modify(vzae_besetzung float);
alter table kenn_sgd_aggr modify(koepfe_besetzung float);
alter table kenn_pbe_aggr modify(summe float);
alter table kenn_flaeche modify(flaeche float);
alter table kenn_zahl_wert modify(wert float);
alter table kenn_konto_aggr modify(betrag float);
alter table kenn_pbv_klr modify(summe float);
alter table kenn_fibu_guv modify(betrag float);
alter table kenn_fibu_guv modify(betragvorjahr float);
alter table kenn_fibu_bilanz modify(betrag float);
alter table kenn_fibu_bilanz modify(betragvorjahr float);

alter table kenn_fibu_quartal modify(plan float);
alter table kenn_fibu_quartal modify(q1 float);
alter table kenn_fibu_quartal modify(q2 float);
alter table kenn_fibu_quartal modify(q3 float);
alter table kenn_fibu_quartal modify(q4 float);
alter table kenn_fibu_quartal modify(steuerungvorschau float);
alter table kenn_fibu_quartal modify(steuerungvorjahr float);

alter table kenn_fibu_wiplan modify(ist float);
alter table kenn_fibu_wiplan modify(sollplus1 float);
alter table kenn_fibu_wiplan modify(sollplus2 float);
alter table kenn_fibu_wiplan modify(sollplus3 float);

alter table kenn_flaeche modify(kfanr varchar(10));
alter table kenn_flaeche_cube modify(kfanr varchar(10));
</#if>

--manuelle Schnittstelle wird in kenn 1.0 neu definiert:
delete from kenn_cifx where key=665 and apnr in ('HABIL_M','HABIL_W','PROM_S','PROM_K','PROM_J');
update kenn_zahl_wert set kenn_zahl='HABIL',geschlecht=1
where kenn_zahl='HABIL_M';
update kenn_zahl_wert set kenn_zahl='HABIL',geschlecht=2
where kenn_zahl='HABIL_W';
--Promotionen ab V. 1.0 jahresweise fr Sachsen und Semesterweise fr BaWue/den Rest der Welt:
update kenn_zahl_wert set kenn_zahl='PROM_SEM'
where kenn_zahl in ('PROM_S','PROM_K','PROM_J')
and sem is not null
and jahr is null;

<#if K_KENN_PROFIL?exists&& K_KENN_PROFIL==5>
--Sachsen
--kenn_konto_aggr Altdaten kaufm./kameral?
update kenn_konto_aggr set kfmkam=2
where 0<(select count(*) from kenn_fibu_quartal Q
where Q.jahr=kenn_konto_aggr.jahr)
and betragsart in ('A','E')
and kfmkam is null;
update kenn_konto_aggr set kfmkam=1 where kfmkam is null;


--KLR Geldgeber haben sich mit 1.1 gendert:
<#if sva_cifx_exists=1>
update sva_cifx set gruppe='33d'
where key=636
and gruppe ='33';

update sva_cifx set gruppe=(select 'KLR_' || G.klr_geldgeber
from sva_geldgeber G
where G.ggnr=sva_cifx.apnr)
where key=636
and apnr in (select S.apnr from sva_cifx S, sva_geldgeber G
where S.key=636
and S.apnr=G.ggnr 
and S.gruppe != ('KLR_' || G.klr_geldgeber))
;
</#if>
<#if fin_cifx_exists=1>
update fin_cifx set gruppe='33d'
where key=636
and gruppe ='33';

update fin_cifx set gruppe=(select 'KLR_' || G.klr_geldgeber
from fin_geldgeber G
where G.ggnr=fin_cifx.apnr)
where key=636
and apnr in (select S.apnr from fin_cifx S, fin_geldgeber G
where S.key=636
and S.apnr=G.ggnr 
and S.gruppe != ('KLR_' || G.klr_geldgeber))
;

</#if>

update kenn_konto_aggr set klr_geldgeber='33d' where klr_geldgeber='33';
update kenn_pbv_aggr set klr_geldgeber='33d' where klr_geldgeber='33';

<#if '${SQLdialect}'='Postgres' >
--neuer Filter ohne Gast./Stud.-Koll./Medizin.Fak.(Sachsen)
INSERT INTO sx_repository
( id
, content
, caption
, comment
, art
, sachgebiete_id
, sort1
, sort2
, sort3
, aktiv
, gueltig_seit
, gueltig_bis
)
select
 'SOS_O_GAST_KOLL_MED'
, 'stg not in (''MED1'',''MED2'') and abschluss not in (select abint from k_abint where astat in (''06'',''07''))'
, 'ohne Gast./Stud.-Koll./Medizin.Fak.(Sachsen)'
, 'Hier werden Studierende ohne Gast./Stud.-Koll./Medizin.Fak.(Sachsen) gefiltert'
, 'SOS_STUD_FILTER '
, 16
, 1
, 0
, 0
, 1
, date_val('01.01.1900')
, date_val('01.01.3000')
from xdummy
where 0=(select count(*) from sx_repository where id='SOS_O_GAST_KOLL_MED')
;
</#if>

--Ende Sachsen
</#if>
--Neues Listenformular ab KENN 1.2:
update  db_forms set form_path='/edit/kenn/kenn_extkotr_stg_liste.jsp' where name='kenn_extkotr_stg_list';
update  db_forms set form_path='/edit/kenn/kenn_extkotr_stg_bearbeiten.jsp' where name='kenn_extkotr_stg_edit';

<#if kernmodul_version == "4.5" && '${SQLdialect}'='Postgres'>
update sx_captions set contents_long='Merkmalsliste siehe http://www.superx-projekt.de/doku/kenn_modul/admin/f_MerkmalederErhebungproKennzahl.htm'
where table_name='felderinfo'
and record_no=18241;

</#if>


--kenn_stupl Summe wird von INTEGER zu FLOAT:
<#if '${SQLdialect}'='Postgres' >
alter table kenn_stupl alter summe type float;
</#if>

<#if '${SQLdialect}'='Informix' >
alter table kenn_stupl modify(summe float);
</#if>

--kennx_stichtagsart_tabelle Feld stichtagsart_id char(40):
<#if '${SQLdialect}'='Postgres' >
alter table kenn_report_stichtagsart alter stichtagsart_id type char(40);
</#if>

<#if '${SQLdialect}'='Informix' >
alter table kenn_report_stichtagsart modify(stichtagsart_id char(40));
</#if>

--kenn_katalog.bezugszeit_diff char(40):
<#if '${SQLdialect}'='Postgres' >
alter table kenn_katalog alter bezugszeit_diff type varchar(255);
</#if>

<#if '${SQLdialect}'='Informix' >
alter table kenn_katalog modify(bezugszeit_diff varchar(255));
</#if>




--Neue Bestandsart ab 1.4:
update kenn_stichtag set stichtagsart_id=(select B.apnr from kenn_stichtagsart B
where B.druck=kenn_stichtag.stichtagsart)
where stichtagsart_id is null;

--BaWue ab 1.4 kenn_sos_stg inkl. HRST 2 = Nebenhrer, vorher war nur Haupthrer
<#if K_KENN_PROFIL?exists && (K_KENN_PROFIL==1 || K_KENN_PROFIL==2 || K_KENN_PROFIL==3 || K_KENN_PROFIL==4) >
update kenn_sos_stg set hrst='1'
where hrst is null;
</#if>

update kenn_katalog_rpt set active=1 where active is null;

update themenbaum set name='Administration Grunddaten und Kennzahlen' where name='Administration Kenn-Modul';

--Bugfix Patch 2019-01-17 
update kenn_lab_astat_2015 set matrikel_nr=val(ef006)
where matrikel_nr=-1
and ef006 like '000%' --nicht grer als max. Integer 2147483647
;
update kenn_lab_astat_2015 set matrikel_nr=-1
where matrikel_nr is null;
--Bugfix fhrende " " bei kenn_pbv_astat.ef11 #208697:
update kenn_pbv_astat set ef11=trim(ef11);
update kenn_pbv_aggr_astat set bund_fachgebiet=trim(bund_fachgebiet);

--Neue Masken NHS:
update themenbaum set parent=(select min(T2.tid) from themenbaum T2 where T2.name='Administration Grunddaten und Kennzahlen')
where maskeninfo_id=32320
and 1=(select count(*) from hochschulinfo);

update themenbaum set parent=(select min(T2.tid) from themenbaum T2 where T2.name='Zentrale Kennzahlen')
where maskeninfo_id=32140
;

--Lschen obsoleter Konstante, schon seit 0.8 weg:
delete from konstanten where beschreibung ='KENN_STPL_MAN';

--KENN 1.8 neues Feld kenn_promo_aggr.dauer_jahre:
update kenn_promo_aggr set dauer_jahre=jahr_ende-jahr_beginn
where dauer_jahre is null
and jahr_ende-jahr_beginn >0;

--KENN 1.9 kenn_fibu_quartal wird quartalsweise historisiert
--Altdaten ohne Quartal werden auf 4 gesetzt:
update kenn_fibu_quartal set quartal=val('' || jahr || '4')
where quartal is null;

--KENN 2.0 STBB:
update sx_repository set sachgebiete_id=111 where sachgebiete_id=109 and id like '%STBB%';

update themenbaum set sort=0 where maskeninfo_id=18540;
update themenbaum set sort=2 where maskeninfo_id=32380;

alter table kenn_rpt_ansprech alter column report_id type char(10) using report_id::char(10);

-- folgende report_ids wurden ersetzt durch die report_ids aus kenn_cifx key=679
delete from kenn_katalog_rpt where report_id in ('BILANZ','GUV','KAM_JA','KAM_QB');

