--freemarker template
<sqlvars>
<sqlvar name="kenn_vari_gefuellt">
select count(*) from kenn_vari;
</sqlvar>
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>
</sqlvars>

--konstanten fuellen:

select '${SQLdialect}' from xdummy;
<#assign  char10_alter = [
  {"table":"kenn_stug", "name":"stug_abschl"},
  {"table":"kenn_stug", "name":"stug_fach"}
  ] />



--neue Maske

CREATE temp TABLE tmp_themenbaum (
    tid integer NOT NULL,
    name character(50) NOT NULL,
    maskeninfo_id integer,
    parent integer,
    gueltig_seit date,
    gueltig_bis date,
    erlaeuterung character(240)
);
insert into tmp_themenbaum(tid,
       name,
       maskeninfo_id,
       gueltig_seit,
       gueltig_bis)
       select max(tid)+1,'Stichtage verwalten'::char(50),18280,
       date_val('01.01.1900'),date_val('30.09.2999')
       from themenbaum;
delete from tmp_themenbaum where 0 <
(select count(*) from themenbaum where maskeninfo_id=18280);
update tmp_themenbaum set parent=(select max(tid) from themenbaum where name='Administration Kenn-Modul');

insert into themenbaum( tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung)
select  tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung
       from tmp_themenbaum;
       
delete from tmp_themenbaum;

--Hierarchien:
insert into tmp_themenbaum(tid,
       name,
       maskeninfo_id,
       gueltig_seit,
       gueltig_bis)
       select max(tid)+1,'Hierarchie erzeugen'::char(50),18300,
       date_val('01.01.1900'),date_val('30.09.2999')
       from themenbaum;
delete from tmp_themenbaum where 0 <
(select count(*) from themenbaum where maskeninfo_id=18300);
update tmp_themenbaum set parent=(select max(tid) from themenbaum where name='Administration Kenn-Modul');

insert into themenbaum( tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung)
select  tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung
       from tmp_themenbaum;
       
delete from tmp_themenbaum;

insert into tmp_themenbaum(tid,
       name,
       maskeninfo_id,
       gueltig_seit,
       gueltig_bis)
       select max(tid)+1,'Hierarchie suchen'::char(50),18320,
       date_val('01.01.1900'),date_val('30.09.2999')
       from themenbaum;
delete from tmp_themenbaum where 0 <
(select count(*) from themenbaum where maskeninfo_id=18320);
update tmp_themenbaum set parent=(select max(tid) from themenbaum where name='Administration Kenn-Modul');

insert into themenbaum( tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung)
select  tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung
       from tmp_themenbaum;
       
delete from tmp_themenbaum;

--KoA extern

insert into tmp_themenbaum(tid,
       name,
       maskeninfo_id,
       gueltig_seit,
       gueltig_bis)
       select max(tid)+1,'Kostenartenbericht (extern)'::char(50),18580,
       date_val('01.01.1900'),date_val('30.09.2999')
       from themenbaum;
delete from tmp_themenbaum where 0 <
(select count(*) from themenbaum where maskeninfo_id=18580);
update tmp_themenbaum set parent=(select max(tid) from themenbaum where name='Grunddaten Kostenrechnung');

insert into themenbaum( tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung)
select  tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung
       from tmp_themenbaum;
       
delete from tmp_themenbaum;
insert into tmp_themenbaum(tid,
       name,
       maskeninfo_id,
       gueltig_seit,
       gueltig_bis)
       select max(tid)+1,'Studierende und Studienanfnger'::char(50),18620,
       date_val('01.01.1900'),date_val('30.09.2999')
       from themenbaum;
delete from tmp_themenbaum where 0 <
(select count(*) from themenbaum where maskeninfo_id=18620);
update tmp_themenbaum set parent=(select max(tid) from themenbaum where name='Grunddaten Studierende, Prfungen');

insert into themenbaum( tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung)
select  tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung
       from tmp_themenbaum;
       
delete from tmp_themenbaum;
insert into tmp_themenbaum(tid,
       name,
       maskeninfo_id,
       gueltig_seit,
       gueltig_bis)
       select max(tid)+1,'Absolventen nach Geschlecht'::char(50),18640,
       date_val('01.01.1900'),date_val('30.09.2999')
       from themenbaum;
delete from tmp_themenbaum where 0 <
(select count(*) from themenbaum where maskeninfo_id=18640);
update tmp_themenbaum set parent=(select max(tid) from themenbaum where name='Grunddaten Studierende, Prfungen');

insert into themenbaum( tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung)
select  tid,
       name,
       maskeninfo_id,
       parent,
       gueltig_seit,
       gueltig_bis,
       erlaeuterung
       from tmp_themenbaum;

drop table tmp_themenbaum;

<#if kenn_vari_gefuellt = 0>

--kenn_vari fllen:
--Defaultmig fr alle HHJ:
<#if cob_installed=1>
create temp table tmp_jahr(jahr integer);
insert into tmp_jahr select distinct jahr from cob_vtbu_aggr;


insert into kenn_vari
(vari_nr,kotr_art,bezugszeit,bezugsart)
select K.apnr,'L'::char(1),T.jahr,'J'::char(1)
from konstanten K, tmp_jahr T
where K.beschreibung='VERTEILSCHRITT KENN LEHRE'
and K.apnr is not null
;


insert into kenn_vari
(vari_nr,kotr_art,bezugszeit,bezugsart)
select K.apnr,'F'::char(1),T.jahr,'J'::char(1)
from konstanten K, tmp_jahr T
where K.beschreibung='VERTEILSCHRITT KENN FORSC'
and K.apnr is not null
;

insert into kenn_vari
(vari_nr,kotr_art,bezugszeit,bezugsart)
select K.apnr,'D'::char(1),T.jahr,'J'::char(1)
from konstanten K, tmp_jahr T
where K.beschreibung='VERTEILSCHRITT KENN DIENS'
and K.apnr is not null
;

delete from konstanten where beschreibung in(
'VERTEILSCHRITT KENN LEHRE',
'VERTEILSCHRITT KENN FORSC',
'VERTEILSCHRITT KENN DIENS');

drop table tmp_jahr;
</#if>
</#if>


--Habil jetzt jahresweise:
UPDATE kenn_cifx
   SET lang_2 = 'jahr*Haushaltsjahr*int,ch110_institut*Institutsnr.*char,bund_fachgebiet*Fachgebiet(Bund)*char,wert*Wert*decimal'
  WHERE key=665 and apnr='HABIL_W';
UPDATE kenn_cifx
   SET lang_2 = 'jahr*Haushaltsjahr*int,ch110_institut*Institutsnr.*char,bund_fachgebiet*Fachgebiet(Bund)*char,wert*Wert*decimal'
 WHERE key=665 and apnr='HABIL_M';
 UPDATE kenn_cifx
   SET druck = 'Gesamtausgaben lt. Landeshaushaltsrechnung',
   lang_1 = 'Gesamtausgaben lt. Landeshaushaltsrechnung'
  WHERE key=665 and apnr='HHM_LHR';
  
  --neue hzbart
  
  create temp table tmp_hilf(isdrin smallint);
  insert into tmp_hilf values (0);
  
  update tmp_hilf set isdrin=1
  where 0 < (select count(*) from kenn_hzbart
  where astat='6');
  
INSERT INTO kenn_hzbart
(astat, druck)
select
'6', 'Fachgeb.HS-Reife'
from xdummy
where 0=(select isdrin from tmp_hilf);

drop table tmp_hilf;

--neu fr rc8:
--Sortierung BVKR Sicht:
update sichten set quelle= 'select trim(apnr) || ''-'' || druck,apnr,parent,1,ebene from kenn_cifx where key=668 and today() between d_akt_von and d_akt_bis order by apnr'
where name_intern='kenn_fikr_bvkr';

--neu in .06rc1: Schlsselverzeichnis hngt unter zentrale Kennzahlen:
create temp table tmp_th(parent_tid integer);
insert into tmp_th select min(tid) from themenbaum where name='Zentrale Kennzahlen';
update themenbaum set parent=(select parent_tid from tmp_th)
where maskeninfo_id=18200
and 0< (select count(*) from tmp_th T where T.parent_tid is not null);
drop table tmp_th;

--neu in 0.8:
--wurden nie fr Sachsen benutzt:
delete from kenn_cifx where key=665 and apnr in ('LEHRNACHFR','LEHRANG');


<#foreach column in char10_alter>

<#if '${SQLdialect}'='Postgres' >

alter table ${column.table} alter column ${column.name} type char(10);

</#if>
<#if '${SQLdialect}'='Informix' >
--nun Informix:
alter table ${column.table} modify(${column.name} char(10));

</#if>

</#foreach>
