--kameraler Quartalsbericht
--freemarker template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
<sqlvar name="kenn_konto_aggr_hsnr_jahre" type='hashsequence'><![CDATA[
select distinct K.hs_nr,K.jahr from kenn_konto_aggr K
left outer join kenn_kam_quartal Q
on (Q.jahr=K.jahr
and Q.hs_nr=K.hs_nr)
where Q.hs_nr is null
and K.jahr is not null
--nur Sachsen:
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))

]]>
</sqlvar>

</sqlvars>
<#macro doubletype>
<#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>



--Aus dem Vorjahr bertragene Einnahme-reste  Gesamt-Soll 2011  Ist I. Quartal (31.03.2011)  Ist II. Quartal (30.06.2011)
--Ist III.Quartal (30.09.2011)  Ist IV. Quartal (31.12.2011)  Gesamt-Ist 2011 (kumulierte Quartale) 
--IST Vorjahr kumulierte Quartale)  Vorschau 2011 bis Jahresende  Abweichung zum Gesamt-Sol
create temp table tmp_kenn_kam_quartal(
hs_nr integer,
jahr integer,
quartal integer,
dr varchar(50),
titel varchar(50),
soll <@doubletype/>, 
reste <@doubletype/> default 0,
haushaltsvorgriff <@doubletype/> default 0,
<#list 1..4 as quartal>
istq${quartal}  <@doubletype/> default 0,
istvorjahr_q${quartal}  <@doubletype/> default 0,
</#list>
vorschau <@doubletype/> default 0,
erlaeuterung text
)<@informixnolog/>
;

<#if kenn_konto_aggr_hsnr_jahre?exists && kenn_konto_aggr_hsnr_jahre?has_content >
<#foreach hsnr_jahr in kenn_konto_aggr_hsnr_jahre>

create temp table tmp_konto (dr varchar(50),
titel char(10),
akts <@doubletype/> default 0,
reste <@doubletype/> default 0,
haushaltsvorgriff <@doubletype/> default 0,
<#list 1..4 as quartal>
istq${quartal}  <@doubletype/> default 0,
istvorjahr_q${quartal}  <@doubletype/> default 0,
</#list>
vorschau  <@doubletype/> default 0
) <@informixnolog/>;

insert into tmp_konto (dr,titel,akts)
select dr,titel,sum(betrag) from kenn_konto_aggr 
where 
jahr=${hsnr_jahr.jahr} 
and betragsart='S' 
and hs_nr=${hsnr_jahr.hs_nr} 
group by 1,2;
insert into tmp_konto (dr,titel,reste)
select dr,titel,sum(betrag) from kenn_konto_aggr 
where 
jahr=${hsnr_jahr.jahr} and betragsart='Z' --Reste 
and hs_nr=${hsnr_jahr.hs_nr} 
group by 1,2;
insert into tmp_konto (dr,titel,haushaltsvorgriff)
select dr,titel,sum(betrag) from kenn_konto_aggr 
where 
jahr=${hsnr_jahr.jahr} and betragsart='V' 
and hs_nr=${hsnr_jahr.hs_nr} 
group by 1,2;



<#list 1..4 as quartal>
  --einnahmen
insert into tmp_konto (dr,titel,istq${quartal})
select dr,titel,sum(betrag) from kenn_konto_aggr where  jahr=${hsnr_jahr.jahr} 
and betragsart='Y'
and substring(titel from 1 for 1) in ('0','1','2','3')
and hs_nr=${hsnr_jahr.hs_nr} 
and monat>=${quartal*3-2} and monat<=${quartal*3} 
group by 1,2;
 --ausgaben
insert into tmp_konto (dr,titel,istq${quartal})
select dr,titel,sum(betrag) from kenn_konto_aggr where  jahr=${hsnr_jahr.jahr} 
and betragsart='X'  
and substring(titel from 1 for 1) in ('4','5','6','7','8','9')
and hs_nr=${hsnr_jahr.hs_nr} 
and monat>=${quartal*3-2} and monat<=${quartal*3}
group by 1,2;
</#list>

delete from tmp_konto where akts=0 and reste=0 and haushaltsvorgriff=0 and istq1=0 and istq2=0 and istq3=0 and istq4=0;
--update tmp_konto set dr='einzeltitel' where dr is null or dr='';
create temp table aktuelle_titel (dr varchar(20),titel varchar(20)); 
insert into aktuelle_titel select distinct dr,titel from tmp_konto;

--vorjahr
<#list 1..4 as quartal>
insert into tmp_konto (dr,titel,istvorjahr_q${quartal})
select dr,titel,sum(betrag) from kenn_konto_aggr 
where 
 jahr=${hsnr_jahr.jahr}-1 
 and betragsart='Y' --Einnahmen
 and substring(titel from 1 for 1) in ('0','1','2','3')
 and hs_nr=${hsnr_jahr.hs_nr} 
 and monat>=${quartal*3-2} and monat<=${quartal*3} 
group by 1,2;

insert into tmp_konto (dr,titel,istvorjahr_q${quartal})
select dr,titel,sum(betrag) from kenn_konto_aggr where 
 jahr=${hsnr_jahr.jahr}-1 
 and betragsart='X' --ausgaben 
 and substring(titel from 1 for 1) in ('4','5','6','7','8','9')
 and hs_nr=${hsnr_jahr.hs_nr} 
 and monat>=${quartal*3-2} and monat<=${quartal*3} 
 group by 1,2;
 

</#list>

--in kenn_konto_aggr ist vorschau nicht quartalsweise da, daher ins 4.Q. buchen:
--zuerst dr:
insert into tmp_konto (dr,vorschau)
select W.titel,sum(W.wert) from kenn_zahl_wert W
where W.kenn_zahl in ('KAM_QVA','KAM_QVE')
 and jahr=${hsnr_jahr.jahr} 
 and hs_nr=${hsnr_jahr.hs_nr} 
 and length(W.titel)=2
 group by 1;

--dann titel :
insert into tmp_konto (dr,titel,vorschau)
select substring(W.titel from 1 for 2),W.titel,sum(W.wert) from kenn_zahl_wert W
where W.kenn_zahl in ('KAM_QVA','KAM_QVE')
 and jahr=${hsnr_jahr.jahr} 
 and hs_nr=${hsnr_jahr.hs_nr} 
 and length(W.titel)=5
 group by 1,2;

 
 
delete from tmp_konto where titel not in (select titel from aktuelle_titel);
update tmp_konto set dr=(select min(dr) from aktuelle_titel where tmp_konto.titel=aktuelle_titel.titel);
drop table aktuelle_titel;

insert into tmp_kenn_kam_quartal(hs_nr ,
jahr,
quartal,
dr ,
titel ,
soll, 
reste,
haushaltsvorgriff ,
<#list 1..4 as quartal>
istq${quartal},
istvorjahr_q${quartal},
</#list>
vorschau)
select 
${hsnr_jahr.hs_nr}  ,
${hsnr_jahr.jahr} ,
4, --fest ins 4. Quartal
dr ,
titel ,
sum(akts), 
sum(reste),
sum(haushaltsvorgriff) ,
<#list 1..4 as quartal>
sum(istq${quartal}),
sum(istvorjahr_q${quartal}),
</#list>
sum(vorschau)
from tmp_konto
group by 1,2,3,4,5;



--erluterung nur bei Postgres, weil Informix keine TEXT inserts mag:
 <#if SQLdialect='Postgres'>
 --zuerst dr:
update tmp_kenn_kam_quartal set erlaeuterung=(select min(W.wert_str)
from kenn_zahl_wert W
where W.kenn_zahl in ('ERL_KAM_QA','ERL_KAM_QE')
 and jahr=${hsnr_jahr.jahr} 
 and hs_nr=${hsnr_jahr.hs_nr} 
 and length(W.titel)=2
 and W.titel=tmp_kenn_kam_quartal.dr
)
where jahr=${hsnr_jahr.jahr} 
 and hs_nr=${hsnr_jahr.hs_nr}
 and dr is not null
 and titel is null;
 
--dann Titel:
update tmp_kenn_kam_quartal set erlaeuterung=(select min(W.wert_str)
from kenn_zahl_wert W
where W.kenn_zahl in ('ERL_KAM_QA','ERL_KAM_QE')
 and jahr=${hsnr_jahr.jahr} 
 and hs_nr=${hsnr_jahr.hs_nr} 
 and length(W.titel)=5
 and W.titel=tmp_kenn_kam_quartal.titel
)
where jahr=${hsnr_jahr.jahr} 
 and hs_nr=${hsnr_jahr.hs_nr}
 and titel is not null;


</#if>

drop table tmp_konto;

</#foreach>
</#if>


insert into kenn_kam_quartal(hs_nr ,
jahr,
quartal,
dr ,
titel ,
soll, 
reste,
haushaltsvorgriff ,
<#list 1..4 as quartal>
istq${quartal},
istvorjahr_q${quartal},
</#list>
vorschau,
erlaeuterung)
select 
hs_nr  ,
jahr, 
quartal,
dr ,
titel ,
soll, 
reste,
haushaltsvorgriff ,
<#list 1..4 as quartal>
istq${quartal},
istvorjahr_q${quartal},
</#list>
vorschau,
erlaeuterung
from tmp_kenn_kam_quartal
;

drop table tmp_kenn_kam_quartal;

