--kameraler Quartalsbericht
--freemarker template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
<sqlvar name="kenn_konto_aggr_hsnr_jahre" type='hashsequence'><![CDATA[
select distinct K.hs_nr,K.jahr from kenn_konto_aggr K
left outer join kenn_kam_ja J
on (J.jahr=K.jahr
and J.hs_nr=K.hs_nr)
where J.hs_nr is null
and K.jahr is not null
--nur Sachsen:
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))

]]>
</sqlvar>

</sqlvars>
<#macro doubletype>
<#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>


CREATE TEMP TABLE tmp_kenn_kam_ja (
    hs_nr integer,
    jahr integer,
    dr character varying(50),
    titel character varying(50),
    soll double precision DEFAULT 0,
    reste double precision DEFAULT 0,
    haushaltsvorgriff double precision DEFAULT 0,
    ist double precision DEFAULT 0,
datum date,
erlaeuterung text
);

<#if kenn_konto_aggr_hsnr_jahre?exists && kenn_konto_aggr_hsnr_jahre?has_content >
<#foreach hsnr_jahr in kenn_konto_aggr_hsnr_jahre>


create temp table tmp_konto (hs_nr integer,
dr varchar(50),
titel char(10),
akts <@doubletype/> default 0,
reste <@doubletype/> default 0,
haushaltsvorgriff <@doubletype/> default 0,
ist  <@doubletype/> default 0
) <@informixnolog/>;
---- statt W Hhans  S aktuelles Soll, X Ausgaben, Y Einnahmen, Z Reste, V = Haushaltsvorgriff 
insert into tmp_konto (hs_nr,dr,titel,akts)
select hs_nr,dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr=${hsnr_jahr.hs_nr}  and
jahr=${hsnr_jahr.jahr} and betragsart='S'  
group by 1,2,3;
insert into tmp_konto (hs_nr,dr,titel,reste)
select hs_nr,dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr=${hsnr_jahr.hs_nr}  and
jahr=${hsnr_jahr.jahr}  and betragsart='Z'  
group by 1,2,3;
insert into tmp_konto (hs_nr,dr,titel,haushaltsvorgriff)
select hs_nr,dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr=${hsnr_jahr.hs_nr}  and
jahr=${hsnr_jahr.jahr}  and betragsart='V'  
group by 1,2,3;


  --einnahmen
insert into tmp_konto (hs_nr,dr,titel,ist)
select hs_nr,dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr=${hsnr_jahr.hs_nr}  and jahr=${hsnr_jahr.jahr}  and betragsart='Y'   and
substring(titel from 1 for 1) in ('0','1','2','3')
group by 1,2,3;
 --ausgaben
insert into tmp_konto (hs_nr,dr,titel,ist)
select hs_nr,dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr=${hsnr_jahr.hs_nr}  and jahr=${hsnr_jahr.jahr}  and betragsart='X'  and
substring(titel from 1 for 1) in ('4','5','6','7','8','9')
 group by 1,2,3;

-- update tmp_konto set dr='einzeltitel' where dr is null or dr='';



insert into tmp_kenn_kam_ja(
hs_nr,
       jahr,
       dr,
       titel,
       soll,
       reste,
       haushaltsvorgriff,
       ist,
       datum
   )
           select
            ${hsnr_jahr.hs_nr} ,
            ${hsnr_jahr.jahr} ,
            dr,
            titel,
            sum(akts) as soll,
	    sum(reste) as reste,
	    sum(haushaltsvorgriff) as haushaltsvorgriff,
	    sum(ist) as ist,
	    
today()
            from  tmp_konto
	    group by 1,2,3,4
	    ;

--erluterung nur bei Postgres, weil Informix keine TEXT inserts mag:
 <#if SQLdialect='Postgres'>
 --zuerst dr:
update tmp_kenn_kam_ja set erlaeuterung=(select min(W.wert_str)
from kenn_zahl_wert W
where W.kenn_zahl in ('ERL_KAM_JA','ERL_KAM_JE')
 and jahr=${hsnr_jahr.jahr} 
 and hs_nr=${hsnr_jahr.hs_nr} 
 and length(W.titel)=2
 and W.titel=tmp_kenn_kam_ja.dr
)
where jahr=${hsnr_jahr.jahr} 
 and hs_nr=${hsnr_jahr.hs_nr}
 and dr is not null
 and titel is null;
 
--dann Titel:
update tmp_kenn_kam_ja set erlaeuterung=(select min(W.wert_str)
from kenn_zahl_wert W
where W.kenn_zahl in ('ERL_KAM_JA','ERL_KAM_JE')
 and jahr=${hsnr_jahr.jahr} 
 and hs_nr=${hsnr_jahr.hs_nr} 
 and length(W.titel)=5
 and W.titel=tmp_kenn_kam_ja.titel
)
where jahr=${hsnr_jahr.jahr} 
 and hs_nr=${hsnr_jahr.hs_nr}
 and titel is not null;


</#if>

drop table tmp_konto;

</#foreach>
</#if>


insert into tmp_kenn_kam_ja(
hs_nr,
       jahr,
       dr,
       titel,
       soll,
       reste,
       haushaltsvorgriff,
       ist,
       datum,
       erlaeuterung
   )
           select
            hs_nr,
            jahr,
            dr,
            titel,
           soll,
	    reste,
	    haushaltsvorgriff,
	    ist,
	    
today(),
erlaeuterung
            from  tmp_kenn_kam_ja
	    ;
drop table tmp_kenn_kam_ja;

