--Freemarker Template 
--Altdaten aus Absol.-Statistik nach kenn_promo_aggr retten:
<sqlvars>
<sqlvar name="jahre" type="hashsequence">
SELECT distinct jahr as bezugszeit ,hs_nr
 FROM kenn_drittm_aggr A
 where A.betragsart='E' 
 and 0=(select count(*)
from kenn_zahl_wert W
where W.hs_nr=A.hs_nr
and W.jahr=A.jahr
and W.kenn_zahl in ('DRITTMITTEL_EINNAHMEN','DRITTMITTEL_GEWERBL')
)
 ;
</sqlvar>

</sqlvars>
<#if jahre?has_content>
<#foreach jahr in jahre>


--Drittmittel aus HS-Finanzstat vor 2020:
insert into kenn_zahl_wert( hs_nr,
       kenn_zahl,
       jahr,
       generic_dim1,
       wert
)
 SELECT 
 D.hs_nr,
 'DRITTMITTEL_EINNAHMEN',
       D.jahr,
       D.fgr,
       sum(D.betrag)
FROM kenn_drittm_aggr D 
where  ${jahr.bezugszeit} =D.jahr --Berichtsjahr
and ${jahr.hs_nr} =D.hs_nr
and D.betragsart='E' and ((D.kfmkam=1 and D.syf in ('23','24')) or (D.kfmkam=2 and D.syf in ('63','64')))

group by 1,2,3,4
 ;
 
 
insert into kenn_zahl_wert( hs_nr,
       kenn_zahl,
       jahr,
       wert
)
 SELECT 
 D.hs_nr,
 'DRITTMITTEL_GEWERBL',
       D.jahr,
       sum(D.betrag)
FROM kenn_drittm_aggr D 
where  ${jahr.bezugszeit} =D.jahr --Berichtsjahr
and ${jahr.hs_nr} =D.hs_nr
and D.betragsart='E' 
and ((D.kfmkam=1 and D.syf in ('248')) or (D.kfmkam=2 and D.syf in ('648')))

group by 1,2,3
 ;
 </#foreach>
</#if>


