--neu fr rc9:
--Anlagen aus manueller Schnittstelle entfernen.

delete from kenn_cifx where key =665
and apnr in ('IVS_ABGANG',
'IVS_ABSCHR',
'IVS_HISTOR',
'IVS_REST',
'IVS_ZUGANG');
--hhere Prioritt hat neue Hilfstabelle kenn_anlagen_aggr
--wenn die Tabelle fr das jew. HHJ gefllt ist, 
--werden die Daten aus der manuellen Schnittstelle entfernt.

delete from kenn_zahl_wert
where kenn_zahl in ('IVS_ABGANG',
'IVS_ABSCHR',
'IVS_HISTOR',
'IVS_REST',
'IVS_ZUGANG')
and jahr in (select distinct jahr from kenn_anlagen_aggr);

create temp table tmp_anlagen_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
ch110_institut CHAR(10) , 
inst_art char(20) ,
bund_fachgebiet CHAR(10) , 
asp_akl varchar(6) , 
rest DECIMAL(14,2) , 
rest_vj DECIMAL(14,2) , 
zugang DECIMAL(14,2) , 
abgang DECIMAL(14,2) , 
abschr DECIMAL(14,2) , 
histor_ahk DECIMAL(14,2) , 
umbuch DECIMAL(14,2) , 
zuschr DECIMAL(14,2) , 
abschr_ges DECIMAL(14,2) , 
datum date 
);

--alle anderen Daten werden in die Hilfstabelle geschoben,
--damit sie dort erhalten bleiben.

--IVS_ABGANG
insert into 
tmp_anlagen_aggr (
hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
              datum,
       rest,
       rest_vj,
       zugang,
       abgang,
       abschr,
       histor_ahk
       )
select hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
       today(),
       0,
       0,
       0,
       sum(wert),
       0,
       0
from kenn_zahl_wert
where kenn_zahl='IVS_ABGANG'
group by 1,2,3,4,5;

--'IVS_ABSCHR',
insert into 
tmp_anlagen_aggr (
hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
              datum,
       rest,
       rest_vj,
       zugang,
       abgang,
       abschr,
       histor_ahk
       )
select hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
       today(),
       0,
       0,
       0,
       0,
       sum(wert),
       0
from kenn_zahl_wert
where kenn_zahl='IVS_ABSCHR'
group by 1,2,3,4,5;
--'IVS_HISTOR',
insert into 
tmp_anlagen_aggr (
hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
              datum,
       rest,
       rest_vj,
       zugang,
       abgang,
       abschr,
       histor_ahk
       )
select hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
       today(),
       0,
       0,
       0,
       0,
       0,
       sum(wert)
from kenn_zahl_wert
where kenn_zahl='IVS_HISTOR'
group by 1,2,3,4,5;
--'IVS_REST',
insert into 
tmp_anlagen_aggr (
hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
              datum,
       rest,
       rest_vj,
       zugang,
       abgang,
       abschr,
       histor_ahk
       )
select hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
       today(),
      sum(wert),
       0,
       0,
       0,
        0,
	0
from kenn_zahl_wert
where kenn_zahl='IVS_REST'
group by 1,2,3,4,5;
--'IVS_REST_VJ',
insert into 
tmp_anlagen_aggr (
hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
       datum,
       rest,
       rest_vj,
       zugang,
       abgang,
       abschr,
       histor_ahk
       )
select hs_nr,
       jahr+1,
       ch110_institut,
       bund_fachgebiet,
       today(),
       0,
       sum(wert),
       0,
       0,
       0,
       0
from kenn_zahl_wert
where kenn_zahl='IVS_REST'
group by 1,2,3,4,5;
--'IVS_ZUGANG'
insert into 
tmp_anlagen_aggr (
hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
              datum,
       rest,
       rest_vj,
       zugang,
       abgang,
       abschr,
       histor_ahk
       )
select hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
       today(),
       0,
       0,
       sum(wert),
       0,
       0,
       0
from kenn_zahl_wert
where kenn_zahl='IVS_ZUGANG'
group by 1,2,3,4,5;
--externe Kostenstelle nachpflegen
update tmp_anlagen_aggr set inst_art=hs_nr || '_' || 
(select min(I.key_ext) from kenn_inst_to_ext I
where I.hs_nr=tmp_anlagen_aggr.hs_nr
and I.instnr=tmp_anlagen_aggr.ch110_institut
and I.key_ext is not null
and trim(I.key_ext) !='');

update tmp_anlagen_aggr set inst_art='_S' where inst_art is null;

--zusammenfhren:

insert into 
kenn_anlagen_aggr (
hs_nr,
       jahr,
       inst_ext,
       bund_fachgebiet,
 --      asp_akl,
        datum,
       rest,
       rest_vj,
       zugang,
       abgang,
       abschr,
       histor_ahk,
       umbuch,
       zuschr,
       abschr_ges
)
select hs_nr,
       jahr,
       ch110_institut,
       bund_fachgebiet,
       datum,
       sum(rest),
sum(rest_vj),
sum(zugang),
sum(abgang),
sum(abschr),
sum(histor_ahk),
sum(umbuch),
sum(zuschr),
sum(abschr_ges)

from tmp_anlagen_aggr
group by 1,2,3,4,5;

drop table tmp_anlagen_aggr;

--nun Stichtage entfernen:
delete from kenn_stichtag where stichtagsart in (
'Anlagen Abgnge',                                                                              
'Anlagen Abschreibungen',                                                       
'Anlagen historische AHK',                                                                             
'Anlagen Restbuchwert',                                                                                
'Anlagen Zugnge');                                                                                     

--In KENN 0.6rc1 wurde unbekannte Anlageklassen nach root geschoben,
--dies erschwert die Fehlersuche.
update kenn_anlagen_aggr set asp_akl= null where asp_akl='root';

