--Freemarker Template 
<#include "SQL_lingua_franca"/>
<sqlvars>
<sqlvar name="sos_installed">
select count(*) from db_version where his_system ='sos';
</sqlvar>
--landesspezifika ermitteln: 5='nrw',14='Sachsen',8 'BaWue'
<sqlvar name="bland_kuerzel">
select 746::integer as kuerzel from cif where key=659 and apnr=5 
union
select 751::integer from cif where key=659 and apnr=14 
union
select 750::integer from cif where key=659 and apnr=8
union
select 750::integer from xdummy where 0=(
select count(*) from cif where key=659 and apnr in (5,8,14)) 
;
</sqlvar>
<sqlvar name = "k_astat_studienfach_land_exists">
SELECT sp_table_exists('k_astat_studienfach_land') FROM xdummy;
</sqlvar>
</sqlvars>

<#if sos_installed=1>

--(c) 2008 Daniel Quathamer

CREATE temp TABLE tmp_kenn_stg_int (
    hs_nr integer,
    apnr character(10) NOT NULL,
    druck character varying(255),
    astat character(10),
    abint character(10),
    datum date
);


--Fcher mit astat:
insert into tmp_kenn_stg_int(hs_nr,
       apnr,
       druck,
       astat,
       datum)
       select H.hs_nr,K.refstg,K.dtxt,K.astat,today()
       from hochschulinfo H, k_stg K
       where K.astat is not null
       and K.refstg is not null;
--manche HSen pflegen die amtlichen Fcher in Abhngigkeit vom Abschluss:
insert into tmp_kenn_stg_int(hs_nr,
       apnr,
       druck,
       astat,
       abint,
       datum)
       select distinct H.hs_nr,K.refstg,K.dtxt,A.astat2,A.abschl,today()
       from hochschulinfo H, k_stg K,k_abstgv A
       where K.astat is null
       and A.stg=K.refstg
       and A.astat2 is not null
       ;
--Duplikate raus:
create temp table tmp_doppelt(apnr char(10),hs_nr integer, abint char(10),astat char(10));
insert into tmp_doppelt(apnr,hs_nr,abint)
select apnr,hs_nr,abint from tmp_kenn_stg_int group by 1,2,3
having count(*) >1;
update tmp_doppelt set astat=(select min(astat) from tmp_kenn_stg_int I
where I.apnr=tmp_doppelt.apnr
and I.hs_nr=tmp_doppelt.hs_nr
and (I.abint=tmp_doppelt.abint or (I.abint is null and tmp_doppelt.abint is null)));

delete from tmp_kenn_stg_int where 0 =(
select count(*) from tmp_doppelt D
where tmp_kenn_stg_int.apnr=D.apnr
and tmp_kenn_stg_int.hs_nr=D.hs_nr
and (tmp_kenn_stg_int.abint=D.abint or (tmp_kenn_stg_int.abint is null and D.abint is null))
and tmp_kenn_stg_int.astat = D.astat)
and 0 < (select count(*) from tmp_doppelt D
where tmp_kenn_stg_int.apnr=D.apnr
and tmp_kenn_stg_int.hs_nr=D.hs_nr
and (tmp_kenn_stg_int.abint=D.abint or (tmp_kenn_stg_int.abint is null and D.abint is null)))
;
drop table tmp_doppelt;

       
       
--insert in echte Tabelle:

delete from kenn_stg_int;
insert into kenn_stg_int
select hs_nr,
       apnr,
       druck,
       astat,
       abint,
       datum
       from tmp_kenn_stg_int;
--der Rest: Fcher ohne astat:
insert into kenn_stg_int(hs_nr,
       apnr,
       druck,
       astat,
       datum)
       select H.hs_nr,K.refstg,K.dtxt,K.astat,today()
       from hochschulinfo H, k_stg K
       where K.astat is null
       and K.refstg is not null
       and 0=(select count(*) from tmp_kenn_stg_int T
       where T.apnr=K.refstg);
--manche Hochschulen pflegen den astat ohne fhrende 0
update kenn_stg_int set astat='0'||astat where length(astat)=3
and substring(astat from 1 for 1)  in ('0','1','2','3','4','5','6','7','8','9')
;
--Umschlsselung Fach ggf. von Landes- auf Bundesschlssel:
update kenn_stg_int set astat=(select min(C.bund_apnr)
from sos_cifx C
where C.key=${bland_kuerzel}
and C.apnr=kenn_stg_int.astat)
where ${bland_kuerzel} in (746, 751) --nur Sachsen und NRW
;

drop table tmp_kenn_stg_int;

</#if>



<#if k_astat_studienfach_land_exists=1>
create temp table tmp_kenn_bland ( apnr varchar(255), druck varchar(255), astat integer);
  
INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('BA','Bayern',9);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('BB','Brandenburg',12);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('BE','Berlin',11);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('BR','Bremen',4);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('BW','Baden-Wrttemberg',8);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('HA','Hamburg',2);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('HE','Hessen',6);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('MV','Mecklenburg-Vorpommern',13);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('NI','Niedersachsen',3);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('NW','Nordrhein-Westfalen',5);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('RP','Rheinland-Pfalz',7);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('SA','Saarland',10);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('SH','Schleswig-Holstein',1);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('SN','Sachsen',14);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('ST','Sachsen-Anhalt',15);

INSERT INTO tmp_kenn_bland (apnr,druck,astat) 
VALUES ('TH','Thringen',16);



create temp table tmp_kenn_bland_hs (bland integer);

insert into tmp_kenn_bland_hs (bland)
select astat from tmp_kenn_bland where apnr in (select K.bland from kenn_hochschulen K, hochschulinfo H where H.hs_nr=K.hs_nr);

<@selectintotmp source="k_astat_studienfach_land" target="tmp_stg" select="schluessel,land,null::char(10) as keybund,max(nvl(gueltig_bis,30001)) as gueltig_bis"> 
where land=(select bland from tmp_kenn_bland_hs)
group by 1,2,3
</@selectintotmp><@informixnolog/>;

update tmp_stg set keybund=(select distinct L.keybund
from k_astat_studienfach_land L
where L.schluessel=tmp_stg.schluessel
and L.land=tmp_stg.land
and (L.gueltig_bis=tmp_stg.gueltig_bis or (L.gueltig_bis is null and tmp_stg.gueltig_bis =30001))
);

update kenn_stg_int set astat=(select K.keybund from tmp_stg K where (kenn_stg_int.astat=K.schluessel or kenn_stg_int.astat='0' || K.schluessel))
where 1=(select count(*) from tmp_stg K where kenn_stg_int.astat=K.schluessel or kenn_stg_int.astat='0' || K.schluessel);

update kenn_stg_int set astat='0' || astat where length(trim(astat))=3;

drop table tmp_kenn_bland;
drop table tmp_kenn_bland_hs;
drop table tmp_stg;
</#if>
