
--Freemarker Template 

<sqlvars>
<sqlvar name="sos_installed">
select count(*) from db_version where his_system ='sos';
</sqlvar>
<sqlvar name="min_jahr">
select year(today())-7 from xdummy;

</sqlvar>
<sqlvar name="max_jahr">
select year(today()) from xdummy;

</sqlvar>
</sqlvars>

create temp table tmp_semester(
	tid INTEGER , 
kurz CHAR(50) , 
druck CHAR(200) , 
akad_jahr SMALLINT , 
akad_jahr_absolv SMALLINT , 
akad_jahr_anf SMALLINT , 
sem_beginn DATE , 
sem_ende DATE 
) 
;



<#if sos_installed=1>


insert into tmp_semester (
tid,
kurz,
druck,
sem_beginn,
sem_ende
)
select 
tid,
eintrag,
eintrag,
sem_beginn,
sem_ende
from semester;

<#else>

<#list min_jahr..max_jahr as i>

--SoSe:

insert into tmp_semester (
tid,
kurz,
druck,
sem_beginn,
sem_ende
)
select  ${i}1,${i}1,'SoSe ${i}',
date_val('01.04.${i}'),
date_val('30.09.${i}')
from xdummy;

--WS:
insert into tmp_semester (
tid,
kurz,
druck,
sem_beginn,
sem_ende
)
select  ${i}2,${i}2,'WiSe ${i}/${i+1}',
date_val('01.10.${i}'),
date_val('31.03.${i}')
from xdummy;

</#list> 
</#if>

-- Akademische Jahre fr BAW und SA
-- Erluterung:
-- Sachsen:
-- Akademisches Jahr fr Absolventen:     2016 = 20152 + 20161
-- Akademisches Jahr fr Studienanfnger: 2016 = 20161 + 20162
-- Baden Wrtemberg:
-- Akademisches Jahr:                     2016 = 20162 + 20171
-- Akademisches Jahr:                     2017 = 20172 + 20181


--Berechnung akad.Jahr  BaWue:
--WS + nachfolgendes SS (2006 = 20062 + 20071)
--WS
update tmp_semester set akad_jahr=(tid/10) where mod(tid,10)=2; 
--SS
update tmp_semester set akad_jahr=(tid/10)-1 where mod(tid,10)=1;


--Berechnung akad.Jahr  SA Absolventen:
--vorheriges WS + SS (2006 = 20052 + 20061)
--WS
update tmp_semester set akad_jahr_absolv=(tid/10)+1 where mod(tid,10)=2; 
--SS
update tmp_semester set akad_jahr_absolv=(tid/10) where mod(tid,10)=1;



--Berechnung akad.Jahr SA Studienanfnger:
--SS + WS (2006 = 20061 + 20062)
--WS
update tmp_semester set akad_jahr_anf=(tid/10) where mod(tid,10)=2; 
--SS
update tmp_semester set akad_jahr_anf=(tid/10) where mod(tid,10)=1;


delete from tmp_semester where tid in (select tid from kenn_semester); 
insert into kenn_semester( tid,
       kurz,
       druck,
       akad_jahr,
       akad_jahr_absolv,
       akad_jahr_anf,
       sem_beginn,
       sem_ende)
      select
       tid,
       kurz,
       druck,
       akad_jahr,
       akad_jahr_absolv,
       akad_jahr_anf,
       sem_beginn,
       sem_ende
       from tmp_semester;
       
drop table tmp_semester;

