
--Freemarker Template 

<sqlvars>
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>
<sqlvar name="kenn_profil">
select apnr from konstanten where beschreibung='KENN_PROFIL';
</sqlvar>
</sqlvars>

--wird nur in Sachsen benutzt
<#if cob_installed=1 && kenn_profil=5>

CREATE temp TABLE tmp_prge
(
   projnr           char(10) ,
   ggnr             char(10)  ,
   k_extkotr char(10),
   klr_geldgeber char(10),
   jahr integer 
);

create temp table tmp_quartal
(
   tid integer,
    bezugszeit integer,
    jahr smallint,
    quartal integer
);

--zuerst alle Quartale zusammenstellen:

insert into tmp_quartal(
tid,
       bezugszeit,
       jahr,
       quartal
       )
select tid,
       val(bezugszeit || '1'),
       bezugszeit,
       1
  from kenn_stichtag
where stichtagsart='Kostenrechnung'
and berechnen='1'
and bezugsart='J';
insert into tmp_quartal(
tid,
       bezugszeit,
       jahr,
       quartal
       )
select tid,
       val(bezugszeit || '2'),
       bezugszeit,
       2
       
from kenn_stichtag
where stichtagsart='Kostenrechnung'
and berechnen='1'
and bezugsart='J';
insert into tmp_quartal(
tid,
       bezugszeit,
       jahr,
       quartal
       )
select tid,
       val(bezugszeit || '3'),
       bezugszeit,
       3
       
from kenn_stichtag
where stichtagsart='Kostenrechnung'
and berechnen='1'
and bezugsart='J';
insert into tmp_quartal(
tid,
       bezugszeit,
       jahr,
       quartal
       )
select tid,
       val(bezugszeit || '4'),
       bezugszeit,
       4
 from kenn_stichtag
where stichtagsart='Kostenrechnung'
and berechnen='1'
and bezugsart='J';

--nun die einzelnen Quartale, werden ggf. danach mit distinct rausgeworfen
insert into tmp_quartal(
tid,
       bezugszeit,
       jahr,
       quartal
       )
select tid,
       bezugszeit ,
       val(substring('' || bezugszeit from 1 for 4)),
       val(substring('' || bezugszeit from 5 for 1))
       
from kenn_stichtag
where stichtagsart='Kostenrechnung'
and berechnen='1'
and bezugsart='Q';

--

create temp table tmp_quartal2
(
  
    bezugszeit integer,
    jahr smallint,
    quartal integer,
    monat_von smallint,
    monat_bis smallint

);

insert into tmp_quartal2
(bezugszeit,
jahr,
       quartal)
select distinct bezugszeit,
jahr,
       quartal
       from tmp_quartal;
       
update tmp_quartal2 set monat_von=quartal*3-2;
update tmp_quartal2 set monat_bis=quartal*3;


insert into tmp_prge
(projnr,
k_extkotr,
ggnr,
jahr
)
select distinct P.projnr,P.k_extkotr,G.ggnr,Q.jahr
from cob_proj P, cob_prge G, tmp_quartal2 Q
where G.projnr=P.projnr
and G.fo_kz='*'
and  Q.jahr between  year(P.gueltig_seit) and year(P.gueltig_bis)
 ;

<#if KENN_PROJ_AUS_INST?exists && KENN_PROJ_AUS_INST !="">

insert into tmp_prge
(projnr,
k_extkotr,
ggnr,
jahr
)
select distinct cob_inst.key_apnr,E.key_extkotr,cob_inst.ggnr,Q.jahr
from tmp_quartal2 Q, cob_inst left outer join cob_inst_to_ext E
on (cob_inst.key_apnr=E.instnr)
where ${KENN_PROJ_AUS_INST}
and  Q.jahr between  year(cob_inst.gueltig_seit) and year(cob_inst.gueltig_bis)
 ;
</#if>

update tmp_prge set klr_geldgeber=(select klr_geldgeber from cob_geldgeber C
where C.ggnr=tmp_prge.ggnr);

delete from kenn_proj_gege
where jahr in (select distinct jahr from tmp_prge);

insert into kenn_proj_gege(hs_nr,
projnr,
klr_geldgeber,
k_extkotr,
jahr
)
SELECT H.hs_nr,
projnr,
klr_geldgeber,
k_extkotr,
jahr
from tmp_prge, hochschulinfo H;

drop table tmp_prge;
drop table tmp_quartal;
drop table tmp_quartal2;

</#if>
