
--Freemarker Template 

<sqlvars>
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>
<sqlvar name="sva_installed">
select count(*) from db_version where his_system ='sva';
</sqlvar>
<sqlvar name="sva_inst_to_ext_exists">
select sp_table_exists('sva_inst_to_ext') from xdummy;
</sqlvar>
</sqlvars>

<#if sva_installed==1 && sva_inst_to_ext_exists==1>
delete from kenn_inst_to_ext;

insert into kenn_inst_to_ext(
hs_nr,
       instnr,
       email,
       key_ext,
       dbez_ext,
       gebnr,
       key_extkotr
       )
SELECT H.hs_nr,
       instnr,
       email,
       key_ext,
       dbez_ext,
       gebnr,
       key_extkotr
FROM sva_inst_to_ext,hochschulinfo H;

</#if>

<#if cob_installed=1>
delete from kenn_inst_to_ext;

insert into kenn_inst_to_ext(
hs_nr,
       instnr,
       email,
       key_ext,
       dbez_ext,
       gebnr
       <#if TableFieldExists?exists && TableFieldExists('cob_inst_to_ext','key_extkotr')>
       ,key_extkotr
       </#if>
       )
SELECT H.hs_nr,
       instnr,
       email,
       key_ext,
       dbez_ext,
       gebnr
       <#if TableFieldExists?exists && TableFieldExists('cob_inst_to_ext','key_extkotr')>
       ,key_extkotr
       </#if>
FROM cob_inst_to_ext,hochschulinfo H;

</#if>

-- wenn gxstage als Datenquelle aktiviert ist, aus gxstage_inst.instnr/key_ext bernehmen
<#if K_KENN_GXSTAGE_STARTJAHR?exists&&K_KENN_GXSTAGE_STARTJAHR&gt;1900>

create temp table tmp_ext (gxstage_inst_key varchar(50), dbez_ext char(25),key_ext char(15), key_extkotr char(10)) <@informixnolog/>;
insert into tmp_ext (gxstage_inst_key,key_ext) select distinct inst_nr,key_ext from gxstage_inst where key_ext is not null;
   -- zur Sicherheit falls mal kein COB installiert mehr und die Tabelle manuell kenn_inst_to_ext angepasst wurde
   delete from tmp_ext where gxstage_inst_key in (select instnr from kenn_inst_to_ext);
  update tmp_ext set dbez_ext=(select min(dbez_ext) from kenn_inst_to_ext where tmp_ext.key_ext=kenn_inst_to_ext.key_ext);
    
  
  update tmp_ext set key_extkotr=(select min(key_extkotr) from kenn_inst_to_ext where tmp_ext.key_ext=kenn_inst_to_ext.key_ext);

 insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
 select distinct today(),'gxstage_inst','kenn_inst_to_ext',
   'In SAP fr '||gxstage_inst_key||' eingetragener externer Kostenstellenschluessel '||key_ext||' ist im Kennmodul unbekannt. Tippfehler?','Warnung'
      from tmp_ext where key_ext not  in (select distinct key_ext from kenn_inst_to_ext where key_ext is not null);

  insert into kenn_inst_to_ext(instnr,key_ext,dbez_ext,key_extkotr)
  select gxstage_inst_key,key_ext,dbez_ext,key_extkotr from tmp_ext;
  update kenn_inst_to_ext set hs_nr=(select hs_nr from hochschulinfo);
      
      drop table tmp_ext;

</#if>
