
--Freemarker Template 

<sqlvars>
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>
<sqlvar name="sva_installed">
select count(*) from db_version where his_system ='sva';
</sqlvar>
</sqlvars>

<#if cob_installed=1>
delete from kenn_inst
where 0=(select apnr from konstanten where beschreibung='KENN Inst. aus Organigr.');

insert into kenn_inst (
key_apnr, 
parent, 
drucktext, 
name, 
ebene, 
lehre, 
gueltig_seit, 
gueltig_bis, 
orgstruktur
)
select key_apnr, 
parent, 
drucktext, 
name, 
ebene, 
lehre, 
gueltig_seit, 
gueltig_bis, 
orgstruktur
from cob_inst
where 0=(select apnr from konstanten where beschreibung='KENN Inst. aus Organigr.');

update kenn_inst set name='NN',drucktext='NN'
where orgstruktur != 30 or orgstruktur is null;

update kenn_inst set hs_nr=(select hs_nr from hochschulinfo);
</#if>

--Ermittlung bund_fachgebiet und LFB aus sva_inst:
<#if sva_installed=1>
--nur Sachsen: ermittelt LFB aus inst.fins
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5)>
update kenn_inst set bund_lehr_forsch=(select min(I.fins)
from sva_inst I
where I.key_apnr=kenn_inst.key_apnr)
where bund_lehr_forsch is null;

<#else>
--auerhalb Sachsen wird inst.bund_lehr_forsch genommen
update kenn_inst set bund_lehr_forsch=(select min(I.bund_lehr_forsch)
from sva_inst I
where I.key_apnr=kenn_inst.key_apnr)
where bund_lehr_forsch is null;

</#if>
--bund_fachgebiet:
update kenn_inst set bund_fachgebiet=(select min(I.bund_fachgebiet)
from sva_inst I
where I.key_apnr=kenn_inst.key_apnr)
where bund_fachgebiet is null;

</#if>
