--freemarker template
<sqlvars>
<sqlvar name="laeuft_im_HUES_var">
select 1 from xdummy where 1 != (select count(*) from hochschulinfo)
union
select 0 from xdummy where 1 = (select count(*) from hochschulinfo);
</sqlvar>
</sqlvars>

<#assign laeuft_im_HUES=0 /> 
<#if laeuft_im_HUES_var =1>
<#assign laeuft_im_HUES=1 />
</#if>

<#assign  kost_arten = [
  {"art":"2", "name":"Gemeinsame Einrichtungen"},
  
  {"art":"3", "name":"Hochschulleitung/ZV"},
  {"art":"4", "name":"Zentrale Einrichtungen"},
  {"art":"9", "name":"Sonstige Einrichtungen"},
  {"art":"8", "name":"Gebudekostenstellen"}
  ] />

select 'Luft im HS: ${laeuft_im_HUES}' from xdummy; 


create temp table tmp_dim_extkost(
	hs_art CHAR(10) , 
hs_art_str VARCHAR(255) , 
hs_nr INTEGER , 
hs_nr_str VARCHAR(255) , 
kost_art VARCHAR(255) , 
extkost CHAR(40) , 
extkost_str VARCHAR(255) ,
key_ext char(40)
) 
;

--Fakultten:
insert into tmp_dim_extkost(
hs_nr,
kost_art,
extkost,
key_ext)
select distinct hs_nr,
'Fakultten',
'' || hs_nr ||'_' || substring(key_ext from 1 for 3),
substring(key_ext from 1 for 3)
from kenn_inst_to_ext  
where substring(key_ext from 1 for 1)='1'
;

<#foreach kost_art in kost_arten>

insert into tmp_dim_extkost(
hs_nr,
kost_art,
extkost,
extkost_str,
key_ext)
select distinct H.hs_nr,
'Weitere Einrichtungen',
'' || H.hs_nr ||'_' || substring(I.key_ext from 1 for 1),
trim(H.kurztext) || ' ' || '${kost_art.name}',
substring(I.key_ext from 1 for 1)
from kenn_inst_to_ext I, kenn_hochschulen H 
where I.hs_nr=H.hs_nr
and substring(I.key_ext from 1 for 1) ='${kost_art.art}'
;
</#foreach>
--Sonstige:
insert into tmp_dim_extkost(
hs_nr,
kost_art,
extkost,
extkost_str,
key_ext)
select distinct H.hs_nr,
'Weitere Einrichtungen',
'' || H.hs_nr ||'_S',
trim(H.kurztext) || ' auerhalb Systematik',
I.key_ext
from kenn_inst_to_ext I, kenn_hochschulen H 
where I.hs_nr=H.hs_nr  
and substring(I.key_ext from 1 for 1) not in ('1','2','3','4','8','9')
;

update tmp_dim_extkost set hs_art=(select H.art from kenn_hochschulen H
where H.hs_nr=tmp_dim_extkost.hs_nr);
update tmp_dim_extkost set hs_art_str='Universitten'
where hs_art='U';
update tmp_dim_extkost set hs_art_str='Hochschulen fr angewandte Wissenschaften'
where hs_art='FH';
update tmp_dim_extkost set hs_art_str='Pdagogische Hochschulen'
where hs_art='PH';
update tmp_dim_extkost set hs_art_str='Kunst- und Musikhochschulen'
where hs_art='KMW';
update tmp_dim_extkost set hs_art_str='Duale Hochschule'
where hs_art='DH';


update tmp_dim_extkost set hs_nr_str=(select H.name from kenn_hochschulen H
where H.hs_nr=tmp_dim_extkost.hs_nr);

--Namen von Fakultten raussuchen:
--zuerst den Schlssel:
update tmp_dim_extkost set key_ext=(select min(I.key_ext)
from kenn_inst_to_ext I
where I.hs_nr= tmp_dim_extkost.hs_nr
and substring(I.key_ext from 1 for 3)=substring(tmp_dim_extkost.key_ext from 1 for 3)
)
where key_ext like '1%';
--Dann den Namen
update tmp_dim_extkost set extkost_str=(select min(trim(H.kurztext) || ' ' || I.dbez_ext)
from kenn_inst_to_ext I, kenn_hochschulen H
where H.hs_nr=I.hs_nr
and I.key_ext=tmp_dim_extkost.key_ext
and I.hs_nr= tmp_dim_extkost.hs_nr
)
where key_ext like '1%';

delete from kenn_dim_extkost;

insert into kenn_dim_extkost
(
hs_art,
hs_art_str,
hs_nr,
hs_nr_str,
kost_art,
extkost,
extkost_str)
select hs_art,
hs_art_str,
hs_nr,
hs_nr_str,
kost_art,
extkost,
extkost_str
from tmp_dim_extkost;

drop table tmp_dim_extkost;


