--(c) 2011 Andre Knieschewski
--Freemarker Template

<sqlvars>
<sqlvar name="kenn_versionierung_testdaten_anlegen_count">SELECT count(*) AS testdaten_anlegen FROM konstanten WHERE beschreibung = 'KENN_VERSIONIERUNG_TESTDATEN_ANLEGEN';</sqlvar>
</sqlvars>

<#assign versionierung_testdaten_anlegen=(kenn_versionierung_testdaten_anlegen_count>0) />



-- 32120_kam_hauptgr_html.jrxml und 18560_kaufm_quartalsbericht_html.jrxml sind Kopien der Exceldatei mit einzigem Unterschied dass Werte .double()/1000 sind, damit Dimension T Eur ausgegeben wird

-- !!!!!!!!!!!!
-- !!Hinweise!!
-- !!!!!!!!!!!!
-- - Achtung: Macro fgt Inhalte ein
-- - Bitte nur Freemarker Variablen fllen
-- - bei nderungen/Aktualisierungen in den Variablen werden die Stylesheets geupdatet 
-- 		 das gilt nicht bei nderungen an filename und contenttype,
-- 		 denn filename und contenttype werden als Primrschlssel genutzt,
--		 es muss dann ein delete (s. u.) auf den alten Datensatz ergnzt werden

<#assign masken = [
{"mask":"18240", "filename":"tabelle_html_18240.xsl", "ord":"1"},
{"mask":"18340", "filename":"tabelle_html_18340.xsl", "ord":"1"},
{"mask":"18180", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18180", "filename":"kostentraeger_lehre_fo.xsl", "ord":"2"},
{"mask":"18760", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18760", "filename":"tabelle_fo_pdf_18760.xsl", "ord":"2"},
{"mask":"18780", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18780", "filename":"tabelle_fo_pdf_18760.xsl", "ord":"2"},
{"mask":"18800", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18420", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18800", "filename":"tabelle_fo_pdf_18760.xsl", "ord":"2"},
{"mask":"18820", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18820", "filename":"tabelle_fo_pdf_18760.xsl", "ord":"2"},
{"mask":"18840", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18840", "filename":"tabelle_fo_pdf_18760.xsl", "ord":"2"},
{"mask":"18860", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18860", "filename":"tabelle_fo_pdf_18760.xsl", "ord":"2"},
{"mask":"18780", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18780", "filename":"tabelle_fo_pdf_18760.xsl", "ord":"2"},
{"mask":"18800", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18800", "filename":"tabelle_fo_pdf_18760.xsl", "ord":"2"},
{"mask":"18820", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18820", "filename":"tabelle_fo_pdf_18760.xsl", "ord":"2"},
{"mask":"18840", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18840", "filename":"tabelle_fo_pdf_18760.xsl", "ord":"2"},
{"mask":"18860", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18860", "filename":"tabelle_fo_pdf_18760.xsl", "ord":"2"},
{"mask":"18880", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18880", "filename":"tabelle_fo_pdf_18880.xsl", "ord":"2"},
{"mask":"18480", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18480", "filename":"tabelle_fo_pdf_18480.xsl", "ord":"2"},
{"mask":"18220", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18220", "filename":"18220_kreuztabelle_hochschule_zeitraum.jrxml", "ord":"2"}
{"mask":"18100", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18100", "filename":"18100_kreuztabelle_hochschule_zeitraum.jrxml", "ord":"2"},
{"mask":"18000", "filename":"18000_kreuztabelle_hochschule_zeitraum.jrxml", "ord":"1"},
{"mask":"18000", "filename":"18000_kreuztabelle_hochschule_zeitraum_lfb.jrxml", "ord":"2"},
{"mask":"18000", "filename":"18000_kreuztabelle_hochschule_zeitraum_lfb_quote.jrxml", "ord":"3"},
{"mask":"18400", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18480", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18380", "filename":"maske_html_kenn_presubmit.xsl", "ord":"1"},
{"mask":"18380", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18380", "filename":"18380_guv_bilanz.jrxml", "ord":"2"},
{"mask":"18380", "filename":"18380_guv2.jrxml", "ord":"3"},
{"mask":"18380", "filename":"18380_guv2_v20241231.jrxml", "ord":"3"},
{"mask":"18380", "filename":"18380_guv2_excel.jrxml", "ord":"4"},
{"mask":"18380", "filename":"18380_guv2_excel_v20241231.jrxml", "ord":"4"},
{"mask":"18380", "filename":"18380_bilanz2.jrxml", "ord":"5"},
{"mask":"18380", "filename":"18380_bilanz2_excel.jrxml", "ord":"6"},
{"mask":"18560", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18560", "filename":"18560_quartalsbericht.jrxml", "ord":"2"},
{"mask":"18560", "filename":"18560_kaufm_quartalsbericht.jrxml", "ord":"3"},
{"mask":"18560", "filename":"18560_kaufm_quartalsbericht_excel.jrxml", "ord":"4"},
{"mask":"18560", "filename":"18560_kaufm_quartalsbericht_html.jrxml", "ord":"5"},
{"mask":"18560", "filename":"18560_kaufm_quartalsbericht_v20241231.jrxml", "ord":"3"},
{"mask":"18560", "filename":"18560_kaufm_quartalsbericht_excel_v20241231.jrxml", "ord":"4"},
{"mask":"18560", "filename":"18560_kaufm_quartalsbericht_html_v20241231.jrxml", "ord":"5"},
{"mask":"18560", "filename":"maske_html_kenn_presubmit.xsl", "ord":"1"},
{"mask":"32020", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"32020", "filename":"tabelle_32020_tablayout.jrxml", "ord":"2"},
{"mask":"32060", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"32060", "filename":"tabelle_32060_qp_crosstab.jrxml", "ord":"2"},
{"mask":"18100", "filename":"18100_zheb_sachsen_gesamt.jrxml", "ord":"2"},
{"mask":"18100", "filename":"18100_zheb_sachsen_gesamt_v20241231.jrxml", "ord":"2"},
{"mask":"18100", "filename":"18100_zheb_sachsen_gesamt_pdf.jrxml", "ord":"10"},
{"mask":"18100", "filename":"18100_zheb_sachsen_gesamt_pdf_v20241231.jrxml", "ord":"10"},
{"mask":"18100", "filename":"18100_zheb_sachsen_lfb.jrxml", "ord":"3"},
{"mask":"18100", "filename":"18100_zheb_sachsen_lfb_pdf.jrxml", "ord":"11"},
{"mask":"32560", "filename":"18100_zheb_sachsen_gesamt.jrxml", "ord":"2"},
{"mask":"32560", "filename":"18100_zheb_sachsen_lfb.jrxml", "ord":"3"},
{"mask":"32560", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18700", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18700", "filename":"18700_kenn_bestand_hs_kreuztab.jrxml", "ord":"10"},
{"mask":"18700", "filename":"18700_kenn_bestand_hs_kreuztab_sachsen.jrxml", "ord":"20"},
{"mask":"18980", "filename":"maske_html_kenn_presubmit.xsl", "ord":"1"},
{"mask":"18980", "filename":"18980_quartalsbericht_excel.jrxml", "ord":"2"},
{"mask":"18980", "filename":"18980_quartalsbericht.jrxml", "ord":"1"},
{"mask":"18980", "filename":"tabelle_html.xsl", "ord":"3"},
{"mask":"18520", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18520", "filename":"maske_html_kenn_presubmit.xsl", "ord":"1"},
{"mask":"18520", "filename":"18520_kam_jahresbericht_excel.jrxml", "ord":"2"},
{"mask":"18520", "filename":"18520_kam_jahresbericht.jrxml", "ord":"1"},
{"mask":"32120", "filename":"maske_html_kenn_presubmit.xsl", "ord":"1"},
{"mask":"32120", "filename":"32120_kam_hauptgr.jrxml", "ord":"1"},
{"mask":"32120", "filename":"32120_kam_hauptgr_excel.jrxml", "ord":"2"},
{"mask":"32120", "filename":"32120_kam_hauptgr_html.jrxml", "ord":"3"},
{"mask":"32120", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"18540", "filename":"maske_html_kenn_presubmit.xsl", "ord":"0"},
{"mask":"18540", "filename":"18540_sbb_excel.jrxml", "ord":"1"},
{"mask":"18540", "filename":"18540_sbb_excel_v20241231.jrxml", "ord":"1"},
{"mask":"18540", "filename":"18540_sbb_xmlsource.jrxml", "ord":"2"},
{"mask":"18540", "filename":"18540_sbb_v20241231_xmlsource.jrxml", "ord":"2"},
{"mask":"18540", "filename":"tabelle_html.xsl", "ord":"3"},
{"mask":"32380", "filename":"32380_sbb_1207_excel.jrxml", "ord":"1"},
{"mask":"32380", "filename":"32380_sbb_1207_excel_v20241231.jrxml", "ord":"1"},
{"mask":"32380", "filename":"32380_sbb_1207_xmlsource.jrxml", "ord":"2"},
{"mask":"32380", "filename":"32380_sbb_1207_v20241231_xmlsource.jrxml", "ord":"2"},
{"mask":"32380", "filename":"tabelle_html.xsl", "ord":"3"},
{"mask":"32380", "filename":"maske_html_kenn_presubmit.xsl", "ord":"0"},
{"mask":"32360", "filename":"32360_Stellen_lt._HH-Plan.jrxml", "ord":"3"},
{"mask":"32360", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"32320", "filename":"tabelle_html_32320.xsl", "ord":"1"},
{"mask":"32620", "filename":"18540_sbb_excel.jrxml", "ord":"1"},
{"mask":"32620", "filename":"18540_sbb_xmlsource.jrxml", "ord":"3"},
{"mask":"32620", "filename":"tabelle_html.xsl", "ord":"4"},
{"mask":"32640", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"32640", "filename":"18100_kreuztabelle_hochschule_zeitraum.jrxml", "ord":"2"},
{"mask":"32640", "filename":"18100_zheb_sachsen_gesamt.jrxml", "ord":"2"},
{"mask":"32640", "filename":"18100_zheb_sachsen_gesamt_pdf.jrxml", "ord":"10"},
{"mask":"32640", "filename":"18100_zheb_sachsen_lfb.jrxml", "ord":"3"},
{"mask":"32640", "filename":"18100_zheb_sachsen_lfb_pdf.jrxml", "ord":"11"},
{"mask":"32680", "filename":"18520_kam_jahresbericht_excel.jrxml", "ord":"2"},
{"mask":"32680", "filename":"18520_kam_jahresbericht.jrxml", "ord":"1"},
{"mask":"32680", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"32700", "filename":"32120_kam_hauptgr.jrxml", "ord":"1"},
{"mask":"32700", "filename":"32120_kam_hauptgr_excel.jrxml", "ord":"2"},
{"mask":"32700", "filename":"32120_kam_hauptgr_html.jrxml", "ord":"3"},
{"mask":"32700", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"32720", "filename":"18980_quartalsbericht_excel.jrxml", "ord":"2"},
{"mask":"32720", "filename":"18980_quartalsbericht.jrxml", "ord":"1"},
{"mask":"32720", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"32740", "filename":"18380_guv_bilanz.jrxml", "ord":"2"},
{"mask":"32740", "filename":"18380_guv2.jrxml", "ord":"3"},
{"mask":"32740", "filename":"18380_guv2_excel.jrxml", "ord":"4"},
{"mask":"32740", "filename":"18380_bilanz2.jrxml", "ord":"5"},
{"mask":"32740", "filename":"18380_bilanz2_excel.jrxml", "ord":"6"},
{"mask":"32740", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"32760", "filename":"18560_quartalsbericht.jrxml", "ord":"2"},
{"mask":"32760", "filename":"18560_kaufm_quartalsbericht.jrxml", "ord":"3"},
{"mask":"32760", "filename":"18560_kaufm_quartalsbericht_excel.jrxml", "ord":"4"},
{"mask":"32760", "filename":"18560_kaufm_quartalsbericht_html.jrxml", "ord":"5"},
{"mask":"32760", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"32780", "filename":"32380_sbb_1207_excel.jrxml", "ord":"1"},
{"mask":"32780", "filename":"32380_sbb_1207_xmlsource.jrxml", "ord":"2"},
{"mask":"32780", "filename":"tabelle_html.xsl", "ord":"1"},
{"mask":"32900", "filename":"tabelle_html_datenblatt.xsl", "ord":"1"},
{"mask":"32930", "filename":"tabelle_html_datenblatt.xsl", "ord":"1"},
{"mask":"32960", "filename":"tabelle_html_datenblatt.xsl", "ord":"1"},
{"mask":"32980", "filename":"tabelle_html.xsl", "ord":"1"}

] />

<#assign stylesheet = [
{"filename":"tabelle_html.xsl", "caption":"Generisches Standardlayout", "description":"Tabelle", "relation":"table", "contenttype":"text/html"},
{"filename":"tabelle_html_datenblatt.xsl", "caption":"Generisches Standardlayout Datenbltter", "description":"Tabelle", "relation":"table", "contenttype":"text/html"},
{"filename":"tabelle_html_18240.xsl", "caption":"Tabelle Kennzahlen hinzufgen", "description":"Tabelle Kennzahlen hinzufgen", "relation":"table", "contenttype":"text/html; charset=ISO-8859-1"},
{"filename":"tabelle_html_18340.xsl", "caption":"Tabelle Hierarchie speichern", "description":"Tabelle  Hierarchie speichern", "relation":"table", "contenttype":"text/html; charset=ISO-8859-1"},
{"filename":"kostentraeger_lehre_fo.xsl", "caption":"PDF-Ausgabe Kostentrger Lehre", "description":"PDF-Ausgabe Kostentrger Lehre", "relation":"table", "contenttype":"application/pdf"},
{"filename":"tabelle_fo_pdf_18760.xsl", "caption":"Studentenstatistik erzeugen", "description":"Export in PDF (Adobe)", "relation":"table", "contenttype":"application/pdf"},
{"filename":"tabelle_fo_pdf_18880.xsl", "caption":"Bewerber- und Studentenstatistik Drucklayout", "description":"Export in PDF (Adobe)", "relation":"table", "contenttype":"application/pdf"},
{"filename":"tabelle_fo_pdf_18480.xsl", "caption":"Bewerber- und Studentenstatistik Drucklayout", "description":"Export in PDF (Adobe)", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18220_kreuztabelle_hochschule_zeitraum.jrxml", "caption":"Kreuztabelle Hochschule und Zeitraum", "description":"Export in Kreuztabelle mit Hochschule und Zeitraum in den Spalten", "relation":"table", "contenttype":"application/pdf"}, 
{"filename":"18100_kreuztabelle_hochschule_zeitraum.jrxml", "caption":"Kreuztabelle Hochschule und Zeitraum (Sachsen)", "description":"Export in Kreuztabelle mit Hochschule und Zeitraum in den Spalten (fr Sachsen)", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18000_kreuztabelle_hochschule_zeitraum.jrxml", "caption":"Kreuztabelle Produkt, Hochschule und Zeitraum", "description":"Export in Kreuztabelle mit Produktgruppe/Produkt in den Zeilen und Hochschule und Zeitraum in den Spalten", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18000_kreuztabelle_hochschule_zeitraum_lfb.jrxml", "caption":"Kreuztabelle LFB, Hochschule und Zeitraum", "description":"Export in Kreuztabelle mit Fchergruppe/Lehr- und Forschungsbereich in den Zeilen und Hochschule und Zeitraum in den Spalten", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18000_kreuztabelle_hochschule_zeitraum_lfb_quote.jrxml", "caption":"Kreuztabelle LFB, Hochschule und Zeitraum (Quote)", "description":"Export in Kreuztabelle mit Fchergruppe/Lehr- und Forschungsbereich in den Zeilen und Hochschule und Zeitraum in den Spalten, ohne Summenbildung, dafr Mittelwerte", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18380_guv_bilanz.jrxml", "caption":"Kaufmnnischer Abschluss", "description":"Kaufmnnischer Abschluss", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18380_guv2.jrxml", "caption":"GuV PDF", "description":"GuV", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18380_guv2_v20241231.jrxml", "caption":"GuV PDF", "description":"GuV", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18380_guv2_excel.jrxml", "caption":"GuV Excel", "description":"GuV", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18380_guv2_excel_v20241231.jrxml", "caption":"GuV Excel", "description":"GuV", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18380_guv2_excel.jrxml", "caption":"GuV HTML", "description":"GuV", "relation":"table", "contenttype":"text/html"},
{"filename":"18380_guv2_excel_v20241231.jrxml", "caption":"GuV HTML", "description":"GuV", "relation":"table", "contenttype":"text/html"},
{"filename":"18380_bilanz2.jrxml", "caption":"Bilanz PDF", "description":"Bilanz", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18380_bilanz2_excel.jrxml", "caption":"Bilanz Excel", "description":"Bilanz", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18380_bilanz2_excel.jrxml", "caption":"Bilanz HTML", "description":"Bilanz", "relation":"table", "contenttype":"text/html"},
{"filename":"18560_quartalsbericht.jrxml", "caption":"Kaufmnnischer Quartalsbericht", "description":"Kaufmnnischer Quartalsbericht", "relation":"table", "contenttype":"application/pdf"},
{"filename":"tabelle_32020_tablayout.jrxml", "caption":"Export Datenblatt Semesterberichte", "description":"Export der Bewerber und Studienanfnger", "relation":"table", "contenttype":"text/txt"},
{"filename":"tabelle_32060_qp_crosstab.jrxml", "caption":"Querschnittsprodukte Kreuztabelle", "description":"Querschnittsprodukte nach Hochschule", "relation":"table", "contenttype":"text/txt"},
{"filename":"18100_zheb_sachsen_lfb.jrxml", "caption":"Hochschulerfolgsbericht Sachsen (LFB) Excel", "description":"Hochschulerfolgsbericht Sachsen (LFB)", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18100_zheb_sachsen_gesamt.jrxml", "caption":"Hochschulerfolgsbericht Sachsen (Hochschule) Excel", "description":"Hochschulerfolgsbericht Sachsen (Hochschule)", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18100_zheb_sachsen_gesamt_v20241231.jrxml", "caption":"Hochschulerfolgsbericht Sachsen (Hochschule) Excel", "description":"Hochschulerfolgsbericht Sachsen (Hochschule)", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18100_zheb_sachsen_lfb_pdf.jrxml", "caption":"Hochschulerfolgsbericht Sachsen (LFB) PDF", "description":"Hochschulerfolgsbericht Sachsen (LFB)", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18100_zheb_sachsen_gesamt_pdf.jrxml", "caption":"Hochschulerfolgsbericht Sachsen (Hochschule) PDF", "description":"Hochschulerfolgsbericht Sachsen (Hochschule)", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18100_zheb_sachsen_gesamt_pdf_v20241231.jrxml", "caption":"Hochschulerfolgsbericht Sachsen (Hochschule) PDF", "description":"Hochschulerfolgsbericht Sachsen (Hochschule)", "relation":"table", "contenttype":"application/pdf"},
{"filename":"maske_html_18100.xsl", "caption":"Hochschulerfolgsbericht (Sachsen) Maske", "description":"Zielorientierter Hochschulerfolgsbericht (Sachsen) Maske", "relation":"mask", "contenttype":"text/html"},
{"filename":"18700_kenn_bestand_hs_kreuztab.jrxml", "caption":"bersicht der Bestnde Kreuztabelle", "description":"bersicht der Bestnde Kreuztabelle (Hochschule in Spalten)", "relation":"table", "contenttype":"application/pdf"},
{"filename":"maske_html_kenn_presubmit.xsl", "caption":"Kenn mit presubmit", "description":"Kenn mit presubmit", "relation":"mask", "contenttype":"text/html"},
{"filename":"18980_quartalsbericht_excel.jrxml", "caption":"Kameraler Quartalsbericht Excel", "description":"Kameraler Quartalsbericht", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18980_quartalsbericht.jrxml", "caption":"Kameraler Quartalsbericht PDF", "description":"Kameraler Quartalsbericht", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18980_quartalsbericht.jrxml", "caption":"Kameraler Quartalsbericht HTML", "description":"Kameraler Quartalsbericht", "relation":"table", "contenttype":"text/html"},
{"filename":"18520_kam_jahresbericht_excel.jrxml", "caption":"Kameraler Jahresabschluss Excel", "description":"Kameraler Jahresabschluss", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18520_kam_jahresbericht_excel.jrxml", "caption":"Kameraler Jahresabschluss HTML", "description":"Kameraler Jahresabschluss", "relation":"table", "contenttype":"text/html"},
{"filename":"18520_kam_jahresbericht.jrxml", "caption":"Kameraler Jahresabschluss PDF", "description":"Kameraler Jahresabschluss", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18560_kaufm_quartalsbericht.jrxml", "caption":"Kaufmnnischer Quartalsbericht PDF", "description":"Kaufmnnischer Quartalsbericht", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18560_kaufm_quartalsbericht_excel.jrxml", "caption":"Kaufmnnischer Quartalsbericht Excel", "description":"Kaufmnnischer Quartalsbericht", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18560_kaufm_quartalsbericht_html.jrxml", "caption":"Kaufmnnischer Quartalsbericht HTML", "description":"Kaufmnnischer Quartalsbericht", "relation":"table", "contenttype":"text/html"},
{"filename":"18560_kaufm_quartalsbericht_v20241231.jrxml", "caption":"Kaufmnnischer Quartalsbericht PDF", "description":"Kaufmnnischer Quartalsbericht", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18560_kaufm_quartalsbericht_excel_v20241231.jrxml", "caption":"Kaufmnnischer Quartalsbericht Excel", "description":"Kaufmnnischer Quartalsbericht", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18560_kaufm_quartalsbericht_html_v20241231.jrxml", "caption":"Kaufmnnischer Quartalsbericht HTML", "description":"Kaufmnnischer Quartalsbericht", "relation":"table", "contenttype":"text/html"},
{"filename":"32120_kam_hauptgr.jrxml", "caption":"Kam. Jahresabschluss nach Hauptgruppen PDF", "description":"Kam.Jahresabschluss nach Hauptgruppen", "relation":"table", "contenttype":"application/pdf"},
{"filename":"32120_kam_hauptgr_excel.jrxml", "caption":"Kam. Jahresabschluss nach Hauptgruppen Excel", "description":"Kam.Jahresabschluss nach Hauptgruppen", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"32120_kam_hauptgr_html.jrxml", "caption":"Kam. Jahresabschluss nach Hauptgruppen HTML", "description":"Kam.Jahresabschluss nach Hauptgruppen", "relation":"table", "contenttype":"text/html"},
{"filename":"18540_sbb_xmlsource.jrxml", "caption":"Stellenbewirtschaftungsbericht PDF", "description":"Stellenbewirtschaftungsbericht PDF", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18540_sbb_v20241231_xmlsource.jrxml", "caption":"Stellenbewirtschaftungsbericht v20241231 PDF", "description":"Stellenbewirtschaftungsbericht v20241231 PDF", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18540_sbb_xmlsource.jrxml", "caption":"Stellenbewirtschaftungsbericht HTML", "description":"Stellenbewirtschaftungsbericht PDF", "relation":"table", "contenttype":"text/html"},
{"filename":"18540_sbb_v20241231_xmlsource.jrxml", "caption":"Stellenbewirtschaftungsbericht v20241231 HTML", "description":"Stellenbewirtschaftungsbericht v20241231 HTML", "relation":"table", "contenttype":"text/html"},
{"filename":"18540_sbb_excel.jrxml", "caption":"Stellenbewirtschaftungsbericht Excel", "description":"Stellenbewirtschaftungsbericht Excel", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18540_sbb_excel_v20241231.jrxml", "caption":"Stellenbewirtschaftungsbericht v20241231 Excel", "description":"Stellenbewirtschaftungsbericht v20241231 Excel", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"32380_sbb_1207_xmlsource.jrxml", "caption":"Stellenbewirtschaftungsbericht - Kapitel 1207 PDF", "description":"Stellenbewirtschaftungsbericht - Kapitel 1207 PDF", "relation":"table", "contenttype":"application/pdf"},
{"filename":"32380_sbb_1207_v20241231_xmlsource.jrxml", "caption":"Stellenbewirtschaftungsbericht - Kapitel 1207 v20241231 PDF", "description":"Stellenbewirtschaftungsbericht - Kapitel 1207 v20241231 PDF", "relation":"table", "contenttype":"application/pdf"},
{"filename":"32380_sbb_1207_xmlsource.jrxml", "caption":"Stellenbewirtschaftungsbericht - Kapitel 1207 HTML", "description":"Stellenbewirtschaftungsbericht - Kapitel 1207 PDF", "relation":"table", "contenttype":"text/html"},
{"filename":"32380_sbb_1207_v20241231_xmlsource.jrxml", "caption":"Stellenbewirtschaftungsbericht - Kapitel 1207 v20241231 HTML", "description":"Stellenbewirtschaftungsbericht - Kapitel 1207 v20241231 HTML", "relation":"table", "contenttype":"text/html"},
{"filename":"32380_sbb_1207_excel.jrxml", "caption":"Stellenbewirtschaftungsbericht - Kapitel 1207 Excel", "description":"Stellenbewirtschaftungsbericht - Kapitel 1207 Excel", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"32380_sbb_1207_excel_v20241231.jrxml", "caption":"Stellenbewirtschaftungsbericht - Kapitel 1207 v20241231 Excel", "description":"Stellenbewirtschaftungsbericht - Kapitel 1207 v20241231 Excel", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"32360_Stellen_lt._HH-Plan.jrxml", "caption":"Template fr die manuelle Schnittstelle des STBB", "description":"Template fr die manuelle Schnittstelle des STBB", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"tabelle_html_32320.xsl", "caption":"Dokument hochladen Ergebnis", "description":"Dokument hochladen", "relation":"table", "contenttype":"text/html"},
{"filename":"18540_sbb_excel_v20240122.jrxml", "caption":"Stellenbewirtschaftungsbericht Excel Version ab 22.01.2024", "description":"Stellenbewirtschaftungsbericht Excel Version ab 22.01.2024", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18540_sbb_excel_v20240101.jrxml", "caption":"Stellenbewirtschaftungsbericht Excel Version bis 21.01.2024", "description":"Stellenbewirtschaftungsbericht Excel Version bis 21.01.2024", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18100_zheb_sachsen_gesamt_v20240131.jrxml", "caption":"Hochschulerfolgsbericht Sachsen (Hochschule) Excel Version bis 31.01.2024", "description":"Hochschulerfolgsbericht Sachsen (Hochschule) Excel Version bis 31.01.2024", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18100_zheb_sachsen_gesamt_pdf_v20240131.jrxml", "caption":"Hochschulerfolgsbericht Sachsen (Hochschule) PDF Version bis 31.01.2024", "description":"Hochschulerfolgsbericht Sachsen (Hochschule) PDF Version bis 31.01.2024", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18100_zheb_sachsen_gesamt_v20181231.jrxml", "caption":"Hochschulerfolgsbericht Sachsen (Hochschule) Excel Version bis 31.12.2018", "description":"Hochschulerfolgsbericht Sachsen (Hochschule) Excel Version bis 31.12.2018", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
{"filename":"18100_zheb_sachsen_gesamt_pdf_v20181231.jrxml", "caption":"Hochschulerfolgsbericht Sachsen (Hochschule) PDF Version bis 18.12.2024", "description":"Hochschulerfolgsbericht Sachsen (Hochschule) PDF Version bis 31.12.2018", "relation":"table", "contenttype":"application/pdf"},
{"filename":"18700_kenn_bestand_hs_kreuztab_sachsen.jrxml", "caption":"bersicht der Bestnde Kreuztabelle (Sachsen)", "description":"bersicht der Bestnde Kreuztabelle (Hochschule in Spalten) (Sachsen)", "relation":"table", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}
] />

<#if versionierung_testdaten_anlegen>
    <#assign masken = masken + [
     {"mask":18100,"filename":"18100_zheb_sachsen_gesamt_pdf_testversion.jrxml","ord":10},
     {"mask":18100,"filename":"18100_zheb_sachsen_gesamt_testversion.jrxml","ord":2},
     {"mask":18100,"filename":"18100_zheb_sachsen_lfb_pdf_testversion.jrxml","ord":11},
     {"mask":18100,"filename":"18100_zheb_sachsen_lfb_testversion.jrxml","ord":3},
     {"mask":32640,"filename":"18100_zheb_sachsen_gesamt_pdf_testversion.jrxml","ord":10},
     {"mask":32640,"filename":"18100_zheb_sachsen_gesamt_testversion.jrxml","ord":2},
     {"mask":32640,"filename":"18100_zheb_sachsen_lfb_pdf_testversion.jrxml","ord":11},
     {"mask":32640,"filename":"18100_zheb_sachsen_lfb_testversion.jrxml","ord":3},
     {"mask":18380,"filename":"18380_bilanz2_excel_testversion.jrxml","ord":6},
     {"mask":18380,"filename":"18380_bilanz2_testversion.jrxml","ord":5},
     {"mask":18380,"filename":"18380_guv2_excel_testversion.jrxml","ord":4},
     {"mask":18380,"filename":"18380_guv2_testversion.jrxml","ord":3},
     {"mask":32740,"filename":"18380_bilanz2_excel_testversion.jrxml","ord":6},
     {"mask":32740,"filename":"18380_bilanz2_testversion.jrxml","ord":5},
     {"mask":32740,"filename":"18380_guv2_excel_testversion.jrxml","ord":4},
     {"mask":32740,"filename":"18380_guv2_testversion.jrxml","ord":3},
     {"mask":18520,"filename":"18520_kam_jahresbericht_excel_testversion.jrxml","ord":2},
     {"mask":18520,"filename":"18520_kam_jahresbericht_testversion.jrxml","ord":1},   
     {"mask":32680,"filename":"18520_kam_jahresbericht_excel_testversion.jrxml","ord":2},
     {"mask":32680,"filename":"18520_kam_jahresbericht_testversion.jrxml","ord":1},
     {"mask":18540,"filename":"18540_sbb_excel_testversion.jrxml","ord":1},
     {"mask":18540,"filename":"18540_sbb_xmlsource_testversion.jrxml","ord":2},
     {"mask":32620,"filename":"18540_sbb_excel_testversion.jrxml","ord":1},
     {"mask":32620,"filename":"18540_sbb_xmlsource_testversion.jrxml","ord":2},
     {"mask":18560,"filename":"18560_kaufm_quartalsbericht_excel_testversion.jrxml","ord":4},
     {"mask":18560,"filename":"18560_kaufm_quartalsbericht_testversion.jrxml","ord":3},
     {"mask":32760,"filename":"18560_kaufm_quartalsbericht_excel_testversion.jrxml","ord":4},
     {"mask":32760,"filename":"18560_kaufm_quartalsbericht_testversion.jrxml","ord":3},
     {"mask":18980,"filename":"18980_quartalsbericht_excel_testversion.jrxml","ord":2},
     {"mask":18980,"filename":"18980_quartalsbericht_testversion.jrxml","ord":1},
     {"mask":32720,"filename":"18980_quartalsbericht_excel_testversion.jrxml","ord":2},
     {"mask":32720,"filename":"18980_quartalsbericht_testversion.jrxml","ord":1},
     {"mask":32120,"filename":"32120_kam_hauptgr_excel_testversion.jrxml","ord":2},
     {"mask":32120,"filename":"32120_kam_hauptgr_html_testversion.jrxml","ord":3},
     {"mask":32120,"filename":"32120_kam_hauptgr_testversion.jrxml","ord":1},
     {"mask":32700,"filename":"32120_kam_hauptgr_excel_testversion.jrxml","ord":2},
     {"mask":32700,"filename":"32120_kam_hauptgr_html_testversion.jrxml","ord":3},
     {"mask":32700,"filename":"32120_kam_hauptgr_testversion.jrxml","ord":1},
     {"mask":32380,"filename":"32380_sbb_1207_excel_testversion.jrxml","ord":1},
     {"mask":32380,"filename":"32380_sbb_1207_xmlsource_testversion.jrxml","ord":2},     
     {"mask":32780,"filename":"32380_sbb_1207_excel_testversion.jrxml","ord":1},
     {"mask":32780,"filename":"32380_sbb_1207_xmlsource_testversion.jrxml","ord":2}
    ] />

    <#assign stylesheet = stylesheet + [
     {"filename":"18100_zheb_sachsen_gesamt_pdf_testversion.jrxml","caption":"Hochschulerfolgsbericht Sachsen (Hochschule) PDF (testversion)","description":"Hochschulerfolgsbericht Sachsen (Hochschule)","relation":"table","contenttype":"application/pdf"},
     {"filename":"18100_zheb_sachsen_gesamt_testversion.jrxml","caption":"Hochschulerfolgsbericht Sachsen (Hochschule) Excel (testversion)","description":"Hochschulerfolgsbericht Sachsen (Hochschule)","relation":"table","contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
     {"filename":"18100_zheb_sachsen_lfb_pdf_testversion.jrxml","caption":"Hochschulerfolgsbericht Sachsen (LFB) PDF (testversion)","description":"Hochschulerfolgsbericht Sachsen (LFB)","relation":"table","contenttype":"application/pdf"},
     {"filename":"18100_zheb_sachsen_lfb_testversion.jrxml","caption":"Hochschulerfolgsbericht Sachsen (LFB) Excel (testversion)","description":"Hochschulerfolgsbericht Sachsen (LFB)","relation":"table","contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
     {"filename":"18380_bilanz2_excel_testversion.jrxml","caption":"Bilanz Excel (testversion)","description":"Bilanz","relation":"table","contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
     {"filename":"18380_bilanz2_excel_testversion.jrxml","caption":"Bilanz HTML (testversion)","description":"Bilanz","relation":"table","contenttype":"text/html"},
     {"filename":"18380_bilanz2_testversion.jrxml","caption":"Bilanz PDF (testversion)","description":"Bilanz","relation":"table","contenttype":"application/pdf"},
     {"filename":"18380_guv2_excel_testversion.jrxml","caption":"GuV Excel (testversion)","description":"GuV","relation":"table","contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
     {"filename":"18380_guv2_excel_testversion.jrxml","caption":"GuV HTML (testversion)","description":"GuV","relation":"table","contenttype":"text/html"},
     {"filename":"18380_guv2_testversion.jrxml","caption":"GuV PDF (testversion)","description":"GuV","relation":"table","contenttype":"application/pdf"},
     {"filename":"18520_kam_jahresbericht_excel_testversion.jrxml","caption":"Kameraler Jahresabschluss Excel (testversion)","description":"Kameraler Jahresabschluss","relation":"table","contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
     {"filename":"18520_kam_jahresbericht_excel_testversion.jrxml","caption":"Kameraler Jahresabschluss HTML (testversion)","description":"Kameraler Jahresabschluss","relation":"table","contenttype":"text/html"},
     {"filename":"18520_kam_jahresbericht_testversion.jrxml","caption":"Kameraler Jahresabschluss PDF (testversion)","description":"Kameraler Jahresabschluss","relation":"table","contenttype":"application/pdf"},
     {"filename":"18540_sbb_excel_testversion.jrxml","caption":"Stellenbewirtschaftungsbericht Excel (testversion)","description":"Stellenbewirtschaftungsbericht Excel","relation":"table","contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
     {"filename":"18540_sbb_xmlsource_testversion.jrxml","caption":"Stellenbewirtschaftungsbericht PDF (testversion)","description":"Stellenbewirtschaftungsbericht PDF","relation":"table","contenttype":"application/pdf"},
     {"filename":"18540_sbb_xmlsource_testversion.jrxml","caption":"Stellenbewirtschaftungsbericht HTML (testversion)","description":"Stellenbewirtschaftungsbericht PDF","relation":"table","contenttype":"text/html"},
     {"filename":"18560_kaufm_quartalsbericht_excel_testversion.jrxml","caption":"Kaufmnnischer Quartalsbericht Excel (testversion)","description":"Kaufmnnischer Quartalsbericht","relation":"table","contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
     {"filename":"18560_kaufm_quartalsbericht_testversion.jrxml","caption":"Kaufmnnischer Quartalsbericht PDF (testversion)","description":"Kaufmnnischer Quartalsbericht","relation":"table","contenttype":"application/pdf"},
     {"filename":"18560_kaufm_quartalsbericht_testversion.jrxml","caption":"Kaufmnnischer Quartalsbericht HTML (testversion)","description":"Kaufmnnischer Quartalsbericht","relation":"table","contenttype":"text/html"},
     {"filename":"18980_quartalsbericht_excel_testversion.jrxml","caption":"Kameraler Quartalsbericht Excel (testversion)","description":"Kameraler Quartalsbericht","relation":"table","contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
     {"filename":"18980_quartalsbericht_testversion.jrxml","caption":"Kameraler Quartalsbericht PDF (testversion)","description":"Kameraler Quartalsbericht","relation":"table","contenttype":"application/pdf"},
     {"filename":"18980_quartalsbericht_testversion.jrxml","caption":"Kameraler Quartalsbericht HTML (testversion)","description":"Kameraler Quartalsbericht","relation":"table","contenttype":"text/html"},
     {"filename":"32120_kam_hauptgr_excel_testversion.jrxml","caption":"Kam. Jahresabschluss nach Hauptgruppen Excel (testversion)","description":"Kam.Jahresabschluss nach Hauptgruppen","relation":"table","contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
     {"filename":"32120_kam_hauptgr_html_testversion.jrxml","caption":"Kam. Jahresabschluss nach Hauptgruppen HTML (testversion)","description":"Kam.Jahresabschluss nach Hauptgruppen","relation":"table","contenttype":"text/html"},
     {"filename":"32120_kam_hauptgr_testversion.jrxml","caption":"Kam. Jahresabschluss nach Hauptgruppen PDF (testversion)","description":"Kam.Jahresabschluss nach Hauptgruppen","relation":"table","contenttype":"application/pdf"},
     {"filename":"32380_sbb_1207_excel_testversion.jrxml","caption":"Stellenbewirtschaftungsbericht - Kapitel 1207 Excel (testversion)","description":"Stellenbewirtschaftungsbericht - Kapitel 1207 Excel","relation":"table","contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"},
     {"filename":"32380_sbb_1207_xmlsource_testversion.jrxml","caption":"Stellenbewirtschaftungsbericht - Kapitel 1207 PDF (testversion)","description":"Stellenbewirtschaftungsbericht - Kapitel 1207 PDF","relation":"table","contenttype":"application/pdf"},
     {"filename":"32380_sbb_1207_xmlsource_testversion.jrxml","caption":"Stellenbewirtschaftungsbericht - Kapitel 1207 HTML (testversion)","description":"Stellenbewirtschaftungsbericht - Kapitel 1207 PDF","relation":"table","contenttype":"text/html"}
    ] />
</#if>

<#assign stylesheet_field = [
{"filename":"tabelle_32060_qp_crosstab.jrxml", "tablename":"kenn_vtbu_qp_aggr", "fieldname":"ziel_projnr"},
{"filename":"tabelle_32060_qp_crosstab.jrxml", "tablename":"kenn_vtbu_qp_aggr", "fieldname":"hs_nr"},
{"filename":"tabelle_32060_qp_crosstab.jrxml", "tablename":"kenn_vtbu_qp_aggr", "fieldname":"betrag"}
] />



--Hier eventuell notwendige delete's auf die Tabellen sx_mask_style, sx_stylesheets oder stylesheet_field einfgen.
delete from sx_mask_style where maskeninfo_id=18220 and stylesheet_id in (select tid from sx_stylesheets where filename ='18220_kreuztabelle_hochschule_zeitraum.jrxml');
delete from sx_mask_style where maskeninfo_id=18240 and stylesheet_id in (select tid from sx_stylesheets where filename ='maske_html_18240.xsl');
delete from sx_mask_style where maskeninfo_id=32380 and stylesheet_id in (select tid from sx_stylesheets where filename ='32380_sbb_1207.jrxml');
delete from sx_mask_style where maskeninfo_id=18540 and stylesheet_id in (select tid from sx_stylesheets where filename ='18540_sbb_xmlsource.jrxml');
delete from sx_mask_style where maskeninfo_id=18100 and stylesheet_id in (select tid from sx_stylesheets where filename ='18100_zheb_sachsen_gesamt_v20240131.jrxml');
delete from sx_mask_style where maskeninfo_id=18100 and stylesheet_id in (select tid from sx_stylesheets where filename ='18100_zheb_sachsen_gesamt_pdf_v20240131.jrxml');
delete from sx_mask_style where maskeninfo_id=18100 and stylesheet_id in (select tid from sx_stylesheets where filename ='18100_zheb_sachsen_gesamt_v20181231.jrxml');
delete from sx_mask_style where maskeninfo_id=18100 and stylesheet_id in (select tid from sx_stylesheets where filename ='18100_zheb_sachsen_gesamt_pdf_v20181231.jrxml');
delete from sx_mask_style where maskeninfo_id=18100 and stylesheet_id in (select tid from sx_stylesheets where filename ='maske_html_18100.xsl');
delete from sx_mask_style where maskeninfo_id=18100 and stylesheet_id in (select tid from sx_stylesheets where filename ='18380_bilanz2_excel.jrxml');
delete from sx_mask_style where stylesheet_id in (select tid from sx_stylesheets where filename ='maske_html_kenn_presubmit.xsl');
delete from sx_mask_style where maskeninfo_id=18540 and stylesheet_id in (select tid from sx_stylesheets where filename ='18540_sbb_excel_v20240122.jrxml');
delete from sx_mask_style where maskeninfo_id=18540 and stylesheet_id in (select tid from sx_stylesheets where filename ='18540_sbb_excel_v20240101.jrxml');
--delete from sx_mask_style where maskeninfo_id in (18140,18380,18560) ;
delete from sx_stylesheets where filename in ('18380_guv_bilanz_xmlsource.jrxml','18560_quartalsbericht_xmlsource.jrxml','32380_sbb_1207.jrxml');


--Achtung: ab hier nicht ndern, Mutterdatei ist $SUPERX_DIR/db/module/sos/schluesseltabellen/sx_stylesheets_fuellen.sql

update sx_stylesheets set uniquename=filename||'-'||contenttype where uniquename is null; 

-- Zombies eliminieren
delete from sx_mask_style where stylesheet_id not in (select tid from sx_stylesheets);

 <@sx_stylesheets_insert
m_masken=masken
m_stylesheet=stylesheet
m_stylesheet_field=stylesheet_field
/>


<#macro sx_stylesheets_insert m_masken m_stylesheet m_stylesheet_field>

-- hinzugefgt durch ij 17.04.2024, damit updates ber Variable erfolgen
<#foreach column in m_stylesheet>

	update sx_stylesheets set caption='${column.caption}' where filename ='${column.filename}' and contenttype ='${column.contenttype}';
	update sx_stylesheets set description='${column.description}' where filename ='${column.filename}' and contenttype ='${column.contenttype}';
	update sx_stylesheets set relation='${column.relation}' where filename ='${column.filename}' and contenttype ='${column.contenttype}';
	--update sx_stylesheets set contenttype='${column.contenttype}' where filename ='${column.filename}' and contenttype ='${column.contenttype}';
	
	--Sicherstellen, dass keine Duplikate vorkommen:
	--####################################################################################################
	<#foreach column_m in m_masken>
		<#if column_m.filename=column.filename>
			delete from sx_mask_style where maskeninfo_id=${column_m.mask} and stylesheet_id in (select tid from sx_stylesheets where filename ='${column_m.filename}' and contenttype ='${column.contenttype}') and ord=${column_m.ord};
		</#if>
	</#foreach>

	<#foreach column_m in m_stylesheet_field>
		<#if column_m.filename=column.filename>
			delete from stylesheet_field where tablename='${column_m.tablename}' and stylesheet_id=(select tid from sx_stylesheets where filename ='${column_m.filename}' and contenttype ='${column.contenttype}') and fieldname='${column_m.fieldname}';
		</#if>
	</#foreach>
	
</#foreach>



--delete sx_stylesheets raus genommen #ak 06.03.2013



-- Stylesheets fllen
--####################################################################################################
create temp table tmp_stylesheets (
tid         serial  not null, 
filename    CHAR(255) , 
caption     CHAR(255) , 
description CHAR(255) , 
relation    CHAR(10) , 
useragent   CHAR(255) , 
contenttype CHAR(200),
uniquename varchar(255)  
);

create temp table tmp_hilf (tid integer);
insert into tmp_hilf select max(tid) from sx_stylesheets;
update tmp_hilf set tid=1 where tid is null;

<#assign couter_tid = 1 />
<#foreach column in m_stylesheet>
insert into tmp_stylesheets (tid,filename,caption,description,relation,contenttype,uniquename)
select max(tid)+${couter_tid},'${column.filename}','${column.caption}', '${column.description}', '${column.relation}','${column.contenttype}','${column.filename}'||'-'||'${column.contenttype}' from tmp_hilf;
<#assign couter_tid = couter_tid + 1 />
</#foreach>

--delete fr tml_stylesheets hinzugefgt #ak 06.03.2013
delete from tmp_stylesheets where filename ||'-'|| contenttype in (select filename ||'-'|| contenttype from sx_stylesheets);


insert into sx_stylesheets (tid,filename, caption, description, relation, useragent, contenttype,uniquename)
SELECT tid, filename, caption, description, relation, useragent, contenttype,uniquename
FROM tmp_stylesheets;

drop table tmp_stylesheets;


-- Mask Style fllen
--####################################################################################################
create temp table tmp_mask_style (
tid serial    not null, 
maskeninfo_id INTEGER , 
stylesheet_id INTEGER , 
ord           SMALLINT,
filename      char(255),
contenttype	  varchar(255)
);

delete from tmp_hilf;
insert into tmp_hilf select max(tid) from sx_mask_style;
update tmp_hilf set tid=1 where tid is null;

<#assign couter_tid = 1 />
<#foreach column in m_stylesheet>
	<#foreach column_m in m_masken>
		<#if column_m.filename=column.filename>
			insert into tmp_mask_style (tid,maskeninfo_id,ord,filename,contenttype)
			select max(tid)+${couter_tid},${column_m.mask},${column_m.ord},'${column_m.filename}','${column.contenttype}' from tmp_hilf;

			update tmp_mask_style set stylesheet_id=(select max(tid) from sx_stylesheets where filename ='${column_m.filename}' and contenttype ='${column.contenttype}')
			where filename ='${column_m.filename}' and contenttype ='${column.contenttype}';
			<#assign couter_tid = couter_tid + 1 />
		</#if>
	</#foreach>
</#foreach>

insert into sx_mask_style ( tid, maskeninfo_id, stylesheet_id, ord)
SELECT tid, maskeninfo_id, stylesheet_id, ord
FROM tmp_mask_style;

drop table tmp_mask_style;


--Field zu Stylesheet Zuordnungen:
--####################################################################################################
CREATE temp TABLE tmp_stylesheet_field
(
tid           serial        NOT NULL,
stylesheet_id INTEGER,
tablename     char(255),
fieldname     char(255),
filename      char(255),
contenttype	  varchar(255)
);

delete from tmp_hilf;
insert into tmp_hilf select max(tid) from stylesheet_field;
update tmp_hilf set tid=1 where tid is null;

<#assign couter_tid = 1 />
<#foreach column in m_stylesheet>
	<#foreach column_m in m_stylesheet_field>
		<#if column_m.filename=column.filename>
			INSERT INTO tmp_stylesheet_field (tid, filename,contenttype, tablename, fieldname)
			select max(tid)+${couter_tid}, '${column_m.filename}','${column.contenttype}', '${column_m.tablename}', '${column_m.fieldname}' from tmp_hilf;

			update tmp_stylesheet_field set stylesheet_id=(select max(tid) from sx_stylesheets where filename ='${column_m.filename}' and contenttype ='${column.contenttype}')
			where filename ='${column_m.filename}' and contenttype ='${column.contenttype}';
			<#assign couter_tid = couter_tid + 1 />
		</#if>
	</#foreach>
</#foreach>

insert into stylesheet_field ( tid, stylesheet_id, tablename, fieldname)
SELECT tid, stylesheet_id, tablename, fieldname
FROM tmp_stylesheet_field;

drop table tmp_stylesheet_field;
drop table tmp_hilf;

<#if SQLdialect='Postgres'>
select sp_update_sequence('sx_stylesheets');
select sp_update_sequence('sx_mask_style');
select sp_update_sequence('stylesheet_field');
</#if>

</#macro>
