--(c) 2008 Daniel Quathamer
--freemarker template
     

CREATE temp TABLE tmp_sichten (
    tid serial NOT NULL,
    parent character(255),
    systeminfoid integer DEFAULT 0 NOT NULL,
    art character(40),
    type integer ,
    name_intern character(200),
    name character(200),
    beschreibung character(255),
    sortnr integer DEFAULT 0 NOT NULL,
    quelle character(255),
    alt_hier_id character(150),
    treecfgtable character(255),
    treecfgid character(150),
    label smallint DEFAULT 0 NOT NULL,
    user_rechte smallint DEFAULT 1 NOT NULL,
    rechtequelle character(255),
    sesamkey character(100),
    standbutton smallint DEFAULT 0 NOT NULL,
    attribut1 character(255),
    attribut2 character(255),
    attribut3 integer,
    attribut4 integer,
    xmlmaxentries integer,
    gueltig_seit date ,
    gueltig_bis date,
    aktiv smallint DEFAULT 1
);

--sx_auto_upload_table.x tmp_sichten "$SOS_PFAD/schluesseltabellen/sichten.unl"

create temp table tmp_hilf (tid integer);
insert into tmp_hilf select max(tid) from sichten;
update tmp_hilf set tid=0 where tid is null;


INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Kostentrger-Sicht'  ,
  1000  ,
  'kenn_extkotr_lehre'  , 
  'KENN externe Kostentrger (Lehre)'  ,
  1  , 
  '', --quelle wird unten per update definiert, damit es auch im Upgrade klappt
  0  , 
  0  ,  
  1 , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;


--neu ab kenn 0.7rc8:
INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Kostentrger-Sicht'  ,
  1000  ,
  'kenn_extkotr_lehre_k'  , 
  'KENN externe Kostentrger (Lehre LeFgr)'  ,
  1  , 
  '',  --quelle wird unten per update definiert, damit es auch im Upgrade klappt
  0  , 
  0  ,  
  1  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;

  INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Kostentrger-Sicht'  ,
  10  ,
  'kenn_extkotr'  , 
  'KENN externe Kostentrger'  ,
  1  , 
  '',  --quelle wird unten per update definiert, damit es auch im Upgrade klappt
  0  , 
  0  ,  
  1  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;

   INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Kostentrger-Sicht'  ,
  10  ,
  'kenn_qp'  , 
  'KENN Querschnittsprodukte'  ,
  1  , 
  '<<SQL>> select name,key,parent,string_not_null(kategorie)||''-''||string_not_null(fins_stugfach) from kenn_extkotr where key in (''extkotr'',''Q.'') or key like ''1400.%'' order by 2', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
  --neu ab KENN 1.2:
    INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Kostentrger-Sicht'  ,
  10  ,
  'kenn_extkotr_a'  , 
  'KENN externe Kostentrger (historisch)'  ,
  1  , 
  '',  --quelle wird unten per update definiert, damit es auch im Upgrade klappt
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
 INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Hochschulen-Sicht'  ,
  10  ,
  'kenn_hs'  , 
  'Hochschulen'  ,
  10  , 
  'select name,hs_nr::char(10),null::char(10) from hochschulinfo;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf
  --nicht im HS:
  where 1=(select count(*) from hochschulinfo);

  INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Fcher-Sicht'  ,
  10  ,
  'kenn_stg_astat_list'  , 
  'Fcher (Liste)'  ,
  20  , 
  'select dtxt,astat,''--alle--'',1,struktur_c from kenn_stg_astat where struktur_c=''Fach (amtlich)'' union select ''Alle'',''--alle--'',null::char(10),1,''Summe'' from xdummy;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;

   INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Fcher-Sicht'  ,
  10  ,
  'kenn_stg_astat_grp'  , 
  'Fcher (gruppiert)'  ,
  15  , 
  'select dtxt,astat,parent,1,struktur_c from kenn_stg_astat order by dtxt;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
  INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Fcher-Sicht'  ,
  10  ,
  'kenn_stg_sb_grp'  , 
  'Fcher und Studienbereiche'  ,
  10  , 
  'select name,apnr,parent,ebene,struktur_str from kenn_stg_sb order by name;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
  --Default fr Semesterberichte, daher sortnr=0:
   INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Fcher-Sicht'  ,
  10  ,
  'kenn_stg_fgr_grp'  , 
  'Fcher und Fchergruppen'  ,
  0  , 
  'select druck,apnr,parent,ebene,struktur_c from kenn_cifx where key=676 order by 1;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;

   INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Kostenarten-Sicht'  ,
  10  ,
  'kenn_fikr_bvkr'  , 
  'Kostenarten (BVKR) KLR'  ,
  1  , 
  'select trim(apnr) || ''-'' || druck,apnr,parent,1,ebene from kenn_cifx where key=668 and today() between d_akt_von and d_akt_bis order by apnr;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
   INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Hochschulen/Standorte-Sicht'  ,
  10  ,
  'kenn_hs_stort_tr'  , 
  'Hochschulen/Standorte nach Trgerschaft'  ,
  80  , 
  'select name,apnr,parent,ebene,struktur_str from kenn_hs_stort_trg order by 1;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
  INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Hochschulen/Standorte-Sicht'  ,
  10  ,
  'kenn_hs_stort_art'  , 
  'Hochschulen/Standorte nach HS-Typ'  ,
  70  , 
  'select name,apnr,parent,ebene,struktur_str from kenn_hs_stort_art order by 1;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
  INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Hochschulen/Standorte-Sicht'  ,
  10  ,
  'kenn_hs_st_trgart'  , 
  'Hochschulen/Standorte nach HS-Typ und Trgerschaft'  ,
  1  , 
  'select name,apnr,parent,ebene,struktur_str from kenn_hs_st_trgart order by 1;', 
--'select name,apnr,parent,ebene,struktur_str from kenn_hs_st_trgart union select name,apnr,parent,ebene,struktur_str from sp_kenn_hs_st_trgart(<<UserID>>) order by 1;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
  INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Hochschulen/Standorte-Sicht'  ,
  10  ,
  'kenn_hs_stort'  , 
  'Hochschulen/Standorte (alphabetisch)'  ,
  50  , 
  'select name,apnr,parent,ebene,struktur_str from kenn_hs_stort order by 1;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
  --in Zukunft auch  Haushalt:
    -- INSERT INTO tmp_sichten(
  -- systeminfoid  , 
  -- art  , 
  -- type  , 
  -- name_intern  , 
  -- name  , 
  -- sortnr  ,
  -- quelle  ,
  -- label  , 
  -- user_rechte  ,
  -- standbutton  , 
    -- gueltig_seit  ,
   -- gueltig_bis  , aktiv
   -- ) select 
  -- 109  ,
  -- 'KENN-Kostenarten-Sicht'  ,
  -- 10  ,
  -- 'kenn_fikr_bvkr_mbs'  , 
  -- 'Kostenarten (BVKR) Haushalt'  ,
  -- 1  , 
  -- 'select trim(apnr) || ''-'' || druck,apnr,parent,1,ebene from kenn_cifx where key=669 and today() between d_akt_von and d_akt_bis order by apnr;', 
  -- 0  , 
  -- 0  ,  
  -- 0  , 
  -- date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;

--fr Joolap-KENN auch schonmal die Anlageklassen, wg. Berechtigung
   INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Anlageklassen-Sicht'  ,
  10  ,
  'kenn_akl'  , 
  'Anlageklassen'  ,
  1  , 
  'select trim(apnr) || ''-'' || druck,apnr,parent,1,ebene from kenn_cifx where key=671 and today() between d_akt_von and d_akt_bis order by apnr;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;

  
-- neu: 
  INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Fcher-Intern-Sicht'  ,
  10  ,
  'kenn_stg_int_list'  , 
  'Fcher intern (Liste)'  ,
  20  , 
  'select ''Alle'',''-alle-'',null::char(10) as parent from xdummy union select druck,astat,''-alle-'' from kenn_stg_int', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
  
  INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Fcher-Intern-Sicht'  ,
  10  ,
  'kenn_stg_int_group'  , 
  'Fcher intern (gruppiert)'  ,
  10  , 
  'select dtxt,astat,parent from kenn_stg_astat union select H.name || '': '' || druck,H.hs_nr || ''_'' || apnr,astat from kenn_stg_int I,hochschulinfo H where H.hs_nr=I.hs_nr', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
  
  
  INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-HZB-Sicht'  ,
  10  ,
  'kenn_hzbart_group'  , 
  'Hochschulzugangsberechtigung (gruppiert)'  ,
  20  , 
  'select ''Alle'',''-alle-'',null::char(10) as parent from xdummy union select druck,astat,''-alle-'' from kenn_hzbart union select druck,apnr,gruppe::char(10) from kenn_hzbart_astat', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
  --HZB-liste sortnr =40
    INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-HZB-Sicht'  ,
  10  ,
  'kenn_hzbart_list'  , 
  'Hochschulzugangsberechtigung (Liste)'  ,
  20  , 
  'select ''Alle'',''-alle-'',null::char(10) as parent from xdummy union select druck,apnr,''-alle-'' from kenn_hzbart_astat', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;
  
  
  INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Abschluss-Intern-Sicht'  ,
  10  ,
  'kenn_abschl_int_list'  , 
  'Abschluss intern (Liste)'  ,
  40  , 
  'select ''Alle'',''-alle-'',null::char(10) as parent from xdummy union select druck,apnr,''-alle-'' from kenn_abint', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;

  INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Abschluss-Intern-Sicht'  ,
  10  ,
  'kenn_abschl_int_group'  , 
  'Abschluss intern (gruppiert)'  ,
  20  , 
  'select dtxt,astat,parent from kenn_abschl_astat union select H.name || '': '' || druck,H.hs_nr || ''_'' || apnr,astat from kenn_abint I,hochschulinfo H where H.hs_nr=I.hs_nr;', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;


INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-LFB-Sicht'  ,
  10  ,
  'kenn_fg_lfb'  , 
  'Fchergruppen und Lehr- und Forschungsbereiche'  ,
  10  , 
  'SELECT drucktext,apnr,parent FROM kenn_lfb_fg where struktur_c != ''Fachgebiet'' order by 3', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;

INSERT INTO tmp_sichten(
  systeminfoid  , 
  art  , 
  type  , 
  name_intern  , 
  name  , 
  sortnr  ,
  quelle  ,
  label  , 
  user_rechte  ,
  standbutton  , 
    gueltig_seit  ,
   gueltig_bis  , aktiv
   ) select 
  109  ,
  'KENN-Katalog-Sicht'  ,
  10  ,
  'kenn_report_katalog'  , 
  'Kennzahlenberichte und Kennzahlen'  ,
  10  , 
  'SELECT trim(nvl(uniquename || ''. '','''')) || '' '' || druck,apnr,parent,quelltabelle as struktur_str,sortnr FROM kenn_report_katalog where report_id=''MWKBW2017'' order by 5,1', 
  0  , 
  0  ,  
  0  , 
  date_val('01.01.1900')  , date_val('01.01.3000') , 1 from tmp_hilf;

    
  
--jetzt einfgen:

--Rechte fr Sichten geben
select 'Rechte fr Sichten geben' from xdummy;
delete from sachgeb_sichtarten where sachgebiete_id in (109,110,111,112,113);
insert into sachgeb_sichtarten
(
   sachgebiete_id ,
   sichtart 
)
select distinct 109,art from tmp_sichten;
insert into sachgeb_sichtarten
(
   sachgebiete_id ,
   sichtart 
)
select distinct 110,art from tmp_sichten;
insert into sachgeb_sichtarten
(
   sachgebiete_id ,
   sichtart 
)
select distinct 111,art from tmp_sichten;
insert into sachgeb_sichtarten
(
   sachgebiete_id ,
   sichtart 
)
select distinct 112,art from tmp_sichten;
insert into sachgeb_sichtarten
(
   sachgebiete_id ,
   sichtart 
)
select distinct 113,art from tmp_sichten;
--Ende Rechte
delete from tmp_sichten where name_intern in (select name_intern from sichten);

--Die Sichten ext kotr werden immer gendert:

update sichten set quelle='<<SQL>> select trim(key) || ''-'' || name,key,parent,string_not_null(kategorie)||''-''||string_not_null(fins_stugfach) from kenn_extkotr where <<Stand>> between gueltig_von and gueltig_bis order by 1 ',
art='KENN-Kostentrger-Sicht',
standbutton=1
where trim(name_intern)='kenn_extkotr';



update sichten set quelle='<<SQL>> select trim(key) || ''-'' || name,key,parent from kenn_extkotr where (key like ''01%'' or key like ''11%'') and <<Stand>> between gueltig_von and gueltig_bis union select ''Lehre'',''L'',null::char(30) from xdummy order by 1 ',
art='KENN-Kostentrger-Sicht',
standbutton=1
where trim(name_intern)='kenn_extkotr_lehre';

update sichten set quelle='<<SQL>> select trim(key) || ''-'' || name,key,parent from kenn_extkotr_lehre_k where <<Stand>> between gueltig_von and gueltig_bis order by 2',
standbutton=1
where trim(name_intern)='kenn_extkotr_lehre_k';


update sichten set quelle='<<SQL>> select trim(key) || ''-'' || name,key,parent from kenn_extkotr_a order by 2'
where trim(name_intern)='kenn_extkotr_a';


update tmp_hilf set tid=(select max(tid) from sichten);
update tmp_hilf set tid=0 where tid is null;

  INSERT INTO sichten(tid,
     systeminfoid  , art  , type  , name_intern  , name  , 
    sortnr  , quelle  , label  , 
    user_rechte  ,  standbutton  , 
     xmlmaxentries  , 
    gueltig_seit  , gueltig_bis  , aktiv)
    select S.tid+H.tid,systeminfoid  , art  , type  , name_intern  , name  , 
    sortnr  , quelle  , label  , 
    user_rechte  ,  standbutton  , 
     xmlmaxentries  , 
    gueltig_seit  , gueltig_bis  , aktiv
    from tmp_sichten S, tmp_hilf H;

<#if SQLdialect='Postgres'>
select setval('sichten_tid_seq',(select max(tid) from sichten));
</#if>



delete from sachgeb_sichtarten where sichtart='KENN-Lehre-Sicht'; 

--ggf. in alten Versionen schon Rechte fr Sichtart KENN-Lehre-Sicht:
update user_sichtarten set sichtart='KENN-Kostentrger-Sicht' where sichtart='KENN-Lehre-Sicht';
update group_sichtarten set sichtart='KENN-Kostentrger-Sicht' where sichtart='KENN-Lehre-Sicht';


drop table tmp_sichten;
drop table tmp_hilf; 
