
create table tmp_stgid(
id integer,
 Name varchar(255),
 Abschluss varchar(255),
Verkettung_Name_Absschluss varchar(255),
 Abschlussbezeichnung varchar(255),
 Studienbeginn varchar(255),
 Regelstudienzeit varchar(255),
 Besonderheiten varchar(255),
 Schwerpunkte varchar(255),
 Unterrichtssprache varchar(255),
 Studiengebuehren varchar(255),
Fachbereich varchar(255),
 Hochschule varchar(255),
 Ort varchar(255),
 Studienbereich varchar(255)
 )
;
create table tmp_hs(
HS_Arten varchar(255),
HS_Arten_kurz varchar(255),
hs_nr varchar(255),
HS_Schluessel varchar(255),
DHBW varchar(255),
Sortierschluessel varchar(255),
Name_Sortierschluessel varchar(255),
HS_Name varchar(255),
Abkrzung_HS_Name varchar(255),
Regierungsbezirkname varchar(255),
Region_Name varchar(255),
Kreis_Nr varchar(255),
Kreisname varchar(255),
Bemerkungen varchar(255)
);

\! sx_auto_upload_table.x tmp_hs Hochschulen.csv
\! sx_auto_upload_table.x tmp_stgid stgid.csv

alter table tmp_stgid add column hs_nr integer;
alter table tmp_stgid add column hs_nr_str varchar(255);
alter table tmp_stgid add column stort char(10);
alter table tmp_stgid add column abgrp char(10);

update tmp_stgid set abgrp='A24' where abschluss ='Bachelor';
update tmp_stgid set abgrp='A37' where abschluss ='Master';


update tmp_stgid set hs_nr=(select val(H.hs_nr)
from tmp_hs H, kenn_hochschulen K
where H.HS_Name=tmp_stgid.Hochschule
and K.hs_nr::varchar(255)=H.hs_nr)
;
update tmp_stgid set hs_nr=(select K.hs_nr
from kenn_hochschulen K
where replace(K.name,'HAW','Hochschule')=tmp_stgid.Hochschule)
where hs_nr is null
;
update tmp_stgid set hs_nr=(select K.hs_nr
from kenn_hochschulen K
where replace(K.name,'HV','Hochschule')=tmp_stgid.Hochschule)
where hs_nr is null
;
update tmp_stgid set hs_nr=(select K.hs_nr
from kenn_hochschulen K
where replace(K.name,'Uni','Universitt')=tmp_stgid.Hochschule)
where hs_nr is null
;
update tmp_stgid set hs_nr=8170,stort=(select K.apnr
from kenn_stort K
where K.hs_nr=8170
and position(K.druck in tmp_stgid.Hochschule)>0

)
where hs_nr is null
and Hochschule like 'Duale%'
;

--Einzelne:
update tmp_stgid set hs_nr= null where Hochschule='Akademie fr Darstellende Kunst Baden-Wrttemberg'; --soll gelscht werden
update tmp_stgid set hs_nr= 7020 where Hochschule='AKAD Hochschulen';
update tmp_stgid set hs_nr= 6900 where Hochschule='Evangelische Hochschule Freiburg';
update tmp_stgid set hs_nr= 7190 where Hochschule='Evangelische Hochschule Ludwigsburg';--oder 7192?
update tmp_stgid set hs_nr= 7120 where Hochschule='Fachhochschule Schwetzingen - Hochschule fr Rechtspflege';
update tmp_stgid set hs_nr= null where Hochschule='Filmakademie Baden-Wrttemberg';  --soll gelscht werden
update tmp_stgid set hs_nr= 50 where Hochschule='German Graduate School of Management & Law Heilbronn';
update tmp_stgid set hs_nr= 60 where Hochschule='Hochschule der Bundesagentur fr Arbeit Mannheim';
update tmp_stgid set hs_nr= 6860 where Hochschule='Hochschule der Medien, Stuttgart';
update tmp_stgid set hs_nr= 7050 where Hochschule='Hochschule fr Gestaltung, Schwbisch Gmnd';
update tmp_stgid set hs_nr= 1980 where Hochschule='Hochschule fr Kunst, Design und Populre Musik';
update tmp_stgid set hs_nr= 7010 where Hochschule='Hochschule fr Kunsttherapie Nrtingen';
update tmp_stgid set hs_nr= 2670 where Hochschule='Hochschule fr Musik Karlsruhe';
update tmp_stgid set hs_nr= 7060 where Hochschule='Hochschule fr ffentliche Verwaltung Kehl';
update tmp_stgid set hs_nr= 7070 where Hochschule='Hochschule fr ffentliche Verwaltung und Finanzen Ludwigsburg';
update tmp_stgid set hs_nr= 7140 where Hochschule='Hochschule fr Polizei Villingen-Schwenningen';
update tmp_stgid set hs_nr= 6741 where Hochschule='Hochschule Furtwangen - Hochschule fr Informatik, Technik, Wirtschaft und Medien';
update tmp_stgid set hs_nr= 6780 where Hochschule='Hochschule Mannheim';
update tmp_stgid set hs_nr= 6791 where Hochschule='Hochschule Nrtingen-Geislingen';
update tmp_stgid set hs_nr= 6820 where Hochschule='Hochschule Ravensburg';
update tmp_stgid set hs_nr= 8150 where Hochschule='Karlshochschule International University';
update tmp_stgid set hs_nr= 1580 where Hochschule='Karlsruher Institut fr Technologie (KIT) (Universitt Karlsruhe)';
update tmp_stgid set hs_nr= 6910 where Hochschule='Katholische Hochschule Freiburg';
update tmp_stgid set hs_nr= 6970 where Hochschule='Merz Akademie, Hochschule fr Gestaltung, Kunst und Medien, Stuttgart';
update tmp_stgid set hs_nr= 6890 where Hochschule='nta Hochschule Isny';
update tmp_stgid set hs_nr= null where Hochschule='Popakademie Baden-Wrttemberg'; --soll gelscht werden
update tmp_stgid set hs_nr= 7180 where Hochschule='SRH FernHochschule Riedlingen';
update tmp_stgid set hs_nr= 7600 where Hochschule='SRH Hochschule fr Wirtschaft und Medien Calw';
update tmp_stgid set hs_nr= 7090 where Hochschule='SRH Hochschule Heidelberg';
update tmp_stgid set hs_nr= 2950 where Hochschule='Staatliche Akademie der Bildenden Knste Karlsruhe';
update tmp_stgid set hs_nr= 2960 where Hochschule='Staatliche Akademie der Bildenden Knste Stuttgart';
update tmp_stgid set hs_nr= 2940 where Hochschule='Staatliche Hochschule fr Gestaltung Karlsruhe';
update tmp_stgid set hs_nr= 2650 where Hochschule='Staatliche Hochschule fr Musik Freiburg';
update tmp_stgid set hs_nr= 2700 where Hochschule='Staatliche Hochschule fr Musik Trossingen';
update tmp_stgid set hs_nr= 2661 where Hochschule='Staatliche Hochschule fr Musik und Darstellende Kunst Mannheim';
update tmp_stgid set hs_nr= 2690 where Hochschule='Staatliche Hochschule fr Musik und Darstellende Kunst Stuttgart';
update tmp_stgid set hs_nr= 7680 where Hochschule='Theologische Hochschule Reutlingen';

--Kontrollselect Hochschulen:
-- select distinct T.Hochschule as "Hochschule gscheit_studiert",trim(H.name) as "Hochschule SuperX",
-- T.hs_nr into temp tmp_hs2 from tmp_stgid T
-- left outer join kenn_hochschulen H
-- on (H.hs_nr=T.hs_nr)
-- order by 1;
-- 
-- \copy tmp_hs2 to stgid_hochschulen.csv with delimiter as ':' null as '' csv header
--drop table tmp_hs2;

--Kontrollselect Duplikate:
--select id
--from tmp_stgid
--group by 1
--having count(*) > 1;

-- select distinct hochschule from tmp_stgid
-- where hs_nr is null
-- order by 1;


--Hochschulnamen dazuholen:
update tmp_stgid  set hs_nr_str=(select K.name
from kenn_hochschulen K
where K.hs_nr=tmp_stgid.hs_nr);


--Hochschulen mit Standort:
--FHHN
update tmp_stgid  set stort=6752
where hs_nr =6751
and Name like '%Knzelsau%'
;
update tmp_stgid  set stort=6753
where hs_nr =6751
and Name like '%Schwbisch-Hall%'
;
--Default ist Heilbronn:
update tmp_stgid  set stort=6751
where hs_nr =6751
and stort is null
;
--Furtwangen:

update tmp_stgid  set stort=6742
where hs_nr =6741
and Name like '%Schwenning%'
;
update tmp_stgid  set stort=6743
where hs_nr =6741
and Name like '%Tuttling%'
;
--Default ist Furtwangen:
update tmp_stgid  set stort=6741
where hs_nr =6741
and stort is null
;

select 'Hochschulen ohne Zuordnung:';

select distinct hochschule from tmp_stgid
where hs_nr is null
order by 1;


--TODO: stupl Import
delete from tmp_stgid where id in (select K.id from kenn_stgid K);

insert into kenn_stgid(id,
       name,
--       beschreibung,
fach,
abschluss,
       hs_nr,
       stort,
       abgrp)
       select distinct id,
       trim(Verkettung_Name_Absschluss) ||  string_not_Null(' - ' || trim(hs_nr_str)),
--       beschreibung,
Name,
Abschluss,
       hs_nr,
       stort,
       abgrp
       from tmp_stgid
       where hs_nr is not null
;
drop table tmp_hs;
drop table tmp_stgid;


