--freemarker template
<sqlvars>
<sqlvar name="laeuft_im_HUES_var">
select 1 from xdummy where 1 != (select count(*) from hochschulinfo)
union
select 0 from xdummy where 1 = (select count(*) from hochschulinfo);
</sqlvar>
<sqlvar name="hsnr_kenn_tabellen" type="hashsequence">select table_name,name from sx_fields
where name='hs_nr' 
and table_name like 'kenn_%'
and table_name not in ('kenn_hochschulen', 'kenn_hs_sichten','kenn_bew_sem_cube','kenn_stud_sem_cube','kenn_stelle_bvl_bez','kenn_stbb_kap_titel_bericht')
and upper(field_type)='INTEGER'
;</sqlvar>
<sqlvar name="hsnr">select distinct hs_nr from hochschulinfo;</sqlvar>
</sqlvars>

<#assign laeuft_im_HUES=0 /> 
<#if laeuft_im_HUES_var =1>
<#assign laeuft_im_HUES=1 />
</#if>

select 'Luft im HIS: ${laeuft_im_HUES}' from xdummy; 


<#if  laeuft_im_HUES==0 && hsnr_kenn_tabellen?has_content >
<#foreach tabelle in hsnr_kenn_tabellen>
update ${tabelle.table_name} set ${tabelle.name}=${hsnr}
where ${tabelle.name}!=${hsnr};
</#foreach> 
</#if>

--Hochschul-Verschiebungen:
<#assign hsen = [
  {"alt":"1980","neu":"36"},
  {"alt":"6871","neu":"6870"}
  ] />


<#foreach hs in hsen>
<#foreach tabelle in hsnr_kenn_tabellen>
update ${tabelle.table_name} set ${tabelle.name}=${hs.neu}
where ${tabelle.name}=${hs.alt};
</#foreach> 
</#foreach> 

