--drop table tmp_konstanten;
--freemarker template
<sqlvars>
<sqlvar name="menu_element_exists">
select sp_table_exists('menu_element') from xdummy;
</sqlvar>
</sqlvars>
create temp TABLE tmp_schluessel (
    id SERIAL,
    variable character(50),
    wert character(255),
    beschreibung character(255),
    typ character(255),
    erlaeuterung character(255)
);
insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_stg_astat_stb_fg','apnr,druck,parent,struktur_c FROM kenn_cifx where key=663 and (lower(druck) like lower(''% ','Amtliche Studiengnge, Studienbereiche und Fchergruppen','kenn schluessel');

insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_abschl_astat','apnr,druck,parent,struktur_c FROM kenn_cifx where key=662 and (lower(druck) like lower(''% ','Amtliche Abschlsse und Abschlussgruppen','kenn schluessel');

-- insert into tmp_schluessel
 -- (variable,
       -- wert,
       -- beschreibung,
       -- typ)
-- values ('kenn_geldgeber_bund','646','Geldgeber nach Stellenstatistik Bundesstatistik StBA 5.2','kenn schluessel');
insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_geldgeber_klr_bw','apnr,druck,parent,struktur_c FROM kenn_cifx where key=648 and (lower(druck) like lower(''% ','Mittelherkunft KLR BaWue','kenn schluessel');

-- insert into tmp_schluessel
 -- (variable,
       -- wert,
       -- beschreibung,
       -- typ)
-- values ('sva_geldgeber_fikey','647','Geldgeber nach Hochschulfinanzstatistik','kenn schluessel');

insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_k_buadbz','buadbz, adbz, gruppe, gruppe_adbz FROM kenn_k_buadbz where (lower(adbz) like lower(''% ','Amtsdienstbez. Bund','kenn schluessel');

insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_sb','sb_nr, sb_text, lfb_nr, lfb_text FROM kenn_sb_astfr_lfb where (lower(sb_text) like lower(''% ','Studienbereiche und zug. LFB','kenn schluessel');
insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_lfb','lfb_nr, lfb_text, sb_nr, sb_text  FROM kenn_sb_astfr_lfb where (lower(lfb_text) like lower(''% ','Lehr- und Forschungsbereiche und zug. SB','kenn schluessel');

insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_lfb_fg','apnr,drucktext,parent,struktur_c  FROM kenn_lfb_fg where (lower(drucktext) like lower(''% ','Fachgebiete und zug. LFB','kenn schluessel');

insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_extkotr','key,name,parent,kategorie FROM kenn_extkotr where (lower(name) like lower(''% ','Externe Kostentrger','kenn schluessel');

insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_bvkr','apnr,druck,parent,struktur_c FROM kenn_cifx where key=668 and (lower(druck) like lower(''% ','Verwaltungs-Kontenrahmen BaWue (KLR)','kenn schluessel');

---in Zukunft auch Haushalt:
--insert into tmp_schluessel
-- (variable,
--       wert,
 --      beschreibung,
 --      typ)
--values ('kenn_bvkr_mbs','apnr,druck,parent,struktur_c FROM kenn_cifx where key=669 and (lower(druck) like lower(''% ','Verwaltungs-Kontenrahmen BaWue (Haushalt)','kenn schluessel');

insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_akl','apnr,druck,parent,struktur_c FROM kenn_cifx where key=671 and (lower(druck) like lower(''% ','Anlageklassen','kenn schluessel');

insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_stuart','apnr,druck,'''','''' FROM kenn_stuart where (lower(druck) like lower(''% ','Studienart (amtlich)','kenn schluessel');
insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_stufrm','apnr,druck,'''','''' FROM kenn_stufrm where (lower(druck) like lower(''% ','Studienform (amtlich)','kenn schluessel');
insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_stort','apnr,druck,hs_nr,'''' FROM kenn_stort where (lower(druck) like lower(''% ','Standort (amtlich)','kenn schluessel');
insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_hzbart_astat','apnr,druck,gruppe,'''' FROM kenn_hzbart_astat where (lower(druck) like lower(''% ','Art der Hochschulzugangsber. (amtlich)','kenn schluessel');
insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_hochschulen','hs_nr,name,art,'''' FROM kenn_hochschulen where (lower(name) like lower(''% ','Hochschule (amtlich)','kenn schluessel');

insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_semester','tid,druck,'''','''' FROM kenn_semester where (lower(druck) like lower(''% ','Semester','kenn schluessel');
insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_geschl','apnr,druck,'''','''' FROM kenn_geschl where (lower(druck) like lower(''% ','Geschlecht','kenn schluessel');
insert into tmp_schluessel
 (variable,
       wert,
       beschreibung,
       typ)
values ('kenn_staat','astat,druck,'''','''' FROM kenn_staat where (lower(druck) like lower(''% ','Nationalitt','kenn schluessel');



create temp table tmp_hilf (tid integer);

--nun einfgen:
<#if menu_element_exists=0>
delete from schluessel where variable='kenn_bvkr';

delete from schluessel where variable in (select variable from tmp_schluessel);


insert into tmp_hilf select max(id) from schluessel;
update tmp_hilf set tid=0 where tid is null;

insert into schluessel(id,variable,
       wert,
       beschreibung,
       typ ) 
select H.tid+K.id , variable,
       wert,
       beschreibung,
       typ  from tmp_schluessel K, tmp_hilf H;


<#else>
--Ab Kernmodul 4.0rc2 heisst die Tabelle menu_element:
delete from menu_element where element='kenn_bvkr';

delete from menu_element where element in (select variable from tmp_schluessel);


insert into tmp_hilf select max(id) from menu_element;
update tmp_hilf set tid=0 where tid is null;

insert into menu_element(id,element,
       element_value,
       description,
       nature ) 
select H.tid+K.id , variable,
       wert,
       beschreibung,
       typ  from tmp_schluessel K, tmp_hilf H;

</#if>
drop table tmp_hilf;
drop table tmp_schluessel;

