--Freemarker Template
--Achtung: Macro fgt Inhalte ein
--Bitte nur Freemarker Variablen fllen
<sqlvars>
<sqlvar name="sx_versions_exists">select sp_table_exists('kenn_rpt_version') from xdummy;</sqlvar>
<sqlvar name="kenn_versionierung_testdaten_anlegen_count">SELECT count(*) AS testdaten_anlegen FROM konstanten WHERE beschreibung = 'KENN_VERSIONIERUNG_TESTDATEN_ANLEGEN';</sqlvar>
</sqlvars>

<#assign testdaten_anlegen=(kenn_versionierung_testdaten_anlegen_count>0) />

<#assign versions = [
{"report_id":"ERFOLG_SAH", "defaulttext":"Zielorientierter Hochschulerfolgsbericht ", "uniquename":"zHEB_H_v20241231", 
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2024"},
{"report_id":"ERFOLG_SAH", "defaulttext":"Zielorientierter Hochschulerfolgsbericht ", "uniquename":"zHEB_H", 
"version_comment":"Zweite Version gem. VwV Rahmenhandbuch NHS i.d.F.d. Bekanntmachung v. 11.12.2024", "ordinal_number":"2", "release_version":"2025.06", "valid_from":"01.01.2025", "valid_to":"01.01.3000"},

{"report_id":"ERFOLG_SAL", "defaulttext":"Zielorientierter Hochschulerfolgsbericht ", "uniquename":"zHEB_L", 
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"01.01.3000"},

{"report_id":"STLI", "defaulttext":"Stellenbewirtschaftungsbericht 1207 ", "uniquename":"STBB_1207_v20241231", 
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2024"},
{"report_id":"STLI", "defaulttext":"Stellenbewirtschaftungsbericht 1207 ", "uniquename":"STBB_1207", 
"version_comment":"B5 Kanzler, Duale HS Sachsen", "ordinal_number":"2", "release_version":"2025.12", "valid_from":"01.01.2025", "valid_to":"01.01.3000"},

{"report_id":"STLI", "defaulttext":"Stellenbewirtschaftungsberichte Hochschulkapitel ", "uniquename":"STBB_HSKAP_v20241231", 
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2024"},
{"report_id":"STLI", "defaulttext":"Stellenbewirtschaftungsberichte Hochschulkapitel ", "uniquename":"STBB_HSKAP", 
"version_comment":"B5 Kanzler, Duale HS Sachsen", "ordinal_number":"2", "release_version":"2025.12", "valid_from":"01.01.2025", "valid_to":"01.01.3000"},

{"report_id":"GuVQ", "defaulttext":"Kaufmnnischer Quartalsbericht ", "uniquename":"KaufmQB_v20241231", 
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2024"},
{"report_id":"GuVQ", "defaulttext":"Kaufmnnischer Quartalsbericht ", "uniquename":"KaufmQB", 
"version_comment":"Zweite Version gem. VwV Rahmenhandbuch NHS i.d.F.d. Bekanntmachung v. 11.12.2024", "ordinal_number":"2", "release_version":"2025.06", "valid_from":"01.01.2025", "valid_to":"01.01.3000"},

{"report_id":"GuV", "defaulttext":"Kaufmnnischer Jahresbericht GuV ", "uniquename":"KaufmJB_G_v20241231", 
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2024"},
{"report_id":"GuV", "defaulttext":"Kaufmnnischer Jahresbericht GuV ", "uniquename":"KaufmJB_G", 
"version_comment":"Zweite Version gem. VwV Rahmenhandbuch NHS i.d.F.d. Bekanntmachung v. 11.12.2024", "ordinal_number":"2", "release_version":"2025.06", "valid_from":"01.01.2025", "valid_to":"01.01.3000"},

{"report_id":"Bilanz", "defaulttext":"Kaufmnnischer Jahresbericht Bilanz ", "uniquename":"KaufmJB_B_v20241231", 
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2024"},
{"report_id":"Bilanz", "defaulttext":"Kaufmnnischer Jahresbericht Bilanz ", "uniquename":"KaufmJB_B", 
"version_comment":"Zweite Version gem. VwV Rahmenhandbuch NHS i.d.F.d. Bekanntmachung v. 11.12.2024", "ordinal_number":"2", "release_version":"2025.06", "valid_from":"01.01.2025", "valid_to":"01.01.3000"},

{"report_id":"KAM_Q", "defaulttext":"Kameraler Quartalsbericht ", "uniquename":"KamQB", 
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"01.01.3000"},
{"report_id":"KAM_JAZ", "defaulttext":"Kameraler Jahresbericht nach Hauptgruppen ", "uniquename":"KamJA_Z", 
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"01.01.3000"},
{"report_id":"KAM_J", "defaulttext":"Kameraler Jahresbericht ", "uniquename":"KamJA", 
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"01.01.3000"}
] />


<#if testdaten_anlegen>
<#assign versions = [
{"report_id":"ERFOLG_SAH", "defaulttext":"Zielorientierter Hochschulerfolgsbericht ", "uniquename":"zHEB_H",
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2021"},
{"report_id":"ERFOLG_SAL", "defaulttext":"Zielorientierter Hochschulerfolgsbericht ", "uniquename":"zHEB_L",
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2021"},

{"report_id":"STLI", "defaulttext":"Stellenbewirtschaftungsbericht 1207 ", "uniquename":"STBB_1207",
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2021"},
{"report_id":"STLI", "defaulttext":"Stellenbewirtschaftungsberichte Hochschulkapitel ", "uniquename":"STBB_HSKAP",
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2021"},

{"report_id":"GuVQ", "defaulttext":"Kaufmnnischer Quartalsbericht ", "uniquename":"KaufmQB",
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2021"},
{"report_id":"GuV", "defaulttext":"Kaufmnnischer Jahresbericht GuV ", "uniquename":"KaufmJB_G",
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2021"},
{"report_id":"Bilanz", "defaulttext":"Kaufmnnischer Jahresbericht Bilanz ", "uniquename":"KaufmJB_B",
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2021"},
{"report_id":"KAM_Q", "defaulttext":"Kameraler Quartalsbericht ", "uniquename":"KamQB",
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2021"},
{"report_id":"KAM_JAZ", "defaulttext":"Kameraler Jahresbericht nach Hauptgruppen ", "uniquename":"KamJA_Z",
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2021"},
{"report_id":"KAM_J", "defaulttext":"Kameraler Jahresbericht ", "uniquename":"KamJA",
"version_comment":"Erste Version", "ordinal_number":"1", "release_version":"2024.06", "valid_from":"01.01.1900", "valid_to":"31.12.2021"},

{"report_id":"ERFOLG_SAH", "defaulttext":"Zielorientierter Hochschulerfolgsbericht ", "uniquename":"zHEB_H_testversion",
"version_comment":"Erste Version", "ordinal_number":"2", "release_version":"2024.06", "valid_from":"01.01.2022", "valid_to":"01.01.3000"},
{"report_id":"ERFOLG_SAL", "defaulttext":"Zielorientierter Hochschulerfolgsbericht ", "uniquename":"zHEB_L_testversion",
"version_comment":"Erste Version", "ordinal_number":"2", "release_version":"2024.06", "valid_from":"01.01.2022", "valid_to":"01.01.3000"},

{"report_id":"STLI", "defaulttext":"Stellenbewirtschaftungsbericht 1207 ", "uniquename":"STBB_1207_testversion",
"version_comment":"Erste Version", "ordinal_number":"2", "release_version":"2024.06", "valid_from":"01.01.2022", "valid_to":"01.01.3000"},
{"report_id":"STLI", "defaulttext":"Stellenbewirtschaftungsberichte Hochschulkapitel ", "uniquename":"STBB_HSKAP_testversion",
"version_comment":"Erste Version", "ordinal_number":"2", "release_version":"2024.06", "valid_from":"01.01.2022", "valid_to":"01.01.3000"},

{"report_id":"GuVQ", "defaulttext":"Kaufmnnischer Quartalsbericht ", "uniquename":"KaufmQB_testversion",
"version_comment":"Erste Version", "ordinal_number":"2", "release_version":"2024.06", "valid_from":"01.01.2022", "valid_to":"01.01.3000"},
{"report_id":"GuV", "defaulttext":"Kaufmnnischer Jahresbericht GuV ", "uniquename":"KaufmJB_G_testversion",
"version_comment":"Erste Version", "ordinal_number":"2", "release_version":"2024.06", "valid_from":"01.01.2022", "valid_to":"01.01.3000"},
{"report_id":"Bilanz", "defaulttext":"Kaufmnnischer Jahresbericht Bilanz ", "uniquename":"KaufmJB_B_testversion",
"version_comment":"Erste Version", "ordinal_number":"2", "release_version":"2024.06", "valid_from":"01.01.2022", "valid_to":"01.01.3000"},
{"report_id":"KAM_Q", "defaulttext":"Kameraler Quartalsbericht ", "uniquename":"KamQB_testversion",
"version_comment":"Erste Version", "ordinal_number":"2", "release_version":"2024.06", "valid_from":"01.01.2022", "valid_to":"01.01.3000"},
{"report_id":"KAM_JAZ", "defaulttext":"Kameraler Jahresbericht nach Hauptgruppen ", "uniquename":"KamJA_Z_testversion",
"version_comment":"Erste Version", "ordinal_number":"2", "release_version":"2024.06", "valid_from":"01.01.2022", "valid_to":"01.01.3000"},
{"report_id":"KAM_J", "defaulttext":"Kameraler Jahresbericht ", "uniquename":"KamJA_testversion",
"version_comment":"Erste Version", "ordinal_number":"2", "release_version":"2024.06", "valid_from":"01.01.2022", "valid_to":"01.01.3000"}
] />
</#if>

<#assign stylesheets = [
{"filename":"18100_zheb_sachsen_gesamt_pdf_v20241231.jrxml", "contenttype":"application/pdf", "version_uniquename":"zHEB_H_v20241231"},
{"filename":"18100_zheb_sachsen_gesamt_v20241231.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"zHEB_H_v20241231"},
{"filename":"18100_zheb_sachsen_gesamt_pdf.jrxml", "contenttype":"application/pdf", "version_uniquename":"zHEB_H"},
{"filename":"18100_zheb_sachsen_gesamt.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"zHEB_H"},

{"filename":"18100_zheb_sachsen_lfb_pdf.jrxml", "contenttype":"application/pdf", "version_uniquename":"zHEB_L"},
{"filename":"18100_zheb_sachsen_lfb.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"zHEB_L"},

{"filename":"32380_sbb_1207_excel_v20241231.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"STBB_1207_v20241231"},
{"filename":"32380_sbb_1207_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"STBB_1207"},
{"filename":"32380_sbb_1207_v20241231_xmlsource.jrxml", "contenttype":"application/pdf", "version_uniquename":"STBB_1207_v20241231"},
{"filename":"32380_sbb_1207_xmlsource.jrxml", "contenttype":"application/pdf", "version_uniquename":"STBB_1207"},
{"filename":"32380_sbb_1207_v20241231_xmlsource.jrxml", "contenttype":"text/html", "version_uniquename":"STBB_1207_v20241231"},
{"filename":"32380_sbb_1207_xmlsource.jrxml", "contenttype":"text/html", "version_uniquename":"STBB_1207"},

{"filename":"18540_sbb_excel_v20241231.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"STBB_HSKAP_v20241231"},
{"filename":"18540_sbb_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"STBB_HSKAP"},
{"filename":"18540_sbb_v20241231_xmlsource.jrxml", "contenttype":"application/pdf", "version_uniquename":"STBB_HSKAP_v20241231"},
{"filename":"18540_sbb_xmlsource.jrxml", "contenttype":"application/pdf", "version_uniquename":"STBB_HSKAP"},
{"filename":"18540_sbb_v20241231_xmlsource.jrxml", "contenttype":"text/html", "version_uniquename":"STBB_HSKAP_v20241231"},
{"filename":"18540_sbb_xmlsource.jrxml", "contenttype":"text/html", "version_uniquename":"STBB_HSKAP"},

{"filename":"18560_kaufm_quartalsbericht_v20241231.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmQB_v20241231"},
{"filename":"18560_kaufm_quartalsbericht_html_v20241231.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmQB_v20241231"},
{"filename":"18560_kaufm_quartalsbericht_excel_v20241231.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmQB_v20241231"},
{"filename":"18560_kaufm_quartalsbericht.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmQB"},
{"filename":"18560_kaufm_quartalsbericht_html.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmQB"},
{"filename":"18560_kaufm_quartalsbericht_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmQB"},

{"filename":"18380_guv2_excel_v20241231.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmJB_G_v20241231"},
{"filename":"18380_guv2_excel_v20241231.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmJB_G_v20241231"},
{"filename":"18380_guv2_v20241231.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmJB_G_v20241231"},
{"filename":"18380_guv2_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmJB_G"},
{"filename":"18380_guv2_excel.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmJB_G"},
{"filename":"18380_guv2.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmJB_G"},

{"filename":"18380_bilanz2_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmJB_B_v20241231"},
{"filename":"18380_bilanz2_excel.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmJB_B_v20241231"},
{"filename":"18380_bilanz2.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmJB_B_v20241231"},
{"filename":"18380_bilanz2_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmJB_B"},
{"filename":"18380_bilanz2_excel.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmJB_B"},
{"filename":"18380_bilanz2.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmJB_B"},

{"filename":"18980_quartalsbericht_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KamQB"},
{"filename":"18980_quartalsbericht.jrxml", "contenttype":"application/pdf", "version_uniquename":"KamQB"},
{"filename":"18980_quartalsbericht.jrxml", "contenttype":"text/html", "version_uniquename":"KamQB"},
{"filename":"32120_kam_hauptgr_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KamJA_Z"},
{"filename":"32120_kam_hauptgr.jrxml", "contenttype":"application/pdf", "version_uniquename":"KamJA_Z"},
{"filename":"32120_kam_hauptgr_html.jrxml", "contenttype":"text/html", "version_uniquename":"KamJA_Z"},
{"filename":"18520_kam_jahresbericht_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KamJA"},
{"filename":"18520_kam_jahresbericht_excel.jrxml", "contenttype":"text/html", "version_uniquename":"KamJA"},
{"filename":"18520_kam_jahresbericht.jrxml", "contenttype":"application/pdf", "version_uniquename":"KamJA"}
] />

<#if testdaten_anlegen>
<#assign stylesheets = [
{"filename":"18100_zheb_sachsen_gesamt_pdf.jrxml", "contenttype":"application/pdf", "version_uniquename":"zHEB_H"},
{"filename":"18100_zheb_sachsen_gesamt.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"zHEB_H"},
{"filename":"18100_zheb_sachsen_lfb_pdf.jrxml", "contenttype":"application/pdf", "version_uniquename":"zHEB_L"},
{"filename":"18100_zheb_sachsen_lfb.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"zHEB_L"},

{"filename":"32380_sbb_1207_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"STBB_1207"},
{"filename":"32380_sbb_1207_xmlsource.jrxml", "contenttype":"application/pdf", "version_uniquename":"STBB_1207"},
{"filename":"32380_sbb_1207_xmlsource.jrxml", "contenttype":"text/html", "version_uniquename":"STBB_1207"},
{"filename":"18540_sbb_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"STBB_HSKAP"},
{"filename":"18540_sbb_xmlsource.jrxml", "contenttype":"application/pdf", "version_uniquename":"STBB_HSKAP"},
{"filename":"18540_sbb_xmlsource.jrxml", "contenttype":"text/html", "version_uniquename":"STBB_HSKAP"},

{"filename":"18560_kaufm_quartalsbericht.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmQB"},
{"filename":"18560_kaufm_quartalsbericht.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmQB"},
{"filename":"18560_kaufm_quartalsbericht_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmQB"},
{"filename":"18380_guv2_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmJB_G"},
{"filename":"18380_guv2_excel.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmJB_G"},
{"filename":"18380_guv2.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmJB_G"},
{"filename":"18380_bilanz2_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmJB_B"},
{"filename":"18380_bilanz2_excel.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmJB_B"},
{"filename":"18380_bilanz2.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmJB_B"},
{"filename":"18980_quartalsbericht_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KamQB"},
{"filename":"18980_quartalsbericht.jrxml", "contenttype":"application/pdf", "version_uniquename":"KamQB"},
{"filename":"18980_quartalsbericht.jrxml", "contenttype":"text/html", "version_uniquename":"KamQB"},
{"filename":"32120_kam_hauptgr_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KamJA_Z"},
{"filename":"32120_kam_hauptgr.jrxml", "contenttype":"application/pdf", "version_uniquename":"KamJA_Z"},
{"filename":"32120_kam_hauptgr_html.jrxml", "contenttype":"text/html", "version_uniquename":"KamJA_Z"},
{"filename":"18520_kam_jahresbericht_excel.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KamJA"},
{"filename":"18520_kam_jahresbericht_excel.jrxml", "contenttype":"text/html", "version_uniquename":"KamJA"},
{"filename":"18520_kam_jahresbericht.jrxml", "contenttype":"application/pdf", "version_uniquename":"KamJA"},


{"filename":"18100_zheb_sachsen_gesamt_pdf_testversion.jrxml", "contenttype":"application/pdf", "version_uniquename":"zHEB_H_testversion"},
{"filename":"18100_zheb_sachsen_gesamt_testversion.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"zHEB_H_testversion"},
{"filename":"18100_zheb_sachsen_lfb_pdf_testversion.jrxml", "contenttype":"application/pdf", "version_uniquename":"zHEB_L_testversion"},
{"filename":"18100_zheb_sachsen_lfb_testversion.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"zHEB_L_testversion"},

{"filename":"32380_sbb_1207_excel_testversion.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"STBB_1207_testversion"},
{"filename":"32380_sbb_1207_xmlsource_testversion.jrxml", "contenttype":"application/pdf", "version_uniquename":"STBB_1207_testversion"},
{"filename":"32380_sbb_1207_xmlsource_testversion.jrxml", "contenttype":"text/html", "version_uniquename":"STBB_1207_testversion"},
{"filename":"18540_sbb_excel_testversion.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"STBB_HSKAP_testversion"},
{"filename":"18540_sbb_xmlsource_testversion.jrxml", "contenttype":"application/pdf", "version_uniquename":"STBB_HSKAP_testversion"},
{"filename":"18540_sbb_xmlsource_testversion.jrxml", "contenttype":"text/html", "version_uniquename":"STBB_HSKAP_testversion"},

{"filename":"18560_kaufm_quartalsbericht_testversion.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmQB_testversion"},
{"filename":"18560_kaufm_quartalsbericht_testversion.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmQB_testversion"},
{"filename":"18560_kaufm_quartalsbericht_excel_testversion.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmQB_testversion"},
{"filename":"18380_guv2_excel_testversion.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmJB_G_testversion"},
{"filename":"18380_guv2_excel_testversion.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmJB_G_testversion"},
{"filename":"18380_guv2_testversion.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmJB_G_testversion"},
{"filename":"18380_bilanz2_excel_testversion.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KaufmJB_B_testversion"},
{"filename":"18380_bilanz2_excel_testversion.jrxml", "contenttype":"text/html", "version_uniquename":"KaufmJB_B_testversion"},
{"filename":"18380_bilanz2_testversion.jrxml", "contenttype":"application/pdf", "version_uniquename":"KaufmJB_B_testversion"},
{"filename":"18980_quartalsbericht_excel_testversion.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KamQB_testversion"},
{"filename":"18980_quartalsbericht_testversion.jrxml", "contenttype":"application/pdf", "version_uniquename":"KamQB_testversion"},
{"filename":"18980_quartalsbericht_testversion.jrxml", "contenttype":"text/html", "version_uniquename":"KamQB_testversion"},
{"filename":"32120_kam_hauptgr_excel_testversion.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KamJA_Z_testversion"},
{"filename":"32120_kam_hauptgr_testversion.jrxml", "contenttype":"application/pdf", "version_uniquename":"KamJA_Z_testversion"},
{"filename":"32120_kam_hauptgr_html_testversion.jrxml", "contenttype":"text/html", "version_uniquename":"KamJA_Z_testversion"},
{"filename":"18520_kam_jahresbericht_excel_testversion.jrxml", "contenttype":"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "version_uniquename":"KamJA_testversion"},
{"filename":"18520_kam_jahresbericht_excel_testversion.jrxml", "contenttype":"text/html", "version_uniquename":"KamJA_testversion"},
{"filename":"18520_kam_jahresbericht_testversion.jrxml", "contenttype":"application/pdf", "version_uniquename":"KamJA_testversion"}
] />
</#if>


--- Freemarker Magic
<#if sx_versions_exists=1>
	
	<#foreach version in versions>
		<#if SQLdialect='Postgres'>
			select sp_update_sequence('kenn_rpt_version');
		</#if>
		
		delete from kenn_rpt_version where uniquename='${version.uniquename}';
		
		INSERT INTO kenn_rpt_version(report_id,defaulttext,uniquename,version_comment,ordinal_number,release_version,valid_from,valid_to)
		VALUES('${version.report_id}','${version.defaulttext}','${version.uniquename}','${version.version_comment}',
			${version.ordinal_number},'${version.release_version}','${version.valid_from}','${version.valid_to}');

	</#foreach>
	
	-- Lschen in eigene foreach, sonst wird Stylesheet, welches in mehreren Berichten verwandt wird flschlicherweise jedes mal gelscht, bspw. gener Standardlayout
	<#foreach sheet in stylesheets>
		delete from kenn_stylesheet_version where stylesheet_id in (select tid from sx_stylesheets where filename = '${sheet.filename}' and contenttype = '${sheet.contenttype}');
	</#foreach>
	
	<#foreach sheet in stylesheets>
		<#if SQLdialect='Postgres'>
			select sp_update_sequence('kenn_stylesheet_version');
		</#if>
		
		insert into kenn_stylesheet_version (stylesheet_id,rpt_version_id)
		values (
			(select min(tid) from sx_stylesheets where filename = '${sheet.filename}' and contenttype = '${sheet.contenttype}'),
			(select min(tid) from kenn_rpt_version where uniquename = '${sheet.version_uniquename}')
		);
		
		<#if SQLdialect='Postgres'>
			select sp_update_sequence('kenn_stylesheet_version');
		</#if>
	</#foreach>
	  
 </#if>
