--Freemarker Template 

<sqlvars>
<sqlvar name="isInKENNX">
select 1 from xdummy where 1 &lt; 
(select count(*) from hochschulinfo)
union
select 0 from xdummy where 1 =
(select count(*) from hochschulinfo);
</sqlvar>

</sqlvars>

--HS BaWue:
<#if isInKENNX?has_content && isInKENNX=1>
update konstanten set apnr=4
where beschreibung='KENN_PROFIL'
and apnr=0
and 1 < (select count(*) from kenn_hochschulen K, hochschulinfo H
where H.hs_nr=K.hs_nr
and K.bland='BW')
;
--Sachsen H-IS
update konstanten set apnr=6
where beschreibung='KENN_PROFIL'
and apnr=0
and 1 < (select count(*) from kenn_hochschulen K, hochschulinfo H
where H.hs_nr=K.hs_nr
and K.bland='SN')
;

<#else>
--Betrieb an Hochschule:
--PHen BaWue
update konstanten set apnr=2
where beschreibung='KENN_PROFIL'
and  0 < (select count(*) from kenn_hochschulen K, hochschulinfo H
where K.art='PH'
and H.hs_nr=K.hs_nr
and K.bland='BW')
;
--FH BaWue
update konstanten set apnr=1
where beschreibung='KENN_PROFIL'
and 0 < (select count(*) from kenn_hochschulen K, hochschulinfo H
where K.art ='FH'
and H.hs_nr=K.hs_nr
and K.bland='BW')
;
--Sonst. BaWue
update konstanten set apnr=3
where beschreibung='KENN_PROFIL'
and 0 < (select count(*) from kenn_hochschulen K, hochschulinfo H
where K.art not in ('PH','FH')
and H.hs_nr=K.hs_nr
and K.bland= 'BW' )
;
--Einzelhochschule Sachsen
update konstanten set apnr=5
where beschreibung='KENN_PROFIL'
and  0 < (select count(*) from kenn_hochschulen K, hochschulinfo H
where H.hs_nr=K.hs_nr
and K.bland='SN')
;
</#if>

--Stichtartarten in Abhngigkeit vom Bundesland:
update kenn_stichtagsart set aktiv=null;

--Bestnde fr BaWue SAchsen ausblenden:
update kenn_stichtagsart set aktiv='0' where (select apnr from konstanten where beschreibung='KENN_PROFIL') in (1,2,3,4)
and (0=(select count(*) from kenn_bestandsart_bland B, kenn_bestandsart K
where B.bestandsart=K.apnr
and K.stichtagsart_id=kenn_stichtagsart.apnr
and B.bland ='BW')
or
0=(select count(*) from kenn_bestandsart_bland B, kenn_bestandsart K
where B.bestandsart=K.apnr
and K.stichtagsart_id=kenn_stichtagsart.apnr)
)
;
update kenn_stichtagsart set aktiv='1' where (select apnr from konstanten where beschreibung='KENN_PROFIL') in (1,2,3,4)
and 0<(select count(*) from kenn_bestandsart_bland B, kenn_bestandsart K
where B.bestandsart=K.apnr
and K.stichtagsart_id=kenn_stichtagsart.apnr
and B.bland ='BW')
;
--Sachsen:
update kenn_stichtagsart set aktiv='0' where (select apnr from konstanten where beschreibung='KENN_PROFIL') in (5,6)
and apnr not in ('KWIPL','LEERST')  --manuelle Uploads sollen eine aktive Stichtagsart haben, haben aber keinen Eintrag in Bestand
and (0=(select count(*) from kenn_bestandsart_bland B, kenn_bestandsart K
where B.bestandsart=K.apnr
and K.stichtagsart_id=kenn_stichtagsart.apnr
and B.bland ='SA')
or
0=(select count(*) from kenn_bestandsart_bland B, kenn_bestandsart K
where B.bestandsart=K.apnr
and K.stichtagsart_id=kenn_stichtagsart.apnr
and B.bland ='SA')
)
;
update kenn_stichtagsart set aktiv='1' where (select apnr from konstanten where beschreibung='KENN_PROFIL') in (5,6)
and 0<(select count(*) from kenn_bestandsart_bland B, kenn_bestandsart K
where B.bestandsart=K.apnr
and K.stichtagsart_id=kenn_stichtagsart.apnr
and B.bland ='SA')
;

update kenn_stichtagsart set aktiv='1'
where aktiv is null or aktiv !='0';

--Stichtage, die im jew. Landesprojekt nicht bentigt werden, entfernen:
--Sachsen:
delete from kenn_stichtag where stichtagsart_id is null
or (
(select apnr from konstanten where beschreibung='KENN_PROFIL') in (5,6)
and 0=(select count(*) from kenn_bestandsart_bland B, kenn_bestandsart K
where B.bestandsart=K.apnr
and K.stichtagsart_id=kenn_stichtag.stichtagsart_id
and B.bland ='SA')
);
--Bawue:
delete from kenn_stichtag where stichtagsart_id is null
or (
(select apnr from konstanten where beschreibung='KENN_PROFIL') in (1,2,3,4)
and 0=(select count(*) from kenn_bestandsart_bland B, kenn_bestandsart K
where B.bestandsart=K.apnr
and K.stichtagsart_id=kenn_stichtag.stichtagsart_id
and B.bland ='BW')
);

<#if isInKENNX==0>
--cif Schlssel 659 enthlt das Bundesland der Installation. Defaultmig 
--steht es auf 0 (=unbekannt). Dies wird u.a. im SOS Modul gefllt.
--Hochschulen ohne SOS-Modul werden hier geupdated:

create temp table tmp_kenn_bland ( apnr varchar(255), druck varchar(255), astat integer);

INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'BA', 'Bayern', 9 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'BB', 'Brandenburg', 12 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'BE', 'Berlin', 11 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'BR', 'Bremen', 4 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'BW', 'Baden-Wrttemberg', 8 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'HA', 'Hamburg', 2 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'HE', 'Hessen', 6 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'MV', 'Mecklenburg-Vorpommern', 13 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'NI', 'Niedersachsen', 3 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'NW', 'Nordrhein-Westfalen', 5 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'RP', 'Rheinland-Pfalz', 7 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'SA', 'Saarland', 10 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'SH', 'Schleswig-Holstein', 1 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'SN', 'Sachsen', 14 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'ST', 'Sachsen-Anhalt', 15 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'TH', 'Thringen', 16 );

update cif set apnr=(select min(T.astat) from tmp_kenn_bland T, kenn_hochschulen K, hochschulinfo H
where apnr = K.bland 
and H.hs_nr=K.hs_nr)
where key=659
and apnr=0
and exists (select T.astat from tmp_kenn_bland T, kenn_hochschulen K, hochschulinfo H
where apnr = K.bland 
and H.hs_nr=K.hs_nr
and T.astat is not null);

drop table tmp_kenn_bland;
<#else>
--HS BaWue
update cif set apnr=8
where 1=(select count(*) from konstanten K
where K.beschreibung='KENN_PROFIL'
and K.apnr=4)
and key=659
and apnr=0;
--HS Sachsen
update cif set apnr=14
where 1=(select count(*) from konstanten K
where K.beschreibung='KENN_PROFIL'
and K.apnr=6)
and key=659
and apnr=0;
</#if>


