#!/bin/bash

if [ "$1" = "" ]
   then echo "Aufruf: kenn_katalog_upload.x <Report-ID>"
	echo " "
	echo "Aktion: kenn_katalog_upload.x ldt einen Bericht vom Dateisystem in die DB"
	echo " "
	exit 0
fi

REPORT_ID=$1
PFAD=$2

if [ "$PFAD" = ""  ]
	then
	PFAD=$KENN_PFAD/schluesseltabellen
fi



DOQUERY "create table tmp_kenn_katalog_sub( report_id CHAR(40)  not null,  katalog_id CHAR(100)  not null,  sub_caption VARCHAR(255) ,  sub_key_col VARCHAR(255) ,  sub_lookup_table VARCHAR(255) ,  sub_lookup_key VARCHAR(255) ,  sub_lookup_name VARCHAR(255) , sub_lookup_whereclause VARCHAR(255) ,sub_lookup_snowflake TEXT ,  ord_nr SMALLINT  )  ;"
DOQUERY "create table tmp_kenn_katalog_grp( report_id CHAR(40)  not null,  id CHAR(40)  not null,  uniquename VARCHAR(255) ,  name VARCHAR(255) ,  beschreibung TEXT ,  parent_id CHAR(40) ,  ord_nr SMALLINT )  ;"
DOQUERY "create table tmp_kenn_katalog(   id CHAR(100)  not null,  name CHAR(255) ,  beschreibung TEXT ,  quelltabelle CHAR(255) ,  quellfeld CHAR(255) ,  bedingung TEXT ,  stichtagsart CHAR(100) ,  bezugsart CHAR(1) ,  zeitfeld CHAR(40) ,  einheit VARCHAR(255) ,  bezugszeit_wert SMALLINT ,  bezugszeit_art CHAR(1) ,  bezugszeit_diff VARCHAR(255),gueltig_von date,gueltig_bis date   )  ;"
DOQUERY "create table tmp_kenn_katalog_rpt(   katalog_id CHAR(100)  not null,  report_id CHAR(40)  not null,  beschreibung TEXT ,  ord_nr SMALLINT ,  gruppe_1 CHAR(40) ,  gruppe_2 CHAR(40) ,  ebene SMALLINT ,  parent_katalog_id CHAR(100) ,  active smallint  default 1 ,  uniquename VARCHAR(255)   )  ;"


		

echo "Lade Tabelle tmp_kenn_katalog"
sx_auto_upload_table.x tmp_kenn_katalog $PFAD/kenn_katalog.unl

echo "Lade Tabelle tmp_kenn_katalog_rpt"
sx_auto_upload_table.x tmp_kenn_katalog_rpt $PFAD/kenn_katalog_rpt_"$REPORT_ID".unl

echo "Lade Tabelle tmp_kenn_katalog_grp"
sx_auto_upload_table.x tmp_kenn_katalog_grp $PFAD/kenn_katalog_grp_"$REPORT_ID".unl

echo "Lade Tabelle tmp_kenn_katalog_sub"
sx_auto_upload_table.x tmp_kenn_katalog_sub $PFAD/kenn_katalog_sub_"$REPORT_ID".unl


DOSQL $KENN_PFAD/schluesseltabellen/kenn_reports_fuellen.sql

