

--freemarker template
<#if SQLdialect='Postgres'>
<#assign texttype="text" />
<#else>
EXECUTE PROCEDURE IFX_ALLOW_NEWLINE('T');
<#assign texttype="lvarchar" />
</#if>
<#assign newline="'
'" />

<#assign systeminfo_id= 109/>
<#assign doku_link= "https://wiki.his.de/mediawiki/index.php/Komponente_Kenn_Admin_-_HS-spezifische_Anpassungen_allgemein_-_HISinOne-BI#Konstanten" />
<#assign sachgebiete_id=109 />
<#assign wertebereich_yesno="0,Nein' || " +newline+" || '1,Ja" />


<#assign  konstanten = [
  {
  "beschreibung":"KENN_PERSONAL_ARCHIV",
  "default_apnr":"1",
  "description":"Sollen beim Update des KENN-Moduls Personaldaten zu vergangenen Stichtagen erhalten bleiben (1) oder gelscht werden (0)",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.3",
  "gruppe":"Konnektorenperformance, Historisieren (Einfrieren) von Daten"},
    {
  "beschreibung":"KENN_STELLEN_ARCHIV",
  "default_apnr":"1",
  "description":"Sollen beim Update des KENN-Moduls Stellendaten zu vergangenen Stichtagen erhalten bleiben (1) oder gelscht werden (0)",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.3",
  "gruppe":"Konnektorenperformance, Historisieren (Einfrieren) von Daten"},
    {
  "beschreibung":"KENN_STUDIUM_ARCHIV",
  "default_apnr":"1",
  "description":"Sollen beim Update des KENN-Moduls Studierendendaten zu vergangenen Stichtagen erhalten bleiben (1) oder gelscht werden (0)",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.3",
  "gruppe":"Konnektorenperformance, Historisieren (Einfrieren) von Daten"},
    {
  "beschreibung":"KENN_PRFUNG_ARCHIV",
  "default_apnr":"1",
  "description":"Sollen beim Update des KENN-Moduls Absolventendaten zu vergangenen Stichtagen erhalten bleiben (1) oder gelscht werden (0)",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.3",
  "gruppe":"Konnektorenperformance, Historisieren (Einfrieren) von Daten"},
    {
  "beschreibung":"KENN_KOSTEN_ARCHIV",
  "default_apnr":"1",
  "description":"Sollen beim Update des KENN-Moduls KLR-Daten zu vergangenen Stichtagen erhalten bleiben (1) oder gelscht werden (0)",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.3",
  "gruppe":"Konnektorenperformance, Historisieren (Einfrieren) von Daten"},
    {
  "beschreibung":"KENN_FINANZEN_ARCHIV",
  "default_apnr":"1",
  "description":"Sollen beim Update des KENN-Moduls Finanzaten zu vergangenen Stichtagen erhalten bleiben (1) oder gelscht werden (0)",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.3",
  "gruppe":"Konnektorenperformance, Historisieren (Einfrieren) von Daten"},
    {
  "beschreibung":"KENN_HHM_LHR_MAN",
  "default_apnr":"1",
  "description":"Sollen die Haushaltsmittel der Landeshaushaltsrechnung aus der manuellen Schnittstelle (1) oder aus FIN (0) bernommen werden. Letzteres ist derzeit noch nicht implementiert. ",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.3",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
    {
  "beschreibung":"KENN_UPDATE_PURGE",
  "default_apnr":"0",
  "description":"Sollen die Daten- und Hilfstabellen der Vormodule sos, cob etc. nach dem KENN-Update aus Datenschutzgrnden gelscht werden (0=nein, 1=ja).",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.3",
  "gruppe":"Konnektorenperformance, Historisieren (Einfrieren) von Daten"},
    {
  "beschreibung":"KENN_BEW_MAN",
  "default_apnr":"0",
  "description":"Wenn 1, dann werden Bewerberdaten ber die manuelle Schnittstelle eingegeben. Wenn 0, dann wird versucht, aus den Bewerberdaten die entsprechenden Grunddaten zu importieren. ",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.6rc2",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
    {
  "beschreibung":"KENN_PROFIL",
  "default_apnr":"0",
  "description":"Umgebung der Installation bzgl. landesspezifischer Konfigurationen",
  "read_only":1,
  "wertebereich":"0-Unbekanntes Profil' || " +newline+" || ',1-Fachhochschulen BaWue' || " +newline+" || ',3-Sonstige Hochschulen BaWue' || " +newline+" || ',4-Hochschulbergreifendes SuperX BaWue' || " +newline+" || ',5-Hochschulen Sachsen' || " +newline+" || ',6-Hochschulb. Infosystem Sachsen",
  "ab_version":"0.1",
  "gruppe":"Spezielle Auswertungsfilter"},
    {
  "beschreibung":"KENN_FINANZEN_KLRPERIODE",
  "default_apnr":"0",
  "description":"Beim Laden von Haushaltsdaten kann man statt dem Buchungsdatum auch den Monat und das Jahr aus der KLR-Periode des Buchungssatzes laden",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.3",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
    {
  "beschreibung":"KENN_PROM_MAN",
  "default_apnr":"0",
  "description":"Wenn 1, dann werden Promotionen (semesterweise) ber die manuelle Schnittstelle eingegeben",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"1.0",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
    {
  "beschreibung":"KENN_ABG_PROM_LAB",
  "default_apnr":"1",
  "description":"Nur fr Hochschulen in BaWue:Abgeschlossene Promotionen (jahresweise) aus der amtl. Absolventenstat. bernehmen",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"1.6",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
    {
  "beschreibung":"KENN_LEHRANG_MAN",
  "default_apnr":"0",
  "description":"Nur fr Hochschulen in Sachsen: Soll das Lehrangebot im Hochschulerfolgsbericht ber die manuelle Schnittstelle (LEHRE_SWS) erhoben werden(1), oder aus KLR /Studienpltze (0). ",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.3",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
    {
  "beschreibung":"KENN_start_stg_cube",
  "default_apnr":"19001",
  "description":"Startsemester fr Berechnung des Studierenden-Datenwrfels",
  "read_only":0,
  "wertebereich":"<<SQL>> select tid,tid || '' ('' || trim(druck) ||'')'' from kenn_semester union select 19001,''19001 (Unbegrenzt)'' from xdummy order by 1 desc",
  "ab_version":"0.8",
  "gruppe":"Konnektorenperformance, Historisieren (Einfrieren) von Daten"},
    {
  "beschreibung":"KENN_start_sb_stg_cube",
  "default_apnr":"19001",
  "description":"Startsemester fr Berechnung des Studierenden-Datenwrfels (Semesterberichte BaWue)",
  "read_only":0,
  "wertebereich":"<<SQL>> select tid,tid || '' ('' || trim(druck) ||'')'' from kenn_semester union select 19001,''19001 (Unbegrenzt)'' from xdummy order by 1 desc",
  "ab_version":"0.8",
  "gruppe":"Konnektorenperformance, Historisieren (Einfrieren) von Daten"},
   {
  "beschreibung":"KENN_start_antr_cube",
  "default_apnr":"19001",
  "description":"Startsemester fr Berechnung des Bewerbungs-Datenwrfels (Semesterberichte BaWue)",
  "read_only":0,
  "wertebereich":"<<SQL>> select tid,tid || '' ('' || trim(druck) ||'')'' from kenn_semester union select 19001,''19001 (Unbegrenzt)'' from xdummy order by 1 desc",
  "ab_version":"0.8",
  "gruppe":"Konnektorenperformance, Historisieren (Einfrieren) von Daten"},
    {
  "beschreibung":"KENN_kfm_kam",
  "default_apnr":"0",
  "description":"Werden Haushaltsdaten fr den zHEB auf der Basis von kameralem Haushaltssystem (1) oder kaufmnnischem System (2) gebucht? Default ist Unbekannt (0). Wird derzeit nur in Sachsen ausgewertet.",
  "read_only":0,
  "wertebereich":"1,kameral ' ||"+ newline+" || '2,kaufmnnisch' || "+ newline+"  || '0,Unbekannt",
  "ab_version":"1.1",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
    {
  "beschreibung":"KENN_KOSTEN_DATENQUELLE",
  "default_apnr":"10",
  "description":"Sollen Primrkosten, Sekundrkosten und Studiengnge aus der Kostenrechnungs-Komponente geladen werden oder aus GXSTAGE",
  "read_only":0,
  "wertebereich":"10,KLR-Komponente ' || "+ newline+"  || '170,GXSTAGE-Komponente",
  "ab_version":"1.3",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
    {
  "beschreibung":"KENN_ANLAGEN_DATENQUELLE",
  "default_apnr":"10",
  "description":"Sollen Anlagedaten aus der Kostenrechnungs-Komponente geladen werden oder aus GXSTAGE",
  "read_only":0,
  "wertebereich":"10,KLR-Komponente ' || "+ newline+"  || '170,GXSTAGE-Komponente",
  "ab_version":"1.3",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
    {
  "beschreibung":"KENN_FINANZEN_DATENQUELLE",
  "default_apnr":"3",
  "description":"Sollen Haushaltsdaten aus der FIN-Komponente geladen werden oder aus GXSTAGE",
  "read_only":0,
  "wertebereich":"3,FIN-Komponente ' || "+ newline+"  || '170,GXSTAGE-Komponente",
  "ab_version":"1.3",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
    {
  "beschreibung":"KENN_FLAECHEN_DATENQUELLE",
  "default_apnr":"10",
  "description":"Sollen Flchendaten aus der Kostenrechnungs-Komponente geladen werden oder aus GXSTAGE",
  "read_only":0,
  "wertebereich":"10,KLR-Komponente ' || "+ newline+"  || '170,GXSTAGE-Komponente",
  "ab_version":"1.3",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
      {
  "beschreibung":"KENN_STUD_DATENQUELLE",
  "default_apnr":"10",
  "description":"Sollen Studierenden-VZ aus der Kostenrechnungs Komponente geladen werden oder aus GXSTAGE",
  "read_only":0,
  "wertebereich":"10,KLR-Komponente ' || "+ newline+"  || '170,GXSTAGE-Komponente",
  "ab_version":"1.3",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
   {
  "beschreibung":"KENN_GXSTAGE_STARTJAHR",
  "default_apnr":"0",
  "description":"Startjahr fr Ressourcendaten aus GXSTAGE",
  "read_only":0,
  "wertebereich":"",
  "ab_version":"1.3",
  "gruppe":"Konnektorenperformance, Historisieren (Einfrieren) von Daten"},
    {
  "beschreibung":"KENN_SWITCH_BA_MA",
  "default_apnr":"1",
  "description":"Studierende, die im 1. Studiengang noch im Bachelor eingeschrieben sind, und dann vor Beendigung des Bachelors schon im zweiten Studiengang als Master eingeschrieben sind, sollen bei der Landesberichterstattung automatisch umgesetzt werden.",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"1.3",
  "gruppe":"Spezielle Auswertungsfilter"},
    {
  "beschreibung":"KENN Inst. aus Organigr.",
  "default_apnr":"1",
  "description":"bernahme der Institutionen aus dem Organigramm (Kernmodul)",
  "read_only":0,
  "wertebereich":wertebereich_yesno,
  "ab_version":"0.6",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"} ,
  {
  "beschreibung":"KENN_SOS_ASTAT_SRC",
  "default_apnr":"1",
  "description":"Soll Studierende (amtlich) manuell aus dem Lieferfile geladen werden oder aus der ASTAT- Komponente",
  "read_only":0,
  "wertebereich":"1,manuell ' || "+ newline+"  || '2,ASTAT-Komponente",
  "ab_version":"1.8",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
  {
  "beschreibung":"KENN_LAB_ASTAT_SRC",
  "default_apnr":"1",
  "description":"Soll Absolvent_innen (amtlich) manuell aus dem Lieferfile geladen werden oder aus der ASTAT- Komponente",
  "read_only":0,
  "wertebereich":"1,manuell ' || "+ newline+"  || '2,ASTAT-Komponente",
  "ab_version":"1.8",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
  {
  "beschreibung":"VERTEILSCHRITT KENN LEHRE",
  "default_apnr":"1",
  "description":"Verteilschritt fr Kosten der Lehre",
  "read_only":1,
  "wertebereich":"",
  "ab_version":"1.0",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
  {
  "beschreibung":"VERTEILSCHRITT KENN FORSC",
  "default_apnr":"1",
  "description":"Verteilschritt fr Kosten der Forschung",
  "read_only":1,
  "wertebereich":"",
  "ab_version":"1.0",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"},
  {
  "beschreibung":"VERTEILSCHRITT KENN DIENS",
  "default_apnr":"1",
  "description":"Verteilschritt fr Kosten der sonst. Diensleistungen",
  "read_only":1,
  "wertebereich":"",
  "ab_version":"1.0",
  "gruppe":"Datenquelle, Entladestartzeitpunkt, -umfang"}
  ] />


  
--Ab hier braucht man nicht mehr ndern:
create temp table tmp_konstanten
  (
    tid serial,
    apnr integer,
    beschreibung char(255),
	defaultvalue integer,
	description  ${texttype},
	systeminfo_id integer,
	doku_link varchar(255),
	read_only integer,
	wertebereich varchar(250),
	ab_version varchar(10),
	gruppe varchar(255),
	sachgebiete_id integer
  );
  
<#foreach konstante in konstanten>
  
insert into tmp_konstanten(apnr, 
beschreibung, 
defaultvalue, 
description,
systeminfo_id, 
doku_link, 
read_only, 
wertebereich, 
ab_version,
gruppe, 
sachgebiete_id)
values (${konstante.default_apnr},
'${konstante.beschreibung}', 
${konstante.default_apnr}, 
'${konstante.description}',
${systeminfo_id},
'${doku_link}',
${konstante.read_only}, 
'${konstante.wertebereich}', 
'${konstante.ab_version}',
'${konstante.gruppe}',
${sachgebiete_id}
)
;

</#foreach>

--vorhandene Schlssel Metadaten updaten:

<#if SQLdialect='Postgres'>
--Postgres Dialekt:
update konstanten set defaultvalue=T.defaultvalue,
description=T.description,
systeminfo_id=T.systeminfo_id ,
doku_link=T.doku_link,
read_only=T.read_only ,
wertebereich=T.wertebereich,
ab_version=T.ab_version,
gruppe=T.gruppe ,
sachgebiete_id=T.sachgebiete_id
from tmp_konstanten T
where T.beschreibung=konstanten.beschreibung;

<#else>

--Informix Dialekt:
update konstanten set (defaultvalue,
 description,
 systeminfo_id,
 doku_link,
 read_only,
 wertebereich,
  ab_version,
 gruppe,
 sachgebiete_id)
       = ((select
       defaultvalue,
 description,
 systeminfo_id,
 doku_link,
 read_only,
 wertebereich,
  ab_version,
 gruppe,
 sachgebiete_id
from tmp_konstanten T
where T.beschreibung=konstanten.beschreibung))
where beschreibung in (
select T.beschreibung
from tmp_konstanten T)
;


</#if>

select 'vorh. Konstanten apnrs bleiben erhalten' from xdummy;

delete from tmp_konstanten where beschreibung in (select beschreibung from konstanten);


create temp table tmp_hilf (tid integer);
insert into tmp_hilf select max(tid) from konstanten;
update tmp_hilf set tid=0 where tid is null;

insert into konstanten(tid , apnr ,beschreibung, defaultvalue, description, systeminfo_id, doku_link, read_only, wertebereich, ab_version, gruppe, sachgebiete_id )
select H.tid+K.tid , K.apnr ,K.beschreibung, K.defaultvalue, K.description, K.systeminfo_id, K.doku_link, K.read_only, K.wertebereich, K.ab_version, K.gruppe, K.sachgebiete_id  from tmp_konstanten K, tmp_hilf H;


drop table tmp_konstanten;

drop table tmp_hilf;




