--Freemarker Template 

<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

--start ergtabelle 
<sqlvars>
<sqlvar name="kenn_katalog" type="hash">
select distinct K.id,
trim(K.name) as name,
trim(K.quelltabelle) as quelltabelle,
trim(K.quellfeld) as quellfeld,
trim(K.bedingung) as bedingung,
trim(K.stichtagsart) as stichtagsart,
trim(K.bezugsart) as  bezugsart,
trim(K.zeitfeld) as zeitfeld
FROM kenn_katalog K, kenn_katalog_rpt R
where K.id=R.katalog_id
and R.report_id in ('ERFOLG_SAL','ERFOLG_SAH')
;
</sqlvar>
</sqlvars>

<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5 || K_KENN_PROFIL==6 || K_KENN_PROFIL==0)>

create temp table tmp_extkotr_lfb_hs(
	key CHAR(255) , 
	key2 CHAR(255) , 
hs_nr INTEGER 
) 
;
create temp table tmp_extkotr_lfb_hs2(
	key CHAR(255) , 
hs_nr INTEGER 
) 
;
<#if kenn_katalog?has_content >
<#foreach row_kennzahl in kenn_katalog>
<#if row_kennzahl.quelltabelle != "" >
--Achtung: koiert von Maske 18000 :
<#assign extkotr_colname="" />
<#if row_kennzahl.quelltabelle=="kenn_sos_stg" || row_kennzahl.quelltabelle=="kenn_sos_lab" 
|| row_kennzahl.quelltabelle=="kenn_sos_stg" || row_kennzahl.quelltabelle=="kenn_flaeche"
|| row_kennzahl.quelltabelle=="kenn_pbv_aggr" || row_kennzahl.quelltabelle=="kenn_konto_aggr"
|| row_kennzahl.quelltabelle=="kenn_anlagen_aggr" || row_kennzahl.quelltabelle=="kenn_stupl" >
<#assign extkotr_colname="extkotr" />
</#if>
<#if row_kennzahl.quelltabelle== "kenn_busa_aggr">
<#assign extkotr_colname="projnr,inst_art" />
</#if>
<#if row_kennzahl.quelltabelle== "kenn_vtbu_aggr">
<#if row_kennzahl.bedingung?index_of("quell") &gt; -1 >
<#assign extkotr_colname="nvl(quell_ch110_inst,quell_projnr),quell_ch110_inst" />
<#else>
<#assign extkotr_colname="ziel_projnr,ziel_ch110_inst" />
</#if>
</#if>
<#if row_kennzahl.quelltabelle== "kenn_zahl_wert">
<#if row_kennzahl.id == "FORSCH_HABILITATION_KOEPFE" || row_kennzahl.id == "FO_WISS_NAWU_HABIL" || row_kennzahl.id == "FO_WISS_NAWU_PROM" || row_kennzahl.id == "FO_WISS_NAWU_PROM_KOOP" || row_kennzahl.id == "FO_WISS_NAWU_PROM_JDV" || row_kennzahl.id == "PROM_WEIBLICH_PROZ" || row_kennzahl.id == "STUD_AUSL_PROM_ANZ">
<#assign extkotr_colname="ch110_institut" />
<#else>
<#if row_kennzahl.id == "LEHR_UNBER_ANG" || row_kennzahl.id == "LEHRANG_LEHRAUFTRAEGE" >
<#assign extkotr_colname="(select min(substring(SG.key_ext from 1 for 10)) from kenn_inst_to_ext SG where SG.hs_nr=kenn_zahl_wert.hs_nr and SG.instnr=kenn_zahl_wert.ch110_institut)" />
<#else>
<#assign extkotr_colname="(select min(SG.k_extkotr) from kenn_stug SG where SG.hs_nr=kenn_zahl_wert.hs_nr and SG.stug_key=kenn_zahl_wert.stugkey)" />
</#if>
</#if>
</#if>
<#if row_kennzahl.quelltabelle== "kenn_su_imp_stud" ||  row_kennzahl.quelltabelle== "kenn_auslastung"||  row_kennzahl.quelltabelle== "kenn_proj_gege">
<#assign extkotr_colname="k_extkotr" />
</#if>

insert into tmp_extkotr_lfb_hs
select distinct 
<#if row_kennzahl.quelltabelle=="kenn_vtbu_aggr" || row_kennzahl.quelltabelle=="kenn_busa_aggr" >
 ${extkotr_colname},
 <#else>
 ${extkotr_colname},
 null::char(10),
 </#if>
 hs_nr
 from ${row_kennzahl.quelltabelle};
</#if>
</#foreach>
</#if>

insert into tmp_extkotr_lfb_hs2
select distinct key,hs_nr from tmp_extkotr_lfb_hs
where key is not null
and hs_nr is not null;
insert into tmp_extkotr_lfb_hs2
select distinct key2,hs_nr from tmp_extkotr_lfb_hs
where key2 is not null
and hs_nr is not null;

 
delete from kenn_extkotr_lfb_hs;
insert into kenn_extkotr_lfb_hs
select distinct substring(key from 4 for 3),hs_nr from tmp_extkotr_lfb_hs2;

drop table  tmp_extkotr_lfb_hs;
drop table  tmp_extkotr_lfb_hs2;

</#if>

