#!/bin/bash

cd $KENN_PFAD/schluesseltabellen

DOQUERY "create table tmp_kenn_cifx
  (
    tid integer,
    hs integer,
    key smallint,
    apnr char(10),
    d_akt_von date,
    d_akt_bis date,
    kurz char(10),
    druck nchar(100),
    lang_1 nchar(250),
    lang_2 nchar(250),
    lang_3 nchar(250),
    parent char(10),
    filter char(10),
    his_system_key char(10),
    astat char(10),
    bund_apnr char(10),
    land_apnr char(10),
    sort1 integer,
    sort2 integer,
    sort3 integer,
    sortc1 char(10),
    sortc2 char(10),
    intern_int integer,
    intern_c char(10),
    sprache char(3),
    struktur_int integer,
    struktur_c char(50),
    ebene integer,
    gruppe char(10)
  )  ;"

DOQUERY "CREATE TABLE tmp_abschl_astat (
    tid serial NOT NULL,
    astat character(10) NOT NULL,
    parent character(10),
    ktxt character(10),
    dtxt character(150),
    ltxt character(250),
    sicht character(200) NOT NULL,
    ebene smallint,
    sort1 integer,
    sortc1 character(10),
    gueltig_von date,
    gueltig_bis date,
    struktur_c char(50)
);"

DOQUERY "CREATE TABLE tmp_stg_astat (
    tid serial NOT NULL,
    astat character(10) NOT NULL,
    parent character(10),
    ktxt character(10),
    dtxt character(150),
    ltxt character(250),
    sicht character(200) NOT NULL,
    ebene smallint,
    sort1 integer,
    sortc1 character(10),
    gueltig_von date,
    gueltig_bis date,
    struktur_c char(50)
);"

echo "Lade Tabelle tmp_stg_astat"
echo `date`
sx_auto_upload_table.x tmp_stg_astat $KENN_PFAD/schluesseltabellen/kenn_stg_astat.unl


echo "Lade Tabelle tmp_abschl_astat"
echo `date`

sx_auto_upload_table.x tmp_abschl_astat $KENN_PFAD/schluesseltabellen/kenn_abschl_astat.unl



sx_auto_upload_table.x tmp_kenn_cifx $KENN_PFAD/schluesseltabellen/kenn_cifx.unl



echo "SQL-Scriptfile $KENN_PFAD/schluesseltabellen/kenn_cifx_init.sql ausfhren"
echo `date`


DOSQL $KENN_PFAD/schluesseltabellen/kenn_cifx_init.sql

echo "SQL-Scriptfile $KENN_PFAD/schluesseltabellen/kenn_cifx_fuellen.sql ausfhren"
echo `date`

DOSQL $KENN_PFAD/upgrade/kenn_cifx_fuellen.sql


echo "SQL-Scriptfile $KENN_PFAD/schluesseltabellen/drop_k.sql ausfhren"
echo `date`


DOSQL $KENN_PFAD/schluesseltabellen/drop_k.sql



