--  
--Freemarker Template 

<sqlvars>
<sqlvar name="ivs_akl_exists">
select sp_table_exists('ivs_akl') from xdummy;
</sqlvar>
</sqlvars>



create temp table tmp_cifx2
  (tid serial,
     key smallint not null ,
   hs integer not null,
    apnr char(10) not null ,
    kurz char(10),
    druck varchar(100),
    lang_1 char(150),
    lang_2 char(150),
    lang_3 char(150),
    astat char(10) ,
    parent char(10) , 
    sortc1 CHAR(10) , 
    sort1 integer,
    bund_apnr CHAR(10) , 
    land_apnr CHAR(10) , 
    sprache CHAR(3),
    struktur_c char(50),
    d_akt_von date,
    d_akt_bis date,
    ebene integer,
    his_system_key char(10),
    gruppe char(50)
  );


create temp table tmp_keys(tid serial,key smallint,hs integer);


create temp table tmp_hilf(tid integer);

CREATE temp  TABLE tmp_stg_astat2 (
    tid serial NOT NULL,
    astat character(10) NOT NULL,
    parent character(10),
    ktxt character(10),
    dtxt character(150),
    ltxt character(250),
    sicht character(200) NOT NULL,
    ebene smallint,
    sort1 integer,
    sortc1 character(10),
    gueltig_von date,
    gueltig_bis date,
    struktur_c char(50)
);

--zunchst feste Tabellen astat:
insert into tmp_stg_astat2
select * from tmp_stg_astat;

insert into tmp_cifx2
( hs,
       key,
       apnr,
       d_akt_von,
       d_akt_bis,
       kurz,
       druck,
       lang_1,
       parent,
       astat,
       sort1,
       sortc1,
       ebene,
       struktur_c)
SELECT 0,662,
       astat,
       gueltig_von,
       gueltig_bis,
       ktxt,
       dtxt,
       ltxt,
            parent,
       astat,
       sort1,
       sortc1,
       ebene,
       struktur_c
FROM tmp_abschl_astat;

insert into tmp_cifx2
( hs,
       key,
       apnr,
       d_akt_von,
       d_akt_bis,
       kurz,
       druck,
       lang_1,
       parent,
       astat,
       sort1,
       sortc1,
       ebene,
       struktur_c)
SELECT 0,663,
       astat,
       gueltig_von,
       gueltig_bis,
       ktxt,
       dtxt,
       ltxt,
       parent,
       astat,
       sort1,
       sortc1,
       ebene,
       struktur_c
FROM tmp_stg_astat;

--kenn_perso_z
insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1
)
values (0,111,'k','k','Kpfe','Kpfe');
insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1
)
values (0,111,'v','v','Vollzeit-quiv.','Vollzeit-quivalente');

--kenn_stell_z
insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1
)
values (0,112,'k','k','Anzahl Stellen','Anzahl Stellen');
insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1
)
values (0,112,'v','v','Vollzeit-quiv.','Vollzeit-quivalente');


update tmp_cifx2 set druck='Sonstige' 
where key=636
and (druck is null or druck='');
update tmp_cifx2 set lang_1='Sonstige' 
where key=636
and (lang_1 is null or lang_1='');


--root Geldgeber
insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
d_akt_von,
d_akt_bis
)
select 0,
636,
'_KLRGG',
'GG KLR',
'Mittelherkunft (KLR)',
'Mittelherkunft (KLR)',
date_val('01.01.1900'),
date_val('31.12.3000')
from xdummy;

--Trgerschaft
insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
lang_2,
sort1
)
values (0,672,'ST','ST','Staatlich','Staatlich','Staatliche Hochschulen',1);

insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
lang_2,
sort1
)
values (0,672,'OEMWK','OEMWK','ff.D.MWK','ffentl. Dienst MWK','Hochschulen ffentlicher Dienst MWK',2);
insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
lang_2,
sort1
)
values (0,672,'OENMWK','OENMWK','ff.D.n.MWK','ffentl. Dienst nicht MWK','Hochschulen ffentlicher Dienst nicht MWK',3);
insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
lang_2,
sort1
)
values (0,672,'NST','NST','Nichtstaatl.','Nicht-Staatlich','Nicht-Staatliche Hochschulen',4);
--Hochschulart
insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
his_system_key
)
values (0,673,'U','Uni','Universitt','Universitt',1);

insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
his_system_key
)
values (0,673,'FH','FH','Fachhochschule','Fachhochschule',3);

insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
his_system_key
)
values (0,673,'PH','PH','Pd. Hochschule','Pd. Hochschule',2);

insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
his_system_key
)
values (0,673,'KMW','Kunsths.','Kunst/Musik-Hochschule','Kunst/Musik-Hochschule',4);

insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
his_system_key
)
values (0,673,'VFH','Verw.-FH','Verwaltungs-Fachhochschule','Verwaltungs-Fachhochschule',6);

insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
his_system_key
)
values (0,673,'DH','Duale HS.','Duale Hochschule','Duale Hochschule',5);
--Sicht Fcher und Fchergruppen:
--Fcherebene, dann SB berspringen, und zur FGR 
insert into tmp_cifx2(
hs,
key,
apnr,
parent,
kurz,
druck,
lang_1,
struktur_c,
ebene
)
SELECT 0,676,
       A.astat,
       T.parent,
       A.ktxt,
       A.dtxt,
       A.ltxt,
       A.struktur_c,
       3
FROM tmp_stg_astat A left outer join tmp_stg_astat2 T
on(T.astat=A.parent)
where A.struktur_c ='Fach (amtlich)'
;
--Dann FGR:
insert into tmp_cifx2(
hs,
key,
apnr,
parent,
kurz,
druck,
lang_1,
struktur_c,
ebene
)
select 0,676,
A.astat,
'_Alle',
       A.ktxt,
       A.dtxt,
       A.ltxt,
       A.struktur_c,
       2
       from tmp_stg_astat A where struktur_c ='Fchergruppe';
--Dann root:
insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
struktur_c,
ebene
)
select 0,676,'_Alle',
'Alle',
'Alle Fchergruppen',
'Alle Fchergruppen',
'Summe Fchergruppen',
1 
from xdummy;



--Duplikate raus
create temp table tmp_doppelt
(key integer, apnr char(10));
insert into tmp_doppelt
select key,apnr from tmp_cifx2
group by 1,2
having count(*)>1;

select * from tmp_doppelt;

delete from tmp_cifx2 where key || apnr in
(select key || apnr from tmp_doppelt);
drop table tmp_doppelt;

--
--Falls es ueberkeys gibt, die nicht in Schlsseltabelle stehen:
create temp table tmp_parent (key integer,parent char(10));
insert into tmp_parent select distinct key, parent from tmp_cifx2
where parent is not null;
delete from tmp_parent where key || parent in (select distinct key || apnr from tmp_cifx2);
--es bleiben die noch nicht zugeorndeten Schlssel:



insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
d_akt_von,
d_akt_bis
)
select 0,
key,
parent,
parent,
'Unbek. Schlssel ' || parent,
'Unbek. Schlssel ' || parent,
date_val('01.01.1900'),
date_val('31.12.2999') 
FROM tmp_parent;

drop table tmp_parent;

--Vorhandene Schlssel werden ersetzt, nicht vorhandene Schlssel bleiben:
--Ausnahme: Feld gruppe wird nicht gendert.
update tmp_cifx2 set gruppe=(select gruppe from kenn_cifx C 
where C.key=tmp_cifx2.key
and C.apnr=tmp_cifx2.apnr
and gruppe is not null
and gruppe != '-9')
where '' || key || apnr in 
(select '' || key || apnr from kenn_cifx
where gruppe is not null
and gruppe != '-9');

--Abschlussart
update tmp_cifx2 set lang_2=(select min(A.dtxt)
  from tmp_abschl_astat A 
  where A.struktur_c ='Abschlussart'
  and A.astat=tmp_cifx2.parent)
  where key=662
  and struktur_c='Abschluss (amtlich)' ;
--Abschlussgruppen:
update tmp_cifx2 set lang_3=(select min(A.dtxt)
  from tmp_abschl_astat A , tmp_abschl_astat A2
  where A.struktur_c ='Abschlussgruppe'
  and A.astat=A2.parent
  and tmp_cifx2.parent=A2.astat)
   where key=662
  and struktur_c='Abschluss (amtlich)' ;
  
--Studienbereiche:
update tmp_cifx2 set lang_2=(select min(A.dtxt)
  from tmp_stg_astat A 
  where A.struktur_c ='Studienbereich'
  and A.astat=tmp_cifx2.parent)
  where key=663
  and struktur_c='Fach (amtlich)' ;

--Fchergruppen:
update tmp_cifx2 set lang_3=(select min(A.dtxt)
  from tmp_stg_astat A , tmp_stg_astat2 A2
  where A.struktur_c ='Fchergruppe'
  and A.astat=A2.parent
  and tmp_cifx2.parent=A2.astat)
   where key=663
  and struktur_c='Fach (amtlich)' ;

--Nun werden Schlssel ersetzt:
delete from kenn_cifx where ('' || key || '_' || trim(apnr))::char(255) in 
(select ('' || key || '_' || trim(apnr))::char(255) from tmp_cifx2)
or (key in (select key from tmp_keys) and apnr='-999990')
;

update tmp_cifx2 set d_akt_von=date_val('01.01.1900') where d_akt_von is null;
update tmp_cifx2 set d_akt_bis=date_val('31.12.3000') where d_akt_bis is null;

insert into tmp_hilf select max(tid) from kenn_cifx;

update tmp_hilf set tid=1 where tid is null;


 insert into kenn_cifx(tid,key,hs,apnr,kurz,druck,lang_1,lang_2,lang_3,
parent,
astat,
bund_apnr,
sort1,
sortc1,
sprache,
 struktur_c,
land_apnr ,
gruppe,
ebene,
    d_akt_von ,
    d_akt_bis,
    his_system_key
)
select C.tid+H.tid,key,hs,apnr,kurz,druck,lang_1,lang_2,lang_3,
parent,
astat,
bund_apnr,
sort1,
sortc1,
sprache,
struktur_c,
land_apnr ,
gruppe,
ebene,
    d_akt_von ,
    d_akt_bis,
    his_system_key 
from tmp_cifx2 C, tmp_hilf H
where apnr is not null;


 
update kenn_cifx set kurz=substring(druck from 1 for 10)
where (kurz is null or trim(kurz)='') and druck is not null;
 
--obsolet:
delete from kenn_cifx where key=679 and apnr='ERFOLG_SA';

 
drop table tmp_cifx2;
drop table tmp_keys;
drop table tmp_hilf;
drop table tmp_stg_astat2;
 
 
--Damit die Hochschulnummern in der CIFX und in der Hochschulinfo-Tabelle
-- uebereinstimmen, ist folgender UPDATE notwendig:

update kenn_cifx
set hs = (select hs_nr from hochschulinfo)
where hs != 0;
