--  
--Freemarker Template 

<sqlvars>
<sqlvar name="ivs_akl_exists">
select sp_table_exists('ivs_akl') from xdummy;
</sqlvar>
</sqlvars>



create temp table tmp_cifx2
  (tid serial,
     key smallint not null ,
   hs integer not null,
    apnr char(10) ,
    kurz char(10),
    druck varchar(100),
    lang_1 char(150),
    astat char(10) ,
    parent char(10) , 
    sortc1 CHAR(10) , 
    sort1 integer,
    bund_apnr CHAR(10) , 
    land_apnr CHAR(10) , 
    sprache CHAR(3),
    struktur_c char(50),
    d_akt_von date,
    d_akt_bis date,
    ebene integer,
    his_system_key char(10),
    gruppe char(50)
  );


create temp table tmp_keys(tid serial,key smallint,hs integer);


create temp table tmp_hilf(tid integer);



--neue Stichtags-Quartale?
create temp table tmp_quartal
(
    quartal integer
);

--zuerst direkt aus kenn_stichtag:
insert into tmp_quartal
select distinct S.bezugszeit
FROM kenn_stichtag S left outer join kenn_quartale Q 
on (Q.apnr=S.bezugszeit)
where S.bezugsart='Q'
and Q.apnr is null
and substring('' || S.bezugszeit from 1 for 1) like '2%'
and  substring('' || S.bezugszeit from 5 for 1) in ('1','2','3','4');
--Dann Quartale aus kenn_busa_aggr etc:
select 'Quartale aus kenn_busa_aggr etc:' from xdummy;
insert into tmp_quartal select distinct quartal from kenn_busa_aggr;
insert into tmp_quartal select distinct quartal from kenn_vtbu_aggr;
insert into tmp_quartal select distinct quartal from kenn_vtbu_qp_aggr;

insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
d_akt_von,
d_akt_bis
)
select distinct 0::smallint,
664::smallint,
S.quartal,
S.quartal,
substring('' || S.quartal from 5 for 1) || '. Quartal ' || substring('' || S.quartal from 1 for 4)::char(150),
substring('' || S.quartal from 5 for 1) || '. Quartal ' || substring('' || S.quartal from 1 for 4)::char(150),
date_val('01.01.1900'),
date_val('31.12.3000')
FROM tmp_quartal S left outer join kenn_quartale Q 
on (Q.apnr=S.quartal)
where Q.apnr is null
;


--Anlageklassen:
<#if ivs_akl_exists=1>

insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
parent,
d_akt_von,
d_akt_bis
)
select distinct 0::smallint,
671::smallint,
akl_key,
akl_key,
akl_bez,
akl_bez,
akl_parent ,
date_val('01.01.1900'),
date_val('31.12.3000')
from ivs_akl;

</#if>


--Duplikate raus
create temp table tmp_doppelt
(key integer, apnr char(10));
insert into tmp_doppelt
select key,apnr from tmp_cifx2
group by 1,2
having count(*)>1;

select * from tmp_doppelt;

delete from tmp_cifx2 where key || '_' || apnr in
(select key || '_' || apnr from tmp_doppelt);
drop table tmp_doppelt;

delete from tmp_cifx2 where apnr is null;

--
--Falls es ueberkeys gibt, die nicht in Schlsseltabelle stehen:
create temp table tmp_parent (key integer,parent char(10));
insert into tmp_parent select distinct key, parent from tmp_cifx2
where parent is not null;
delete from tmp_parent where key || parent in (select distinct key || apnr from tmp_cifx2);
--es bleiben die noch nicht zugeorndeten Schlssel:



insert into tmp_cifx2(
hs,
key,
apnr,
kurz,
druck,
lang_1,
d_akt_von,
d_akt_bis
)
select 0,
key,
parent,
parent,
'Unbek. Schlssel ' || parent,
'Unbek. Schlssel ' || parent,
date_val('01.01.1900'),
date_val('31.12.2999') 
FROM tmp_parent;

drop table tmp_parent;

--Vorhandene Schlssel werden ersetzt, nicht vorhandene Schlssel bleiben:
--Ausnahme: Feld gruppe wird nicht gendert.
update tmp_cifx2 set gruppe=(select gruppe from kenn_cifx C 
where C.key=tmp_cifx2.key
and C.apnr=tmp_cifx2.apnr
and gruppe is not null
and gruppe != '-9')
where '' || key || apnr in 
(select '' || key || apnr from kenn_cifx
where gruppe is not null
and gruppe != '-9');


--Nun werden Schlssel ersetzt:
delete from kenn_cifx where ('' || key || trim(apnr))::char(255) in 
(select ('' || key || trim(apnr))::char(255) from tmp_cifx2)
or (key in (select key from tmp_keys) and apnr='-999990')
;

update tmp_cifx2 set d_akt_von=date_val('01.01.1900') where d_akt_von is null;
update tmp_cifx2 set d_akt_bis=date_val('31.12.3000') where d_akt_bis is null;

insert into tmp_hilf select max(tid) from kenn_cifx;

update tmp_hilf set tid=1 where tid is null;


 insert into kenn_cifx(tid,key,hs,apnr,kurz,druck,lang_1,
parent,
astat,
bund_apnr,
sort1,
sortc1,
sprache,
 struktur_c,
land_apnr ,
gruppe,
ebene,
    d_akt_von ,
    d_akt_bis,
    his_system_key
)
select C.tid+H.tid,key,hs,apnr,kurz,druck,lang_1
,
parent,
astat,
bund_apnr,
sort1,
sortc1,
sprache,
struktur_c,
land_apnr ,
gruppe,
ebene,
    d_akt_von ,
    d_akt_bis,
    his_system_key 
from tmp_cifx2 C, tmp_hilf H
where apnr is not null;


 
update kenn_cifx set kurz=substring(druck from 1 for 10)
where (kurz is null or trim(kurz)='') and druck is not null;
 


 
drop table tmp_cifx2;
drop table tmp_keys;
drop table tmp_hilf;
 drop table tmp_quartal;
 
--Damit die Hochschulnummern in der CIFX und in der Hochschulinfo-Tabelle
-- uebereinstimmen, ist folgender UPDATE notwendig:

update kenn_cifx
set hs = (select hs_nr from hochschulinfo)
where hs != 0;

