#!/bin/bash
CP=".:$JDBC_CLASSPATH"

java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "SELECT K.id as id,trim(R.gruppe_1) || string_not_null(trim(R.gruppe_2)) as Laufnummer,trim(K.name) as Name,trim(K.beschreibung) as Kommentar,
K.quelltabelle as Quelltabelle, K.quellfeld as Feld, replace(substring(K.bedingung from 4 for 251),'and','und')::text as Filter
 FROM kenn_katalog_rpt R, kenn_katalog K
where R.katalog_id=K.id
and R.report_id='GRUND_BW'
order by R.ord_nr;" "xml" "$DBDELIMITER" "false" "grund.xml" 


sx_transform.x -IN:grund.xml -XSL:$SUPERX_DIR/db/conf/xml_unload2html.xsl -OUT:./../../../../../../../doku/kenn_modul/formeln_grunddaten.html -method:html "-param:tabname=Grunddaten-Katalog"
rm grund.xml
java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "SELECT K.id as ID,trim(R.gruppe_1)  || string_not_null(trim(R.gruppe_2)) as Laufnummer,trim(K.name) as Name,trim(K.beschreibung) as Kommentar,
K.quelltabelle as Quelltabelle, K.quellfeld as Feld, replace(substring(K.bedingung from 4 for 251),'and','und')::text as Filter
 FROM kenn_katalog_rpt R, kenn_katalog K
where R.katalog_id=K.id
and R.report_id='KENN_BW'
order by R.ord_nr;" "xml" "$DBDELIMITER" "false" "kenn.xml" 


sx_transform.x -IN:kenn.xml -XSL:$SUPERX_DIR/db/conf/xml_unload2html.xsl -OUT:./../../../../../../../doku/kenn_modul/formeln_kennzahlen.html -method:html "-param:tabname=Kennzahlen-Katalog"
rm kenn.xml


java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "SELECT K.id as id,trim(R.gruppe_1) || string_not_null(trim(R.gruppe_2)) as Laufnummer,trim(K.name) as Name,trim(K.beschreibung) as Kommentar,
K.quelltabelle as Quelltabelle, K.quellfeld as Feld, replace(substring(K.bedingung from 4 for 200),'and','und') as Filter
 FROM kenn_katalog_rpt R, kenn_katalog K
where R.katalog_id=K.id
and R.report_id='ERFOLG_SAH'
order by R.ord_nr;" "xml" "$DBDELIMITER" "false" "grund.xml" 


sx_transform.x -IN:grund.xml -XSL:$SUPERX_DIR/db/conf/xml_unload2html.xsl -OUT:./../../../../../../../doku/kenn_modul/formeln_grunddaten_erfolg_sah.html -method:html "-param:tabname=Hochschul-Erfolgsbericht (Hochschulen)"
rm grund.xml

java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "SELECT K.id as id,trim(R.gruppe_1) || string_not_null(trim(R.gruppe_2)) as Laufnummer,trim(K.name) as Name,trim(K.beschreibung) as Kommentar,
K.quelltabelle as Quelltabelle, K.quellfeld as Feld, replace(substring(K.bedingung from 4 for 200),'and','und') as Filter
 FROM kenn_katalog_rpt R, kenn_katalog K
where R.katalog_id=K.id
and R.report_id='ERFOLG_SAL'
order by R.ord_nr;" "xml" "$DBDELIMITER" "false" "grund.xml" 


sx_transform.x -IN:grund.xml -XSL:$SUPERX_DIR/db/conf/xml_unload2html.xsl -OUT:./../../../../../../../doku/kenn_modul/formeln_grunddaten_erfolg_sal.html -method:html "-param:tabname=Hochschul-Erfolgsbericht (LFB)"
rm grund.xml

java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "SELECT K.id as id,trim(R.gruppe_1) || string_not_null(trim(R.gruppe_2)) as Laufnummer,trim(K.name) as Name,trim(K.beschreibung) as Kommentar,
K.quelltabelle as Quelltabelle, K.quellfeld as Feld, replace(substring(K.bedingung from 4 for 200),'and','und') as Filter
 FROM kenn_katalog_rpt R, kenn_katalog K
where R.katalog_id=K.id
and R.report_id='BASIS_SA'
order by R.ord_nr;" "xml" "$DBDELIMITER" "false" "grund.xml" 


sx_transform.x -IN:grund.xml -XSL:$SUPERX_DIR/db/conf/xml_unload2html.xsl -OUT:./../../../../../../../doku/kenn_modul/formeln_grunddaten_basis_sa.html -method:html "-param:tabname=Basiskennzahlenbericht"
rm grund.xml

java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "SELECT K.id as id,trim(R.gruppe_1) || string_not_null(trim(R.gruppe_2)) as Laufnummer,trim(K.name) as Name,trim(K.beschreibung) as Kommentar,
K.quelltabelle as Quelltabelle, K.quellfeld as Feld, replace(substring(K.bedingung from 4 for 251),'and','und')::text as Filter
 FROM kenn_katalog_rpt R, kenn_katalog K
where R.katalog_id=K.id
and R.report_id='MWKBW2017'
order by K.id;" "xml" "$DBDELIMITER" "false" "mwkbw2017.xml" 


sx_transform.x -IN:mwkbw2017.xml -XSL:$SUPERX_DIR/db/conf/xml_unload2html.xsl -OUT:./../../../../../../../doku/kenn_modul/formeln_mwkbw2017.html -method:html "-param:tabname=MWKBW-2017-Kennzahlen-Katalog"
rm mwkbw2017.xml
