-- XML-generiertes SQL-Script fuer -- von dimension_fuellen.xsl
--freemarker template
--(c) 2008 Daniel Quathamer
<sqlvars>
<sqlvar name="dimension_exists">
select sp_table_exists('dimension') from xdummy;

</sqlvar>

</sqlvars>
<#if dimension_exists=1>

 

create temp table tmp_dimension(
tid integer,
dimension_bp_id INTEGER  not null, 
fact_table VARCHAR(255) , 
d_akt_von DATE , 
d_akt_bis DATE , 
name VARCHAR(255) , 
druck VARCHAR(255) , 
lang_1 VARCHAR(255) , 
lang_2 VARCHAR(255) , 
lang_3 VARCHAR(255) , 
sourcefilter VARCHAR(255),
system_key VARCHAR(255) 

);



insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'hs_nr',
'Hochschulen Namen',
'Hochschulen Namen',
'Hochschulen Namen',
'Hochschulen Namen',
'',
'405'
from dimension_bp where system_key='bluep_hs_nr'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'ca12_staat',
'Staatsangehrigkeit (weltweit)',
'Staatsangehrigkeit (weltweit)',
'Staatsangehrigkeit (weltweit)',
'Staatsangehrigkeit (weltweit)',
'',
'410'
from dimension_bp where system_key='bluep_ca12_staat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'geschlecht',
'Geschlecht',
'Geschlecht',
'Geschlecht',
'Geschlecht',
'',
'501'
from dimension_bp where system_key='bluep_geschlecht'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'hzbart',
'Hochschulzugangsberechtigung',
'Hochschulzugangsberechtigung',
'Hochschulzugangsberechtigung',
'Hochschulzugangsberechtigung',
'',
'806'
from dimension_bp where system_key='bluep_hzbart'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'studiengang_nr',
'Studiengang Nr.',
'Studiengang Nr.',
'Studiengang Nr.',
'Studiengang Nr.',
'',
'373'
from dimension_bp where system_key='bluep_studiengang_nr'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'fach_nr',
'Studienfachnummer',
'Studienfachnummer',
'Studienfachnummer',
'Studienfachnummer',
'',
'372'
from dimension_bp where system_key='bluep_fach_nr'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'fach_sem_zahl',
'Studiensem. nach Fachsem.',
'Studiensem. nach Fachsem.',
'Studiensem. nach Fachsem.',
'Studiensem. nach Fachsem.',
'',
'112'
from dimension_bp where system_key='bluep_fach_sem_zahl'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'sem_rueck_beur_ein',
'Semester',
'Semester',
'Semester',
'Semester',
'',
'604'
from dimension_bp where system_key='bluep_sem'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'kz_rueck_beur_ein',
'Einschreib/Rckmeldestatus',
'Einschreib/Rckmeldestatus',
'Einschreib/Rckmeldestatus',
'Einschreib/Rckmeldestatus',
'',
'815'
from dimension_bp where system_key='bluep_kz_rueck_beur_ein'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'hssem',
'Studiensem. nach Hochschulsem.',
'Studiensem. nach Hochschulsem.',
'Studiensem. nach Hochschulsem.',
'Studiensem. nach Hochschulsem.',
'',
'111'
from dimension_bp where system_key='bluep_hssem'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'stufrm_astat',
'Studienform (amtlich)',
'Studienform (amtlich)',
'Studienform (amtlich)',
'Studienform (amtlich)',
'',
'870'
from dimension_bp where system_key='bluep_stufrm_astat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'stg_astat',
'Studienfach (amtlich)',
'Studienfach (amtlich)',
'Studienfach (amtlich)',
'Studienfach (amtlich)',
'',
'871'
from dimension_bp where system_key='bluep_stg_astat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'kz_fach_astat',
'Fachkennzeichen (amtlich)',
'Fachkennzeichen (amtlich)',
'Fachkennzeichen (amtlich)',
'Fachkennzeichen (amtlich)',
'',
'872'
from dimension_bp where system_key='bluep_kz_fach_astat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'abschluss_astat',
'Studienabschluss (amtlich)',
'Studienabschluss (amtlich)',
'Studienabschluss (amtlich)',
'Studienabschluss (amtlich)',
'',
'873'
from dimension_bp where system_key='bluep_abschluss_astat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'rsz',
'Regelstudienzeit',
'Regelstudienzeit',
'Regelstudienzeit',
'Regelstudienzeit',
'',
'805'
from dimension_bp where system_key='bluep_rsz'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_stg_cube',       
       d_akt_von,
       d_akt_bis,
'extkotr',
'Ext. Kostentrger',
'Ext. Kostentrger',
'Ext. Kostentrger',
'Ext. Kostentrger',
'',
'874'
from dimension_bp where system_key='bluep_extkotr'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'hs_nr',
'Hochschule',
'Hochschule',
'Hochschule',
'Hochschule',
'',
'405'
from dimension_bp where system_key='bluep_hs_nr'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'ca12_staat',
'Staatsangehrigkeit',
'Staatsangehrigkeit',
'Staatsangehrigkeit',
'Staatsangehrigkeit',
'',
'410'
from dimension_bp where system_key='bluep_ca12_staat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'geschlecht',
'Geschlecht',
'Geschlecht',
'Geschlecht',
'Geschlecht',
'',
'501'
from dimension_bp where system_key='bluep_geschlecht'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'hzbart',
'Gruppe der HZB',
'Gruppe der HZB',
'Gruppe der HZB',
'Gruppe der HZB',
'',
'806'
from dimension_bp where system_key='bluep_hzbart'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'studiengang_nr',
'Studiengang-Nummer',
'Studiengang-Nummer',
'Studiengang-Nummer',
'Studiengang-Nummer',
'',
'373'
from dimension_bp where system_key='bluep_studiengang_nr'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'fach_nr',
'Fach-Nummer',
'Fach-Nummer',
'Fach-Nummer',
'Fach-Nummer',
'',
'372'
from dimension_bp where system_key='bluep_fach_nr'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'fachsem',
'Anzahl Fachsemester',
'Anzahl Fachsemester',
'Anzahl Fachsemester',
'Anzahl Fachsemester',
'',
'112'
from dimension_bp where system_key='bluep_fach_sem_zahl'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'semester',
'Semester',
'Semester',
'Semester',
'Semester',
'',
'604'
from dimension_bp where system_key='bluep_sem'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'kz_rueck_beur_ein',
'Status',
'Status',
'Status',
'Status',
'',
'815'
from dimension_bp where system_key='bluep_kz_rueck_beur_ein'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'hssem',
'Anzahl Hochschulsemester',
'Anzahl Hochschulsemester',
'Anzahl Hochschulsemester',
'Anzahl Hochschulsemester',
'',
'111'
from dimension_bp where system_key='bluep_hssem'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'stufrm',
'Studienform (amtlich)',
'Studienform (amtlich)',
'Studienform (amtlich)',
'Studienform (amtlich)',
'',
'870'
from dimension_bp where system_key='bluep_stufrm_astat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'stg_astat',
'Fach (amtlich)',
'Fach (amtlich)',
'Fach (amtlich)',
'Fach (amtlich)',
'',
'871'
from dimension_bp where system_key='bluep_stg_astat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'kz_fach',
'Fachkennzeichen (amtlich)',
'Fachkennzeichen (amtlich)',
'Fachkennzeichen (amtlich)',
'Fachkennzeichen (amtlich)',
'',
'872'
from dimension_bp where system_key='bluep_kz_fach_astat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'abschluss_astat',
'Abschluss (amtlich)',
'Abschluss (amtlich)',
'Abschluss (amtlich)',
'Abschluss (amtlich)',
'',
'873'
from dimension_bp where system_key='bluep_abschluss_astat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_sember_stg_cube',       
       d_akt_von,
       d_akt_bis,
'rsz',
'in der RSZ',
'in der RSZ',
'in der RSZ',
'in der RSZ',
'',
'805'
from dimension_bp where system_key='bluep_rsz'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_antr_cube',       
       d_akt_von,
       d_akt_bis,
'hs_nr',
'Hochschulnummer',
'Hochschulnummer',
'Hochschulnummer',
'Hochschulnummer',
'',
'405'
from dimension_bp where system_key='bluep_hs_nr'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_antr_cube',       
       d_akt_von,
       d_akt_bis,
'ca12_staat',
'Nationalitt',
'Nationalitt',
'Nationalitt',
'Nationalitt',
'',
'410'
from dimension_bp where system_key='bluep_ca12_staat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_antr_cube',       
       d_akt_von,
       d_akt_bis,
'geschlecht',
'Geschlecht (1 mnnl.,2 weibl.)',
'Geschlecht (1 mnnl.,2 weibl.)',
'Geschlecht (1 mnnl.,2 weibl.)',
'Geschlecht (1 mnnl.,2 weibl.)',
'',
'501'
from dimension_bp where system_key='bluep_geschlecht'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_antr_cube',       
       d_akt_von,
       d_akt_bis,
'hzbart',
'Art der Hochschulzugangsber.',
'Art der Hochschulzugangsber.',
'Art der Hochschulzugangsber.',
'Art der Hochschulzugangsber.',
'',
'806'
from dimension_bp where system_key='bluep_hzbart'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_antr_cube',       
       d_akt_von,
       d_akt_bis,
'zul_kz',
'Zulassungskennzeichen',
'Zulassungskennzeichen',
'Zulassungskennzeichen',
'Zulassungskennzeichen',
'',
'875'
from dimension_bp where system_key='bluep_zul_kz'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_antr_cube',       
       d_akt_von,
       d_akt_bis,
'fach_nr',
'Fach-Nummer',
'Fach-Nummer',
'Fach-Nummer',
'Fach-Nummer',
'',
'372'
from dimension_bp where system_key='bluep_fach_nr'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_antr_cube',       
       d_akt_von,
       d_akt_bis,
'fach_sem_zahl',
'Fachsemester',
'Fachsemester',
'Fachsemester',
'Fachsemester',
'',
'112'
from dimension_bp where system_key='bluep_fach_sem_zahl'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_antr_cube',       
       d_akt_von,
       d_akt_bis,
'bewsem',
'Semester',
'Semester',
'Semester',
'Semester',
'',
'604'
from dimension_bp where system_key='bluep_sem'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_antr_cube',       
       d_akt_von,
       d_akt_bis,
'stg_astat',
'Fach (amtlich)',
'Fach (amtlich)',
'Fach (amtlich)',
'Fach (amtlich)',
'',
'871'
from dimension_bp where system_key='bluep_stg_astat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_antr_cube',       
       d_akt_von,
       d_akt_bis,
'abschluss_astat',
'Abschluss (amtlich)',
'Abschluss (amtlich)',
'Abschluss (amtlich)',
'Abschluss (amtlich)',
'',
'873'
from dimension_bp where system_key='bluep_abschluss_astat'
;

insert into tmp_dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select tid,
'kenn_antr_cube',       
       d_akt_von,
       d_akt_bis,
'antrnr',
'Antragsnummer',
'Antragsnummer',
'Antragsnummer',
'Antragsnummer',
'',
'670'
from dimension_bp where system_key='bluep_antrnr'
;

--Vorhandene Schlssel werden ersetzt, nicht vorhandene Schlssel bleiben:

--vorhandene Schlssel ermitteln:
update tmp_dimension set tid=(select tid from 
dimension D where D.fact_table=tmp_dimension.fact_table
and D.system_key=tmp_dimension.system_key);

--vorhandene Schlssel updaten:

<#if SQLdialect='Postgres'>
--Postgres Dialekt:
update dimension set dimension_bp_id=D.dimension_bp_id, 
d_akt_von=D.d_akt_von, 
d_akt_bis=D.d_akt_bis , 
name=D.name , 
druck=D.druck , 
lang_1=D.lang_1 , 
lang_2=D.lang_2 , 
lang_3=D.lang_3 , 
sourcefilter=D.sourcefilter
from tmp_dimension D
where D.tid is not null
and D.tid=dimension.tid;

<#else>

--Informix Dialekt:
update dimension set (dimension_bp_id,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter) 
       = ((select 
       dimension_bp_id,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter
from tmp_dimension D
where D.tid=dimension.tid))
where tid in (select D.tid from tmp_dimension D);


</#if>

--neue Schlssel:
insert into dimension(
dimension_bp_id,
fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key)
       select dimension_bp_id,
       fact_table,
       d_akt_von,
       d_akt_bis,
       name,
       druck,
       lang_1,
       lang_2,
       lang_3,
       sourcefilter,
       system_key
       from tmp_dimension
       where tid is null;
       
       
--gelschte Dimensionen:
delete from dimension 
where fact_table in (select fact_table from tmp_dimension)
and 0 = (select count(*) from tmp_dimension D
where D.system_key=dimension.system_key);

drop table tmp_dimension;



</#if>

