-- XML-generiertes SQL-Script fuer -- von dimension_bp_fuellen.xsl

--freemarker template
<sqlvars>
<sqlvar name="dimension_bp_exists">
select sp_table_exists('dimension_bp') from xdummy;

</sqlvar>
</sqlvars>
<#if dimension_bp_exists=1>

 

create temp table tmp_dimension_bp(
	tid SERIAL  not null, 
d_akt_von DATE , 
d_akt_bis DATE , 
apnr VARCHAR(255) , 
kurz VARCHAR(255) , 
druck VARCHAR(255) , 
lang_1 VARCHAR(255) , 
lang_2 VARCHAR(255) , 
lang_3 VARCHAR(255) , 
keyfield VARCHAR(255) , 
keyfieldtype VARCHAR(255) , 
datatype VARCHAR(255) , 
captionfield VARCHAR(255) ,
sortfield VARCHAR(255) , 
source VARCHAR(255) , 
sourcefilter VARCHAR(255) , 
system_key VARCHAR(255) 
);



insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_hs_nr',
substring('Hochschule' from 1 for 10),
'Hochschule',
'Hochschule',
'Hochschule',
'Hochschule',
'INTEGER',
'nominal',

'hs_nr',
'name' ,'', 'dim_hochschule','','bluep_hs_nr'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_ca12_staat',
substring('Staatsangehrigkeit' from 1 for 10),
'Staatsangehrigkeit',
'Staatsangehrigkeit',
'Staatsangehrigkeit',
'Staatsangehrigkeit',
'INTEGER',
'nominal',

'apnr',
'druck' ,'sort1', 'cif',' where key=12','bluep_ca12_staat'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_geschlecht',
substring('Geschlecht' from 1 for 10),
'Geschlecht',
'Geschlecht',
'Geschlecht',
'Geschlecht',
'INTEGER',
'nominal',

'apnr',
'druck' ,'sort1', 'cif',' where key=9003','bluep_geschlecht'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_hzbart',
substring('Hochschulzugangsberechtigung' from 1 for 10),
'Hochschulzugangsberechtigung',
'Hochschulzugangsberechtigung',
'Hochschulzugangsberechtigung',
'Hochschulzugangsberechtigung',
'INTEGER',
'nominal',

'apnr',
'druck' ,'sort1', 'cif',' where key=652','bluep_hzbart'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_studiengang_nr',
substring('Studiengangnummer.' from 1 for 10),
'Studiengangnummer.',
'Studiengangnummer.',
'Studiengangnummer.',
'Studiengangnummer.',
'INTEGER',
'nominal',

'apnr',
'druck' ,'sort1', 'cif',' where key=653','bluep_studiengang_nr'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_fach_nr',
substring('Studienfachnummer' from 1 for 10),
'Studienfachnummer',
'Studienfachnummer',
'Studienfachnummer',
'Studienfachnummer',
'INTEGER',
'nominal',

'apnr',
'druck' ,'sort1', 'cif',' where key=654','bluep_fach_nr'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_fach_sem_zahl',
substring('Studiensem. nach Fachsem.' from 1 for 10),
'Studiensem. nach Fachsem.',
'Studiensem. nach Fachsem.',
'Studiensem. nach Fachsem.',
'Studiensem. nach Fachsem.',
'INTEGER',
'nominal',

'apnr',
'druck' ,'sort1', 'cif',' where key=655','bluep_fach_sem_zahl'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_sem',
substring('Semester' from 1 for 10),
'Semester',
'Semester',
'Semester',
'Semester',
'INTEGER',
'nominal',

'apnr',
'druck' ,'sort1', 'cif',' where key=661','bluep_sem'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_kz_rueck_beur_ein',
substring('Einschreib/Rckmeldestatus' from 1 for 10),
'Einschreib/Rckmeldestatus',
'Einschreib/Rckmeldestatus',
'Einschreib/Rckmeldestatus',
'Einschreib/Rckmeldestatus',
'INTEGER',
'nominal',

'val(astat)',
'druck' ,'sort1', 'cifx',' where key=9001','bluep_kz_rueck_beur_ein'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_hssem',
substring('Studiensem. nach Hochschulsem.' from 1 for 10),
'Studiensem. nach Hochschulsem.',
'Studiensem. nach Hochschulsem.',
'Studiensem. nach Hochschulsem.',
'Studiensem. nach Hochschulsem.',
'INTEGER',
'nominal',

'apnr',
'druck' ,'sort1', 'cif',' where key=657','bluep_hssem'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_stufrm_astat',
substring('Studienform (amtlich)' from 1 for 10),
'Studienform (amtlich)',
'Studienform (amtlich)',
'Studienform (amtlich)',
'Studienform (amtlich)',
'varchar',
'nominal',

'apnr',
'druck' ,'', 'kenn_stufrm','','bluep_stufrm_astat'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_stg_astat',
substring('Studienfach (amtlich)' from 1 for 10),
'Studienfach (amtlich)',
'Studienfach (amtlich)',
'Studienfach (amtlich)',
'Studienfach (amtlich)',
'varchar',
'nominal',

'astat',
'dtxt' ,'', 'kenn_stg_astat',' where struktur_c=''Fach (amtlich)''','bluep_stg_astat'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_kz_fach_astat',
substring('Fachkennzeichen (amtlich)' from 1 for 10),
'Fachkennzeichen (amtlich)',
'Fachkennzeichen (amtlich)',
'Fachkennzeichen (amtlich)',
'Fachkennzeichen (amtlich)',
'varchar',
'nominal',

'astat',
'druck' ,'', 'kenn_kzfa','','bluep_kz_fach_astat'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_abschluss_astat',
substring('Abschluss (amtlich)' from 1 for 10),
'Abschluss (amtlich)',
'Abschluss (amtlich)',
'Abschluss (amtlich)',
'Abschluss (amtlich)',
'varchar',
'nominal',

'astat',
'dtxt' ,'', 'kenn_abschl_astat',' where struktur_c=''Abschluss (amtlich)''','bluep_abschluss_astat'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_rsz',
substring('Regelstudienzeit (in / ausserhalb)' from 1 for 10),
'Regelstudienzeit (in / ausserhalb)',
'Regelstudienzeit (in / ausserhalb)',
'Regelstudienzeit (in / ausserhalb)',
'Regelstudienzeit (in / ausserhalb)',
'INTEGER',
'nominal',

'apnr',
'druck' ,'sort1', 'cif',' where key=658','bluep_rsz'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_extkotr',
substring('Externer Kostentraeger' from 1 for 10),
'Externer Kostentraeger',
'Externer Kostentraeger',
'Externer Kostentraeger',
'Externer Kostentraeger',
'varchar',
'nominal',

'key',
'name' ,'', 'kenn_extkotr','','bluep_extkotr'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_antrnr',
substring('Antrag' from 1 for 10),
'Antrag',
'Antrag',
'Antrag',
'Antrag',
'INTEGER',
'nominal',

'apnr',
'druck' ,'sort1', 'cif',' where key=662','bluep_antrnr'
);

insert into tmp_dimension_bp(
       d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfieldtype,
       datatype,
       keyfield  , 
captionfield  ,
sortfield , 
source , 
sourcefilter, 
       system_key)
       values(
date_val('01.01.1900'),
date_val('01.01.2999'),
'bluep_zul_kz',
substring('Zulassungskennzeichen' from 1 for 10),
'Zulassungskennzeichen',
'Zulassungskennzeichen',
'Zulassungskennzeichen',
'Zulassungskennzeichen',
'INTEGER',
'nominal',

'apnr',
'druck' ,'sort1', 'cif',' where key=663','bluep_zul_kz'
);

--updates auf vorh. Schlssel

<#if SQLdialect='Postgres'>
--Postgres Dialekt:
update dimension_bp set apnr=D.apnr, 
d_akt_von=D.d_akt_von, 
d_akt_bis=D.d_akt_bis , 
kurz=D.kurz , 
druck=D.druck , 
lang_1=D.lang_1 , 
lang_2=D.lang_2 , 
lang_3=D.lang_3 , 
keyfieldtype=D.keyfieldtype,
datatype=D.datatype,
keyfield=D.keyfield,
captionfield=D.captionfield,
source=D.source,
sourcefilter=D.sourcefilter
<#if TableFieldExists?exists && TableFieldExists('dimension_bp','sortfield')>
,sortfield=D.sortfield
</#if>
from tmp_dimension_bp D
where D.system_key=dimension_bp.system_key;

<#else>

--Informix Dialekt:
update dimension_bp set ( apnr,
       d_akt_von,
       d_akt_bis,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfield,
       keyfieldtype,
       datatype,
       captionfield,
       <#if TableFieldExists?exists && TableFieldExists('dimension_bp','sortfield')>
sortfield,
</#if>
       source,
       sourcefilter) 
       = ((select 
        apnr,
       d_akt_von,
       d_akt_bis,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
       keyfield,
       keyfieldtype,
       datatype,
       captionfield,
<#if TableFieldExists?exists && TableFieldExists('dimension_bp','sortfield')>
sortfield,
</#if>
       source,
       sourcefilter
from tmp_dimension_bp D
where D.system_key=dimension_bp.system_key))
where system_key in (select D.system_key from tmp_dimension_bp D);


</#if>

--neue werden eingefgt:
delete from tmp_dimension_bp where system_key in 
(select system_key from dimension_bp);

insert into dimension_bp(d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
             keyfield  ,
	     keyfieldtype,
       datatype, 
captionfield  ,
<#if TableFieldExists?exists && TableFieldExists('dimension_bp','sortfield')>
sortfield,
</#if>
source , 
sourcefilter, 
       system_key
 )
select d_akt_von,
       d_akt_bis,
       apnr,
       kurz,
       druck,
       lang_1,
       lang_2,
       lang_3,
             keyfield  , 
	     keyfieldtype,
       datatype,
captionfield  ,
<#if TableFieldExists?exists && TableFieldExists('dimension_bp','sortfield')>
sortfield,
</#if>
source , 
sourcefilter, 
       system_key
 from tmp_dimension_bp
;


 drop table tmp_dimension_bp;


</#if>

