--freemarker template
--(c) 2008 Daniel Quathamer

<#include "KERN_CIFX_UPDATE"/>
--die Merkmale aus Edsutore werden fr ICE aufbereitet:
--keine Zahl grer als 5-stellig (hochschlsseln von 1-x)
--keine 0en
--unbekannt bekomme 99998
--keine negativen Zahlen erlaubt

<sqlvars>

<sqlvar name="merkmale">

select distinct D.system_key,D.druck,('select ' || trim(D.system_key) || ',' || trim(B.keyfield) || 
 ',' || trim(B.captionfield) || ' from ' || trim(B.source) || ' ' || trim(string_not_null(B.sourcefilter)))::varchar(255)
from dimension_bp B,dimension D
where D.dimension_bp_id=B.tid
and D.fact_table in ('kenn_stg_cube','kenn_sember_stg_cube','kenn_antr_cube')
order by 1,2,3;

</sqlvar>
<sqlvar name="sos_k_staat_exists">
select sp_table_exists('sos_k_staat') from xdummy;
</sqlvar>
</sqlvars>

<#assign systeminfo_id="109" />
<#assign nicht_summierbare_merkmale="604" />
<#assign nullable_merkmale="112,--fach_sem_zahl
111, --hssem
806, --hzbart
371, --studiengang_nr
372, --fach_nr
815,--kz_rueck_beur_ein
870,--stufrm_astat
871,--stg_astat
872, --kz_fach_astat
873,--abschluss_astat
874, --extkotr
875, --zul_kz
670, --antrnr
410 --staat
" />
--Merkmale, die Ganzzahlig sind und unverndert 
--nach ICE kommen sollen:
<#assign unchanged_merkmale="501, --geschlecht
604,--Semester
806,--HZBArt
373,--studiengang_nr
372,--fach_nr
111, --hssem
112,--fach_sem_zahl
405, --HS-Nr.
805, --rsz
815, --kz_rueck_beur_ein
875, --zul_kz
670 --antrnr
"
/>


--Das Musterscript liegt fm_templates (id=KERN_CIFX_UPDATE)
<@dim_bp_apnr_fuellen />

--jetzt Level-Hierarchien:
--bluep_ca12_staat
--uniquename:
update dim_bp_apnr set uniquename=(select T.sourcesystem_id
from trans_dim_bp_apnr T where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_ca12_staat')
;

--Inland/Ausland:
update dim_bp_apnr set level1_char='I',level1_str='Inland' where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_ca12_staat')
and apnr in (select T.apnr from trans_dim_bp_apnr T where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and T.sourcesystem_id='0');
update dim_bp_apnr set level1_char='A',level1_str='Ausland' where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_ca12_staat')
and apnr in (select T.apnr from trans_dim_bp_apnr T where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and T.sourcesystem_id!='0');
update dim_bp_apnr set level1_char='U',level1_str='Unbekannt' where level1_char is null
and dim_bp_apnr.dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_ca12_staat');

<#if sos_k_staat_exists=1>
--Kontinent:
update dim_bp_apnr set level2_char=(select min(C.druck) 
from  cifx C, trans_dim_bp_apnr T, sos_k_staat S 
where C.key=747 
and C.apnr=S.erdteil
and T.apnr=dim_bp_apnr.apnr
and '' || val(S.astat)=T.sourcesystem_id
and T.dimension_bp_id=dim_bp_apnr.dimension_bp_id)
where dim_bp_apnr.dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_ca12_staat');
<#else>
--aus Kernmodul:
update dim_bp_apnr set level2_char=(select min(C.lang_3) 
from  cif C, trans_dim_bp_apnr T
where C.key=12
and '' || C.apnr=T.sourcesystem_id
and T.apnr=dim_bp_apnr.apnr
and T.dimension_bp_id=dim_bp_apnr.dimension_bp_id)
where dim_bp_apnr.dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_ca12_staat');
</#if>
update dim_bp_apnr set level2_char='Unbekannt' where level2_char is null
and dim_bp_apnr.dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_ca12_staat');


--Joker: unbekannt:
<#list 1..3 as i>
update dim_bp_apnr set level${i}_char='Unbekannt',level${i}_str='Unbekannt'
where level${i}_char is null
and dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_abschluss');
</#list>

--bluep_stg_astat

--uniquename:
update dim_bp_apnr set uniquename=(select T.sourcesystem_id
from trans_dim_bp_apnr T
where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_stg_astat')
;
--Studienbereich auf Ebene 2:
update dim_bp_apnr set level2_char=(select K.parent
from trans_dim_bp_apnr T, kenn_stg_astat K
where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr
and K.astat=T.sourcesystem_id
)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_stg_astat')
;
--SB Name:
update dim_bp_apnr set level2_str=(select K.dtxt
from trans_dim_bp_apnr T, kenn_stg_astat K
where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr
and K.astat=dim_bp_apnr.level2_char
)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_stg_astat')
;
--Fchergruppe auf Ebene 1:
update dim_bp_apnr set level1_char=(select K.parent
from trans_dim_bp_apnr T, kenn_stg_astat K
where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr
and K.astat=dim_bp_apnr.level2_char
)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_stg_astat')
;
--FGR Name:
update dim_bp_apnr set level1_str=(select K.dtxt
from trans_dim_bp_apnr T, kenn_stg_astat K
where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr
and K.astat=dim_bp_apnr.level1_char
)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_stg_astat')
;
--kenn_abschl_astat:
--uniquename:
update dim_bp_apnr set uniquename=(select T.sourcesystem_id
from trans_dim_bp_apnr T
where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_abschluss_astat')
;
--Abschlussgruppe auf Ebene 2:
update dim_bp_apnr set level2_char=(select K.parent
from trans_dim_bp_apnr T, kenn_abschl_astat K
where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr
and K.astat=T.sourcesystem_id
)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_abschluss_astat')
;
--Abschlussgruppe Name:
update dim_bp_apnr set level2_str=(select K.dtxt
from trans_dim_bp_apnr T, kenn_abschl_astat K
where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr
and K.astat=dim_bp_apnr.level2_char
)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_abschluss_astat')
;
--Abschlussart auf Ebene 1:
update dim_bp_apnr set level1_char=(select K.parent
from trans_dim_bp_apnr T, kenn_abschl_astat K
where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr
and K.astat=dim_bp_apnr.level2_char
)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_abschluss_astat')
;
--Abschlussart Name:
update dim_bp_apnr set level1_str=(select K.dtxt
from trans_dim_bp_apnr T, kenn_abschl_astat K
where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr
and K.astat=dim_bp_apnr.level1_char
)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_abschluss_astat')
;

--bluep_extkotr
--uniquename:
update dim_bp_apnr set uniquename=(select T.sourcesystem_id
from trans_dim_bp_apnr T
where T.dimension_bp_id=dim_bp_apnr.dimension_bp_id
and T.systeminfo_id=${systeminfo_id}
and dim_bp_apnr.apnr=T.apnr)
where dimension_bp_id=
(select D.tid from dimension_bp D where D.apnr='bluep_extkotr')
;
