#!/bin/bash
#Extraction Script for SuperX.
#Bitte nicht ndern, diese Datei ist automatisch generiert. 

SRC_PFAD=$KENN_LOAD_PFAD
. ./KENN_ENV
if [ "$SRC_PFAD" = "" ]
then 
SRC_PFAD=.
fi

if [ "$outFormat" = "" ]
then 
outFormat=txt
fi

DATUM=`cat $SRC_PFAD/superx.datum`
ERR=kenn_unload.err
cp $SRC_PFAD/superx.datum $SRC_PFAD/superx.datum.alt

##Lschen der alten Dateien
rm $SRC_PFAD/unl/*unl >/dev/null 2>&1

date +'%d.%m.%Y' > $SRC_PFAD/superx.datum  ##neues Entladedatum

HEUTE=`date +'%d.%m.%Y'`

echo "Letztes Update-Datum: " $DATUM >$ERR
echo "DATABASE: $DATABASE" >>$ERR
echo "VERSION:  $VERSION" >>$ERR
echo "SX_CLIENT: $SX_CLIENT" >>$ERR 
echo "2.5^"$HEUTE"^" >$SRC_PFAD/unl/superx_unload_version.unl  

cd $SRC_PFAD >>$ERR 2>&1

CP=".:$JDBC_CLASSPATH:$XML_CLASSPATH"

case "`uname`" in
CYGWIN*) 
CP=".;$JDBC_CLASSPATH;$XML_CLASSPATH"
;;
esac

cat /dev/null >unload_params.txt

 
if [ "$SOURCESYSTEM" = "" ]
then
SOURCESYSTEM="eduetl"
export SOURCESYSTEM

fi
echo "Parameter SOURCESYSTEM: $SOURCESYSTEM"  >>$ERR
echo "\$SOURCESYSTEM=$SOURCESYSTEM" >>unload_params.txt 

#jdbc zum Entladen 
if [ "$SX_CLIENT" = "jdbc" ]
then
java $JAVA_OPTS -cp $CP de.superx.bin.SxExtractor -logger:$LOGGER_PROPERTIES -dbproperties:$DB_PROPERTIES -xml:kenn_unload.xml -outFormat:$outFormat -delim:$DBDELIMITER -header:$header -database:$DATABASE -version:$VERSION -unload_params:unload_params.txt >>$ERR 2>&1

exit 0

fi


#
#Unload-Job kenn_version
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_version" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
SELECT version
 FROM db_version
where his_system='kenn' ;
		" "txt" "$DBDELIMITER" "false" "unl/kenn_version.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_version >>$ERR  2>&1   

unload to "unl/kenn_version.unl" 

			
SELECT version
 FROM db_version
where his_system='kenn' ;
		--Ende
END_kenn_version
fi

fi

#
#Unload-Job kenn_busa_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_busa_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
 SELECT hs_nr,
	jahr,
	quartal,
	monat,
	fikrkey,
	kokl_faktor,
	klr_geldgeber,
	ch110_institut,
	projnr,
	date_str(datum) ,
	betrag,
	bvkr_art,
	inst_art
 FROM kenn_busa_aggr
 where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KOTN'
 and exportieren='1')
 or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='KOTN'
 and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_busa_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_busa_aggr >>$ERR  2>&1   

unload to "unl/kenn_busa_aggr.unl" 

			
 SELECT hs_nr,
	jahr,
	quartal,
	monat,
	fikrkey,
	kokl_faktor,
	klr_geldgeber,
	ch110_institut,
	projnr,
	date_str(datum) ,
	betrag,
	bvkr_art,
	inst_art
 FROM kenn_busa_aggr
 where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KOTN'
 and exportieren='1')
 or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='KOTN'
 and exportieren='1');
		--Ende
END_kenn_busa_aggr
fi

fi

#
#Unload-Job kenn_fikr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_fikr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
 SELECT hs_nr,
 key,
	ueberg,
	kbez,
	lbez,
	kokl,
	habpos,
	ebene,
	date_str(key_von) ,
	date_str(key_bis) 
 FROM kenn_fikr
 where 0 < (SELECT count(*) 
 FROM kenn_stichtag where stichtagsart_id='KOTN'
 and exportieren='1')
 
		" "txt" "$DBDELIMITER" "false" "unl/kenn_fikr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_fikr >>$ERR  2>&1   

unload to "unl/kenn_fikr.unl" 

			
 SELECT hs_nr,
 key,
	ueberg,
	kbez,
	lbez,
	kokl,
	habpos,
	ebene,
	date_str(key_von) ,
	date_str(key_bis) 
 FROM kenn_fikr
 where 0 < (SELECT count(*) 
 FROM kenn_stichtag where stichtagsart_id='KOTN'
 and exportieren='1')
 
		--Ende
END_kenn_fikr
fi

fi

#
#Unload-Job kenn_proj_gege
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_proj_gege" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
 SELECT hs_nr,
 projnr,
klr_geldgeber,
k_extkotr,
jahr
FROM kenn_proj_gege
 where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KOTN'
 and exportieren='1')
 
		" "txt" "$DBDELIMITER" "false" "unl/kenn_proj_gege.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_proj_gege >>$ERR  2>&1   

unload to "unl/kenn_proj_gege.unl" 

			
 SELECT hs_nr,
 projnr,
klr_geldgeber,
k_extkotr,
jahr
FROM kenn_proj_gege
 where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KOTN'
 and exportieren='1')
 
		--Ende
END_kenn_proj_gege
fi

fi

#
#Unload-Job kenn_flaeche
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_flaeche" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
 SELECT F.hs_nr,
	F.ch110_institut,
	F.nutzungsart,
	F.kfanr,
	F.jahr,
	F.extkotr,
	date_str(F.datum) ,
	F.flaeche
 FROM kenn_flaeche F, kenn_stichtag K
where K.bezugszeit=F.jahr
and K.bezugsart='J'
and K.stichtagsart_id='FLCG'
and K.exportieren='1';

		" "txt" "$DBDELIMITER" "false" "unl/kenn_flaeche.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_flaeche >>$ERR  2>&1   

unload to "unl/kenn_flaeche.unl" 

			
 SELECT F.hs_nr,
	F.ch110_institut,
	F.nutzungsart,
	F.kfanr,
	F.jahr,
	F.extkotr,
	date_str(F.datum) ,
	F.flaeche
 FROM kenn_flaeche F, kenn_stichtag K
where K.bezugszeit=F.jahr
and K.bezugsart='J'
and K.stichtagsart_id='FLCG'
and K.exportieren='1';

		--Ende
END_kenn_flaeche
fi

fi

#
#Unload-Job kenn_inst
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_inst" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
 SELECT tid,
	hs_nr,
	key_apnr,
	parent,
	drucktext,
	name,
	ebene,
	lehre,
	date_str(gueltig_seit) ,
	date_str(gueltig_bis) ,
	orgstruktur,
	bund_lehr_forsch,
	bund_fachgebiet
 FROM kenn_inst
 where 0 < (SELECT count(*) 
 FROM kenn_stichtag where stichtagsart_id='KOTN'
 and exportieren='1')
 ;
 
		" "txt" "$DBDELIMITER" "false" "unl/kenn_inst.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_inst >>$ERR  2>&1   

unload to "unl/kenn_inst.unl" 

			
 SELECT tid,
	hs_nr,
	key_apnr,
	parent,
	drucktext,
	name,
	ebene,
	lehre,
	date_str(gueltig_seit) ,
	date_str(gueltig_bis) ,
	orgstruktur,
	bund_lehr_forsch,
	bund_fachgebiet
 FROM kenn_inst
 where 0 < (SELECT count(*) 
 FROM kenn_stichtag where stichtagsart_id='KOTN'
 and exportieren='1')
 ;
 
		--Ende
END_kenn_inst
fi

fi

#
#Unload-Job kenn_pbv_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_pbv_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT hs_nr,
	geschlecht,
	bund_fachgebiet,
	bund_taetigkeit,
	bund_dienstart,
	buadbz,
	klr_geldgeber,
	kapitel,
	extkost,
	extkotr,
	befristet,
	staat,
	date_str(stichtag) ,
	zaehlung,
	date_str(datum) ,
	summe
FROM kenn_pbv_aggr
where stichtag in
(SELECT stichtag FROM kenn_stichtag where bezugsart='J' and stichtagsart_id='PESI' and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_pbv_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_pbv_aggr >>$ERR  2>&1   

unload to "unl/kenn_pbv_aggr.unl" 

			SELECT hs_nr,
	geschlecht,
	bund_fachgebiet,
	bund_taetigkeit,
	bund_dienstart,
	buadbz,
	klr_geldgeber,
	kapitel,
	extkost,
	extkotr,
	befristet,
	staat,
	date_str(stichtag) ,
	zaehlung,
	date_str(datum) ,
	summe
FROM kenn_pbv_aggr
where stichtag in
(SELECT stichtag FROM kenn_stichtag where bezugsart='J' and stichtagsart_id='PESI' and exportieren='1');
		--Ende
END_kenn_pbv_aggr
fi

fi

#
#Unload-Job kenn_pbv_aggr_astat
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_pbv_aggr_astat" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			select hs_nr,
       jahr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       bund_geldgeber,
       zaehlung,
       datum,
       befristet,
       staat,
       ernennung_jahr,
       ernennung_alter,
       qualifizierung_art,
       fgr,
       summe
       from kenn_pbv_aggr_astat
where jahr in
(SELECT bezugszeit FROM kenn_stichtag 
where bezugsart='J' 
and stichtagsart_id='PESA' 
and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_pbv_aggr_astat.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_pbv_aggr_astat >>$ERR  2>&1   

unload to "unl/kenn_pbv_aggr_astat.unl" 

			select hs_nr,
       jahr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       bund_geldgeber,
       zaehlung,
       datum,
       befristet,
       staat,
       ernennung_jahr,
       ernennung_alter,
       qualifizierung_art,
       fgr,
       summe
       from kenn_pbv_aggr_astat
where jahr in
(SELECT bezugszeit FROM kenn_stichtag 
where bezugsart='J' 
and stichtagsart_id='PESA' 
and exportieren='1');
		--Ende
END_kenn_pbv_aggr_astat
fi

fi

#
#Unload-Job kenn_semester
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_semester" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT tid,
	kurz,
	druck,
	akad_jahr,
	akad_jahr_absolv,
	akad_jahr_anf,
	date_str(sem_beginn) ,
	date_str(sem_ende) 
FROM kenn_semester;
		" "txt" "$DBDELIMITER" "false" "unl/kenn_semester.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_semester >>$ERR  2>&1   

unload to "unl/kenn_semester.unl" 

			SELECT tid,
	kurz,
	druck,
	akad_jahr,
	akad_jahr_absolv,
	akad_jahr_anf,
	date_str(sem_beginn) ,
	date_str(sem_ende) 
FROM kenn_semester;
		--Ende
END_kenn_semester
fi

fi

#
#Unload-Job hochschulinfo
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: hochschulinfo" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT name,hs_nr,kapitel, '$HOST' 
FROM hochschulinfo;
		" "txt" "$DBDELIMITER" "false" "unl/hochschulinfo.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_hochschulinfo >>$ERR  2>&1   

unload to "unl/hochschulinfo.unl" 

			SELECT name,hs_nr,kapitel, '$HOST' 
FROM hochschulinfo;
		--Ende
END_hochschulinfo
fi

fi

#
#Unload-Job kenn_sgd_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_sgd_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT 
hs_nr,
bund_fachgebiet,
bund_dienstart,
faktor,
buadbz,
besetzung,
vzae_besetzung,
koepfe_besetzung,
buadbz_besetzung,
da_besetzung,
taet_besetzung,
date_str(stichtag) ,
date_str(datum) ,
zaehlung,
	--nur NHS Sachsen:
titel , 
bund_bvl_stelle , 
hhv  , 
kategorie_gruppe,
vzae_besetzung_beamt,
vzae_besetzung_besch,
vzae_besetzung_uw,
--Ende Sachsen
	summe,
bvl_stelle_kurz,
kapitel,
adbz_land
FROM kenn_sgd_aggr
where stichtag in
(SELECT stichtag FROM kenn_stichtag where stichtagsart_id='STLI' and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_sgd_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_sgd_aggr >>$ERR  2>&1   

unload to "unl/kenn_sgd_aggr.unl" 

			SELECT 
hs_nr,
bund_fachgebiet,
bund_dienstart,
faktor,
buadbz,
besetzung,
vzae_besetzung,
koepfe_besetzung,
buadbz_besetzung,
da_besetzung,
taet_besetzung,
date_str(stichtag) ,
date_str(datum) ,
zaehlung,
	--nur NHS Sachsen:
titel , 
bund_bvl_stelle , 
hhv  , 
kategorie_gruppe,
vzae_besetzung_beamt,
vzae_besetzung_besch,
vzae_besetzung_uw,
--Ende Sachsen
	summe,
bvl_stelle_kurz,
kapitel,
adbz_land
FROM kenn_sgd_aggr
where stichtag in
(SELECT stichtag FROM kenn_stichtag where stichtagsart_id='STLI' and exportieren='1');
		--Ende
END_kenn_sgd_aggr
fi

fi

#
#Unload-Job kenn_stelle_hhpl
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_stelle_hhpl" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


	 
	select distinct H.kapitel,
  H.titel,
 H.hs_nr,
	       H.bvl_stelle_kurz,
	       H.adbz_land,
	       H.summe,
	       H.jahr_von,
	       H.jahr_bis,
	       H.datum
	FROM kenn_stelle_hhpl H, kenn_stichtag K
	where 
		K.bezugszeit between H.jahr_von and H.jahr_bis
		and K.bezugsart='J' 
		and K.stichtagsart_id='STHP' 
		and K.exportieren='1'
	;
	" "txt" "$DBDELIMITER" "false" "unl/kenn_stelle_hhpl.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_stelle_hhpl >>$ERR  2>&1   

unload to "unl/kenn_stelle_hhpl.unl" 

	 
	select distinct H.kapitel,
  H.titel,
 H.hs_nr,
	       H.bvl_stelle_kurz,
	       H.adbz_land,
	       H.summe,
	       H.jahr_von,
	       H.jahr_bis,
	       H.datum
	FROM kenn_stelle_hhpl H, kenn_stichtag K
	where 
		K.bezugszeit between H.jahr_von and H.jahr_bis
		and K.bezugsart='J' 
		and K.stichtagsart_id='STHP' 
		and K.exportieren='1'
	;
	--Ende
END_kenn_stelle_hhpl
fi

fi

#
#Unload-Job kenn_pbe_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_pbe_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
			select hs_nr,
       bund_fachgebiet,
       bund_dienstart,
       faktor,
       buadbz,
       buadbz_besetzung,
       da_besetzung,
       taet_besetzung,
       stichtag,
       datum,
       zaehlung,
       summe
FROM kenn_pbe_aggr
where stichtag in
(SELECT stichtag FROM kenn_stichtag where bezugsart='J' and stichtagsart_id='STLI' and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_pbe_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_pbe_aggr >>$ERR  2>&1   

unload to "unl/kenn_pbe_aggr.unl" 

			
			select hs_nr,
       bund_fachgebiet,
       bund_dienstart,
       faktor,
       buadbz,
       buadbz_besetzung,
       da_besetzung,
       taet_besetzung,
       stichtag,
       datum,
       zaehlung,
       summe
FROM kenn_pbe_aggr
where stichtag in
(SELECT stichtag FROM kenn_stichtag where bezugsart='J' and stichtagsart_id='STLI' and exportieren='1');
		--Ende
END_kenn_pbe_aggr
fi

fi

#
#Unload-Job kenn_sos_lab
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_sos_lab" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT hs_nr,
	studiengang_nr,
	fach_nr,
	geschlecht,
	ca12_staat,
	sem_der_pruefung,
	stg,
	abschluss,
	fach_sem_zahl,
	hzbart,
	kz_fach,
	regel,
	extkost,
	extkotr,
	stufrm,
	date_str(datum) ,
	summe
FROM kenn_sos_lab
where sem_der_pruefung in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='PRFI' and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_sos_lab.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_sos_lab >>$ERR  2>&1   

unload to "unl/kenn_sos_lab.unl" 

			SELECT hs_nr,
	studiengang_nr,
	fach_nr,
	geschlecht,
	ca12_staat,
	sem_der_pruefung,
	stg,
	abschluss,
	fach_sem_zahl,
	hzbart,
	kz_fach,
	regel,
	extkost,
	extkotr,
	stufrm,
	date_str(datum) ,
	summe
FROM kenn_sos_lab
where sem_der_pruefung in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='PRFI' and exportieren='1');
		--Ende
END_kenn_sos_lab
fi

fi

#
#Unload-Job kenn_sos_stg
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_sos_stg" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT 
	hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       stg,
       abschluss,
       regel,
       hzbart,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
       kz_fach,
      extkost,
       extkotr,
	stufrm,
	hrst,
 	date_str(datum) ,
	summe
 FROM kenn_sos_stg
 where sem_rueck_beur_ein in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='STDI' and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_sos_stg.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_sos_stg >>$ERR  2>&1   

unload to "unl/kenn_sos_stg.unl" 

			SELECT 
	hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       stg,
       abschluss,
       regel,
       hzbart,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
       kz_fach,
      extkost,
       extkotr,
	stufrm,
	hrst,
 	date_str(datum) ,
	summe
 FROM kenn_sos_stg
 where sem_rueck_beur_ein in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='STDI' and exportieren='1');
		--Ende
END_kenn_sos_stg
fi

fi

#
#Unload-Job kenn_stg_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_stg_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT 
	hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       stg,
       abschluss,
       regel,
       hzbart,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
       kz_fach,
       stort,
       stuart,
       stufrm,
       stg_int,
       abint,
       hzbart_astat,
       hrst,
null::char(10),--       kz_fach_int,
null::char(10),--       vertfg,
	date_str(datum) ,
--	antrnr,
	sum(summe)
 FROM kenn_stg_aggr
 where sem_rueck_beur_ein in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='STDM' and exportieren='1')
--nur FHen und sonst. HSen BaWue:
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (1,3))
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24
union
SELECT 
	hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       stg,
       abschluss,
       regel,
       hzbart,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
       kz_fach,
       stort,
       stuart,
       stufrm,
       stg_int,
       abint,
       hzbart_astat,
       hrst,
       kz_fach_int,
       vertfg,
	date_str(datum) ,
--	antrnr,
	sum(summe)
 FROM kenn_stg_aggr
 where sem_rueck_beur_ein in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='STDM' and exportieren='1')
--nur PHen BaWue:
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (2))
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24

;
		" "txt" "$DBDELIMITER" "false" "unl/kenn_stg_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_stg_aggr >>$ERR  2>&1   

unload to "unl/kenn_stg_aggr.unl" 

			SELECT 
	hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       stg,
       abschluss,
       regel,
       hzbart,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
       kz_fach,
       stort,
       stuart,
       stufrm,
       stg_int,
       abint,
       hzbart_astat,
       hrst,
null::char(10),--       kz_fach_int,
null::char(10),--       vertfg,
	date_str(datum) ,
--	antrnr,
	sum(summe)
 FROM kenn_stg_aggr
 where sem_rueck_beur_ein in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='STDM' and exportieren='1')
--nur FHen und sonst. HSen BaWue:
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (1,3))
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24
union
SELECT 
	hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       stg,
       abschluss,
       regel,
       hzbart,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
       kz_fach,
       stort,
       stuart,
       stufrm,
       stg_int,
       abint,
       hzbart_astat,
       hrst,
       kz_fach_int,
       vertfg,
	date_str(datum) ,
--	antrnr,
	sum(summe)
 FROM kenn_stg_aggr
 where sem_rueck_beur_ein in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='STDM' and exportieren='1')
--nur PHen BaWue:
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (2))
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24

;
		--Ende
END_kenn_stg_aggr
fi

fi

#
#Unload-Job kenn_stug
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_stug" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT hs_nr,
	stug_key,
	date_str(stug_von) ,
	stug_fach,
	stug_abschl,
	stug_dbez,
	stug_rstuz,
	stug_cnw,
	date_str(stug_bis),
	key_lehreinh,
	stug_plaetze,
	k_extkotr
 FROM kenn_stug
 where 0 < (SELECT count(*) 
 FROM kenn_stichtag where stichtagsart_id='STDG'
 and exportieren='1')
 ;
 
		" "txt" "$DBDELIMITER" "false" "unl/kenn_stug.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_stug >>$ERR  2>&1   

unload to "unl/kenn_stug.unl" 

			SELECT hs_nr,
	stug_key,
	date_str(stug_von) ,
	stug_fach,
	stug_abschl,
	stug_dbez,
	stug_rstuz,
	stug_cnw,
	date_str(stug_bis),
	key_lehreinh,
	stug_plaetze,
	k_extkotr
 FROM kenn_stug
 where 0 < (SELECT count(*) 
 FROM kenn_stichtag where stichtagsart_id='STDG'
 and exportieren='1')
 ;
 
		--Ende
END_kenn_stug
fi

fi

#
#Unload-Job kenn_vtbu_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_vtbu_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT hs_nr,
	jahr,
	quartal,
	monat,
	quell_ch110_inst,
	vari,
	quell_stug,
	quell_projnr,
	ziel_projnr,
	ziel_stug,
	ziel_fikrkey,
	ziel_ch110_inst,
	kokl,
	klr_geldgeber,
	date_str(datum) ,
	betrag
 FROM kenn_vtbu_aggr
  where (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KOTN'
 and exportieren='1')
 or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='KOTN'
 and exportieren='1'));
 
		" "txt" "$DBDELIMITER" "false" "unl/kenn_vtbu_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_vtbu_aggr >>$ERR  2>&1   

unload to "unl/kenn_vtbu_aggr.unl" 

			SELECT hs_nr,
	jahr,
	quartal,
	monat,
	quell_ch110_inst,
	vari,
	quell_stug,
	quell_projnr,
	ziel_projnr,
	ziel_stug,
	ziel_fikrkey,
	ziel_ch110_inst,
	kokl,
	klr_geldgeber,
	date_str(datum) ,
	betrag
 FROM kenn_vtbu_aggr
  where (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KOTN'
 and exportieren='1')
 or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='KOTN'
 and exportieren='1'));
 
		--Ende
END_kenn_vtbu_aggr
fi

fi

#
#Unload-Job kenn_vtbu_qp_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_vtbu_qp_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT hs_nr,
	jahr,
	quartal,
	monat,
	quell_ch110_inst,
	--vari,
	--quell_stug,
	ziel_projnr,
	--ziel_stug,
	--ziel_fikrkey,
	--ziel_ch110_inst,
	kokl,
	--klr_geldgeber,
	date_str(datum) ,
	betrag
 FROM kenn_vtbu_qp_aggr
  where  (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KOTN_QP'
 and exportieren='1')
 or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='KOTN_QP'
 and exportieren='1'));
 
		" "txt" "$DBDELIMITER" "false" "unl/kenn_vtbu_qp_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_vtbu_qp_aggr >>$ERR  2>&1   

unload to "unl/kenn_vtbu_qp_aggr.unl" 

			SELECT hs_nr,
	jahr,
	quartal,
	monat,
	quell_ch110_inst,
	--vari,
	--quell_stug,
	ziel_projnr,
	--ziel_stug,
	--ziel_fikrkey,
	--ziel_ch110_inst,
	kokl,
	--klr_geldgeber,
	date_str(datum) ,
	betrag
 FROM kenn_vtbu_qp_aggr
  where  (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KOTN_QP'
 and exportieren='1')
 or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='KOTN_QP'
 and exportieren='1'));
 
		--Ende
END_kenn_vtbu_qp_aggr
fi

fi

#
#Unload-Job kenn_su_imp_stud
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_su_imp_stud" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT hs_nr,
       lehreinheit,
       k_extkotr,
       sem,
       stgnr,
       fsemnr,
       fachkey,
       fachkeydbez,
       abslkey,
       abslkeydbez,
       kzfach,
       stufrm,
       stufrmdbez,
       kzfachdbez,
       ffstgnr,
       gruppierung,
       ffgewicht,
       stugkey,
       vza,
       ffges,
       ffidr,
       ff1_4,
       ffidrgfs,
       ff1_4gfs,
       ffidrgf2,
       ff1_4gf2,
       kpfges,
       kpfidr,
       kpf1_4,
       date_str(datum) 
FROM kenn_su_imp_stud
where sem in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='STDG' and exportieren='1');


		" "txt" "$DBDELIMITER" "false" "unl/kenn_su_imp_stud.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_su_imp_stud >>$ERR  2>&1   

unload to "unl/kenn_su_imp_stud.unl" 

			SELECT hs_nr,
       lehreinheit,
       k_extkotr,
       sem,
       stgnr,
       fsemnr,
       fachkey,
       fachkeydbez,
       abslkey,
       abslkeydbez,
       kzfach,
       stufrm,
       stufrmdbez,
       kzfachdbez,
       ffstgnr,
       gruppierung,
       ffgewicht,
       stugkey,
       vza,
       ffges,
       ffidr,
       ff1_4,
       ffidrgfs,
       ff1_4gfs,
       ffidrgf2,
       ff1_4gf2,
       kpfges,
       kpfidr,
       kpf1_4,
       date_str(datum) 
FROM kenn_su_imp_stud
where sem in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='STDG' and exportieren='1');


		--Ende
END_kenn_su_imp_stud
fi

fi

#
#Unload-Job kenn_konto_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_konto_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			 select hs_nr,
       jahr,
       quartal,
       monat,
       kapitel,
       titel,
       dr, -- (nur gefllt wenn Konstante KENN_PROFIL=5)
       extkost,
       extkotr,
       fikrkey,
       klr_geldgeber,
       betragsart,
       bund_fachgebiet,
       date_str(datum) ,
       betrag,
       kfmkam
FROM kenn_konto_aggr
   where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='HASL'
 and exportieren='1')
or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='HASL'
 and exportieren='1');


		" "txt" "$DBDELIMITER" "false" "unl/kenn_konto_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_konto_aggr >>$ERR  2>&1   

unload to "unl/kenn_konto_aggr.unl" 

			 select hs_nr,
       jahr,
       quartal,
       monat,
       kapitel,
       titel,
       dr, -- (nur gefllt wenn Konstante KENN_PROFIL=5)
       extkost,
       extkotr,
       fikrkey,
       klr_geldgeber,
       betragsart,
       bund_fachgebiet,
       date_str(datum) ,
       betrag,
       kfmkam
FROM kenn_konto_aggr
   where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='HASL'
 and exportieren='1')
or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='HASL'
 and exportieren='1');


		--Ende
END_kenn_konto_aggr
fi

fi

#
#Unload-Job kenn_drittm_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_drittm_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			 select hs_nr,
       jahr,
       betragsart,
       kfmkam,
       syf,
       fgr,
       datum,
       betrag
FROM kenn_drittm_aggr
   where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='HADM'
 and exportieren='1')
;


		" "txt" "$DBDELIMITER" "false" "unl/kenn_drittm_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_drittm_aggr >>$ERR  2>&1   

unload to "unl/kenn_drittm_aggr.unl" 

			 select hs_nr,
       jahr,
       betragsart,
       kfmkam,
       syf,
       fgr,
       datum,
       betrag
FROM kenn_drittm_aggr
   where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='HADM'
 and exportieren='1')
;


		--Ende
END_kenn_drittm_aggr
fi

fi

#
#Unload-Job kenn_anlagen_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_anlagen_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			 SELECT hs_nr,
       jahr,
       inst_ext,
       bund_fachgebiet,
       asp_akl,
       extkotr,
       rest,
       rest_vj,
       zugang,
       abgang,
       abschr,
       histor_ahk,
       umbuch,
       zuschr,
       abschr_ges,
       datum
FROM kenn_anlagen_aggr
   where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='ANLAGEN'
 and exportieren='1')
;


		" "txt" "$DBDELIMITER" "false" "unl/kenn_anlagen_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_anlagen_aggr >>$ERR  2>&1   

unload to "unl/kenn_anlagen_aggr.unl" 

			 SELECT hs_nr,
       jahr,
       inst_ext,
       bund_fachgebiet,
       asp_akl,
       extkotr,
       rest,
       rest_vj,
       zugang,
       abgang,
       abschr,
       histor_ahk,
       umbuch,
       zuschr,
       abschr_ges,
       datum
FROM kenn_anlagen_aggr
   where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='ANLAGEN'
 and exportieren='1')
;


		--Ende
END_kenn_anlagen_aggr
fi

fi

#
#Unload-Job kenn_zahl_wert
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_zahl_wert" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
 SELECT tid,
       hs_nr,
       kenn_zahl,
       jahr,
       sem,
       ch110_institut,
       stugkey,
       bund_fachgebiet,
       titel,
       geschlecht,
       ca12_staat,
       wert,
       wert_str,
       generic_dim1,
       generic_dim2
FROM kenn_zahl_wert
where kenn_zahl || '_' || jahr
 in 
(SELECT S.stichtagsart_id  || '_' || S.bezugszeit 
 FROM kenn_stichtag S
 where S.bezugsart='J' 
 and exportieren='1')
 
 or kenn_zahl || '_' || sem in (SELECT S.stichtagsart_id  || '_' || S.bezugszeit 
 FROM kenn_stichtag S
 where S.bezugsart='S' 
 and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_zahl_wert.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_zahl_wert >>$ERR  2>&1   

unload to "unl/kenn_zahl_wert.unl" 

			
 SELECT tid,
       hs_nr,
       kenn_zahl,
       jahr,
       sem,
       ch110_institut,
       stugkey,
       bund_fachgebiet,
       titel,
       geschlecht,
       ca12_staat,
       wert,
       wert_str,
       generic_dim1,
       generic_dim2
FROM kenn_zahl_wert
where kenn_zahl || '_' || jahr
 in 
(SELECT S.stichtagsart_id  || '_' || S.bezugszeit 
 FROM kenn_stichtag S
 where S.bezugsart='J' 
 and exportieren='1')
 
 or kenn_zahl || '_' || sem in (SELECT S.stichtagsart_id  || '_' || S.bezugszeit 
 FROM kenn_stichtag S
 where S.bezugsart='S' 
 and exportieren='1');
		--Ende
END_kenn_zahl_wert
fi

fi

#
#Unload-Job kenn_unload
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_unload" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
SELECT count(*)::smallint
FROM kenn_stichtag
where exportieren='1';
		" "txt" "$DBDELIMITER" "false" "unl/kenn_unload.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_unload >>$ERR  2>&1   

unload to "unl/kenn_unload.unl" 

			
SELECT count(*)::smallint
FROM kenn_stichtag
where exportieren='1';
		--Ende
END_kenn_unload
fi

fi

#
#Unload-Job kenn_hs_sichten
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_hs_sichten" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
select  hs_nr, tid,
       dimension,
       dimension_lang,
       stichtag,
       alt_hier_id,
       sichtart,
       bezugszeit,
       bezugsart
FROM kenn_hs_sichten 
--where 
-- exportieren='1'
;


		" "txt" "$DBDELIMITER" "false" "unl/kenn_hs_sichten.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_hs_sichten >>$ERR  2>&1   

unload to "unl/kenn_hs_sichten.unl" 

			
select  hs_nr, tid,
       dimension,
       dimension_lang,
       stichtag,
       alt_hier_id,
       sichtart,
       bezugszeit,
       bezugsart
FROM kenn_hs_sichten 
--where 
-- exportieren='1'
;


		--Ende
END_kenn_hs_sichten
fi

fi

#
#Unload-Job kenn_alt_hier
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_alt_hier" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
select * from xdummy where 1=0;

		" "txt" "$DBDELIMITER" "false" "unl/kenn_alt_hier.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_alt_hier >>$ERR  2>&1   

unload to "unl/kenn_alt_hier.unl" 

			
select * from xdummy where 1=0;

		--Ende
END_kenn_alt_hier
fi

fi

#
#Unload-Job kenn_alt_keys
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_alt_keys" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
select hs_nr,relation,
       hierarchie_id,
       key,
       parent,
       flags
from kenn_alt_keys
where 0 < (SELECT count(*) 
 FROM kenn_stichtag where stichtagsart_id='KOTN'
 and exportieren='1')
 ;

		" "txt" "$DBDELIMITER" "false" "unl/kenn_alt_keys.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_alt_keys >>$ERR  2>&1   

unload to "unl/kenn_alt_keys.unl" 

			
select hs_nr,relation,
       hierarchie_id,
       key,
       parent,
       flags
from kenn_alt_keys
where 0 < (SELECT count(*) 
 FROM kenn_stichtag where stichtagsart_id='KOTN'
 and exportieren='1')
 ;

		--Ende
END_kenn_alt_keys
fi

fi

#
#Unload-Job kenn_inst_to_ext
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_inst_to_ext" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       instnr,
       email,
       key_ext,
       dbez_ext,
       gebnr
FROM kenn_inst_to_ext
where 0 < (SELECT count(*) 
 FROM kenn_stichtag where stichtagsart_id='KOTN'
 and exportieren='1')
 ;
     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_inst_to_ext.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_inst_to_ext >>$ERR  2>&1   

unload to "unl/kenn_inst_to_ext.unl" 

SELECT hs_nr,
       instnr,
       email,
       key_ext,
       dbez_ext,
       gebnr
FROM kenn_inst_to_ext
where 0 < (SELECT count(*) 
 FROM kenn_stichtag where stichtagsart_id='KOTN'
 and exportieren='1')
 ;
     
	--Ende
END_kenn_inst_to_ext
fi

fi

#
#Unload-Job kenn_antr_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_antr_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       bewsem,
       stg,
       abschluss,
       antrnr,
       fach_sem_zahl,
       stort,
       stg_int,
       abint,
       hzbart,
       zul_kz,
       date_str(datum) ,
       einschreib_kz,
       summe,
       stg_land
FROM kenn_antr_aggr
where bewsem in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='BEW' and exportieren='1')
;

     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_antr_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_antr_aggr >>$ERR  2>&1   

unload to "unl/kenn_antr_aggr.unl" 

SELECT hs_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       bewsem,
       stg,
       abschluss,
       antrnr,
       fach_sem_zahl,
       stort,
       stg_int,
       abint,
       hzbart,
       zul_kz,
       date_str(datum) ,
       einschreib_kz,
       summe,
       stg_land
FROM kenn_antr_aggr
where bewsem in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='BEW' and exportieren='1')
;

     
	--Ende
END_kenn_antr_aggr
fi

fi

#
#Unload-Job kenn_antr_prozess_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_antr_prozess_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       fach_nr,
       geschlecht,
       bewsem,
       stg,
       stg_land,
       abschlusstyp,
       antrnr,
       fach_sem_zahl_1,
       antrag_status,
       aufbaustudium,
       datum,
       summe
FROM kenn_antr_prozess_aggr 
where bewsem in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='BEW' and exportieren='1')
;

     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_antr_prozess_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_antr_prozess_aggr >>$ERR  2>&1   

unload to "unl/kenn_antr_prozess_aggr.unl" 

SELECT hs_nr,
       fach_nr,
       geschlecht,
       bewsem,
       stg,
       stg_land,
       abschlusstyp,
       antrnr,
       fach_sem_zahl_1,
       antrag_status,
       aufbaustudium,
       datum,
       summe
FROM kenn_antr_prozess_aggr 
where bewsem in
(SELECT bezugszeit FROM kenn_stichtag where bezugsart='S' and stichtagsart_id='BEW' and exportieren='1')
;

     
	--Ende
END_kenn_antr_prozess_aggr
fi

fi

#
#Unload-Job kenn_stg_int
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_stg_int" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       apnr,
       druck,
       astat,
       abint,
       datum
FROM kenn_stg_int
where 0 <
(SELECT count(*) FROM kenn_stichtag where bezugsart='S' and stichtagsart_id in ('BEW','STDM') and exportieren='1')
;

     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_stg_int.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_stg_int >>$ERR  2>&1   

unload to "unl/kenn_stg_int.unl" 

SELECT hs_nr,
       apnr,
       druck,
       astat,
       abint,
       datum
FROM kenn_stg_int
where 0 <
(SELECT count(*) FROM kenn_stichtag where bezugsart='S' and stichtagsart_id in ('BEW','STDM') and exportieren='1')
;

     
	--Ende
END_kenn_stg_int
fi

fi

#
#Unload-Job kenn_abint
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_abint" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       apnr,
       druck,
       astat,
       datum
FROM kenn_abint
where 0 <
(SELECT count(*) FROM kenn_stichtag where bezugsart='S' and stichtagsart_id in ('BEW','STDM') and exportieren='1')


     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_abint.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_abint >>$ERR  2>&1   

unload to "unl/kenn_abint.unl" 

SELECT hs_nr,
       apnr,
       druck,
       astat,
       datum
FROM kenn_abint
where 0 <
(SELECT count(*) FROM kenn_stichtag where bezugsart='S' and stichtagsart_id in ('BEW','STDM') and exportieren='1')


     
	--Ende
END_kenn_abint
fi

fi

#
#Unload-Job kenn_kzfach_int
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_kzfach_int" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       apnr,
       druck,
       datum
FROM kenn_kzfach_int
where 0 <
(SELECT count(*) FROM kenn_stichtag where bezugsart='S' and stichtagsart_id in ('BEW','STDM') and exportieren='1')
--nur PHen BaWue
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (2))
;

     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_kzfach_int.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_kzfach_int >>$ERR  2>&1   

unload to "unl/kenn_kzfach_int.unl" 

SELECT hs_nr,
       apnr,
       druck,
       datum
FROM kenn_kzfach_int
where 0 <
(SELECT count(*) FROM kenn_stichtag where bezugsart='S' and stichtagsart_id in ('BEW','STDM') and exportieren='1')
--nur PHen BaWue
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (2))
;

     
	--Ende
END_kenn_kzfach_int
fi

fi

#
#Unload-Job kenn_vert_int
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_vert_int" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       apnr,
       druck,
       datum
FROM kenn_vert_int
where 0 <
(SELECT count(*) FROM kenn_stichtag where bezugsart='S' and stichtagsart_id in ('BEW','STDM') and exportieren='1')
--nur PHen BaWue
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (2))
;

     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_vert_int.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_vert_int >>$ERR  2>&1   

unload to "unl/kenn_vert_int.unl" 

SELECT hs_nr,
       apnr,
       druck,
       datum
FROM kenn_vert_int
where 0 <
(SELECT count(*) FROM kenn_stichtag where bezugsart='S' and stichtagsart_id in ('BEW','STDM') and exportieren='1')
--nur PHen BaWue
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (2))
;

     
	--Ende
END_kenn_vert_int
fi

fi

#
#Unload-Job kenn_dr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_dr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


select * from kenn_dr 
where (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='HASL'
 and exportieren='1')
or jahr in (SELECT val(substring('' || bezugszeit from 1 for 4))
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='HASL'
 and exportieren='1'))
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))

	" "txt" "$DBDELIMITER" "false" "unl/kenn_dr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_dr >>$ERR  2>&1   

unload to "unl/kenn_dr.unl" 

select * from kenn_dr 
where (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='HASL'
 and exportieren='1')
or jahr in (SELECT val(substring('' || bezugszeit from 1 for 4))
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='HASL'
 and exportieren='1'))
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))

	--Ende
END_kenn_dr
fi

fi

#
#Unload-Job kenn_titel
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_titel" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


select * from kenn_titel 
where (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='HASL'
 and exportieren='1')
or jahr in (SELECT val(substring('' || bezugszeit from 1 for 4))
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='HASL'
 and exportieren='1'))
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_titel.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_titel >>$ERR  2>&1   

unload to "unl/kenn_titel.unl" 

select * from kenn_titel 
where (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='HASL'
 and exportieren='1')
or jahr in (SELECT val(substring('' || bezugszeit from 1 for 4))
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='HASL'
 and exportieren='1'))
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	--Ende
END_kenn_titel
fi

fi

#
#Unload-Job kenn_pbv_klr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_pbv_klr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


select hs_nr,
       jahr,
       monat,
       kapitel,
       titel,
       kostenart,
       kalk_kostenart,
       bund_dienstart,
       buadbz,
       klr_geldgeber,
       extkost,
       extkotr,
       stichtag,
       zaehlung,
       datum,
       summe
FROM kenn_pbv_klr
where year(stichtag) in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='PEKLR'
 and exportieren='1')
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_pbv_klr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_pbv_klr >>$ERR  2>&1   

unload to "unl/kenn_pbv_klr.unl" 

select hs_nr,
       jahr,
       monat,
       kapitel,
       titel,
       kostenart,
       kalk_kostenart,
       bund_dienstart,
       buadbz,
       klr_geldgeber,
       extkost,
       extkotr,
       stichtag,
       zaehlung,
       datum,
       summe
FROM kenn_pbv_klr
where year(stichtag) in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='PEKLR'
 and exportieren='1')
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	--Ende
END_kenn_pbv_klr
fi

fi

#
#Unload-Job kenn_auslastung
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_auslastung" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       lehreinheit,
       k_extkotr,
       sem,
       datum,
       ffidrgf2,
       sws_lehrang,
       sws_lehrnf,
       sws_lehrnf_eigen,
       sws_lehrnf_fremd,
       sws_lehrnf_ea,
       dlk
FROM kenn_auslastung
where sem in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='S' 
 and stichtagsart_id='STDG'
 and exportieren='1')
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_auslastung.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_auslastung >>$ERR  2>&1   

unload to "unl/kenn_auslastung.unl" 

SELECT hs_nr,
       lehreinheit,
       k_extkotr,
       sem,
       datum,
       ffidrgf2,
       sws_lehrang,
       sws_lehrnf,
       sws_lehrnf_eigen,
       sws_lehrnf_fremd,
       sws_lehrnf_ea,
       dlk
FROM kenn_auslastung
where sem in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='S' 
 and stichtagsart_id='STDG'
 and exportieren='1')
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	--Ende
END_kenn_auslastung
fi

fi

#
#Unload-Job kenn_fibu_bilanz
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_fibu_bilanz" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       jahr,
       name,
       hierarchie_ebene,
       betrag,
       betragvorjahr,
       unterstrich,
       sortnr,
       sortnr2,
       datum
FROM kenn_fibu_bilanz
where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='Bilanz'
 and exportieren='1')
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_fibu_bilanz.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_fibu_bilanz >>$ERR  2>&1   

unload to "unl/kenn_fibu_bilanz.unl" 

SELECT hs_nr,
       jahr,
       name,
       hierarchie_ebene,
       betrag,
       betragvorjahr,
       unterstrich,
       sortnr,
       sortnr2,
       datum
FROM kenn_fibu_bilanz
where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='Bilanz'
 and exportieren='1')
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	--Ende
END_kenn_fibu_bilanz
fi

fi

#
#Unload-Job kenn_fibu_guv
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_fibu_guv" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       jahr,
       name,
       hierarchie_ebene,
       betrag,
       betragvorjahr,
       unterstrich,
       sortnr,
       sortnr2,
       datum
FROM kenn_fibu_guv
where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='GuV'
 and exportieren='1')
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_fibu_guv.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_fibu_guv >>$ERR  2>&1   

unload to "unl/kenn_fibu_guv.unl" 

SELECT hs_nr,
       jahr,
       name,
       hierarchie_ebene,
       betrag,
       betragvorjahr,
       unterstrich,
       sortnr,
       sortnr2,
       datum
FROM kenn_fibu_guv
where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='GuV'
 and exportieren='1')
--nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	--Ende
END_kenn_fibu_guv
fi

fi

#
#Unload-Job kenn_fibu_quartal
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_fibu_quartal" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       id,
       jahr,
       quartal,
       zeile,
       kontengruppe,
       name,
       hierarchie_ebene,
       plan,
       q1,
       q2,
       q3,
       q4,
       steuerungvorschau,
       steuerungvorjahr,
       erlaeuterung,
       sortnr,
       sortnr2,
       zeilennr,
       vorjahr_q1,
       vorjahr_q2,
       vorjahr_q3,
       vorjahr_q4,
       datum
FROM kenn_fibu_quartal
where (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='GuVQ'
 and exportieren='1')
 or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='GuVQ'
 and exportieren='1')
 )
 --nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_fibu_quartal.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_fibu_quartal >>$ERR  2>&1   

unload to "unl/kenn_fibu_quartal.unl" 

SELECT hs_nr,
       id,
       jahr,
       quartal,
       zeile,
       kontengruppe,
       name,
       hierarchie_ebene,
       plan,
       q1,
       q2,
       q3,
       q4,
       steuerungvorschau,
       steuerungvorjahr,
       erlaeuterung,
       sortnr,
       sortnr2,
       zeilennr,
       vorjahr_q1,
       vorjahr_q2,
       vorjahr_q3,
       vorjahr_q4,
       datum
FROM kenn_fibu_quartal
where (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='GuVQ'
 and exportieren='1')
 or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='GuVQ'
 and exportieren='1')
 )
 --nur Hochschulen Sachsen
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	--Ende
END_kenn_fibu_quartal
fi

fi

#
#Unload-Job kenn_kam_quartal
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_kam_quartal" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


	select hs_nr,
       jahr,
       quartal,
       dr,
       titel,
       soll,
       reste,
       haushaltsvorgriff,
       istq1,
       istq2,
       istq3,
       istq4,
       istvorjahr_q1,
       istvorjahr_q2,
       istvorjahr_q3,
       istvorjahr_q4,
       vorschau,
       erlaeuterung,
       datum
FROM kenn_kam_quartal 
where (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KAM_QB'
 and exportieren='1')
 or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='KAM_QB'
 and exportieren='1')
 )
     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_kam_quartal.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_kam_quartal >>$ERR  2>&1   

unload to "unl/kenn_kam_quartal.unl" 

	select hs_nr,
       jahr,
       quartal,
       dr,
       titel,
       soll,
       reste,
       haushaltsvorgriff,
       istq1,
       istq2,
       istq3,
       istq4,
       istvorjahr_q1,
       istvorjahr_q2,
       istvorjahr_q3,
       istvorjahr_q4,
       vorschau,
       erlaeuterung,
       datum
FROM kenn_kam_quartal 
where (jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KAM_QB'
 and exportieren='1')
 or quartal in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='Q' 
 and stichtagsart_id='KAM_QB'
 and exportieren='1')
 )
     
	--Ende
END_kenn_kam_quartal
fi

fi

#
#Unload-Job kenn_kam_ja
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_kam_ja" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


	select hs_nr,
       jahr,
       dr,
       titel,
       soll,
       reste,
       haushaltsvorgriff,
       ist,
       erlaeuterung,
       datum
FROM kenn_kam_ja 
where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KAM_JA'
 and exportieren='1')
 
     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_kam_ja.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_kam_ja >>$ERR  2>&1   

unload to "unl/kenn_kam_ja.unl" 

	select hs_nr,
       jahr,
       dr,
       titel,
       soll,
       reste,
       haushaltsvorgriff,
       ist,
       erlaeuterung,
       datum
FROM kenn_kam_ja 
where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KAM_JA'
 and exportieren='1')
 
     
	--Ende
END_kenn_kam_ja
fi

fi

#
#Unload-Job kenn_fibu_wiplan
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_fibu_wiplan" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       id,
       jahr,
       kuerzel,
       kontengruppe,
       zweckbestimmung,
       ist,
       sollplus1,
       sollplus2,
       sollplus3,
       sortnr,
       datum
FROM kenn_fibu_wiplan
where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KWIPL'
 and exportieren='1')
--nicht mehr Hochschulen Sachsen
and 0 = (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_fibu_wiplan.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_fibu_wiplan >>$ERR  2>&1   

unload to "unl/kenn_fibu_wiplan.unl" 

SELECT hs_nr,
       id,
       jahr,
       kuerzel,
       kontengruppe,
       zweckbestimmung,
       ist,
       sollplus1,
       sollplus2,
       sollplus3,
       sortnr,
       datum
FROM kenn_fibu_wiplan
where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='KWIPL'
 and exportieren='1')
--nicht mehr Hochschulen Sachsen
and 0 = (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
     
	--Ende
END_kenn_fibu_wiplan
fi

fi

#
#Unload-Job kenn_stupl
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_stupl" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       stug_key,
       stug_rstuz,
       jahr,
       sem,
       extkotr,
       datum,
       summe
FROM kenn_stupl
where sem in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='S' 
 and stichtagsart_id='STPLKLR'
 and exportieren='1')

     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_stupl.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_stupl >>$ERR  2>&1   

unload to "unl/kenn_stupl.unl" 

SELECT hs_nr,
       stug_key,
       stug_rstuz,
       jahr,
       sem,
       extkotr,
       datum,
       summe
FROM kenn_stupl
where sem in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='S' 
 and stichtagsart_id='STPLKLR'
 and exportieren='1')

     
	--Ende
END_kenn_stupl
fi

fi

#
#Unload-Job kenn_promo_aggr
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_promo_aggr" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT hs_nr,
       jahr,
       jahr_beginn,
       jahr_ende,
       monat_beginn,
       monat_ende,
       jahr_beginn_bezug,
       jahr_ende_bezug,
       art_ende,
       koop_land_ausl,
       geschlecht,
       extkotr,
       datum,
       summe,
       dauer_jahre
FROM kenn_promo_aggr 
 
where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='PROM'
 and exportieren='1')

     
	" "txt" "$DBDELIMITER" "false" "unl/kenn_promo_aggr.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_promo_aggr >>$ERR  2>&1   

unload to "unl/kenn_promo_aggr.unl" 

SELECT hs_nr,
       jahr,
       jahr_beginn,
       jahr_ende,
       monat_beginn,
       monat_ende,
       jahr_beginn_bezug,
       jahr_ende_bezug,
       art_ende,
       koop_land_ausl,
       geschlecht,
       extkotr,
       datum,
       summe,
       dauer_jahre
FROM kenn_promo_aggr 
 
where jahr in (SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='PROM'
 and exportieren='1')

     
	--Ende
END_kenn_promo_aggr
fi

fi

#
#Unload-Job kenn_stg_aggr_astat
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_stg_aggr_astat" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       stg,
       abschluss,
       fgr,
       abgrp,
       regel,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
       stort,
       stuart,
       stufrm,
       hzbart_astat,
       hzbkfzkz,
       hrst,
       letzte_pruefung_stort,
       letzte_pruefung_staat,
       letzte_pruefung_abschluss,
       letzte_pruefung_ergebnis,
       vorletzte_pruefung_stort,
       vorletzte_pruefung_staat,
       vorletzte_pruefung_abschluss,
       vorletzte_pruefung_ergebnis,
       datum,
       summe,
       stg_land
       from kenn_stg_aggr_astat
where sem_rueck_beur_ein in
(SELECT bezugszeit FROM kenn_stichtag 
where bezugsart='S' 
and stichtagsart_id='STDA' 
and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_stg_aggr_astat.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_stg_aggr_astat >>$ERR  2>&1   

unload to "unl/kenn_stg_aggr_astat.unl" 

			SELECT hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       stg,
       abschluss,
       fgr,
       abgrp,
       regel,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
       stort,
       stuart,
       stufrm,
       hzbart_astat,
       hzbkfzkz,
       hrst,
       letzte_pruefung_stort,
       letzte_pruefung_staat,
       letzte_pruefung_abschluss,
       letzte_pruefung_ergebnis,
       vorletzte_pruefung_stort,
       vorletzte_pruefung_staat,
       vorletzte_pruefung_abschluss,
       vorletzte_pruefung_ergebnis,
       datum,
       summe,
       stg_land
       from kenn_stg_aggr_astat
where sem_rueck_beur_ein in
(SELECT bezugszeit FROM kenn_stichtag 
where bezugsart='S' 
and stichtagsart_id='STDA' 
and exportieren='1');
		--Ende
END_kenn_stg_aggr_astat
fi

fi

#
#Unload-Job kenn_stud_aggr_astat
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_stud_aggr_astat" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT hs_nr,
	studiengang_nr,
       fach_nr,
       geschlecht,
       bildungstyp,
       sem_rueck_beur_ein,
       stg,
       stg_land,
       abschlusstyp,
       regel,
       fach_sem_zahl,
       hssem_1,
       aufbaustudium,
       datum,
       hrst,
       summe
FROM kenn_stud_aggr_astat 
where sem_rueck_beur_ein in
(SELECT bezugszeit FROM kenn_stichtag 
where bezugsart='S' 
and stichtagsart_id='STDA' 
and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_stud_aggr_astat.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_stud_aggr_astat >>$ERR  2>&1   

unload to "unl/kenn_stud_aggr_astat.unl" 

			SELECT hs_nr,
	studiengang_nr,
       fach_nr,
       geschlecht,
       bildungstyp,
       sem_rueck_beur_ein,
       stg,
       stg_land,
       abschlusstyp,
       regel,
       fach_sem_zahl,
       hssem_1,
       aufbaustudium,
       datum,
       hrst,
       summe
FROM kenn_stud_aggr_astat 
where sem_rueck_beur_ein in
(SELECT bezugszeit FROM kenn_stichtag 
where bezugsart='S' 
and stichtagsart_id='STDA' 
and exportieren='1');
		--Ende
END_kenn_stud_aggr_astat
fi

fi

#
#Unload-Job kenn_lab_aggr_astat
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_lab_aggr_astat" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			SELECT  hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_der_pruefung,
       stg,
       abschluss,
       fgr,
       abgrp,
       regel,
       fach_sem_zahl,
       hzbart_astat,
       hzbkfzkz,
       stort,
       stufrm,
       pruefung_monat,
       pruefung_jahr,
       pruefung_ergebnis,
       ausland,
       datum,
       summe,
       stg_land
       from kenn_lab_aggr_astat
where sem_der_pruefung in
(SELECT bezugszeit FROM kenn_stichtag 
where bezugsart='S' 
and stichtagsart_id='PRFA' 
and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_lab_aggr_astat.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_lab_aggr_astat >>$ERR  2>&1   

unload to "unl/kenn_lab_aggr_astat.unl" 

			SELECT  hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_der_pruefung,
       stg,
       abschluss,
       fgr,
       abgrp,
       regel,
       fach_sem_zahl,
       hzbart_astat,
       hzbkfzkz,
       stort,
       stufrm,
       pruefung_monat,
       pruefung_jahr,
       pruefung_ergebnis,
       ausland,
       datum,
       summe,
       stg_land
       from kenn_lab_aggr_astat
where sem_der_pruefung in
(SELECT bezugszeit FROM kenn_stichtag 
where bezugsart='S' 
and stichtagsart_id='PRFA' 
and exportieren='1');
		--Ende
END_kenn_lab_aggr_astat
fi

fi

#
#Unload-Job kenn_absolv_aggr_astat
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_absolv_aggr_astat" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			select hs_nr,
       fach_nr,
       geschlecht,
       bildungstyp,
       sem_der_pruefung,
       stg,
       stg_land,
       abschlusstyp,
       regel,
       fach_sem_zahl,
       aufbaustudium,
       datum,
       summe
FROM kenn_absolv_aggr_astat 
where sem_der_pruefung in
(SELECT bezugszeit FROM kenn_stichtag 
where bezugsart='S' 
and stichtagsart_id='PRFA' 
and exportieren='1');
		" "txt" "$DBDELIMITER" "false" "unl/kenn_absolv_aggr_astat.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_absolv_aggr_astat >>$ERR  2>&1   

unload to "unl/kenn_absolv_aggr_astat.unl" 

			select hs_nr,
       fach_nr,
       geschlecht,
       bildungstyp,
       sem_der_pruefung,
       stg,
       stg_land,
       abschlusstyp,
       regel,
       fach_sem_zahl,
       aufbaustudium,
       datum,
       summe
FROM kenn_absolv_aggr_astat 
where sem_der_pruefung in
(SELECT bezugszeit FROM kenn_stichtag 
where bezugsart='S' 
and stichtagsart_id='PRFA' 
and exportieren='1');
		--Ende
END_kenn_absolv_aggr_astat
fi

fi

#
#Unload-Job kenn_rpt_ansprech
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_rpt_ansprech" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


SELECT  report_id,
hs_nr,
     name,
     vorname,
     email,
     telefon
       from kenn_rpt_ansprech
       --nur Hochschulen Sachsen
where 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
and exportieren='1'
       ;
       
		" "txt" "$DBDELIMITER" "false" "unl/kenn_rpt_ansprech.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_rpt_ansprech >>$ERR  2>&1   

unload to "unl/kenn_rpt_ansprech.unl" 

SELECT  report_id,
hs_nr,
     name,
     vorname,
     email,
     telefon
       from kenn_rpt_ansprech
       --nur Hochschulen Sachsen
where 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (5))
and exportieren='1'
       ;
       
		--Ende
END_kenn_rpt_ansprech
fi

fi

#
#Unload-Job kenn_unload_version
#
echo "--------------------------------------------------------------" >>$ERR
echo "Unload-Job: kenn_unload_version" >>$ERR


if [ "$SX_CLIENT" = "psql" ]
then
echo "Unload with jdbc for Postgres" >>$ERR  2>&1 


if [ "$SOURCESYSTEM" = "eduetl" ]
then



java $LOCALE $JAVA_OPTS -cp $CP de.superx.bin.Doquery $LOGGER_PROPERTIES $DB_PROPERTIES "

$JDBC_PARAM


			
SELECT        version,
       today()
FROM db_version
where his_system='kenn' ;

		" "txt" "$DBDELIMITER" "false" "unl/superx_unload_version.unl" >>$ERR 2>&1

fi 

fi

if [ "$SX_CLIENT" = "dbaccess" ]
then
echo "Unload with dbaccess" >>$ERR  2>&1 

#Unload sql-Statement

if [ "$SOURCESYSTEM" = "eduetl" ]
then
$INFORMIXDIR/bin/dbaccess $DBASE - <<END_kenn_unload_version >>$ERR  2>&1   

unload to "unl/superx_unload_version.unl" 

			
SELECT        version,
       today()
FROM db_version
where his_system='kenn' ;

		--Ende
END_kenn_unload_version
fi

fi

#Nachbearbeitung der unl-Dateien:
#Zumchst maskierte "\ " entfernen, Postgres kommt damit nicht klar
sed '/\\ /s///g' unl/kenn_version.unl >tmp.unl   
mv tmp.unl unl/kenn_version.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_busa_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_busa_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_fikr.unl >tmp.unl   
mv tmp.unl unl/kenn_fikr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_proj_gege.unl >tmp.unl   
mv tmp.unl unl/kenn_proj_gege.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_flaeche.unl >tmp.unl   
mv tmp.unl unl/kenn_flaeche.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_inst.unl >tmp.unl   
mv tmp.unl unl/kenn_inst.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_pbv_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_pbv_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_pbv_aggr_astat.unl >tmp.unl   
mv tmp.unl unl/kenn_pbv_aggr_astat.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_semester.unl >tmp.unl   
mv tmp.unl unl/kenn_semester.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/hochschulinfo.unl >tmp.unl   
mv tmp.unl unl/hochschulinfo.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_sgd_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_sgd_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_stelle_hhpl.unl >tmp.unl   
mv tmp.unl unl/kenn_stelle_hhpl.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_pbe_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_pbe_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_sos_lab.unl >tmp.unl   
mv tmp.unl unl/kenn_sos_lab.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_sos_stg.unl >tmp.unl   
mv tmp.unl unl/kenn_sos_stg.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_stg_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_stg_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_stug.unl >tmp.unl   
mv tmp.unl unl/kenn_stug.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_vtbu_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_vtbu_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_vtbu_qp_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_vtbu_qp_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_su_imp_stud.unl >tmp.unl   
mv tmp.unl unl/kenn_su_imp_stud.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_konto_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_konto_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_drittm_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_drittm_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_anlagen_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_anlagen_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_zahl_wert.unl >tmp.unl   
mv tmp.unl unl/kenn_zahl_wert.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_unload.unl >tmp.unl   
mv tmp.unl unl/kenn_unload.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_hs_sichten.unl >tmp.unl   
mv tmp.unl unl/kenn_hs_sichten.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_alt_hier.unl >tmp.unl   
mv tmp.unl unl/kenn_alt_hier.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_alt_keys.unl >tmp.unl   
mv tmp.unl unl/kenn_alt_keys.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_inst_to_ext.unl >tmp.unl   
mv tmp.unl unl/kenn_inst_to_ext.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_antr_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_antr_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_antr_prozess_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_antr_prozess_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_stg_int.unl >tmp.unl   
mv tmp.unl unl/kenn_stg_int.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_abint.unl >tmp.unl   
mv tmp.unl unl/kenn_abint.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_kzfach_int.unl >tmp.unl   
mv tmp.unl unl/kenn_kzfach_int.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_vert_int.unl >tmp.unl   
mv tmp.unl unl/kenn_vert_int.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_dr.unl >tmp.unl   
mv tmp.unl unl/kenn_dr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_titel.unl >tmp.unl   
mv tmp.unl unl/kenn_titel.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_pbv_klr.unl >tmp.unl   
mv tmp.unl unl/kenn_pbv_klr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_auslastung.unl >tmp.unl   
mv tmp.unl unl/kenn_auslastung.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_fibu_bilanz.unl >tmp.unl   
mv tmp.unl unl/kenn_fibu_bilanz.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_fibu_guv.unl >tmp.unl   
mv tmp.unl unl/kenn_fibu_guv.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_fibu_quartal.unl >tmp.unl   
mv tmp.unl unl/kenn_fibu_quartal.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_kam_quartal.unl >tmp.unl   
mv tmp.unl unl/kenn_kam_quartal.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_kam_ja.unl >tmp.unl   
mv tmp.unl unl/kenn_kam_ja.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_fibu_wiplan.unl >tmp.unl   
mv tmp.unl unl/kenn_fibu_wiplan.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_stupl.unl >tmp.unl   
mv tmp.unl unl/kenn_stupl.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_promo_aggr.unl >tmp.unl   
mv tmp.unl unl/kenn_promo_aggr.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_stg_aggr_astat.unl >tmp.unl   
mv tmp.unl unl/kenn_stg_aggr_astat.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_stud_aggr_astat.unl >tmp.unl   
mv tmp.unl unl/kenn_stud_aggr_astat.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_lab_aggr_astat.unl >tmp.unl   
mv tmp.unl unl/kenn_lab_aggr_astat.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_absolv_aggr_astat.unl >tmp.unl   
mv tmp.unl unl/kenn_absolv_aggr_astat.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/kenn_rpt_ansprech.unl >tmp.unl   
mv tmp.unl unl/kenn_rpt_ansprech.unl >>$ERR 2>&1 
sed '/\\ /s///g' unl/superx_unload_version.unl >tmp.unl   
mv tmp.unl unl/superx_unload_version.unl >>$ERR 2>&1 


chmod go+r $ERR
chmod go+r $SRC_PFAD/superx.datum
chmod go+r $SRC_PFAD/superx.datum.alt
chmod go+w $SRC_PFAD/superx.datum
chmod go+w $SRC_PFAD/superx.datum.alt

chmod go+r $SRC_PFAD/unl/*

##Herstellen altes Entladedatum bei Fehler
fgrep -s "not found" $ERR >/dev/null
FLAG1=$?
fgrep -i -s "nicht gefunden" $ERR >/dev/null
FLAG2=$?
fgrep -i -s "error" $ERR >/dev/null
FLAG3=$? >/dev/null
fgrep -i -s "exception" $ERR >/dev/null 
FLAG4=$? >/dev/null

if [ $FLAG1 -eq 0 -o $FLAG2 -eq 0 -o $FLAG3 -eq 0 -o $FLAG4 -eq 0 ]
then
	echo "Fehler beim Entladen. Das Datum wird zurckgesetzt." 
	echo "---------------------------------------" 
	echo "Prfen Sie Fehlerprotokoll: $ERR" 
	echo "---------------------------------------" 
	cp $SRC_PFAD/superx.datum.alt $SRC_PFAD/superx.datum 
fi
