#!/bin/bash
#Copy Script for SuperX.
. ./KENN_ENV
if [ "$SRC_PFAD" = "" ]
then 
SRC_PFAD=.
fi

ERR=kenn_copy.err


#
#Unload-Job 
#
echo "--------------------------------------------------------------" >$ERR
echo "Kopiere Dateien via $COPY_METHOD von $SRC_PFAD:" >>$ERR
if [ $COPY_METHOD = "scp" ] 
then
scp $SCP_OPTS $SRC_PFAD/kenn_unload.err $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/kenn_unload.err >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_version.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_busa_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_fikr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_proj_gege.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_flaeche.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_inst.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_pbv_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_pbv_aggr_astat.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_semester.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/hochschulinfo.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_sgd_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_stelle_hhpl.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_pbe_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_sos_lab.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_sos_stg.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_stg_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_stug.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_vtbu_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_vtbu_qp_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_su_imp_stud.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_konto_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_drittm_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_anlagen_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_zahl_wert.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_unload.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_hs_sichten.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_alt_hier.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_alt_keys.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_inst_to_ext.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_antr_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_antr_prozess_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_stg_int.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_abint.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_kzfach_int.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_vert_int.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_dr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_titel.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_pbv_klr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_auslastung.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_fibu_bilanz.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_fibu_guv.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_fibu_quartal.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_kam_quartal.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_kam_ja.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_fibu_wiplan.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_stupl.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_promo_aggr.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_stg_aggr_astat.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_stud_aggr_astat.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_lab_aggr_astat.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_absolv_aggr_astat.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/kenn_rpt_ansprech.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1
scp $SCP_OPTS $SRC_PFAD/unl/superx_unload_version.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1


if [ -f $SRC_PFAD/unl/superx_unload_version.unl  ]
then
 scp $SCP_OPTS $SRC_PFAD/unl/superx_unload_version.unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR >>$ERR 2>&1
fi

fi #Ende scp
if [ $COPY_METHOD = "rsync" ] 
then
scp $SCP_OPTS  $SRC_PFAD/kenn_unload.err $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/kenn_unload.err >>$ERR 2>&1
rsync -rauvz -e ssh --delete $SRC_PFAD/unl $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR  >>$ERR 2>&1

fi
#Wenn Dateien existieren, auch Datum kopieren (z.B. im SOS-Modul)

if [ $COPY_METHOD = "rsync" -o $COPY_METHOD = "scp" ] 
then
if [ -f $SRC_PFAD/superx.datum  ]
then
 scp $SCP_OPTS $SRC_PFAD/superx.datum $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR >>$ERR 2>&1
fi
if [ -f $SRC_PFAD/superx.datum.alt  ]
then
 scp $SCP_OPTS $SRC_PFAD/superx.datum.alt $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR >>$ERR 2>&1
fi
fi

#sftp:
if [ $COPY_METHOD = "sftp" ] 
then
cd $SRC_PFAD
echo "using sftp to $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR" >>$ERR 2>&1
#zuerst Metadateien:
echo "put kenn_unload.err" >kenn_sftp_logs.txt 2>>$ERR
if [ -f $SRC_PFAD/superx.datum  ]
then
echo "put superx.datum" >>kenn_sftp_logs.txt 2>>$ERR
fi
if [ -f $SRC_PFAD/superx.datum.alt  ]
then
echo "put superx.datum.alt" >>kenn_sftp_logs.txt 2>>$ERR
fi
#sftp-Kopieren start:
#cat kenn_sftp_logs.txt >>$ERR 2>&1
sftp $SFTP_OPTS -b kenn_sftp_logs.txt $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR >>$ERR 2>&1
if [ -f $SRC_PFAD/unl/superx_unload_version.unl  ]
then
echo "put unl/superx_unload_version.unl" >kenn_sftp_version.txt 2>>$ERR
#sftp-Kopieren start:
#cat kenn_sftp_version.txt >>$ERR 2>&1
sftp $SFTP_OPTS  -b kenn_sftp_version.txt $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1

fi

#UNL-Dateien selber:
#cat kenn_sftp.txt >>$ERR 2>&1
sftp $SFTP_OPTS  -b kenn_sftp.txt $REMOTE_USER@$REMOTE_HOST:$REMOTE_DIR/unl >>$ERR 2>&1

fi


#Fehlerbehandlung
fgrep -s "not found" $ERR >/dev/null
FLAG1=$?
fgrep -i -s "nicht gefunden" $ERR >/dev/null
FLAG2=$?
fgrep -i -s "error" $ERR >/dev/null
FLAG3=$? >/dev/null
if [ $FLAG1 -eq 0 -o $FLAG2 -eq 0 -o $FLAG3 -eq 0 ]
then
	echo "Fehler beim Kopieren. " 
	echo "---------------------------------------" 
	echo "Prfen Sie Fehlerprotokoll: $ERR" 
	echo "---------------------------------------" 
	 
fi

