
--drop FUNCTION sp_get_rpt_sta_bezugszeit;
--Fr einen Bericht und eine Stichtagsart die zugehrigen Bezugszeiten finden

CREATE or replace FUNCTION sp_get_rpt_sta_bezugszeit(p_report_id char(10), p_stichtagsart_id char(10), p_bezugszeit_rpt int)
RETURNS TABLE(report_id char(10), stichtagsart_id  char(10), bezugsart_stichtagsart char(1), bezugszeit int, bezugszeit_str varchar(255)) AS '
DECLARE
p_bezugsart_stichtagsart	char(1);
p_bezugsart_report_stichtagsart	char(1);
BEGIN
    p_bezugsart_stichtagsart := (select S.bezugsart from kenn_stichtagsart S where S.apnr=p_stichtagsart_id);
    p_bezugsart_report_stichtagsart := (select R.bezugsart from kenn_report_fuer_stichtagsarten R where R.apnr=p_report_id);
    
    if p_bezugsart_report_stichtagsart=p_bezugsart_stichtagsart
    then 
        RETURN QUERY 
    SELECT p_report_id,
    p_stichtagsart_id, 
    p_bezugsart_stichtagsart as bezugsart_stichtagsart,
    p_bezugszeit_rpt as bezugszeit,
    p_bezugszeit_rpt::varchar(255) as bezugszeit_str
    from xdummy;
    
    end if;
    if p_bezugsart_report_stichtagsart=''J'' and p_bezugsart_stichtagsart=''S''
         then 
        RETURN QUERY 
    SELECT distinct p_report_id,
    S.apnr, 
    p_bezugsart_stichtagsart as bezugsart_stichtagsart,
    SEM.tid as bezugszeit,
SEM.druck::varchar(255) as bezugszeit_str
FROM kenn_report_stichtagsart R ,kenn_report_fuer_stichtagsarten RS, kenn_report RR, kenn_stichtagsart S, kenn_katalog K, kenn_katalog_rpt KR, kenn_semester SEM 
where RS.apnr=RR.gruppe
and KR.report_id=RR.apnr
and RS.apnr=p_report_id
and K.id=KR.katalog_id 
and R.stichtagsart_id=S.apnr
and p_stichtagsart_id=S.apnr
and S.druck=K.stichtagsart
and S.aktiv=''1''
and S.bezugsart=p_bezugsart_stichtagsart 
--and R.report_id=p_report_id
and get_akad_jahr(SEM.tid,K.bezugsart)=p_bezugszeit_rpt
and (
R.stichtagsart_id not in (''STDG'',''STDI'') 
or (
--in Sachsen wird akad. Jahr Studierende nur frs WiSe berechnet:
R.stichtagsart_id in  (''STDI'') 
and (
(K.bezugsart=''A'' and Substring('''' || SEM.tid from 5 for 1)=''2'')
or K.bezugsart=''B''
)
)
--Studierende KLR bei Kennz. Auslastung nach Prfungsjahr
or (
--Studierende KLR bei Kennz. DLK nach WiSe
R.stichtagsart_id in  (''STDG'')
and (
(K.bezugsart=''P'' and  val( Substring('''' || SEM.tid from 1 for 4))= p_bezugszeit_rpt)
or (
K.bezugsart=''A'' and Substring('''' || SEM.tid from 5 for 1)=''2''
  )
)
)
)
;
end if;
if p_bezugsart_report_stichtagsart=''Q'' and p_bezugsart_stichtagsart=''J''
         then 
        RETURN QUERY 
	SELECT p_report_id,
    p_stichtagsart_id, 
    p_bezugsart_stichtagsart as bezugsart_stichtagsart,
    val(substring('''' || p_bezugszeit_rpt from 1 for 4)) as bezugszeit,
    val(substring('''' || p_bezugszeit_rpt from 1 for 4))::varchar(255) as bezugszeit_str
    from xdummy;
end if; 
END;
' LANGUAGE plpgsql;
