--freemarker template

<#assign zeilen={"list":[
{"sortnr":0,"titel":"Ausgaben:","titel2":"","formel":""},
{"sortnr":1,"titel":"1.","titel2":"Personalausgaben","formel":"titel like '4%'"},
{"sortnr":2,"titel":"2.","titel2":"Schliche Verwaltungsausgaben","formel":"titel like '5%'"},
{"sortnr":3,"titel":"3.","titel2":"Zuweisungen und Zuschsse (ohne Investitionen)","formel":"titel like '6%'"},
{"sortnr":4,"titel":"4.","titel2":"Investitionen","formel":"titel like '8%'"},
{"sortnr":5,"titel":"5.","titel2":"Zufhrungen zur Rcklage","formel":"titel='91901'"},
{"sortnr":6,"titel":"","titel2":"Zusammen:","formel":""},
{"sortnr":7,"titel":"","titel2":"Abzglich eigene Einnahmen:","formel":""},
{"sortnr":8,"titel":"","titel2":"Mithin Zuwendungsbedarf","formel":""},
{"sortnr":9,"titel":"","titel2":"","formel":""},
{"sortnr":10,"titel":"Der Zuwendungsbedarf soll gedeckt werden durch:","titel2":"","formel":""},
{"sortnr":12,"titel":"1.","titel2":"Zuweisungen des Freistaates","formel":"titel in ('23201','33201')"},
{"sortnr":13,"titel":"2.","titel2":"Zuweisungen des Freistaates aus zentralen Anstzen","formel":"titel in ('23270','23272','36001')"},
{"sortnr":14,"titel":"3.","titel2":"Zuwendungen anderer ffentlicher Zuwendungstrger","formel":"titel in ('23152','33152','23273','23274','23131','23501','23503','26101','36002')"},
{"sortnr":15,"titel":"4.","titel2":"Zuwendungen Dritter","formel":"titel in ('28253','34253','12902','28231')"},
{"sortnr":16,"titel":"5.","titel2":"Entnahme aus der Rcklage","formel":"titel='35901'"},
{"sortnr":17,"titel":"","titel2":"Zusammen","formel":""}
]}/>

<#macro doubletype>
<#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>

create temp table tmp_erg(

sortnr integer,
titel varchar(255),
titel2 varchar(255),
soll <@doubletype/>, --Aktuelles Soll statt W Haushaltansatz 19.2.2012 - da Reste extra dargestellt werden in zwei Titel (36001,36002) entspricht das in MBS akts-reste 
ist <@doubletype/>,
abweichung  <@doubletype/>
)<@informixnolog/>
;

create temp table tmp_konto (titel char(10),akts <@doubletype/> default 0,reste <@doubletype/> default 0,ist  <@doubletype/> default 0) <@informixnolog/>;
---- statt W Hhans  S aktuelles Soll, X Ausgaben, Y Einnahmen, Z Reste 
insert into tmp_konto (titel,akts)
select titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='S'  
group by 1;
insert into tmp_konto (titel,reste)
select titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='Z'  
group by 1;

  --einnahmen/ausgaben ist
insert into tmp_konto (titel,ist)
select titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and betragsart in ('X','Y')  
group by 1;

 
 <#foreach zeile in zeilen.list>
 <#if zeile.formel="">
 insert into tmp_erg (sortnr,titel,titel2)
 values (${zeile.sortnr},'${zeile.titel}','${zeile.titel2}');
 <#else>
insert into tmp_erg (sortnr,titel,titel2,soll,ist )
select ${zeile.sortnr},'${zeile.titel}','${zeile.titel2}',sum(akts)-sum(reste),sum(ist)
from xdummy left outer join tmp_konto on (
${zeile.formel} )
group by 1,2,3;
 
 </#if>
</#foreach>
   drop table tmp_konto;

   create temp table tmp_sum(soll <@doubletype/>, ist <@doubletype/>) <@informixnolog/>;
   insert into tmp_sum (soll,ist) select sum(soll),sum(ist) from tmp_erg where sortnr<=5;
   update tmp_erg set soll=(select soll from tmp_sum),ist=(select ist from tmp_sum) where sortnr=6;
   truncate table tmp_sum;
   insert into tmp_sum (soll,ist) select sum(soll),sum(ist) from tmp_erg where sortnr=6;
   insert into tmp_sum (soll,ist) select sum(soll*-1),sum(ist*-1) from tmp_erg where sortnr=7;
   update tmp_erg set soll=(select sum(soll) from tmp_sum),ist=(select sum(ist) from tmp_sum) where sortnr=8;
   truncate table tmp_sum;
    insert into tmp_sum (soll,ist) select sum(soll),sum(ist) from tmp_erg where sortnr>=12 and sortnr<=16;
     update tmp_erg set soll=(select soll from tmp_sum),ist=(select ist from tmp_sum) where sortnr=17;
     drop table tmp_sum;
    
   update tmp_erg set abweichung=nvl(ist,0)-nvl(soll,0);
   update tmp_erg set abweichung=null where sortnr=9;
update tmp_erg set soll=null where soll=0;
update tmp_erg set ist=null where ist=0;



select titel,titel2,soll,ist,abweichung,sortnr from tmp_erg order by sortnr;
