--kameraler Quartalsbericht
--freemarker template

<sqlvars>
<sqlvar name="jahr">select year(today()) from xdummy</sqlvar>
<sqlvar name="monat">select month(today()) from xdummy</sqlvar>
</sqlvars>
<#macro doubletype>
<#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>


<#if "<<dynamisch oder fest>>"="<<dynamisch oder fest>>">


<#assign quartal_filter=4 />
/* <#assign quartal_filter= <<Auswertung bis Quartal>> /> */ 
<#assign quartal_filter="val(substring('' || quartal from 5 for 1)) <= "+quartal_filter />
--Aus dem Vorjahr bertragene Einnahme-reste  Gesamt-Soll 2011  Ist I. Quartal (31.03.2011)  Ist II. Quartal (30.06.2011)
--Ist III.Quartal (30.09.2011)  Ist IV. Quartal (31.12.2011)  Gesamt-Ist 2011 (kumulierte Quartale) 
--IST Vorjahr kumulierte Quartale)  Vorschau 2011 bis Jahresende  Abweichung zum Gesamt-Sol
create temp table tmp_erg(
einnahmen_ausgaben char(10),
sort_ea smallint, -- einnahmen ausgaben
sort_einzeltit_dr smallint default 0, -- 0 einzeltitel, 1 berschift Titelgr. , 2 drs
sort_drtit smallint default 0, --erst 0 drbez, 1 einzelne Titel, 2 dr summe 
typ char(5), --tit or dr or drsum
dr varchar(50),
titel varchar(50),
name varchar(255),
soll <@doubletype/>, --Aktuelles Soll statt W Haushaltansatz 19.2.2012 - da Reste extra dargestellt werden in zwei Titel (36001,36002) entspricht das in MBS akts-reste 
haushaltsvorgriff <@doubletype/>,
gesamtsoll  <@doubletype/>,
istq1  <@doubletype/> default 0,
istq2 <@doubletype/> default 0,
istq3  <@doubletype/> default 0,
istq4 <@doubletype/> default 0,
gesamtist <@doubletype/>,
istvorjahr  <@doubletype/>,
vorschau <@doubletype/>,
abweichung  <@doubletype/>,
erl varchar(255)
)<@informixnolog/>
;

create temp table tmp_konto (dr varchar(50),titel char(10),
akts <@doubletype/> default 0,
reste <@doubletype/> default 0,
haushaltsvorgriff <@doubletype/> default 0,
istq1  <@doubletype/> default 0,
istq2 <@doubletype/> default 0,
istq3  <@doubletype/> default 0,
istq4 <@doubletype/> default 0,
istvorjahr  <@doubletype/>
) <@informixnolog/>;

insert into tmp_konto (dr,titel,akts)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='S' 
and ${quartal_filter} 
group by 1,2;
insert into tmp_konto (dr,titel,reste)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='Z' --Reste 
and ${quartal_filter} 
group by 1,2;
insert into tmp_konto (dr,titel,haushaltsvorgriff)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='V' 
and ${quartal_filter} 
group by 1,2;



<#list 1..4 as quartal>
  --einnahmen
insert into tmp_konto (dr,titel,istq${quartal})
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and betragsart='Y'
and substring(titel from 1 for 1) in ('0','1','2','3')
and ${quartal_filter} and monat>=${quartal*3-2} and monat<=${quartal*3} 
group by 1,2;
 --ausgaben
insert into tmp_konto (dr,titel,istq${quartal})
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and betragsart='X'  and
substring(titel from 1 for 1) in ('4','5','6','7','8','9')
and ${quartal_filter} 
and monat>=${quartal*3-2} and monat<=${quartal*3}
group by 1,2;
</#list>


--vorjahr
insert into tmp_konto (dr,titel,istvorjahr)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> 
and jahr=<<Haushaltsjahr>>-1 and betragsart='Y' --Einnahmen
 and substring(titel from 1 for 1) in ('0','1','2','3')
 and ${quartal_filter} 
group by 1,2;
insert into tmp_konto (dr,titel,istvorjahr)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> 
and jahr=<<Haushaltsjahr>>-1 and betragsart='X' --ausgaben 
 and substring(titel from 1 for 1) in ('4','5','6','7','8','9')
 and ${quartal_filter} 
 group by 1,2;
 update tmp_konto set dr='einzeltitel' where dr='' or dr is null;
 
<#macro sumit sortea sort_einzeltit_dr sort_drtit typ feld dr>
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,typ,dr,titel,soll,haushaltsvorgriff,istq1,istq2,istq3,istq4,istvorjahr )
select ${sortea},${sort_einzeltit_dr},${sort_drtit},'${typ}',dr,${feld},sum(akts)-sum(reste),sum(haushaltsvorgriff),
sum(istq1),sum(istq2),sum(istq3),sum(istq4),sum(istvorjahr) from tmp_konto where
<#if sortea="0">
 substring(titel from 1 for 1) in ('0','1','2','3')  
<#else>
substring(titel from 1 for 1) in ('4','5','6','7','8','9')
</#if>
 and ${dr}
 group by 1,2,3,4,5,6;
</#macro>
<#macro sumit70er sortea sort_einzeltit_dr sort_drtit typ feld dr>
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,typ,dr,titel,soll,haushaltsvorgriff,istq1,istq2,istq3,istq4,istvorjahr )
select ${sortea},${sort_einzeltit_dr},${sort_drtit},'${typ}','70,72,73,74',${feld},sum(akts)-sum(reste),sum(haushaltsvorgriff),
sum(istq1),sum(istq2),sum(istq3),sum(istq4),sum(istvorjahr) from tmp_konto where
<#if sortea="0">
 substring(titel from 1 for 1) in ('0','1','2','3')  
<#else>
substring(titel from 1 for 1) in ('4','5','6','7','8','9')
</#if>
 and ${dr}
 group by 1,2,3,4,5,6;
</#macro>
 
--Einnahmen
insert into tmp_erg (sort_ea,sort_einzeltit_dr,name) values (0,-1,'Einnahmen');

  --Einzeltitel
<@sumit  sortea="0" sort_einzeltit_dr="0 as einzeltit" sort_drtit="0" typ='tit' feld="titel" dr="dr='einzeltitel'" />
 
--Aggregierung Einzeltitel
--insert into tmp_erg (sort_ea, sort_einzeltit_dr,drtitel,akts,reste,istq1,istq2,istq3,istq4,istvorjahr )
--select 0,1,'Summe Einzeltitel',sum(akts),sum(reste_gesamt),
--sum(istq1),sum(istq2),sum(istq3),sum(istq4),sum(istvorjahr) from tmp_konto where
-- substring(titel from 1 for 1) in ('0','1','2','3')  and dr=''
 --group by 1,2,3;
 
 --berschrift Titelgruppen
 --insert into tmp_erg (sort_ea,sort_einzeltit_dr,name) values (0,2,'Titelgruppen');
 
  --Deckungsringberschriften
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,typ,dr )
select distinct 0 as einnahmen,3 as dr,0 as drbez,'dr',dr from tmp_konto where substring(titel from 1 for 1)  in ('0','1','2','3')
  and dr!='einzeltitel' and dr not in ('70','72','73','74');;
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,typ,dr,name )
values (0,3,0 ,'dr','70,72,73,74','TG 70,72,73,74');


  -- Titel des DR
  <@sumit  sortea="0" sort_einzeltit_dr="3 as dreinzeltit" sort_drtit="1" typ='tit' feld="titel"  dr="dr!='einzeltitel'  and dr not in ('70','72','73','74')" />
  <@sumit70er  sortea="0" sort_einzeltit_dr="3 as dreinzeltit" sort_drtit="1" typ='tit' feld="titel"  dr="dr in ('70','72','73','74')" />
 
  --Summe des Dr
   <@sumit  sortea="0" sort_einzeltit_dr="3 as dreinzeltit" sort_drtit="2 as drsum" typ='drsum' feld="''" dr="dr!='einzeltitel'  and dr not in ('70','72','73','74')" />
 <@sumit70er  sortea="0" sort_einzeltit_dr="3 as dreinzeltit" sort_drtit="2 as drsum" typ='drsum' feld="''" dr="dr in ('70','72','73','74')" />
  --summe Einnahmen
  insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,name,soll,haushaltsvorgriff,istq1,istq2,istq3,istq4,istvorjahr )
select 0 as einnahmen,4 as dr,0 as nix,'Summe Einnahmen',sum(akts)-sum(reste),sum(haushaltsvorgriff),
sum(istq1),sum(istq2),sum(istq3),sum(istq4),sum(istvorjahr)  from tmp_konto where
      substring(titel from 1 for 1)  in ('0','1','2','3')  
   group by 1,2,3,4;
  
 --leerzeilen
insert into tmp_erg (sort_ea,sort_einzeltit_dr,sort_drtit,dr) values (0,1,5,'einzeltitel'); -- leerzeile 
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,dr)
select distinct 0 as einnahmen,3 as dr,5,dr from tmp_konto where substring(titel from 1 for 1)  in ('0','1','2','3')
  and dr!='einzeltitel' and dr not in ('70','72','73','74');
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,dr )
values (0,3 ,5 ,'70,72,73,74');   
   
   
   --Ausgaben
 insert into tmp_erg (sort_ea,sort_einzeltit_dr,name) values (1,-1,'Ausgaben');  
   
  --Einzeltitel
<@sumit  sortea="1" sort_einzeltit_dr="0 as einzeltit" sort_drtit="0" typ='tit' feld="titel" dr="dr='einzeltitel'" />
 
--Aggregierung Einzeltitel
--insert into tmp_erg (sort_ea, sort_einzeltit_dr,drtitel,soll,haushaltsvorgriff,istq1,istq2,istq3,istq4,istvorjahr )
--select 1,1,'Summe Einzeltitel',sum(akts)-sum(reste),sum(haushaltsvorgriff),
--sum(istq1),sum(istq2),sum(istq3),sum(istq4),sum(istvorjahr) from tmp_konto where
 --substring(titel from 1 for 1) in ('4','5','6','7','8','9')  and dr=''
 --group by 1,2,3;
 --berschrift Titelgruppen
 --insert into tmp_erg (sort_ea,sort_einzeltit_dr,drtitel) values (1,2,'Titelgruppen');
 
  --Deckungsringberschriften
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,typ,dr )
select distinct 1 as ausgaben,3 as dr,0 as drbez,'dr',dr from tmp_konto where 
substring(titel from 1 for 1) in ('4','5','6','7','8','9')
  and dr!='einzeltitel';

  -- Titel des DR
  <@sumit  sortea="1" sort_einzeltit_dr="3 as dreinzeltit" sort_drtit="1" typ='tit' feld="titel"  dr="dr!='einzeltitel'" />
 
  --Summe des Dr
   <@sumit  sortea="1" sort_einzeltit_dr="3 as dreinzeltit" sort_drtit="2 as drsum" typ='drsum' feld="''" dr="dr!='einzeltitel'" />
 
  --summe Ausgaben
  insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,name,soll,haushaltsvorgriff,istq1,istq2,istq3,istq4,istvorjahr )
select 1 as ausgaben,4 as dr,0 as nix,'Summe Ausgaben',sum(akts)-sum(reste),sum(haushaltsvorgriff),
sum(istq1),sum(istq2),sum(istq3),sum(istq4),sum(istvorjahr)  from tmp_konto where
     substring(titel from 1 for 1) in ('4','5','6','7','8','9')
   group by 1,2,3,4;
 
 --leerzeilen
insert into tmp_erg (sort_ea,sort_einzeltit_dr,sort_drtit,dr) values (1,0,5,'einzeltitel'); -- leerzeile
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,dr)
select distinct 1,3 as dr,5,dr from tmp_konto where substring(titel from 1 for 1)  in ('4','5','6','7','8','9')
  and dr!='einzeltitel';
  
  
update tmp_erg set einnahmen_ausgaben='einnahmen' where sort_ea=0;
update tmp_erg set einnahmen_ausgaben='ausgaben' where sort_ea=1;

    --erluerungen 
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_QE' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.titel=kenn_zahl_wert.titel ) where einnahmen_ausgaben='einnahmen' and typ='tit';
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_QE' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.dr=kenn_zahl_wert.titel) where einnahmen_ausgaben='einnahmen' and typ='drsum';
    update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_QE' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    kenn_zahl_wert.titel='70') where einnahmen_ausgaben='einnahmen' and typ='drsum' and dr='70,72,73,74';
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_QA' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.titel=kenn_zahl_wert.titel) where einnahmen_ausgaben='ausgaben' and typ='tit' ;
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_QA' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.dr=kenn_zahl_wert.titel) where einnahmen_ausgaben='ausgaben' and typ='drsum';
  
    
 
--SUmmenberechnung
update tmp_erg set gesamtsoll=nvl(soll,0)+nvl(haushaltsvorgriff,0);
update tmp_erg set gesamtist=istq1+istq2+istq3+istq4;


 --ggfs. manuelle manuelle Vorschau
 --Einnahmen titelbezogen
update tmp_erg set vorschau=(select wert from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='KAM_QVE' and
    tmp_erg.titel=kenn_zahl_wert.titel and kenn_zahl_wert.jahr=<<Haushaltsjahr>> ) where 
    einnahmen_ausgaben='einnahmen' and typ='tit';
 --Einnahmen DR-Summen
 update tmp_erg set vorschau=(select sum(wert) from kenn_zahl_wert W where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='KAM_QVE' and
    tmp_erg.dr=W.titel and W.jahr=<<Haushaltsjahr>>) where einnahmen_ausgaben='einnahmen' and  typ='drsum';
    update tmp_erg set vorschau=(select sum(wert) from kenn_zahl_wert W where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='KAM_QVE' and
    W.titel='70' and W.jahr=<<Haushaltsjahr>>) where einnahmen_ausgaben='einnahmen' and  typ='drsum' and dr='70,72,73,74' ;
-- Ausgaben titelbezogen
update tmp_erg set vorschau=(select wert from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='KAM_QVA' and
    tmp_erg.titel=kenn_zahl_wert.titel and kenn_zahl_wert.jahr=<<Haushaltsjahr>> ) where 
    einnahmen_ausgaben='ausgaben' and  typ='tit';
-- Ausgaben DR-Summen
update tmp_erg set vorschau=(select sum(wert) from kenn_zahl_wert W where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='KAM_QVA' and
    tmp_erg.dr=W.titel and W.jahr=<<Haushaltsjahr>>) where einnahmen_ausgaben='ausgaben' and  typ='drsum';
 
 
 --  update tmp_erg set vorschau=(select sum(wert) from kenn_zahl_wert W where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and 
 --  kenn_zahl in ('KAM_QVA','KAM_QVE') and titel in (${zeile.formel})) where
 --  einnahmen_ausgaben='${zeile.einnahmen_ausgaben}' and dr='${zeile.dr}' and name='${zeile.zw}';
 
 
 
    --falls schon WErte fr alle vier Quartale vorliegen, diesen als Vorschauwert nehmen
    -- https://wiki.his.de/mediawiki/index.php/FD_BIA_NHS-QB_kam_V2015#Berechnung_und_Terminologie
    <@selectintotmp source="tmp_erg" target="tmp_test" select="count(*) as anzahl_q4_gefuellt">
 where istq4 is not null and istq4!=0
 </@selectintotmp>;
 update tmp_erg set vorschau=gesamtist where (select anzahl_q4_gefuellt from tmp_test)>0;
 drop table tmp_test;
   
  ---nun Summenzeilen neu berechnen:
    create temp table tmp_sum(summe  <@doubletype/>);
    insert into tmp_sum   select sum(vorschau) from tmp_erg where typ='tit' and substring(titel from 1 for 1) in ('0','1','2','3');
update tmp_erg set vorschau=(select summe from tmp_sum) where name='Summe Einnahmen'  ;
truncate table tmp_sum;
insert into tmp_sum  select sum(vorschau) from tmp_erg where typ='tit' and substring(titel from 1 for 1) in ('4','5','6','7','8','9');
update tmp_erg set vorschau=(select summe from tmp_sum)  where name='Summe Ausgaben' ;
drop table tmp_sum;

update tmp_erg set gesamtsoll=null where gesamtsoll=0;
update tmp_erg set vorschau=null where vorschau=0;
--Abweichung zum Gesamtsoll: Beim Vergleich IST gegenber SOLL der Einnahmen ist durch das Vorzeichen zu verdeutlichen, 
--dass z. B. Mehreinnahmen mit plus und Mindereinahmen mit minus zu kennzeichnen sind. 
-- in ExcelVorlage ist feste Formel
--update tmp_erg set abweichung=vorschau-gesamtsoll  where einnahmen_ausgaben='einnahmen' and vorschau is not null and gesamtsoll is not null;
--
--Bei den Ausgaben stellt sich der Sachverhalt genau umgedreht dar, d. h., die Mehrausgaben sind mit minus und die Minderausgaben sind mit plus zu kennzeichnen. 
--update tmp_erg set abweichung=gesamtsoll-vorschau where einnahmen_ausgaben='ausgaben' and vorschau is not null and gesamtsoll is not null;
update tmp_erg set abweichung=gesamtsoll-vorschau where vorschau is not null and gesamtsoll is not null;





drop table tmp_konto;

--namen
update tmp_erg set name=(select substring(min(ktobez) from 7) from kenn_titel where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and tmp_erg.titel=kenn_titel.titel) where typ='tit';
update tmp_erg set name='',titel='TG '||dr||' '||(select substring(min(ktobez) from 4) from kenn_dr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and tmp_erg.dr=kenn_dr.dr) where typ='dr'
and dr!='70,72,73,74';
update tmp_erg set name='Summe der Titelgruppe' where typ='drsum' and dr!='70,72,73,74';
update tmp_erg set name='Summe der Titelgruppen' where typ='drsum' and dr='70,72,73,74';


update tmp_erg set istq1=null,istq2=null,istq3=null,istq4=null,gesamtist=null where 
(typ is null or (typ!='tit' and typ!='drsum')) and (name is null or name not in ('Summe Einnahmen','Summe Ausgaben'));
update tmp_erg set soll=null where soll=0;
update tmp_erg set haushaltsvorgriff=null where haushaltsvorgriff=0;

update tmp_erg set gesamtist=null where gesamtist=0;
update tmp_erg set gesamtsoll=null where gesamtsoll=0;
update tmp_erg set istvorjahr=null where istvorjahr=0;
update tmp_erg set abweichung=null where abweichung=0;


update tmp_erg set abweichung=null where (name is null or name='') or (gesamtist is null and gesamtsoll is null);

select einnahmen_ausgaben,dr,titel,name,soll,haushaltsvorgriff,gesamtsoll,
istq1,istq2,istq3,istq4,gesamtist,istvorjahr,vorschau,abweichung,erl from tmp_erg 
order by sort_ea,sort_einzeltit_dr,dr,sort_drtit,titel;
<#else>
--alte Version
<#assign einnahmetitel="'11949','12902','23131','23201','23501','23503','26101','28231','33201','35901','36001','36002','23152','33152','28253','34253','23270','23272','23273','23274'"/>
<#assign ausgabetitel="'42201','42206','42711','42801','42812','42821','42826','44301','51101','51701','51901','52501','52701','52901','53101','54649','68131','68501','68502','81101','81201','91901','42751','51151','52351','52751','54751','81251','42852','45952','54752','81252','42853','45953','54753','81253','45960','54760','81260','42970','54770','81270','42972','54772','81272','42973','54773','81273','42974','54774','81274'"/>
<#assign zeilen={"list":[
{"einnahmen_ausgaben":"einnahmen","dr":"","titel":"Einnahmen","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"11949","zw":"Vermischte Einnahmen","formel":"'11949'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"12902","zw":"Einnahmen aus dem Betrieb der Institute, Laboratorien usw.","formel":"'12902'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"23131","zw":"Zuweisungen des Bundes fr Stipendien fr besonders begabte Studenten","formel":"'23131'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"23201","zw":"Zuweisungen des Freistaates Sachsen zum laufenden Betrieb","formel":"'23201'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"23501","zw":"Erstattungen im Rahmen des Altersteilzeitgesetzes","formel":"'23501'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"23503","zw":"Zuweisungen der Bundesagentur fr Arbeit ","formel":"'23503'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"26101","zw":"Programmpauschalen","formel":"'26101'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"28231","zw":"Zuweisungen von Dritten fr Stipendien fr besonders begabte Studenten","formel":"'28231'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"33201","zw":"Zuweisungen des Freistaates Sachsen fr Investitionen","formel":"'33201'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"35901","zw":"Entnahme aus der  Rcklage","formel":"'35901'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"36001","zw":"berschuss des Vorjahres aus Landesmitteln","formel":"'36001'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"36002","zw":"berschuss des Vorjahres aus Drittmitteln","formel":"'36002'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"52","titel":"TG 52 Frderung der Forschung und Lehre aus Zuweisungen des Bundes und der DFG ","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"52","titel":"23152","zw":"Zuweisungen fr laufende Zwecke","formel":"'23152'"},
{"einnahmen_ausgaben":"einnahmen","dr":"52","titel":"33152","zw":"Zuweisungen fr Investitionen","formel":"'33152'"},
{"einnahmen_ausgaben":"einnahmen","dr":"52","titel":"","zw":"Summe der Titelgruppe","formel":"'23152','33152'"},
{"einnahmen_ausgaben":"einnahmen","dr":"52","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"53","titel":"TG 53 Zuschsse von Sonstigen einschlielich Spenden","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"53","titel":"28253","zw":"Zuschsse fr laufende Zwecke","formel":"'28253'"},
{"einnahmen_ausgaben":"einnahmen","dr":"53","titel":"34253","zw":"Zuschsse fr Investitionen","formel":"'34253'"},
{"einnahmen_ausgaben":"einnahmen","dr":"53","titel":"","zw":"Summe der Titelgruppe","formel":"'28253','34253'"},
{"einnahmen_ausgaben":"einnahmen","dr":"53","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"TG 70, 72, 73, 74","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"23270","zw":"Zuweisungen fr Projekte ","formel":"'23270'"},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"23272","zw":"Zuweisungen Hochschulpakt 2020","formel":"'23272'"},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"23273","zw":"Zuweisungen fr Manahmen aus Mitteln des EU-Regionalfonds (EFRE)","formel":"'23273'"},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"23274","zw":"Zuweisungen fr Manahmen aus Mitteln des Europischen Sozialfonds (ESF)","formel":"'23274'"},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"","zw":"Summe der Titelgruppen","formel":"'23270','23272','23273','23274'"},
{"einnahmen_ausgaben":"einnahmen","dr":"-","titel":"","zw":"Gesamteinnahmen","formel":"'11949','12902','23131','23201','23501','23503','26101','28231','33201','35901','36001','36002','23152','33152','28253','34253','23270','23272','23273','23274'"},
{"einnahmen_ausgaben":"ausgaben","dr":"","titel":"Ausgaben","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42201","zw":"Bezge der planmigen Beamten und Richter (einschl. Abordnungen)","formel":"'42201'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42206","zw":"Leistungsbezahlung Beamte","formel":"'42206'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42711","zw":"Entgelte fr Leistungen sonstiger Beschftigter","formel":"'42711'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42801","zw":"Entgelte fr Arbeitnehmerinnen und Arbeitnehmer","formel":"'42801'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42812","zw":"Aufwendungen fr Beschftigte in Arbeitsbeschaffungsmanahmen","formel":"'42812'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42821","zw":"Entgelte fr Auszubildende in tariflichen Ausbildungsverhltnissen","formel":"'42821'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42826","zw":"Sonstige nicht stellenplangebundene Personalausgaben","formel":"'42826'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"44301","zw":"Untersttzungen auf Grund der Untersttzungsgrundstze, Frsorgemanahmen sowie Kosten nach dem Arbeitssicherheitsgesetz","formel":"'44301'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"45301","zw":"Trennungsgeld und Umzugskostenvergtungen","formel":"'45301'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"51101","zw":"Geschftsbedarf, Gerte und Ausstattungsgegenstnde, Brief- und Paketgebhren, Fernmeldegebhren","formel":"'51101'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"51701","zw":"Bewirtschaftung der Grundstcke, Gebude und Rume","formel":"'51701'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"51901","zw":"Unterhaltung der Grundstcke und baulichen Anlagen","formel":"'51901'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"52501","zw":"Aus- und Fortbildung, Umschulung","formel":"'52501'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"52701","zw":"Reisekostenvergtungen","formel":"'52701'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"52901","zw":"Zur Verfgung des Rektors fr auergewhnlichen Aufwand aus dienstlicher Veranlassung in besonderen Fllen","formel":"'52901'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"53101","zw":"Kosten fr Verffentlichungen, Dokumentation und ffentlichkeitsarbeit","formel":"'53101'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"54649","zw":"Vermischte Verwaltungsausgaben","formel":"'54649'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"68131","zw":"Stipendien fr besonders begabte Studenten","formel":"'68131'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"68501","zw":"Mitgliedsbeitrge","formel":"'68501'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"68502","zw":"Zuwendungen an Dritte","formel":"'68502'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"81101","zw":"Erwerb von Dienstfahrzeugen","formel":"'81101'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"81201","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81201'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"91901","zw":"Zufhrungen zur Rcklage","formel":"'91901'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"TG 51 Lehre und Forschung","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"42751","zw":"Beschftigungsentgelte","formel":"'42751'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"51151","zw":"Geschftsbedarf, Gerte und Ausstattungen","formel":"'51151'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"52351","zw":"Wissenschaftliche Literatur","formel":"'52351'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"52751","zw":"Reisekostenvergtungen","formel":"'52751'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"54751","zw":"Sonstige schliche Ausgaben","formel":"'54751'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"81251","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81251'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"","zw":"Summe der Titelgruppe","formel":"'42751','51151','52351','52751','54751','81251'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"TG 52 Frderung der Forschung und Lehre aus Zuweisungen des Bundes und der DFG ","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"42852","zw":"Drittmittelfinanzierte Personalausgaben","formel":"'42852'"},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"45952","zw":"Vermischte Personalausgaben","formel":"'45952'"},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"54752","zw":"Schliche Ausgaben","formel":"'54752'"},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"81252","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81252'"},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"","zw":"Summe der Titelgruppe","formel":"'42852','45952','54752','81252'"},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"TG 53 Zuschsse von Sonstigen einschlielich Spenden","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"42853","zw":"Drittmittelfinanzierte Personalausgaben","formel":"'42853'"},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"45953","zw":"Vermischte Personalausgaben","formel":"'45953'"},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"54753","zw":"Schliche  Ausgaben","formel":"'54753'"},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"81253","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81253'"},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"","zw":"Summe der Titelgruppe","formel":"'42853','45953','54753','81253'"},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"TG 60 Institute, Laboratorien usw.","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"45960","zw":"Vermischte Personalausgaben","formel":"'45960'"},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"54760","zw":"Schliche Ausgaben","formel":"'54760'"},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"81260","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81260'"},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"","zw":"Summe der Titelgruppe","formel":"'45960','54760','81260'"},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"TG 70 Landesprojekte","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"42970","zw":"Personalausgaben","formel":"'42970'"},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"54770","zw":"Schliche Ausgaben","formel":"'54770'"},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"81270","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81270'"},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"","zw":"Summe der Titelgruppe","formel":"'42970','54770','81270'"},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"TG 72 Hochschulpakt 2020","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"42972","zw":"Personalausgaben","formel":"'42972'"},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"54772","zw":"Schliche Ausgaben","formel":"'54772'"},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"81272","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81272'"},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"","zw":"Summe der Titelgruppe","formel":"'42972','54772','81272'"},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"TG 73 Manahmen aus Mitteln des EU-Regional-fonds (EFRE)","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"42973","zw":"Personalausgaben","formel":"'42973'"},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"54773","zw":"Schliche Ausgaben","formel":"'54773'"},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"81273","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81273'"},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"","zw":"Summe der Titelgruppe","formel":"'42973','54773','81273'"},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"74","titel":"TG 74 Manahmen aus Mitteln des Europischen Sozialfonds (ESF)","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"74","titel":"42974","zw":"Personalausgaben","formel":"'42974'"},
{"einnahmen_ausgaben":"ausgaben","dr":"74","titel":"54774","zw":"Schliche Ausgaben","formel":"'54774'"},
{"einnahmen_ausgaben":"ausgaben","dr":"74","titel":"81274","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81274'"},
{"einnahmen_ausgaben":"ausgaben","dr":"74","titel":"","zw":"Summe der Titelgruppe","formel":"'42974','54774','81274'"},
{"einnahmen_ausgaben":"ausgaben","dr":"-","titel":"","zw":"Gesamtausgaben","formel":"'42201','42206','42711','42801','42812','42821','42826','44301','45301','51101','51701','51901','52501','52701','52901','53101','54649','68131','68501','68502','81101','81201','91901','42751','51151','52351','52751','54751','81251','42852','45952','54752','81252','42853','45953','54753','81253','45960','54760','81260','42970','54770','81270','42972','54772','81272','42973','54773','81273','42974','54774','81274'"}
]}/>




<#assign quartal_filter=4 />
/* <#assign quartal_filter= <<Auswertung bis Quartal>> /> */ 
<#assign quartal_filter="val(substring('' || quartal from 5 for 1)) <= "+quartal_filter />
--Aus dem Vorjahr bertragene Einnahme-reste  Gesamt-Soll 2011  Ist I. Quartal (31.03.2011)  Ist II. Quartal (30.06.2011)
--Ist III.Quartal (30.09.2011)  Ist IV. Quartal (31.12.2011)  Gesamt-Ist 2011 (kumulierte Quartale) 
--IST Vorjahr kumulierte Quartale)  Vorschau 2011 bis Jahresende  Abweichung zum Gesamt-Sol
create temp table tmp_erg(
einnahmen_ausgaben char(10),
dr char(5),
titel varchar(255),
zw varchar(255),
sortnr integer,
soll <@doubletype/>, --Aktuelles Soll statt W Haushaltansatz 19.2.2012 - da Reste extra dargestellt werden in zwei Titel (36001,36002) entspricht das in MBS akts-reste 
haushaltsvorgriff <@doubletype/>,
gesamtsoll  <@doubletype/>,
istq1  <@doubletype/> default 0,
istq2 <@doubletype/> default 0,
istq3  <@doubletype/> default 0,
istq4 <@doubletype/> default 0,
gesamtist <@doubletype/>,
istvorjahr  <@doubletype/>,
vorschau <@doubletype/>,
abweichung  <@doubletype/>,
erl varchar(255)
)<@informixnolog/>
;

create temp table tmp_konto (dr char(5),dr2 char(5),titel char(10),
akts <@doubletype/> default 0,
reste <@doubletype/> default 0,
haushaltsvorgriff <@doubletype/> default 0,
istq1  <@doubletype/> default 0,
istq2 <@doubletype/> default 0,
istq3  <@doubletype/> default 0,
istq4 <@doubletype/> default 0,
istvorjahr  <@doubletype/>
) <@informixnolog/>;

insert into tmp_konto (dr,titel,akts)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='S' 
and ${quartal_filter} 
group by 1,2;
insert into tmp_konto (dr,titel,reste)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='Z' --Reste 
and ${quartal_filter} 
group by 1,2;
insert into tmp_konto (dr,titel,haushaltsvorgriff)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='V' 
and ${quartal_filter} 
group by 1,2;



<#list 1..4 as quartal>
  --einnahmen
insert into tmp_konto (dr,titel,istq${quartal})
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and betragsart='Y'
and substring(titel from 1 for 1) in ('0','1','2','3')
and ${quartal_filter} and monat>=${quartal*3-2} and monat<=${quartal*3} 
group by 1,2;
 --ausgaben
insert into tmp_konto (dr,titel,istq${quartal})
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and betragsart='X'  and
substring(titel from 1 for 1) in ('4','5','6','7','8','9')
and ${quartal_filter} 
and monat>=${quartal*3-2} and monat<=${quartal*3}
group by 1,2;
</#list>


--vorjahr
insert into tmp_konto (dr,titel,istvorjahr)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> 
and jahr=<<Haushaltsjahr>>-1 and betragsart='Y' --Einnahmen
 and substring(titel from 1 for 1) in ('0','1','2','3')
 and ${quartal_filter} 
group by 1,2;
insert into tmp_konto (dr,titel,istvorjahr)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> 
and jahr=<<Haushaltsjahr>>-1 and betragsart='X' --ausgaben 
 and substring(titel from 1 for 1) in ('4','5','6','7','8','9')
 and ${quartal_filter} 
 group by 1,2;
<#assign sortnr=0/>
 <#foreach zeile in zeilen.list>
 <#assign sortnr=sortnr+1/>
 <#if zeile.formel="">
 insert into tmp_erg (einnahmen_ausgaben,titel,dr,zw,sortnr )
 values ('${zeile.einnahmen_ausgaben}','${zeile.titel}','${zeile.dr}','${zeile.zw}',${sortnr});
 <#else>
insert into tmp_erg (einnahmen_ausgaben,dr,titel,zw,sortnr,soll,haushaltsvorgriff,istq1,istq2,istq3,istq4,istvorjahr )
select '${zeile.einnahmen_ausgaben}','${zeile.dr}','${zeile.titel}','${zeile.zw}',${sortnr},sum(akts)-sum(reste),sum(haushaltsvorgriff),
sum(istq1),sum(istq2),sum(istq3),sum(istq4),sum(istvorjahr)  
from xdummy left outer join tmp_konto on (
titel in (${zeile.formel}) )
group by 1,2,3,4,5;
 
 </#if>
</#foreach>
 
    
    --erluerungen 
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_QE' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.titel=kenn_zahl_wert.titel ) where einnahmen_ausgaben='einnahmen' and zw not like 'Summe der Titelgruppe%';
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_QE' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.dr=kenn_zahl_wert.titel) where einnahmen_ausgaben='einnahmen' and zw like 'Summe der Titelgruppe%';
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_QA' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.titel=kenn_zahl_wert.titel) where einnahmen_ausgaben='ausgaben' and zw not like 'Summe der Titelgruppe%' ;
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_QA' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.dr=kenn_zahl_wert.titel) where einnahmen_ausgaben='ausgaben' and zw like 'Summe der Titelgruppe%';
  
    
 
--SUmmenberechnung
update tmp_erg set gesamtsoll=nvl(soll,0)+nvl(haushaltsvorgriff,0);
update tmp_erg set gesamtist=istq1+istq2+istq3+istq4;





 --ggfs. manuelle manuelle Vorschau
 --Einnahmen titelbezogen
update tmp_erg set vorschau=(select wert from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='KAM_QVE' and
    tmp_erg.titel=kenn_zahl_wert.titel and kenn_zahl_wert.jahr=<<Haushaltsjahr>> ) where 
    einnahmen_ausgaben='einnahmen' and zw not like 'Summe der Titelgruppe%';
 --Einnahmen DR-Summen
 update tmp_erg set vorschau=(select sum(wert) from kenn_zahl_wert W where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='KAM_QVE' and
    tmp_erg.dr=W.titel and W.jahr=<<Haushaltsjahr>>) where einnahmen_ausgaben='einnahmen' and zw  like 'Summe der Titelgruppe%';
-- Ausgaben titelbezogen
update tmp_erg set vorschau=(select wert from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='KAM_QVA' and
    tmp_erg.titel=kenn_zahl_wert.titel and kenn_zahl_wert.jahr=<<Haushaltsjahr>> ) where 
    einnahmen_ausgaben='ausgaben' and zw not like 'Summe der Titelgruppe%';
-- Ausgaben DR-Summen
update tmp_erg set vorschau=(select sum(wert) from kenn_zahl_wert W where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='KAM_QVA' and
    tmp_erg.dr=W.titel and W.jahr=<<Haushaltsjahr>>) where einnahmen_ausgaben='ausgaben' and zw  like 'Summe der Titelgruppe%';
 <#foreach zeile in zeilen.list>
 <#if zeile.zw?index_of("Summe der Titelgruppe")&gt;-1>
   update tmp_erg set vorschau=(select sum(wert) from kenn_zahl_wert W where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and 
   kenn_zahl in ('KAM_QVA','KAM_QVE') and titel in (${zeile.formel})) where
   einnahmen_ausgaben='${zeile.einnahmen_ausgaben}' and dr='${zeile.dr}' and zw='${zeile.zw}';
 </#if>
 
 </#foreach>
    --falls schon WErte fr alle vier Quartale vorliegen, diesen als Vorschauwert nehmen
    -- https://wiki.his.de/mediawiki/index.php/FD_BIA_NHS-QB_kam_V2015#Berechnung_und_Terminologie
    update tmp_erg set istq1=null where istq1=0;
update tmp_erg set istq2=null where istq2=0;
update tmp_erg set istq3=null where istq3=0;
update tmp_erg set istq4=null where istq4=0;
    update tmp_erg set vorschau=gesamtist where istq1 is not NULL and istq2 is not NULL and istq3 is not NULL and istq4 is not NULL;
  ---nun Summenzeilen neu berechnen:
    create temp table tmp_sum(summe  <@doubletype/>);
    insert into tmp_sum   select sum(vorschau) from tmp_erg where substring(titel from 1 for 1) in ('0','1','2','3');
update tmp_erg set vorschau=(select summe from tmp_sum) where zw='Gesamteinnahmen'  ;
truncate table tmp_sum;
insert into tmp_sum  select sum(vorschau) from tmp_erg where substring(titel from 1 for 1) in ('4','5','6','7','8','9');
update tmp_erg set vorschau=(select summe from tmp_sum)  where zw='Gesamtausgaben' ;
drop table tmp_sum;

update tmp_erg set gesamtsoll=null where gesamtsoll=0;
update tmp_erg set vorschau=null where vorschau=0;
--Abweichung zum Gesamtsoll: Beim Vergleich IST gegenber SOLL der Einnahmen ist durch das Vorzeichen zu verdeutlichen, 
--dass z. B. Mehreinnahmen mit plus und Mindereinahmen mit minus zu kennzeichnen sind. 
-- in ExcelVorlage ist feste Formel
--update tmp_erg set abweichung=vorschau-gesamtsoll  where einnahmen_ausgaben='einnahmen' and vorschau is not null and gesamtsoll is not null;
--
--Bei den Ausgaben stellt sich der Sachverhalt genau umgedreht dar, d. h., die Mehrausgaben sind mit minus und die Minderausgaben sind mit plus zu kennzeichnen. 
--update tmp_erg set abweichung=gesamtsoll-vorschau where einnahmen_ausgaben='ausgaben' and vorschau is not null and gesamtsoll is not null;
update tmp_erg set abweichung=gesamtsoll-vorschau where vorschau is not null and gesamtsoll is not null;





drop table tmp_konto;

 
update tmp_erg set istq1=null,istq2=null,istq3=null,istq4=null,gesamtist=null where zw is null or zw='';
update tmp_erg set soll=null where soll=0;
update tmp_erg set haushaltsvorgriff=null where haushaltsvorgriff=0;

update tmp_erg set gesamtist=null where gesamtist=0;
update tmp_erg set gesamtsoll=null where gesamtsoll=0;
update tmp_erg set istvorjahr=null where istvorjahr=0;
update tmp_erg set abweichung=null where abweichung=0;


select einnahmen_ausgaben,dr,titel,zw,soll,haushaltsvorgriff,gesamtsoll,
istq1,istq2,istq3,istq4,gesamtist,istvorjahr,vorschau,abweichung,erl from tmp_erg 
order by sortnr;
</#if>
